/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.messages;

import com.ibm.msg.client.commonservices.collections.CSHashtable;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;

abstract class TransientMessageProps
implements JmsPropertyContext {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected CSHashtable properties = new CSHashtable(15);

    TransientMessageProps() {
    }

    public void setBatchProperties(Map batchedProperties) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setBatchProperties(Map)", new Object[]{batchedProperties});
        }
        Iterator keys = batchedProperties.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            this.setObjectProperty((String)key, batchedProperties.get(key));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setBatchProperties(Map)");
        }
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setBooleanProperty(String,boolean)", "setter", name);
        }
        this.properties.put(name, new Boolean(value));
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setByteProperty(String,byte)", "setter", name);
        }
        this.properties.put(name, new Byte(value));
    }

    public void setBytesProperty(String name, byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setBytesProperty(String,byte [ ])", new Object[]{name, value});
        }
        HashMap<String, Object> inserts = new HashMap<String, Object>();
        inserts.put("XMSC_INSERT_PROPERTY", name);
        inserts.put("XMSC_INSERT_VALUE", value);
        inserts.put("XMSC_INSERT_TYPE", new byte[0].getClass());
        JMSException ex = (JMSException)((Object)NLSServices.createException("JMSWMQ0006", inserts));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setBytesProperty(String,byte [ ])", ex);
        }
        throw ex;
    }

    public void setCharProperty(String name, char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setCharProperty(String,char)", new Object[]{name, new Character(value)});
        }
        HashMap<String, Object> inserts = new HashMap<String, Object>();
        inserts.put("XMSC_INSERT_PROPERTY", name);
        inserts.put("XMSC_INSERT_VALUE", new Character(value));
        inserts.put("XMSC_INSERT_TYPE", Character.class);
        JMSException ex = (JMSException)((Object)NLSServices.createException("JMSWMQ0006", inserts));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setCharProperty(String,char)", ex);
        }
        throw ex;
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setDoubleProperty(String,double)", "setter", name);
        }
        this.properties.put(name, new Double(value));
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setFloatProperty(String,float)", "setter", name);
        }
        this.properties.put(name, new Float(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setIntProperty(String,int)", "setter", name);
        }
        this.properties.put(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setLongProperty(String,long)", "setter", name);
        }
        this.properties.put(name, new Long(value));
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setObjectProperty(String,Object)", "setter", name);
        }
        this.properties.put(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setShortProperty(String,short)", "setter", name);
        }
        this.properties.put(name, new Short(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "setStringProperty(String,String)", "setter", name);
        }
        this.properties.put(name, value);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        boolean result = TransientMessageProps.parseBoolean(value, name, JMSException.class);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getBooleanProperty(String)", "getter", result);
        }
        return result;
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        byte result = TransientMessageProps.parseByte(value, name, JMSException.class);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getByteProperty(String)", "getter", new Byte(result));
        }
        return result;
    }

    public byte[] getBytesProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getBytesProperty(String)", new Object[]{name});
        }
        HashMap<String, Object> inserts = new HashMap<String, Object>();
        inserts.put("XMSC_INSERT_PROPERTY", name);
        inserts.put("XMSC_INSERT_TYPE", new byte[0].getClass());
        JMSException ex = (JMSException)((Object)NLSServices.createException("JMSWMQ0006", inserts));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getBytesProperty(String)", ex);
        }
        throw ex;
    }

    public char getCharProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getCharProperty(String)", new Object[]{name});
        }
        HashMap<String, Object> inserts = new HashMap<String, Object>();
        inserts.put("XMSC_INSERT_PROPERTY", name);
        inserts.put("XMSC_INSERT_TYPE", Character.class);
        JMSException ex = (JMSException)((Object)NLSServices.createException("JMSWMQ0006", inserts));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getCharProperty(String)", ex);
        }
        throw ex;
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        double result = TransientMessageProps.parseDouble(value, name, JMSException.class);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getDoubleProperty(String)", "getter", new Double(result));
        }
        return result;
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        float result = TransientMessageProps.parseFloat(value, name, JMSException.class);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getFloatProperty(String)", "getter", new Float(result));
        }
        return result;
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        int result = TransientMessageProps.parseInt(value, name, JMSException.class);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getIntProperty(String)", "getter", new Integer(result));
        }
        return result;
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        long result = TransientMessageProps.parseLong(value, name, JMSException.class);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getLongProperty(String)", "getter", new Long(result));
        }
        return result;
    }

    public Object getObjectProperty(String name) throws JMSException {
        Object result = this.properties.get(name);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getObjectProperty(String)", "getter", result);
        }
        return result;
    }

    public Enumeration getPropertyNames() throws JMSException {
        Enumeration traceRet1 = this.properties.keys();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getPropertyNames()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        short result = TransientMessageProps.parseShort(value, name, JMSException.class);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getShortProperty(String)", "getter", new Short(result));
        }
        return result;
    }

    public String getStringProperty(String name) throws JMSException {
        Object obj = this.getObjectProperty(name);
        String value = null;
        value = obj instanceof String || obj == null ? (String)obj : obj.toString();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "getStringProperty(String)", "getter", value);
        }
        return value;
    }

    public boolean propertyExists(String name) throws JMSException {
        boolean result = this.properties.containsKey(name);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "propertyExists(String)", "getter", result);
        }
        return result;
    }

    static void throwBadConvertException(Object obj, String propName, String dType, Class exceptionClass) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.messages.TransientMessageProps", "throwBadConvertException(Object,String,String,Class)", new Object[]{obj, propName, dType, exceptionClass});
        }
        String clsName = null;
        if (!(obj instanceof byte[])) {
            clsName = obj.getClass().getName();
            int index = 0;
            index = clsName.lastIndexOf(46);
            if (index != 0) {
                clsName = clsName.substring(index + 1);
            }
        } else {
            clsName = "Byte[]";
        }
        String msgId = "JMSWMQ1055";
        if (JMSException.class == exceptionClass) {
            msgId = "JMSWMQ1055";
        } else if (MessageFormatException.class == exceptionClass) {
            msgId = "JMSWMQ0006";
        } else {
            HashMap<String, Class> info = new HashMap<String, Class>();
            info.put("class", exceptionClass);
            Trace.ffst("WMQMessageProps", "throwBadConvertException", "XN00J001", info, JMSException.class);
        }
        HashMap<String, String> inserts = new HashMap<String, String>();
        inserts.put("XMSC_INSERT_PROPERTY", propName);
        inserts.put("XMSC_INSERT_TYPE", clsName);
        inserts.put("XMSC_INSERT_OTHER_TYPE", dType);
        JMSException ex = (JMSException)((Object)NLSServices.createException(msgId, inserts));
        if (Trace.isOn) {
            Trace.throwing("com.ibm.msg.client.wmq.messages.TransientMessageProps", "throwBadConvertException(Object,String,String,Class)", ex);
        }
        throw ex;
    }

    protected static boolean parseBoolean(Object obj, String name, Class exceptionClass) throws JMSException {
        boolean value = false;
        if (obj instanceof Boolean) {
            value = (Boolean)obj;
        } else if (obj instanceof String) {
            value = Boolean.valueOf((String)obj);
        } else if (obj == null) {
            value = Boolean.valueOf(null);
        } else {
            TransientMessageProps.throwBadConvertException(obj, name, "Boolean", exceptionClass);
        }
        return value;
    }

    protected static byte parseByte(Object obj, String name, Class exceptionClass) throws JMSException {
        byte value = 0;
        if (obj instanceof Byte) {
            value = (Byte)obj;
        } else if (obj instanceof String) {
            value = Byte.parseByte((String)obj);
        } else if (obj == null) {
            value = Byte.valueOf(null);
        } else {
            TransientMessageProps.throwBadConvertException(obj, name, "Byte", exceptionClass);
        }
        return value;
    }

    protected static double parseDouble(Object obj, String name, Class exceptionClass) throws JMSException {
        double value = 0.0;
        if (obj instanceof Double) {
            value = (Double)obj;
        } else if (obj instanceof String) {
            value = Double.parseDouble((String)obj);
        } else if (obj instanceof Float) {
            value = ((Float)obj).doubleValue();
        } else if (obj == null) {
            value = Double.valueOf(null);
        } else {
            TransientMessageProps.throwBadConvertException(obj, name, "Double", exceptionClass);
        }
        return value;
    }

    protected static float parseFloat(Object obj, String name, Class exceptionClass) throws JMSException {
        float value = 0.0f;
        if (obj instanceof Float) {
            value = ((Float)obj).floatValue();
        } else if (obj instanceof String) {
            value = Float.parseFloat((String)obj);
        } else if (obj == null) {
            value = Float.valueOf(null).floatValue();
        } else {
            TransientMessageProps.throwBadConvertException(obj, name, "Float", exceptionClass);
        }
        return value;
    }

    protected static int parseInt(Object obj, String name, Class exceptionClass) throws JMSException {
        int value = 0;
        if (obj instanceof Integer) {
            value = (Integer)obj;
        } else if (obj instanceof String) {
            value = Integer.parseInt((String)obj);
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).intValue();
        } else if (obj instanceof Short) {
            value = ((Short)obj).intValue();
        } else if (obj == null) {
            value = Integer.valueOf(null);
        } else {
            TransientMessageProps.throwBadConvertException(obj, name, "Integer", exceptionClass);
        }
        return value;
    }

    protected static long parseLong(Object obj, String name, Class exceptionClass) throws JMSException {
        long value = 0L;
        if (obj instanceof Long) {
            value = (Long)obj;
        } else if (obj instanceof String) {
            value = Long.parseLong((String)obj);
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).longValue();
        } else if (obj instanceof Short) {
            value = ((Short)obj).longValue();
        } else if (obj instanceof Integer) {
            value = ((Integer)obj).longValue();
        } else if (obj == null) {
            value = Long.valueOf(null);
        } else {
            TransientMessageProps.throwBadConvertException(obj, name, "Long", exceptionClass);
        }
        return value;
    }

    protected static short parseShort(Object obj, String name, Class exceptionClass) throws JMSException {
        short value = 0;
        if (obj instanceof Short) {
            value = (Short)obj;
        } else if (obj instanceof String) {
            value = Short.parseShort((String)obj);
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).shortValue();
        } else if (obj == null) {
            value = Short.valueOf(null);
        } else {
            TransientMessageProps.throwBadConvertException(obj, name, "Short", exceptionClass);
        }
        return value;
    }

    public void clearProperties() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "clearProperties()");
        }
        this.properties.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "clearProperties()");
        }
    }

    public void removeProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "removeProperty(String)", new Object[]{name});
        }
        this.properties.remove(name);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "removeProperty(String)");
        }
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "clear()");
        }
        this.properties.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "clear()");
        }
    }

    public boolean containsKey(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "containsKey(Object)", new Object[]{key});
        }
        boolean traceRet1 = this.properties.containsKey(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "containsKey(Object)", traceRet1);
        }
        return traceRet1;
    }

    public boolean containsValue(Object value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "containsValue(Object)", new Object[]{value});
        }
        boolean traceRet1 = this.properties.containsValue(value);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "containsValue(Object)", traceRet1);
        }
        return traceRet1;
    }

    public Set entrySet() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "entrySet()");
        }
        Set traceRet1 = this.properties.entrySet();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "entrySet()", traceRet1);
        }
        return traceRet1;
    }

    public Object get(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "get(Object)", new Object[]{key});
        }
        Object traceRet1 = this.properties.get(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "get(Object)", traceRet1);
        }
        return traceRet1;
    }

    public boolean isEmpty() {
        boolean traceRet1 = this.properties.isEmpty();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "isEmpty()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Set keySet() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "keySet()");
        }
        Set traceRet1 = this.properties.keySet();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "keySet()", traceRet1);
        }
        return traceRet1;
    }

    public Object put(Object arg0, Object arg1) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "put(Object,Object)", new Object[]{arg0, arg1});
        }
        Object traceRet1 = this.properties.put(arg0, arg1);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "put(Object,Object)", traceRet1);
        }
        return traceRet1;
    }

    public void putAll(Map arg0) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "putAll(Map)", new Object[]{arg0});
        }
        this.properties.putAll(arg0);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "putAll(Map)");
        }
    }

    public Object remove(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "remove(Object)", new Object[]{key});
        }
        Object traceRet1 = this.properties.remove(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "remove(Object)", traceRet1);
        }
        return traceRet1;
    }

    public int size() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "size()");
        }
        int traceRet1 = this.properties.size();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "size()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Collection values() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "values()");
        }
        Collection traceRet1 = this.properties.values();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageProps", "values()", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.messages.TransientMessageProps", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/messages/TransientMessageProps.java, jmscc.wmq, k701, k701-112-140304  1.9.1.1 09/08/17 08:55:37");
        }
    }
}

