/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.messages;

import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.messages.TransientMessageProps;
import java.util.Arrays;
import java.util.HashMap;
import javax.jms.JMSException;

public class TransientMessageHeader
extends TransientMessageProps {
    private static final long serialVersionUID = 2045246072882327995L;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/messages/TransientMessageHeader.java, jmscc.wmq, k701, k701-112-140304 1.16.1.1 09/08/17 08:56:31";
    private static final int DEFAULT_DELIVERY_MODE = 2;
    private static final long DEFAULT_EXPIRATION = 0L;
    private static final int DEFAULT_PRIORITY = 4;
    private static final boolean DEFAULT_REDELIVERED = false;
    private static final long DEFAULT_TIMESTAMP = 0L;
    private static final byte[] DEFAULT_CORRELID_BYTES;
    private int jmsDeliveryMode = 2;
    private int jmsPriority = 4;
    private long jmsExpiration = 0L;
    private long jmsTimestamp = 0L;
    private boolean jmsRedelivered = false;
    private String jmsMessageID = null;
    private String jmsDestinationAsString = null;
    private String jmsReplyToAsString = null;
    private String jmsType = null;
    private String jmsCorrelationID = null;
    private byte[] jmsCorrelationIDAsBytes = null;
    protected String messageClass = "jms_none";
    protected String jmsType_Domain = null;
    protected String jmsType_Format = null;
    protected String jmsType_Set = null;
    protected String jmsType_Type = null;
    protected boolean hideDeliveryMode = false;

    public String getJMSCorrelationID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSCorrelationID()");
        }
        if (this.jmsCorrelationID == null && this.jmsCorrelationIDAsBytes != null && !Arrays.equals(this.jmsCorrelationIDAsBytes, DEFAULT_CORRELID_BYTES)) {
            this.jmsCorrelationID = WMQUtils.idToString(this.jmsCorrelationIDAsBytes);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSCorrelationID()", this.jmsCorrelationID);
        }
        return this.jmsCorrelationID;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSCorrelationIDAsBytes()");
        }
        if (this.jmsCorrelationIDAsBytes == null && this.jmsCorrelationID != null) {
            this.jmsCorrelationIDAsBytes = WMQUtils.computeBytesFromText(this.jmsCorrelationID, "UTF-8");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSCorrelationIDAsBytes()", this.jmsCorrelationIDAsBytes);
        }
        return this.jmsCorrelationIDAsBytes;
    }

    public Integer getJMSDeliveryMode() throws JMSException {
        Integer dm = new Integer(this.jmsDeliveryMode);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSDeliveryMode()", "getter", dm);
        }
        return dm;
    }

    public String getJMSDestinationAsString() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSDestinationAsString()", "getter", this.jmsDestinationAsString);
        }
        return this.jmsDestinationAsString;
    }

    public Long getJMSExpiration() throws JMSException {
        Long exp = new Long(this.jmsExpiration);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSExpiration()", "getter", exp);
        }
        return exp;
    }

    public String getJMSMessageID() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSMessageID()", "getter", this.jmsMessageID);
        }
        return this.jmsMessageID;
    }

    public Integer getJMSPriority() throws JMSException {
        Integer pri = new Integer(this.jmsPriority);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSPriority()", "getter", pri);
        }
        return pri;
    }

    public Boolean getJMSRedelivered() throws JMSException {
        Boolean redelivered = new Boolean(this.jmsRedelivered);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSRedelivered()", "getter", redelivered);
        }
        return redelivered;
    }

    public String getJMSReplyToAsString() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSReplyToAsString()", "getter", this.jmsReplyToAsString);
        }
        return this.jmsReplyToAsString;
    }

    public Long getJMSTimestamp() throws JMSException {
        Long ts = new Long(this.jmsTimestamp);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSTimestamp()", "getter", ts);
        }
        return ts;
    }

    public String getJMSType() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "getJMSType()", "getter", this.jmsType);
        }
        return this.jmsType;
    }

    public void setJMSCorrelationID(String correlID) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSCorrelationID(String)", new Object[]{correlID});
        }
        if (correlID == null) {
            this.jmsCorrelationID = null;
            this.jmsCorrelationIDAsBytes = null;
        } else {
            this.jmsCorrelationIDAsBytes = (byte[])(correlID.startsWith("ID:") ? WMQUtils.stringToId(correlID) : null);
        }
        this.jmsCorrelationID = correlID;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSCorrelationID(String)");
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlIDBytes) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSCorrelationIDAsBytes(byte [ ])", new Object[]{correlIDBytes});
        }
        if (correlIDBytes == null) {
            this.jmsCorrelationIDAsBytes = null;
            this.jmsCorrelationID = null;
        } else {
            this.jmsCorrelationIDAsBytes = new byte[correlIDBytes.length];
            System.arraycopy(correlIDBytes, 0, this.jmsCorrelationIDAsBytes, 0, correlIDBytes.length);
            this.jmsCorrelationID = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSCorrelationIDAsBytes(byte [ ])");
        }
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSDeliveryMode(int)", new Object[]{new Integer(deliveryMode)});
        }
        if (deliveryMode == -2) {
            this.jmsDeliveryMode = 2;
            this.hideDeliveryMode = true;
        } else if (deliveryMode == -3) {
            this.jmsDeliveryMode = -2;
            this.hideDeliveryMode = true;
        } else {
            this.jmsDeliveryMode = deliveryMode;
            this.hideDeliveryMode = false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSDeliveryMode(int)");
        }
    }

    public void setJMSDestinationAsString(String newDestinationAsString) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSDestinationAsString(String)", "setter", newDestinationAsString);
        }
        this.jmsDestinationAsString = newDestinationAsString;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSExpiration(long)", "setter", new Long(expiration));
        }
        this.jmsExpiration = expiration;
    }

    public void setJMSMessageID(String messageID) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSMessageID(String)", "setter", messageID);
        }
        this.jmsMessageID = messageID;
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSPriority(int)", "setter", new Integer(priority));
        }
        this.jmsPriority = priority;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSRedelivered(boolean)", "setter", redelivered);
        }
        this.jmsRedelivered = redelivered;
    }

    public void setJMSReplyToAsString(String newReplyToAsString) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSReplyToAsString(String)", "setter", newReplyToAsString);
        }
        this.jmsReplyToAsString = newReplyToAsString;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSTimestamp(long)", "setter", new Long(timestamp));
        }
        this.jmsTimestamp = timestamp;
    }

    public void setJMSType(String type) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSType(String)", new Object[]{type});
        }
        this.jmsType = type;
        if (type == null || !type.startsWith("mcd://")) {
            this.jmsType_Domain = null;
            this.jmsType_Set = null;
            this.jmsType_Type = null;
            this.jmsType_Format = null;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSType(String)", 1);
            }
            return;
        }
        if (!"jms_text".equals(this.messageClass) && !"jms_bytes".equals(this.messageClass)) {
            this.throwBadJMSTypeException(type);
        }
        String msDomain = null;
        String msSet = null;
        String msType = null;
        String msFormat = null;
        int index = 6;
        int query = type.indexOf(63, index);
        String path = query == -1 ? type : type.substring(0, query);
        int separator = path.indexOf(47, index);
        if (separator == -1) {
            if (path.length() <= 6) {
                this.throwBadJMSTypeException(type);
            }
            msDomain = path.substring(index);
        } else {
            if (separator == index) {
                this.throwBadJMSTypeException(type);
            }
            msDomain = path.substring(index, separator);
            index = separator + 1;
            if ((separator = path.indexOf(47, index)) == -1) {
                msSet = path.substring(index);
            } else {
                msSet = path.substring(index, separator);
                index = separator + 1;
                msType = path.substring(index);
            }
        }
        if (query > 0) {
            if (type.regionMatches(true, query, "?format=", 0, 8)) {
                msFormat = type.substring(query + 8);
                if (msFormat.indexOf(38) != -1) {
                    this.throwBadJMSTypeException(type);
                }
            } else {
                this.throwBadJMSTypeException(type);
            }
        }
        this.jmsType_Domain = msDomain;
        this.jmsType_Set = msSet;
        this.jmsType_Type = msType;
        this.jmsType_Format = msFormat;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "setJMSType(String)", 2);
        }
    }

    private void throwBadJMSTypeException(String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "throwBadJMSTypeException(String)", new Object[]{value});
        }
        HashMap<String, String> inserts = new HashMap<String, String>();
        inserts.put("XMSC_INSERT_PROPERTY", "JMSType");
        inserts.put("XMSC_INSERT_VALUE", value);
        JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ1006", inserts));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.messages.TransientMessageHeader", "throwBadJMSTypeException(String)", je);
        }
        throw je;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.messages.TransientMessageHeader", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/messages/TransientMessageHeader.java, jmscc.wmq, k701, k701-112-140304  1.16.1.1 09/08/17 08:56:31");
        }
        DEFAULT_CORRELID_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }
}

