/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.constants.CMQC;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.LpiNotifyDetails;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageListener;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.internal.WMQConnection;
import com.ibm.msg.client.wmq.internal.WMQConsumerShadow;
import com.ibm.msg.client.wmq.internal.WMQMessageConsumer;
import com.ibm.msg.client.wmq.internal.WMQSession;
import java.util.HashMap;
import javax.jms.JMSException;

class WMQSyncConsumerShadow
extends WMQConsumerShadow {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQSyncConsumerShadow.java, jmscc.wmq, k701, k701-112-140304 1.55.1.6 11/07/22 14:05:28";
    private static final int CHUNKTIME = 5000;
    private WMQSession session;

    WMQSyncConsumerShadow(JmsPropertyContext jmsProps, WMQSession session, WMQDestination destination, String selector, boolean nolocal, String subscriptionName) {
        this(jmsProps, session, destination, selector, nolocal, subscriptionName, null);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "<init>(JmsPropertyContext,WMQSession,WMQDestination,String,boolean,String)", new Object[]{jmsProps, session, destination, selector, nolocal, subscriptionName});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "<init>(JmsPropertyContext,WMQSession,WMQDestination,String,boolean,String)");
        }
    }

    WMQSyncConsumerShadow(JmsPropertyContext jmsProps, WMQSession session, WMQDestination destination, String selector, boolean nolocal, String subscriptionName, byte[] subID) {
        super(jmsProps, session, destination, selector, nolocal, subscriptionName, subID);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "<init>(JmsPropertyContext,WMQSession,WMQDestination,String,boolean,String,byte [ ])", new Object[]{jmsProps, session, destination, selector, nolocal, subscriptionName, subID});
        }
        this.session = session;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "<init>(JmsPropertyContext,WMQSession,WMQDestination,String,boolean,String,byte [ ])");
        }
    }

    void initialize() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "initialize()");
        }
        super.initialize();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "initialize()");
        }
    }

    ProviderMessage receiveInternal(long timeOut) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "receiveInternal(long)", new Object[]{new Long(timeOut)});
        }
        Pint cc = this.env.newPint();
        Pint rc = this.env.newPint();
        ProviderMessage resultMsg = null;
        MQGMO gmo = null;
        if (timeOut != -1L && (timeOut > Integer.MAX_VALUE || timeOut < 0L)) {
            HashMap<String, Long> inserts = new HashMap<String, Long>();
            inserts.put("XMSC_INSERT_TIMEOUT", new Long(timeOut));
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ1067", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "receiveInternal(long)", je, 1);
            }
            throw je;
        }
        boolean unlimitedWait = timeOut == 0L;
        long thisWaitTime = 0L;
        long endTime = 0L;
        boolean firstPassDone = false;
        boolean lastTry = false;
        do {
            if (unlimitedWait) {
                thisWaitTime = -1L;
            } else if (firstPassDone) {
                thisWaitTime = Math.max(endTime - System.currentTimeMillis(), 0L);
                if (thisWaitTime == 0L) {
                    lastTry = true;
                }
            } else {
                thisWaitTime = Math.max(timeOut, 0L);
                endTime = System.currentTimeMillis() + timeOut;
            }
            try {
                gmo = this.computeGMO((int)thisWaitTime);
                if (this.nolocal) {
                    boolean messageValid = false;
                    do {
                        resultMsg = this.getMsg(gmo, -1, true, cc, rc);
                        String parentConnId = ((WMQConnection)this.session.getConnection()).getHconn().getConnectionIdAsString();
                        String messageConnId = null;
                        if (resultMsg != null) {
                            messageConnId = resultMsg.getStringProperty("JMS_IBM_ConnectionID");
                        }
                        if (!parentConnId.equals(messageConnId)) {
                            messageValid = true;
                            continue;
                        }
                        if (!Trace.isOn) continue;
                        Trace.data(this, "c.i.m.c.wmq.internal.ApiSyncConsumerShadow", (Object)"noLocal, Message disgarded as ConnectionID matched our ConnectioID");
                    } while (!messageValid);
                    continue;
                }
                resultMsg = this.getMsg(gmo, -1, true, cc, rc);
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "receiveInternal(long)", e);
                }
                if (rc.x == 2107 && cc.x != 0) {
                    firstPassDone = true;
                    if (!lastTry) continue;
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "receiveInternal(long)", null, 1);
                    }
                    return null;
                }
                if (rc.x == 2033) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "receiveInternal(long)", null, 2);
                    }
                    return null;
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "receiveInternal(long)", e, 2);
                }
                throw e;
            }
        } while (resultMsg == null && this.isRunning());
        if (!this.isRunning() && resultMsg == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "receiveInternal(long)", null, 3);
            }
            return null;
        }
        if (resultMsg != null && (gmo.getOptions() & 4) != 4 && (resultMsg.getJMSDeliveryMode() != 1 || (gmo.getOptions() & 0x1000) != 4096)) {
            this.session.operationPerformed(WMQConsumerOwner.Operation.GET, true);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "receiveInternal(long)", resultMsg, 4);
        }
        return resultMsg;
    }

    void setMessageListener(ProviderMessageListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "setMessageListener(ProviderMessageListener)", new Object[]{listener});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "setMessageListener(ProviderMessageListener)");
        }
    }

    ProviderMessage receive(byte[] token, int msgLength) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "receive(byte [ ],int)", new Object[]{token, new Integer(msgLength)});
        }
        ProviderMessage resultMsg = null;
        MQGMO gmo = this.computeGMO(0);
        gmo.setMatchOptions(32);
        gmo.setMsgToken(token);
        gmo.setVersion(3);
        int options = gmo.getOptions();
        gmo.setOptions(options &= 0xFFFFFFFE);
        resultMsg = this.getMsg(gmo, msgLength, false);
        if (resultMsg != null && (gmo.getOptions() & 4) != 4 && (resultMsg.getJMSDeliveryMode() != 1 || (gmo.getOptions() & 0x1000) != 4096)) {
            this.session.operationPerformed(WMQConsumerOwner.Operation.GET, true);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "receive(byte [ ],int)", resultMsg);
        }
        return resultMsg;
    }

    void closeInternal() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "closeInternal()");
        }
        Pint cc = this.env.newPint();
        Pint rc = this.env.newPint();
        if (this.destination.isTopic()) {
            this.mq.MQCLOSE(this.hconn, this.phsub, 0, cc, rc);
            WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ0025", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN004009", this.helper.getConnection(), this.hconn);
        }
        this.mq.MQCLOSE(this.hconn, this.phobj, 0, cc, rc);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "closeInternal()");
        }
    }

    void setRunning(boolean running) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "setRunning(boolean)", new Object[]{running});
        }
        super.setRunning(running);
        if (!running) {
            LpiNotifyDetails notifyDetails = ((JmqiSystemEnvironment)this.env).newLpiNotifyDetails();
            Hconn helperHconn = this.helper.getHconn();
            Hconn connectionsHconn = ((WMQConnection)this.helper.getConnection()).getHconn();
            if (helperHconn == CMQC.jmqi_MQHC_UNUSABLE_HCONN || connectionsHconn == CMQC.jmqi_MQHC_UNUSABLE_HCONN) {
                if (Trace.isOn) {
                    Trace.data(this, "helper.hconn", (Object)helperHconn);
                    Trace.data(this, "helper.connection.hconn", (Object)connectionsHconn);
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "setRunning(boolean)", 1);
                }
                return;
            }
            byte[] connectionID = helperHconn.getConnectionId();
            notifyDetails.setConnectionId(connectionID);
            notifyDetails.setVersion(1);
            notifyDetails.setReason(2107);
            Pint temprc = this.env.newPint();
            Pint tempcc = this.env.newPint();
            ((JmqiSP)this.mq).jmqiNotify(connectionsHconn, this.hconn, 1, notifyDetails, tempcc, temprc);
            if (temprc.x != 2107 && tempcc.x != 0) {
                if (Reason.isImpossibleReason(temprc.x, tempcc.x)) {
                    HashMap<String, Comparable<Boolean>> info = new HashMap<String, Comparable<Boolean>>();
                    info.put("running", new Boolean(running));
                    info.put("reason", new Integer(temprc.x));
                    info.put("compcode", new Integer(tempcc.x));
                    info.put("hconn", (Comparable<Boolean>)this.hconn);
                    Trace.ffst("WMQSyncConsumerShadow", "setRunning(boolean)", "XN00T001", info, null);
                } else {
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("XMSC_INSERT_METHOD", "spiNotify");
                    info.put("XMSC_INSERT_COMP_CODE", new Integer(tempcc.x));
                    info.put("XMSC_INSERT_REASON", new Integer(temprc.x));
                    Log.log(this, "setRunning(boolean)", "JMSWMQ2019", info);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "setRunning(boolean), 2");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQSyncConsumerShadow.java, jmscc.wmq, k701, k701-112-140304  1.55.1.6 11/07/22 14:05:28");
        }
    }
}

