/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.MQCNO;
import com.ibm.mq.jmqi.MQSTS;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Phconn;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.internal.JmqiTools;
import com.ibm.mq.jmqi.system.JmqiConnectOptions;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.TableBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.provider.ProviderMessageReference;
import com.ibm.msg.client.provider.ProviderQueueBrowser;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.wmq.common.WMQCommonUtils;
import com.ibm.msg.client.wmq.common.WMQThreadLocalStorage;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.common.internal.WMQCommonConnection;
import com.ibm.msg.client.wmq.common.internal.WMQCommonSession;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.internal.Utils;
import com.ibm.msg.client.wmq.internal.WMQConnection;
import com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow;
import com.ibm.msg.client.wmq.internal.WMQMessageConsumer;
import com.ibm.msg.client.wmq.internal.WMQMessageProducer;
import com.ibm.msg.client.wmq.internal.WMQMessageReference;
import com.ibm.msg.client.wmq.internal.WMQQueueBrowser;
import com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow;
import java.util.HashMap;
import javax.jms.JMSException;

public class WMQSession
extends WMQPropertyContext
implements ProviderSession,
WMQConsumerOwner,
WMQCommonSession {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid1 = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQSession.java, jmscc.wmq, k701, k701-112-140304 1.132.1.20 13/01/02 15:24:48";
    private static final long serialVersionUID = 1489582154L;
    private int ackMode;
    private WMQSyncConsumerShadow asfConsumer;
    private WMQDestination asfDestination;
    private String asfSubName;
    private AsyncPutCounter asyncPutCounter;
    private WMQConnection connection;
    private boolean didRecovAsyncPut = false;
    private JmqiEnvironment environment;
    private int jmqiCompId;
    private Hconn hconn;
    private WMQConsumerOwnerShadow helper;
    private boolean inSyncpoint = false;
    private JmqiMQ mq;
    private String queueManagerName;

    static String createFullSubscriptionName(String clientid, String subscriptionName, String resolvedQMName, String streamName) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQSession", "createFullSubscriptionName(String,String,String,String)", new Object[]{clientid, subscriptionName, resolvedQMName, streamName});
        }
        StringBuffer name = new StringBuffer();
        name.append("JMS:");
        name.append(WMQCommonUtils.escapeString(resolvedQMName));
        name.append(":");
        name.append(WMQCommonUtils.escapeString(clientid));
        name.append(":");
        name.append(WMQCommonUtils.escapeString(subscriptionName));
        if (!streamName.equals("SYSTEM.BROKER.DEFAULT.STREAM")) {
            name.append(WMQCommonUtils.escapeString(streamName));
        }
        String traceRet1 = name.toString();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQSession", "createFullSubscriptionName(String,String,String,String)", (Object)traceRet1);
        }
        return traceRet1;
    }

    WMQSession(WMQConnection connection, int ackMode, JmsPropertyContext propertyContext) throws JMSException {
        super(propertyContext);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "<init>(WMQConnection,int,JmsPropertyContext)", new Object[]{connection, new Integer(ackMode), propertyContext});
        }
        this.connection = connection;
        this.ackMode = ackMode;
        WMQFFSTInfo.addSession(this);
        short adminObjectType = this.getShortProperty("XMSC_ADMIN_OBJECT_TYPE");
        if ((adminObjectType & 0x100) == 0) {
            this.connect();
        } else {
            this.connectRRS();
        }
        this.helper = new WMQConsumerOwnerShadow(this, this.queueManagerName);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "<init>(WMQConnection,int,JmsPropertyContext)");
        }
    }

    private void connect() throws JMSException {
        String userid;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "connect()");
        }
        this.queueManagerName = this.connection.getQueueManagerName();
        this.environment = this.connection.getJmqiEnvironment();
        this.jmqiCompId = this.connection.getJmqiCompId();
        this.mq = this.connection.getJmqiMQ();
        this.asyncPutCounter = new AsyncPutCounter(this);
        JmqiSP sp = (JmqiSP)this.mq;
        JmqiConnectOptions jmqiConnOpts = this.connection.getJmqiConnectOptions();
        MQCNO connOpts = this.connection.getConnectOptions();
        Phconn phconn = this.environment.newPhconn();
        Pint cc = this.environment.newPint();
        Pint rc = this.environment.newPint();
        Pint cc2 = this.environment.newPint();
        Pint rc2 = this.environment.newPint();
        Hconn parentHconn = this.connection.getHconn();
        phconn.setHconn(parentHconn);
        sp.jmqiConnect(this.queueManagerName, jmqiConnOpts, connOpts, parentHconn, phconn, cc, rc);
        if (cc.x == 1 && rc.x == 2267) {
            cc.x = 0;
            rc.x = 0;
        }
        if (cc.x == 1) {
            this.mq.MQDISC(phconn, cc2, rc2);
        }
        if (cc.x == 0 && (userid = jmqiConnOpts.getUserIdentifier()) != null && !"".equals(userid.trim())) {
            Hconn hconn2 = phconn.getHconn();
            String password = jmqiConnOpts.getPassword();
            this.mq.authenticate(hconn2, userid, password, cc, rc);
            if (cc.x != 0) {
                this.mq.MQDISC(phconn, cc2, rc2);
            }
        }
        if (cc.x != 0) {
            if (Reason.isImpossibleReason(rc.x, cc.x)) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("reason", rc);
                info.put("compcode", cc);
                info.put("queuemanager", this.queueManagerName);
                info.put("jmqiConnOpts", jmqiConnOpts);
                info.put("connOpts", connOpts);
                Trace.ffst(this, "<init>(WMQConnection,int,JmsPropertyContext)", "XN008001", info, JMSException.class);
            }
            if (Reason.isConnectionBroken(rc.x)) {
                JMSException e = Reason.createException("JMSWMQ1107", null, rc.x, cc.x, this.environment);
                this.connection.driveExceptionListener(e, true);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_QUEUE_MANAGER", this.queueManagerName);
            inserts.put("XMSC_WMQ_CONNECTION_MODE", this.getStringProperty("XMSC_WMQ_CONNECTION_MODE"));
            inserts.put("XMSC_WMQ_HOST_NAME", this.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT"));
            JMSException je = Reason.createException("JMSWMQ0018", inserts, rc.x, cc.x, this.environment);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQSession", "connect()", je);
            }
            throw je;
        }
        this.hconn = phconn.getHconn();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "connect()");
        }
    }

    private void connectRRS() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "connectRRS()");
        }
        this.queueManagerName = this.connection.getQueueManagerName();
        this.environment = this.connection.getJmqiEnvironment();
        this.jmqiCompId = this.connection.getJmqiCompId();
        this.mq = this.connection.getJmqiMQ();
        this.asyncPutCounter = new AsyncPutCounter(this);
        JmqiSP sp = (JmqiSP)this.mq;
        JmqiConnectOptions jmqiConnOpts = this.connection.getJmqiConnectOptions();
        MQCNO connOpts = this.connection.getConnectOptions();
        Phconn phconn = this.environment.newPhconn();
        Pint cc = this.environment.newPint();
        Pint rc = this.environment.newPint();
        Pint cc2 = this.environment.newPint();
        Pint rc2 = this.environment.newPint();
        Hconn parentHconn = this.connection.getHconn();
        sp.jmqiConnect(this.queueManagerName, jmqiConnOpts, connOpts, parentHconn, phconn, cc, rc);
        if (cc.x == 1) {
            switch (rc.x) {
                case 2002: 
                case 2267: {
                    cc.x = 0;
                    rc.x = 0;
                }
            }
        }
        if (cc.x == 1) {
            this.mq.MQDISC(phconn, cc2, rc2);
        }
        if (cc.x != 0) {
            if (Reason.isImpossibleReason(rc.x, cc.x)) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("reason", rc);
                info.put("compcode", cc);
                info.put("queuemanager", this.queueManagerName);
                info.put("jmqiConnOpts", jmqiConnOpts);
                info.put("connOpts", connOpts);
                Trace.ffst(this, "<init>(WMQConnection,int,JmsPropertyContext)", "XN008001", info, JMSException.class);
            }
            if (Reason.isConnectionBroken(rc.x)) {
                JMSException e = Reason.createException("JMSWMQ1107", null, rc.x, cc.x, this.environment);
                this.connection.driveExceptionListener(e, true);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_QUEUE_MANAGER", this.queueManagerName);
            inserts.put("XMSC_WMQ_CONNECTION_MODE", this.getStringProperty("XMSC_WMQ_CONNECTION_MODE"));
            inserts.put("XMSC_WMQ_HOST_NAME", this.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT"));
            JMSException je = Reason.createException("JMSWMQ0018", inserts, rc.x, cc.x, this.environment);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQSession", "connectRRS()", je);
            }
            throw je;
        }
        this.hconn = phconn.getHconn();
        sp.honourRRS(this.hconn, cc, rc);
        if (cc.x != 0) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("reason", rc);
            info.put("compcode", cc);
            info.put("queuemanager", this.queueManagerName);
            Trace.ffst(this, "connectRRS()", "XN008009", info, JMSException.class);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "connectRRS()");
        }
    }

    public void addAsyncConsumer() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "addAsyncConsumer()");
        }
        this.helper.addAsyncConsumer();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "addAsyncConsumer()");
        }
    }

    public void addQueueToCache(Phobj phobj, String queueName, String selector, int options) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "addQueueToCache(Phobj,String,String,int)", new Object[]{phobj, queueName, selector, new Integer(options)});
        }
        this.helper.addQueueToCache(phobj, queueName, selector, options);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "addQueueToCache(Phobj,String,String,int)");
        }
    }

    private void callMQSTAT(Pint reason, Pint compcode) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "callMQSTAT(Pint,Pint)", new Object[]{reason, compcode});
        }
        MQSTS sts = this.environment.newMQSTS();
        boolean didSuspend = this.suspendAsyncService();
        this.mq.MQSTAT(this.hconn, 0, sts, compcode, reason);
        if (didSuspend) {
            this.resumeAsyncService();
        }
        if (0 != reason.x) {
            if (Reason.isImpossibleReason(reason.x, compcode.x)) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("reason", reason);
                info.put("compcode", compcode);
                info.put("queuemanager", this.queueManagerName);
                info.put("hconn", this.hconn);
                Trace.ffst(this, "callMQSTAT()", "XN008006", info, JMSException.class);
            }
            if (Reason.isConnectionBroken(reason.x)) {
                JMSException e = Reason.createException("JMSWMQ1107", null, reason.x, compcode.x, this.environment);
                this.connection.driveExceptionListener(e, true);
            }
            JMSException je = Reason.createException("MQSTAT", reason.x, compcode.x, this.environment);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQSession", "callMQSTAT(Pint,Pint)", je, 1);
            }
            throw je;
        }
        if (sts.getReason() != 0 || sts.getPutFailureCount() != 0 || sts.getPutWarningCount() != 0) {
            StringBuffer wmqMsgbuff = new StringBuffer("JMSWMQ0002");
            wmqMsgbuff.append(": ");
            String wmqMsg = NLSServices.getMessage("JMSWMQ0002", new Object[]{Integer.toString(sts.getCompCode()), Integer.toString(sts.getReason()), sts.getObjectName(), sts.getResolvedObjectName(), Integer.toString(sts.getObjectType()), sts.getObjectQMgrName(), sts.getResolvedQMgrName(), Integer.toString(sts.getPutFailureCount()), Integer.toString(sts.getPutSuccessCount()), Integer.toString(sts.getPutWarningCount())});
            wmqMsgbuff.append(wmqMsg);
            wmqMsg = wmqMsgbuff.toString();
            MQException wmqex = new MQException(wmqMsg, "JMSWMQ0002", sts.getReason(), sts.getCompCode());
            JMSException je2 = (JMSException)((Object)NLSServices.createException("JMSWMQ0028", null));
            je2.setLinkedException((Exception)((Object)wmqex));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQSession", "callMQSTAT(Pint,Pint)", je2, 2);
            }
            throw je2;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "callMQSTAT(Pint,Pint)");
        }
    }

    private void callMQSTATQuietly(Pint reason, Pint compcode, WMQConsumerOwner.Operation operation, boolean invokeExceptionListener) {
        block8: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "callMQSTATQuietly(Pint,Pint,Operation,boolean)", new Object[]{reason, compcode, operation, invokeExceptionListener});
            }
            try {
                this.callMQSTAT(reason, compcode);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQSession", "callMQSTATQuietly(Pint,Pint,Operation,boolean)", je, 1);
                }
                if (!invokeExceptionListener) break block8;
                try {
                    this.connection.driveExceptionListener(je, Reason.isConnectionBroken(reason.x));
                }
                catch (JMSException je2) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQSession", "callMQSTATQuietly(Pint,Pint,Operation,boolean)", je2, 2);
                    }
                    HashMap<String, Object> ffstInfo = new HashMap<String, Object>();
                    ffstInfo.put("Operation", null == operation ? "<null>" : operation.toString());
                    ffstInfo.put("JMSException1", (Object)je);
                    ffstInfo.put("JMSException2", (Object)je2);
                    Trace.ffst(this, "operationPerformed", "XN008007", ffstInfo, null);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "callMQSTATQuietly(Pint,Pint,Operation,boolean)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean closingFromConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "close(boolean)", new Object[]{closingFromConnection});
        }
        try {
            Pint cc = this.environment.newPint();
            Pint rc = this.environment.newPint();
            if (this.ackMode != 0 && this.asyncPutCounter.getCounter() > 0) {
                this.callMQSTATQuietly(rc, cc, null, true);
            }
            this.disconnect();
        }
        finally {
            WMQFFSTInfo.removeSession(this);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "close(boolean)");
        }
    }

    private void disconnect() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "disconnect()");
        }
        Pint cc = this.environment.newPint();
        Pint rc = this.environment.newPint();
        Phconn phconn = new Phconn(this.environment);
        phconn.setHconn(this.hconn);
        this.mq.MQDISC(phconn, cc, rc);
        if (0 != rc.x) {
            if (Reason.isImpossibleReason(rc.x, cc.x)) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("reason", rc);
                info.put("compcode", cc);
                info.put("queuemanager", this.queueManagerName);
                info.put("hconn", this.hconn);
                Trace.ffst(this, "disconnect()", "XN008003", info, JMSException.class);
            }
            if (Reason.isConnectionBroken(rc.x)) {
                JMSException e = Reason.createException("JMSWMQ1107", null, rc.x, cc.x, this.environment);
                this.connection.driveExceptionListener(e, true);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_QUEUE_MANAGER", this.queueManagerName);
            inserts.put("XMSC_WMQ_CONNECTION_MODE", this.getStringProperty("XMSC_WMQ_CONNECTION_MODE"));
            inserts.put("XMSC_WMQ_HOST_NAME", this.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT"));
            JMSException je = Reason.createException("JMSWMQ0019", inserts, rc.x, cc.x, this.environment);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQSession", "disconnect()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "disconnect()");
        }
    }

    public synchronized void commit() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "commit()");
        }
        this.syncpoint(true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "commit()");
        }
    }

    public ProviderQueueBrowser createBrowser(ProviderDestination destination, String selector, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "createBrowser(ProviderDestination,String,JmsPropertyContext)", new Object[]{destination, selector, propertyContext});
        }
        WMQQueueBrowser browser = new WMQQueueBrowser(this, destination, selector, propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "createBrowser(ProviderDestination,String,JmsPropertyContext)", browser);
        }
        return browser;
    }

    public ProviderMessageConsumer createConsumer(ProviderDestination destination, String selector, boolean nolocal, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", new Object[]{destination, selector, nolocal, propertyContext});
        }
        WMQMessageConsumer consumer = new WMQMessageConsumer((WMQDestination)destination, this, selector, nolocal, propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", consumer);
        }
        return consumer;
    }

    public ProviderMessageConsumer createDurableSubscriber(ProviderDestination destination, String subscriptionName, String selector, boolean nolocal, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "createDurableSubscriber(ProviderDestination,String,String,boolean,JmsPropertyContext)", new Object[]{destination, subscriptionName, selector, nolocal, propertyContext});
        }
        if (null == subscriptionName || subscriptionName.length() == 0) {
            Trace.ffst(this, "createDurableSubscriber", "XN008004", null, JMSException.class);
        }
        String fullSubName = this.createFullSubscriptionName(subscriptionName);
        WMQMessageConsumer consumer = new WMQMessageConsumer((WMQDestination)destination, this, fullSubName, selector, nolocal, propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "createDurableSubscriber(ProviderDestination,String,String,boolean,JmsPropertyContext)", consumer);
        }
        return consumer;
    }

    private String createFullSubscriptionName(String subscriptionName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "createFullSubscriptionName(String)", new Object[]{subscriptionName});
        }
        String clientid = this.getStringProperty("XMSC_CLIENT_ID");
        String resolvedQMName = this.getStringProperty("XMSC_WMQ_RESOLVED_QUEUE_MANAGER");
        String streamName = this.getStringProperty("XMSC_WMQ_BROKER_PUBQ");
        String name = WMQSession.createFullSubscriptionName(clientid, subscriptionName, resolvedQMName, streamName);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "createFullSubscriptionName(String)", name);
        }
        return name;
    }

    public String createMessageID() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "createMessageID()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "createMessageID()", null);
        }
        return null;
    }

    public ProviderMessageProducer createProducer(ProviderDestination destination, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "createProducer(ProviderDestination,JmsPropertyContext)", new Object[]{destination, propertyContext});
        }
        WMQMessageProducer producer = new WMQMessageProducer(this, (WMQDestination)destination, propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "createProducer(ProviderDestination,JmsPropertyContext)", producer);
        }
        return producer;
    }

    public ProviderDestination createTemporaryDestination(int destType, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "createTemporaryDestination(int,JmsPropertyContext)", new Object[]{new Integer(destType), propertyContext});
        }
        WMQDestination dest = this.connection.createTemporaryDestination(destType, propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "createTemporaryDestination(int,JmsPropertyContext)", dest);
        }
        return dest;
    }

    public void deleteDurableSubscriber(String subscriptionName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "deleteDurableSubscriber(String)", new Object[]{subscriptionName});
        }
        String fullSubName = this.createFullSubscriptionName(subscriptionName);
        WMQMessageConsumer.deleteDurableSubscription(this, fullSubName);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "deleteDurableSubscriber(String)");
        }
    }

    public int getAckMode() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getAckMode()", "getter", new Integer(this.ackMode));
        }
        return this.ackMode;
    }

    public WMQCommonConnection getConnection() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getConnection()", "getter", this.connection);
        }
        return this.connection;
    }

    public Hconn getHconn() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getHconn()", "getter", this.hconn);
        }
        return this.hconn;
    }

    public JmqiEnvironment getJmqiEnvironment() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getJmqiEnvironment()", "getter", this.environment);
        }
        return this.environment;
    }

    public JmqiMQ getJmqiMQ() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getJmqiMQ()", "getter", this.mq);
        }
        return this.mq;
    }

    public Phobj getQueueFromCache(String queueName, String selector, int options) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getQueueFromCache(String,String,int)", new Object[]{queueName, selector, new Integer(options)});
        }
        Phobj phobjTemp = this.helper.getQueueFromCache(queueName, selector, options);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "getQueueFromCache(String,String,int)", phobjTemp);
        }
        return phobjTemp;
    }

    private String getSafeProperty(String name) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getSafeProperty(String)", new Object[]{name});
        }
        try {
            if (this.propertyExists(name)) {
                String prop = this.getStringProperty(name);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getSafeProperty(String)", prop, 1);
                }
                return prop;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getSafeProperty(String)", je);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getSafeProperty(String)", null, 2);
            }
            return null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getSafeProperty(String)", null, 3);
        }
        return null;
    }

    public boolean isInGlobalTransaction() {
        boolean isInUOW;
        boolean rrs;
        boolean xa;
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "isInGlobalTransaction()");
            }
            xa = false;
            rrs = false;
            try {
                short adminObjectType = this.getShortProperty("XMSC_ADMIN_OBJECT_TYPE");
                xa = (adminObjectType & 0x40) != 0;
                rrs = (adminObjectType & 0x100) != 0;
            }
            catch (JMSException e) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQSession", "isInGlobalTransaction()", e);
            }
        }
        boolean bl = isInUOW = rrs && Utils.isRRSTransactionInProgress() || xa;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "isInGlobalTransaction()", isInUOW);
        }
        return isInUOW;
    }

    public boolean getTransacted() {
        boolean result;
        boolean rrs;
        block3: {
            rrs = false;
            try {
                short adminObjectType = this.getShortProperty("XMSC_ADMIN_OBJECT_TYPE");
                rrs = (adminObjectType & 0x100) != 0;
            }
            catch (JMSException e) {
                if (!Trace.isOn) break block3;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getTransacted()", e);
            }
        }
        boolean transacted = 0 == this.ackMode;
        boolean bl = result = transacted || rrs && Utils.isRRSTransactionInProgress();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getTransacted()", "getter", result);
        }
        return result;
    }

    public boolean isAsyncRunning() {
        boolean traceRet1 = this.helper.isAsyncRunning();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQSession", "isAsyncRunning()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public boolean isSubscriptionInUse(String subscriptionName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "isSubscriptionInUse(String)", new Object[]{subscriptionName});
        }
        boolean traceRet1 = this.helper.isSubscriptionInUse(subscriptionName);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "isSubscriptionInUse(String)", traceRet1);
        }
        return traceRet1;
    }

    public void loadMessageReference(ProviderMessageReference messageReference) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "loadMessageReference(ProviderMessageReference)", new Object[]{messageReference});
        }
        boolean sameSubName = true;
        String subname = null;
        WMQMessageReference msgRef = (WMQMessageReference)messageReference;
        WMQDestination destination = msgRef.getDestination();
        if (destination.isTopic()) {
            subname = msgRef.getFqSubName();
            sameSubName = false;
            if (null == subname && null == this.asfSubName) {
                sameSubName = true;
            }
            if (null != subname && null != this.asfSubName && subname.equals(this.asfSubName)) {
                sameSubName = true;
            }
        }
        if (!destination.equals(this.asfDestination) || !sameSubName) {
            this.asfConsumer = null;
        }
        if (null == this.asfConsumer) {
            byte[] subID = msgRef.getSubID();
            this.asfConsumer = new WMQSyncConsumerShadow(this, this, destination, null, false, subname, subID){

                int computeQueueOpenOptions() throws JMSException {
                    if (Trace.isOn) {
                        Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession#WMQSyncConsumerShadow", "computeQueueOpenOptions()");
                    }
                    int options = super.computeQueueOpenOptions();
                    options |= 0x80000;
                    options |= 2;
                    options &= 0xFFFFFFFE;
                    options &= 0xFFFFFFFF;
                    options &= 0xFFEFFFFF;
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession#WMQSyncConsumerShadow", "computeQueueOpenOptions()", new Integer(options));
                    }
                    return options;
                }

                int computeSubscriptionOptions() throws JMSException {
                    if (Trace.isOn) {
                        Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession#WMQSyncConsumerShadow", "computeSubscriptionOptions()");
                    }
                    int options = super.computeSubscriptionOptions();
                    options |= 0x80000;
                    options &= 0xFFFFFFFF;
                    options &= 0xFFEFFFFF;
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession#WMQSyncConsumerShadow", "computeSubscriptionOptions()", new Integer(options));
                    }
                    return options;
                }
            };
            this.asfConsumer.initialize();
            this.asfDestination = destination;
            this.asfSubName = subname;
        }
        byte[] token = msgRef.getToken();
        if (Trace.isOn) {
            Trace.data(this, "loadMessageReference", "message token", (Object)JmqiTools.arrayToHexString((byte[])token));
        }
        int msgLen = msgRef.getMsgLength();
        ProviderMessage message = this.asfConsumer.receive(token, msgLen);
        msgRef.setMessage(message);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "loadMessageReference(ProviderMessageReference)");
        }
    }

    public void operationPerformed(WMQConsumerOwner.Operation operation, boolean syncpoint) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "operationPerformed(Operation,boolean)", new Object[]{operation, syncpoint});
        }
        if (syncpoint) {
            this.inSyncpoint = true;
            if (WMQConsumerOwner.Operation.ASYNCPUT == operation) {
                this.didRecovAsyncPut = true;
            }
        } else if (operation.isAnyPut() && this.asyncPutCounter.incrementAndCheckLimit()) {
            Pint reason = this.environment.newPint();
            Pint compcode = this.environment.newPint();
            this.callMQSTATQuietly(reason, compcode, operation, true);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "operationPerformed(Operation,boolean)");
        }
    }

    public String getDestinationURI(byte[] flatMR) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getDestinationURI(byte [ ])", new Object[]{flatMR});
        }
        String uri = WMQMessageReference.getDestinationURI(flatMR);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "getDestinationURI(byte [ ])", uri);
        }
        return uri;
    }

    public ProviderMessageReference recreateMessageReference(byte[] flatMR, ProviderDestination dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "recreateMessageReference(byte [ ],ProviderDestination)", new Object[]{flatMR, dest});
        }
        WMQMessageReference mr = new WMQMessageReference(flatMR, dest);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "recreateMessageReference(byte [ ],ProviderDestination)", mr);
        }
        return mr;
    }

    public void removeAsyncConsumer() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "removeAsyncConsumer()");
        }
        this.helper.removeAsyncConsumer();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "removeAsyncConsumer()");
        }
    }

    public boolean removeQueueFromCache(Phobj phobj) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "removeQueueFromCache(Phobj)", new Object[]{phobj});
        }
        boolean removed = this.helper.removeQueueFromCache(phobj);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "removeQueueFromCache(Phobj)", removed);
        }
        return removed;
    }

    public void removeSubscription(String subscriptionName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "removeSubscription(String)", new Object[]{subscriptionName});
        }
        this.helper.removeSubscription(subscriptionName);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "removeSubscription(String)");
        }
    }

    public void resumeAsyncService() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "resumeAsyncService()");
        }
        this.helper.resumeAsyncService();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "resumeAsyncService()");
        }
    }

    public synchronized void rollback() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "rollback()");
        }
        this.syncpoint(false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "rollback()");
        }
    }

    public void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "start()");
        }
        this.helper.start();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "start()");
        }
    }

    public void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "stop()");
        }
        this.helper.stop();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "stop()");
        }
    }

    public boolean suspendAsyncService() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "suspendAsyncService()");
        }
        boolean didSuspend = this.helper.suspendAsyncService();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSession", "suspendAsyncService()", didSuspend);
        }
        return didSuspend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void syncpoint(boolean commit) throws JMSException {
        JMSException je;
        block27: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "syncpoint(boolean)", new Object[]{commit});
            }
            Pint compcode = this.environment.newPint();
            Pint reason = this.environment.newPint();
            je = null;
            if (this.inSyncpoint || 0 == this.ackMode) {
                this.inSyncpoint = false;
                boolean didSuspend = this.suspendAsyncService();
                if (commit) {
                    this.mq.MQCMIT(this.hconn, compcode, reason);
                    if (compcode.x == 1 && reason.x == 2408) {
                        compcode.x = 0;
                        reason.x = 0;
                    }
                } else {
                    this.mq.MQBACK(this.hconn, compcode, reason);
                }
                if (didSuspend) {
                    this.resumeAsyncService();
                }
                if (0 != reason.x) {
                    String method;
                    String string = method = commit ? "MQCMIT" : "MQBACK";
                    if (Reason.isImpossibleReason(reason.x, compcode.x)) {
                        HashMap<String, Object> info = new HashMap<String, Object>();
                        info.put("reason", reason);
                        info.put("compcode", compcode);
                        info.put("queuemanager", this.queueManagerName);
                        info.put("method", method);
                        info.put("hconn", this.hconn);
                        Trace.ffst(this, "syncpoint()", "XN008005", info, JMSException.class);
                    }
                    if (Reason.isConnectionBroken(reason.x)) {
                        JMSException e = Reason.createException("JMSWMQ1107", null, reason.x, compcode.x, this.environment);
                        this.connection.driveExceptionListener(e, true);
                    }
                    je = Reason.createException(method, reason.x, compcode.x, this.environment);
                }
            }
            if (0 == this.ackMode && this.didRecovAsyncPut) {
                block28: {
                    try {
                        try {
                            if (je == null) {
                                this.callMQSTATQuietly(reason, compcode, null, false);
                            } else {
                                this.callMQSTAT(reason, compcode);
                            }
                        }
                        catch (JMSException je2) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQSession", "syncpoint(boolean)", je2);
                            }
                            if (null != je && commit) {
                                je.setLinkedException((Exception)((Object)je2));
                            }
                            Object var9_10 = null;
                            if (Trace.isOn) {
                                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQSession", "syncpoint(boolean)");
                            }
                            if (0 == reason.x) {
                                this.didRecovAsyncPut = false;
                            }
                            break block27;
                        }
                        Object var9_9 = null;
                        if (!Trace.isOn) break block28;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQSession", "syncpoint(boolean)");
                        }
                        if (0 == reason.x) {
                            this.didRecovAsyncPut = false;
                        }
                        throw throwable;
                    }
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQSession", "syncpoint(boolean)");
                }
                if (0 == reason.x) {
                    this.didRecovAsyncPut = false;
                }
            }
        }
        if (null != je) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQSession", "syncpoint(boolean)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "syncpoint(boolean)");
        }
    }

    public WMQThreadLocalStorage getThreadLocalStorage() {
        JmqiSystemEnvironment sysenv = (JmqiSystemEnvironment)this.environment;
        WMQThreadLocalStorage traceRet1 = (WMQThreadLocalStorage)sysenv.getComponentTls(this.jmqiCompId);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getThreadLocalStorage()", "getter", (Object)traceRet1);
        }
        return traceRet1;
    }

    public void decrementCloseCounter() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "decrementCloseCounter()");
        }
        this.helper.decrementCloseCounter();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "decrementCloseCounter()");
        }
    }

    public void incrementCloseCounter() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "incrementCloseCounter()");
        }
        this.helper.incrementCloseCounter();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "incrementCloseCounter()");
        }
    }

    public int getCloseCounter() {
        int traceRet1 = this.helper.getCloseCounter();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getCloseCounter()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Object getHconnLock() {
        Object traceRet1 = this.helper.getHconnLock();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQSession", "getHconnLock()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public String toString() {
        TableBuilder builder = new TableBuilder();
        builder.append("Instance", super.toString());
        if (this.connection == null) {
            builder.append("Parent Connection", "<null>");
        } else {
            builder.append("Parent Connection", this.connection.getClass().getName() + '@' + Integer.toHexString(this.connection.hashCode()));
        }
        builder.append("ackMode", new Integer(this.ackMode));
        builder.append("asfConsumer", this.asfConsumer);
        builder.append("asfDestination", this.asfDestination);
        builder.append("asfSubName", this.asfSubName);
        builder.append("asyncPutCounter", this.asyncPutCounter);
        builder.append("didRecovAsyncPut", new Boolean(this.didRecovAsyncPut));
        builder.append("helper", this.helper);
        builder.append("inSyncpoint", new Boolean(this.inSyncpoint));
        builder.append("queueManagerName", this.queueManagerName);
        return builder.toString();
    }

    public boolean isMessageAlien(ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSession", "isMessageAlien(ProviderMessage)", new Object[]{message});
        }
        if (message instanceof WMQMessage) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "isMessageAlien(ProviderMessage)", false, 1);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSession", "isMessageAlien(ProviderMessage)", true, 2);
        }
        return true;
    }

    protected boolean isInSyncPoint() {
        return this.inSyncpoint;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQSession", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQSession.java, jmscc.wmq, k701, k701-112-140304  1.132.1.20 13/01/02 15:24:48");
        }
    }

    private class AsyncPutCounter {
        private int counter = 0;
        private final int limit;
        private final boolean off;

        private AsyncPutCounter(JmsPropertyContext propertyContext) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.AsyncPutCounter", "<init>(JmsPropertyContext)", new Object[]{propertyContext});
            }
            this.limit = propertyContext.getIntProperty("XMSC_WMQ_SEND_CHECK_COUNT");
            boolean bl = this.off = 0 == this.limit;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.AsyncPutCounter", "<init>(JmsPropertyContext)");
            }
        }

        private synchronized int getCounter() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.AsyncPutCounter", "getCounter()", "getter", new Integer(this.counter));
            }
            return this.counter;
        }

        private synchronized boolean incrementAndCheckLimit() {
            boolean isZero;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.AsyncPutCounter", "incrementAndCheckLimit()");
            }
            if (this.off) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.AsyncPutCounter", "incrementAndCheckLimit()", false, 1);
                }
                return false;
            }
            ++this.counter;
            if (this.counter == this.limit) {
                this.counter = 0;
            }
            boolean bl = isZero = 0 == this.counter;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.AsyncPutCounter", "incrementAndCheckLimit()", isZero, 2);
            }
            return isZero;
        }
    }
}

