/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.system.SpiOpenOptions;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.internal.WMQSession;
import com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.jms.JMSException;

public class WMQQueueEnumeration
implements Enumeration {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQQueueEnumeration.java, jmscc.wmq, k701, k701-112-140304 1.28.1.5 11/12/12 16:29:08";
    private WMQSyncBrowserShadow browserShadow;
    private boolean bufferFilled = false;
    private ProviderMessage message;

    WMQQueueEnumeration(JmsPropertyContext jmsProps, WMQSession session, WMQDestination queue, String selector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "<init>(JmsPropertyContext,WMQSession,WMQDestination,String)", new Object[]{jmsProps, session, queue, selector});
        }
        this.browserShadow = new WMQSyncBrowserShadow(jmsProps, session, queue, selector, null);
        this.browserShadow.initialize();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "<init>(JmsPropertyContext,WMQSession,WMQDestination,String)");
        }
    }

    void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "close()");
        }
        if (this.browserShadow != null) {
            this.browserShadow.close(null);
            this.browserShadow = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "close()");
        }
    }

    public boolean hasMoreElements() {
        boolean result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "hasMoreElements()");
        }
        if (this.browserShadow == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "hasMoreElements()", false, 1);
            }
            return false;
        }
        if (this.bufferFilled) {
            if (Trace.isOn) {
                Trace.traceData(this, "hasMoreElements found previously cached message", null);
            }
            result = true;
        } else {
            this.message = this.retrieveMessage();
            if (this.message == null) {
                result = false;
            } else {
                this.bufferFilled = true;
                result = true;
                if (Trace.isOn) {
                    Trace.traceData(this, "hasMoreElements put message in cache", null);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "hasMoreElements()", result, 2);
        }
        return result;
    }

    public Object nextElement() throws NoSuchElementException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "nextElement()");
        }
        if (this.browserShadow == null) {
            NoSuchElementException nsee = new NoSuchElementException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "nextElement()", nsee, 1);
            }
            throw nsee;
        }
        ProviderMessage result = null;
        if (this.bufferFilled) {
            result = this.message;
            this.bufferFilled = false;
        } else {
            result = this.retrieveMessage();
        }
        if (result == null) {
            NoSuchElementException nsee = new NoSuchElementException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "nextElement()", nsee, 2);
            }
            throw nsee;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "nextElement()", result);
        }
        return result;
    }

    private ProviderMessage retrieveMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "retrieveMessage()");
        }
        try {
            ProviderMessage m = this.browserShadow.receive(-1L);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "retrieveMessage()", m, 1);
            }
            return m;
        }
        catch (JMSException je) {
            MQException wex;
            int reason;
            Exception e;
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "retrieveMessage()", je, 1);
            }
            if ((e = je.getLinkedException()) instanceof MQException && (reason = (wex = (MQException)((Object)e)).getReason()) == 2033) {
                try {
                    this.close();
                }
                catch (JMSException je2) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "retrieveMessage()", je2, 2);
                    }
                }
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "retrieveMessage()", e, 3);
            }
            HashMap<String, Object> ffstData = new HashMap<String, Object>();
            ffstData.put("Exception", e);
            ffstData.put("browserShadow", this.browserShadow);
            Trace.ffst(this, "nextElement()", "XN00H001", ffstData, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "retrieveMessage()", null, 2);
        }
        return null;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQQueueEnumeration", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQQueueEnumeration.java, jmscc.wmq, k701, k701-112-140304  1.28.1.5 11/12/12 16:29:08");
        }
    }

    protected class WMQSyncBrowserShadow
    extends WMQSyncConsumerShadow {
        WMQSyncBrowserShadow(JmsPropertyContext jmsProps, WMQSession session, WMQDestination queue, String selector, String subscriptionName) {
            super(jmsProps, session, queue, selector, false, subscriptionName);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncBrowserShadow", "<init>(JmsPropertyContext,WMQSession,WMQDestination,String,String)", new Object[]{jmsProps, session, queue, selector, subscriptionName});
            }
            this.isBrowser = true;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQSyncBrowserShadow", "<init>(JmsPropertyContext,WMQSession,WMQDestination,String,String)");
            }
        }

        MQGMO computeGMO(int waitTime) throws JMSException {
            MQGMO gmo;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncBrowserShadow", "computeGMO(int)", new Object[]{new Integer(waitTime)});
            }
            if ((gmo = this.env.newMQGMO()).getVersion() < 3) {
                gmo.setVersion(3);
            }
            int getOptions = 0;
            int fiq = this.destination.getIntProperty("failIfQuiesce");
            if (fiq == 1) {
                if (Trace.isOn) {
                    Trace.data(this, "Get fail-if-quiesce = yes", null);
                }
                getOptions |= 0x2000;
            }
            getOptions |= 0x24;
            gmo.setOptions(getOptions |= this.gmoConvertOption);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSyncBrowserShadow", "computeGMO(int)", gmo);
            }
            return gmo;
        }

        int computeQueueOpenOptions() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncBrowserShadow", "computeQueueOpenOptions()");
            }
            int options = super.computeQueueOpenOptions();
            options &= 0xFFFFFF7F;
            options &= 0xFFFFFFFE;
            options |= 8;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSyncBrowserShadow", "computeQueueOpenOptions()", new Integer(options));
            }
            return options;
        }

        SpiOpenOptions computeSpiOpenOptions(int queueOpenOptions) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQSyncBrowserShadow", "computeSpiOpenOptions(int)", new Object[]{new Integer(queueOpenOptions)});
            }
            SpiOpenOptions spiOO = super.computeSpiOpenOptions(queueOpenOptions);
            int qoo = spiOO.getLpiOptions();
            qoo &= 0xFFFFFFFE;
            spiOO.setLpiOptions(qoo &= 0xFFFFFFFD);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQSyncBrowserShadow", "computeSpiOpenOptions(int)", spiOO);
            }
            return spiOO;
        }
    }
}

