/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.constants.CMQC;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.JmqiUtils;
import com.ibm.mq.jmqi.MQDLH;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.MQPMO;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Hobj;
import com.ibm.mq.jmqi.handles.PbyteBuffer;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.internal.JmqiTools;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal;
import com.ibm.msg.client.wmq.internal.WMQConnection;
import com.ibm.msg.client.wmq.internal.WMQSession;
import com.ibm.msg.client.wmq.internal.WMQXASession;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import javax.jms.JMSException;

public class WMQPoison {
    private static String jmsDeadLetterStyleProperty;
    private static String V7_JMS_DEAD_LETTER_STYLE;
    private static String V6_JMS_DEAD_LETTER_STYLE;
    private String jmsDeadLetterStyle = null;
    private boolean isBrowser = false;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQPoison.java, jmscc.wmq, k701, k701-112-140304 1.58.1.29 13/11/20 15:45:08";
    public static final String useDefaultBOValues = "com.ibm.mq.jms.useDefaultBOValues";
    private JmqiEnvironment env;
    private JmqiMQ mq;
    private JmqiSP sp;
    private Hconn hconn;
    private Hobj consumersHobj;
    private WMQConsumerOwner owner;
    private WMQDestination destination;
    private DestinationAttrs destAttrs;
    private QmAttrs qmAttrs;
    private Pint cc;
    private Pint rc;
    private Pint cc2;
    private Pint rc2;
    private String subscriptionQueue;
    private WMQSession session;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setBrowser(boolean isBrowser) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "setBrowser(boolean)", (Object)new Object[]{new Boolean(isBrowser)});
        }
        this.isBrowser = isBrowser;
    }

    WMQPoison(WMQConsumerOwner owner, WMQDestination destination, Hobj hobj, String subscriptionQueue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "<init>(WMQConsumerOwner,WMQDestination,Hobj,String)", new Object[]{owner, destination, hobj, subscriptionQueue});
        }
        this.owner = owner;
        this.destination = destination;
        this.subscriptionQueue = subscriptionQueue;
        this.env = owner.getJmqiEnvironment();
        this.mq = owner.getJmqiMQ();
        this.sp = (JmqiSP)this.mq;
        this.hconn = owner.getHconn();
        this.consumersHobj = hobj;
        this.cc = this.env.newPint();
        this.rc = this.env.newPint();
        this.cc2 = this.env.newPint();
        this.rc2 = this.env.newPint();
        this.qmAttrs = new QmAttrs();
        this.destAttrs = new DestinationAttrs();
        this.jmsDeadLetterStyle = PropertyStore.getStringProperty(jmsDeadLetterStyleProperty);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "<init>(WMQConsumerOwner,WMQDestination,Hobj,String)");
        }
    }

    void setHobj(Hobj hobj) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "setHobj(Hobj)", "setter", hobj);
        }
        this.consumersHobj = hobj;
    }

    boolean shouldMessageBeRequeued(int attempts) {
        boolean requeueit;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "shouldMessageBeRequeued(int)", new Object[]{new Integer(attempts)});
        }
        if (this.destAttrs.BOThresh == 0) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "shouldMessageBeRequeued(int)", false, 1);
            }
            return false;
        }
        boolean bl = requeueit = this.destAttrs.BOThresh <= attempts;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "shouldMessageBeRequeued(int)", requeueit, 2);
        }
        return requeueit;
    }

    void handlePoisonMessage(WMQMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(WMQMessage)", new Object[]{message});
        }
        this.handlePoisonMessage(message, 0);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(WMQMessage)");
        }
    }

    void handlePoisonMessage(WMQMessage message, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(WMQMessage,int)", new Object[]{message, new Integer(reason)});
        }
        PoisonMessage pmsg = new PoisonMessage(message);
        this.handlePoisonMessage(pmsg, reason, null);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(WMQMessage,int)");
        }
    }

    ProviderMessage handlePoisonMessage(MQMD mqmd, ByteBuffer[] msgBuffers) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(MQMD,ByteBuffer [ ])", new Object[]{mqmd, msgBuffers});
        }
        ProviderMessage provMsg = this.handlePoisonMessage(mqmd, msgBuffers, null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(MQMD,ByteBuffer [ ])", provMsg);
        }
        return provMsg;
    }

    ProviderMessage handlePoisonMessage(MQMD mqmd, ByteBuffer[] msgBuffers, MQGMO gmo) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(MQMD,ByteBuffer [ ],MQGMO)", new Object[]{mqmd, msgBuffers, gmo});
        }
        PoisonMessage pmsg = new PoisonMessage(mqmd, msgBuffers);
        ProviderMessage provMsg = this.handlePoisonMessage(pmsg, 0, gmo);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(MQMD,ByteBuffer [ ],MQGMO)", provMsg);
        }
        return provMsg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProviderMessage handlePoisonMessage(PoisonMessage pmsg, int defaultReason, MQGMO gmo) throws JMSException {
        Hobj previousConsumersHobj;
        Phobj pHobj;
        boolean closeRequired;
        block55: {
            ProviderMessage rc2;
            block53: {
                ProviderMessage providerMessage;
                block51: {
                    block52: {
                        if (Trace.isOn) {
                            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)", new Object[]{pmsg, new Integer(defaultReason), gmo});
                        }
                        closeRequired = false;
                        this.rc.x = 0;
                        this.cc.x = 0;
                        pHobj = null;
                        previousConsumersHobj = this.consumersHobj;
                        try {
                            try {
                                boolean sessionCleanBeforeBORQ;
                                if (this.owner instanceof WMQSession) {
                                    this.session = (WMQSession)this.owner;
                                } else if (this.owner instanceof WMQConnection) {
                                    WMQConnection connection = (WMQConnection)this.owner;
                                    connection.setIntProperty("XMSC_ACKNOWLEDGE_MODE", 1);
                                    connection.setBooleanProperty("XMSC_TRANSACTED", false);
                                    this.session = (WMQSession)connection.createSession(connection);
                                } else {
                                    Trace.ffst(this, "handlePoisonMessage", "XN00S001", this.ffstInfo(), JMSException.class);
                                }
                                boolean bl = sessionCleanBeforeBORQ = !this.session.isInSyncPoint();
                                if (this.isBrowser) {
                                    if (!(this.session instanceof WMQXASession) || ((WMQXASession)this.session).isXASessionActive()) {
                                        closeRequired = true;
                                        Pint rc2 = this.env.newPint();
                                        pHobj = this.env.newPhobj();
                                        pmsg = this.getBrowsedMessage(gmo, rc2, pHobj);
                                        this.consumersHobj = pHobj.getHobj();
                                        if (rc2.x == 2033) {
                                            if (Trace.isOn) {
                                                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int, MQGMO)", null, 1);
                                            }
                                            providerMessage = null;
                                            Object var16_16 = null;
                                            if (!Trace.isOn) break block51;
                                            break block52;
                                        }
                                    } else {
                                        if (Trace.isOn) {
                                            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)", (Object)("Unable to requeue the message as the session is not enlisted in a transaction, MsgId:" + JmqiTools.arrayToHexString((byte[])pmsg.mqmd.getMsgId())));
                                            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int, MQGMO)", null, 2);
                                        }
                                        rc2 = null;
                                        break block53;
                                    }
                                }
                                boolean messageDeadLettered = false;
                                boolean messageDiscarded = false;
                                String qname = null;
                                String qmname = null;
                                int reason = this.backoutRequeue(pmsg);
                                if (reason != 0) {
                                    if ((pmsg.getReport() & 0x8000000) != 0x8000000) {
                                        qmname = ((WMQConnection)this.owner.getConnection()).getQueueManagerName();
                                        if (this.destAttrs.BORQName == null || this.destAttrs.BORQName.length() == 0) {
                                            if (this.destination.isTopic()) {
                                                if (this.subscriptionQueue == null) {
                                                    Trace.ffst(this, "deadletter", "XN00S002", this.ffstInfo(), JMSException.class);
                                                }
                                                qname = this.subscriptionQueue;
                                            } else {
                                                qname = this.destination.getName();
                                            }
                                        } else {
                                            qname = this.destAttrs.BORQName;
                                        }
                                        if (defaultReason != 0) {
                                            reason = defaultReason;
                                        }
                                        this.deadletter(pmsg, qname, qmname, reason);
                                        messageDeadLettered = true;
                                    } else {
                                        messageDiscarded = true;
                                    }
                                    this.sendReport(pmsg, reason);
                                }
                                this.syncpoint(true, sessionCleanBeforeBORQ);
                                if (messageDeadLettered) {
                                    HashMap<String, String> inserts = new HashMap<String, String>();
                                    String messageID = JmqiTools.arrayToHexString((byte[])pmsg.mqmd.getMsgId());
                                    inserts.put("XMSC_INSERT_MESSAGE_ID", messageID);
                                    inserts.put("XMSC_INSERT_DESTINATION_NAME", qname);
                                    inserts.put("XMSC_INSERT_QUEUE_MANAGER_NAME", qmname);
                                    Log.log(this, "handlePoisonMessage(PoisonMessage,int,MQGMO)", "JMSWMQ1116", inserts);
                                    break block55;
                                }
                                if (messageDiscarded) {
                                    HashMap<String, String> inserts = new HashMap<String, String>();
                                    String messageID = JmqiTools.arrayToHexString((byte[])pmsg.mqmd.getMsgId());
                                    inserts.put("XMSC_INSERT_MESSAGE_ID", messageID);
                                    inserts.put("XMSC_INSERT_DESTINATION_NAME", qname);
                                    inserts.put("XMSC_INSERT_QUEUE_MANAGER_NAME", qmname);
                                    Log.log(this, "handlePoisonMessage(PoisonMessage,int,MQGMO)", "JMSWMQ1117", inserts);
                                }
                                break block55;
                            }
                            catch (JMSException je) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)", je, 1);
                                }
                                this.syncpoint(false, false);
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)", je, 1);
                                }
                                throw je;
                            }
                            catch (RuntimeException rte) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int)", rte, 2);
                                }
                                this.syncpoint(false, false);
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)", rte, 2);
                                }
                                throw rte;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var16_19 = null;
                            if (Trace.isOn) {
                                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)");
                            }
                            if (this.isBrowser) {
                                this.consumersHobj = previousConsumersHobj;
                                if (Trace.isOn) {
                                    Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)", (Object)("Reset consumersHobj to new  previous value " + this.consumersHobj));
                                }
                                if (closeRequired) {
                                    Pint closeCc = this.env.newPint();
                                    Pint closeRc = this.env.newPint();
                                    this.mq.MQCLOSE(this.hconn, pHobj, 0, closeCc, closeRc);
                                }
                            }
                            if (this.owner instanceof WMQConnection && this.session != null) {
                                this.session.close(false);
                                this.session = null;
                            }
                            throw throwable;
                        }
                    }
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)");
                }
                if (this.isBrowser) {
                    this.consumersHobj = previousConsumersHobj;
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)", (Object)("Reset consumersHobj to new  previous value " + this.consumersHobj));
                    }
                    if (closeRequired) {
                        Pint closeCc = this.env.newPint();
                        Pint closeRc = this.env.newPint();
                        this.mq.MQCLOSE(this.hconn, pHobj, 0, closeCc, closeRc);
                    }
                }
                if (this.owner instanceof WMQConnection && this.session != null) {
                    this.session.close(false);
                    this.session = null;
                }
                return providerMessage;
            }
            Object var16_17 = null;
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)");
            }
            if (this.isBrowser) {
                this.consumersHobj = previousConsumersHobj;
                if (Trace.isOn) {
                    Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)", (Object)("Reset consumersHobj to new  previous value " + this.consumersHobj));
                }
                if (closeRequired) {
                    Pint closeCc = this.env.newPint();
                    Pint closeRc = this.env.newPint();
                    this.mq.MQCLOSE(this.hconn, pHobj, 0, closeCc, closeRc);
                }
            }
            if (this.owner instanceof WMQConnection && this.session != null) {
                this.session.close(false);
                this.session = null;
            }
            return rc2;
        }
        Object var16_18 = null;
        if (Trace.isOn) {
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)");
        }
        if (this.isBrowser) {
            this.consumersHobj = previousConsumersHobj;
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)", (Object)("Reset consumersHobj to new  previous value " + this.consumersHobj));
            }
            if (closeRequired) {
                Pint closeCc = this.env.newPint();
                Pint closeRc = this.env.newPint();
                this.mq.MQCLOSE(this.hconn, pHobj, 0, closeCc, closeRc);
            }
        }
        if (this.owner instanceof WMQConnection && this.session != null) {
            this.session.close(false);
            this.session = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "handlePoisonMessage(PoisonMessage,int,MQGMO)", null, 3);
        }
        return null;
    }

    private PoisonMessage getBrowsedMessage(MQGMO gmo, Pint getRc, Phobj pHobj) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "getBrowsedMessage(MQGMO,Pint,Phobj)");
        }
        PoisonMessage pmsg = null;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "getBrowsedMessage(MQGMO,Pint,Phobj)", (Object)"Message got using browser, now attempting to re-get message from queue");
        }
        try {
            MQOD od = this.env.newMQOD();
            od.setObjectType(1);
            od.setObjectName(this.destination.getName());
            int openOpts = 8322;
            this.mq.MQOPEN(this.hconn, od, openOpts, pHobj, this.cc, this.rc);
            this.checkJmqiCallSuccess("MQOPEN", "JMSWMQ0030", this.destination.getName(), this.cc, this.rc, "XN00S00F");
            MQGMO newGMO = this.env.newMQGMO();
            if (newGMO.getVersion() < 3) {
                newGMO.setVersion(3);
            }
            int getOpts = 8194;
            newGMO.setOptions(getOpts);
            byte[] nullMsgToken = new byte[16];
            Arrays.fill(nullMsgToken, (byte)0);
            Pint getCc = this.env.newPint();
            MQMD newMQMD = this.env.newMQMD();
            PbyteBuffer msgBuffer = this.env.newPbyteBuffer();
            ByteBuffer newMsgBuf = null;
            if (gmo != null && !Arrays.equals(gmo.getMsgToken(), nullMsgToken)) {
                newGMO.setMatchOptions(32);
                newGMO.setMsgToken(gmo.getMsgToken());
                Pint msgTooSmallForBuffer = this.env.newPint();
                Pint dataLength = this.env.newPint();
                newMsgBuf = ((JmqiSP)this.mq).jmqiGet(this.hconn, pHobj.getHobj(), newMQMD, newGMO, -1, Integer.MAX_VALUE, msgBuffer, msgTooSmallForBuffer, dataLength, getCc, getRc);
                this.session.operationPerformed(WMQConsumerOwner.Operation.GET, true);
            } else {
                if (Trace.isOn) {
                    Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "getBrowsedMessage(MQGMO,Pint,Phobj)", (Object)"Unable to obtain message as msgToken is unavailable, aborting poison message handling");
                }
                getRc.x = 2033;
            }
            this.checkJmqiCallSuccess("jmqiGet", "JMSWMQ0030", this.destination.getName(), getCc, getRc, "XN00S010");
            pmsg = new PoisonMessage(newMQMD, new ByteBuffer[]{newMsgBuf});
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "getBrowsedMessage(MQGMO,Pint,Phobj)", (Object)("Set consumersHobj to new hobj " + pHobj.getHobj()));
            }
        }
        catch (JMSException je) {
            Pint closeCc = this.env.newPint();
            Pint closeRc = this.env.newPint();
            this.mq.MQCLOSE(this.hconn, pHobj, 0, closeCc, closeRc);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "getBrowsedMessage(MQGMO,Pint,Phobj)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "getBrowsedMessage(MQGMO,Pint,Phobj)", pmsg);
        }
        return pmsg;
    }

    private int backoutRequeue(PoisonMessage pmsg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "backoutRequeue(PoisonMessage)", new Object[]{pmsg});
        }
        if (this.destAttrs.BORQName == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "backoutRequeue(PoisonMessage)", new Integer(2362), 1);
            }
            return 2362;
        }
        try {
            pmsg.setTargetDestination(this.destAttrs.BORQDestination);
            this.put(pmsg, this.destAttrs.BORQName, null, false);
        }
        catch (JMSException je) {
            MQException wmqex;
            int reason;
            Exception e;
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "backoutRequeue(PoisonMessage)", je);
            }
            if ((e = je.getLinkedException()) != null && e instanceof MQException && (reason = (wmqex = (MQException)((Object)e)).getReason()) != 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "backoutRequeue(PoisonMessage)", new Integer(reason), 2);
                }
                return reason;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "backoutRequeue(PoisonMessage)", new Integer(2362), 3);
            }
            return 2362;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "backoutRequeue(PoisonMessage)", new Integer(this.rc.x), 4);
        }
        return this.rc.x;
    }

    private void deadletter(PoisonMessage pmsg, String qname, String qmname, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "deadletter(PoisonMessage,String,String,int)", new Object[]{pmsg, qname, qmname, new Integer(reason)});
        }
        if (this.qmAttrs.deadLetterQ == null || this.qmAttrs.deadLetterQ.length() == 0) {
            Log.log(this, "driveExceptionListener(JMSException, boolean)", "JMSWMQ0032", null);
            JMSException jmsex = (JMSException)((Object)NLSServices.createException("JMSWMQ0032", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "deadletter(PoisonMessage,String,String,int)", jmsex, 1);
            }
            throw jmsex;
        }
        try {
            PoisonMessage deadmsg = (PoisonMessage)pmsg.clone();
            deadmsg.setTargetDestination(this.qmAttrs.deadLetterQDestination);
            if (Trace.isOn && deadmsg.wmqMsg == null) {
                Trace.traceInfo(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "deadletter(PoisonMessage,String,String,int)", (Object)"message does not contain a provider message");
            }
            if (this.jmsDeadLetterStyle.equalsIgnoreCase(V7_JMS_DEAD_LETTER_STYLE) && deadmsg.wmqMsg != null) {
                if (Trace.isOn) {
                    Trace.traceInfo(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "deadletter(PoisonMessage,String,String,int)", (Object)("com.ibm.msg.client.tuning.JmsDeadLetterStyle is set to " + this.jmsDeadLetterStyle + ". Dead lettering message as a BytesMessage"));
                }
                deadmsg.convertToBytesMessage();
            } else if (Trace.isOn) {
                Trace.traceInfo(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "deadletter(PoisonMessage,String,String,int)", (Object)"dead lettering message in it's original format");
            }
            MQDLH dlh = this.computeDLH(deadmsg, qname, qmname, reason);
            deadmsg.chainInDLH(dlh);
            this.put(deadmsg, this.qmAttrs.deadLetterQ, null, true);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "deadletter(PoisonMessage,String,String,int)", e);
            }
            HashMap<String, Exception> inserts = new HashMap<String, Exception>();
            inserts.put("XMSC_INSERT_EXCEPTION", e);
            Log.log(this, "driveExceptionListener(JMSException, boolean)", "JMSWMQ0035", inserts);
            JMSException jmsex1 = (JMSException)((Object)NLSServices.createException("JMSWMQ1079", null));
            jmsex1.setLinkedException(e);
            JMSException jmsex = (JMSException)((Object)NLSServices.createException("JMSWMQ1080", null));
            jmsex.setLinkedException((Exception)((Object)jmsex1));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "deadletter(PoisonMessage,String,String,int)", jmsex, 2);
            }
            throw jmsex;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "deadletter(PoisonMessage,String,String,int)");
        }
    }

    private void put(PoisonMessage pmsg, String destname, String qmname, boolean newMsgId) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "put(PoisonMessage,String,String,boolean)", new Object[]{pmsg, destname, qmname, newMsgId});
        }
        MQOD od = this.computeOD(destname, qmname);
        int opts = 8208;
        if (null == this.subscriptionQueue) {
            opts |= 0x200;
        }
        Phobj pHobj = this.env.newPhobj();
        this.mq.MQOPEN(this.hconn, od, opts, pHobj, this.cc, this.rc);
        this.checkJmqiCallSuccess("MQOPEN", "JMSWMQ0030", destname, this.cc, this.rc, "XN00S003");
        MQPMO pmo = this.computePMO(newMsgId);
        MQMD mqmd = pmsg.getMQMD();
        ByteBuffer[] buffs = pmsg.getByteBuffers();
        if (buffs != null) {
            for (int i = 0; i < buffs.length; ++i) {
                buffs[i].rewind();
            }
        }
        this.sp.jmqiPut(this.hconn, pHobj.getHobj(), mqmd, pmo, buffs, this.cc, this.rc);
        this.mq.MQCLOSE(this.hconn, pHobj, 0, this.cc2, this.rc2);
        this.checkJmqiCallSuccess("MQPUT", "JMSWMQ0030", destname, this.cc, this.rc, "XN00S004");
        this.checkJmqiCallSuccess("MQCLOSE", "JMSWMQ0030", destname, this.cc2, this.rc2, "XN00S005");
        this.session.operationPerformed(WMQConsumerOwner.Operation.SYNCPUT, true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "put(PoisonMessage,String,String,boolean)");
        }
    }

    private void syncpoint(boolean commit, boolean forceTransactedCommit) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "syncpoint(boolean)", new Object[]{commit, forceTransactedCommit});
        }
        if (this.owner instanceof WMQConnection) {
            if (commit) {
                this.mq.MQCMIT(this.hconn, this.cc, this.rc);
                if (this.cc.x == 1 && this.rc.x == 2408) {
                    this.cc.x = 0;
                    this.rc.x = 0;
                }
            } else {
                this.mq.MQBACK(this.hconn, this.cc, this.rc);
            }
            this.checkJmqiCallSuccess(commit ? "MQCMIT" : "MQBACK", "JMSWMQ0030", this.destination.getName(), this.cc, this.rc, "XN00S006");
        } else if (!this.session.getTransacted() && this.session.getAckMode() != 2) {
            if (commit) {
                this.session.commit();
            } else {
                this.session.rollback();
            }
        } else if (this.session.getTransacted() || this.session.getAckMode() == 2) {
            if (!this.session.isInGlobalTransaction()) {
                if (commit && forceTransactedCommit) {
                    this.session.commit();
                }
            } else if (Trace.isOn) {
                Trace.data(this, "Not committing globally transacted session (" + this.session.getClass() + ")", null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "syncpoint(boolean)");
        }
    }

    private MQDLH computeDLH(PoisonMessage pmsg, String qname, String qmname, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "computeDLH(PoisonMessage,String,String,int)", new Object[]{pmsg, qname, qmname, new Integer(reason)});
        }
        MQMD mqmd = pmsg.getMQMD();
        MQDLH dlh = this.env.newMQDLH();
        dlh.setCodedCharSetId(mqmd.getCodedCharSetId());
        dlh.setEncoding(mqmd.getEncoding());
        dlh.setFormat(mqmd.getFormat());
        dlh.setDestQMgrName(qmname);
        dlh.setDestQName(qname);
        dlh.setPutApplName("MQ JMS ConnectionConsumer");
        dlh.setPutApplType(28);
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        int year = gc.get(1);
        int month = gc.get(2) + 1;
        int day = gc.get(5);
        int hour = gc.get(11);
        int min = gc.get(12);
        int sec = gc.get(13);
        int millis = gc.get(14);
        dlh.setPutDateAndTime(year, month, day, hour, min, sec, millis);
        dlh.setReason(reason);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "computeDLH(PoisonMessage,String,String,int)", dlh);
        }
        return dlh;
    }

    private void sendReport(PoisonMessage pmsg, int reason) throws JMSException {
        int opts;
        int reportExcBits;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "sendReport(PoisonMessage,int)", new Object[]{pmsg, new Integer(reason)});
        }
        if ((reportExcBits = (opts = pmsg.getReport()) & 0x7000000) == 0) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "sendReport(PoisonMessage,int)", 1);
            }
            return;
        }
        MQMD mqmd = pmsg.getMQMD();
        MQMD outmqmd = this.generateReportMQMD(mqmd, reason);
        pmsg.setMQMD(outmqmd);
        String replyToQM = WMQPoison.trim(mqmd.getReplyToQMgr());
        String replyTo = WMQPoison.trim(mqmd.getReplyToQ());
        if (replyTo == null) {
            this.deadletter(pmsg, replyTo, replyToQM, 2085);
        }
        PoisonMessage reportMsg = null;
        try {
            this.rc.x = 0;
            boolean newMsgId = (opts & 0x80) != 128;
            String uri = replyTo;
            StringBuffer uriBuff = new StringBuffer("queue://");
            if (replyToQM != null) {
                uriBuff.append(replyToQM);
            }
            uriBuff.append("/");
            uriBuff.append(replyTo);
            uri = uriBuff.toString();
            if (!$assertionsDisabled && !(this.owner instanceof JmsPropertyContext)) {
                throw new AssertionError();
            }
            WMQDestination replyToQ = new WMQDestination(1, uri, (JmsPropertyContext)((Object)this.owner));
            reportMsg = this.generateReportMessage(pmsg, replyToQ, reportExcBits);
            this.put(reportMsg, replyTo, replyToQM, newMsgId);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "sendReport(PoisonMessage,int)", je);
            }
            if (this.rc.x != 0) {
                this.deadletter(reportMsg, replyTo, replyToQM, this.rc.x);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_DESTINATION_NAME", replyTo);
            JMSException wrapper = (JMSException)((Object)NLSServices.createException("JMSWMQ0029", inserts));
            wrapper.setLinkedException((Exception)((Object)je));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "sendReport(PoisonMessage,int)", wrapper);
            }
            throw wrapper;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "sendReport(PoisonMessage,int)", 2);
        }
    }

    private PoisonMessage generateReportMessage(PoisonMessage pmsg, WMQDestination replyToQ, int reportExcBits) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "generateReportMessage(PoisonMessage,WMQDestination,int)", new Object[]{pmsg, replyToQ, new Integer(reportExcBits)});
        }
        switch (reportExcBits) {
            case 0x1000000: {
                pmsg.truncateBody(0);
                break;
            }
            case 0x3000000: {
                pmsg.truncateBody(100);
                break;
            }
            case 0x7000000: {
                break;
            }
            default: {
                HashMap data = this.ffstInfo();
                data.put("poison message", pmsg);
                data.put("replyto", replyToQ);
                Trace.ffst(this, "generateReportMessage", "XN00S007", data, JMSException.class);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "generateReportMessage(PoisonMessage,WMQDestination,int)", pmsg);
        }
        return pmsg;
    }

    private MQMD generateReportMQMD(MQMD mqmd, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "generateReportMQMD(MQMD,int)", new Object[]{mqmd, new Integer(reason)});
        }
        MQMD out = this.env.newMQMD();
        out.setVersion(2);
        out.setReport(0);
        out.setMsgType(4);
        out.setExpiry(-1);
        out.setFeedback(reason);
        out.setEncoding(mqmd.getEncoding());
        out.setCodedCharSetId(mqmd.getCodedCharSetId());
        out.setFormat(mqmd.getFormat());
        out.setPriority(mqmd.getPriority());
        out.setPersistence(mqmd.getPersistence());
        int opts = mqmd.getReport();
        if ((opts & 0x80) == 128) {
            out.setMsgId(mqmd.getMsgId());
        } else {
            out.setMsgId(CMQC.MQMI_NONE);
        }
        if ((opts & 0x40) == 64) {
            out.setCorrelId(mqmd.getCorrelId());
        } else {
            out.setCorrelId(mqmd.getMsgId());
        }
        out.setBackoutCount(0);
        out.setReplyToQ("");
        out.setReplyToQMgr(((WMQConnection)this.owner.getConnection()).getQueueManagerName());
        out.setPutApplType(28);
        out.setPutApplName("MQ JMS Connection Consumer");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "generateReportMQMD(MQMD,int)", out);
        }
        return out;
    }

    private MQOD computeOD(String destname, String qmname) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "computeOD(String,String)", new Object[]{destname, qmname});
        }
        MQOD od = this.env.newMQOD();
        if (qmname != null) {
            od.setObjectQMgrName(qmname);
        }
        od.setObjectType(1);
        od.setObjectName(destname);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "computeOD(String,String)", od);
        }
        return od;
    }

    private MQPMO computePMO(boolean newMsgId) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "computePMO(boolean)", new Object[]{newMsgId});
        }
        MQPMO pmo = this.env.newMQPMO();
        int options = 2;
        if (null == this.subscriptionQueue) {
            options |= 0x200;
        }
        if (newMsgId) {
            options |= 0x40;
        }
        pmo.setOptions(options);
        pmo.setContext(this.consumersHobj.getIntegerHandle());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "computePMO(boolean)", pmo);
        }
        return pmo;
    }

    private static String trim(String text) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQPoison", "trim(String)", new Object[]{text});
        }
        if (text == null || text.length() == 0) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.internal.WMQPoison", "trim(String)", (Object)null, 1);
            }
            return null;
        }
        String tidied = text.trim();
        if (tidied.length() == 0) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.internal.WMQPoison", "trim(String)", (Object)null, 2);
            }
            return null;
        }
        for (int i = 0; i < tidied.length(); ++i) {
            if (tidied.charAt(i) == '*') continue;
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.internal.WMQPoison", "trim(String)", (Object)tidied, 3);
            }
            return tidied;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQPoison", "trim(String)", (Object)null, 4);
        }
        return null;
    }

    private void checkJmqiCallSuccess(String method, String messageid, String targetDestination, Pint completionCode, Pint reason, String probeid) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "checkJmqiCallSuccess(String,String,String,Pint,Pint,String)", new Object[]{method, messageid, targetDestination, completionCode, reason, probeid});
        }
        if (reason.x != 0 || completionCode.x != 0) {
            if (Reason.isImpossibleReason(reason.x, completionCode.x)) {
                HashMap info = this.ffstInfo();
                info.put("method", method);
                info.put("reason", reason);
                info.put("compcode", completionCode);
                info.put("target destination", targetDestination);
                info.put("hconn", this.hconn);
                Trace.ffst("WMQPoison", "checkJmqiCallSuccess", probeid, info, JMSException.class);
            }
            if (Reason.isConnectionBroken(reason.x)) {
                JMSException e = Reason.createException("JMSWMQ1107", null, reason.x, completionCode.x, this.env);
                ((WMQConnection)this.owner.getConnection()).driveExceptionListener(e, true);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", method);
            if (targetDestination != null) {
                inserts.put("XMSC_DESTINATION_NAME", targetDestination);
            }
            JMSException je = Reason.createException(messageid, inserts, reason.x, completionCode.x, this.env);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "checkJmqiCallSuccess(String,String,String,Pint,Pint,String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "checkJmqiCallSuccess(String,String,String,Pint,Pint,String)");
        }
    }

    private HashMap ffstInfo() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQPoison", "ffstInfo()");
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("this", this);
        info.put("env", this.env);
        info.put("mq", this.mq);
        info.put("hconn", this.hconn);
        info.put("consumersHobj", this.consumersHobj);
        info.put("owner", this.owner);
        info.put("destination", this.destination);
        if (this.destination != null) {
            info.put("destination name", this.destination.getName());
        }
        info.put("destAttrs", this.destAttrs);
        info.put("qmAttrs", this.qmAttrs);
        info.put("cc", this.cc);
        info.put("rc", this.rc);
        info.put("cc2", this.rc2);
        info.put("subscriptionQueue", this.subscriptionQueue);
        info.put("session", this.session);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQPoison", "ffstInfo()", info);
        }
        return info;
    }

    static {
        $assertionsDisabled = !WMQPoison.class.desiredAssertionStatus();
        jmsDeadLetterStyleProperty = "com.ibm.msg.client.tuning.JmsDeadLetterStyle";
        V7_JMS_DEAD_LETTER_STYLE = "V7";
        V6_JMS_DEAD_LETTER_STYLE = "V6";
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQPoison", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQPoison.java, jmscc.wmq, k701, k701-112-140304  1.58.1.29 13/11/20 15:45:08");
        }
        PropertyStore.register(jmsDeadLetterStyleProperty, V6_JMS_DEAD_LETTER_STYLE, false);
    }

    private class PoisonMessage
    implements Cloneable {
        private WMQMessage wmqMsg;
        private MQMD mqmd;
        private ByteBuffer[] buffers;
        private WMQDestination targetDestination;

        private PoisonMessage(WMQMessage msg) {
            this.wmqMsg = null;
            this.mqmd = null;
            this.buffers = null;
            this.targetDestination = null;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "<init>(WMQMessage)", new Object[]{msg});
            }
            this.wmqMsg = msg;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "<init>(WMQMessage)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private PoisonMessage(MQMD mqmd, ByteBuffer[] msgBuffers) {
            block22: {
                boolean weCreatedTheTmpSession;
                WMQSession tmpSession;
                block21: {
                    this.wmqMsg = null;
                    this.mqmd = null;
                    this.buffers = null;
                    this.targetDestination = null;
                    if (Trace.isOn) {
                        Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "<init>(MQMD,ByteBuffer [ ])", new Object[]{mqmd, msgBuffers});
                    }
                    tmpSession = null;
                    weCreatedTheTmpSession = false;
                    try {
                        if (Trace.isOn) {
                            Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "msgBuffers", new Object[]{msgBuffers});
                        }
                        ByteBuffer merged = this.mergeByteBuffers(msgBuffers);
                        if (WMQPoison.this.owner instanceof WMQSession) {
                            tmpSession = (WMQSession)WMQPoison.this.owner;
                        } else if (WMQPoison.this.owner instanceof WMQConnection) {
                            Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Creating new temporary session.", null);
                            WMQConnection connection = (WMQConnection)WMQPoison.this.owner;
                            connection.setIntProperty("XMSC_ACKNOWLEDGE_MODE", 1);
                            connection.setBooleanProperty("XMSC_TRANSACTED", false);
                            tmpSession = (WMQSession)connection.createSession(connection);
                            weCreatedTheTmpSession = true;
                        } else {
                            Trace.ffst(this, "PoisonMessage<init>", "XN00S001", WMQPoison.this.ffstInfo(), class$javax$jms$JMSException == null ? (class$javax$jms$JMSException = WMQPoison.class$("javax.jms.JMSException")) : class$javax$jms$JMSException);
                        }
                        WMQReceiveMarshal receiveMarshal = WMQMarshal.newReceiveMarshal(tmpSession, merged, 0);
                        receiveMarshal.importMQMDMesageBuffer(tmpSession, WMQPoison.this.destination, mqmd, merged, 0, merged.limit());
                        this.wmqMsg = receiveMarshal.exportProviderMessage(false);
                        Object var9_9 = null;
                        if (!Trace.isOn) break block21;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (Trace.isOn) {
                            Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Ensure MQMD is copied", null);
                        }
                        this.mqmd = mqmd;
                        this.buffers = msgBuffers;
                        if (weCreatedTheTmpSession) {
                            Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Closing temporary session: ", tmpSession);
                            try {
                                tmpSession.close(false);
                            }
                            catch (JMSException e2) {
                                Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Caught exception closing tmpSession: ", e2.getStackTrace());
                            }
                        }
                        throw throwable;
                    }
                    Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Ensure MQMD is copied", null);
                }
                this.mqmd = mqmd;
                this.buffers = msgBuffers;
                if (weCreatedTheTmpSession) {
                    Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Closing temporary session: ", tmpSession);
                    try {
                        tmpSession.close(false);
                    }
                    catch (JMSException e2) {
                        Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Caught exception closing tmpSession: ", e2.getStackTrace());
                    }
                }
                break block22;
                {
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Caught exception: ", e.getStackTrace());
                        }
                        Object var9_10 = null;
                        if (Trace.isOn) {
                            Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Ensure MQMD is copied", null);
                        }
                        this.mqmd = mqmd;
                        this.buffers = msgBuffers;
                        if (weCreatedTheTmpSession) {
                            Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Closing temporary session: ", tmpSession);
                            try {
                                tmpSession.close(false);
                            }
                            catch (JMSException e2) {
                                Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "Constructor(MQMD,buffer)", "Caught exception closing tmpSession: ", e2.getStackTrace());
                            }
                        }
                    }
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "<init>(MQMD,ByteBuffer [ ])");
            }
        }

        private WMQMessage getWMQMessage() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "getWMQMessage()");
            }
            if (this.wmqMsg == null) {
                ByteBuffer merged = this.mergeByteBuffers(this.buffers);
                WMQReceiveMarshal receiveMarshal = WMQMarshal.newReceiveMarshal(WMQPoison.this.session, merged, 0);
                receiveMarshal.importMQMDMesageBuffer(WMQPoison.this.session, WMQPoison.this.destination, this.mqmd, merged, 0, merged.limit());
                this.wmqMsg = receiveMarshal.exportProviderMessage(false);
            }
            this.mqmd = null;
            this.buffers = null;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "getWMQMessage()", this.wmqMsg);
            }
            return this.wmqMsg;
        }

        private ByteBuffer mergeByteBuffers(ByteBuffer[] buffs) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "mergeByteBuffers(ByteBuffer [ ])", new Object[]{buffs});
            }
            int capacity = 0;
            int limit = 0;
            for (int i = 0; i < buffs.length; ++i) {
                buffs[i].rewind();
                capacity += buffs[i].capacity();
                limit += buffs[i].limit();
            }
            ByteBuffer merged = ByteBuffer.allocate(capacity);
            for (int i = 0; i < buffs.length; ++i) {
                merged.put(buffs[i]);
            }
            merged.limit(limit);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "mergeByteBuffers(ByteBuffer [ ])", merged);
            }
            return merged;
        }

        private void setTargetDestination(WMQDestination dest) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "setTargetDestination(WMQDestination)", "setter", dest);
            }
            this.targetDestination = dest;
        }

        private void calculateMqmdAndBuffers() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "calculateMqmdAndBuffers()");
            }
            if (this.wmqMsg != null) {
                if (this.wmqMsg.getJMSDestinationAsString() == null || this.wmqMsg.getJMSDestinationAsString().equals("")) {
                    if (this.targetDestination == null) {
                        this.targetDestination = new WMQDestination(1, "x", null);
                    }
                    this.wmqMsg.setJMSDestinationAsString(this.targetDestination.toURI());
                    this.mqmd = null;
                    this.buffers = null;
                }
                if (this.buffers == null || this.mqmd == null) {
                    WMQSendMarshal sendMarshal = WMQMarshal.newSendMarshal();
                    sendMarshal.importProviderMessage(WMQPoison.this.session, this.wmqMsg, WMQPoison.this.destination);
                    this.mqmd = sendMarshal.exportMQMD();
                    this.mqmd.setMsgId(WMQUtils.stringToId(this.wmqMsg.getJMSMessageID()));
                    this.buffers = sendMarshal.exportMessageBuffers();
                }
                this.wmqMsg = null;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "calculateMqmdAndBuffers()");
            }
        }

        private MQMD getMQMD() throws JMSException {
            this.calculateMqmdAndBuffers();
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "getMQMD()", "getter", this.mqmd);
            }
            return this.mqmd;
        }

        private void setMQMD(MQMD mqmd) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "setMQMD(MQMD)", "setter", mqmd);
            }
            this.mqmd = mqmd;
        }

        private ByteBuffer[] getByteBuffers() throws JMSException {
            this.calculateMqmdAndBuffers();
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "getByteBuffers()", "getter", this.buffers);
            }
            return this.buffers;
        }

        private void convertToBytesMessage() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "convertToBytesMessage()");
            }
            this.getWMQMessage();
            if (this.wmqMsg instanceof WMQBytesMessage) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "convertToBytesMessage()", 1);
                }
                return;
            }
            WMQBytesMessage newMsg = new WMQBytesMessage();
            this.duplicate(this.wmqMsg, newMsg);
            this.wmqMsg = newMsg;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "convertToBytesMessage()", 2);
            }
        }

        private void duplicate(WMQMessage src, WMQMessage tgt) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "duplicate(WMQMessage,WMQMessage)", new Object[]{src, tgt});
            }
            Enumeration names = src.getPropertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object value = src.getObjectProperty(name);
                tgt.setObjectProperty(name, value);
            }
            tgt.setJMSCorrelationID(src.getJMSCorrelationID());
            tgt.setJMSDeliveryMode(src.getJMSDeliveryMode());
            tgt.setJMSDestinationAsString(src.getJMSDestinationAsString());
            tgt.setJMSExpiration(src.getJMSExpiration());
            tgt.setJMSMessageID(src.getJMSMessageID());
            tgt.setJMSPriority(src.getJMSPriority());
            tgt.setJMSRedelivered(src.getJMSRedelivered());
            tgt.setJMSReplyToAsString(src.getJMSReplyToAsString());
            tgt.setJMSTimestamp(src.getJMSTimestamp());
            tgt.setJMSType(src.getJMSType());
            int encoding = src.getIntProperty("JMS_IBM_Encoding");
            String charset = src.getStringProperty("JMS_IBM_Character_Set");
            byte[] payload = src._exportBody(encoding, charset);
            tgt._importBody(payload, 0, -1, encoding, charset);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "duplicate(WMQMessage,WMQMessage)");
            }
        }

        private void chainInDLH(MQDLH dlh) throws JMSException, JmqiException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "chainInDLH(MQDLH)", new Object[]{dlh});
            }
            this.calculateMqmdAndBuffers();
            this.mqmd.setFormat("MQDEAD  ");
            boolean ptrsize = false;
            boolean byteswap = (this.mqmd.getEncoding() & 0xF) == 2;
            int ccsid = this.mqmd.getCodedCharSetId();
            JmqiCodepage cp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)WMQPoison.this.env, (int)ccsid);
            int dlhlen = MQDLH.getSize((JmqiEnvironment)WMQPoison.this.env, (int)1, (int)0);
            byte[] dlhbytes = new byte[dlhlen];
            dlh.writeToBuffer(dlhbytes, 0, 0, byteswap, cp, WMQPoison.this.mq);
            ByteBuffer dlhbuff = ByteBuffer.allocate(dlhlen);
            dlhbuff.put(dlhbytes);
            ByteBuffer[] msgBuffers2 = new ByteBuffer[this.buffers.length + 1];
            System.arraycopy(this.buffers, 0, msgBuffers2, 1, this.buffers.length);
            msgBuffers2[0] = dlhbuff;
            this.buffers = msgBuffers2;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "chainInDLH(MQDLH)");
            }
        }

        private int getReport() throws JMSException {
            this.calculateMqmdAndBuffers();
            int report = this.mqmd.getReport();
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "getReport()", "getter", new Integer(report));
            }
            return report;
        }

        private void truncateBody(int length) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "truncateBody(int)", new Object[]{new Integer(length)});
            }
            this.getWMQMessage();
            if (length == 0) {
                this.wmqMsg.clearBody();
                this.mqmd = null;
                this.buffers = null;
            } else {
                String charset;
                int encoding = this.wmqMsg.getIntProperty("JMS_IBM_Encoding");
                byte[] body = this.wmqMsg._exportBody(encoding, charset = this.wmqMsg.getStringProperty("JMS_IBM_Character_Set"));
                if (body.length > length) {
                    byte[] body2 = new byte[length];
                    System.arraycopy(body, 0, body2, 0, length);
                    this.wmqMsg.clearBody();
                    this.wmqMsg._importBody(body2, 0, -1, encoding, charset);
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "truncateBody(int)");
            }
        }

        public Object clone() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "clone()");
            }
            PoisonMessage clone = null;
            try {
                this.calculateMqmdAndBuffers();
                MQMD newmqmd = WMQPoison.this.env.newMQMD();
                newmqmd.setAccountingToken(this.mqmd.getAccountingToken());
                newmqmd.setApplIdentityData(this.mqmd.getApplIdentityData());
                newmqmd.setApplOriginData(this.mqmd.getApplOriginData());
                newmqmd.setBackoutCount(this.mqmd.getBackoutCount());
                newmqmd.setCodedCharSetId(this.mqmd.getCodedCharSetId());
                newmqmd.setCorrelId(this.mqmd.getCorrelId());
                newmqmd.setEncoding(this.mqmd.getEncoding());
                newmqmd.setExpiry(this.mqmd.getExpiry());
                newmqmd.setFeedback(this.mqmd.getFeedback());
                newmqmd.setFormat(this.mqmd.getFormat());
                newmqmd.setGroupId(this.mqmd.getGroupId());
                newmqmd.setMsgFlags(this.mqmd.getMsgFlags());
                newmqmd.setMsgId(this.mqmd.getMsgId());
                newmqmd.setMsgSeqNumber(this.mqmd.getMsgSeqNumber());
                newmqmd.setMsgType(this.mqmd.getMsgType());
                newmqmd.setOffset(this.mqmd.getOffset());
                newmqmd.setOriginalLength(this.mqmd.getOriginalLength());
                newmqmd.setPersistence(this.mqmd.getPersistence());
                newmqmd.setPriority(this.mqmd.getPriority());
                newmqmd.setPutApplName(this.mqmd.getPutApplName());
                newmqmd.setPutApplType(this.mqmd.getPutApplType());
                newmqmd.setPutDate(this.mqmd.getPutDate());
                newmqmd.setPutTime(this.mqmd.getPutTime());
                newmqmd.setReplyToQ(this.mqmd.getReplyToQ());
                newmqmd.setReplyToQMgr(this.mqmd.getReplyToQMgr());
                newmqmd.setReport(this.mqmd.getReport());
                newmqmd.setUserIdentifier(this.mqmd.getUserIdentifier());
                newmqmd.setVersion(this.mqmd.getVersion());
                ByteBuffer[] newbuffers = this.duplicate(this.buffers);
                clone = new PoisonMessage(newmqmd, newbuffers);
                newbuffers = this.duplicate(this.buffers);
                this.buffers = newbuffers;
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "clone()", je);
                }
                HashMap info = WMQPoison.this.ffstInfo();
                info.put("exception", je);
                Trace.ffst(this, "clone", "XN00S00E", info, null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "clone()", clone);
            }
            return clone;
        }

        private ByteBuffer[] duplicate(ByteBuffer[] src) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "duplicate(ByteBuffer [ ])", new Object[]{src});
            }
            ByteBuffer[] newbuffers = new ByteBuffer[src.length];
            for (int i = 0; i < src.length; ++i) {
                ByteBuffer newbuff = ByteBuffer.allocate(src[i].capacity());
                src[i].rewind();
                byte[] array = src[i].array();
                byte[] newarray = new byte[array.length];
                System.arraycopy(array, 0, newarray, 0, array.length);
                newbuff.put(newarray);
                newbuff.limit(src[i].limit());
                newbuffers[i] = newbuff;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.PoisonMessage", "duplicate(ByteBuffer [ ])", newbuffers);
            }
            return newbuffers;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            try {
                buff.append(super.toString());
                buff.append(" mqmd=" + (this.mqmd == null ? "<null>" : this.mqmd.toString()));
                buff.append(" buffers=" + (this.buffers == null ? "<null>" : Arrays.asList(this.buffers).toString()));
                buff.append(" wmqMsg=" + (this.wmqMsg == null ? "<null>" : this.wmqMsg.toString()));
                buff.append(" targetDestination=" + (this.targetDestination == null ? "<null>" : this.targetDestination.toURI()));
            }
            catch (Exception e) {
                buff.append("Unknown");
            }
            return buff.toString();
        }
    }

    private class QmAttrs {
        private String deadLetterQ;
        private WMQDestination deadLetterQDestination;

        private QmAttrs() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.QmAttrs", "<init>()");
            }
            Phobj pHobjQM = WMQPoison.this.env.newPhobj();
            MQOD od = WMQPoison.this.env.newMQOD();
            od.setObjectType(5);
            int opts = 8224;
            WMQPoison.this.mq.MQOPEN(WMQPoison.this.hconn, od, opts, pHobjQM, WMQPoison.this.cc, WMQPoison.this.rc);
            WMQPoison.this.checkJmqiCallSuccess("MQOPEN", "JMSWMQ0031", null, WMQPoison.this.cc, WMQPoison.this.rc, "XN00S00B");
            int[] pSelectors = new int[]{2006};
            byte[] pCharAttrs = new byte[48];
            WMQPoison.this.mq.MQINQ(WMQPoison.this.hconn, pHobjQM.getHobj(), pSelectors.length, pSelectors, 0, null, pCharAttrs.length, pCharAttrs, WMQPoison.this.cc, WMQPoison.this.rc);
            WMQPoison.this.checkJmqiCallSuccess("MQINQ", "JMSWMQ0031", null, WMQPoison.this.cc, WMQPoison.this.rc, "XN00S00C");
            int ccsid = 0;
            try {
                ccsid = WMQPoison.this.hconn.getCcsid();
                this.deadLetterQ = JmqiUtils.qmgrBytesToString((JmqiEnvironment)WMQPoison.this.env, (Hconn)WMQPoison.this.hconn, (byte[])pCharAttrs, (int)0, (int)48);
                this.deadLetterQ = WMQPoison.trim(this.deadLetterQ);
                this.deadLetterQDestination = new WMQDestination(1, this.deadLetterQ, null);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.QmAttrs", "<init>()", e);
                }
                HashMap<String, Integer> inserts = new HashMap<String, Integer>();
                inserts.put("CCSID", new Integer(ccsid));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ0034", inserts));
                je.setLinkedException(e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.QmAttrs", "<init>()", je);
                }
                throw je;
            }
            WMQPoison.this.mq.MQCLOSE(WMQPoison.this.hconn, pHobjQM, 0, WMQPoison.this.cc, WMQPoison.this.rc);
            WMQPoison.this.checkJmqiCallSuccess("MQCLOSE", "JMSWMQ0031", null, WMQPoison.this.cc, WMQPoison.this.rc, "XN00S00D");
            if (Trace.isOn) {
                Trace.data(this, "QmAttrs", "<init>", "attrs", this);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.QmAttrs", "<init>()");
            }
        }

        public String toString() {
            StringBuffer buff = new StringBuffer(super.toString());
            buff.append(" deadLetterQ:" + (this.deadLetterQ == null ? "<null>" : this.deadLetterQ));
            return buff.toString();
        }
    }

    private class DestinationAttrs {
        private int BOThresh;
        private String BORQName;
        private WMQDestination BORQDestination;
        private String baseQName;

        private DestinationAttrs() throws JMSException {
            this(this$0.destination.getName(), this$0.destination.isQueue(), 1);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.DestinationAttrs", "<init>()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.DestinationAttrs", "<init>()");
            }
        }

        private DestinationAttrs(String destname, boolean isQueue, int depth) throws JMSException {
            int type;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.DestinationAttrs", "<init>(String,boolean,int)", new Object[]{destname, isQueue, new Integer(depth)});
            }
            Hobj hobj = null;
            Phobj pHobjQueue = null;
            if (isQueue) {
                pHobjQueue = WMQPoison.this.env.newPhobj();
                MQOD od = WMQPoison.this.computeOD(destname, null);
                int opts = 8224;
                WMQPoison.this.mq.MQOPEN(WMQPoison.this.hconn, od, opts, pHobjQueue, WMQPoison.this.cc, WMQPoison.this.rc);
                WMQPoison.this.checkJmqiCallSuccess("MQOPEN", "JMSWMQ0030", destname, WMQPoison.this.cc, WMQPoison.this.rc, "XN00S008");
                hobj = pHobjQueue.getHobj();
            } else {
                hobj = WMQPoison.this.consumersHobj;
            }
            int[] pSelectors = new int[]{22, 20, 2019, 2002};
            int[] pIntAttrs = new int[2];
            byte[] pCharAttrs = new byte[96];
            WMQPoison.this.mq.MQINQ(WMQPoison.this.hconn, hobj, pSelectors.length, pSelectors, pIntAttrs.length, pIntAttrs, pCharAttrs.length, pCharAttrs, WMQPoison.this.cc, WMQPoison.this.rc);
            if (((WMQPoison)WMQPoison.this).rc.x != 0 && ((WMQPoison)WMQPoison.this).rc.x != 2068) {
                WMQPoison.this.checkJmqiCallSuccess("MQINQ", "JMSWMQ0030", destname, WMQPoison.this.cc, WMQPoison.this.rc, "XN00S009");
            }
            if ((type = pIntAttrs[1]) == 7) {
                WMQPoison.this.mq.MQCLOSE(WMQPoison.this.hconn, pHobjQueue, 0, WMQPoison.this.cc, WMQPoison.this.rc);
                hobj = null;
                pHobjQueue = null;
                pHobjQueue = WMQPoison.this.env.newPhobj();
                MQOD od = WMQPoison.this.computeOD(destname, null);
                int opts = 8225;
                WMQPoison.this.mq.MQOPEN(WMQPoison.this.hconn, od, opts, pHobjQueue, WMQPoison.this.cc, WMQPoison.this.rc);
                WMQPoison.this.checkJmqiCallSuccess("MQOPEN", "JMSWMQ0030", destname, WMQPoison.this.cc, WMQPoison.this.rc, "XN00S008");
                hobj = pHobjQueue.getHobj();
                WMQPoison.this.mq.MQINQ(WMQPoison.this.hconn, hobj, pSelectors.length, pSelectors, pIntAttrs.length, pIntAttrs, pCharAttrs.length, pCharAttrs, WMQPoison.this.cc, WMQPoison.this.rc);
                if (((WMQPoison)WMQPoison.this).rc.x != 0 && ((WMQPoison)WMQPoison.this).rc.x != 2068) {
                    WMQPoison.this.checkJmqiCallSuccess("MQINQ", "JMSWMQ0030", destname, WMQPoison.this.cc, WMQPoison.this.rc, "XN00S009");
                }
                type = pIntAttrs[1];
            }
            this.BOThresh = pIntAttrs[0];
            int ccsid = 0;
            try {
                ccsid = WMQPoison.this.hconn.getCcsid();
                this.BORQName = JmqiUtils.qmgrBytesToString((JmqiEnvironment)WMQPoison.this.env, (Hconn)WMQPoison.this.hconn, (byte[])pCharAttrs, (int)0, (int)48);
                this.BORQName = WMQPoison.trim(this.BORQName);
                this.BORQDestination = new WMQDestination(1, this.BORQName, null);
                this.baseQName = JmqiUtils.qmgrBytesToString((JmqiEnvironment)WMQPoison.this.env, (Hconn)WMQPoison.this.hconn, (byte[])pCharAttrs, (int)48, (int)48);
                this.baseQName = WMQPoison.trim(this.baseQName);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.DestinationAttrs", "<init>(String,boolean,int)", e);
                }
                HashMap<String, Object> inserts = new HashMap<String, Object>();
                inserts.put("XMSC_DESTINATION_NAME", destname);
                inserts.put("CCSID", new Integer(ccsid));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ0033", inserts));
                je.setLinkedException(e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.DestinationAttrs", "<init>(String,boolean,int)", je);
                }
                throw je;
            }
            if (isQueue) {
                WMQPoison.this.mq.MQCLOSE(WMQPoison.this.hconn, pHobjQueue, 0, WMQPoison.this.cc, WMQPoison.this.rc);
                WMQPoison.this.checkJmqiCallSuccess("MQCLOSE", "JMSWMQ0030", destname, WMQPoison.this.cc, WMQPoison.this.rc, "XN00S00A");
            }
            if (type == 3 && this.baseQName != null && depth == 1) {
                try {
                    PropertyStore.register(WMQPoison.useDefaultBOValues, false);
                    if (PropertyStore.getBooleanPropertyObject(WMQPoison.useDefaultBOValues).booleanValue()) {
                        this.BOThresh = 0;
                        if (Trace.isOn) {
                            Trace.traceData(this, "useDefaultBOValues = TRUE, using the default values of BOThresh and BORQ\nBOThresh = " + this.BOThresh + " BORQName = " + this.BORQName, null);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.data(this, "DestinationAttrs", "useDefaultBOValues = false. So querying BO values from the target queue", "attrs", this);
                        }
                        DestinationAttrs baseDestAttrs = new DestinationAttrs(this.baseQName, isQueue, depth + 1);
                        this.BORQName = baseDestAttrs.BORQName;
                        this.BOThresh = baseDestAttrs.BOThresh;
                        this.BORQDestination = new WMQDestination(1, this.BORQName, null);
                    }
                }
                catch (JMSException e) {
                    MQException mqe = (MQException)((Object)e.getLinkedException());
                    if (mqe != null && mqe.reasonCode == 2035) {
                        this.BOThresh = 0;
                        if (Trace.isOn) {
                            Trace.traceWarning(this, "com.ibm.msg.client.wmq.internal.WMQPoison.DestinationAttrs", "MQRC_NOT_AUTHORIZED error returned when inquiring backout details from queue referenced by alias queue", (Object)e);
                        }
                        HashMap<String, Object> inserts = new HashMap<String, Object>();
                        inserts.put("XMSC_INSERT_COMP_CODE", mqe.getErrorCode());
                        inserts.put("XMSC_INSERT_REASON", new Integer(mqe.getReason()));
                        inserts.put("XMSC_INSERT_EXCEPTION", (Object)mqe);
                        Log.log(this, "DestinationAttrs(String,Boolean,int)", "MQRC_NOT_AUTHORIZED error returned when inquiring backout details from queue referenced by alias queue", inserts);
                    }
                    throw e;
                }
            }
            if (Trace.isOn) {
                Trace.data(this, "DestinationAttrs", "<init>", "attrs", this);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.DestinationAttrs", "<init>(String,boolean,int)");
            }
        }

        public String toString() {
            StringBuffer buff = new StringBuffer(super.toString());
            buff.append(" BOThresh:" + this.BOThresh);
            buff.append(" BORQName:" + (this.BORQName == null ? "<null>" : this.BORQName));
            buff.append(" baseQName:" + (this.baseQName == null ? "<null>" : this.baseQName));
            return buff.toString();
        }
    }
}

