/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageListener;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.internal.WMQConnection;
import com.ibm.msg.client.wmq.internal.WMQConnectionBrowser;
import com.ibm.msg.client.wmq.internal.WMQMessageConsumer;
import com.ibm.msg.client.wmq.internal.WMQPoison;
import com.ibm.msg.client.wmq.internal.WMQSession;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.JMSException;

public class WMQMessageRetentionProcessor {
    private static final String NULL_SELECTOR = "<NULL>";
    private static Hashtable agents;
    private static WMQMessageRetentionProcessor retentionProcessor;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQMessageRetentionProcessor.java, jmscc.wmq, k701, k701-112-140304 1.17.1.3 10/02/24 16:35:54";

    private WMQMessageRetentionProcessor() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionProcessor", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionProcessor", "<init>()");
        }
    }

    public static WMQMessageRetentionProcessor getInstance() {
        if (retentionProcessor == null) {
            retentionProcessor = new WMQMessageRetentionProcessor();
        }
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQMessageRetentionProcessor", "getInstance()", "getter", (Object)retentionProcessor);
        }
        return retentionProcessor;
    }

    public void registerConnectionBrowser(WMQConnectionBrowser connectionBrowser, WMQDestination destination, String selector) throws JMSException {
        String destinationName;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionProcessor", "registerConnectionBrowser(WMQConnectionBrowser,WMQDestination,String)", new Object[]{connectionBrowser, destination, selector});
        }
        if (agents.contains(destinationName = destination.getStringProperty("XMSC_WMQ_QUEUE_MANAGER") + "/" + destination.getName())) {
            WMQMessageRetentionAgent consumer = (WMQMessageRetentionAgent)agents.get(destinationName);
            consumer.addBrowser(connectionBrowser, selector);
        } else {
            WMQMessageRetentionAgent consumer = new WMQMessageRetentionAgent(destination);
            String selectorString = selector;
            if (selector == null) {
                selectorString = NULL_SELECTOR;
            }
            consumer.addBrowser(connectionBrowser, selectorString);
            agents.put(destinationName, consumer);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionProcessor", "registerConnectionBrowser(WMQConnectionBrowser,WMQDestination,String)");
        }
    }

    public void removeConnectionBrowser(WMQConnectionBrowser connectionBrowser, WMQDestination destination) throws JMSException {
        WMQMessageRetentionAgent consumer;
        int numLeft;
        String destinationName;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionProcessor", "removeConnectionBrowser(WMQConnectionBrowser,WMQDestination)", new Object[]{connectionBrowser, destination});
        }
        if (agents.containsKey(destinationName = destination.getStringProperty("XMSC_WMQ_QUEUE_MANAGER") + "/" + destination.getName()) && (numLeft = (consumer = (WMQMessageRetentionAgent)agents.get(destinationName)).removeBrowser(connectionBrowser)) <= 0) {
            agents.remove(destinationName);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionProcessor", "removeConnectionBrowser(WMQConnectionBrowser,WMQDestination)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQMessageRetentionProcessor", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQMessageRetentionProcessor.java, jmscc.wmq, k701, k701-112-140304  1.17.1.3 10/02/24 16:35:54");
        }
        agents = new Hashtable();
    }

    private class WMQMessageRetentionAgent
    implements ProviderMessageListener {
        private Hashtable browsers = new Hashtable();
        private WMQMessageConsumer consumer;
        private WMQDestination destination;
        private int nullSelectors = 0;
        private WMQPoison poisonHandler;
        private WMQSession session;

        public WMQMessageRetentionAgent(WMQDestination destination) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "<init>(WMQDestination)", new Object[]{destination});
            }
            this.destination = destination;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "<init>(WMQDestination)");
            }
        }

        public void addBrowser(WMQConnectionBrowser browser, String selector) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "addBrowser(WMQConnectionBrowser,String)", new Object[]{browser, selector});
            }
            this.browsers.put(browser, selector);
            if (selector.equals(WMQMessageRetentionProcessor.NULL_SELECTOR)) {
                ++this.nullSelectors;
            }
            this.updateSelector();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "addBrowser(WMQConnectionBrowser,String)");
            }
        }

        public int removeBrowser(WMQConnectionBrowser browser) throws JMSException {
            String selector;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "removeBrowser(WMQConnectionBrowser)", new Object[]{browser});
            }
            if (WMQMessageRetentionProcessor.NULL_SELECTOR.equals(selector = (String)this.browsers.get(browser))) {
                --this.nullSelectors;
            }
            this.browsers.remove(browser);
            this.updateSelector();
            int traceRet1 = this.browsers.size();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "removeBrowser(WMQConnectionBrowser)", new Integer(traceRet1));
            }
            return traceRet1;
        }

        private void updateSelector() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "updateSelector()");
            }
            if (this.nullSelectors == 0) {
                Iterator it = this.browsers.values().iterator();
                if (it.hasNext()) {
                    StringBuffer sb = new StringBuffer("NOT((");
                    sb.append(it.next());
                    sb.append(")");
                    while (it.hasNext()) {
                        sb.append(" AND (");
                        sb.append(it.next());
                        sb.append(")");
                    }
                    sb.append(")");
                    if (this.consumer != null) {
                        this.consumer.close(false);
                    }
                    if (this.session != null) {
                        this.session.close(false);
                    }
                    WMQConnectionBrowser firstBrowser = (WMQConnectionBrowser)this.browsers.keys().nextElement();
                    WMQConnection conn = firstBrowser.getConnection();
                    JmsPropertyContext properties = null;
                    try {
                        properties = (JmsPropertyContext)firstBrowser.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "updateSelector()", e);
                        }
                        properties = firstBrowser;
                    }
                    properties.setIntProperty("XMSC_ACKNOWLEDGE_MODE", 0);
                    this.session = (WMQSession)conn.createSession(properties);
                    this.session.start();
                    this.consumer = new WMQMessageConsumer(this.destination, this.session, sb.toString(), false, firstBrowser);
                    this.consumer.setMessageListener(this);
                } else {
                    if (this.consumer != null) {
                        this.consumer.close(false);
                    }
                    if (this.session != null) {
                        this.session.close(false);
                    }
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "updateSelector()");
            }
        }

        public void onMessage(ProviderMessage message) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "onMessage(ProviderMessage)", new Object[]{message});
            }
            try {
                if (this.poisonHandler == null) {
                    this.poisonHandler = new WMQPoison(this.session, this.destination, this.consumer.getHobj(), null);
                }
                this.poisonHandler.handlePoisonMessage((WMQMessage)message, 2363);
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "onMessage(ProviderMessage)", e);
                }
                String exceptionMsg = e.getMessage();
                int substringTo = exceptionMsg.indexOf(":");
                Log.log(this, "onMessage", exceptionMsg.substring(0, substringTo), null);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageRetentionAgent", "onMessage(ProviderMessage)");
            }
        }
    }
}

