/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.jmqi.internal.JmqiTools;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageReference;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.jms.JMSException;

public class WMQMessageReference
implements ProviderMessageReference {
    private static final String ASCII = "ASCII";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EYECATCHER = "MQMR";
    private static final int MSGREF_VERSION_4 = 4;
    private static final long prime1 = 2147483587L;
    private static final long prime2 = Integer.MAX_VALUE;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQMessageReference.java, jmscc.wmq, k701, k701-112-140304 1.31.1.1 09/08/17 08:09:23";
    private WMQDestination destination;
    private String fqSubName = null;
    private int hashcode = -1;
    private ProviderMessage message = null;
    private int msgLength = 0;
    private byte[] token;
    private String managedQName = null;
    private String qMgrName = null;
    private byte[] subID;
    private int dataQuantity = 0;

    WMQMessageReference(byte[] flattened, ProviderDestination dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "<init>(byte [ ],ProviderDestination)", new Object[]{flattened, dest});
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(flattened);
            DataInputStream dis = new DataInputStream(bais);
            WMQMessageReference.checkEyeCatcherAndVersion(dis);
            WMQMessageReference.reinflateString(dis);
            this.destination = (WMQDestination)dest;
            this.token = WMQMessageReference.reinflateBytes(dis);
            this.msgLength = dis.readInt();
            this.fqSubName = WMQMessageReference.reinflateString(dis);
            this.managedQName = WMQMessageReference.reinflateString(dis);
            this.qMgrName = WMQMessageReference.reinflateString(dis);
            this.subID = WMQMessageReference.reinflateBytes(dis);
            dis.close();
            bais.close();
            this.calculateHashCode();
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "<init>(byte [ ],ProviderDestination)", ioe);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ1096", null));
            je.setLinkedException((Exception)ioe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "<init>(byte [ ],ProviderDestination)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "<init>(byte [ ],ProviderDestination)");
        }
    }

    private static void checkEyeCatcherAndVersion(DataInputStream dis) throws IOException {
        int version;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQMessageReference", "checkEyeCatcherAndVersion(DataInputStream)", new Object[]{dis});
        }
        byte[] eyeBytes = new byte[4];
        dis.readFully(eyeBytes);
        String eyecatcher = new String(eyeBytes, ASCII);
        if (!EYECATCHER.equals(eyecatcher)) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("eyecatcher", eyecatcher);
            Trace.ffst("WMQMessageReference", "checkEyeCatcherAndVersion", "XN00F005", info, IOException.class);
        }
        if (4 != (version = dis.readInt())) {
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("version", new Integer(version));
            Trace.ffst("WMQMessageReference", "checkEyeCatcherAndVersion", "XN00F006", info, IOException.class);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageReference", "checkEyeCatcherAndVersion(DataInputStream)");
        }
    }

    static String getDestinationURI(byte[] flattened) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQMessageReference", "getDestinationURI(byte [ ])", new Object[]{flattened});
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(flattened);
            DataInputStream dis = new DataInputStream(bais);
            WMQMessageReference.checkEyeCatcherAndVersion(dis);
            String destUri = WMQMessageReference.reinflateString(dis);
            dis.close();
            bais.close();
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageReference", "getDestinationURI(byte [ ])", (Object)destUri);
            }
            return destUri;
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.internal.WMQMessageReference", "getDestinationURI(byte [ ])", ioe);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ1096", null));
            je.setLinkedException((Exception)ioe);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.internal.WMQMessageReference", "getDestinationURI(byte [ ])", je);
            }
            throw je;
        }
    }

    WMQMessageReference(byte[] token, WMQDestination destination, int msgLength, byte[] subID) {
        this(token, destination, null, null, null, msgLength, subID);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "<init>(byte [ ],WMQDestination,int,byte [ ])", new Object[]{token, destination, new Integer(msgLength), subID});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "<init>(byte [ ],WMQDestination,int,byte [ ])");
        }
    }

    WMQMessageReference(byte[] token, WMQDestination destination, String managedQName, String qMgrName, int msgLength, byte[] subID) {
        this(token, destination, managedQName, qMgrName, null, msgLength, subID);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "<init>(byte [ ],WMQDestination,String,String,int,byte [ ])", new Object[]{token, destination, managedQName, qMgrName, new Integer(msgLength), subID});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "<init>(byte [ ],WMQDestination,String,String,int,byte [ ])");
        }
    }

    WMQMessageReference(byte[] token, WMQDestination destination, String managedQName, String qMgrName, String fqSubName, int msgLength, byte[] subID) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "<init>(byte [ ],WMQDestination,String,String,String,int,byte [ ])", new Object[]{token, destination, managedQName, qMgrName, fqSubName, new Integer(msgLength), subID});
        }
        this.token = new byte[token.length];
        System.arraycopy(token, 0, this.token, 0, token.length);
        if (subID != null) {
            this.subID = new byte[subID.length];
            System.arraycopy(subID, 0, this.subID, 0, subID.length);
        }
        this.destination = destination;
        this.fqSubName = fqSubName;
        this.msgLength = msgLength;
        this.managedQName = managedQName;
        this.qMgrName = qMgrName;
        this.calculateHashCode();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "<init>(byte [ ],WMQDestination,String,String,String,int,byte [ ])");
        }
    }

    private void calculateHashCode() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "calculateHashCode()");
        }
        this.hashcode = 0;
        byte[] temp = new byte[8];
        int i = 0;
        while (i + 8 <= this.token.length) {
            System.arraycopy(this.token, i, temp, 0, 8);
            this.hashcode ^= this.hash8bytes(temp);
            i += 8;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "calculateHashCode()");
        }
    }

    public Object clone() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "clone()");
        }
        WMQMessageReference clone = new WMQMessageReference(this.token, this.destination, this.managedQName, this.qMgrName, this.fqSubName, this.msgLength, this.subID);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "clone()", clone);
        }
        return clone;
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof WMQMessageReference)) {
            return false;
        }
        WMQMessageReference wmr = (WMQMessageReference)other;
        return null != wmr.token && Arrays.equals(this.token, wmr.token);
    }

    public byte[] flatten() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "flatten()");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(EYECATCHER.getBytes(ASCII));
            dos.writeInt(4);
            WMQMessageReference.flattenString(dos, this.destination.toURI());
            WMQMessageReference.flattenBytes(dos, this.token);
            dos.writeInt(this.msgLength);
            WMQMessageReference.flattenString(dos, this.fqSubName);
            WMQMessageReference.flattenString(dos, this.managedQName);
            WMQMessageReference.flattenString(dos, this.qMgrName);
            WMQMessageReference.flattenBytes(dos, this.subID);
            dos.flush();
            baos.flush();
            byte[] bytearray = baos.toByteArray();
            dos.close();
            baos.close();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "flatten()", bytearray);
            }
            return bytearray;
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "flatten()", ioe);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ1096", null));
            je.setLinkedException((Exception)ioe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "flatten()", je);
            }
            throw je;
        }
    }

    private static void flattenBytes(DataOutputStream dos, byte[] bytes) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQMessageReference", "flattenBytes(DataOutputStream,byte [ ])", new Object[]{dos, bytes});
        }
        if (null == bytes) {
            dos.writeInt(0);
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageReference", "flattenBytes(DataOutputStream,byte [ ])", 1);
            }
            return;
        }
        dos.writeInt(bytes.length);
        dos.write(bytes);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageReference", "flattenBytes(DataOutputStream,byte [ ])", 2);
        }
    }

    private static void flattenString(DataOutputStream dos, String text) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQMessageReference", "flattenString(DataOutputStream,String)", new Object[]{dos, text});
        }
        byte[] bytes = null;
        if (null != text) {
            bytes = text.getBytes(ASCII);
        }
        WMQMessageReference.flattenBytes(dos, bytes);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageReference", "flattenString(DataOutputStream,String)");
        }
    }

    public int getDataQuantity() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "getDataQuantity()", "getter", new Integer(this.dataQuantity));
        }
        return this.dataQuantity;
    }

    void setDataQuantity(int dataQuantity) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "setDataQuantity(int)", "setter", new Integer(dataQuantity));
        }
        this.dataQuantity = dataQuantity;
    }

    WMQDestination getDestination() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "getDestination()", "getter", this.destination);
        }
        return this.destination;
    }

    public void setDestination(ProviderDestination dest) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "setDestination(ProviderDestination)", "setter", dest);
        }
        this.destination = (WMQDestination)dest;
    }

    public String getDestinationAsString() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "getDestinationAsString()", "getter", this.managedQName);
        }
        return this.managedQName;
    }

    String getFqSubName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "getFqSubName()", "getter", this.fqSubName);
        }
        return this.fqSubName;
    }

    String getManagedQName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "getManagedQName()", "getter", this.managedQName);
        }
        return this.managedQName;
    }

    String getQMgrName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "getQMgrName()", "getter", this.qMgrName);
        }
        return this.qMgrName;
    }

    public ProviderMessage getMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "getMessage()", "getter", this.message);
        }
        return this.message;
    }

    int getMsgLength() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "getMsgLength()", "getter", new Integer(this.msgLength));
        }
        return this.msgLength;
    }

    byte[] getToken() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "getToken()", "getter", this.token);
        }
        return this.token;
    }

    byte[] getSubID() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "getSubID()", "getter", this.subID);
        }
        return this.subID;
    }

    private int hash8bytes(byte[] bytes) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "hash8bytes(byte [ ])", new Object[]{bytes});
        }
        int i1 = bytes[0] & 0xFF;
        int i2 = (bytes[1] & 0xFF) << 8;
        int i3 = (bytes[2] & 0xFF) << 16;
        long l4 = (long)(bytes[3] & 0xFF) << 24;
        long w1 = (long)(i1 + i2 + i3) + l4 | 0x40404040L;
        w1 *= 2147483587L;
        w1 = w1 >>> 32 ^ w1 & 0xFFFFFFFFL;
        i1 = bytes[4] & 0xFF;
        i2 = (bytes[5] & 0xFF) << 8;
        i3 = (bytes[6] & 0xFF) << 16;
        l4 = (long)(bytes[7] & 0xFF) << 24;
        long w2 = (long)(i1 + i2 + i3) + l4 | 0x40404040L;
        w2 *= Integer.MAX_VALUE;
        w2 = w2 >>> 32 ^ w2 & 0xFFFFFFFFL;
        w1 *= w2;
        w1 = w1 >>> 32 ^ w1 & 0xFFFFFFFFL;
        int traceRet1 = (int)w1;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "hash8bytes(byte [ ])", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int hashCode() {
        return this.hashcode;
    }

    private static byte[] reinflateBytes(DataInputStream dis) throws IOException {
        int len;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQMessageReference", "reinflateBytes(DataInputStream)", new Object[]{dis});
        }
        if (0 > (len = dis.readInt())) {
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("len", new Integer(len));
            Trace.ffst("WMQMessageReference", "reinflateString", "XN00F004", info, IOException.class);
        }
        if (0 == len) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageReference", "reinflateBytes(DataInputStream)", (Object)null, 1);
            }
            return null;
        }
        byte[] bytes = new byte[len];
        dis.readFully(bytes);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageReference", "reinflateBytes(DataInputStream)", bytes, 2);
        }
        return bytes;
    }

    private static String reinflateString(DataInputStream dis) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQMessageReference", "reinflateString(DataInputStream)", new Object[]{dis});
        }
        byte[] bytes = WMQMessageReference.reinflateBytes(dis);
        String text = null;
        if (null != bytes) {
            text = new String(bytes, ASCII);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageReference", "reinflateString(DataInputStream)", (Object)text);
        }
        return text;
    }

    void setMessage(ProviderMessage message) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageReference", "setMessage(ProviderMessage)", "setter", message);
        }
        this.message = message;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("WMQMessageReference ");
        try {
            buff.append(Integer.toHexString(System.identityHashCode(this)));
            buff.append(" destination=");
            if (null == this.destination) {
                buff.append("<null>");
            } else {
                buff.append(this.destination.getName());
            }
            buff.append(" messagetoken=");
            if (this.token == null) {
                buff.append("<null>");
            } else {
                JmqiTools.arrayToHexString((byte[])this.token);
            }
            buff.append(" messagelength=");
            buff.append(this.msgLength);
            buff.append(" fqSubName=");
            if (this.fqSubName == null) {
                buff.append("<null>");
            } else {
                buff.append(this.fqSubName);
            }
            buff.append(" managedQName=");
            if (this.managedQName == null) {
                buff.append("<null>");
            } else {
                buff.append(this.managedQName);
            }
            buff.append(" qMgrName=");
            if (this.qMgrName == null) {
                buff.append("<null>");
            } else {
                buff.append(this.qMgrName);
            }
            buff.append(" subID=");
            if (this.subID == null) {
                buff.append("<null>");
            } else {
                JmqiTools.arrayToHexString((byte[])this.subID);
            }
            buff.append(" message=");
            if (this.message == null) {
                buff.append("<null>");
            } else {
                buff.append("<notnull>");
            }
        }
        catch (Throwable t) {
            buff.append("<ERROR>");
        }
        return buff.toString();
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQMessageReference", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQMessageReference.java, jmscc.wmq, k701, k701-112-140304  1.31.1.1 09/08/17 08:09:23");
        }
    }
}

