/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.MQPMO;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Hobj;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.remote.internal.ReconnectableHobj;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.SpiOpenOptions;
import com.ibm.mq.jmqi.system.zrfp.Triplet;
import com.ibm.msg.client.commonservices.trace.TableBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshalMH;
import com.ibm.msg.client.wmq.internal.WMQConnection;
import com.ibm.msg.client.wmq.internal.WMQSession;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.jms.JMSException;

public class WMQMessageProducer
extends WMQPropertyContext
implements ProviderMessageProducer {
    private static final long serialVersionUID = 2752307110812311630L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26         (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQMessageProducer.java, jmscc.wmq, k000 1.92 09/05/28 16:07:17";
    private Pint cc = null;
    private JmqiEnvironment env;
    private Hconn hconn = null;
    private boolean isClosed = false;
    private JmqiMQ mq;
    private JmqiSP mqSPI;
    private Pint rc = null;
    private WMQSession session = null;
    private ProducerShadow shadow = null;

    WMQMessageProducer(WMQSession session, WMQDestination destination, JmsPropertyContext propertyContext) throws JMSException {
        super(propertyContext);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "<init>(WMQSession,WMQDestination,JmsPropertyContext)", new Object[]{session, destination, propertyContext});
        }
        WMQFFSTInfo.addProducer(this);
        this.session = session;
        this.ensureNonNull("ctor", "Producer's session", this.session);
        this.env = session.getJmqiEnvironment();
        this.ensureNonNull("ctor", "Session's JmqiEnvironment", this.env);
        this.hconn = session.getHconn();
        this.ensureNonNull("ctor", "Session's Hconn", this.hconn);
        this.mq = session.getJmqiMQ();
        this.mqSPI = (JmqiSP)this.mq;
        this.ensureNonNull("ctor", "Session's JmqiMQ", this.mq);
        this.cc = this.env.newPint();
        this.rc = this.env.newPint();
        this.shadow = this.getShadowInstance(destination);
        this.shadow.initialise();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "<init>(WMQSession,WMQDestination,JmsPropertyContext)");
        }
    }

    private void checkJmqiCallSuccess(String messageid, WMQDestination destination, String probeid) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "checkJmqiCallSuccess(String,WMQDestination,String)", new Object[]{messageid, destination, probeid});
        }
        this.checkJmqiCallSuccess(messageid, destination, probeid, this.cc, this.rc);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "checkJmqiCallSuccess(String,WMQDestination,String)");
        }
    }

    private void checkJmqiCallSuccess(String messageid, WMQDestination destination, String probeid, Pint cc, Pint rc) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "checkJmqiCallSuccess(String,WMQDestination,String,Pint,Pint)", new Object[]{messageid, destination, probeid, cc, rc});
        }
        if (rc.x != 0 || cc.x != 0) {
            if (Reason.isImpossibleReason(rc.x, cc.x)) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("messageid", messageid);
                info.put("destination name", destination.getName());
                info.put("reason", (String)rc);
                info.put("compcode", (String)cc);
                info.put("hconn", (String)this.hconn);
                Trace.ffst(this, "checkJmqiCallSuccess", probeid, info, JMSException.class);
            }
            if (Reason.isConnectionBroken(rc.x)) {
                JMSException e = Reason.createException("JMSWMQ1107", null, rc.x, cc.x, this.env);
                ((WMQConnection)this.session.getConnection()).driveExceptionListener(e, true);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_DESTINATION_NAME", destination.getName());
            JMSException je = Reason.createException(messageid, inserts, rc.x, cc.x, this.env);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "checkJmqiCallSuccess(String,WMQDestination,String,Pint,Pint)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "checkJmqiCallSuccess(String,WMQDestination,String,Pint,Pint)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean closingFromSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "close(boolean)", new Object[]{closingFromSession});
        }
        try {
            if (this.isClosed) {
                if (Trace.isOn) {
                    Trace.data(this, "close()", "Producer already closed. Early return.", null);
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "close(boolean)", 1);
                }
                return;
            }
            this.shadow.close();
            this.isClosed = true;
        }
        finally {
            WMQFFSTInfo.removeProducer(this);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "close(boolean)", 2);
        }
    }

    private void ensureNonNull(String methodName, String name, Object object) throws JMSException {
        if (object == null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("methodName", methodName);
            info.put("object", name);
            info.put("message", "Object is null");
            Trace.ffst(this, "ensureNonNull(String,String,Object)", "XN005001", info, JMSException.class);
        }
    }

    protected WMQSession getSession() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "getSession()", "getter", this.session);
        }
        return this.session;
    }

    private ProducerShadow getShadowInstance(WMQDestination destination) {
        ProducerShadow shadow = null;
        boolean unidentified = destination == null;
        shadow = unidentified ? new SpiUnidentifiedProducerShadow(destination) : new SpiIdentifiedProducerShadow(destination);
        return shadow;
    }

    public void send(ProviderDestination destAtSendCall, ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "send(ProviderDestination,ProviderMessage)", new Object[]{destAtSendCall, message});
        }
        this.shadow.send((WMQDestination)destAtSendCall, (WMQMessage)message);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "send(ProviderDestination,ProviderMessage)");
        }
    }

    public String toString() {
        TableBuilder builder = new TableBuilder();
        builder.append("Instance", super.toString());
        if (this.session == null) {
            builder.append("Parent Session", "<null>");
        } else {
            builder.append("Parent Session", this.session.getClass().getName() + '@' + Integer.toHexString(this.session.hashCode()));
        }
        builder.append("shadow", this.shadow);
        builder.append("isClosed", new Boolean(this.isClosed));
        return builder.toString();
    }

    public boolean providerPriorityValidate(int priority) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "providerPriorityValidate(int)", new Object[]{new Integer(priority)});
        }
        if (-1 == priority) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "providerPriorityValidate(int)", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "providerPriorityValidate(int)", false, 2);
        }
        return false;
    }

    public boolean providerTimeToLiveValidate(long timeToLive) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "providerTimeToLiveValidate(long)", new Object[]{new Long(timeToLive)});
        }
        if (-2L == timeToLive) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "providerTimeToLiveValidate(long)", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageProducer", "providerTimeToLiveValidate(long)", false, 2);
        }
        return false;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQMessageProducer", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQMessageProducer.java, jmscc.wmq, k701, k701-112-140304  1.96.1.11 10/08/31 10:28:22");
        }
    }

    class SpiUnidentifiedProducerShadow
    extends ProducerShadow {
        SpiUnidentifiedProducerShadow(WMQDestination dest) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.SpiUnidentifiedProducerShadow", "<init>(WMQDestination)", new Object[]{dest});
            }
            this.identified = false;
            this.destination = dest;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.SpiUnidentifiedProducerShadow", "<init>(WMQDestination)");
            }
        }

        void close() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.SpiUnidentifiedProducerShadow", "close()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.SpiUnidentifiedProducerShadow", "close()");
            }
        }

        void initialise() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.SpiUnidentifiedProducerShadow", "initialise()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.SpiUnidentifiedProducerShadow", "initialise()");
            }
        }

        void sendInternal(MQMD md, ByteBuffer[] buffers, Triplet[] triplets) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.SpiUnidentifiedProducerShadow", "sendInternal(MQMD,ByteBuffer [ ],Triplet [ ])", new Object[]{md, buffers, triplets});
            }
            this.mqod = WMQMessageProducer.this.env.newMQOD();
            this.updateMQOD();
            if (triplets == null) {
                WMQMessageProducer.this.mqSPI.jmqiPut1(WMQMessageProducer.this.hconn, this.mqod, md, this.pmo, buffers, WMQMessageProducer.this.cc, WMQMessageProducer.this.rc);
            } else {
                WMQMessageProducer.this.mqSPI.jmqiPut1WithTriplets(WMQMessageProducer.this.hconn, this.mqod, md, this.pmo, buffers, triplets, WMQMessageProducer.this.cc, WMQMessageProducer.this.rc);
            }
            WMQMessageProducer.this.checkJmqiCallSuccess("JMSWMQ2007", this.destination, "XN005005");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.SpiUnidentifiedProducerShadow", "sendInternal(MQMD,ByteBuffer [ ],Triplet [ ])");
            }
        }
    }

    class SpiIdentifiedProducerShadow
    extends ProducerShadow {
        private Hobj destinationHobj;

        SpiIdentifiedProducerShadow(WMQDestination dest) {
            this.destinationHobj = null;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.SpiIdentifiedProducerShadow", "<init>(WMQDestination)", new Object[]{dest});
            }
            this.identified = true;
            this.destination = dest;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.SpiIdentifiedProducerShadow", "<init>(WMQDestination)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.SpiIdentifiedProducerShadow", "close()");
            }
            int closeOptions = 0;
            Pint cc = WMQMessageProducer.this.env.newPint();
            Pint rc = WMQMessageProducer.this.env.newPint();
            Phobj phobj = WMQMessageProducer.this.env.newPhobj();
            phobj.setHobj(this.destinationHobj);
            WMQMessageProducer.this.session.incrementCloseCounter();
            Object object = WMQMessageProducer.this.session.getHconnLock();
            synchronized (object) {
                boolean didSuspend;
                block10: {
                    didSuspend = WMQMessageProducer.this.session.suspendAsyncService();
                    try {
                        WMQMessageProducer.this.mq.MQCLOSE(WMQMessageProducer.this.hconn, phobj, closeOptions, cc, rc);
                        Object var8_7 = null;
                        if (!Trace.isOn) break block10;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.SpiIdentifiedProducerShadow", "close()");
                        }
                        WMQMessageProducer.this.session.decrementCloseCounter();
                        if (didSuspend) {
                            WMQMessageProducer.this.session.resumeAsyncService();
                        }
                        WMQMessageProducer.this.session.getHconnLock().notify();
                        throw throwable;
                    }
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.SpiIdentifiedProducerShadow", "close()");
                }
                WMQMessageProducer.this.session.decrementCloseCounter();
                if (didSuspend) {
                    WMQMessageProducer.this.session.resumeAsyncService();
                }
                WMQMessageProducer.this.session.getHconnLock().notify();
            }
            WMQMessageProducer.this.checkJmqiCallSuccess(this.destination.isQueue() ? "JMSWMQ2000" : "JMSWMQ2003", this.destination, "XN005002", cc, rc);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.SpiIdentifiedProducerShadow", "close()");
            }
        }

        void initialise() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.SpiIdentifiedProducerShadow", "initialise()");
            }
            this.mqod = WMQMessageProducer.this.env.newMQOD();
            this.updateMQOD();
            Phobj phobj = null;
            SpiOpenOptions spiOO = null;
            while (true) {
                Hobj hobj;
                int openOptions = 16;
                int fiq = this.destination.getIntProperty("failIfQuiesce");
                if (fiq == 1) {
                    if (Trace.isOn) {
                        Trace.data(this, "initialise()", "Open fail-if-quiesce = yes", null);
                    }
                    openOptions |= 0x2000;
                } else {
                    if (Trace.isOn) {
                        Trace.data(this, "initialise()", "Open fail-if-quiesce = no", null);
                    }
                    openOptions &= 0xFFFFDFFF;
                }
                int messageContextOptions = this.computeMessageContextOptions();
                phobj = WMQMessageProducer.this.env.newPhobj();
                spiOO = ((JmqiSystemEnvironment)WMQMessageProducer.this.env).newSpiOpenOptions();
                spiOO.setOptions(openOptions |= messageContextOptions);
                ((JmqiSP)WMQMessageProducer.this.mq).spiOpen(WMQMessageProducer.this.hconn, this.mqod, spiOO, phobj, WMQMessageProducer.this.cc, WMQMessageProducer.this.rc);
                if (((WMQMessageProducer)WMQMessageProducer.this).rc.x == 0 && ((WMQMessageProducer)WMQMessageProducer.this).cc.x == 0 && this.destination.isQueue() && this.destination.getName() != null && !this.destination.getName().equals(this.mqod.getObjectName().trim())) {
                    WMQMessageProducer.this.mq.MQCLOSE(WMQMessageProducer.this.hconn, phobj, 0, WMQMessageProducer.this.cc, WMQMessageProducer.this.rc);
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_DESTINATION_NAME", this.destination.getName());
                    JMSException je = Reason.createException("JMSWMQ2022", inserts, 2152, 2, WMQMessageProducer.this.env);
                    throw je;
                }
                if (this.destination.isTemporary() && (hobj = phobj.getHobj()) instanceof ReconnectableHobj) {
                    ((ReconnectableHobj)hobj).setModelQueueName(WMQMessageProducer.this.session.getConnection().getStringProperty("XMSC_WMQ_TEMPORARY_MODEL"));
                }
                if (((WMQMessageProducer)WMQMessageProducer.this).cc.x == 0 || ((WMQMessageProducer)WMQMessageProducer.this).rc.x != 2087) break;
                this.mqod.setObjectQMgrName(null);
            }
            WMQMessageProducer.this.checkJmqiCallSuccess(this.destination.isQueue() ? "JMSWMQ2008" : "JMSWMQ2006", this.destination, "XN005003");
            this.destinationHobj = phobj.getHobj();
            WMQMessageProducer.this.ensureNonNull("initialise", "Destination hobj after MQOPEN", this.destinationHobj);
            this.defaultPutResponseType = spiOO.getDefPutResponseType();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.SpiIdentifiedProducerShadow", "initialise()");
            }
        }

        void sendInternal(MQMD md, ByteBuffer[] buffers, Triplet[] triplets) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.SpiIdentifiedProducerShadow", "sendInternal(MQMD,ByteBuffer [ ],Triplet [ ])", new Object[]{md, buffers, triplets});
            }
            if (triplets == null) {
                WMQMessageProducer.this.mqSPI.jmqiPut(WMQMessageProducer.this.hconn, this.destinationHobj, md, this.pmo, buffers, WMQMessageProducer.this.cc, WMQMessageProducer.this.rc);
            } else {
                WMQMessageProducer.this.mqSPI.jmqiPutWithTriplets(WMQMessageProducer.this.hconn, this.destinationHobj, md, this.pmo, buffers, triplets, WMQMessageProducer.this.cc, WMQMessageProducer.this.rc);
            }
            WMQMessageProducer.this.checkJmqiCallSuccess("JMSWMQ2007", this.destination, "XN005004");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.SpiIdentifiedProducerShadow", "sendInternal(MQMD,ByteBuffer [ ],Triplet [ ])");
            }
        }
    }

    abstract class ProducerShadow {
        WMQDestination destination = null;
        boolean identified;
        WMQDestination lastUsedDestination = null;
        MQOD mqod = null;
        MQPMO pmo = null;
        private WMQSendMarshal sendMarshal = null;
        int defaultPutResponseType = -1;

        ProducerShadow() {
        }

        abstract void close() throws JMSException;

        void computePMO(WMQMessage message) throws JMSException {
            int retain;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.ProducerShadow", "computePMO(WMQMessage)", new Object[]{message});
            }
            if (this.pmo == null) {
                this.pmo = WMQMessageProducer.this.env.newMQPMO();
            }
            if (this.destination != this.lastUsedDestination) {
                int options = 0;
                if (WMQMessageProducer.this.session.getTransacted()) {
                    if (Trace.isOn) {
                        Trace.data(this, "computePMO()", "Put under syncpoint = true", null);
                    }
                    options |= 2;
                } else {
                    if (Trace.isOn) {
                        Trace.data(this, "computePMO()", "Put under syncpoint = false", null);
                    }
                    options |= 4;
                }
                int putAsyncValue = this.destination.getIntProperty("putAsyncAllowed");
                switch (putAsyncValue) {
                    case 1: {
                        if (Trace.isOn) {
                            Trace.data(this, "computePMO()", "Sync or Async put = MQPMO_ASYNC_RESPONSE", null);
                        }
                        options |= 0x10000;
                        break;
                    }
                    case 0: {
                        if (Trace.isOn) {
                            Trace.data(this, "computePMO()", "Sync or Async put = MQPMO_SYNC_RESPONSE", null);
                        }
                        options |= 0x20000;
                        break;
                    }
                    default: {
                        if (this.destination.isTopic()) {
                            if (Trace.isOn) {
                                Trace.data(this, "computePMO()", "Sync or Async put = MQPMO_RESPONSE_AS_TOPIC_DEF", null);
                            }
                            options |= 0;
                            break;
                        }
                        if (Trace.isOn) {
                            Trace.data(this, "computePMO()", "Sync or Async put = MQPMO_RESPONSE_AS_Q_DEF", null);
                        }
                        options |= 0;
                    }
                }
                int fiq = this.destination.getIntProperty("failIfQuiesce");
                if (fiq == 1) {
                    if (Trace.isOn) {
                        Trace.data(this, "computePMO()", "Put fail-if-quiesce = yes", null);
                    }
                    options |= 0x2000;
                } else {
                    if (Trace.isOn) {
                        Trace.data(this, "computePMO()", "Put fail-if-quiesce = no", null);
                    }
                    options &= 0xFFFFDFFF;
                }
                int messageContextOptions = this.computeMessageContextOptions();
                options |= messageContextOptions;
                if (Trace.isOn) {
                    Trace.data(this, "computePMO()", "PMO options", (Object)new Integer(options));
                }
                this.pmo.setOptions(options);
                this.lastUsedDestination = this.destination;
            }
            boolean newMessageId = true;
            newMessageId = this.destination.getBooleanProperty("mdWriteEnabled") ? !message.propertyExists("JMS_IBM_MQMD_MsgId") : true;
            int pmoOptions = this.pmo.getOptions();
            pmoOptions = newMessageId ? (pmoOptions |= 0x40) : (pmoOptions &= 0xFFFFFFBF);
            this.pmo.setOptions(pmoOptions);
            if (this.destination.isTopic() && message.propertyExists("JMS_IBM_Retain") && (retain = message.getIntProperty("JMS_IBM_Retain")) == 1) {
                if (Trace.isOn) {
                    Trace.data(this, "computePMO()", "Retained publication: using MQPMO_RETAIN", null);
                }
                int options = this.pmo.getOptions();
                this.pmo.setOptions(options |= 0x200000);
                this.lastUsedDestination = null;
            }
            if (this.sendMarshal instanceof WMQSendMarshalMH && this.pmo.getVersion() < 3) {
                this.pmo.setVersion(3);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.ProducerShadow", "computePMO(WMQMessage)");
            }
        }

        int computeMessageContextOptions() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.ProducerShadow", "computeMessageContextOptions()");
            }
            int messageContextOptions = 0;
            int value = this.destination.getIntProperty("mdMessageContext");
            messageContextOptions = value == 1 ? 1024 : (value == 2 ? 2048 : 0);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.ProducerShadow", "computeMessageContextOptions()", new Integer(messageContextOptions));
            }
            return messageContextOptions;
        }

        void informSession() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.ProducerShadow", "informSession()");
            }
            int pmoOptions = this.pmo.getOptions();
            if (Trace.isOn) {
                Trace.data(this, "informSession()", "PMO options read", (Object)new Integer(pmoOptions));
            }
            boolean underSyncpoint = (pmoOptions & 2) == 2;
            WMQConsumerOwner.Operation op = null;
            if ((pmoOptions & 0x20000) == 131072) {
                op = WMQConsumerOwner.Operation.SYNCPUT;
            } else if ((pmoOptions & 0x10000) == 65536) {
                op = WMQConsumerOwner.Operation.ASYNCPUT;
            } else if ((pmoOptions & 0) == 0) {
                op = this.defaultPutResponseType == 1 ? WMQConsumerOwner.Operation.SYNCPUT : WMQConsumerOwner.Operation.ASYNCPUT;
            }
            WMQMessageProducer.this.session.operationPerformed(op, underSyncpoint);
            if (Trace.isOn) {
                Trace.data(this, "informSession()", op == WMQConsumerOwner.Operation.SYNCPUT ? "Heuristic says last put was sync" : "Heuristic says last put was Async", null);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.ProducerShadow", "informSession()");
            }
        }

        abstract void initialise() throws JMSException;

        void send(WMQDestination destAtSendCall, WMQMessage message) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.ProducerShadow", "send(WMQDestination,WMQMessage)", new Object[]{destAtSendCall, message});
            }
            if (this.identified) {
                if (destAtSendCall != null && this.destination != destAtSendCall) {
                    HashMap<String, WMQDestination> info = new HashMap<String, WMQDestination>();
                    info.put("destination at instantiation time", this.destination);
                    info.put("destination at send call", destAtSendCall);
                    Trace.ffst(this, "send(WMQDestination,WMQMessage)", "XN005006", info, class$javax$jms$JMSException == null ? (class$javax$jms$JMSException = WMQMessageProducer.class$("javax.jms.JMSException")) : class$javax$jms$JMSException);
                }
            } else {
                this.destination = destAtSendCall;
            }
            if (this.destination.isTopic()) {
                WMQConnection connection = (WMQConnection)WMQMessageProducer.this.session.getConnection();
                WMQMessageProducer.this.ensureNonNull("send", "producer's connection", connection);
                message.setStringProperty("JMS_IBM_ConnectionID", connection.getHconn().getConnectionIdAsString());
            }
            if (this.sendMarshal == null) {
                this.sendMarshal = WMQMarshal.newSendMarshal(WMQMessageProducer.this.session, false);
            }
            this.sendMarshal.importProviderMessage(WMQMessageProducer.this.session, message, this.destination);
            MQMD md = this.sendMarshal.exportMQMD();
            WMQMessageProducer.this.ensureNonNull("send", "MD for message to put", md);
            ByteBuffer[] buffers = this.sendMarshal.exportMessageBuffers();
            Triplet[] triplets = null;
            if (this.sendMarshal instanceof WMQSendMarshalMH) {
                WMQSendMarshalMH sm = (WMQSendMarshalMH)this.sendMarshal;
                triplets = sm.getTriplets();
            }
            this.computePMO(message);
            this.sendInternal(md, buffers, triplets);
            this.informSession();
            this.sendMarshal.informSendMarshal(md);
            this.sendMarshal.resetSendState();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.ProducerShadow", "send(WMQDestination,WMQMessage)");
            }
        }

        abstract void sendInternal(MQMD var1, ByteBuffer[] var2, Triplet[] var3) throws JMSException;

        void updateMQOD() throws JMSException {
            String qmName;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.ProducerShadow", "updateMQOD()");
            }
            if ((qmName = this.destination.getStringProperty("XMSC_WMQ_QUEUE_MANAGER")) != null && qmName.length() > 0) {
                this.mqod.setObjectQMgrName(qmName);
            }
            if (this.destination.isQueue()) {
                if (Trace.isOn) {
                    Trace.data(this, "updateMQOD()", "Messaging style for this send: Point-to-point", (Object)this.destination.toURI());
                }
                this.mqod.setObjectType(1);
                this.mqod.setObjectName(this.destination.getName());
            } else if (this.destination.isTopic()) {
                if (Trace.isOn) {
                    Trace.data(this, "updateMQOD()", "Messaging style for this send: Publish/Subscribe", (Object)this.destination.toURI());
                }
                this.mqod.setVersion(4);
                this.mqod.setObjectType(8);
                this.mqod.getObjectString().setVsString(this.destination.getName());
                this.mqod.getObjectString().setVsBufSize(10240);
                String streamName = WMQMessageProducer.this.getStringProperty("XMSC_WMQ_BROKER_PUBQ");
                if (!streamName.equals("SYSTEM.BROKER.DEFAULT.STREAM")) {
                    this.mqod.setObjectName(streamName);
                }
            } else {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("methodName", "updateMQOD()");
                info.put("message", "destination type is unexpected");
                info.put("destination", this.destination);
                Trace.ffst(this, "updateMQOD()", "XN005007", info, class$javax$jms$JMSException == null ? (class$javax$jms$JMSException = WMQMessageProducer.class$("javax.jms.JMSException")) : class$javax$jms$JMSException);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.ProducerShadow", "updateMQOD()");
            }
        }
    }
}

