/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.constants.CMQC;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.MQSD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Hobj;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.LpiSD;
import com.ibm.msg.client.commonservices.ReentrantMutex;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.TableBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.provider.ProviderMessageListener;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.common.internal.WMQCommonConnection;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow;
import com.ibm.msg.client.wmq.internal.WMQConnection;
import com.ibm.msg.client.wmq.internal.WMQConsumerShadow;
import com.ibm.msg.client.wmq.internal.WMQPoison;
import com.ibm.msg.client.wmq.internal.WMQSession;
import com.ibm.msg.client.wmq.internal.WMQSyncConsumerShadow;
import java.io.Serializable;
import java.util.HashMap;
import javax.jms.JMSException;

public class WMQMessageConsumer
extends WMQPropertyContext
implements ProviderMessageConsumer {
    private static final long serialVersionUID = 2284996314173494058L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQMessageConsumer.java, jmscc.wmq, k000 1.97 09/03/30 10:20:54";
    private WMQAsyncConsumerShadow asyncShadow = null;
    private WMQConsumerShadow currentShadow = null;
    private WMQDestination destination;
    private boolean nolocal;
    private String selector;
    private WMQSession session;
    private String subscriptionName;
    private WMQSyncConsumerShadow syncShadow = null;
    private WMQPoison poison = null;

    static void checkJmqiCallSuccess(String messageid, String insert, String insertKey, Pint completionCode, Pint reason, JmqiEnvironment environment, String probeid, WMQCommonConnection commonConnection, Hconn hconn) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "checkJmqiCallSuccess(String,String,String,Pint,Pint,JmqiEnvironment,String,WMQCommonConnection,Hconn)", new Object[]{messageid, insert, insertKey, completionCode, reason, environment, probeid, commonConnection, hconn});
        }
        if (reason.x != 0 || completionCode.x != 0) {
            if (Reason.isImpossibleReason(reason.x, completionCode.x)) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("messageid", messageid);
                info.put(insertKey, insert);
                info.put("reason", (String)reason);
                info.put("compcode", (String)completionCode);
                info.put("hconn", (String)hconn);
                Trace.ffst("WMQMessageConsumer", "checkJmqiCallSuccess", probeid, info, JMSException.class);
            }
            if (Reason.isConnectionBroken(reason.x)) {
                JMSException e = Reason.createException("JMSWMQ1107", null, reason.x, completionCode.x, environment);
                ((WMQConnection)commonConnection).driveExceptionListener(e, true);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put(insertKey, insert);
            JMSException je = Reason.createException(messageid, inserts, reason.x, completionCode.x, environment);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "checkJmqiCallSuccess(String,String,String,Pint,Pint,JmqiEnvironment,String,WMQCommonConnection,Hconn)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "checkJmqiCallSuccess(String,String,String,Pint,Pint,JmqiEnvironment,String,WMQCommonConnection,Hconn)");
        }
    }

    static void deleteDurableSubscription(WMQConsumerOwner owner, String subscriptionName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "deleteDurableSubscription(WMQConsumerOwner,String)", new Object[]{owner, subscriptionName});
        }
        JmqiMQ tempMQ = owner.getJmqiMQ();
        Hconn tempHconn = owner.getHconn();
        JmqiEnvironment tempEnv = owner.getJmqiEnvironment();
        MQSD mqsd = tempEnv.newMQSD();
        mqsd.getSubName().setVsString(subscriptionName);
        mqsd.getSubName().setVsBufSize(10240);
        LpiSD spisd = ((JmqiSystemEnvironment)tempEnv).newSpiSD();
        spisd.setDestOpenOptions(2);
        int cloneSupport = owner.getConnection().getIntProperty("XMSC_WMQ_CLONE_SUPPORT");
        if (cloneSupport == 1) {
            spisd.setOptions(16);
        }
        Pint tempCC = tempEnv.newPint();
        Pint tempRC = tempEnv.newPint();
        Phobj tempPhsub = tempEnv.newPhobj();
        Phobj tempPhobj = tempEnv.newPhobj();
        tempPhobj.setHobj(CMQC.jmqi_MQHO_NONE);
        mqsd.setOptions(556);
        ((JmqiSP)tempMQ).spiSubscribe(tempHconn, spisd, mqsd, tempPhobj, tempPhsub, tempCC, tempRC);
        WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ0025", subscriptionName, "XMSC_DESTINATION_NAME", tempCC, tempRC, tempEnv, "XN00400D", owner.getConnection(), tempHconn);
        tempMQ.MQCLOSE(tempHconn, tempPhsub, 8, tempCC, tempRC);
        WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ0025", subscriptionName, "XMSC_DESTINATION_NAME", tempCC, tempRC, tempEnv, "XN00400E", owner.getConnection(), tempHconn);
        tempMQ.MQCLOSE(tempHconn, tempPhobj, 0, tempCC, tempRC);
        WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ2000", subscriptionName, "XMSC_DESTINATION_NAME", tempCC, tempRC, tempEnv, "XN00400F", owner.getConnection(), tempHconn);
        owner.removeSubscription(subscriptionName);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "deleteDurableSubscription(WMQConsumerOwner,String)");
        }
    }

    public WMQMessageConsumer(WMQDestination destination, WMQSession session, String selector, boolean nolocal, JmsPropertyContext jmsProps) throws JMSException {
        super(jmsProps);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "<init>(WMQDestination,WMQSession,String,boolean,JmsPropertyContext)", new Object[]{destination, session, selector, nolocal, jmsProps});
        }
        this.destination = destination;
        this.session = session;
        this.selector = selector;
        this.nolocal = nolocal;
        WMQFFSTInfo.addConsumer(this);
        this.checkDestinationValidForNPHigh();
        this.syncShadow = new WMQSyncConsumerShadow(this, session, destination, selector, nolocal, this.subscriptionName);
        this.currentShadow = this.syncShadow;
        this.currentShadow.initialize();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "<init>(WMQDestination,WMQSession,String,boolean,JmsPropertyContext)");
        }
    }

    public WMQMessageConsumer(WMQDestination topic, WMQSession session, String subscriptionName, String selector, boolean nolocal, JmsPropertyContext jmsProps) throws JMSException {
        super(jmsProps);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "<init>(WMQDestination,WMQSession,String,String,boolean,JmsPropertyContext)", new Object[]{topic, session, subscriptionName, selector, nolocal, jmsProps});
        }
        this.destination = topic;
        this.session = session;
        this.selector = selector;
        this.nolocal = nolocal;
        this.subscriptionName = subscriptionName;
        WMQFFSTInfo.addConsumer(this);
        this.syncShadow = new WMQSyncConsumerShadow(this, session, this.destination, selector, nolocal, subscriptionName);
        this.currentShadow = this.syncShadow;
        this.currentShadow.initialize();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "<init>(WMQDestination,WMQSession,String,String,boolean,JmsPropertyContext)");
        }
    }

    private void checkDestinationValidForNPHigh() throws JMSException {
        int destinationPersistence;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "checkDestinationValidForNPHigh()");
        }
        if (this.destination.isQueue() && (destinationPersistence = this.destination.getIntProperty("deliveryMode")) == 3 && !WMQUtils.isNPMClassHigh(this.session, this.destination)) {
            HashMap<String, Serializable> inserts = new HashMap<String, Serializable>();
            inserts.put("XMSC_DESTINATION_NAME", this.destination);
            inserts.put("persistence", new Integer(destinationPersistence));
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ2010", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "checkDestinationValidForNPHigh()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "checkDestinationValidForNPHigh()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean closingFromSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "close(boolean)", new Object[]{closingFromSession});
        }
        try {
            Object value = this.getObjectProperty("onMessageMutex");
            ReentrantMutex onMessageMutex = null;
            if (value instanceof ReentrantMutex) {
                onMessageMutex = (ReentrantMutex)value;
            }
            this.currentShadow.close(onMessageMutex);
        }
        finally {
            WMQFFSTInfo.removeConsumer(this);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "close(boolean)");
        }
    }

    public void handlePoisonMessage(ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "handlePoisonMessage(ProviderMessage)", new Object[]{message});
        }
        this.initialisePoison();
        this.poison.handlePoisonMessage((WMQMessage)message);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "handlePoisonMessage(ProviderMessage)");
        }
    }

    public boolean shouldMessageBeRequeued(int attempts, ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "shouldMessageBeRequeued(int,ProviderMessage)", new Object[]{new Integer(attempts), message});
        }
        this.initialisePoison();
        boolean requeued = this.poison.shouldMessageBeRequeued(attempts);
        message.setIntProperty("JMSXDeliveryCount", attempts + 1);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "shouldMessageBeRequeued(int,ProviderMessage)", requeued);
        }
        return requeued;
    }

    public ProviderMessage receive(long timeOut) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "receive(long)", new Object[]{new Long(timeOut)});
        }
        ProviderMessage traceRet1 = this.currentShadow.receive(timeOut);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "receive(long)", traceRet1);
        }
        return traceRet1;
    }

    public void setMessageListener(ProviderMessageListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "setMessageListener(ProviderMessageListener)", new Object[]{listener});
        }
        if (listener != null) {
            if (this.asyncShadow == null) {
                this.asyncShadow = new WMQAsyncConsumerShadow(this, this.session, this.destination, this.selector, this.nolocal, this.subscriptionName);
            }
            this.asyncShadow.initialize(this.currentShadow);
            this.currentShadow = this.asyncShadow;
            this.currentShadow.setMessageListener(listener);
        } else {
            this.currentShadow.setMessageListener(listener);
            if (this.syncShadow == null) {
                this.syncShadow = new WMQSyncConsumerShadow(this, this.session, this.destination, this.selector, this.nolocal, this.subscriptionName);
            }
            this.syncShadow.initialize(this.currentShadow);
            this.currentShadow = this.syncShadow;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "setMessageListener(ProviderMessageListener)");
        }
    }

    public void start(boolean deliverImmediately) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "start(boolean)", new Object[]{deliverImmediately});
        }
        this.currentShadow.setRunning(true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "start(boolean)");
        }
    }

    public void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "stop()");
        }
        this.currentShadow.setRunning(false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "stop()");
        }
    }

    Hobj getHobj() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "getHobj()", "getter", this.currentShadow.hobj);
        }
        return this.currentShadow.hobj;
    }

    private void initialisePoison() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "initialisePoison()");
        }
        if (null == this.poison) {
            String subQueue = this.currentShadow.getSubscriptionQueue();
            this.poison = new WMQPoison(this.session, this.destination, this.getHobj(), subQueue);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "initialisePoison()");
        }
    }

    public String toString() {
        TableBuilder builder = new TableBuilder();
        builder.append("Instance", super.toString());
        if (this.session == null) {
            builder.append("Parent Session", "<null>");
        } else {
            builder.append("Parent Session", this.session.getClass().getName() + '@' + Integer.toHexString(this.session.hashCode()));
        }
        builder.append("destination", this.destination);
        builder.append("nolocal", new Boolean(this.nolocal));
        builder.append("selector", this.selector);
        builder.append("subcriptionName", this.subscriptionName);
        builder.append("asyncShadow", this.asyncShadow);
        builder.append("syncShadow", this.syncShadow);
        builder.append("currentShadow", this.currentShadow);
        return builder.toString();
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQMessageConsumer", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQMessageConsumer.java, jmscc.wmq, k701, k701-112-140304  1.98.1.6 11/09/06 09:25:57");
        }
    }
}

