/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.constants.CMQC;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.MQSD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Hobj;
import com.ibm.mq.jmqi.handles.PbyteBuffer;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.remote.internal.ReconnectableHobj;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.LpiNotifyDetails;
import com.ibm.mq.jmqi.system.LpiSD;
import com.ibm.mq.jmqi.system.LpiSDSubProps;
import com.ibm.mq.jmqi.system.SpiOpenOptions;
import com.ibm.msg.client.commonservices.ReentrantMutex;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageListener;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshalMH;
import com.ibm.msg.client.wmq.internal.WMQConnection;
import com.ibm.msg.client.wmq.internal.WMQMessageConsumer;
import com.ibm.msg.client.wmq.internal.WMQPoison;
import com.ibm.msg.client.wmq.internal.WMQQueueEnumeration;
import com.ibm.msg.client.wmq.internal.WMQSession;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.jms.JMSException;

abstract class WMQConsumerShadow {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQConsumerShadow.java, jmscc.wmq, k701, k701-112-140304 1.121.1.33 13/09/26 16:34:31";
    public static final String receiveConversionCCSIDPropertyName = "com.ibm.msg.client.wmq.receiveConversionCCSID";
    private int receiveCCSID = 0;
    private static final long defaultCCSID = 1208L;
    private static final Long MIN_VALID_CCSID;
    private static final Long MAX_VALID_CCSID;
    protected int gmoConvertOption = 0;
    protected boolean isBrowser = false;
    static final int MSG_LENGTH_NOT_KNOWN_IN_ADVANCE = -1;
    private static final byte[] MQMI_NONE;
    private static final String JMSCORRELATIONID = "JMSCorrelationID";
    private static final String JMSMESSAGEID = "JMSMessageID";
    private static final int ID_LENGTH = 24;
    private byte[] correlationID = null;
    private byte[] messageID = null;
    protected Hconn hconn = null;
    protected Hobj hobj = null;
    protected JmqiMQ mq = null;
    protected Phobj phobj = null;
    protected Phobj phsub = null;
    protected MQMD mqmd = null;
    protected MQGMO mqgmo = null;
    protected WMQReceiveMarshal receiveMarshal = null;
    protected WMQConsumerOwner helper;
    protected WMQDestination destination;
    protected JmqiEnvironment env = null;
    protected String selector;
    protected String subscriptionName;
    protected boolean transacted;
    protected int ackMode;
    protected boolean nolocal;
    private boolean running = true;
    protected JmsPropertyContext jmsProps = null;
    protected WMQPoison poison = null;
    private Pint dataLength = null;
    private PbyteBuffer getMessageDataBuffer = null;
    private Pint msgsTooSmallForBuffer = null;
    protected LpiSD spisd = null;
    private byte[] subID;
    static final /* synthetic */ boolean $assertionsDisabled;

    WMQConsumerShadow(JmsPropertyContext jmsProps, WMQConsumerOwner helper, WMQDestination destination, String selector, boolean nolocal, String subscriptionName, byte[] subID) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "<init>(JmsPropertyContext,WMQConsumerOwner,WMQDestination,String,boolean,String,byte [ ])", new Object[]{jmsProps, helper, destination, selector, nolocal, subscriptionName, subID});
        }
        this.helper = helper;
        this.destination = destination;
        this.selector = selector;
        this.subscriptionName = subscriptionName;
        this.env = helper.getJmqiEnvironment();
        this.hconn = helper.getHconn();
        this.mq = helper.getJmqiMQ();
        this.transacted = helper.getTransacted();
        this.ackMode = helper.getAckMode();
        this.jmsProps = jmsProps;
        this.nolocal = nolocal;
        this.msgsTooSmallForBuffer = this.env.newPint();
        this.getMessageDataBuffer = this.env.newPbyteBuffer();
        this.subID = subID;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "<init>(JmsPropertyContext,WMQConsumerOwner,WMQDestination,String,boolean,String,byte [ ])");
        }
    }

    abstract void closeInternal() throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(ReentrantMutex onMessageMutex) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "close()");
        }
        Pint rc = this.env.newPint();
        Pint cc = this.env.newPint();
        boolean asfMode = this.helper == this.helper.getConnection();
        this.helper.incrementCloseCounter();
        if (onMessageMutex != null) {
            onMessageMutex.release();
        }
        boolean asyncDidSuspend = false;
        boolean connectionDidSuspend = false;
        Object object = this.helper.getHconnLock();
        synchronized (object) {
            block26: {
                try {
                    block25: {
                        asyncDidSuspend = this.helper.suspendAsyncService();
                        if (!asfMode) {
                            connectionDidSuspend = ((WMQConnection)this.helper.getConnection()).suspendAsyncService();
                        }
                        LpiNotifyDetails notifyDetails = ((JmqiSystemEnvironment)this.env).newLpiNotifyDetails();
                        byte[] connectionID = this.helper.getHconn().getConnectionId();
                        notifyDetails.setConnectionId(connectionID);
                        notifyDetails.setVersion(1);
                        notifyDetails.setReason(2107);
                        Hconn connectionsHconn = ((WMQConnection)this.helper.getConnection()).getHconn();
                        ((JmqiSP)this.mq).jmqiNotify(connectionsHconn, this.hconn, 1, notifyDetails, cc, rc);
                        switch (rc.x) {
                            case 0: 
                            case 2107: {
                                break;
                            }
                            default: {
                                String exceptionMsg = this.destination.isTopic() ? "JMSWMQ2003" : "JMSWMQ2000";
                                WMQMessageConsumer.checkJmqiCallSuccess(exceptionMsg, this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN00P001", this.helper.getConnection(), this.hconn);
                            }
                        }
                        try {
                            if (this.destination.isQueue() && !(this instanceof WMQQueueEnumeration.WMQSyncBrowserShadow)) {
                                boolean closeQueue = this.helper.removeQueueFromCache(this.phobj);
                                if (closeQueue) {
                                    this.closeInternal();
                                }
                            } else {
                                this.closeInternal();
                            }
                            Object var13_13 = null;
                            if (!Trace.isOn) break block25;
                        }
                        catch (Throwable throwable) {
                            Object var13_14 = null;
                            if (Trace.isOn) {
                                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "close()");
                            }
                            if (this.subscriptionName != null) {
                                this.helper.removeSubscription(this.subscriptionName);
                            }
                            throw throwable;
                        }
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "close()");
                    }
                    if (this.subscriptionName != null) {
                        this.helper.removeSubscription(this.subscriptionName);
                    }
                    Object var15_16 = null;
                    this.helper.decrementCloseCounter();
                    if (asfMode || !connectionDidSuspend) break block26;
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    this.helper.decrementCloseCounter();
                    if (!asfMode && connectionDidSuspend) {
                        ((WMQConnection)this.helper.getConnection()).resumeAsyncService();
                    }
                    if (asyncDidSuspend) {
                        this.helper.resumeAsyncService();
                    }
                    this.helper.getHconnLock().notify();
                    if (onMessageMutex != null) {
                        onMessageMutex.acquire(-1);
                    }
                    throw throwable;
                }
                ((WMQConnection)this.helper.getConnection()).resumeAsyncService();
            }
            if (asyncDidSuspend) {
                this.helper.resumeAsyncService();
            }
            this.helper.getHconnLock().notify();
            if (onMessageMutex != null) {
                onMessageMutex.acquire(-1);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "close()");
        }
    }

    MQGMO computeGMO(int waitTime) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeGMO(int)", new Object[]{new Integer(waitTime)});
        }
        if (this.receiveMarshal == null) {
            this.initializeReceiveMarshal();
        }
        if (this.mqgmo == null) {
            int platform;
            block20: {
                if (Trace.isOn) {
                    Trace.data(this, "Creating a new MQGMO", null);
                }
                this.mqgmo = this.env.newMQGMO();
                int getOptions = 0;
                boolean alwaysSync = this.jmsProps.getBooleanProperty("XMSC_WMQ_SYNCPOINT_ALL_GETS");
                getOptions = this.transacted || alwaysSync || this.ackMode == 2 ? (getOptions |= 2) : (this.subscriptionName != null || this.destination.isQueue() ? (getOptions |= 0x1000) : (getOptions |= 4));
                try {
                    int fiq = this.destination.getIntProperty("failIfQuiesce");
                    if (fiq == 1) {
                        if (Trace.isOn) {
                            Trace.data(this, "Get fail-if-quiesce = yes", null);
                        }
                        getOptions |= 0x2000;
                    } else {
                        if (Trace.isOn) {
                            Trace.data(this, "Get fail-if-quiesce = no", null);
                        }
                        getOptions &= 0xFFFFDFFF;
                    }
                }
                catch (JMSException jmsex) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeGMO(int)", jmsex, 1);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeGMO(int)", jmsex);
                    }
                    throw jmsex;
                }
                getOptions |= 1;
                getOptions |= 0x2000000;
                getOptions |= this.gmoConvertOption;
                if (this.receiveMarshal instanceof WMQReceiveMarshalMH) {
                    if (this.mqgmo.getVersion() < 4) {
                        this.mqgmo.setVersion(4);
                    }
                    getOptions &= 0xFDFFFFFF;
                    getOptions |= 0x8000000;
                    long messageHandleDummy = System.identityHashCode(this.hconn) | 2;
                    this.mqgmo.setMessageHandle(messageHandleDummy);
                }
                this.mqgmo.setOptions(getOptions);
                platform = 0;
                try {
                    platform = this.hconn.getPlatform();
                }
                catch (JmqiException e) {
                    if (!Trace.isOn) break block20;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeGMO(int)", e, 2);
                }
            }
            if (platform == 1) {
                this.setMatchOptions(this.selector, this.mqgmo);
            }
        } else if (Trace.isOn) {
            Trace.data(this, "Using cached MQGMO", (Object)this.mqgmo);
        }
        this.mqgmo.setWaitInterval(waitTime);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeGMO(int)", this.mqgmo);
        }
        return this.mqgmo;
    }

    LpiSD computeLpiSD() throws JMSException {
        int cloneSupport;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeLpiSD()");
        }
        LpiSD sd = ((JmqiSystemEnvironment)this.env).newSpiSD();
        int options = this.computeQueueOpenOptions();
        sd.setDestOpenOptions(options);
        LpiSDSubProps sdSubProps = sd.getSubProps();
        sdSubProps.setPSPropertyStyle(3);
        if (this.subscriptionName != null && (cloneSupport = this.jmsProps.getIntProperty("XMSC_WMQ_CLONE_SUPPORT")) == 1) {
            if (!this.helper.isSubscriptionInUse(this.subscriptionName)) {
                int spiOptions = 16;
                sd.setOptions(spiOptions);
            } else {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_DESTINATION_NAME", this.destination.getName());
                inserts.put("XMSC_INSERT_OBJECT", this.subscriptionName);
                JMSException traceRet1 = (JMSException)((Object)NLSServices.createException("JMSWMQ2011", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeLpiSD()", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeLpiSD()", sd);
        }
        return sd;
    }

    SpiOpenOptions computeSpiOpenOptions(int queueOpenOptions) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeSpiOpenOptions(int)", new Object[]{new Integer(queueOpenOptions)});
        }
        int qoo = 0;
        SpiOpenOptions spiOO = ((JmqiSystemEnvironment)this.env).newSpiOpenOptions();
        qoo |= 1;
        spiOO.setOptions(queueOpenOptions);
        spiOO.setLpiOptions(qoo |= 2);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeSpiOpenOptions(int)", spiOO);
        }
        return spiOO;
    }

    void initialize() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "initialize()");
        }
        Pint rc = this.env.newPint();
        Pint cc = this.env.newPint();
        this.dataLength = this.env.newPint();
        this.mqmd = this.env.newMQMD();
        PropertyStore.register(receiveConversionCCSIDPropertyName, 1208L, MIN_VALID_CCSID, MAX_VALID_CCSID);
        this.setReceiveCCSID();
        this.mqmd.setCodedCharSetId(this.receiveCCSID);
        this.mqmd.setVersion(2);
        if (this.destination.isTopic()) {
            int subscriptionOptions = this.computeSubscriptionOptions();
            this.phobj = this.env.newPhobj();
            this.phsub = this.env.newPhobj();
            MQSD mqsd = this.env.newMQSD();
            this.spisd = this.computeLpiSD();
            mqsd.getResolvedObjectString().setVsBufSize(10240);
            mqsd.getSelectionString().setVsBufSize(10240);
            mqsd.getObjectString().setVsString(this.destination.getName());
            mqsd.getObjectString().setVsBufSize(10240);
            String streamName = this.jmsProps.getStringProperty("XMSC_WMQ_BROKER_PUBQ");
            if (!streamName.equals("SYSTEM.BROKER.DEFAULT.STREAM")) {
                mqsd.setObjectName(streamName);
            }
            mqsd.getSelectionString().setVsString(this.selector);
            mqsd.getSelectionString().setVsBufSize(10240);
            if (this.subscriptionName != null) {
                mqsd.getSubName().setVsString(this.subscriptionName);
                mqsd.getSubName().setVsBufSize(10240);
            }
            mqsd.setOptions(subscriptionOptions);
            this.phobj.setHobj(CMQC.jmqi_MQHO_NONE);
            ((JmqiSP)this.mq).spiSubscribe(this.hconn, this.spisd, mqsd, this.phobj, this.phsub, cc, rc);
            if (Trace.isOn) {
                StringBuffer details = new StringBuffer();
                details.append("Requested subscription details:\n");
                if (this.subscriptionName != null) {
                    details.append("Requested SubscriptionName: ");
                    details.append(this.subscriptionName);
                    details.append('\n');
                }
                details.append("Requested TopicString:      ");
                details.append(this.destination.getName());
                details.append('\n');
                details.append("Requested Stream Name:      ");
                details.append(streamName);
                details.append('\n');
                details.append("Requested selector:         ");
                details.append(this.selector);
                details.append('\n');
                details.append("Using subscriptionOptions:  ");
                details.append(subscriptionOptions);
                details.append('\n');
                Trace.data(this, "initialize()", details.toString(), null);
                details = new StringBuffer();
                String reutrnedSubscriptionName = mqsd.getSubName().getVsString();
                String returnedTopic = mqsd.getResolvedObjectString().getVsString();
                String returnedStream = mqsd.getObjectName();
                String returnedSelectorStr = mqsd.getSelectionString().getVsString();
                details.append("Returned subscription details:\n");
                if (this.subscriptionName != null) {
                    details.append("Returned SubscriptionName: ");
                    details.append(reutrnedSubscriptionName);
                    details.append('\n');
                }
                details.append("Returned full TopicString: ");
                details.append(returnedTopic);
                details.append('\n');
                details.append("Returned Stream Name:      ");
                details.append(returnedStream);
                details.append('\n');
                details.append("Returned selector:         ");
                details.append(this.selector);
                details.append('\n');
                details.append("Returned subscriptionOptions:  ");
                details.append(returnedSelectorStr);
                details.append('\n');
                details.append("CompletionCode = ");
                details.append(cc.x);
                details.append('\n');
                details.append("ReasonnCode = ");
                details.append(rc.x);
                details.append('\n');
                Trace.data(this, "initialize()", details.toString(), null);
            }
            if (this.subscriptionName != null) {
                boolean detailsDifferent = false;
                if (rc.x == 2510 || rc.x == 2524) {
                    detailsDifferent = true;
                } else if (rc.x == 2533 || rc.x == 2515) {
                    if (Trace.isOn) {
                        if (rc.x == 2533) {
                            Trace.data(this, "initialize()", "Call to ALTER sub failed with MQRC_DEST_CLASS_NOT_ALTERABLE. Attempting to RESUME sub instead.", null);
                        } else {
                            Trace.data(this, "initialize()", "Call to ALTER sub failed with MQRC_GROUPING_ALTERABLE. Attempting to RESUME sub instead.", null);
                        }
                    }
                    subscriptionOptions &= 0xFFFFFFFE;
                    mqsd.setOptions(subscriptionOptions |= 4);
                    ((JmqiSP)this.mq).spiSubscribe(this.hconn, this.spisd, mqsd, this.phobj, this.phsub, cc, rc);
                    if (Trace.isOn) {
                        StringBuffer details = new StringBuffer();
                        String reutrnedSubscriptionName = mqsd.getSubName().getVsString();
                        String returnedTopic = mqsd.getResolvedObjectString().getVsString();
                        String returnedStream = mqsd.getObjectName();
                        String returnedSelectorStr = mqsd.getSelectionString().getVsString();
                        details.append("Returned subscription details:\n");
                        if (this.subscriptionName != null) {
                            details.append("Returned SubscriptionName: ");
                            details.append(reutrnedSubscriptionName);
                            details.append('\n');
                        }
                        details.append("Returned full TopicString: ");
                        details.append(returnedTopic);
                        details.append('\n');
                        details.append("Returned Stream Name:      ");
                        details.append(returnedStream);
                        details.append('\n');
                        details.append("Returned selector:         ");
                        details.append(this.selector);
                        details.append('\n');
                        details.append("Returned subscriptionOptions:  ");
                        details.append(returnedSelectorStr);
                        details.append('\n');
                        details.append("CompletionCode = ");
                        details.append(cc.x);
                        details.append('\n');
                        details.append("ReasonnCode = ");
                        details.append(rc.x);
                        details.append('\n');
                        Trace.data(this, "initialize()", details.toString(), null);
                    }
                }
                if (detailsDifferent) {
                    WMQMessageConsumer.deleteDurableSubscription(this.helper, this.subscriptionName);
                    this.phobj.setHobj(CMQC.jmqi_MQHO_NONE);
                    mqsd = this.env.newMQSD();
                    mqsd.getResolvedObjectString().setVsBufSize(10240);
                    mqsd.getObjectString().setVsString(this.destination.getName());
                    mqsd.getObjectString().setVsBufSize(10240);
                    mqsd.getSelectionString().setVsString(this.selector);
                    mqsd.getSelectionString().setVsBufSize(10240);
                    mqsd.getSubName().setVsString(this.subscriptionName);
                    mqsd.getSubName().setVsBufSize(10240);
                    mqsd.setOptions(subscriptionOptions);
                    if (!streamName.equals("SYSTEM.BROKER.DEFAULT.STREAM")) {
                        mqsd.setObjectName(streamName);
                    }
                    ((JmqiSP)this.mq).spiSubscribe(this.hconn, this.spisd, mqsd, this.phobj, this.phsub, cc, rc);
                }
            }
            WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ0026", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN00400B", this.helper.getConnection(), this.hconn);
        } else {
            int queueOpenOptions = this.computeQueueOpenOptions();
            this.phobj = this.helper.getQueueFromCache(this.destination.getName(), this.selector, queueOpenOptions);
            if (this.phobj == null) {
                if (this.subID != null) {
                    this.spisd = this.computeLpiSD();
                    int options = this.spisd.getOptions();
                    this.spisd.setOptions(options |= 0x20000);
                    this.spisd.setSubId(this.subID);
                    this.phobj = this.env.newPhobj();
                    this.phsub = this.env.newPhobj();
                    MQSD mqsd = this.env.newMQSD();
                    int subscriptionOptions = 36;
                    mqsd.setOptions(subscriptionOptions);
                    ((JmqiSP)this.mq).spiSubscribe(this.hconn, this.spisd, mqsd, this.phobj, this.phsub, cc, rc);
                }
                if (this.subID == null || rc.x == 2440) {
                    Hobj hobj;
                    this.phobj = this.env.newPhobj();
                    MQOD mqod = this.env.newMQOD();
                    mqod.setObjectName(this.destination.getName());
                    if (this.selector != null) {
                        mqod.setVersion(4);
                        mqod.getSelectionString().setVsString(this.selector);
                        mqod.getSelectionString().setVsBufSize(10240);
                    }
                    SpiOpenOptions spiOO = this.computeSpiOpenOptions(queueOpenOptions);
                    ((JmqiSP)this.mq).spiOpen(this.hconn, mqod, spiOO, this.phobj, cc, rc);
                    if (rc.x == 0 && cc.x == 0 && this.destination.getName() != null && !this.destination.getName().equals(mqod.getObjectName().trim())) {
                        this.mq.MQCLOSE(this.hconn, this.phobj, 0, cc, rc);
                        HashMap<String, String> inserts = new HashMap<String, String>();
                        inserts.put("XMSC_DESTINATION_NAME", this.destination.getName());
                        JMSException je = Reason.createException("JMSWMQ2022", inserts, 2152, 2, this.env);
                        throw je;
                    }
                    if (this.destination.isTemporary() && (hobj = this.phobj.getHobj()) instanceof ReconnectableHobj) {
                        ((ReconnectableHobj)hobj).setModelQueueName(this.helper.getConnection().getStringProperty("XMSC_WMQ_TEMPORARY_MODEL"));
                    }
                }
                String messageId = "JMSWMQ2008";
                if (rc.x == 2045) {
                    messageId = "JMSWMQ1017";
                }
                WMQMessageConsumer.checkJmqiCallSuccess(messageId, this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN00400C", this.helper.getConnection(), this.hconn);
                if (!(this instanceof WMQQueueEnumeration.WMQSyncBrowserShadow)) {
                    this.helper.addQueueToCache(this.phobj, this.destination.getName(), this.selector, queueOpenOptions);
                }
            }
        }
        this.hobj = this.phobj.getHobj();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "initialize()");
        }
    }

    void initialize(WMQConsumerShadow previousShadow) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "initialize(WMQConsumerShadow)", new Object[]{previousShadow});
        }
        if (previousShadow == null) {
            this.initialize();
        } else {
            this.destination = previousShadow.destination;
            this.env = previousShadow.env;
            this.hconn = previousShadow.hconn;
            this.helper = previousShadow.helper;
            this.hobj = previousShadow.hobj;
            this.jmsProps = previousShadow.jmsProps;
            this.mq = previousShadow.mq;
            this.phobj = previousShadow.phobj;
            this.phsub = previousShadow.phsub;
            this.mqmd = previousShadow.mqmd;
            this.running = previousShadow.running;
            this.selector = previousShadow.selector;
            this.subscriptionName = previousShadow.subscriptionName;
            this.transacted = previousShadow.transacted;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "initialize(WMQConsumerShadow)");
        }
    }

    boolean qmIsZOS() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "qmIsZOS()");
        }
        try {
            boolean traceRet1;
            boolean bl = traceRet1 = this.hconn.getPlatform() == 1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "qmIsZOS()", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "qmIsZOS()", e);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "qmIsZOS()", false, 2);
            }
            return false;
        }
    }

    void resetMQMD() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "resetMQMD()");
        }
        this.setReceiveCCSID();
        this.mqmd.setCodedCharSetId(this.receiveCCSID);
        this.mqmd.setEncoding(273);
        if (this.qmIsZOS()) {
            if (this.messageID == null) {
                this.mqmd.setMsgId(MQMI_NONE);
            } else {
                this.mqmd.setMsgId(this.messageID);
            }
            if (this.correlationID == null) {
                this.mqmd.setCorrelId(MQMI_NONE);
            } else {
                this.mqmd.setCorrelId(this.correlationID);
            }
        } else {
            this.mqmd.setMsgId(MQMI_NONE);
            this.mqmd.setCorrelId(MQMI_NONE);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "resetMQMD()");
        }
    }

    ProviderMessage receive(long timeOut) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "receive(long)", new Object[]{new Long(timeOut)});
        }
        ProviderMessage traceRet1 = this.receiveInternal(timeOut);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "receive(long)", traceRet1);
        }
        return traceRet1;
    }

    abstract ProviderMessage receiveInternal(long var1) throws JMSException;

    abstract void setMessageListener(ProviderMessageListener var1) throws JMSException;

    private boolean isFiq() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "isFiq()");
        }
        try {
            int fiq = this.destination.getIntProperty("failIfQuiesce");
            if (fiq == 1) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "isFiq()", true, 1);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "isFiq()", false, 2);
            }
            return false;
        }
        catch (JMSException jmsex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "isFiq()", jmsex);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "isFiq()", jmsex);
            }
            throw jmsex;
        }
    }

    int computeQueueOpenOptions() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeQueueOpenOptions()");
        }
        int options = 33;
        if (this.isFiq()) {
            options |= 0x2000;
        }
        try {
            int readA = this.destination.getIntProperty("readAheadAllowed");
            if (readA == 1) {
                if (Trace.isOn) {
                    Trace.data(this, "Open read-ahead-allowed = enabled", null);
                }
                options |= 0x100000;
            } else if (readA == 0) {
                if (Trace.isOn) {
                    Trace.data(this, "Open read-ahead-allowed = disabled", null);
                }
                options |= 0x80000;
            }
        }
        catch (JMSException jmsex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeQueueOpenOptions()", jmsex);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeQueueOpenOptions()", jmsex);
            }
            throw jmsex;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeQueueOpenOptions()", new Integer(options));
        }
        return options;
    }

    int computeSubscriptionOptions() throws JMSException {
        int wildcard;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeSubscriptionOptions()");
        }
        int options = 34;
        options = this.isFiq() ? (options |= 0x2000) : (options &= 0xFFFFDFFF);
        if (this.subscriptionName != null) {
            options |= 0x209;
        }
        if ((wildcard = this.destination.getIntProperty("wildcardFormat")) == 0) {
            options |= 0x200000;
        } else if (wildcard == 1) {
            options |= 0x100000;
        }
        int readA = this.destination.getIntProperty("readAheadAllowed");
        if (readA == 1) {
            options |= 0x10000000;
        } else if (readA == 0) {
            options |= 0x8000000;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "computeSubscriptionOptions()", new Integer(options));
        }
        return options;
    }

    protected void initialisePoison() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "initialisePoison()");
        }
        if (null == this.poison) {
            String subQueue = this.getSubscriptionQueue();
            this.poison = new WMQPoison(this.helper, this.destination, this.hobj, subQueue);
            this.poison.setBrowser(this.isBrowser);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "initialisePoison()");
        }
    }

    String getSubscriptionQueue() {
        String subQueue = null;
        if (this.spisd != null && this.spisd.getSubProps() != null) {
            subQueue = this.spisd.getSubProps().getDestinationQName();
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "getSubscriptionQueue()", "getter", subQueue);
        }
        return subQueue;
    }

    ProviderMessage getMsg(MQGMO gmo, int msgLength, boolean throwExceptionForNoMsg) throws JMSException {
        return this.getMsg(gmo, msgLength, throwExceptionForNoMsg, this.env.newPint(), this.env.newPint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProviderMessage getMsg(MQGMO gmo, int msgLength, boolean throwExceptionForNoMsg, Pint cc, Pint rc) throws JMSException {
        ProviderMessage pmsg;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "getMsg(MQGMO,int,boolean)", new Object[]{gmo, new Integer(msgLength), throwExceptionForNoMsg});
        }
        if (!$assertionsDisabled && !(this.helper instanceof WMQSession)) {
            throw new AssertionError();
        }
        this.resetMQMD();
        ByteBuffer msgBuffer = null;
        Object object = this.helper.getHconnLock();
        synchronized (object) {
            while (this.helper.getCloseCounter() > 0) {
                try {
                    this.helper.getHconnLock().wait();
                }
                catch (InterruptedException e) {
                    if (!Trace.isOn) continue;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "getMsg(MQGMO,int,boolean)", e, 1);
                }
            }
            msgBuffer = ((JmqiSP)this.mq).jmqiGet(this.hconn, this.hobj, this.mqmd, gmo, msgLength, Integer.MAX_VALUE, this.getMessageDataBuffer, this.msgsTooSmallForBuffer, this.dataLength, cc, rc);
        }
        if (cc.x != 2 && Trace.isOn) {
            Trace.traceData(this, "Message size is ", (Object)Integer.toString(this.dataLength.x));
        }
        switch (rc.x) {
            case 0: 
            case 2110: {
                break;
            }
            case 2150: {
                if (this.mqmd.getBackoutCount() > 0) {
                    this.initialisePoison();
                    if (this.poison.shouldMessageBeRequeued(this.mqmd.getBackoutCount())) {
                        pmsg = this.poison.handlePoisonMessage(this.mqmd, new ByteBuffer[]{msgBuffer});
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "getMsg(MQGMO,int,boolean)", pmsg, 5);
                        }
                        return pmsg;
                    }
                }
            }
            default: {
                if (!throwExceptionForNoMsg && rc.x == 2033) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "getMsg(MQGMO,int,boolean)", null, 1);
                    }
                    return null;
                }
                WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ2002", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN004008", this.helper.getConnection(), this.hconn);
            }
        }
        if (this.mqmd.getBackoutCount() > 0) {
            this.initialisePoison();
            if (this.poison.shouldMessageBeRequeued(this.mqmd.getBackoutCount())) {
                pmsg = this.poison.handlePoisonMessage(this.mqmd, new ByteBuffer[]{msgBuffer}, gmo);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "getMsg(MQGMO,int,boolean)", pmsg, 2);
                }
                return pmsg;
            }
        }
        if (this.receiveMarshal == null) {
            this.initializeReceiveMarshal();
        }
        this.receiveMarshal.importMQMDMesageBuffer(this.helper, this.destination, this.mqmd, msgBuffer, 0, this.dataLength.x);
        WMQMessage resultMsg = null;
        try {
            resultMsg = this.receiveMarshal.exportProviderMessage(false);
        }
        catch (JMSException jmsEx) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "getMsg(MQGMO,int,boolean)", jmsEx, 2);
                Trace.data(this, "getMsg(MQGMO,int,boolean)", "Provider message is invalid. Performing poison message handling", null);
            }
            this.initialisePoison();
            ProviderMessage pmsg2 = this.poison.handlePoisonMessage(this.mqmd, new ByteBuffer[]{msgBuffer});
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "getMsg(MQGMO,int,boolean)", pmsg2, 4);
            }
            return pmsg2;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "getMsg(MQGMO,int,boolean)", resultMsg, 3);
        }
        return resultMsg;
    }

    private void setMatchOptions(String selector, MQGMO gmo) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "setMatchOptions(String,MQGMO)", new Object[]{selector, gmo});
        }
        if (selector != null && selector.trim().length() != 0) {
            String tokens = new String(selector.trim());
            byte[] id = null;
            int idLength = 0;
            boolean bId = false;
            int matchOptions = 0;
            if (tokens.startsWith(JMSCORRELATIONID)) {
                tokens = tokens.substring(JMSCORRELATIONID.length()).trim();
                idLength = 24;
                bId = true;
                id = this.correlationID = new byte[idLength];
                if (gmo != null) {
                    matchOptions |= 2;
                }
            }
            if (tokens.startsWith(JMSMESSAGEID)) {
                tokens = tokens.substring(JMSMESSAGEID.length()).trim();
                idLength = 24;
                bId = true;
                this.messageID = new byte[idLength];
                id = this.messageID;
                if (gmo != null) {
                    matchOptions |= 1;
                }
            }
            if (bId && tokens.charAt(0) == '=' && (tokens = tokens.substring(1).trim()).startsWith("'ID:") && (tokens = tokens.substring(4).toLowerCase()).length() == idLength * 2 + 1 && tokens.charAt(idLength * 2) == '\'') {
                for (int i = 0; i < 24; ++i) {
                    int n = 0;
                    char c1 = tokens.charAt(i * 2);
                    if (c1 >= '0' && c1 <= '9') {
                        n += c1 - 48;
                    } else if (c1 >= 'a' && c1 <= 'f') {
                        n += c1 - 97 + 10;
                    }
                    n *= 16;
                    char c2 = tokens.charAt(i * 2 + 1);
                    if (c2 >= '0' && c2 <= '9') {
                        n += c2 - 48;
                    } else if (c2 >= 'a' && c2 <= 'f') {
                        n += c2 - 97 + 10;
                    }
                    id[i] = (byte)n;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "setMatchOptions(String,MQGMO)");
        }
    }

    boolean isRunning() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "isRunning()", "getter", this.running);
        }
        return this.running;
    }

    void setRunning(boolean running) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "setRunning(boolean)", "setter", running);
        }
        this.running = running;
    }

    protected void initializeReceiveMarshal() {
        if (this.helper instanceof WMQSession && (this.jmsProps instanceof WMQMessageConsumer || this.jmsProps instanceof WMQQueueEnumeration) && this.destination != null) {
            boolean forceRFH2;
            try {
                int messageBodyStyle = this.destination.getIntProperty("messageBody");
                forceRFH2 = messageBodyStyle == 1;
            }
            catch (JMSException jmsex) {
                forceRFH2 = true;
            }
            this.receiveMarshal = WMQMarshal.newReceiveMarshal((WMQSession)this.helper, forceRFH2);
        } else {
            this.receiveMarshal = WMQMarshal.newReceiveMarshal();
        }
    }

    private void setReceiveCCSID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "setReceiveCCSID()");
        }
        if (PropertyStore.wasOverridden(receiveConversionCCSIDPropertyName, null)) {
            if (Trace.isOn) {
                Trace.data(this, "setReceiveCCSID()", "Reading CCSID from system property", null);
            }
            this.receiveCCSID = (int)PropertyStore.getLongPropertyObject(receiveConversionCCSIDPropertyName).longValue();
            this.gmoConvertOption = 16384;
            if (this.receiveCCSID == 0) {
                this.receiveCCSID = this.env.getNativeCcsid();
            }
        } else if (this.destination.getIntProperty("receiveConversion") == 2) {
            if (Trace.isOn) {
                Trace.data(this, "setReceiveCCSID()", "Reading CCSID from destination", null);
            }
            this.receiveCCSID = this.destination.getIntProperty("receiveCCSID");
            this.gmoConvertOption = 16384;
            if (this.receiveCCSID == 0) {
                if (Trace.isOn) {
                    Trace.data(this, "setReceiveCCSID()", "Using default JVM CCSID", null);
                }
                this.receiveCCSID = this.env.getNativeCcsid();
            }
        } else {
            if (Trace.isOn) {
                Trace.data(this, "setReceiveCCSID()", "Queue manager conversion not required, using default JVM CCSID", null);
            }
            this.receiveCCSID = 1208;
            this.gmoConvertOption = 0;
        }
        if (Trace.isOn) {
            Trace.data(this, "setReceiveCCSID()", "gmoConvertOption=" + this.gmoConvertOption + " receiveCCSID=" + this.receiveCCSID, null);
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "setReceiveCCSID()");
        }
    }

    static {
        boolean bl = $assertionsDisabled = !WMQConsumerShadow.class.desiredAssertionStatus();
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQConsumerShadow", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQConsumerShadow.java, jmscc.wmq, k701, k701-112-140304  1.121.1.33 13/09/26 16:34:31");
        }
        MIN_VALID_CCSID = new Long(-1L);
        MAX_VALID_CCSID = new Long(Long.MAX_VALUE);
        MQMI_NONE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }
}

