/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.MQCTLO;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.JMSException;

public class WMQConsumerOwnerShadow {
    private volatile boolean isSuspended = false;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQConsumerOwnerShadow.java, jmscc.wmq, k000 1.33 09/05/12 09:45:46";
    private static Vector subscriptionNames;
    private boolean asyncRunning = false;
    private JmqiEnvironment environment;
    private Object hconnLock = new Object();
    private Hconn hconn;
    private JmqiMQ mq;
    private int numAsyncConsumers = 0;
    private int closeCounter = 0;
    private HashMap queueCache;
    private HashMap queueCacheUsage;
    private String queueManagerName;
    private boolean started = false;

    WMQConsumerOwnerShadow(WMQConsumerOwner helper, String qmname) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "<init>(WMQConsumerOwner,String)", new Object[]{helper, qmname});
        }
        this.environment = helper.getJmqiEnvironment();
        this.hconn = helper.getHconn();
        this.mq = helper.getJmqiMQ();
        this.queueManagerName = qmname;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "<init>(WMQConsumerOwner,String)");
        }
    }

    void addAsyncConsumer() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "addAsyncConsumer()");
        }
        ++this.numAsyncConsumers;
        this.controlAsyncService();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "addAsyncConsumer()");
        }
    }

    void addQueueToCache(Phobj phobj, String queueName, String selector, int options) {
        QueueCacheKey key;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "addQueueToCache(Phobj,String,String,int)", new Object[]{phobj, queueName, selector, new Integer(options)});
        }
        if (this.queueCache == null) {
            this.queueCache = new HashMap();
        }
        if (this.queueCacheUsage == null) {
            this.queueCacheUsage = new HashMap();
        }
        if (this.queueCache.containsKey(key = new QueueCacheKey(queueName, selector, options)) || this.queueCacheUsage.containsKey(phobj)) {
            HashMap<String, HashMap> info = new HashMap<String, HashMap>();
            info.put("queueCache", this.queueCache);
            info.put("queueCacheUsage", this.queueCacheUsage);
            Trace.ffst(this, "addQueueToCache()", "XN00N001", info, null);
        }
        this.queueCache.put(key, phobj);
        this.queueCacheUsage.put(phobj, new QueueCacheUsageEntry(key));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "addQueueToCache(Phobj,String,String,int)");
        }
    }

    private void controlAsyncService() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "controlAsyncService()");
        }
        if (Trace.isOn) {
            Trace.data(this, "controlAsyncService()", (Object)("asyncRunning=" + this.asyncRunning + " started=" + this.started + " numAsyncConsumers=" + this.numAsyncConsumers));
        }
        if (this.asyncRunning) {
            if (!this.started || this.numAsyncConsumers <= 0) {
                Pint cc = this.environment.newPint();
                Pint rc = this.environment.newPint();
                MQCTLO mqctlo = this.environment.newMQCTLO();
                this.mq.MQCTL(this.hconn, 4, mqctlo, cc, rc);
                if (0 != rc.x) {
                    if (Reason.isImpossibleReason(rc.x, cc.x)) {
                        HashMap<String, Object> info = new HashMap<String, Object>();
                        info.put("reason", rc);
                        info.put("compcode", cc);
                        info.put("queuemanager", this.queueManagerName);
                        info.put("hconn", this.hconn);
                        Trace.ffst(this, "controlAsyncService()", "XN008009", info, JMSException.class);
                    }
                    JMSException je = Reason.createException("MQCTL", rc.x, cc.x, this.environment);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "controlAsyncService()", je, 1);
                    }
                    throw je;
                }
                if (this.numAsyncConsumers < 0) {
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("numAsyncConsumers", new Integer(this.numAsyncConsumers));
                    info.put("queuemanager", this.queueManagerName);
                    Trace.ffst(this, "controlAsyncService()", "XN00N002", info, JMSException.class);
                }
                this.asyncRunning = false;
                this.isSuspended = false;
            }
        } else if (this.started && this.numAsyncConsumers > 0) {
            Pint cc = this.environment.newPint();
            Pint rc = this.environment.newPint();
            MQCTLO mqctlo = this.environment.newMQCTLO();
            this.mq.MQCTL(this.hconn, 1, mqctlo, cc, rc);
            if (0 != rc.x) {
                if (Reason.isImpossibleReason(rc.x, cc.x)) {
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("reason", rc);
                    info.put("compcode", cc);
                    info.put("queuemanager", this.queueManagerName);
                    info.put("hconn", this.hconn);
                    Trace.ffst(this, "controlAsyncService()", "XN008008", info, JMSException.class);
                }
                JMSException je = Reason.createException("MQCTL", rc.x, cc.x, this.environment);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "controlAsyncService()", je, 2);
                }
                throw je;
            }
            this.asyncRunning = true;
            this.isSuspended = false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "controlAsyncService()");
        }
    }

    Phobj getQueueFromCache(String queueName, String selector, int options) {
        QueueCacheKey key;
        Phobj phobjTemp;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "getQueueFromCache(String,String,int)", new Object[]{queueName, selector, new Integer(options)});
        }
        if (this.queueCache == null) {
            this.queueCache = new HashMap();
        }
        if (this.queueCacheUsage == null) {
            this.queueCacheUsage = new HashMap();
        }
        if ((phobjTemp = (Phobj)this.queueCache.get(key = new QueueCacheKey(queueName, selector, options))) != null) {
            QueueCacheUsageEntry usuage = (QueueCacheUsageEntry)this.queueCacheUsage.get(phobjTemp);
            if (usuage == null) {
                HashMap<String, HashMap> info = new HashMap<String, HashMap>();
                info.put("queueCache", this.queueCache);
                info.put("queueCacheUsage", this.queueCacheUsage);
                Trace.ffst(this, "getQueueFromCache()", "XN00N003", info, null);
            } else {
                usuage.count++;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "getQueueFromCache(String,String,int)", phobjTemp);
        }
        return phobjTemp;
    }

    boolean isSuspended() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "isSuspended()", "getter", this.isSuspended);
        }
        return this.isSuspended;
    }

    boolean isAsyncRunning() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "isAsyncRunning()", "getter", this.asyncRunning);
        }
        return this.asyncRunning;
    }

    synchronized boolean isSubscriptionInUse(String subscriptionName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "isSubscriptionInUse(String)", new Object[]{subscriptionName});
        }
        if (!subscriptionNames.contains(subscriptionName)) {
            subscriptionNames.add(subscriptionName);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "isSubscriptionInUse(String)", false, 1);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "isSubscriptionInUse(String)", true, 2);
        }
        return true;
    }

    void removeAsyncConsumer() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "removeAsyncConsumer()");
        }
        --this.numAsyncConsumers;
        this.controlAsyncService();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "removeAsyncConsumer()");
        }
    }

    boolean removeQueueFromCache(Phobj phobj) {
        QueueCacheUsageEntry usage;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "removeQueueFromCache(Phobj)", new Object[]{phobj});
        }
        if (this.queueCache == null) {
            this.queueCache = new HashMap();
        }
        if (this.queueCacheUsage == null) {
            this.queueCacheUsage = new HashMap();
        }
        if ((usage = (QueueCacheUsageEntry)this.queueCacheUsage.get(phobj)) != null) {
            usage.count--;
            if (usage.count == 0) {
                usage = (QueueCacheUsageEntry)this.queueCacheUsage.remove(phobj);
                this.queueCache.remove(usage.key);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "removeQueueFromCache(Phobj)", true, 1);
                }
                return true;
            }
            if (usage.count < 0) {
                HashMap<String, Integer> info = new HashMap<String, Integer>();
                info.put("usage count", new Integer(usage.count));
                Trace.ffst(this, "removeQueueFromCache()", "XN00N004", info, null);
            }
        } else {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("queueCacheUsage", this.queueCacheUsage);
            info.put("usage entry", usage);
            Trace.ffst(this, "removeQueueFromCache()", "XN00N005", info, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "removeQueueFromCache(Phobj)", false, 2);
        }
        return false;
    }

    synchronized void removeSubscription(String subscriptionName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "removeSubscription(String)", new Object[]{subscriptionName});
        }
        subscriptionNames.remove(subscriptionName);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "removeSubscription(String)");
        }
    }

    void resumeAsyncService() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "resumeAsyncService()");
        }
        if (!this.mq.isAsyncConsumeThread(this.hconn)) {
            if (this.isAsyncRunning()) {
                if (this.isSuspended) {
                    Pint cc = this.environment.newPint();
                    Pint rc = this.environment.newPint();
                    MQCTLO mqctlo = this.environment.newMQCTLO();
                    this.mq.MQCTL(this.hconn, 131072, mqctlo, cc, rc);
                    if (0 != rc.x) {
                        if (Reason.isImpossibleReason(rc.x, cc.x)) {
                            HashMap<String, Object> info = new HashMap<String, Object>();
                            info.put("reason", rc);
                            info.put("compcode", cc);
                            info.put("queuemanager", this.queueManagerName);
                            info.put("hconn", this.hconn);
                            Trace.ffst(this, "resumeAsyncService()", "XN00N006", info, JMSException.class);
                        }
                        JMSException je = Reason.createException("MQCTL", rc.x, cc.x, this.environment);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "resumeAsyncService()", je);
                        }
                        throw je;
                    }
                    this.isSuspended = false;
                } else if (Trace.isOn) {
                    Trace.data(this, "WMQConsumerOwnerShadow", (Object)"Resume not called as NOT suspended");
                }
            } else if (Trace.isOn) {
                Trace.data(this, "WMQConsumerOwnerShadow", (Object)"Resume not called as async service not running");
            }
        } else if (Trace.isOn) {
            Trace.data(this, "WMQConsumerOwnerShadow", (Object)"Resume not called as we are the async consume thread");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "resumeAsyncService()");
        }
    }

    void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "start()");
        }
        this.started = true;
        this.controlAsyncService();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "start()");
        }
    }

    void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "stop()");
        }
        this.started = false;
        this.controlAsyncService();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "stop()");
        }
    }

    boolean suspendAsyncService() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "suspendAsyncService()");
        }
        boolean didSuspend = false;
        if (!this.mq.isAsyncConsumeThread(this.hconn)) {
            if (this.isAsyncRunning()) {
                if (!this.isSuspended()) {
                    this.isSuspended = true;
                    Pint cc = this.environment.newPint();
                    Pint rc = this.environment.newPint();
                    MQCTLO mqctlo = this.environment.newMQCTLO();
                    this.mq.MQCTL(this.hconn, 65536, mqctlo, cc, rc);
                    if (0 != rc.x) {
                        this.isSuspended = false;
                        if (Reason.isImpossibleReason(rc.x, cc.x)) {
                            HashMap<String, Object> info = new HashMap<String, Object>();
                            info.put("reason", rc);
                            info.put("compcode", cc);
                            info.put("queuemanager", this.queueManagerName);
                            info.put("hconn", this.hconn);
                            Trace.ffst(this, "suspendAsyncService()", "XN00N007", info, JMSException.class);
                        }
                        JMSException je = Reason.createException("MQCTL", rc.x, cc.x, this.environment);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "suspendAsyncService()", je);
                        }
                        throw je;
                    }
                    if (Trace.isOn) {
                        Trace.data(this, "WMQConsumerOwnerShadow", (Object)"Setting suspend to true");
                    }
                    didSuspend = true;
                } else if (Trace.isOn) {
                    Trace.data(this, "WMQConsumerOwnerShadow", (Object)"Suspend no called as async service already suspended");
                }
            } else if (Trace.isOn) {
                Trace.data(this, "WMQConsumerOwnerShadow", (Object)"Suspend not called as async service not running");
            }
        } else if (Trace.isOn) {
            Trace.data(this, "WMQConsumerOwnerShadow", (Object)"Suspend not called as we are the async consume thread");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "suspendAsyncService() ", new Boolean(didSuspend));
        }
        return didSuspend;
    }

    public void incrementCloseCounter() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "incrementCloseCounter()");
        }
        ++this.closeCounter;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "incrementCloseCounter()");
        }
    }

    public void decrementCloseCounter() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "decrementCloseCounter()");
        }
        --this.closeCounter;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "decrementCloseCounter()");
        }
    }

    int getCloseCounter() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "getCloseCounter()", "getter", new Integer(this.closeCounter));
        }
        return this.closeCounter;
    }

    public Object getHconnLock() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "getHconnLock()", "getter", this.hconnLock);
        }
        return this.hconnLock;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQConsumerOwnerShadow.java, jmscc.wmq, k701, k701-112-140304  1.36.1.4 10/03/23 03:58:56");
        }
        subscriptionNames = new Vector();
    }

    private class QueueCacheUsageEntry {
        private int count;
        private QueueCacheKey key;

        private QueueCacheUsageEntry(QueueCacheKey key) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.QueueCacheUsageEntry", "<init>(QueueCacheKey)", new Object[]{key});
            }
            this.key = key;
            this.count = 1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.QueueCacheUsageEntry", "<init>(QueueCacheKey)");
            }
        }
    }

    private class QueueCacheKey {
        private int openOptions;
        private String queueName;
        private String selector;

        private QueueCacheKey(String qName, String selector, int options) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.QueueCacheKey", "<init>(String,String,int)", new Object[]{qName, selector, new Integer(options)});
            }
            this.queueName = qName;
            this.selector = selector;
            this.openOptions = options;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.QueueCacheKey", "<init>(String,String,int)");
            }
        }

        public boolean equals(Object obj) {
            boolean result = true;
            if (obj instanceof QueueCacheKey) {
                QueueCacheKey other = (QueueCacheKey)obj;
                result &= this.queueName.equals(other.queueName);
                result = this.selector != null ? (result &= this.selector.equals(other.selector)) : (other.selector != null ? (result &= other.selector.equals(this.selector)) : (this.selector == null && other.selector == null ? (result &= true) : false));
                result &= this.openOptions == other.openOptions;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            int result = this.openOptions;
            if (this.selector != null) {
                result += this.selector.hashCode();
            }
            return result += this.queueName.hashCode();
        }
    }
}

