/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.MQCBC;
import com.ibm.mq.jmqi.MQCBD;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQHeader;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.MQRFH;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Hobj;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.internal.JmqiTools;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.mq.jmqi.system.JmqiComponentTls;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.JmqiTls;
import com.ibm.mq.jmqi.system.LpiSDSubProps;
import com.ibm.mq.jmqi.system.SpiOpenOptions;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderConnectionBrowser;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessageReferenceHandler;
import com.ibm.msg.client.wmq.common.WMQThreadLocalStorage;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow;
import com.ibm.msg.client.wmq.internal.WMQConnection;
import com.ibm.msg.client.wmq.internal.WMQMessageConsumer;
import com.ibm.msg.client.wmq.internal.WMQMessageReference;
import com.ibm.msg.client.wmq.internal.WMQMessageRetentionProcessor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.jms.JMSException;

public class WMQConnectionBrowser
extends WMQPropertyContext
implements ProviderConnectionBrowser {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQConnectionBrowser.java, jmscc.wmq, k701, k701-112-140304 1.89.1.13 13/01/30 12:51:49";
    private static final long serialVersionUID = 1489582153L;
    private WMQConnection connection;
    private WMQDestination destination;
    private String fqSubName;
    private ProviderMessageReferenceHandler msgRefHandler;
    private int quantityHint;
    private static final int HEADERSIZE_DEFAULT = 5000;
    private WMQConnectionBrowserShadow shadow;
    static /* synthetic */ Class class$javax$jms$JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WMQConnectionBrowser(WMQConnection connection, ProviderDestination destination, String fqSubName, String selector, ProviderMessageReferenceHandler msgRefHandler, int quantityHint, boolean noLocal) throws JMSException {
        super(connection);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "<init>(WMQConnection,ProviderDestination,String,String,ProviderMessageReferenceHandler,int,boolean)", new Object[]{connection, destination, fqSubName, selector, msgRefHandler, new Integer(quantityHint), noLocal});
        }
        this.connection = connection;
        this.destination = (WMQDestination)destination;
        this.fqSubName = fqSubName;
        this.msgRefHandler = msgRefHandler;
        this.quantityHint = quantityHint;
        this.shadow = new WMQConnectionBrowserShadow(connection, this.destination, selector, this.fqSubName);
        Object object = connection.getHconnLock();
        synchronized (object) {
            boolean didSuspend;
            block11: {
                didSuspend = connection.suspendAsyncService();
                try {
                    this.shadow.initialize();
                    Object var11_10 = null;
                    if (!Trace.isOn) break block11;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "<init>(WMQConnection,ProviderDestination,String,String,ProviderMessageReferenceHandler,int,boolean)");
                    }
                    if (didSuspend) {
                        connection.resumeAsyncService();
                    }
                    throw throwable;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "<init>(WMQConnection,ProviderDestination,String,String,ProviderMessageReferenceHandler,int,boolean)");
            }
            if (didSuspend) {
                connection.resumeAsyncService();
            }
            this.shadow.registerMessageListener();
        }
        if (this.getIntProperty("XMSC_WMQ_MESSAGE_RETENTION") == 0 && destination.isQueue()) {
            WMQMessageRetentionProcessor mRetProc = WMQMessageRetentionProcessor.getInstance();
            mRetProc.registerConnectionBrowser(this, this.destination, selector);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "<init>(WMQConnection,ProviderDestination,String,String,ProviderMessageReferenceHandler,int,boolean)");
        }
    }

    public void close(boolean closingFromConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "close(boolean)", new Object[]{closingFromConnection});
        }
        if (this.getIntProperty("XMSC_WMQ_MESSAGE_RETENTION") == 0 && this.destination.isQueue()) {
            WMQMessageRetentionProcessor mRetProc = WMQMessageRetentionProcessor.getInstance();
            mRetProc.removeConnectionBrowser(this, this.destination);
        }
        this.shadow.close();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "close(boolean)");
        }
    }

    public void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "start()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "start()");
        }
    }

    public void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "stop()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "stop()");
        }
    }

    WMQConnection getConnection() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "getConnection()", "getter", this.connection);
        }
        return this.connection;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQConnectionBrowser", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQConnectionBrowser.java, jmscc.wmq, k701, k701-112-140304  1.89.1.13 13/01/30 12:51:49");
        }
    }

    private class WMQConnectionBrowserShadow
    extends WMQAsyncConsumerShadow {
        private Hobj secondHobj;

        private WMQConnectionBrowserShadow(WMQConnection connection, WMQDestination destination, String selector, String subscriptionName) {
            super(connection, connection, destination, selector, false, subscriptionName);
            this.secondHobj = null;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "<init>(WMQConnection,WMQDestination,String,String)", new Object[]{connection, destination, selector, subscriptionName});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "<init>(WMQConnection,WMQDestination,String,String)");
            }
        }

        void closeInternal() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "closeInternal()");
            }
            Pint rc = this.env.newPint();
            Pint cc = this.env.newPint();
            this.helper.removeAsyncConsumer();
            if (this.destination.isTopic()) {
                this.mq.MQCLOSE(this.hconn, this.phsub, 0, cc, rc);
                WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ0025", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN004009", this.helper.getConnection(), this.hconn);
            }
            this.mq.MQCLOSE(this.hconn, this.phobj, 0, cc, rc);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "closeInternal()");
            }
        }

        MQCBD computeCBD() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "computeCBD()");
            }
            MQCBD cbd = super.computeCBD();
            if (0 == WMQConnectionBrowser.this.quantityHint) {
                cbd.setMaxMsgLength(0);
            } else if (1 == WMQConnectionBrowser.this.quantityHint) {
                cbd.setMaxMsgLength(5000);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "computeCBD()", cbd);
            }
            return cbd;
        }

        MQGMO computeGMO(int waitTime) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "computeGMO(int)", new Object[]{new Integer(waitTime)});
            }
            MQGMO gmo = super.computeGMO(waitTime);
            int options = gmo.getOptions();
            int gmoVersion = gmo.getVersion();
            if (gmoVersion < 3) {
                gmo.setVersion(3);
            }
            gmo.setWaitInterval(0);
            options |= 1;
            options &= 0xFFFFFFFF;
            if (2 != WMQConnectionBrowser.this.quantityHint) {
                options |= 0x40;
            }
            options |= 0x10;
            options |= 0x1000000;
            options |= 0x200000;
            options &= 0xFFFFFFFD;
            options &= 0xFFFFEFFF;
            options |= 4;
            if (this.qmIsZOS() && WMQConnectionBrowser.this.quantityHint == 1) {
                options &= 0xFFFFBFFF;
            }
            gmo.setOptions(options);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "computeGMO(int)", gmo);
            }
            return gmo;
        }

        protected int computeQueueOpenOptions() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "computeQueueOpenOptions()");
            }
            int options = super.computeQueueOpenOptions();
            options |= 0x2000A;
            options &= 0xFFFFFFFB;
            options &= 0xFFFFFFFE;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "computeQueueOpenOptions()", new Integer(options));
            }
            return options;
        }

        private void initialiseSecondHobj() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "initialiseSecondHobj()");
            }
            if (this.secondHobj != null) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "initialiseSecondHobj()", 1);
                }
                return;
            }
            Pint rc = this.env.newPint();
            Pint cc = this.env.newPint();
            String qname = null;
            if (this.destination.isTopic()) {
                LpiSDSubProps subprops = this.spisd.getSubProps();
                qname = subprops.getDestinationQName();
            } else {
                qname = this.destination.getName();
            }
            Phobj secondPhobj = this.env.newPhobj();
            MQOD mqod = this.env.newMQOD();
            mqod.setObjectName(qname);
            int queueOpenOptions = this.computeQueueOpenOptions();
            queueOpenOptions |= 8;
            queueOpenOptions &= 0xFFFDFFFF;
            queueOpenOptions &= 0xFFEFFFFF;
            SpiOpenOptions spiOO = this.computeSpiOpenOptions(queueOpenOptions |= 0x80000);
            ((JmqiSP)this.mq).spiOpen(this.hconn, mqod, spiOO, secondPhobj, cc, rc);
            String messageId = "JMSWMQ2008";
            if (rc.x == 2045) {
                messageId = "JMSWMQ1017";
            }
            WMQMessageConsumer.checkJmqiCallSuccess(messageId, this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN00D00B", this.helper.getConnection(), this.hconn);
            this.secondHobj = secondPhobj.getHobj();
            if (this.poison != null) {
                this.poison.setHobj(this.secondHobj);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "initialiseSecondHobj()", 2);
            }
        }

        void close() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "close()");
            }
            Pint rc = this.env.newPint();
            Pint cc = this.env.newPint();
            if (this.secondHobj != null) {
                Phobj secondPhobj = this.env.newPhobj();
                secondPhobj.setHobj(this.secondHobj);
                this.mq.MQCLOSE(this.hconn, secondPhobj, 0, cc, rc);
            }
            super.close(null);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "close()");
            }
        }

        private boolean poisonous(MQMD md, MQGMO gmo, MQCBC cbc) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "poisonous(MQMD,MQGMO,MQCBC)", new Object[]{md, gmo, cbc});
            }
            if (md.getBackoutCount() == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "poisonous(MQMD,MQGMO,MQCBC)", false, 1);
                }
                return false;
            }
            this.initialisePoison();
            if (this.poison.shouldMessageBeRequeued(md.getBackoutCount())) {
                this.handlePoisonMessage(md, gmo, cbc);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "poisonous(MQMD,MQGMO,MQCBC)", true, 2);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "poisonous(MQMD,MQGMO,MQCBC)", false, 3);
            }
            return false;
        }

        private void handlePoisonMessage(MQMD md, MQGMO gmo, MQCBC cbc) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "handlePoisonMessage(MQMD,MQGMO,MQCBC)", new Object[]{md, gmo, cbc});
            }
            Pint rc = this.env.newPint();
            Pint cc = this.env.newPint();
            this.initialisePoison();
            this.initialiseSecondHobj();
            MQGMO newgmo = this.env.newMQGMO();
            if (newgmo.getVersion() < 3) {
                newgmo.setVersion(3);
            }
            int options = 4096;
            newgmo.setOptions(options);
            newgmo.setMatchOptions(32);
            newgmo.setMsgToken(gmo.getMsgToken());
            MQMD newmqmd = this.env.newMQMD();
            ByteBuffer buffer = ByteBuffer.allocate(cbc.getDataLength());
            Pint dataLen = this.env.newPint();
            int msgLen = cbc.getDataLength();
            this.mq.MQGET(this.hconn, this.secondHobj, newmqmd, newgmo, msgLen, buffer, dataLen, cc, rc);
            if (rc.x == 2080) {
                if (Trace.isOn) {
                    Trace.data(this, "WMQConnectionBrowserShadow", "handlePoisonMessage", "Unable to get poison message as buffer size was too small. Buffer size used : ", new Integer(cbc.getDataLength()));
                    Trace.data(this, "WMQConnectionBrowserShadow", "handlePoisonMessage", "Trying again with an increased buffer size : ", new Integer(dataLen.x));
                }
                buffer = ByteBuffer.allocate(dataLen.x);
                msgLen = dataLen.x;
                this.mq.MQGET(this.hconn, this.secondHobj, newmqmd, newgmo, msgLen, buffer, dataLen, cc, rc);
            }
            if (rc.x == 2033) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "handlePoisonMessage(MQMD,MQGMO,MQCBC)", 1);
                }
                return;
            }
            try {
                WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ2002", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN00D00A", this.helper.getConnection(), this.hconn);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "handlePoisonMessage(MQMD,MQGMO,MQCBC)", je, 1);
                }
                if (cc.x == 1) {
                    this.mq.MQBACK(this.hconn, cc, rc);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "handlePoisonMessage(MQMD,MQGMO,MQCBC)", je, 1);
                }
                throw je;
            }
            ByteBuffer msgBuffer = ByteBuffer.allocate(dataLen.x);
            byte[] tempBuffer = new byte[dataLen.x];
            buffer.get(tempBuffer, 0, dataLen.x);
            msgBuffer.put(tempBuffer);
            try {
                this.poison.handlePoisonMessage(newmqmd, new ByteBuffer[]{msgBuffer});
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "handlePoisonMessage(MQMD,MQGMO,MQCBC)", je, 2);
                }
                if (newmqmd.getPersistence() == 1) {
                    this.helper.removeAsyncConsumer();
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "handlePoisonMessage(MQMD,MQGMO,MQCBC)", je, 2);
                    }
                    throw je;
                }
                HashMap<String, JMSException> inserts = new HashMap<String, JMSException>();
                inserts.put("XMSC_INSERT_EXCEPTION", je);
                Log.log(this, "consumer()", "JMSWMQ0036", inserts);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "handlePoisonMessage(MQMD,MQGMO,MQCBC)", 2);
            }
        }

        public void consumer(Hconn hconn2, MQMD mqmd2, MQGMO mqgmo2, ByteBuffer pBuffer, MQCBC mqcbc) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", new Object[]{hconn2, mqmd2, mqgmo2, pBuffer, mqcbc});
            }
            int callType = mqcbc.getCallType();
            int reason = mqcbc.getReason();
            int compcode = mqcbc.getCompCode();
            if (0 != reason && 2033 != reason && 2079 != reason) {
                if (Trace.isOn) {
                    Trace.data(this, "WMQConnectionBrowserShadow", "consumer", "Unexpected reason", new Integer(reason));
                }
                if (Reason.isImpossibleReason(reason, compcode) || 2120 == reason || WMQConnectionBrowser.this.quantityHint == 2 && 2079 == reason) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("callType", new Integer(callType));
                    data.put("cc", new Integer(compcode));
                    data.put("rc", new Integer(reason));
                    data.put("hconn2", hconn2);
                    data.put("md", mqmd2);
                    data.put("gmo", mqgmo2);
                    data.put("cbc", mqcbc);
                    data.put("connection", WMQConnectionBrowser.this.connection);
                    data.put("destination", this.destination);
                    if (WMQConnectionBrowser.this.fqSubName != null) {
                        data.put("subname", WMQConnectionBrowser.this.fqSubName);
                    }
                    Trace.ffst(this, "consumer", "XN00D004", data, null);
                }
                if (Reason.isConnectionBroken(reason)) {
                    JMSException e = Reason.createException("JMSWMQ1107", null, reason, compcode, this.env);
                    try {
                        WMQConnectionBrowser.this.connection.driveExceptionListener(e, true);
                    }
                    catch (JMSException ex) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", ex, 1);
                        }
                        HashMap<String, JMSException> info = new HashMap<String, JMSException>();
                        info.put("exception", e);
                        Trace.ffst(this, "c.i.m.c.wmq.internal.WMQConnectionBrowser", "XN00D005", info, null);
                    }
                }
            }
            try {
                if (2033 == reason) {
                    if (Trace.isOn) {
                        Trace.data(this, "WMQConnectionBrowserShadow", "consumer", "Light traffic so send this batch off straight away", new Integer(reason));
                    }
                    WMQConnectionBrowser.this.msgRefHandler.endDeliver();
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", 1);
                    }
                    return;
                }
                switch (callType) {
                    case 1: {
                        if (Trace.isOn) {
                            Trace.data(this, "WMQConnectionBrowserShadow", "consumer", "called to START", new Integer(reason));
                        }
                        break;
                    }
                    case 2: {
                        if (Trace.isOn) {
                            Trace.data(this, "WMQConnectionBrowserShadow", "consumer", "called to STOP", new Integer(reason));
                        }
                        break;
                    }
                    case 3: {
                        if (Trace.isOn) {
                            Trace.data(this, "WMQConnectionBrowserShadow", "consumer", "called to REGISTER", new Integer(reason));
                        }
                        break;
                    }
                    case 4: {
                        if (Trace.isOn) {
                            Trace.data(this, "WMQConnectionBrowserShadow", "consumer", "called to DEREGISTER", new Integer(reason));
                        }
                        break;
                    }
                    case 7: {
                        if (Trace.isOn) {
                            Trace.data(this, "WMQConnectionBrowserShadow", "consumer", "called to BROWSE msgid=" + JmqiTools.arrayToHexString((byte[])mqmd2.getMsgId()) + " messagetoken=" + JmqiTools.arrayToHexString((byte[])mqgmo2.getMsgToken()), new Integer(reason));
                        }
                        ByteBuffer pBuffer1 = pBuffer;
                        if (0 != reason) {
                            if (2 != WMQConnectionBrowser.this.quantityHint && 2079 == reason) {
                                if (Trace.isOn) {
                                    Trace.data(this, "consumer()", "Got MQRC_TRUNCATED_MSG_ACCEPTED as expected", (Object)new Integer(reason));
                                }
                                if (1 == WMQConnectionBrowser.this.quantityHint) {
                                    pBuffer1 = this.browseHeaderData(hconn2, mqmd2, mqgmo2, pBuffer1, mqcbc);
                                }
                            } else if (compcode == 1 && reason == 2110 && "        ".equals(mqmd2.getFormat())) {
                                if (Trace.isOn) {
                                    Trace.data(this, "consumer()", "Got MQRC_FORMAT_ERROR as warning but ignoring as Format field is set to MQFMT_NONE", (Object)new Integer(reason));
                                }
                            } else {
                                this.handlePoisonMessage(mqmd2, mqgmo2, mqcbc);
                                if (Trace.isOn) {
                                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", 2);
                                }
                                return;
                            }
                        }
                        if (this.poisonous(mqmd2, mqgmo2, mqcbc)) {
                            if (Trace.isOn) {
                                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", 3);
                            }
                            return;
                        }
                        byte[] token = mqgmo2.getMsgToken();
                        int msgLen = mqcbc.getDataLength();
                        WMQMessageReference msgRef = null;
                        if (this.spisd == null) {
                            msgRef = new WMQMessageReference(token, this.destination, msgLen, null);
                        } else {
                            LpiSDSubProps subprops = this.spisd.getSubProps();
                            msgRef = new WMQMessageReference(token, this.destination, subprops.getDestinationQName(), subprops.getDestinationQMgr(), WMQConnectionBrowser.this.fqSubName, msgLen, this.spisd.getSubId());
                        }
                        if (0 != WMQConnectionBrowser.this.quantityHint) {
                            try {
                                WMQMessage message = null;
                                message = 1 == WMQConnectionBrowser.this.quantityHint ? this.unmarshal(mqmd2, pBuffer1, true) : this.unmarshal(mqmd2, pBuffer1, false);
                                msgRef.setDataQuantity(WMQConnectionBrowser.this.quantityHint);
                                msgRef.setMessage(message);
                            }
                            catch (JMSException je) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", je, 7);
                                }
                                this.handlePoisonMessage(mqmd2, mqgmo2, mqcbc);
                                if (Trace.isOn) {
                                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", 5);
                                }
                                return;
                            }
                        }
                        try {
                            WMQConnectionBrowser.this.msgRefHandler.handleMessageReference(msgRef);
                            break;
                        }
                        catch (JMSException je) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", je, 2);
                            }
                            this.helper.stop();
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", je);
                            }
                            throw je;
                        }
                    }
                    case 5: {
                        if (Trace.isOn) {
                            Trace.data(this, "WMQConnectionBrowserShadow", "consumer", "called for an EVENT", new Integer(reason));
                        }
                        if (reason == 2494) {
                            HashMap<String, String> inserts = new HashMap<String, String>();
                            inserts.put("XMSC_INSERT_DESTINATION_NAME", this.destination.getName());
                            Log.log(this, "consumer()", "JMSWMQ1118", inserts);
                            break;
                        }
                        JMSException e = Reason.createException("JMSWMQ1107", null, reason, compcode, this.env);
                        try {
                            WMQConnectionBrowser.this.connection.driveExceptionListener(e, Reason.isConnectionBroken(reason));
                        }
                        catch (JMSException ex) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", ex, 3);
                            }
                            HashMap<String, JMSException> info = new HashMap<String, JMSException>();
                            info.put("exception", e);
                            Trace.ffst(this, "c.i.m.c.wmq.internal.WMQConnectionBrowser", "XN00D006", info, class$javax$jms$JMSException == null ? (class$javax$jms$JMSException = WMQConnectionBrowser.class$("javax.jms.JMSException")) : class$javax$jms$JMSException);
                        }
                        if (reason == 2016) {
                            HashMap<String, String> inserts = new HashMap<String, String>();
                            inserts.put("XMSC_INSERT_DESTINATION_NAME", this.destination.getName());
                            Log.log(this, "consumer()", "JMSWMQ1119", inserts);
                        }
                        break;
                    }
                    default: {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("callType", new Integer(callType));
                        data.put("cc", new Integer(compcode));
                        data.put("rc", new Integer(reason));
                        data.put("hconn2", hconn2);
                        data.put("md", mqmd2);
                        data.put("gmo", mqgmo2);
                        data.put("cbc", mqcbc);
                        data.put("connection", WMQConnectionBrowser.this.connection);
                        data.put("destination", this.destination);
                        if (WMQConnectionBrowser.this.fqSubName != null) {
                            data.put("subname", WMQConnectionBrowser.this.fqSubName);
                        }
                        Trace.ffst(this, "consumer", "XN00D003", data, class$javax$jms$JMSException == null ? (class$javax$jms$JMSException = WMQConnectionBrowser.class$("javax.jms.JMSException")) : class$javax$jms$JMSException);
                    }
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", je, 4);
                }
                HashMap<String, JMSException> inserts = new HashMap<String, JMSException>();
                inserts.put("XMSC_INSERT_EXCEPTION", je);
                Log.log(this, "consumer()", "JMSWMQ0036", inserts);
                try {
                    boolean b = this.isConnectionBroken((Exception)((Object)je));
                    WMQConnectionBrowser.this.connection.driveExceptionListener(je, b);
                }
                catch (JMSException ex) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", ex, 5);
                    }
                    HashMap<String, JMSException> info = new HashMap<String, JMSException>();
                    info.put("exception1", je);
                    info.put("exception2", ex);
                    Trace.ffst(this, "c.i.m.c.wmq.internal.WMQConnectionBrowser", "XN00D007", info, null);
                }
            }
            catch (Throwable t) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", t, 6);
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("callType", new Integer(callType));
                data.put("cc", new Integer(compcode));
                data.put("rc", new Integer(reason));
                data.put("hconn2", hconn2);
                data.put("md", mqmd2);
                data.put("gmo", mqgmo2);
                data.put("cbc", mqcbc);
                data.put("connection", WMQConnectionBrowser.this.connection);
                data.put("destination", this.destination);
                if (WMQConnectionBrowser.this.fqSubName != null) {
                    data.put("subname", WMQConnectionBrowser.this.fqSubName);
                }
                if (pBuffer != null) {
                    data.put("pBuffer", pBuffer);
                } else {
                    data.put("pBuffer", "null");
                }
                data.put("exception", t);
                Trace.ffst(this, "consumer", "XN00D008", data, null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", 4);
            }
        }

        private WMQMessage unmarshal(MQMD mqmd2, ByteBuffer pBuffer, boolean unmarshalHeadersOnly) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "unmarshal(MQMD,ByteBuffer,boolean)", new Object[]{mqmd2, pBuffer, new Boolean(unmarshalHeadersOnly)});
            }
            if (null == this.receiveMarshal) {
                this.receiveMarshal = WMQMarshal.newReceiveMarshal();
            }
            pBuffer.rewind();
            this.receiveMarshal.importMQMDMesageBuffer(WMQConnectionBrowser.this.connection, this.destination, mqmd2, pBuffer, 0, pBuffer.limit());
            WMQMessage message = this.receiveMarshal.exportProviderMessage(unmarshalHeadersOnly);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "unmarshal(MQMD,ByteBuffer,boolean)", message);
            }
            return message;
        }

        private ByteBuffer browseHeaderData(Hconn hconn2, MQMD mqmd2, MQGMO mqgmo2, ByteBuffer pBuffer, MQCBC mqcbc) throws JmqiException, JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "browseHeaderData(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", new Object[]{hconn2, mqmd2, mqgmo2, pBuffer, mqcbc});
            }
            pBuffer.rewind();
            ByteBuffer buff = pBuffer;
            int hdrLen = this.getHeaderLength(hconn2, mqmd2, pBuffer);
            if (hdrLen < 0) {
                buff.limit(0);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "browseHeaderData(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", buff, 1);
                }
                return buff;
            }
            int msgLen = mqgmo2.getReturnedLength();
            if (msgLen == -1) {
                msgLen = mqcbc.getDataLength() < pBuffer.limit() ? mqcbc.getDataLength() : pBuffer.limit();
            }
            if (hdrLen > msgLen) {
                buff = this.rebrowseMessage(mqgmo2.getMsgToken(), hdrLen);
            } else if (hdrLen < pBuffer.limit()) {
                pBuffer.limit(hdrLen);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "browseHeaderData(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", buff, 2);
            }
            return buff;
        }

        private ByteBuffer rebrowseMessage(byte[] token, int msgLen) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "rebrowseMessage(byte [ ],int)", new Object[]{token, new Integer(msgLen)});
            }
            Pint rc = this.env.newPint();
            Pint cc = this.env.newPint();
            this.initialiseSecondHobj();
            MQGMO gmo = this.env.newMQGMO();
            if (gmo.getVersion() < 3) {
                gmo.setVersion(3);
            }
            int options = 84;
            options = this.qmIsZOS() && WMQConnectionBrowser.this.quantityHint == 1 ? (options &= 0xFFFFBFFF) : (options |= this.gmoConvertOption);
            gmo.setOptions(options);
            gmo.setMatchOptions(32);
            gmo.setMsgToken(token);
            MQMD newmqmd = this.env.newMQMD();
            ByteBuffer buffer = ByteBuffer.allocate(msgLen);
            Pint dataLen = this.env.newPint();
            this.mq.MQGET(this.hconn, this.secondHobj, newmqmd, gmo, msgLen, buffer, dataLen, cc, rc);
            if (rc.x != 2079) {
                WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ2002", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN00D009", this.helper.getConnection(), this.hconn);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "rebrowseMessage(byte [ ],int)", buffer);
            }
            return buffer;
        }

        private int getHeaderLength(Hconn hconn2, MQMD mqmd2, ByteBuffer pBuffer) throws JmqiException, JMSException {
            JmqiCodepage cp;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "getHeaderLength(Hconn,MQMD,ByteBuffer)", new Object[]{hconn2, mqmd2, pBuffer});
            }
            if (!"MQHRF2  ".equals(mqmd2.getFormat())) {
                int traceRet1 = -1;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "getHeaderLength(Hconn,MQMD,ByteBuffer)", new Integer(traceRet1), 1);
                }
                return traceRet1;
            }
            MQRFH rfh = this.env.newMQRFH(10);
            MQHeader header = rfh.getMqHeader();
            JmqiSystemEnvironment sysenv = (JmqiSystemEnvironment)this.env;
            WMQThreadLocalStorage tls = WMQConnectionBrowser.this.connection.getThreadLocalStorage();
            JmqiTls jTls = sysenv.getJmqiTls((JmqiComponentTls)tls);
            int encoding = mqmd2.getEncoding();
            int previousCcsid = hconn2.getCcsid();
            int ccsid = mqmd2.getCodedCharSetId();
            if (ccsid == -2) {
                ccsid = previousCcsid;
            }
            if ((cp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)ccsid)) == null) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("CCSID", "ccsid:" + Integer.toString(ccsid));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ1046", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "getHeaderLength(Hconn,MQMD,ByteBuffer)", je);
                }
                throw je;
            }
            boolean swap = (encoding & 0xF) == 2;
            int ptrSize = 0;
            header.readFromBuffer(pBuffer.array(), 0, ptrSize, swap, cp, jTls);
            if (!"RFH ".equals(header.getStrucId())) {
                int traceRet2 = -1;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "getHeaderLength(Hconn,MQMD,ByteBuffer)", new Integer(traceRet2), 2);
                }
                return traceRet2;
            }
            int len = header.getStrucLength();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnectionBrowserShadow", "getHeaderLength(Hconn,MQMD,ByteBuffer)", new Integer(len), 3);
            }
            return len;
        }
    }
}

