/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.exits.MQCD;
import com.ibm.mq.exits.MQCSP;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.JmqiUtils;
import com.ibm.mq.jmqi.MQCBC;
import com.ibm.mq.jmqi.MQCBD;
import com.ibm.mq.jmqi.MQCNO;
import com.ibm.mq.jmqi.MQConsumer;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.MQSCO;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Hobj;
import com.ibm.mq.jmqi.handles.Phconn;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.remote.internal.ReconnectableHobj;
import com.ibm.mq.jmqi.system.JmqiConnectOptions;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.cssystem.WASSupport;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.TableBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderConnection;
import com.ibm.msg.client.provider.ProviderConnectionBrowser;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderExceptionListener;
import com.ibm.msg.client.provider.ProviderMessageReferenceHandler;
import com.ibm.msg.client.provider.ProviderMetaData;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.wmq.common.WMQThreadLocalStorage;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.common.internal.WMQCommonConnection;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo;
import com.ibm.msg.client.wmq.common.internal.WMQMetaData;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.common.internal.WMQTemporaryQueue;
import com.ibm.msg.client.wmq.common.internal.WMQTemporaryTopic;
import com.ibm.msg.client.wmq.internal.WMQConnectionBrowser;
import com.ibm.msg.client.wmq.internal.WMQConsumerOwnerShadow;
import com.ibm.msg.client.wmq.internal.WMQSession;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.JMSException;
import javax.net.ssl.SSLSocketFactory;

public class WMQConnection
extends WMQPropertyContext
implements ProviderConnection,
WMQCommonConnection,
WMQConsumerOwner,
MQConsumer {
    private static final long serialVersionUID = -2703683054810854326L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String persistenceFromMDProperty;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQConnection.java, jmscc.wmq, k701, k701-112-140304 1.159.1.24 13/11/26 14:35:35";
    private static String[] connectionModeMapppings;
    public static final int SHARING_CONVERSATION_UNDEFINED = -1;
    public static final int FAP_LEVEL_UNDEFINED = -1;
    private MQCNO connectOptions;
    private ProviderExceptionListener exceptionListener;
    private WMQConsumerOwnerShadow helper;
    private JmqiConnectOptions jmqiConnectOptions;
    private JmqiEnvironment jmqiEnvironment;
    private JmqiMQ jmqiMq;
    private int jmqiCompId;
    private WMQMetaData metaData;
    private boolean persistenceFromMD;
    private Phconn phconn;
    private String queueManagerName;
    private String resolvedQMName;
    private Boolean specComplientExceptionListener;
    protected String temporaryModelQ;
    protected Hashtable temporaryQueues = new Hashtable();
    protected String tempQPrefix;
    private Object UOWManagerObject = null;
    private Method getLocalUOWIdMethod = null;
    private boolean setupReflectionAttempted = false;

    private static Enumeration tokenise(String string) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQConnection", "tokenise(String)", new Object[]{string});
        }
        Vector<String> vector = new Vector<String>();
        boolean inQuotes = false;
        boolean firstQuote = false;
        int quote = 39;
        int comma = 44;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char thisChar = string.charAt(i);
            if (inQuotes) {
                if (firstQuote) {
                    if (thisChar == '\'') {
                        buffer.append(thisChar);
                    } else if (thisChar == ',') {
                        vector.add(new String(buffer));
                        buffer = new StringBuffer();
                        inQuotes = false;
                    } else {
                        buffer.append(thisChar);
                        inQuotes = false;
                    }
                    firstQuote = false;
                    continue;
                }
                if (thisChar == '\'') {
                    firstQuote = true;
                    continue;
                }
                buffer.append(thisChar);
                continue;
            }
            if (thisChar == ',') {
                vector.add(new String(buffer));
                buffer = new StringBuffer();
                continue;
            }
            if (thisChar == '\'') {
                inQuotes = true;
                continue;
            }
            buffer.append(thisChar);
        }
        vector.add(new String(buffer));
        Enumeration traceRet1 = vector.elements();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQConnection", "tokenise(String)", traceRet1);
        }
        return traceRet1;
    }

    public WMQConnection(JmqiEnvironment jmqiEnvironment, JmqiMQ jmqiMq, int jmqiCompId, JmsPropertyContext connectionProps) throws JMSException {
        super(connectionProps);
        HashMap<String, String> inserts;
        HashMap<String, Integer> info;
        String userid;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "<init>(JmqiEnvironment,JmqiMQ,int,JmsPropertyContext)", new Object[]{jmqiEnvironment, jmqiMq, new Integer(jmqiCompId), connectionProps});
        }
        this.jmqiEnvironment = jmqiEnvironment;
        this.jmqiMq = jmqiMq;
        this.jmqiCompId = jmqiCompId;
        this.phconn = jmqiEnvironment.newPhconn();
        JmqiSP sp = (JmqiSP)jmqiMq;
        Pint cc = jmqiEnvironment.newPint();
        Pint rc = jmqiEnvironment.newPint();
        Pint cc2 = jmqiEnvironment.newPint();
        Pint rc2 = jmqiEnvironment.newPint();
        this.getQueueManagerName();
        String ccdt = this.getStringProperty("XMSC_WMQ_CCDTURL");
        String channel = this.getStringProperty("XMSC_WMQ_CHANNEL");
        if (ccdt != null && channel != null && channel.length() > 0 && !channel.equals("SYSTEM.DEF.SVRCONN")) {
            HashMap<String, String> inserts2 = new HashMap<String, String>();
            inserts2.put("XMSC_INSERT_QUEUE_MANAGER", this.queueManagerName);
            inserts2.put("XMSC_WMQ_CONNECTION_MODE", connectionModeMapppings[this.getIntProperty("XMSC_WMQ_CONNECTION_MODE")]);
            inserts2.put("XMSC_WMQ_CCDTURL", ccdt);
            inserts2.put("XMSC_WMQ_CHANNEL", channel);
            JMSException je = Reason.createException("JMSWMQ2020", inserts2, 2423, 2, jmqiEnvironment);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "<init>(JmqiEnvironment,JmqiMQ,int,JmsPropertyContext)", je, 1);
            }
            throw je;
        }
        this.getJmqiConnectOptions();
        this.connectOptions = this.getConnectOptions();
        sp.jmqiConnect(this.queueManagerName, this.jmqiConnectOptions, this.connectOptions, null, this.phconn, cc, rc);
        if (cc.x == 1 && rc.x == 2267) {
            cc.x = 0;
            rc.x = 0;
        }
        if (cc.x == 1) {
            jmqiMq.MQDISC(this.phconn, cc2, rc2);
        } else if (cc.x == 0) {
            try {
                Hconn hconn = this.getHconn();
                sp.checkCmdLevel(hconn);
            }
            catch (JmqiException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "<init>(JmqiEnvironment,JmqiMQ,int,JmsPropertyContext)", e, 1);
                }
                cc.x = e.getCompCode();
                rc.x = e.getReason();
                jmqiMq.MQDISC(this.phconn, cc2, rc2);
            }
        }
        if (cc.x == 0 && (userid = this.jmqiConnectOptions.getUserIdentifier()) != null && !"".equals(userid.trim())) {
            Hconn hconn = this.getHconn();
            String password = this.jmqiConnectOptions.getPassword();
            jmqiMq.authenticate(hconn, userid, password, cc, rc);
            if (cc.x != 0) {
                jmqiMq.MQDISC(this.phconn, cc2, rc2);
            }
        }
        if (cc.x != 0) {
            String exceptionMessage;
            if (Reason.isImpossibleReason(rc.x, cc.x)) {
                HashMap<String, Object> info2 = new HashMap<String, Object>();
                info2.put("rc", rc);
                info2.put("cc", cc);
                info2.put("queuemanager", this.queueManagerName);
                info2.put("jmqiConnOpts", this.jmqiConnectOptions);
                info2.put("connOpts", this.connectOptions);
                Trace.ffst(this, "<init>(WMQConnection,int,JmsPropertyContext)", "XN001001", info2, JMSException.class);
            }
            HashMap<String, String> inserts3 = new HashMap<String, String>();
            inserts3.put("XMSC_INSERT_QUEUE_MANAGER", this.queueManagerName);
            inserts3.put("XMSC_WMQ_CONNECTION_MODE", connectionModeMapppings[this.getIntProperty("XMSC_WMQ_CONNECTION_MODE")]);
            if (rc.x == 2035) {
                if (ccdt == null) {
                    inserts3.put("XMSC_WMQ_HOST_NAME", this.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT"));
                    exceptionMessage = "JMSWMQ2013";
                } else {
                    inserts3.put("XMSC_WMQ_CCDTURL", ccdt);
                    exceptionMessage = "JMSWMQ2021";
                }
            } else if (ccdt == null) {
                inserts3.put("XMSC_WMQ_HOST_NAME", this.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT"));
                exceptionMessage = "JMSWMQ0018";
            } else {
                inserts3.put("XMSC_WMQ_CCDTURL", ccdt);
                exceptionMessage = "JMSWMQ2020";
            }
            JMSException je = Reason.createException(exceptionMessage, inserts3, rc.x, cc.x, jmqiEnvironment);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "<init>(JmqiEnvironment,JmqiMQ,int,JmsPropertyContext)", je, 2);
            }
            throw je;
        }
        WMQFFSTInfo.addConnection(this);
        try {
            this.resolvedQMName = this.getHconn().getName();
            if (this.resolvedQMName != null) {
                this.resolvedQMName = this.resolvedQMName.trim();
            }
            this.setStringProperty("XMSC_WMQ_RESOLVED_QUEUE_MANAGER", this.resolvedQMName);
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "<init>(JmqiEnvironment,JmqiMQ,int,JmsPropertyContext)", e, 2);
            }
            info = new HashMap<String, Integer>();
            info.put("reason", new Integer(e.getReason()));
            info.put("compcode", new Integer(e.getCompCode()));
            info.put("hconn", (Integer)this.phconn.getHconn());
            Trace.ffst(this, "<init>", "XN00100C", info, null);
            inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_QUEUE_MANAGER", this.queueManagerName);
            inserts.put("XMSC_WMQ_CONNECTION_MODE", connectionModeMapppings[this.getIntProperty("XMSC_WMQ_CONNECTION_MODE")]);
            String exceptionMessage = "JMSWMQ2019";
            JMSException je = Reason.createException(exceptionMessage, inserts, e.getReason(), e.getCompCode(), jmqiEnvironment);
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "<init>(JmqiEnvironment,JmqiMQ,int,JmsPropertyContext)", je, 4);
            }
            throw je;
        }
        try {
            this.setStringProperty("XMSC_WMQ_RESOLVED_QUEUE_MANAGER_ID", this.getHconn().getUid());
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "<init>(JmqiEnvironment,JmqiMQ,int,JmsPropertyContext)", e, 3);
            }
            info = new HashMap();
            info.put("reason", new Integer(e.getReason()));
            info.put("compcode", new Integer(e.getCompCode()));
            info.put("hconn", (Integer)this.getHconn());
            Trace.ffst(this, "<init>", "XN001010", info, null);
            inserts = new HashMap();
            inserts.put("XMSC_INSERT_QUEUE_MANAGER", this.queueManagerName);
            inserts.put("XMSC_WMQ_CONNECTION_MODE", connectionModeMapppings[this.getIntProperty("XMSC_WMQ_CONNECTION_MODE")]);
            String exceptionMessage = "JMSWMQ2019";
            JMSException je = Reason.createException(exceptionMessage, inserts, e.getReason(), e.getCompCode(), jmqiEnvironment);
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "<init>(JmqiEnvironment,JmqiMQ,int,JmsPropertyContext)", je, 5);
            }
            throw je;
        }
        try {
            String qmQsgName = this.getHconn().getQsgName();
            this.setStringProperty("XMSC_WMQ_REMOTE_QMGR_QSGNAME", qmQsgName);
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.data(this, "Ignoring JmqiException reported during getQSGName check", (Object)"");
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "<init>(JmqiEnvironment,JmqiMQ,int,JmsPropertyContext)", e);
            }
            this.setStringProperty("XMSC_WMQ_REMOTE_QMGR_QSGNAME", "UNKNOWN");
        }
        this.helper = new WMQConsumerOwnerShadow(this, this.queueManagerName);
        String persistenceFromMDAsString = PropertyStore.getStringProperty(persistenceFromMDProperty);
        this.persistenceFromMD = persistenceFromMDAsString != null && persistenceFromMDAsString.equalsIgnoreCase("ON");
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "<init>(JmqiEnvironment,JmqiMQ,int,JmsPropertyContext)");
        }
    }

    private String accessTemporaryQueue(Phobj phobj) throws JMSException {
        int fiq;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "accessTemporaryQueue(Phobj)", new Object[]{phobj});
        }
        if (this.tempQPrefix == null) {
            this.tempQPrefix = this.getStringProperty("XMSC_WMQ_TEMP_Q_PREFIX");
        }
        if (this.temporaryModelQ == null) {
            this.temporaryModelQ = this.getStringProperty("XMSC_WMQ_TEMPORARY_MODEL");
        }
        String queueName = null;
        MQOD mqod = this.jmqiEnvironment.newMQOD();
        int openOptions = 16;
        if (this.temporaryModelQ != null && this.temporaryModelQ.length() > 0) {
            mqod.setObjectName(this.temporaryModelQ);
        }
        if (this.resolvedQMName != null && this.resolvedQMName.length() > 0) {
            mqod.setObjectQMgrName(this.resolvedQMName);
        }
        if (this.tempQPrefix != null && this.tempQPrefix.length() > 0) {
            mqod.setDynamicQName(this.tempQPrefix);
        }
        if ((fiq = this.getIntProperty("failIfQuiesce")) == 1) {
            if (Trace.isOn) {
                Trace.data(this, "Open fail-if-quiesce = yes", null);
            }
            openOptions |= 0x2000;
        } else {
            if (Trace.isOn) {
                Trace.data(this, "Open fail-if-quiesce = no", null);
            }
            openOptions &= 0xFFFFDFFF;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "accessTemporaryQueue", "queue = " + mqod.getObjectName() + "\nqueue manager = " + mqod.getObjectQMgrName() + "\ndynamic queue name = " + mqod.getDynamicQName() + "\nalternate user id = " + mqod.getAlternateUserId() + "\noptions = " + openOptions, null);
        }
        Pint pCompCode = new Pint(this.jmqiEnvironment);
        Pint pReason = new Pint(this.jmqiEnvironment);
        this.jmqiMq.MQOPEN(this.phconn.getHconn(), mqod, openOptions, phobj, pCompCode, pReason);
        if (pReason.x != 0 || pCompCode.x != 0) {
            if (Reason.isImpossibleReason(pReason.x, pCompCode.x)) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("pHConn", this.phconn);
                info.put("MQOD", mqod);
                info.put("openOptions", new Integer(openOptions));
                info.put("reason", pReason);
                info.put("compcode", pCompCode);
                info.put("hconn", this.phconn.getHconn());
                Trace.ffst(this, "accessTemporaryQueue", "XN001003", info, JMSException.class);
            }
            if (Reason.isConnectionBroken(pReason.x)) {
                JMSException e = Reason.createException("JMSWMQ1107", null, pReason.x, pCompCode.x, this.jmqiEnvironment);
                this.driveExceptionListener(e, true);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_DESTINATION_NAME", this.temporaryModelQ);
            JMSException je = Reason.createException("JMSWMQ2008", inserts, pReason.x, pCompCode.x, this.jmqiEnvironment);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "accessTemporaryQueue(Phobj)", je);
            }
            throw je;
        }
        queueName = mqod.getObjectName().trim();
        Hobj hobj = phobj.getHobj();
        if (hobj instanceof ReconnectableHobj) {
            ((ReconnectableHobj)hobj).setModelQueueName(this.temporaryModelQ);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "accessTemporaryQueue(Phobj)", queueName);
        }
        return queueName;
    }

    public void addAsyncConsumer() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "addAsyncConsumer()");
        }
        this.helper.addAsyncConsumer();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "addAsyncConsumer()");
        }
    }

    public void addQueueToCache(Phobj phobj, String queueName, String selector, int options) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "addQueueToCache(Phobj,String,String,int)", new Object[]{phobj, queueName, selector, new Integer(options)});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "addQueueToCache(Phobj,String,String,int)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "close()");
        }
        try {
            Pint cc = this.jmqiEnvironment.newPint();
            Pint rc = this.jmqiEnvironment.newPint();
            this.jmqiMq.MQDISC(this.phconn, cc, rc);
            if (rc.x != 0) {
                if (Reason.isImpossibleReason(rc.x, cc.x)) {
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("rc", rc);
                    info.put("cc", cc);
                    info.put("queuemanager", this.queueManagerName);
                    info.put("hconn", this.phconn.getHconn());
                    Trace.ffst(this, "close()", "XN001002", info, JMSException.class);
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_QUEUE_MANAGER", this.queueManagerName);
                inserts.put("XMSC_WMQ_CONNECTION_MODE", this.getStringProperty("XMSC_WMQ_CONNECTION_MODE"));
                inserts.put("XMSC_WMQ_HOST_NAME", this.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT"));
                JMSException je = Reason.createException("JMSWMQ0019", inserts, rc.x, cc.x, this.jmqiEnvironment);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "close()", je);
                }
                throw je;
            }
        }
        finally {
            WMQFFSTInfo.removeConnection(this);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "close()");
        }
    }

    public void consumer(Hconn hconn, MQMD mqmd, MQGMO mqgmo, ByteBuffer pBuffer, MQCBC mqcbc) {
        int callType;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", new Object[]{hconn, mqmd, mqgmo, pBuffer, mqcbc});
        }
        if ((callType = mqcbc.getCallType()) == 6) {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            data.put("callType", new Integer(callType));
            Trace.ffst(this, "consume(Hconn,MQMD,MQGMO,ByteNuffer,MQCBC)", "XN001004", data, null);
        } else if (callType == 7) {
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            data.put("callType", new Integer(callType));
            Trace.ffst(this, "consume(Hconn,MQMD,MQGMO,ByteNuffer,MQCBC)", "XN001005", data, null);
        } else if (callType == 5) {
            int rc = mqcbc.getReason();
            int cc = mqcbc.getCompCode();
            if (rc == 2033) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", 1);
                }
                return;
            }
            if (Reason.isImpossibleReason(rc, cc)) {
                HashMap<String, Serializable> info = new HashMap<String, Serializable>();
                info.put("connection", this);
                info.put("reason", new Integer(rc));
                info.put("compcode", new Integer(cc));
                info.put("hconn", (Serializable)hconn);
                Trace.ffst("WMQConnection", "consumer()", "XN001006", info, null);
            }
            String wmqMsg = NLSServices.getMessage("JMSWMQ2014", new Object[]{Integer.toString(cc), Integer.toString(rc)});
            MQException wmqex = new MQException(wmqMsg, "JMSWMQ2014", rc, cc);
            JMSException e = Reason.createException("JMSWMQ1107", null, rc, cc, this.jmqiEnvironment);
            e.setLinkedException((Exception)((Object)wmqex));
            try {
                this.driveExceptionListener(e, Reason.isConnectionBroken(rc));
            }
            catch (JMSException e2) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", e2);
                }
                HashMap<String, JMSException> info = new HashMap<String, JMSException>();
                info.put("exception1", e);
                info.put("exception2", e2);
                Trace.ffst(this, "consume(Hconn,MQMD,MQGMO,ByteNuffer,MQCBC)", "XN001007", info, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", 2);
        }
    }

    public ProviderConnectionBrowser createConnectionBrowser(ProviderDestination destination, String selector, ProviderMessageReferenceHandler msgRefHandler, int quantityHint) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "createConnectionBrowser(ProviderDestination,String,ProviderMessageReferenceHandler,int)", new Object[]{destination, selector, msgRefHandler, new Integer(quantityHint)});
        }
        WMQConnectionBrowser browser = new WMQConnectionBrowser(this, destination, null, selector, msgRefHandler, quantityHint, false);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "createConnectionBrowser(ProviderDestination,String,ProviderMessageReferenceHandler,int)", browser);
        }
        return browser;
    }

    public ProviderConnectionBrowser createDurableConnectionBrowser(ProviderDestination destination, String clientid, String subName, String selector, ProviderMessageReferenceHandler msgRefHandler, int quantityHint, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "createDurableConnectionBrowser(ProviderDestination,String,String,String,ProviderMessageReferenceHandler,int,boolean)", new Object[]{destination, clientid, subName, selector, msgRefHandler, new Integer(quantityHint), noLocal});
        }
        String streamName = this.getStringProperty("XMSC_WMQ_BROKER_PUBQ");
        String fqSubName = WMQSession.createFullSubscriptionName(clientid, subName, this.resolvedQMName, streamName);
        WMQConnectionBrowser browser = new WMQConnectionBrowser(this, destination, fqSubName, selector, msgRefHandler, quantityHint, noLocal);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "createDurableConnectionBrowser(ProviderDestination,String,String,String,ProviderMessageReferenceHandler,int,boolean)", browser);
        }
        return browser;
    }

    public ProviderSession createSession(JmsPropertyContext properties) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "createSession(JmsPropertyContext)", new Object[]{properties});
        }
        this.throwIfClosed();
        int ackMode = properties.getIntProperty("XMSC_ACKNOWLEDGE_MODE");
        WMQSession session = new WMQSession(this, ackMode, properties);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "createSession(JmsPropertyContext)", session);
        }
        return session;
    }

    public synchronized WMQDestination createTemporaryDestination(int destType, JmsPropertyContext propContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "createTemporaryDestination(int,JmsPropertyContext)", new Object[]{new Integer(destType), propContext});
        }
        WMQDestination dest = null;
        if (destType == 1) {
            Phobj phobj = this.jmqiEnvironment.newPhobj();
            String name = this.accessTemporaryQueue(phobj);
            String tempQMName = this.resolvedQMName == null ? this.getQueueManagerName() : this.resolvedQMName;
            dest = new WMQTemporaryQueue("queue://" + tempQMName + "/" + name, this, propContext);
            this.temporaryQueues.put(dest, phobj);
        } else if (destType == 2) {
            boolean addPrefixDelimiter = true;
            String tempTopicPrefix = this.getStringProperty("XMSC_WMQ_TEMP_TOPIC_PREFIX");
            if (tempTopicPrefix == null || tempTopicPrefix.equals("")) {
                addPrefixDelimiter = false;
                if (tempTopicPrefix == null) {
                    tempTopicPrefix = "";
                }
            }
            StringBuffer namesb = new StringBuffer("TEMP/");
            namesb.append(tempTopicPrefix);
            if (addPrefixDelimiter) {
                namesb.append('/');
            }
            namesb.append(this.hashCode());
            namesb.append(System.currentTimeMillis());
            dest = new WMQTemporaryTopic(namesb.toString(), this, propContext);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "createTemporaryDestination(int,JmsPropertyContext)", dest);
        }
        return dest;
    }

    public void decrementCloseCounter() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "decrementCloseCounter()");
        }
        this.helper.decrementCloseCounter();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "decrementCloseCounter()");
        }
    }

    public void deleteTemporaryDestination(WMQDestination dest) throws JMSException {
        Phobj phobj;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "deleteTemporaryDestination(WMQDestination)", new Object[]{dest});
        }
        if ((phobj = (Phobj)this.temporaryQueues.get(dest)) == null) {
            if (Trace.isOn) {
                Trace.data(this, "deleteTemporaryDestination(WMQDestination dest)", "Failed to find temporary queue in Hashtable", (Object)dest);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "deleteTemporaryDestination(WMQDestination)", 1);
            }
            return;
        }
        int options = 2;
        Pint pCompCode = this.jmqiEnvironment.newPint();
        Pint pReason = this.jmqiEnvironment.newPint();
        this.jmqiMq.MQCLOSE(this.phconn.getHconn(), phobj, options, pCompCode, pReason);
        if (pReason.x != 0 || pCompCode.x != 0) {
            if (Reason.isImpossibleReason(pReason.x, pCompCode.x)) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("pHConn", this.phconn);
                info.put("pHobj", phobj);
                info.put("closeOptions", new Integer(options));
                info.put("reason", pReason);
                info.put("compcode", pCompCode);
                Trace.ffst(this, "deleteTemporaryDestination", "XN001008", info, JMSException.class);
            }
            if (Reason.isConnectionBroken(pReason.x)) {
                JMSException e = Reason.createException("JMSWMQ1107", null, pReason.x, pCompCode.x, this.jmqiEnvironment);
                this.driveExceptionListener(e, true);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_DESTINATION_NAME", dest.getName());
            JMSException je = Reason.createException("JMSWMQ2000", inserts, pReason.x, pCompCode.x, this.jmqiEnvironment);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "deleteTemporaryDestination(WMQDestination)", je);
            }
            throw je;
        }
        this.temporaryQueues.remove(dest);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "deleteTemporaryDestination(WMQDestination)", 2);
        }
    }

    public void driveExceptionListener(JMSException e, boolean isConnectionBroken) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "driveExceptionListener(JMSException,boolean)", new Object[]{e, isConnectionBroken});
        }
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(e, isConnectionBroken);
        } else {
            if (Trace.isOn) {
                Trace.traceData(this, "driveExceptionListener(JMSException, boolean)", "No listener  - Exception ignored", (Object)e);
            }
            HashMap<String, JMSException> inserts = new HashMap<String, JMSException>();
            inserts.put("XMSC_INSERT_EXCEPTION", e);
            Log.log(this, "driveExceptionListener(JMSException, boolean)", "JMSWMQ2018", inserts);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "driveExceptionListener(JMSException,boolean)");
        }
    }

    public int getAckMode() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getAckMode()", "getter", new Integer(1));
        }
        return 1;
    }

    public int getCmdLevel() throws JmqiException {
        Hconn hconn = this.phconn.getHconn();
        int traceRet1 = hconn.getCmdLevel();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getCmdLevel()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getSharingConversations() throws JmqiException {
        Hconn hconn = this.phconn.getHconn();
        int traceRet1 = hconn.getNumberOfSharingConversations();
        if (traceRet1 == -1) {
            traceRet1 = -1;
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getSharingConversations()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getFapLevel() throws JmqiException {
        Hconn hconn = this.phconn.getHconn();
        int traceRet1 = hconn.getFapLevel();
        if (traceRet1 == -1) {
            traceRet1 = -1;
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getFapLevel()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public WMQCommonConnection getConnection() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getConnection()", "getter", this);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MQCNO getConnectOptions() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getConnectOptions()");
        }
        MQCNO connOptions = this.jmqiEnvironment.newMQCNO();
        MQSCO sslConfig = this.jmqiEnvironment.newMQSCO();
        connOptions.setSslConfig(sslConfig);
        boolean sslFipsRequired = this.getBooleanProperty("XMSC_WMQ_SSL_FIPS_REQUIRED");
        int value = sslFipsRequired ? 1 : 0;
        sslConfig.setFipsRequired(value);
        String sslCryptoHardware = this.getStringProperty("XMSC_WMQ_SSL_CRYPTO_HW");
        sslConfig.setCryptoHardware(sslCryptoHardware);
        String sslKeyRepository = this.getStringProperty("XMSC_WMQ_SSL_KEY_REPOSITORY");
        sslConfig.setKeyRepository(sslKeyRepository);
        int sslKeyResetCount = this.getIntProperty("XMSC_WMQ_SSL_KEY_RESETCOUNT");
        sslConfig.setKeyResetCount(sslKeyResetCount);
        int options = 0;
        try {
            if (this.jmqiMq.isSharedHandlesSupported()) {
                options |= 0x40;
            }
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getConnectOptions()", e);
            }
            HashMap<String, JmqiException> info = new HashMap<String, JmqiException>();
            info.put("exception", e);
            Trace.ffst(this, "c.i.m.c.wmq.internal.WMQConnection", "XN001009", info, JMSException.class);
        }
        switch (this.getIntProperty("XMSC_WMQ_SHARE_CONV_ALLOWED")) {
            case 0: {
                options |= 0x10000;
                break;
            }
        }
        int transport = this.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
        if (transport == 1) {
            switch (this.getIntProperty("XMSC_WMQ_CLIENT_RECONNECT_OPTIONS")) {
                case 0x4000000: {
                    options |= 0x4000000;
                    break;
                }
                case 0x1000000: {
                    options |= 0x1000000;
                    break;
                }
                case 0x2000000: {
                    break;
                }
                case 0: {
                    options |= 0;
                    break;
                }
            }
            this.jmqiConnectOptions.setReconnectionTimeout(this.getIntProperty("XMSC_WMQ_CLIENT_RECONNECT_TIMEOUT"));
        }
        int mask = -327905;
        connOptions.setOptions(options |= this.getIntProperty("XMSC_WMQ_CONNECT_OPTIONS") & mask);
        String url = this.getStringProperty("XMSC_WMQ_CCDTURL");
        if (url == null) {
            String localAddress;
            MQCD clientConn = this.jmqiEnvironment.newMQCD();
            connOptions.setClientConn(clientConn);
            String qMgrName = this.getStringProperty("XMSC_WMQ_QUEUE_MANAGER");
            if (qMgrName != null && !qMgrName.equals("")) {
                clientConn.setQMgrName(qMgrName);
            }
            if ((localAddress = this.getStringProperty("XMSC_WMQ_LOCAL_ADDRESS")) != null && !localAddress.equals("")) {
                clientConn.setLocalAddress(localAddress);
                clientConn.setVersion(7);
            }
            String userId = this.getStringProperty("XMSC_USERID");
            String password = this.getStringProperty("XMSC_PASSWORD");
            clientConn.setRemoteUserIdentifier(userId);
            clientConn.setRemotePassword(password);
            String connname = this.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT");
            if (connname != null && !connname.equals("")) {
                clientConn.setConnectionName(this.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT").trim());
            } else {
                HashMap data = new HashMap(this);
                Trace.ffst(this, "getConnectOptions()", "????????", data, null);
            }
            clientConn.setChannelName(this.getStringProperty("XMSC_WMQ_CHANNEL"));
            clientConn.setMaxMsgLength(0x6400000);
            String string = this.getStringProperty("XMSC_WMQ_RECEIVE_EXIT");
            if (string != null && string.trim().length() == 0) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getConnectOptions()", "Receive Exit", "Set exit string to null");
                string = null;
            }
            String fixedLengthString = this.makeFixedLengthStrings(string, JmqiEnvironment.MQ_EXIT_NAME_LENGTH);
            int count = this.getNumberOfExitsDefined(fixedLengthString, JmqiEnvironment.MQ_EXIT_NAME_LENGTH);
            clientConn.setReceiveExitPtr(fixedLengthString);
            clientConn.setReceiveExitsDefined(count);
            string = this.getStringProperty("XMSC_WMQ_RECEIVE_EXIT_INIT");
            fixedLengthString = this.makeFixedLengthStrings(string, 32);
            if (this.jmqiConnectOptions != null) {
                this.jmqiConnectOptions.setReceiveExitsUserData(fixedLengthString);
            }
            if ((string = this.getStringProperty("XMSC_WMQ_SEND_EXIT")) != null && string.trim().length() == 0) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getConnectOptions()", "Send Exit", "Set exit string to null");
                string = null;
            }
            fixedLengthString = this.makeFixedLengthStrings(string, JmqiEnvironment.MQ_EXIT_NAME_LENGTH);
            count = this.getNumberOfExitsDefined(fixedLengthString, JmqiEnvironment.MQ_EXIT_NAME_LENGTH);
            clientConn.setSendExitPtr(fixedLengthString);
            clientConn.setSendExitsDefined(count);
            string = this.getStringProperty("XMSC_WMQ_SEND_EXIT_INIT");
            fixedLengthString = this.makeFixedLengthStrings(string, 32);
            if (this.jmqiConnectOptions != null) {
                this.jmqiConnectOptions.setSendExitsUserData(fixedLengthString);
            }
            string = this.getStringProperty("XMSC_WMQ_SECURITY_EXIT");
            clientConn.setSecurityExit(string);
            string = this.getStringProperty("XMSC_WMQ_SECURITY_EXIT_INIT");
            clientConn.setSecurityUserData(string);
            if (this.jmqiConnectOptions != null) {
                this.jmqiConnectOptions.setSecurityExitUserData(string);
            }
            String sslCipherSpec = this.getStringProperty("XMSC_WMQ_SSL_CIPHER_SPEC");
            String sslCipherSuite = this.getStringProperty("XMSC_WMQ_SSL_CIPHER_SUITE");
            if (sslCipherSuite != null && sslCipherSuite.length() == 0) {
                sslCipherSuite = null;
            }
            if (sslCipherSpec == null) {
                if (sslCipherSuite != null) {
                    sslCipherSpec = JmqiUtils.toCipherSpec((String)sslCipherSuite, (boolean)sslFipsRequired);
                    if (sslCipherSpec != null) {
                        clientConn.setSslCipherSpec(sslCipherSpec);
                    } else {
                        HashMap<String, String> inserts = new HashMap<String, String>();
                        inserts.put("XMSC_INSERT_QUEUE_MANAGER", this.queueManagerName);
                        inserts.put("XMSC_WMQ_CONNECTION_MODE", connectionModeMapppings[this.getIntProperty("XMSC_WMQ_CONNECTION_MODE")]);
                        inserts.put("XMSC_WMQ_HOST_NAME", this.getStringProperty("XMSC_WMQ_HOST_NAME"));
                        JMSException e = Reason.createException("JMSWMQ0018", inserts, 2400, 2, this.jmqiEnvironment);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getConnectOptions()", e);
                        }
                        throw e;
                    }
                }
            } else {
                clientConn.setSslCipherSpec(sslCipherSpec);
            }
            String sslPeerName = this.getStringProperty("XMSC_WMQ_SSL_PEER_NAME");
            clientConn.setSslPeerName(sslPeerName);
            Object hdrComp = this.getObjectProperty("XMSC_WMQ_HEADER_COMP");
            if (hdrComp instanceof String) {
                clientConn.setHdrCompList(this.getHdrCompArray((String)hdrComp));
            } else if (hdrComp instanceof Collection) {
                clientConn.setHdrCompList(this.getHdrCompArray((Collection)hdrComp));
            } else {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("hdrComp", hdrComp != null ? hdrComp.toString() : "<null>");
                if (hdrComp != null) {
                    data.put("class", hdrComp.getClass().getName());
                }
                Trace.ffst(this, "getConnectOptions()", "XN00100D", data, null);
            }
            Object msgComp = this.getObjectProperty("XMSC_WMQ_MSG_COMP");
            if (msgComp instanceof String) {
                clientConn.setMsgCompList(this.getMsgCompArray((String)msgComp));
            } else if (msgComp instanceof Collection) {
                clientConn.setMsgCompList(this.getMsgCompArray((Collection)msgComp));
            } else {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("msgComp", msgComp != null ? msgComp.toString() : "<null>");
                if (msgComp != null) {
                    data.put("class", msgComp.getClass().getName());
                }
                Trace.ffst(this, "getConnectOptions()", "XN00100E", data, null);
            }
        }
        byte[] connTag = this.getBytesProperty("XMSC_WMQ_CONNECTION_TAG");
        connOptions.setConnTag(connTag);
        String username = this.getStringProperty("XMSC_USERID");
        String password = this.getStringProperty("XMSC_PASSWORD");
        if (transport == 0 && username != null && username.trim().length() > 0) {
            MQCSP csp = this.jmqiEnvironment.newMQCSP();
            csp.setCspUserId(username);
            csp.setCspPassword(password);
            csp.setAuthenticationType(1);
            connOptions.setSecurityParms(csp);
        } else {
            connOptions.setSecurityParms(null);
        }
        connOptions.setVersion(5);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getConnectOptions()", connOptions);
        }
        return connOptions;
    }

    public Hconn getHconn() {
        Hconn traceRet1 = this.phconn.getHconn();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getHconn()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public JmqiConnectOptions getJmqiConnectOptions() throws JMSException {
        block15: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getJmqiConnectOptions()");
            }
            if (this.jmqiConnectOptions == null) {
                String sslCertStoresStr;
                block14: {
                    JmqiSystemEnvironment jmqiSystemEnvironment = (JmqiSystemEnvironment)this.jmqiEnvironment;
                    this.jmqiConnectOptions = jmqiSystemEnvironment.newJmqiConnectOptions();
                    String userid = this.getStringProperty("XMSC_USERID");
                    this.jmqiConnectOptions.setUserIdentifier(userid);
                    String password = this.getStringProperty("XMSC_PASSWORD");
                    this.jmqiConnectOptions.setPassword(password);
                    try {
                        String value = this.getStringProperty("XMSC_WMQ_CCDTURL");
                        URL url = value != null ? new URL(value) : null;
                        this.jmqiConnectOptions.setCcdtUrl(url);
                    }
                    catch (MalformedURLException e) {
                        if (!Trace.isOn) break block14;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getJmqiConnectOptions()", e, 1);
                    }
                }
                Collection sslCertStoresCol = (Collection)this.getObjectProperty("XMSC_WMQ_SSL_CERT_STORES_COL");
                if (sslCertStoresCol == null && (sslCertStoresStr = this.getStringProperty("XMSC_WMQ_SSL_CERT_STORES_STR")) != null && !sslCertStoresStr.trim().equals("")) {
                    try {
                        sslCertStoresCol = JmqiUtils.getCertStoreCollectionFromSpaceSeperatedString((String)sslCertStoresStr);
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getJmqiConnectOptions()", e, 2);
                        }
                        HashMap<String, String> info = new HashMap<String, String>();
                        info.put("XMSC_INSERT_VALUE", sslCertStoresStr);
                        info.put("XMSC_INSERT_PROPERTY", "XMSC_WMQ_SSL_CERT_STORES_STR");
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ1006", info));
                        je.setLinkedException(e);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getJmqiConnectOptions()", je);
                        }
                        throw je;
                    }
                }
                this.jmqiConnectOptions.setCrlCertStores(sslCertStoresCol);
                SSLSocketFactory sslSocketFactory = (SSLSocketFactory)this.getObjectProperty("XMSC_WMQ_SSL_SOCKET_FACTORY");
                this.jmqiConnectOptions.setSslSocketFactory(sslSocketFactory);
                int ccsid = this.getIntProperty("XMSC_WMQ_QMGR_CCSID");
                this.jmqiConnectOptions.setQueueManagerCCSID(ccsid);
                try {
                    WASSupport.WASRuntimeHelper helper;
                    boolean optimize = PropertyStore.getBooleanProperty("com.ibm.msg.client.wmq.overrideInheritRRSContext");
                    if (optimize && (helper = (WASSupport.WASRuntimeHelper)PropertyStore.getObjectProperty("com.ibm.mq.connector.JCARuntimeHelper")) != null && WASSupport.getWASSupport().isWASCommonServicesPresent() && helper.getEnvironment() == 32) {
                        this.jmqiConnectOptions.setWASLocalUOWID(new JmqiConnectOptions.JmqiOptionAdapter(){

                            public long getLongOption() {
                                long rrsTranID;
                                block5: {
                                    if (Trace.isOn) {
                                        Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getLongOption()");
                                    }
                                    rrsTranID = -1L;
                                    try {
                                        rrsTranID = helper.getLocalRRSTranId();
                                        if (rrsTranID == -1L) {
                                            rrsTranID = WMQConnection.this.fakeGetLocalRRSTrandId();
                                        }
                                    }
                                    catch (IllegalStateException e) {
                                        if (!Trace.isOn) break block5;
                                        Trace.data(this, "com.ibm.msg.client.wmq.internal.null", "IllegalStateException from WAS", (Object)e);
                                    }
                                }
                                if (Trace.isOn) {
                                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.null", "getLongOption()", new Long(rrsTranID));
                                }
                                return rrsTranID;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getJmqiConnectOptions()", e, 3);
                    }
                    if (!Trace.isOn) break block15;
                    Trace.traceInfo(this, "WMQConnection", "getJmqiConnectOptions()", (Object)("Failed to setup the 2PC optimization " + e));
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getJmqiConnectOptions()", this.jmqiConnectOptions);
        }
        return this.jmqiConnectOptions;
    }

    public JmqiEnvironment getJmqiEnvironment() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getJmqiEnvironment()", "getter", this.jmqiEnvironment);
        }
        return this.jmqiEnvironment;
    }

    public JmqiMQ getJmqiMQ() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getJmqiMQ()", "getter", this.jmqiMq);
        }
        return this.jmqiMq;
    }

    public ProviderMetaData getMetaData() throws JMSException {
        if (this.metaData == null) {
            String providerVersion = this.getStringProperty("XMSC_WMQ_PROVIDER_VERSION");
            this.metaData = new WMQMetaData(providerVersion);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getMetaData()", "getter", this.metaData);
        }
        return this.metaData;
    }

    public String getName() throws JmqiException {
        Hconn hconn = this.phconn.getHconn();
        String traceRet1 = hconn.getName();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getName()", "getter", traceRet1);
        }
        return traceRet1;
    }

    private int getNumberOfExitsDefined(String fixedLengthString, int length) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getNumberOfExitsDefined(String,int)", new Object[]{fixedLengthString, new Integer(length)});
        }
        int result = 0;
        if (fixedLengthString != null) {
            result = fixedLengthString.length() / length;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getNumberOfExitsDefined(String,int)", new Integer(result));
        }
        return result;
    }

    public boolean getPersistenceFromMD() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getPersistenceFromMD()", "getter", this.persistenceFromMD);
        }
        return this.persistenceFromMD;
    }

    public int getPlatform() throws JmqiException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getPlatform()");
        }
        Hconn hconn = this.phconn.getHconn();
        int traceRet1 = hconn.getPlatform();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getPlatform()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Phobj getQueueFromCache(String queueName, String selector, int options) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getQueueFromCache(String,String,int)", new Object[]{queueName, selector, new Integer(options)});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getQueueFromCache(String,String,int)", null);
        }
        return null;
    }

    public String getQueueManagerName() throws JMSException {
        if (this.queueManagerName == null) {
            this.queueManagerName = this.getStringProperty("XMSC_WMQ_QUEUE_MANAGER");
        }
        if (this.queueManagerName != null) {
            this.queueManagerName = this.queueManagerName.trim();
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getQueueManagerName()", "getter", this.queueManagerName);
        }
        return this.queueManagerName;
    }

    public boolean getTransacted() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getTransacted()", "getter", false);
        }
        return false;
    }

    public String getUid() throws JmqiException {
        Hconn hconn = this.phconn.getHconn();
        String traceRet1 = hconn.getUid();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getUid()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void incrementCloseCounter() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "incrementCloseCounter()");
        }
        this.helper.incrementCloseCounter();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "incrementCloseCounter()");
        }
    }

    public boolean isAsyncRunning() {
        boolean traceRet1 = this.helper.isAsyncRunning();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "isAsyncRunning()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public boolean isSubscriptionInUse(String subscriptionName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "isSubscriptionInUse(String)", new Object[]{subscriptionName});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "isSubscriptionInUse(String)", false);
        }
        return false;
    }

    private String makeFixedLengthStrings(String input, int length) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "makeFixedLengthStrings(String,int)", new Object[]{input, new Integer(length)});
        }
        String result = null;
        if (input != null) {
            Enumeration eTokens = WMQConnection.tokenise(input);
            StringBuffer buffer = new StringBuffer();
            while (eTokens.hasMoreElements()) {
                String exit = (String)eTokens.nextElement();
                if (exit.length() > length) {
                    exit = exit.substring(0, length);
                }
                buffer.append(exit);
                for (int j = exit.length(); j < length; ++j) {
                    buffer.append(' ');
                }
            }
            result = buffer.toString();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "makeFixedLengthStrings(String,int)", result);
        }
        return result;
    }

    public void removeAsyncConsumer() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "removeAsyncConsumer()");
        }
        this.helper.removeAsyncConsumer();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "removeAsyncConsumer()");
        }
    }

    public boolean removeQueueFromCache(Phobj phobj) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "removeQueueFromCache(Phobj)", new Object[]{phobj});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "removeQueueFromCache(Phobj)", true);
        }
        return true;
    }

    public void removeSubscription(String subscriptionName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "removeSubscription(String)", new Object[]{subscriptionName});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "removeSubscription(String)");
        }
    }

    public void resumeAsyncService() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "resumeAsyncService()");
        }
        this.helper.resumeAsyncService();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "resumeAsyncService()");
        }
    }

    public void setExceptionListener(ProviderExceptionListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "setExceptionListener(ProviderExceptionListener)", new Object[]{listener});
        }
        int transport = this.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
        if (this.exceptionListener != null && listener != null) {
            this.exceptionListener = listener;
        } else if (this.exceptionListener != null || listener != null) {
            if (listener != null && transport != 0) {
                MQCBD cbd = this.jmqiEnvironment.newMQCBD();
                cbd.setCallbackFunction((MQConsumer)this);
                cbd.setCallbackType(2);
                boolean didSuspend = this.suspendAsyncService();
                Phobj pHobj = this.jmqiEnvironment.newPhobj();
                Pint cc = this.jmqiEnvironment.newPint();
                Pint rc = this.jmqiEnvironment.newPint();
                this.jmqiMq.MQCB(this.phconn.getHconn(), 256, cbd, pHobj.getHobj(), null, null, cc, rc);
                if (rc.x != 0 || cc.x != 0) {
                    if (Reason.isImpossibleReason(rc.x, cc.x)) {
                        HashMap<String, Object> info = new HashMap<String, Object>();
                        info.put("messageid", "JMSWMQ2016");
                        info.put("connection", this);
                        info.put("reason", rc);
                        info.put("compcode", cc);
                        info.put("hconn", this.phconn.getHconn());
                        Trace.ffst("WMQConnection", "setExceptionListener", "XN00100A", info, JMSException.class);
                    }
                    JMSException je = Reason.createException("JMSWMQ2016", null, rc.x, cc.x, this.jmqiEnvironment);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "setExceptionListener(ProviderExceptionListener)", je, 1);
                    }
                    throw je;
                }
                if (didSuspend) {
                    this.resumeAsyncService();
                }
            } else if (transport != 0) {
                this.suspendAsyncService();
                MQCBD cbd = this.jmqiEnvironment.newMQCBD();
                cbd.setCallbackType(2);
                Phobj pHobj = this.jmqiEnvironment.newPhobj();
                Pint cc = this.jmqiEnvironment.newPint();
                Pint rc = this.jmqiEnvironment.newPint();
                this.jmqiMq.MQCB(this.phconn.getHconn(), 512, cbd, pHobj.getHobj(), null, null, cc, rc);
                if (rc.x != 0 || cc.x != 0) {
                    if (Reason.isImpossibleReason(rc.x, cc.x)) {
                        HashMap<String, Object> info = new HashMap<String, Object>();
                        info.put("messageid", "JMSWMQ2017");
                        info.put("connection", this);
                        info.put("reason", rc);
                        info.put("compcode", cc);
                        info.put("hconn", this.phconn.getHconn());
                        Trace.ffst("WMQConnection", "setExceptionListener", "XN00100B", info, JMSException.class);
                    }
                    JMSException je = Reason.createException("JMSWMQ2017", null, rc.x, cc.x, this.jmqiEnvironment);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "setExceptionListener(ProviderExceptionListener)", je, 2);
                    }
                    throw je;
                }
                this.resumeAsyncService();
            }
            this.exceptionListener = listener;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "setExceptionListener(ProviderExceptionListener)");
        }
    }

    public void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "start()");
        }
        this.helper.start();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "start()");
        }
    }

    public void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "stop()");
        }
        this.helper.stop();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "stop()");
        }
    }

    public boolean suspendAsyncService() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "suspendAsyncService()");
        }
        boolean didSuspend = this.helper.suspendAsyncService();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "suspendAsyncService()", didSuspend);
        }
        return didSuspend;
    }

    private void throwIfClosed() throws javax.jms.IllegalStateException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "throwIfClosed()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "throwIfClosed()");
        }
    }

    public void validateProperty(String name, Object value) throws JMSException {
        boolean isValid;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "validateProperty(String,Object)", new Object[]{name, value});
        }
        if (!(isValid = true)) {
            this.throwValidationException(name, value, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "validateProperty(String,Object)");
        }
    }

    public int getJmqiCompId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getJmqiCompId()", "getter", new Integer(this.jmqiCompId));
        }
        return this.jmqiCompId;
    }

    public int getCloseCounter() {
        int traceRet1 = this.helper.getCloseCounter();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getCloseCounter()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Object getHconnLock() {
        Object traceRet1 = this.helper.getHconnLock();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getHconnLock()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public String toString() {
        TableBuilder builder = new TableBuilder();
        builder.append("Instance", super.toString());
        builder.append("connectOptions", this.connectOptions);
        builder.append("exceptionListener", this.exceptionListener);
        builder.append("helper", this.helper);
        builder.append("queueManagerName", this.queueManagerName);
        builder.append("temporaryModelQ", this.temporaryModelQ);
        builder.append("tempQPrefix", this.tempQPrefix);
        return builder.toString();
    }

    public void operationPerformed(WMQConsumerOwner.Operation operation, boolean syncpoint) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "operationPerformed(Operation,boolean)", new Object[]{operation, syncpoint});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "operationPerformed(Operation,boolean)");
        }
    }

    private int[] getHdrCompArray(String value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getHdrCompArray(String)", new Object[]{value});
        }
        StringTokenizer st = new StringTokenizer(value);
        int[] result = new int[st.countTokens()];
        int pos = 0;
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            if (tk.equals("NONE")) {
                result[pos++] = 0;
                continue;
            }
            if (tk.equals("SYSTEM")) {
                result[pos++] = 8;
                continue;
            }
            try {
                result[pos] = Integer.parseInt(tk);
                ++pos;
            }
            catch (NumberFormatException nfe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getHdrCompArray(String)", nfe);
                }
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("value", value);
                Trace.ffst(this, "getHdrCompArray(String)", "XN00100F", data, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getHdrCompArray(String)", result);
        }
        return result;
    }

    private int[] getHdrCompArray(Collection value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getHdrCompArray(Collection)", new Object[]{value});
        }
        StringBuffer buff = new StringBuffer();
        Iterator i = value.iterator();
        while (i.hasNext()) {
            buff.append(i.next().toString());
            if (!i.hasNext()) continue;
            buff.append(" ");
        }
        int[] traceRet1 = this.getHdrCompArray(buff.toString());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getHdrCompArray(Collection)", traceRet1);
        }
        return traceRet1;
    }

    private int[] getMsgCompArray(String value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getMsgCompArray(String)", new Object[]{value});
        }
        StringTokenizer st = new StringTokenizer(value);
        int[] result = new int[st.countTokens()];
        int pos = 0;
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            if (tk.equals("NONE")) {
                result[pos++] = 0;
                continue;
            }
            if (tk.equals("RLE")) {
                result[pos++] = 1;
                continue;
            }
            if (tk.equals("ZLIBFAST")) {
                result[pos++] = 2;
                continue;
            }
            if (tk.equals("ZLIBHIGH")) {
                result[pos++] = 4;
                continue;
            }
            try {
                result[pos] = Integer.parseInt(tk);
                ++pos;
            }
            catch (NumberFormatException nfe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getMsgCompArray(String)", nfe);
                }
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("value", value);
                Trace.ffst(this, "getMsgCompArray(String)", "XN00100G", data, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getMsgCompArray(String)", result);
        }
        return result;
    }

    private int[] getMsgCompArray(Collection value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getMsgCompArray(Collection)", new Object[]{value});
        }
        StringBuffer buff = new StringBuffer();
        Iterator i = value.iterator();
        while (i.hasNext()) {
            buff.append(i.next().toString());
            if (!i.hasNext()) continue;
            buff.append(" ");
        }
        int[] traceRet1 = this.getMsgCompArray(buff.toString());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getMsgCompArray(Collection)", traceRet1);
        }
        return traceRet1;
    }

    private long fakeGetLocalRRSTrandId() {
        long uow;
        block10: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "fakeGetLocalRRSTrandId()");
            }
            uow = -1L;
            try {
                if (!this.setupReflectionAttempted) {
                    this.setupUOWRelfection();
                }
                if (this.UOWManagerObject != null && this.getLocalUOWIdMethod != null) {
                    Object longObj = this.getLocalUOWIdMethod.invoke(this.UOWManagerObject, null);
                    uow = (Long)longObj;
                    if (Trace.isOn) {
                        Trace.traceInfo(this, "WMQConnection", "fakeGetLocalRRSTrandId()", (Object)("UOW id=" + uow));
                    }
                } else if (Trace.isOn) {
                    Trace.traceInfo(this, "WMQConnection", "fakeGetLocalRRSTrandId()", (Object)"Can't proceed method setupUOWReflection failed");
                }
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "fakeGetLocalRRSTrandId()", e);
                }
                if (!Trace.isOn) break block10;
                Trace.catchBlock(this, "WMQConnection", "fakeGetLocalRRSTrandId()", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQConnection", "fakeGetLocalRRSTrandId()", new Long(uow));
        }
        return uow;
    }

    private void setupUOWRelfection() {
        block5: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "setupUOWRelfection()");
            }
            try {
                Class registryClass = CSSystem.dynamicLoadClass("com.ibm.ws.uow.UOWManagerFactory", this.getClass());
                Method getUOWManager = registryClass.getDeclaredMethod("getUOWManager", null);
                this.UOWManagerObject = getUOWManager.invoke((Object)registryClass, null);
                this.getLocalUOWIdMethod = this.UOWManagerObject.getClass().getDeclaredMethod("getLocalUOWId", null);
                this.setupReflectionAttempted = true;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "setupUOWRelfection()", e);
                }
                if (!Trace.isOn) break block5;
                Trace.catchBlock(this, "WMQConnection", "setupUOWRelfection()", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "setupUOWRelfection()");
        }
    }

    public WMQThreadLocalStorage getThreadLocalStorage() {
        JmqiSystemEnvironment sysenv = (JmqiSystemEnvironment)this.jmqiEnvironment;
        WMQThreadLocalStorage traceRet1 = (WMQThreadLocalStorage)sysenv.getComponentTls(this.jmqiCompId);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQConnection", "getThreadLocalStorage()", "getter", (Object)traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQConnection", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQConnection.java, jmscc.wmq, k701, k701-112-140304  1.159.1.24 13/11/26 14:35:35");
        }
        persistenceFromMDProperty = "com.ibm.mq.jms.tuning.usePersistenceFromMD";
        connectionModeMapppings = new String[]{"Bindings", "Client", "DirectTCPIP", "", "DirectHTTP", "ClientUnmanged", "", "", "ClientThenBindings"};
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.internal.WMQConnection", "static()");
        }
        PropertyStore.register(persistenceFromMDProperty, null);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQConnection", "static()");
        }
    }
}

