/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.MQCBC;
import com.ibm.mq.jmqi.MQCBD;
import com.ibm.mq.jmqi.MQConsumer;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageListener;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.internal.WMQConnection;
import com.ibm.msg.client.wmq.internal.WMQConsumerShadow;
import com.ibm.msg.client.wmq.internal.WMQMessageConsumer;
import com.ibm.msg.client.wmq.internal.WMQSession;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.jms.JMSException;

class WMQAsyncConsumerShadow
extends WMQConsumerShadow
implements MQConsumer {
    private static final int closeWaitTime = 30000;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQAsyncConsumerShadow.java, jmscc.wmq, k701, k701-112-140304 1.69.1.11 13/12/05 11:08:01";
    private boolean delayedCloseFinished = false;
    private Object delayedCloseLock = new Object();
    protected ProviderMessageListener listener = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    WMQAsyncConsumerShadow(JmsPropertyContext jmsProps, WMQConsumerOwner helper, WMQDestination destination, String selector, boolean nolocal, String subscriptionName) {
        super(jmsProps, helper, destination, selector, nolocal, subscriptionName, null);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "<init>(JmsPropertyContext,WMQConsumerOwner,WMQDestination,String,boolean,String)", new Object[]{jmsProps, helper, destination, selector, nolocal, subscriptionName});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "<init>(JmsPropertyContext,WMQConsumerOwner,WMQDestination,String,boolean,String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "closeInternal()");
        }
        Pint rc = this.env.newPint();
        Pint cc = this.env.newPint();
        boolean hobjAlreadyClosed = false;
        int closePolicy = this.destination.getIntProperty("readAheadClosePolicy");
        if (closePolicy == 2) {
            int closeOptions = 32;
            this.mq.MQCLOSE(this.hconn, this.phobj, closeOptions, cc, rc);
            if (cc.x == 1 && rc.x == 2458) {
                Object object = this.delayedCloseLock;
                synchronized (object) {
                    this.helper.resumeAsyncService();
                    if (!this.delayedCloseFinished) {
                        block17: {
                            try {
                                this.delayedCloseLock.wait(30000L);
                            }
                            catch (InterruptedException e) {
                                if (!Trace.isOn) break block17;
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "closeInternal()", e);
                            }
                        }
                        if (!this.delayedCloseFinished) {
                            HashMap<String, String> inserts = new HashMap<String, String>();
                            inserts.put("XMSC_DESTINATION_NAME", this.destination.getName());
                            JMSException traceRet1 = (JMSException)((Object)NLSServices.createException("JMSWMQ2001", inserts));
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "closeInternal()", traceRet1);
                            }
                            throw traceRet1;
                        }
                    }
                    this.helper.suspendAsyncService();
                }
            }
            if (this.destination.isTopic()) {
                WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ2003", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN00M001", this.helper.getConnection(), this.hconn);
                hobjAlreadyClosed = true;
            } else {
                WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ2000", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN00M001", this.helper.getConnection(), this.hconn);
                this.helper.removeAsyncConsumer();
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "closeInternal()", 1);
                }
                return;
            }
        }
        this.helper.removeAsyncConsumer();
        if (this.destination.isTopic()) {
            this.mq.MQCLOSE(this.hconn, this.phsub, 0, cc, rc);
            WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ0025", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN004009", this.helper.getConnection(), this.hconn);
        }
        if (!hobjAlreadyClosed) {
            this.mq.MQCLOSE(this.hconn, this.phobj, 0, cc, rc);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "closeInternal()", 2);
        }
    }

    MQCBD computeCBD() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "computeCBD()");
        }
        MQCBD cbd = this.env.newMQCBD();
        cbd.setCallbackFunction((MQConsumer)this);
        cbd.setCallbackType(1);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "computeCBD()", cbd);
        }
        return cbd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumer(Hconn hconn, MQMD mqmd, MQGMO mqgmo, ByteBuffer pBuffer, MQCBC mqcbc) {
        block40: {
            int callType;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", new Object[]{hconn, mqmd, mqgmo, pBuffer, mqcbc});
            }
            if ((callType = mqcbc.getCallType()) == 6) {
                int dataLength;
                if (this.receiveMarshal == null) {
                    this.initializeReceiveMarshal();
                }
                if ((dataLength = mqcbc.getDataLength()) <= 0 && Trace.isOn) {
                    Trace.traceData(this, "getMsgAsync (empty message)", null);
                }
                if (!$assertionsDisabled && !(this.helper instanceof WMQSession)) {
                    throw new AssertionError();
                }
                this.receiveMarshal.importMQMDMesageBuffer(this.helper, this.destination, mqmd, pBuffer, 0, dataLength);
                WMQMessage resultMsg = null;
                try {
                    resultMsg = this.receiveMarshal.exportProviderMessage(false);
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", e, 1);
                    }
                    try {
                        ((WMQConnection)this.helper.getConnection()).driveExceptionListener(e, false);
                    }
                    catch (JMSException e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", e2, 2);
                        }
                        HashMap<String, Object> info = new HashMap<String, Object>();
                        info.put("exception1", (Object)e);
                        info.put("exception2", (Object)e2);
                        info.put("destination", this.destination.getName());
                        info.put("marshal", this.receiveMarshal);
                        Trace.ffst(this, "consume(Hconn,MQMD,MQGMO,ByteNuffer,MQCBC)", "XN004003", info, null);
                    }
                }
                ByteBuffer[] msgBuffer = new ByteBuffer[]{pBuffer};
                boolean poisonous = this.poisonous(mqmd, resultMsg, msgBuffer);
                if (resultMsg != null && !poisonous && (mqgmo.getOptions() & 4) != 4) {
                    try {
                        if (resultMsg.getJMSDeliveryMode() != 1 || (mqgmo.getOptions() & 0x1000) != 4096) {
                            this.helper.operationPerformed(WMQConsumerOwner.Operation.GET, true);
                        }
                    }
                    catch (JMSException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", e, 3);
                        }
                        try {
                            ((WMQConnection)this.helper.getConnection()).driveExceptionListener(e, false);
                        }
                        catch (JMSException e2) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", e2, 4);
                            }
                            HashMap<String, Object> info = new HashMap<String, Object>();
                            info.put("exception1", (Object)e);
                            info.put("exception2", (Object)e2);
                            info.put("destination", this.destination.getName());
                            info.put("syncpoint", resultMsg);
                            Trace.ffst(this, "consume(Hconn,MQMD,MQGMO,ByteNuffer,MQCBC)", "XN00M005", info, null);
                        }
                    }
                }
                if (!poisonous) {
                    this.honourNoLocal(mqmd, resultMsg);
                }
            } else if (callType == 7) {
                ProviderMessage resultMsg = null;
                try {
                    MQGMO gmo = this.computeGMO(0);
                    gmo.setMatchOptions(32);
                    gmo.setMsgToken(mqgmo.getMsgToken());
                    resultMsg = this.getMsg(gmo, mqcbc.getDataLength(), true);
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", e, 5);
                    }
                    try {
                        ((WMQConnection)this.helper.getConnection()).driveExceptionListener(e, false);
                    }
                    catch (JMSException e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", e2, 6);
                        }
                        HashMap<String, Object> info = new HashMap<String, Object>();
                        info.put("exception1", (Object)e);
                        info.put("exception2", (Object)e2);
                        info.put("destination", this.destination.getName());
                        info.put("msg type", "persistent");
                        Trace.ffst(this, "consume(Hconn,MQMD,MQGMO,ByteNuffer,MQCBC)", "XN00M002", info, null);
                    }
                }
                if (this.destination.isQueue()) {
                    this.helper.operationPerformed(WMQConsumerOwner.Operation.GET, true);
                }
                this.honourNoLocal(mqmd, resultMsg);
            } else if (callType == 5) {
                try {
                    Pint consumerRC = this.env.newPint(mqcbc.getReason());
                    Pint consumerCC = this.env.newPint(mqcbc.getCompCode());
                    if (consumerCC.x == 2 && consumerRC.x == 2518) {
                        Object e2 = this.delayedCloseLock;
                        synchronized (e2) {
                            this.delayedCloseFinished = true;
                            this.delayedCloseLock.notify();
                            break block40;
                        }
                    }
                    if (consumerCC.x == 2 && consumerRC.x == 2517) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("destination", this.destination.getName());
                        data.put("reason", new Integer(consumerRC.x));
                        Trace.ffst(this, "consumer()", "XN00M003", data, null);
                    } else {
                        WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ2002", this.destination.getName(), "XMSC_DESTINATION_NAME", consumerCC, consumerRC, this.env, "XN004004", this.helper.getConnection(), hconn);
                    }
                }
                catch (JMSException e) {
                    if (!Trace.isOn) break block40;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)", e, 7);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "consumer(Hconn,MQMD,MQGMO,ByteBuffer,MQCBC)");
        }
    }

    private void honourNoLocal(MQMD mqmd, ProviderMessage msg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "honourNoLocal(MQMD,ProviderMessage)", new Object[]{mqmd, msg});
        }
        if (this.nolocal) {
            String parentConnId = ((WMQConnection)this.helper.getConnection()).getHconn().getConnectionIdAsString();
            String messageConnId = null;
            if (msg != null) {
                try {
                    messageConnId = msg.getStringProperty("JMS_IBM_ConnectionID");
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "honourNoLocal(MQMD,ProviderMessage)", e);
                    }
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("exception1", (Object)e);
                    info.put("destination", this.destination.getName());
                    info.put("msg", msg);
                    Trace.ffst(this, "consume(Hconn,MQMD,MQGMO,ByteNuffer,MQCBC)", "XN00M004", info, null);
                }
            }
            if (!parentConnId.equals(messageConnId)) {
                this.listener.onMessage(msg);
            } else if (Trace.isOn) {
                Trace.data(this, "c.i.m.c.wmq.internal.ApiAsyncConsumerShadow", (Object)"noLocal, Message disgarded as ConnectionID matched our ConnectionID");
            }
        } else {
            this.listener.onMessage(msg);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "honourNoLocal(MQMD,ProviderMessage)");
        }
    }

    private boolean poisonous(MQMD mqmd1, ProviderMessage msg, ByteBuffer[] pBuffer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "poisonous(MQMD,ProviderMessage,ByteBuffer[])", new Object[]{mqmd1, msg, pBuffer});
        }
        try {
            if (msg == null) {
                if (Trace.isOn) {
                    Trace.traceInfo(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "poisonous(MQMD,ProviderMessage,ByteBuffer[])", (Object)"message does not contain a provider message. Moving to the backout queue");
                }
                this.initialisePoison();
                this.poison.handlePoisonMessage(mqmd1, pBuffer);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "poisonous(MQMD,ProviderMessage,ByteBuffer[])", true, 5);
                }
                return true;
            }
            if (mqmd1.getBackoutCount() == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "poisonous(MQMD,ProviderMessage,ByteBuffer[])", false, 1);
                }
                return false;
            }
            this.initialisePoison();
            if (this.poison.shouldMessageBeRequeued(mqmd1.getBackoutCount())) {
                this.poison.handlePoisonMessage((WMQMessage)msg);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "poisonous(MQMD,ProviderMessage,ByteBuffer[])", true, 2);
                }
                return true;
            }
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "poisonous(MQMD,ProviderMessage,ByteBuffer[])", e, 1);
            }
            HashMap<String, JMSException> inserts = new HashMap<String, JMSException>();
            inserts.put("XMSC_INSERT_EXCEPTION", e);
            Log.log(this, "poisonous()", "JMSWMQ0036", inserts);
            try {
                if (msg.getJMSDeliveryMode() == 2) {
                    boolean b = this.isConnectionBroken((Exception)((Object)e));
                    ((WMQConnection)this.helper.getConnection()).driveExceptionListener(e, b);
                }
                if (!$assertionsDisabled && !(this.helper instanceof WMQSession)) {
                    throw new AssertionError();
                }
                WMQSession session = (WMQSession)this.helper;
                session.rollback();
                this.helper.removeAsyncConsumer();
            }
            catch (JMSException e2) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "poisonous(MQMD,ProviderMessage,ByteBuffer[])", e2, 2);
                }
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("exception1", (Object)e);
                info.put("exception2", (Object)e2);
                info.put("destination", this.destination.getName());
                info.put("mqmd", mqmd1);
                Trace.ffst(this, "consume(Hconn,MQMD,MQGMO,ByteNuffer,MQCBC)", "XN00M006", info, null);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "poisonous(MQMD,ProviderMessage,ByteBuffer[])", true, 3);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "poisonous(MQMD,ProviderMessage)", false, 4);
        }
        return false;
    }

    protected boolean isConnectionBroken(Exception e) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "isConnectionBroken(Exception)", new Object[]{e});
        }
        boolean b = false;
        if (e instanceof JMSException) {
            JMSException je = (JMSException)((Object)e);
            b = this.isConnectionBroken(je.getLinkedException());
        } else if (e instanceof MQException) {
            MQException mqe = (MQException)((Object)e);
            b = Reason.isConnectionBroken(mqe.getReason());
        } else if (e instanceof JmqiException) {
            JmqiException jmqie = (JmqiException)((Object)e);
            b = Reason.isConnectionBroken(jmqie.getReason());
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "isConnectionBroken(Exception)", b);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterMessageListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "deregisterMessageListener()");
        }
        Pint rc = this.env.newPint();
        Pint cc = this.env.newPint();
        Object object = this.helper.getHconnLock();
        synchronized (object) {
            boolean didSuspend = this.helper.suspendAsyncService();
            MQCBD cbd = this.computeCBD();
            this.mq.MQCB(this.hconn, 512, cbd, this.hobj, this.env.newMQMD(), this.env.newMQGMO(), cc, rc);
            if (didSuspend) {
                this.helper.resumeAsyncService();
            }
            WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ0021", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN004002", this.helper.getConnection(), this.hconn);
            this.helper.removeAsyncConsumer();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "deregisterMessageListener()");
        }
    }

    void initialize() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "initialize()");
        }
        super.initialize();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "initialize()");
        }
    }

    ProviderMessage receiveInternal(long timeOut) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "receiveInternal(long)", new Object[]{new Long(timeOut)});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "receiveInternal(long)", null);
        }
        return null;
    }

    MQGMO computeGMO(int waitTime) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "computeGMO(int)", new Object[]{new Integer(waitTime)});
        }
        MQGMO gmo = super.computeGMO(waitTime);
        int options = gmo.getOptions();
        options &= 0xFFFFFFFE;
        options |= 0;
        gmo.setOptions(options |= 0x2000);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "computeGMO(int)", gmo);
        }
        return gmo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerMessageListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "registerMessageListener()");
        }
        Pint rc = this.env.newPint();
        Pint cc = this.env.newPint();
        MQCBD cbd = this.computeCBD();
        int options = cbd.getOptions();
        options |= 0x2000;
        cbd.setOptions(options |= 4);
        this.resetMQMD();
        MQGMO gmo = this.computeGMO(0);
        Object object = this.helper.getHconnLock();
        synchronized (object) {
            boolean didSuspend = this.helper.suspendAsyncService();
            this.mq.MQCB(this.hconn, 256, cbd, this.hobj, this.mqmd, gmo, cc, rc);
            WMQMessageConsumer.checkJmqiCallSuccess("JMSWMQ0020", this.destination.getName(), "XMSC_DESTINATION_NAME", cc, rc, this.env, "XN004001", this.helper.getConnection(), this.hconn);
            if (didSuspend) {
                this.helper.resumeAsyncService();
            }
            this.helper.addAsyncConsumer();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "registerMessageListener()");
        }
    }

    void setMessageListener(ProviderMessageListener newListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "setMessageListener(ProviderMessageListener)", new Object[]{newListener});
        }
        if (this.listener == null && newListener == null) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "setMessageListener(ProviderMessageListener)", (Object)"No operation required, the local listener is null and this method was passed null");
            }
        } else if (this.listener != null && newListener != null) {
            this.listener = newListener;
        } else if (newListener != null) {
            this.listener = newListener;
            try {
                this.registerMessageListener();
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "setMessageListener(ProviderMessageListener)", e);
                }
                this.listener = null;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "setMessageListener(ProviderMessageListener)", e);
                }
                throw e;
            }
        } else {
            this.deregisterMessageListener();
            this.listener = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "setMessageListener(ProviderMessageListener)");
        }
    }

    static {
        boolean bl = $assertionsDisabled = !WMQAsyncConsumerShadow.class.desiredAssertionStatus();
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.internal.WMQAsyncConsumerShadow", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/WMQAsyncConsumerShadow.java, jmscc.wmq, k701, k701-112-140304  1.69.1.11 13/12/05 11:08:01");
        }
    }
}

