/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.internal;

import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

class Utils {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq/src/com/ibm/msg/client/wmq/internal/Utils.java, jmscc.wmq, k701, k701-112-140304 1.3.1.1 09/08/17 09:05:56";
    static final int MQCA_BASE_Q_NAME = 2002;
    static final int MQCA_Q_MGR_NAME = 2015;
    static final int MQCA_Q_NAME = 2016;
    static final int MQCA_Q_MGR_IDENTIFIER = 2032;
    static final int MQCA_DEAD_LETTER_Q_NAME = 2006;
    static final int MQCA_BACKOUT_REQ_Q_NAME = 2019;
    static final int MQIA_DEFINITION_TYPE = 7;
    static final int MQIA_Q_TYPE = 20;
    static final int MQIA_BACKOUT_THRESHOLD = 22;
    private static final String CLASSNAME = "com.ibm.msg.client.wmq.jms.internal.Utils";
    private static Object xactionManager = null;
    private static boolean wasNotDetected = false;
    private static final Object xactionManagerLock = new Object();

    Utils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isRRSTransactionInProgress() {
        if (wasNotDetected) {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Previous call did not detect a WAS zOS TransactionManager", null);
            }
            return false;
        }
        if (xactionManager == null) {
            Object object = xactionManagerLock;
            synchronized (object) {
                if (xactionManager == null) {
                    try {
                        CSSystem.dynamicLoadClass("javax.transaction.TransactionManager", Utils.class);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Class javax.transaction.TransactionManager not found; WAS zOS not detected", null);
                        }
                        wasNotDetected = true;
                        return false;
                    }
                    String tmProperty = "com.ibm.ws390.jta.TransactionManager";
                    PropertyStore.register(tmProperty, "com.ibm.ws390.tx.TransactionManagerImpl");
                    String classname = PropertyStore.getStringProperty(tmProperty);
                    Method getTxMgrMth = null;
                    try {
                        Class txMgrClass = CSSystem.dynamicLoadClass(classname, Utils.class);
                        getTxMgrMth = txMgrClass.getMethod("getTransactionManager", null);
                    }
                    catch (NullPointerException npe) {
                        wasNotDetected = true;
                        return false;
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Class " + classname + " not found; WAS OS/390 not detected", null);
                        }
                        wasNotDetected = true;
                        return false;
                    }
                    catch (NoSuchMethodException nsme) {
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Method getTransactionManager() not found on tm implementation", null);
                        }
                        wasNotDetected = true;
                        return false;
                    }
                    try {
                        TransactionManager txMgr = (TransactionManager)getTxMgrMth.invoke(null, (Object[])null);
                        if (txMgr == null) {
                            if (Trace.isOn) {
                                Trace.traceData(CLASSNAME, "No TransactionManager present. Reverting to local transaction behaviour for this JVM", null);
                            }
                            wasNotDetected = true;
                            return false;
                        }
                        xactionManager = txMgr;
                    }
                    catch (InvocationTargetException ite) {
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Error when finding TransactionManager", null);
                        }
                        wasNotDetected = true;
                        return false;
                    }
                    catch (IllegalAccessException iae) {
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Error when finding TransactionManager", null);
                        }
                        wasNotDetected = true;
                        return false;
                    }
                }
            }
        }
        Transaction tran = null;
        try {
            TransactionManager txMgr = (TransactionManager)xactionManager;
            tran = txMgr.getTransaction();
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Unexpected exception while getting Transaction", null);
            }
            return false;
        }
        if (Trace.isOn) {
            if (tran == null) {
                Trace.traceData(CLASSNAME, "No global transaction present.", null);
            } else {
                Trace.traceData(CLASSNAME, "Global transaction active on this thread.", null);
            }
        }
        boolean traceRet2 = tran != null;
        return traceRet2;
    }
}

