/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.factories;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderConnection;
import com.ibm.msg.client.provider.ProviderXAConnection;
import com.ibm.msg.client.provider.ProviderXAConnectionFactory;
import com.ibm.msg.client.wmq.factories.WMQConnectionFactory;
import com.ibm.msg.client.wmq.internal.WMQXAConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQXAConnection;
import java.util.HashMap;
import javax.jms.JMSException;

public class WMQXAConnectionFactory
extends WMQConnectionFactory
implements ProviderXAConnectionFactory {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid2 = "@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/factories/WMQXAConnectionFactory.java, jmscc.wmq, k701, k701-112-140304 1.20.1.1 09/08/17 08:34:28";
    public static final long serialVersionUID = 4815162342L;

    public WMQXAConnectionFactory(JmsPropertyContext props) throws JMSException {
        super(props);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "<init>(JmsPropertyContext)", new Object[]{props});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "<init>(JmsPropertyContext)");
        }
    }

    public ProviderXAConnection createProviderXAConnection(JmsPropertyContext properties) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createProviderXAConnection(JmsPropertyContext)", new Object[]{properties});
        }
        ProviderXAConnection xaConnection = (ProviderXAConnection)this.createProviderConnection(properties);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createProviderXAConnection(JmsPropertyContext)", xaConnection);
        }
        return xaConnection;
    }

    protected ProviderConnection createV7ProviderConnection(JmsPropertyContext connectionProps) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createV7ProviderConnection(JmsPropertyContext)", new Object[]{connectionProps});
        }
        int jmqiType = -1;
        int transport = connectionProps.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
        if (transport == 0) {
            jmqiType = 0;
        } else if (transport == 1) {
            jmqiType = 2;
        }
        int jmqiOptions = 1;
        if (WMQConnectionFactory.forceUseJmqiWorkerThread) {
            jmqiOptions |= 4;
        }
        if (WMQConnectionFactory.forceDontUseJmqiWorkerThread) {
            jmqiOptions |= 8;
        }
        if (WMQConnectionFactory.forceDontUseSharedHconn) {
            jmqiOptions |= 0x10;
        }
        if (WMQConnectionFactory.inheritRRSContext) {
            jmqiOptions |= 0x40;
        }
        jmqiOptions |= 0x2000;
        JmqiMQ jmqiMq = null;
        JmqiEnvironment jmqiEnvironment = this.getJmqiEnvironment();
        int jmqiCompId = this.getJmqiCompId();
        try {
            jmqiMq = jmqiEnvironment.getMQI(jmqiType, jmqiOptions);
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createV7ProviderConnection(JmsPropertyContext)", e);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ6312", null));
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createV7ProviderConnection(JmsPropertyContext)", je);
            }
            throw je;
        }
        WMQXAConnection connection = new WMQXAConnection(jmqiEnvironment, jmqiMq, jmqiCompId, connectionProps);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createV7ProviderConnection(JmsPropertyContext)", connection);
        }
        return connection;
    }

    protected ProviderConnection createV6ProviderConnection(JmsPropertyContext connectionProps) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createV6ProviderConnection(JmsPropertyContext)", new Object[]{connectionProps});
        }
        MQXAConnection connection = null;
        try {
            String password;
            int brokerVersion = connectionProps.getIntProperty("brokerVersion");
            int messageSelection = connectionProps.getIntProperty("XMSC_WMQ_MESSAGE_SELECTION");
            if (brokerVersion != 1 && messageSelection == 1) {
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ3036", null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createV6ProviderConnection(JmsPropertyContext)", je, 1);
                }
                throw je;
            }
            String username = connectionProps.getStringProperty("XMSC_USERID");
            if (username == null) {
                username = "";
            }
            if ((password = connectionProps.getStringProperty("XMSC_PASSWORD")) == null) {
                password = "";
            }
            if (Trace.isOn) {
                Trace.traceData(this, "connecting as user: " + username, null);
            }
            int transportType = connectionProps.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
            switch (transportType) {
                case 0: 
                case 1: {
                    connection = new MQXAConnection(username, password, connectionProps);
                    break;
                }
                default: {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("connectionMode", Integer.toString(transportType));
                    Trace.ffst(this, "(createV6ProviderConnection)", "XT002002", info, JMSException.class);
                    break;
                }
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createV6ProviderConnection(JmsPropertyContext)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createV6ProviderConnection(JmsPropertyContext)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createV6ProviderConnection(JmsPropertyContext)", connection);
        }
        return connection;
    }

    protected ProviderConnection createDirectConnection(JmsPropertyContext connectionProps) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createDirectConnection(JmsPropertyContext)", new Object[]{connectionProps});
        }
        JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ6311", null));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "createDirectConnection(JmsPropertyContext)", je);
        }
        throw je;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/factories/WMQXAConnectionFactory.java, jmscc.wmq, k701, k701-112-140304  1.20.1.1 09/08/17 08:34:28");
        }
    }
}

