/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.factories;

import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.disthub2.impl.client.Logger;
import com.ibm.disthub2.impl.client.SessionConfig;
import com.ibm.disthub2.impl.util.DebugState;
import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.componentmanager.Component;
import com.ibm.msg.client.commonservices.componentmanager.ComponentManager;
import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.cssystem.WASSupport;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.provider.trace.CSPTrace;
import com.ibm.msg.client.commonservices.trace.FlightRecorder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderConnectionFactory;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderFactoryFactory;
import com.ibm.msg.client.provider.ProviderJmsFactory;
import com.ibm.msg.client.provider.ProviderMatchSpace;
import com.ibm.msg.client.provider.ProviderMessageFactory;
import com.ibm.msg.client.provider.ProviderMetaData;
import com.ibm.msg.client.provider.ProviderXAConnectionFactory;
import com.ibm.msg.client.wmq.common.WMQLicenseCheck;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo;
import com.ibm.msg.client.wmq.factories.WAS6Tracer;
import com.ibm.msg.client.wmq.factories.WMQConnectionFactory;
import com.ibm.msg.client.wmq.factories.WMQMessageFactory;
import com.ibm.msg.client.wmq.factories.WMQTraceMonitor;
import com.ibm.msg.client.wmq.factories.WMQXAConnectionFactory;
import com.ibm.msg.client.wmq.factories.admin.WMQJmsFactory;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionMetaData;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;

public class WMQFactoryFactory
implements ProviderFactoryFactory {
    private static Map capabilities;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ProviderFactoryFactory factoryFactory;
    private static ProviderJmsFactory jmsFactory;
    private static final String MATCHSPACE_CLASS = "com.ibm.msg.client.matchspace.MatchMaker";
    private static ProviderMessageFactory messageFactory;
    private static ProviderMetaData metaData;
    private static WMQJmsFactory providerJmsFactory;
    private static ProviderMatchSpace providerMatchSpace;
    private static ProviderMessageFactory providerMessageFactory;
    public static final String osNameProperty = "os.name";
    public static final String bitModeProperty = "com.ibm.vm.bitmode";
    public static final String forceClientProperty = "com.ibm.msg.client.wmq.forceAllowClientConnection";
    public static final String overrideProviderVersion = "com.ibm.msg.client.wmq.overrideProviderVersion";
    public static final String standaloneTraceProperty = "com.ibm.msg.client.commonservices.trace.standalone";
    public static final String overrideReplyToStyleDefault = "com.ibm.mq.jms.replyToStyle";
    public static final String traceStatusProperty_WMQTRC = "WMQTRC";
    protected static boolean iSeries;
    protected static boolean zSeries;
    protected static boolean zSeries64;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/factories/WMQFactoryFactory.java, jmscc.wmq, k701, k701-112-140304 1.48.1.3 12/01/27 14:31:09";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProviderFactoryFactory getInstance() {
        if (factoryFactory == null) {
            Class clazz = WMQFactoryFactory.class;
            synchronized (clazz) {
                if (factoryFactory == null) {
                    factoryFactory = new WMQFactoryFactory();
                }
            }
        }
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "getInstance()", "getter", (Object)factoryFactory);
        }
        return factoryFactory;
    }

    private WMQFactoryFactory() {
        WASSupport support;
        boolean runningInWAS6;
        boolean xaEnabled;
        block21: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "<init>()");
            }
            xaEnabled = false;
            runningInWAS6 = false;
            support = WASSupport.getWASSupport();
            if (support.isWASCommonServicesPresent()) {
                runningInWAS6 = false;
            } else {
                xaEnabled = runningInWAS6 = support.isWASv6Present();
                if (Trace.isOn) {
                    Trace.data(this, "<init>", "runningInWS", (Object)new Boolean(runningInWAS6));
                }
            }
            PropertyStore.register(standaloneTraceProperty, false);
            Boolean standaloneTrace = PropertyStore.getBooleanPropertyObject(standaloneTraceProperty);
            if (Trace.isOn) {
                Trace.data(this, "<init>", "WS Standalone Trace ", (Object)standaloneTrace);
            }
            if (runningInWAS6 && !standaloneTrace.booleanValue()) {
                try {
                    CSPTrace defaultTracer = Trace.getCSPTrace();
                    WAS6Tracer wasTracer = new WAS6Tracer(defaultTracer);
                    Trace.data(this, "<init>", "Last trace point BEFORE WAS trace integration engaged.", null);
                    Trace.setCSPTrace(wasTracer);
                    Trace.data(this, "<init>", "First trace point AFTER WAS trace integration engaged.", null);
                    wasTracer.start();
                    Trace.data(this, "<init>", "WAS trace started.", null);
                }
                catch (Throwable t) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "<init>()", t, 1);
                    }
                    HashMap<String, Throwable> data = new HashMap<String, Throwable>();
                    data.put("Throwable thrown from Trace", t);
                    Trace.ffst(this, "<init>", "XT003001", data, null);
                }
            } else {
                ComponentManager compMgr = ComponentManager.getInstance();
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put("WMQv7", "");
                try {
                    Component component = compMgr.getComponent("LICENSE", filter);
                    if (component != null) {
                        xaEnabled = ((WMQLicenseCheck)component.getFactoryInstance()).isClientXAEnabled();
                    }
                }
                catch (CSIException e) {
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "<init>()", "Caught expected exception at catch index 2", e);
                    }
                    if (!Trace.isOn) break block21;
                    Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "<init>()", "Caught expected exception at catch index 1", e);
                }
            }
        }
        if (runningInWAS6) {
            support.setupWASv6Helper();
        }
        PropertyStore.register("com.ibm.msg.client.wmq.xaClientEnabled", xaEnabled, true);
        boolean forceAllowClientConnection = this.readBooleanMQEnvironmentSetting("forceAllowClientConnection");
        PropertyStore.register(forceClientProperty, forceAllowClientConnection, true);
        PropertyStore.register(overrideProviderVersion, null);
        PropertyStore.register(overrideReplyToStyleDefault, null);
        PropertyStore.register(osNameProperty, null, false);
        String os = PropertyStore.getStringProperty(osNameProperty);
        if (os == null) {
            os = "";
        }
        if (os.equals("OS/390") || os.equals("z/OS")) {
            zSeries = true;
            PropertyStore.register(bitModeProperty, null, false);
            zSeries64 = "64".equals(PropertyStore.getStringProperty(bitModeProperty));
        } else if (os.equals("OS/400") || os.equals("OS400")) {
            iSeries = true;
        }
        this.setupDistHubTracing();
        PropertyStore.register("com.ibm.msg.client.commonservices.trace.status", "OFF");
        String traceOn = PropertyStore.getStringProperty("com.ibm.msg.client.commonservices.trace.status");
        if (null != traceOn && traceOn.equalsIgnoreCase(traceStatusProperty_WMQTRC)) {
            WMQTraceMonitor.setupWMQTraceMonitor();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "<init>()");
        }
    }

    private void setupDistHubTracing() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "setupDistHubTracing()");
        }
        BaseConfig.initialize((Class)SessionConfig.class);
        Logger.setLoggerPath((String)"com.ibm.msg.client.wmq.factories");
        Logger.start();
        BaseConfig.setParameter((String)"DEBUG_LEVEL", (String)String.valueOf(-1));
        BaseConfig.setParameter((String)"DEBUG_NAME", (String)"*");
        DebugState.update();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "setupDistHubTracing()");
        }
    }

    public ProviderConnectionFactory createProviderConnectionFactory(JmsPropertyContext properties) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "createProviderConnectionFactory(JmsPropertyContext)", new Object[]{properties});
        }
        WMQConnectionFactory pcf = new WMQConnectionFactory(properties);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "createProviderConnectionFactory(JmsPropertyContext)", pcf);
        }
        return pcf;
    }

    public ProviderXAConnectionFactory createProviderXAConnectionFactory(JmsPropertyContext properties) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "createProviderXAConnectionFactory(JmsPropertyContext)", new Object[]{properties});
        }
        WMQXAConnectionFactory pxcf = new WMQXAConnectionFactory(properties);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "createProviderXAConnectionFactory(JmsPropertyContext)", pxcf);
        }
        return pxcf;
    }

    public ProviderDestination createProviderDestination(int destType, String name, JmsPropertyContext properties) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "createProviderDestination(int,String,JmsPropertyContext)", new Object[]{new Integer(destType), name, properties});
        }
        WMQDestination destination = null;
        destination = new WMQDestination(destType, name, properties);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "createProviderDestination(int,String,JmsPropertyContext)", destination);
        }
        return destination;
    }

    public Map getCapabilities() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "getCapabilities()");
        }
        if (null == capabilities) {
            capabilities = Collections.synchronizedMap(new HashMap());
            capabilities.put("XMSC_CAPABILITY_TRANSACTIONS_XA", true);
            capabilities.put("XMSC_CAPABILITY_TRANSACTIONS_LOCAL", true);
            capabilities.put("XMSC_CAPABILITY_ASF", true);
            capabilities.put("XMSC_CAPABILITY_POINT_TO_POINT", true);
            capabilities.put("XMSC_CAPABILITY_PUBLISH_SUBSCRIBE", true);
            capabilities.put("XMSC_CAPABILITY_USERNAME_PASSWORD", true);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "getCapabilities()", capabilities);
        }
        return capabilities;
    }

    public ProviderJmsFactory getJmsFactory() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "getJmsFactory()", "getter", providerJmsFactory);
        }
        return providerJmsFactory;
    }

    public ProviderMatchSpace getMatchSpace() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "getMatchSpace()", "getter", providerMatchSpace);
        }
        return providerMatchSpace;
    }

    public ProviderMessageFactory getMessageFactory() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "getMessageFactory()", "getter", providerMessageFactory);
        }
        return providerMessageFactory;
    }

    public ProviderMetaData getMetaData() throws JMSException {
        MQConnectionMetaData providerMetaData = new MQConnectionMetaData();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "getMetaData()", "getter", providerMetaData);
        }
        return providerMetaData;
    }

    private boolean readBooleanMQEnvironmentSetting(final String methodName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "readBooleanMQEnvironmentSetting(final String)", new Object[]{methodName});
        }
        Boolean isEnabled = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "run()");
                }
                Boolean enabled = null;
                try {
                    Class mqenv = CSSystem.dynamicLoadClass("com.ibm.mq.MQEnvironment", this.getClass());
                    if (mqenv == null) {
                        enabled = Boolean.FALSE;
                    } else {
                        Method m;
                        Class c = mqenv;
                        if (Trace.isOn) {
                            Trace.data(this, "<init>", "class", (Object)c);
                        }
                        if ((m = c.getMethod(methodName, null)) != null) {
                            Object returnVal = m.invoke(null, null);
                            if (Trace.isOn) {
                                Trace.data(this, "<init>", "Found method - it returned", returnVal);
                            }
                            enabled = returnVal instanceof Boolean ? (Boolean)returnVal : Boolean.FALSE;
                        } else if (Trace.isOn) {
                            Trace.data(this, "<init>", "failed to find method", null);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.wmq.factories.null", "run()", "Caught expected exception at catch index 1", e);
                    }
                    enabled = Boolean.FALSE;
                }
                catch (Exception ex) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()", ex, 2);
                    }
                    enabled = Boolean.FALSE;
                }
                catch (NoClassDefFoundError error) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()", error, 3);
                    }
                    enabled = Boolean.FALSE;
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", enabled);
                }
                return enabled;
            }
        });
        boolean traceRet1 = isEnabled;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "readBooleanMQEnvironmentSetting(final String)", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/factories/WMQFactoryFactory.java, jmscc.wmq, k701, k701-112-140304  1.48.1.3 12/01/27 14:31:09");
        }
        capabilities = null;
        providerJmsFactory = new WMQJmsFactory();
        providerMatchSpace = null;
        providerMessageFactory = new WMQMessageFactory();
        iSeries = false;
        zSeries = false;
        zSeries64 = false;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "static()");
        }
        FlightRecorder.start();
        try {
            NLSServices.addCatalogue("com.ibm.msg.client.wmq.internal.resources.JMSWMQ_MessageResourceBundle", "JMSWMQ", WMQFactoryFactory.class);
            NLSServices.addCatalogue("com.ibm.msg.client.wmq.common.internal.resources.JMSCMQ_MessageResourceBundle", "JMSCMQ", WMQFactoryFactory.class);
            NLSServices.addCatalogue("com.ibm.msg.client.wmq.factories.resources.JMSFMQ_MessageResourceBundle", "JMSFMQ", WMQFactoryFactory.class);
            NLSServices.addCatalogue("com.ibm.msg.client.wmq.v6.jms.internal.services.resources.MQJMS_MessageResourceBundle", "MQJMS", WMQFactoryFactory.class);
            Trace.registerFFSTInfo(new WMQFFSTInfo());
        }
        catch (Throwable e) {
            if (Trace.isOn) {
                Trace.data("com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "static()", "Caught expected exception", (Object)e);
            }
            System.err.println("Serious problem with class initialization:");
            e.printStackTrace();
            System.err.println("End of information");
            System.err.flush();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.factories.WMQFactoryFactory", "static()");
        }
    }
}

