/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.factories;

import com.ibm.disthub2.impl.client.SessionConfig;
import com.ibm.mq.MQException;
import com.ibm.mq.constants.CMQC;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiFactory;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.JmqiPropertyHandler;
import com.ibm.mq.jmqi.JmqiThreadPoolFactory;
import com.ibm.mq.jmqi.JmqiTraceHandlerAdapter;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Hobj;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.system.JmqiComponent;
import com.ibm.mq.jmqi.system.JmqiComponentTls;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.cssystem.WASSupport;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderConnection;
import com.ibm.msg.client.provider.ProviderConnectionFactory;
import com.ibm.msg.client.wmq.common.WMQConnectionName;
import com.ibm.msg.client.wmq.common.WMQConnectionNameList;
import com.ibm.msg.client.wmq.common.WMQThreadLocalStorage;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyHandler;
import com.ibm.msg.client.wmq.common.internal.WMQStandardValidators;
import com.ibm.msg.client.wmq.common.internal.WMQThreadPoolFactory;
import com.ibm.msg.client.wmq.common.internal.WMQTraceHandler;
import com.ibm.msg.client.wmq.common.internal.WMQValidationInterface;
import com.ibm.msg.client.wmq.factories.WMQFactoryFactory;
import com.ibm.msg.client.wmq.internal.WMQConnection;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.jms.JMSException;

public class WMQConnectionFactory
extends WMQPropertyContext
implements ProviderConnectionFactory,
JmqiComponent {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/factories/WMQConnectionFactory.java, jmscc.wmq, k701, k701-112-140304 1.120.1.18 11/07/21 11:41:01";
    private static final long serialVersionUID = 4815162342L;
    protected static String forceDontUseJmqiWorkerThreadProperty;
    protected static boolean forceDontUseJmqiWorkerThread;
    protected static String forceDontUseSharedHconnProperty;
    protected static boolean forceDontUseSharedHconn;
    protected static String forceUseJmqiWorkerThreadProperty;
    protected static boolean forceUseJmqiWorkerThread;
    protected static String inheritRRSContextProperty;
    protected static boolean inheritRRSContext;
    private static final Map propertyValidators;
    private transient JmqiEnvironment jmqiEnvironment;
    private int jmqiCompId;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQQueueConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQXAConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQXAQueueConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQXATopicConnectionFactory;
    static /* synthetic */ Class class$com$ibm$msg$client$wmq$factories$WMQConnectionFactory;

    public WMQConnectionFactory(JmsPropertyContext props) throws JMSException {
        super(props);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "<init>(JmsPropertyContext)", new Object[]{props});
        }
        this.initialiseWMQConnectionFactory();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "<init>(JmsPropertyContext)");
        }
    }

    private void initialiseWMQConnectionFactory() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "initialiseWMQConnectionFactory()");
        }
        WMQTraceHandler traceHandler = new WMQTraceHandler();
        WMQThreadPoolFactory threadPool = new WMQThreadPoolFactory();
        WMQPropertyHandler propertyHandler = new WMQPropertyHandler();
        try {
            this.jmqiEnvironment = JmqiFactory.getInstance((JmqiTraceHandlerAdapter)traceHandler, (JmqiThreadPoolFactory)threadPool, (JmqiPropertyHandler)propertyHandler);
            JmqiSystemEnvironment sysenv = (JmqiSystemEnvironment)this.jmqiEnvironment;
            this.jmqiCompId = sysenv.registerComponent((JmqiComponent)this);
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "initialiseWMQConnectionFactory()", e);
            }
            HashMap<String, JmqiException> info = new HashMap<String, JmqiException>();
            info.put("exception", e);
            Trace.ffst(this, "<init>(WMQConnectionFactory)", "XT001001", info, null);
        }
        this.jmqiEnvironment.setCaller('M');
        threadPool.setEnv(this.jmqiEnvironment);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "initialiseWMQConnectionFactory()");
        }
    }

    public ProviderConnection createProviderConnection(JmsPropertyContext connectionProps) throws JMSException {
        String ccdturl;
        String sysPropProviderVer;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", new Object[]{connectionProps});
        }
        ProviderConnection connection = null;
        String providerVer = connectionProps.getStringProperty("XMSC_WMQ_PROVIDER_VERSION");
        int transportType = connectionProps.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
        int brokerVersion = connectionProps.getIntProperty("brokerVersion");
        String brokerQMgr = connectionProps.getStringProperty("XMSC_WMQ_BROKER_QMGR");
        if (transportType == 1) {
            this.setConnectionCredentials(connectionProps);
        }
        if (providerVer == null) {
            providerVer = "unspecified";
        }
        if ((sysPropProviderVer = PropertyStore.getStringProperty("com.ibm.msg.client.wmq.overrideProviderVersion")) != null) {
            boolean valid;
            block64: {
                valid = false;
                Object validationEx = null;
                try {
                    valid = this.validate("XMSC_WMQ_PROVIDER_VERSION", sysPropProviderVer);
                }
                catch (JMSException e) {
                    if (!Trace.isOn) break block64;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", e, 1);
                }
            }
            if (valid) {
                providerVer = sysPropProviderVer;
            }
        }
        if ((ccdturl = connectionProps.getStringProperty("XMSC_WMQ_CCDTURL")) != null && transportType == 0) {
            connectionProps.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
            this.setConnectionCredentials(connectionProps);
        }
        if (providerVer.equalsIgnoreCase("unspecified") && brokerVersion == 1 && brokerQMgr != null && !brokerQMgr.trim().equals("")) {
            providerVer = "6.0.0.0";
        }
        boolean bindingsThenClient = false;
        int transport = connectionProps.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
        if (transport == 8) {
            bindingsThenClient = true;
            connectionProps.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 0);
        }
        if (transportType == 4 || transportType == 2) {
            if (Trace.isOn) {
                Trace.traceData(this, "createProviderConnection(JmsPropertyContext)", (Object)"Direct IP connection required");
            }
            connectionProps.setStringProperty("XMSC_WMQ_PROVIDER_VERSION", "7");
            connection = this.createDirectConnection(connectionProps);
        } else if (providerVer.equalsIgnoreCase("unspecified")) {
            if (Trace.isOn) {
                Trace.traceData(this, "createProviderConnection(JmsPropertyContext)", (Object)"ProviderVersion is unset or set to 'unspecified' - auto-detecting QM level.");
            }
            connection = null;
            try {
                connectionProps.setStringProperty("XMSC_WMQ_PROVIDER_VERSION", "7");
                connection = this.createV7ProviderConnection(connectionProps);
            }
            catch (JMSException jmsE) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", jmsE, 2);
                }
                if (!bindingsThenClient) {
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", jmsE, 1);
                    }
                    throw jmsE;
                }
                int reason = 0;
                Exception cause = jmsE.getLinkedException();
                if (cause instanceof JmqiException) {
                    reason = ((JmqiException)((Object)cause)).getReason();
                } else if (cause instanceof MQException) {
                    reason = ((MQException)((Object)cause)).getReason();
                }
                switch (reason) {
                    case 2058: 
                    case 2059: 
                    case 2495: {
                        connectionProps.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
                        this.setConnectionCredentials(connectionProps);
                        connection = this.createV7ProviderConnection(connectionProps);
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", jmsE, 2);
                        }
                        throw jmsE;
                    }
                }
            }
            if (this.checkConnectionPV7Capable((WMQConnection)connection, providerVer, false) && this.checkBrokerStatus((WMQConnection)connection, brokerVersion)) {
                if (Trace.isOn) {
                    Trace.traceData(this, "createProviderConnection(JmsPropertyContext)", (Object)"Retaining connection for V7 QM.");
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "createProviderConnection(JmsPropertyContext)", (Object)"creating V6 QM.");
                }
                connection.close();
                connectionProps.setStringProperty("XMSC_WMQ_PROVIDER_VERSION", "6");
                connection = this.createV6ProviderConnection(connectionProps);
            }
        } else {
            String[] providerVerElements = providerVer.split("\\.");
            if (providerVerElements.length == 0) {
                Trace.ffst(this, "createProviderConnection", "XT001002", null, JMSException.class);
            }
            int firstProviderElement = 6;
            try {
                firstProviderElement = Integer.parseInt(providerVerElements[0]);
            }
            catch (NumberFormatException nfe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", nfe, 3);
                }
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("ProviderVersionFirstElement", providerVerElements[0]);
                Trace.ffst(this, "createProviderConnection", "XT001009", null, JMSException.class);
            }
            if (firstProviderElement >= 7) {
                boolean tryClient = false;
                try {
                    connection = this.createV7ProviderConnection(connectionProps);
                }
                catch (JMSException jmsE) {
                    int reason;
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", jmsE, 4);
                    }
                    if (!bindingsThenClient) {
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", jmsE, 3);
                        }
                        throw jmsE;
                    }
                    Exception cause = jmsE.getLinkedException();
                    if (cause instanceof MQException) {
                        int reason2 = ((MQException)((Object)cause)).getReason();
                        if (reason2 == 2058 || reason2 == 2059) {
                            tryClient = true;
                        }
                    } else if (cause instanceof JmqiException && (reason = ((JmqiException)((Object)cause)).getReason()) == 2495) {
                        tryClient = true;
                    }
                    if (tryClient) {
                        connectionProps.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
                        this.setConnectionCredentials(connectionProps);
                        connection = this.createV7ProviderConnection(connectionProps);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", jmsE, 4);
                    }
                    throw jmsE;
                }
                if (this.checkConnectionPV7Capable((WMQConnection)connection, providerVer, true) && Trace.isOn) {
                    Trace.traceData(this, "createProviderConnection(JmsPropertyContext)", (Object)"ProviderVersion set to request V7 CF; returning new V7 CF");
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "createProviderConnectionFactory(JmsPropertyContext)", (Object)"ProviderVersion set to request non-v7 CF; returning new V6 CF");
                }
                try {
                    connection = this.createV6ProviderConnection(connectionProps);
                }
                catch (JMSException jmsE) {
                    int reason;
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", jmsE, 5);
                    }
                    if (!bindingsThenClient) {
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", jmsE, 5);
                        }
                        throw jmsE;
                    }
                    boolean tryClient = false;
                    Throwable cause = jmsE.getLinkedException();
                    if (cause instanceof MQException) {
                        reason = ((MQException)cause).getReason();
                        if (reason == 2058 || reason == 2059) {
                            tryClient = true;
                        } else if (reason == 2298) {
                            cause = cause.getCause();
                        }
                    }
                    if (cause instanceof JmqiException && (reason = ((JmqiException)cause).getReason()) == 2495) {
                        tryClient = true;
                    }
                    if (tryClient) {
                        connectionProps.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
                        this.setConnectionCredentials(connectionProps);
                        connection = this.createV6ProviderConnection(connectionProps);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", jmsE, 6);
                    }
                    throw jmsE;
                }
            }
        }
        connectionProps.setStringProperty("XMSC_WMQ_PROVIDER_VERSION", providerVer);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createProviderConnection(JmsPropertyContext)", connection);
        }
        return connection;
    }

    private void setConnectionCredentials(JmsPropertyContext connectionProps) throws JMSException {
        String password;
        boolean bForceUserID;
        String username = connectionProps.getStringProperty("XMSC_USERID");
        if ((username == null || username.equals("")) && (bForceUserID = PropertyStore.getBooleanPropertyObject("com.ibm.mq.jms.ForceUserID").booleanValue())) {
            connectionProps.setStringProperty("XMSC_USERID", this.getProcessUserId());
        }
        if ((password = connectionProps.getStringProperty("XMSC_PASSWORD")) == null) {
            connectionProps.setStringProperty("XMSC_PASSWORD", "");
        }
        if (Trace.isOn) {
            Trace.traceData(this, "connecting as user: " + username, null);
        }
    }

    private boolean checkBrokerStatus(WMQConnection connection, int brokerVersion) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkBrokerStatus(WMQConnection,int)", new Object[]{connection, new Integer(brokerVersion)});
        }
        boolean suitableForV7PubSub = true;
        if (brokerVersion == 0 || brokerVersion == -1) {
            suitableForV7PubSub = true;
        } else {
            String controlQ = null;
            try {
                controlQ = connection.getStringProperty("XMSC_WMQ_BROKER_CONTROLQ");
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkBrokerStatus(WMQConnection,int)", e);
                }
                HashMap<String, WMQConnection> data = new HashMap<String, WMQConnection>();
                data.put("BrokerControlQ", null);
                data.put("WMQConnection", connection);
                Trace.ffst(this, "checkBrokerStatus", "XT001006", data, JMSException.class);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkBrokerStatus(WMQConnection,int)", false, 1);
                }
                return false;
            }
            JmqiMQ mq = connection.getJmqiMQ();
            JmqiEnvironment env = connection.getJmqiEnvironment();
            Hconn hConn = connection.getHconn();
            Pint cc = env.newPint(0);
            Pint rc = env.newPint(0);
            MQOD mqod = env.newMQOD();
            mqod.setObjectName(controlQ);
            int options = 8208;
            Phobj phobj = env.newPhobj();
            mq.MQOPEN(hConn, mqod, options, phobj, cc, rc);
            if (cc.x == 0 || cc.x == 1) {
                MQOD mqod_qm = env.newMQOD();
                mqod_qm.setObjectType(5);
                int options_qm = 32;
                Phobj phobj_qm = env.newPhobj();
                mq.MQOPEN(hConn, mqod_qm, options_qm, phobj_qm, cc, rc);
                if (cc.x == 0 || cc.x == 1) {
                    Hobj hobj = phobj_qm.getHobj();
                    int[] selectors = new int[]{187};
                    int[] intAttrs = new int[1];
                    mq.MQINQ(hConn, hobj, selectors.length, selectors, intAttrs.length, intAttrs, 0, new byte[0], cc, rc);
                    if (rc.x == 0) {
                        int psMode = intAttrs[0];
                        suitableForV7PubSub = psMode != 1 && psMode != 0;
                        if (Trace.isOn) {
                            HashMap<String, Constable> data = new HashMap<String, Constable>();
                            data.put("psMode", new Integer(psMode));
                            data.put("suitableForV7PubSub", new Boolean(suitableForV7PubSub));
                            Trace.data(this, "checkBrokerStatus()", "Final BrokerVer results", data);
                        }
                    } else {
                        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
                        data.put("WMQConnection", connection);
                        data.put("cc", new Integer(cc.x));
                        data.put("rc", new Integer(rc.x));
                        Trace.ffst(this, "checkBrokerStatus", "XT001007", data, JMSException.class);
                    }
                    mq.MQCLOSE(hConn, phobj_qm, 0, cc, rc);
                } else {
                    HashMap<String, Serializable> data = new HashMap<String, Serializable>();
                    data.put("WMQConnection", connection);
                    data.put("cc", new Integer(cc.x));
                    data.put("rc", new Integer(rc.x));
                    Trace.ffst(this, "checkBrokerStatus", "XT001008", data, JMSException.class);
                }
                options = 0;
                mq.MQCLOSE(hConn, phobj, options, cc, rc);
            } else {
                if (Trace.isOn) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("ControlQ", controlQ);
                    data.put("cc", new Integer(cc.x));
                    data.put("rc", new Integer(rc.x));
                    Trace.data(this, "checkBrokerStatus()", "Unable to open the broker control queue", null);
                }
                suitableForV7PubSub = true;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkBrokerStatus(WMQConnection,int)", suitableForV7PubSub, 2);
        }
        return suitableForV7PubSub;
    }

    public JmqiEnvironment getJmqiEnvironment() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "getJmqiEnvironment()", "getter", this.jmqiEnvironment);
        }
        return this.jmqiEnvironment;
    }

    public int getJmqiCompId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "getJmqiCompId()", "getter", new Integer(this.jmqiCompId));
        }
        return this.jmqiCompId;
    }

    protected ProviderConnection createV7ProviderConnection(JmsPropertyContext connectionProps) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV7ProviderConnection(JmsPropertyContext)", new Object[]{connectionProps});
        }
        int jmqiType = -1;
        int transport = connectionProps.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
        if (transport == 0) {
            jmqiType = 0;
        } else if (transport == 1) {
            this.checkClientConnectionAllowed();
            jmqiType = 2;
        }
        int jmqiOptions = 0;
        WASSupport.WASRuntimeHelper helper = (WASSupport.WASRuntimeHelper)PropertyStore.getObjectProperty("com.ibm.mq.connector.JCARuntimeHelper");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV7ProviderConnection(JmsPropertyContext)", (Object)("Got runtime helper object:" + helper));
        }
        if (helper != null) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV7ProviderConnection(JmsPropertyContext)", (Object)("Environment settings are " + helper.getEnvironment()));
            }
            if (helper.getEnvironment() == 8 || helper.getEnvironment() == 16 || helper.getEnvironment() == 32) {
                jmqiOptions |= 0x20;
            }
        }
        if (forceUseJmqiWorkerThread) {
            jmqiOptions |= 4;
        }
        if (forceDontUseJmqiWorkerThread) {
            jmqiOptions |= 8;
        }
        if (forceDontUseSharedHconn) {
            jmqiOptions |= 0x10;
        }
        if (inheritRRSContext) {
            jmqiOptions |= 0x40;
        }
        jmqiOptions |= 0x2000;
        JmqiMQ jmqiMq = null;
        try {
            jmqiMq = this.jmqiEnvironment.getMQI(jmqiType, jmqiOptions);
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV7ProviderConnection(JmsPropertyContext)", e);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ6312", null));
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV7ProviderConnection(JmsPropertyContext)", je);
            }
            throw je;
        }
        WMQConnection connection = new WMQConnection(this.jmqiEnvironment, jmqiMq, this.jmqiCompId, connectionProps);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV7ProviderConnection(JmsPropertyContext)", connection);
        }
        return connection;
    }

    protected ProviderConnection createV6ProviderConnection(JmsPropertyContext connectionProps) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV6ProviderConnection(JmsPropertyContext)", new Object[]{connectionProps});
        }
        MQConnection connection = null;
        try {
            int brokerVersion = connectionProps.getIntProperty("brokerVersion");
            int messageSelection = connectionProps.getIntProperty("XMSC_WMQ_MESSAGE_SELECTION");
            if (brokerVersion != 1 && messageSelection == 1) {
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ3036", null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV6ProviderConnection(JmsPropertyContext)", je, 1);
                }
                throw je;
            }
            String username = connectionProps.getStringProperty("XMSC_USERID");
            String password = connectionProps.getStringProperty("XMSC_PASSWORD");
            int transportType = connectionProps.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
            switch (transportType) {
                case 0: {
                    connection = new MQConnection(username, password, connectionProps);
                    break;
                }
                case 1: {
                    this.checkClientConnectionAllowed();
                    connection = new MQConnection(username, password, connectionProps);
                    break;
                }
                default: {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("connectionMode", Integer.toString(transportType));
                    Trace.ffst(this, "(createV6ProviderConnection)", "XT001004", info, JMSException.class);
                    break;
                }
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV6ProviderConnection(JmsPropertyContext)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV6ProviderConnection(JmsPropertyContext)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createV6ProviderConnection(JmsPropertyContext)", connection);
        }
        return connection;
    }

    protected ProviderConnection createDirectConnection(JmsPropertyContext connectionProps) throws JMSException {
        ConnectionImpl connection;
        String password;
        String username;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createDirectConnection(JmsPropertyContext)", new Object[]{connectionProps});
        }
        if ((username = connectionProps.getStringProperty("XMSC_USERID")) == null) {
            username = this.getProcessUserId();
        }
        if ((password = connectionProps.getStringProperty("XMSC_PASSWORD")) == null) {
            password = "";
        }
        if (Trace.isOn) {
            Trace.traceData(this, "connecting as user: " + username, null);
        }
        try {
            CSSystem.dynamicLoadClass("com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment", this.getClass());
        }
        catch (ClassNotFoundException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createDirectConnection(JmsPropertyContext)", e, 1);
            }
            HashMap<String, String> ffstData = new HashMap<String, String>();
            ffstData.put("Class", "com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment");
            Trace.ffst(this, "createDirectConnection(JmsPropertyContext)", "XT001005", ffstData, JMSException.class);
        }
        SessionConfig sessionConfig = new SessionConfig();
        String directSocketType = "tcp";
        int directAuth = connectionProps.getIntProperty("XMSC_RTT_DIRECT_AUTH");
        if (directAuth == 0) {
            sessionConfig.AUTH_PROTOCOLS = "PM";
        } else if (directAuth == 1) {
            String sslCipherSuite;
            sessionConfig.AUTH_PROTOCOLS = "SR";
            sessionConfig.SSL_CIPHER_SUITES = "SSL_RSA_WITH_RC4_128_SHA";
            if (Trace.isOn && (sslCipherSuite = connectionProps.getStringProperty("XMSC_WMQ_SSL_CIPHER_SUITE")) != null && Trace.isOn) {
                Trace.traceData(this, "WARNING: User specified ciphersuite " + sslCipherSuite + " ignored for DIRECTAUTH", null);
            }
            sessionConfig.SSL_PEER_NAME = connectionProps.getStringProperty("XMSC_WMQ_SSL_PEER_NAME");
            sessionConfig.SSL_SOCKET_FACTORY = connectionProps.getObjectProperty("XMSC_WMQ_SSL_SOCKET_FACTORY");
            sessionConfig.SSL_CERT_STORES = MQConnection.getSSLCertStores(connectionProps);
            SessionConfig.CLIENT_SECURITY_IMPL = "com.ibm.mq.jms.SxaSecurityImpl";
            sessionConfig.SSL_CLASS = "com.ibm.mq.jms.JsseImpl";
        }
        sessionConfig.MULTICAST_ENABLED = true;
        String local = connectionProps.getStringProperty("XMSC_WMQ_LOCAL_ADDRESS");
        if (local != null && !local.equals("")) {
            if (local.indexOf(40) != -1) {
                Trace.traceData(this, "Port specified on localAddr parameter (" + local + ") on a DH connect - failing connect", null);
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_WMQ_LOCAL_ADDRESS", local);
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSF1105", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createDirectConnection(JmsPropertyContext)", je, 1);
                }
                throw je;
            }
            sessionConfig.MULTICAST_MULTICAST_INTERFACE = local;
        } else {
            sessionConfig.MULTICAST_MULTICAST_INTERFACE = "none";
        }
        int transportType = connectionProps.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
        String proxyHostName = connectionProps.getStringProperty("XMSC_RTT_PROXY_HOSTNAME");
        int proxyPort = connectionProps.getIntProperty("XMSC_RTT_PROXY_PORT");
        if (proxyHostName != null && !proxyHostName.equals("")) {
            sessionConfig.HTTP_PROXY = proxyHostName;
            sessionConfig.HTTP_PROXY_PORT = proxyPort;
            directSocketType = "connect-via-proxy";
        } else if (transportType == 4) {
            directSocketType = "http";
        }
        sessionConfig.MAX_MESSAGE_QUEUE_SIZE = connectionProps.getIntProperty("XMSC_WMQ_MAX_BUFFER_SIZE");
        WMQConnectionNameList connName = (WMQConnectionNameList)this.getObjectProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT");
        connectionProps.setStringProperty("XMSC_WMQ_HOST_NAME", ((WMQConnectionName)connName.get(0)).getHostname());
        connectionProps.setIntProperty("XMSC_WMQ_PORT", new Integer(((WMQConnectionName)connName.get(0)).getPort()));
        String directHost = connectionProps.getStringProperty("XMSC_WMQ_HOST_NAME");
        int directPort = connectionProps.getIntProperty("XMSC_WMQ_PORT");
        SessionConfig.noMoreChanges = true;
        if (Trace.isOn) {
            Trace.traceData(this, "DH: directSocketType = " + directSocketType, null);
            Trace.traceData(this, "DH: AUTH_PROTOCOLS = " + sessionConfig.AUTH_PROTOCOLS, null);
            Trace.traceData(this, "DH: SSL_PEER_NAME = " + sessionConfig.SSL_PEER_NAME, null);
            Trace.traceData(this, "DH: MCAST_INTERFACE = " + sessionConfig.MULTICAST_MULTICAST_INTERFACE, null);
            Trace.traceData(this, "DH: HTTP_PROXY = " + sessionConfig.HTTP_PROXY, null);
            Trace.traceData(this, "DH: HTTP_PROXY_PORT = " + sessionConfig.HTTP_PROXY_PORT, null);
            Trace.traceData(this, "DH: MAX_MESSAGE_QUEUE_SIZE = " + sessionConfig.MAX_MESSAGE_QUEUE_SIZE, null);
        }
        try {
            switch (transportType) {
                case 4: {
                    connection = new ConnectionImpl(directSocketType, directHost, directPort, username, password, sessionConfig, connectionProps);
                    break;
                }
                default: {
                    connection = new ConnectionImpl(directSocketType, directHost, directPort, username, password, sessionConfig, connectionProps);
                }
            }
            String clientID = connectionProps.getStringProperty("XMSC_CLIENT_ID");
            if (clientID != null && clientID.length() > 0) {
                connection.setClientID(clientID);
            }
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createDirectConnection(JmsPropertyContext)", e, 2);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ6115", null));
            je.setLinkedException((Exception)e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createDirectConnection(JmsPropertyContext)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "createDirectConnection(JmsPropertyContext)", connection);
        }
        return connection;
    }

    protected String getProcessUserId() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "getProcessUserId()");
        }
        String username = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String traceRet1;
                block5: {
                    if (Trace.isOn) {
                        Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "run()");
                    }
                    traceRet1 = null;
                    try {
                        traceRet1 = PropertyStore.user_name;
                    }
                    catch (AccessControlException ace) {
                        if (!Trace.isOn) break block5;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()", ace);
                    }
                }
                if (traceRet1 == null) {
                    traceRet1 = "anonymous";
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", traceRet1);
                }
                return traceRet1;
            }
        });
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "getProcessUserId()", username);
        }
        return username;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        in.defaultReadObject();
        this.initialiseWMQConnectionFactory();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "readObject(java.io.ObjectInputStream)");
        }
    }

    public JmqiComponentTls newTlsObject() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "newTlsObject()");
        }
        WMQThreadLocalStorage traceRet1 = new WMQThreadLocalStorage();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "newTlsObject()", (Object)traceRet1);
        }
        return traceRet1;
    }

    public String getJmqiComponentName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "getJmqiComponentName()", "getter", "com.ibm.msg.client.wmq");
        }
        return "com.ibm.msg.client.wmq";
    }

    public Object mapFromCanonical(String keyIn, Object valueIn) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "mapFromCanonical(String,Object)", new Object[]{keyIn, valueIn});
        }
        if (propertyValidators.size() > 0) {
            WMQStandardValidators.WMQPropertyValidator mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn);
            if (mapper == null) {
                mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn.toUpperCase());
            }
            if (mapper != null) {
                WMQValidationInterface.WMQPropertyValidatorDatatype mappedPair = mapper.fromCanonical(this, keyIn, valueIn);
                Object traceRet1 = mappedPair.getValue();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "mapFromCanonical(String,Object)", traceRet1, 1);
                }
                return traceRet1;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "mapFromCanonical(String,Object)", valueIn, 2);
            }
            return valueIn;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "mapFromCanonical(String,Object)", valueIn, 3);
        }
        return valueIn;
    }

    public String getCanonicalKey(String keyIn) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "getCanonicalKey(String)", new Object[]{keyIn});
        }
        if (propertyValidators.size() > 0) {
            WMQStandardValidators.WMQPropertyValidator mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn);
            if (mapper == null) {
                mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn.toUpperCase());
            }
            if (mapper != null) {
                String traceRet1 = mapper.getDomainName(4);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "getCanonicalKey(String)", traceRet1, 1);
                }
                return traceRet1;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "getCanonicalKey(String)", keyIn, 2);
            }
            return keyIn;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "getCanonicalKey(String)", keyIn, 3);
        }
        return keyIn;
    }

    public Vector mapToCanonical(String keyIn, Object valueIn) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "mapToCanonical(String,Object)", new Object[]{keyIn, valueIn});
        }
        Vector<Object> result = new Vector<Object>();
        if (propertyValidators.size() > 0) {
            WMQStandardValidators.WMQPropertyValidator mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn);
            if (mapper == null) {
                mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn.toUpperCase());
            }
            if (mapper != null) {
                WMQValidationInterface.WMQPropertyValidatorDatatype pair = mapper.toCanonical(this, keyIn, valueIn);
                result.add(pair.getName());
                result.add(pair.getValue());
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "mapToCanonical(String,Object)", result, 1);
                }
                return result;
            }
            result.add(keyIn);
            result.add(valueIn);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "mapToCanonical(String,Object)", result, 2);
            }
            return result;
        }
        result.add(keyIn);
        result.add(valueIn);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "mapToCanonical(String,Object)", result, 3);
        }
        return result;
    }

    public boolean validate(Object name, Object value) throws JMSException {
        if (propertyValidators.size() > 0) {
            Object mqValidator = propertyValidators.get(name);
            if (mqValidator == null && name instanceof String) {
                mqValidator = propertyValidators.get(((String)name).toUpperCase());
            }
            if (mqValidator != null) {
                boolean traceRet1 = ((WMQStandardValidators.WMQPropertyValidator)mqValidator).validate(value, this.jmsPropertyContext);
                return traceRet1;
            }
            Trace.traceData(this, "Unable to find validator for property " + name + " - skipping validation", null);
            return true;
        }
        return true;
    }

    public String crossPropertyValidate() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "crossPropertyValidate()");
        }
        boolean overallValidation = true;
        String validationFailures = "";
        if (propertyValidators.size() > 0) {
            Iterator en = propertyValidators.keySet().iterator();
            while (en.hasNext()) {
                boolean validated;
                Object key;
                block9: {
                    key = en.next();
                    Object mqValidator = propertyValidators.get(key);
                    if (mqValidator == null) continue;
                    validated = true;
                    try {
                        validated = ((WMQStandardValidators.WMQPropertyValidator)mqValidator).crossPropertyValidate(this.jmsPropertyContext);
                    }
                    catch (JMSException j) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "crossPropertyValidate()", j);
                        }
                        if (!Trace.isOn) break block9;
                        Trace.traceWarning(this, "c.i.m.c.w.common.internal.WMQDestination", "crossPropertyValidate()", (Object)j);
                    }
                }
                if (validated) continue;
                overallValidation = false;
                validationFailures = validationFailures + key.toString() + ", ";
            }
        }
        if (overallValidation) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "crossPropertyValidate()", null, 1);
            }
            return null;
        }
        String traceRet1 = validationFailures.substring(0, validationFailures.length() - 2);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "crossPropertyValidate()", traceRet1, 2);
        }
        return traceRet1;
    }

    private boolean checkConnectionPV7Capable(WMQConnection connection, String requestedProviderVersion, boolean throwException) throws JMSException {
        int sharingConversations;
        int cmdLevel;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkConnectionPV7Capable(WMQConnection,String,boolean)", new Object[]{connection, requestedProviderVersion, throwException});
        }
        boolean traceRet1 = false;
        try {
            cmdLevel = connection.getCmdLevel();
            sharingConversations = connection.getSharingConversations();
        }
        catch (JmqiException j) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkConnectionPV7Capable(WMQConnection,String,boolean)", j);
            }
            JMSException jmsE = new JMSException(j.getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkConnectionPV7Capable(WMQConnection,String,boolean)", jmsE, 1);
            }
            throw jmsE;
        }
        if (cmdLevel < 700) {
            if (Trace.isOn) {
                Trace.traceData(this, "checkConnectionPV7Capable(WMQConnection)", (Object)"cmdLevel < 700; not a v7 capable QM");
            }
            if (throwException) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_WMQ_PROVIDER_VERSION", requestedProviderVersion);
                inserts.put("XMSC_INSERT_COMMAND_LEVEL", Integer.toString(cmdLevel));
                Log.log(this, "checkConnectionPV7Capable()", "JMSFMQ0003", inserts);
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ0003", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkConnectionPV7Capable(WMQConnection,String,boolean)", je, 2);
                }
                throw je;
            }
            traceRet1 = false;
        } else if (sharingConversations != -1 && sharingConversations == 0) {
            if (Trace.isOn) {
                Trace.traceData(this, "checkConnectionPV7Capable(WMQConnection)", (Object)"sharingConversations == 0; not a v7 capable client connection");
            }
            if (throwException) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_VALUE", Integer.toString(sharingConversations));
                inserts.put("XMSC_WMQ_PROVIDER_VERSION", requestedProviderVersion);
                Log.log(this, "checkConnectionPV7Capable()", "JMSFMQ0004", inserts);
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkConnectionPV7Capable(WMQConnection,String,boolean)", je, 3);
                }
                throw je;
            }
            traceRet1 = false;
        } else {
            if (Trace.isOn) {
                Trace.traceData(this, "checkConnectionPV7Capable(WMQConnection)", (Object)"v7 capable QM and/or connection");
            }
            traceRet1 = true;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkConnectionPV7Capable(WMQConnection,String,boolean)", traceRet1);
        }
        return traceRet1;
    }

    private void checkClientConnectionAllowed() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkClientConnectionAllowed()");
        }
        boolean forceAllowClientConnection = false;
        PropertyStore.register("com.ibm.msg.client.wmq.forceAllowClientConnection", forceAllowClientConnection, true);
        forceAllowClientConnection = PropertyStore.getBooleanProperty("com.ibm.msg.client.wmq.forceAllowClientConnection");
        if (Trace.isOn) {
            Trace.traceData(this, "zSeries = " + WMQFactoryFactory.zSeries, null);
            Trace.traceData(this, "forceAllowClientConnection = " + forceAllowClientConnection, null);
        }
        if (!WMQFactoryFactory.zSeries || forceAllowClientConnection) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkClientConnectionAllowed()");
            }
            return;
        }
        Log.log(this, "checkClientConnectionAllowed()", "JMSFMQ0005", null);
        JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ0005", null));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "checkClientConnectionAllowed()", je);
        }
        throw je;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "static", "SCCS id", (Object)sccsid1);
        }
        forceDontUseJmqiWorkerThreadProperty = "com.ibm.msg.client.wmq.internal.forceDontUseJmqiWorkerThread";
        forceDontUseJmqiWorkerThread = false;
        forceDontUseSharedHconnProperty = "com.ibm.msg.client.wmq.internal.forceDontUseSharedHconn";
        forceDontUseSharedHconn = false;
        forceUseJmqiWorkerThreadProperty = "com.ibm.msg.client.wmq.internal.forceUseJmqiWorkerThread";
        forceUseJmqiWorkerThread = false;
        inheritRRSContextProperty = "com.ibm.msg.client.wmq.overrideInheritRRSContext";
        inheritRRSContext = false;
        propertyValidators = new HashMap();
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "static()");
        }
        propertyValidators.put("XMSC_CLIENT_ID", "validateClientID");
        propertyValidators.put("XMSC_USERID", "validateUserID");
        propertyValidators.put("XMSC_PASSWORD", "validatePassword");
        PropertyStore.register(forceUseJmqiWorkerThreadProperty, false);
        PropertyStore.register(forceDontUseJmqiWorkerThreadProperty, false);
        PropertyStore.register(forceDontUseSharedHconnProperty, false);
        PropertyStore.register(inheritRRSContextProperty, false);
        PropertyStore.register("com.ibm.mq.connector.JCARuntimeHelper", (Object)null);
        forceUseJmqiWorkerThread = PropertyStore.getBooleanProperty(forceUseJmqiWorkerThreadProperty);
        forceDontUseJmqiWorkerThread = PropertyStore.getBooleanProperty(forceDontUseJmqiWorkerThreadProperty);
        forceDontUseSharedHconn = PropertyStore.getBooleanProperty(forceDontUseSharedHconnProperty);
        inheritRRSContext = PropertyStore.getBooleanProperty(inheritRRSContextProperty);
        propertyValidators.put("XMSC_ADMIN_OBJECT_TYPE", new WMQAdminObjectPropertyValidator(4));
        propertyValidators.put("XMSC_WMQ_BROKER_CC_SUBQ", new WMQBrokerCCSubQPropertyValidator(4));
        propertyValidators.put("BROKERCCSUBQ", new WMQBrokerCCSubQPropertyValidator(1));
        propertyValidators.put("CCSUB", new WMQBrokerCCSubQPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_BROKER_CONTROLQ", new WMQBrokerControlQPropertyValidator(4));
        propertyValidators.put("BROKERCONQ", new WMQBrokerControlQPropertyValidator(1));
        propertyValidators.put("BCON", new WMQBrokerControlQPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_BROKER_PUBQ", new WMQBrokerPubQPropertyValidator(4));
        propertyValidators.put("BROKERPUBQ", new WMQBrokerPubQPropertyValidator(1));
        propertyValidators.put("BPUB", new WMQBrokerPubQPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_BROKER_QMGR", new WMQBrokerQMgrPropertyValidator(4));
        propertyValidators.put("BROKERQMGR", new WMQBrokerQMgrPropertyValidator(1));
        propertyValidators.put("BQM", new WMQBrokerQMgrPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_BROKER_SUBQ", new WMQBrokerSubQPropertyValidator(4));
        propertyValidators.put("BROKERSUBQ", new WMQBrokerSubQPropertyValidator(1));
        propertyValidators.put("BSUB", new WMQBrokerSubQPropertyValidator(2));
        propertyValidators.put("brokerVersion", new WMQBrokerVersionPropertyValidator(4));
        propertyValidators.put("BROKERVERPUBQ", new WMQBrokerVersionPropertyValidator(1));
        propertyValidators.put("BVER", new WMQBrokerVersionPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_QMGR_CCSID", new WMQQMgrCCSIDPropertyValidator(4));
        propertyValidators.put("CCSID", new WMQQMgrCCSIDPropertyValidator(1));
        propertyValidators.put("CCS", new WMQQMgrCCSIDPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CCDTURL", new WMQCCDTURLPropertyValidator(4));
        propertyValidators.put("CCDTURL", new WMQCCDTURLPropertyValidator(1));
        propertyValidators.put("CCDT", new WMQCCDTURLPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CHANNEL", new WMQChannelPropertyValidator(4));
        propertyValidators.put("CHANNEL", new WMQChannelPropertyValidator(1));
        propertyValidators.put("CHAN", new WMQChannelPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CLEANUP_INTERVAL", new WMQCleanupIntervalPropertyValidator(4));
        propertyValidators.put("CLEANUPINT", new WMQCleanupIntervalPropertyValidator(1));
        propertyValidators.put("CLINT", new WMQCleanupIntervalPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CLEANUP_LEVEL", new WMQCleanupLevelPropertyValidator(4));
        propertyValidators.put("CLEANUP", new WMQCleanupLevelPropertyValidator(1));
        propertyValidators.put("CL", new WMQCleanupLevelPropertyValidator(2));
        propertyValidators.put("XMSC_CLIENT_ID", new WMQClientIDPropertyValidator(4));
        propertyValidators.put("CLIENTID", new WMQClientIDPropertyValidator(1));
        propertyValidators.put("CID", new WMQClientIDPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CLONE_SUPPORT", new WMQCloneSupportPropertyValidator(4));
        propertyValidators.put("CLONESUPP", new WMQCloneSupportPropertyValidator(1));
        propertyValidators.put("CLS", new WMQCloneSupportPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CONNECTION_TAG", new WMQConnTagPropertyValidator(4));
        propertyValidators.put("CONNTAG", new WMQConnTagPropertyValidator(1));
        propertyValidators.put("CNTAG", new WMQConnTagPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CF_DESCRIPTION", new WMQCFDescriptionPropertyValidator(4));
        propertyValidators.put("DESCRIPTION", new WMQCFDescriptionPropertyValidator(1));
        propertyValidators.put("DESC", new WMQCFDescriptionPropertyValidator(2));
        propertyValidators.put("XMSC_RTT_DIRECT_AUTH", new WMQDirectAuthPropertyValidator(4));
        propertyValidators.put("DIRECTAUTH", new WMQDirectAuthPropertyValidator(1));
        propertyValidators.put("DAUTH", new WMQDirectAuthPropertyValidator(2));
        propertyValidators.put("failIfQuiesce", new WMQFailIfQuiescePropertyValidator(4));
        propertyValidators.put("FAILIFQUIESCE", new WMQFailIfQuiescePropertyValidator(1));
        propertyValidators.put("FIQ", new WMQFailIfQuiescePropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_HEADER_COMP", new WMQHeaderCompPropertyValidator(4));
        propertyValidators.put("COMPHDR", new WMQHeaderCompPropertyValidator(1));
        propertyValidators.put("HC", new WMQHeaderCompPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_HOST_NAME", new WMQHostnamePropertyValidator(4));
        propertyValidators.put("HOSTNAME", new WMQHostnamePropertyValidator(1));
        propertyValidators.put("HOST", new WMQHostnamePropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_LOCAL_ADDRESS", new WMQLocalAddressPropertyValidator(4));
        propertyValidators.put("LOCALADDRESS", new WMQLocalAddressPropertyValidator(1));
        propertyValidators.put("LA", new WMQLocalAddressPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_MAP_NAME_STYLE", new WMQMapmsgNameStylePropertyValidator(4));
        propertyValidators.put("MAPNAMESTYLE", new WMQMapmsgNameStylePropertyValidator(1));
        propertyValidators.put("MNST", new WMQMapmsgNameStylePropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_MAX_BUFFER_SIZE", new WMQMaxBufferSizePropertyValidator(4));
        propertyValidators.put("MAXBUFFSIZE", new WMQMaxBufferSizePropertyValidator(1));
        propertyValidators.put("MBSZ", new WMQMaxBufferSizePropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_MESSAGE_RETENTION", new WMQMessageRetentionPropertyValidator(4));
        propertyValidators.put("MSGRETENTION", new WMQMessageRetentionPropertyValidator(1));
        propertyValidators.put("MRET", new WMQMessageRetentionPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_MESSAGE_SELECTION", new WMQMessageSelectionPropertyValidator(4));
        propertyValidators.put("MSGSELECTION", new WMQMessageSelectionPropertyValidator(1));
        propertyValidators.put("MSEL", new WMQMessageSelectionPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CONNECT_OPTIONS", new WMQConnectionOptionsPropertyValidator(4));
        propertyValidators.put("CONNOPT", new WMQConnectionOptionsPropertyValidator(1));
        propertyValidators.put("CNOPT", new WMQConnectionOptionsPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_MSG_BATCH_SIZE", new WMQMsgBatchSizePropertyValidator(4));
        propertyValidators.put("MSGBATCHSZ", new WMQMsgBatchSizePropertyValidator(1));
        propertyValidators.put("MBS", new WMQMsgBatchSizePropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_MSG_COMP", new WMQMsgCompPropertyValidator(4));
        propertyValidators.put("COMPMSG", new WMQMsgCompPropertyValidator(1));
        propertyValidators.put("MC", new WMQMsgCompPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_POLLING_INTERVAL", new WMQPollingIntervalPropertyValidator(4));
        propertyValidators.put("POLLINGINT", new WMQPollingIntervalPropertyValidator(1));
        propertyValidators.put("PINT", new WMQPollingIntervalPropertyValidator(2));
        propertyValidators.put("multicast", new WMQMulticastPropertyValidator(4));
        propertyValidators.put("MULTICAST", new WMQMulticastPropertyValidator(1));
        propertyValidators.put("MCAST", new WMQMulticastPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_OPT_PUB", new WMQOptPubPropertyValidator(4));
        propertyValidators.put("OPTIMISTICPUBLICATION", new WMQOptPubPropertyValidator(1));
        propertyValidators.put("OPTPUB", new WMQOptPubPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_OUTCOME_NOTIFICATION", new WMQOutNotifyPropertyValidator(4));
        propertyValidators.put("OUTCOMENOTIFICATION", new WMQOutNotifyPropertyValidator(1));
        propertyValidators.put("NOTIFY", new WMQOutNotifyPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_PORT", new WMQPortPropertyValidator(4));
        propertyValidators.put("PORT", new WMQPortPropertyValidator(1));
        propertyValidators.put("PORT", new WMQPortPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_PROCESS_DURATION", new WMQProcessDurationPropertyValidator(4));
        propertyValidators.put("PROCESSDURATION", new WMQProcessDurationPropertyValidator(1));
        propertyValidators.put("PROCDUR", new WMQProcessDurationPropertyValidator(2));
        propertyValidators.put("XMSC_RTT_PROXY_HOSTNAME", new WMQProxyHostnamePropertyValidator(4));
        propertyValidators.put("PROXYHOSTNAME", new WMQProxyHostnamePropertyValidator(1));
        propertyValidators.put("PHOST", new WMQProxyHostnamePropertyValidator(2));
        propertyValidators.put("XMSC_RTT_PROXY_PORT", new WMQProxyPortPropertyValidator(4));
        propertyValidators.put("PROXYPORT", new WMQProxyPortPropertyValidator(1));
        propertyValidators.put("PPORT", new WMQProxyPortPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_PROVIDER_VERSION", new WMQProviderVersionPropertyValidator(4));
        propertyValidators.put("PROVIDERVERSION", new WMQProviderVersionPropertyValidator(1));
        propertyValidators.put("PVER", new WMQProviderVersionPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_PUB_ACK_INTERVAL", new WMQPubAckIntervalPropertyValidator(4));
        propertyValidators.put("PUBACKINT", new WMQPubAckIntervalPropertyValidator(1));
        propertyValidators.put("PAI", new WMQPubAckIntervalPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_QUEUE_MANAGER", new WMQQueueManagerPropertyValidator(4));
        propertyValidators.put("QMANAGER", new WMQQueueManagerPropertyValidator(1));
        propertyValidators.put("QMGR", new WMQQueueManagerPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_RECEIVE_EXIT", new WMQReceiveExitPropertyValidator(4));
        propertyValidators.put("RECEXIT", new WMQReceiveExitPropertyValidator(1));
        propertyValidators.put("RCX", new WMQReceiveExitPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_RECEIVE_EXIT_INIT", new WMQReceiveExitInitPropertyValidator(4));
        propertyValidators.put("RECEXITINIT", new WMQReceiveExitInitPropertyValidator(1));
        propertyValidators.put("RCXI", new WMQReceiveExitInitPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_RECEIVE_ISOLATION", new WMQRcvIsolPropertyValidator(4));
        propertyValidators.put("RECEIVEISOLATION", new WMQRcvIsolPropertyValidator(1));
        propertyValidators.put("RCVISOL", new WMQRcvIsolPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_RESCAN_INTERVAL", new WMQRescanIntervalPropertyValidator(4));
        propertyValidators.put("RESCANINT", new WMQRescanIntervalPropertyValidator(1));
        propertyValidators.put("RINT", new WMQRescanIntervalPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SECURITY_EXIT", new WMQSecurityExitPropertyValidator(4));
        propertyValidators.put("SECEXIT", new WMQSecurityExitPropertyValidator(1));
        propertyValidators.put("SCX", new WMQSecurityExitPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SECURITY_EXIT_INIT", new WMQSecurityExitInitPropertyValidator(4));
        propertyValidators.put("SECEXITINIT", new WMQSecurityExitInitPropertyValidator(1));
        propertyValidators.put("SCXI", new WMQSecurityExitInitPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SEND_CHECK_COUNT", new WMQSendCheckCountPropertyValidator(4));
        propertyValidators.put("SENDCHECKCOUNT", new WMQSendCheckCountPropertyValidator(1));
        propertyValidators.put("SCC", new WMQSendCheckCountPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SEND_EXIT", new WMQSendExitPropertyValidator(4));
        propertyValidators.put("SENDEXIT", new WMQSendExitPropertyValidator(1));
        propertyValidators.put("SDX", new WMQSendExitPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SEND_EXIT_INIT", new WMQSendExitInitPropertyValidator(4));
        propertyValidators.put("SENDEXITINIT", new WMQSendExitInitPropertyValidator(1));
        propertyValidators.put("SDXI", new WMQSendExitInitPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SHARE_CONV_ALLOWED", new WMQShareConvAllowedPropertyValidator(4));
        propertyValidators.put("SHARECONVALLOWED", new WMQShareConvAllowedPropertyValidator(1));
        propertyValidators.put("SCALD", new WMQShareConvAllowedPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SPARSE_SUBSCRIPTIONS", new WMQSparseSubscriptionsPropertyValidator(4));
        propertyValidators.put("SPARSESUBS", new WMQSparseSubscriptionsPropertyValidator(1));
        propertyValidators.put("SSUBS", new WMQSparseSubscriptionsPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SSL_CERT_STORES_COL", new WMQSSLCertStoresColPropertyValidator(4));
        propertyValidators.put("XMSC_WMQ_SSL_CERT_STORES_STR", new WMQSSLCertStoresStrPropertyValidator(4));
        propertyValidators.put("SSLCRL", new WMQSSLCertStoresStrPropertyValidator(1));
        propertyValidators.put("SCRL", new WMQSSLCertStoresStrPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SSL_CIPHER_SUITE", new WMQSSLCipherSuitePropertyValidator(4));
        propertyValidators.put("SSLCIPHERSUITE", new WMQSSLCipherSuitePropertyValidator(1));
        propertyValidators.put("SCPHS", new WMQSSLCipherSuitePropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SSL_FIPS_REQUIRED", new WMQSSLFipsRequiredPropertyValidator(4));
        propertyValidators.put("SSLFIPSREQUIRED", new WMQSSLFipsRequiredPropertyValidator(1));
        propertyValidators.put("SFIPS", new WMQSSLFipsRequiredPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SSL_PEER_NAME", new WMQSSLPeerNamePropertyValidator(4));
        propertyValidators.put("SSLPEERNAME", new WMQSSLPeerNamePropertyValidator(1));
        propertyValidators.put("SPEER", new WMQSSLPeerNamePropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SSL_KEY_RESETCOUNT", new WMQSSLResetCountPropertyValidator(4));
        propertyValidators.put("SSLRESETCOUNT", new WMQSSLResetCountPropertyValidator(1));
        propertyValidators.put("SRC", new WMQSSLResetCountPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SSL_SOCKET_FACTORY", new WMQSSLSocketFactoryPropertyValidator(4));
        propertyValidators.put("XMSC_WMQ_STATUS_REFRESH_INTERVAL", new WMQStatusRefreshIntervalPropertyValidator(4));
        propertyValidators.put("STATREFRESHINT", new WMQStatusRefreshIntervalPropertyValidator(1));
        propertyValidators.put("SRI", new WMQStatusRefreshIntervalPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SUBSCRIPTION_STORE", new WMQSubscriptionStorePropertyValidator(4));
        propertyValidators.put("SUBSTORE", new WMQSubscriptionStorePropertyValidator(1));
        propertyValidators.put("SS", new WMQSubscriptionStorePropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_SYNCPOINT_ALL_GETS", new WMQSyncpointAllGetsPropertyValidator(4));
        propertyValidators.put("SYNCPOINTALLGETS", new WMQSyncpointAllGetsPropertyValidator(1));
        propertyValidators.put("SPAG", new WMQSyncpointAllGetsPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_TARGET_CLIENT_MATCHING", new WMQTargetClientMatchingPropertyValidator(4));
        propertyValidators.put("TARGCLIENTMATCHING", new WMQTargetClientMatchingPropertyValidator(1));
        propertyValidators.put("TCM", new WMQTargetClientMatchingPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_TEMPORARY_MODEL", new WMQTemporaryModelPropertyValidator(4));
        propertyValidators.put("TEMPMODEL", new WMQTemporaryModelPropertyValidator(1));
        propertyValidators.put("TM", new WMQTemporaryModelPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_TEMP_TOPIC_PREFIX", new WMQTempTopicPrefixPropertyValidator(4));
        propertyValidators.put("TEMPTOPICPREFIX", new WMQTempTopicPrefixPropertyValidator(1));
        propertyValidators.put("TTP", new WMQTempTopicPrefixPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_TEMP_Q_PREFIX", new WMQTempQPrefixPropertyValidator(4));
        propertyValidators.put("TEMPQPREFIX", new WMQTempQPrefixPropertyValidator(1));
        propertyValidators.put("TQP", new WMQTempQPrefixPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CONNECTION_MODE", new WMQConnectionModePropertyValidator(4));
        propertyValidators.put("TRANSPORT", new WMQConnectionModePropertyValidator(1));
        propertyValidators.put("TRAN", new WMQConnectionModePropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_USE_CONNECTION_POOLING", new WMQConnectionPoolingPropertyValidator(4));
        propertyValidators.put("USECONNPOOLING", new WMQConnectionPoolingPropertyValidator(1));
        propertyValidators.put("UCP", new WMQConnectionPoolingPropertyValidator(2));
        propertyValidators.put("wildcardFormat", new WMQWildcardFormatPropertyValidator(4));
        propertyValidators.put("WILDCARDFORMAT", new WMQWildcardFormatPropertyValidator(1));
        propertyValidators.put("WCFMT", new WMQWildcardFormatPropertyValidator(2));
        propertyValidators.put("XMSC_CONNECTION_TYPE_NAME", new WMQConnectionTypeNamePropertyValidator(4));
        propertyValidators.put("XMSC_CONNECTION_TYPE", new WMQConnectionTypePropertyValidator(4));
        propertyValidators.put("XMSC_PASSWORD", new WMQPasswordPropertyValidator(4));
        propertyValidators.put("XMSC_USERID", new WMQUserIDPropertyValidator(4));
        propertyValidators.put("XMSC_ASYNC_EXCEPTIONS", new WMQAsyncExceptionsPropertyValidator(4));
        propertyValidators.put("ASYNCEXCEPTION", new WMQAsyncExceptionsPropertyValidator(1));
        propertyValidators.put("AEX", new WMQAsyncExceptionsPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CLIENT_RECONNECT_OPTIONS", new WMQClientReconnectionOptionsPropertyValidator(4));
        propertyValidators.put("CLIENTRECONNECTOPTIONS", new WMQClientReconnectionOptionsPropertyValidator(1));
        propertyValidators.put("CROPT", new WMQClientReconnectionOptionsPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_CLIENT_RECONNECT_TIMEOUT", new WMQClientReconnectionTimeoutPropertyValidator(4));
        propertyValidators.put("XMSC_WMQ_CONNECTION_NAME_LIST_INT", new WMQConnectionNameListPropertyValidator(4));
        propertyValidators.put("XMSC_WMQ_CONNECTION_NAME_LIST", new WMQConnectionNameListPropertyValidator(5));
        propertyValidators.put("CONNECTIONNAMELIST", new WMQConnectionNameListPropertyValidator(1));
        propertyValidators.put("CNLIST", new WMQConnectionNameListPropertyValidator(2));
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "static()");
        }
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "static()");
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.factories.WMQConnectionFactory", "static()");
        }
    }

    static class WMQConnectionNameListPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = -542695826704636159L;
        static final /* synthetic */ boolean $assertionsDisabled;

        public WMQConnectionNameListPropertyValidator(int domain) {
            super(domain);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionNameListPropertyValidator", "<init>(int)", new Object[]{new Integer(domain)});
            }
            this.domainNames.put(new Integer(1), "CONNECTIONNAMELIST");
            this.domainNames.put(new Integer(2), "CNLIST");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CONNECTION_NAME_LIST_INT");
            this.domainNames.put(new Integer(5), "XMSC_WMQ_CONNECTION_NAME_LIST");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionNameListPropertyValidator", "<init>(int)");
            }
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype fromCanonical(JmsPropertyContext context, String keyIn, Object valueIn) {
            return this.fromCanonical(keyIn, valueIn);
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype fromCanonical(String keyIn, Object valueIn) {
            if (this.mapperDomain == 4 && keyIn.equalsIgnoreCase("XMSC_WMQ_CONNECTION_NAME_LIST_INT")) {
                return new WMQValidationInterface.WMQPropertyValidatorDatatype(keyIn, valueIn);
            }
            StringBuffer buffer = new StringBuffer();
            ArrayList list = (ArrayList)valueIn;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                WMQConnectionName wcn = (WMQConnectionName)iterator.next();
                buffer.append(",");
                buffer.append(wcn);
            }
            buffer.deleteCharAt(0);
            WMQValidationInterface.WMQPropertyValidatorDatatype datatype = new WMQValidationInterface.WMQPropertyValidatorDatatype(keyIn, buffer.toString());
            return datatype;
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(JmsPropertyContext context, String keyIn, Object valueIn) {
            return this.toCanonical(keyIn, valueIn);
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(String keyIn, Object valueIn) {
            WMQConnectionNameList list;
            if (valueIn instanceof WMQConnectionNameList) {
                list = (WMQConnectionNameList)valueIn;
            } else {
                list = new WMQConnectionNameList();
                String[] entries = ((String)valueIn).trim().split(",");
                for (int i = 0; i < entries.length; ++i) {
                    String[] singleEntry = entries[i].split("\\(|\\)");
                    if (!$assertionsDisabled && singleEntry.length != 1 && singleEntry.length != 2) {
                        throw new AssertionError();
                    }
                    if (singleEntry.length == 2) {
                        int port = Integer.parseInt(singleEntry[1].trim());
                        WMQConnectionName wcn = new WMQConnectionName(singleEntry[0], port);
                        list.add(wcn);
                        continue;
                    }
                    if (singleEntry.length != 1) continue;
                    WMQConnectionName wcn = new WMQConnectionName(singleEntry[0], 1414);
                    list.add(wcn);
                }
            }
            WMQValidationInterface.WMQPropertyValidatorDatatype datatype = new WMQValidationInterface.WMQPropertyValidatorDatatype("XMSC_WMQ_CONNECTION_NAME_LIST_INT", list);
            return datatype;
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnectionNameListPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (!super.validate(value, parent)) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionNameListPropertyValidator", "validate(Object,Object)", false, 1);
                }
                return false;
            }
            if (value == null || value.equals("")) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionNameListPropertyValidator", "validate(Object,Object)", false, 2);
                }
                return false;
            }
            String[] entries = ((String)value).trim().split(",");
            for (int i = 0; i < entries.length; ++i) {
                String[] singleEntry = entries[i].split("\\(|\\)");
                if (!$assertionsDisabled && singleEntry.length != 1 && singleEntry.length != 2) {
                    throw new AssertionError();
                }
                if (singleEntry.length != 2) continue;
                try {
                    Integer.parseInt(singleEntry[1].trim());
                    continue;
                }
                catch (NumberFormatException nfe) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionNameListPropertyValidator", "validate(Object,Object)", false, 4);
                    }
                    return false;
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQConnectionNameListPropertyValidator", "validate(Object,Object)", true, 3);
            }
            return true;
        }

        static {
            $assertionsDisabled = !(class$com$ibm$msg$client$wmq$factories$WMQConnectionFactory == null ? (class$com$ibm$msg$client$wmq$factories$WMQConnectionFactory = WMQConnectionFactory.class$("com.ibm.msg.client.wmq.factories.WMQConnectionFactory")) : class$com$ibm$msg$client$wmq$factories$WMQConnectionFactory).desiredAssertionStatus();
        }
    }

    static class WMQClientReconnectionTimeoutPropertyValidator
    extends WMQStandardValidators.WMQIntPropertyValidator {
        private static final long serialVersionUID = -542695826704636159L;

        public WMQClientReconnectionTimeoutPropertyValidator(int domain) {
            super(domain);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionTimeoutPropertyValidator", "<init>(int)", new Object[]{new Integer(domain)});
            }
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CLIENT_RECONNECT_TIMEOUT");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionTimeoutPropertyValidator", "<init>(int)");
            }
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionTimeoutPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (!super.validate(value, parent)) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionTimeoutPropertyValidator", "validate(Object,Object)", false, 1);
                }
                return false;
            }
            if ((Integer)value < 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionTimeoutPropertyValidator", "validate(Object,Object)", false, 2);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionTimeoutPropertyValidator", "validate(Object,Object)", true, 3);
            }
            return true;
        }
    }

    static class WMQClientReconnectionOptionsPropertyValidator
    extends WMQStandardValidators.WMQIntPropertyValidator {
        private static final long serialVersionUID = -542695826704636159L;

        public WMQClientReconnectionOptionsPropertyValidator(int domain) {
            super(domain);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionOptionsPropertyValidator", "<init>(int)", new Object[]{new Integer(domain)});
            }
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CLIENT_RECONNECT_OPTIONS");
            this.domainNames.put(new Integer(1), "CLIENTRECONNECTOPTIONS");
            this.domainNames.put(new Integer(2), "CROPT");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("ANY", new Integer(0x1000000));
            adminNames.put("QMGR", new Integer(0x4000000));
            adminNames.put("ASDEF", new Integer(0));
            adminNames.put("DISABLED", new Integer(0x2000000));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionOptionsPropertyValidator", "<init>(int)");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionOptionsPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (value instanceof Integer) {
                int cropt = (Integer)value;
                switch (cropt) {
                    case 0: 
                    case 0x1000000: 
                    case 0x2000000: 
                    case 0x4000000: {
                        if (!Trace.isOn) return true;
                        Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionOptionsPropertyValidator", "validate(Object,Object)", true, 2);
                        return true;
                    }
                }
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("XMSC_INSERT_VALUE", String.valueOf(cropt));
                info.put("XMSC_INSERT_NAME", "XMSC_WMQ_CLIENT_RECONNECT_OPTIONS");
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                throw je;
            }
            if (!Trace.isOn) return false;
            Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQClientReconnectionOptionsPropertyValidator", "validate(Object,Object)", false, 3);
            return false;
        }
    }

    static class WMQAsyncExceptionsPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 5712381868077510247L;

        public WMQAsyncExceptionsPropertyValidator(int domain) {
            super(domain);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQAsyncExceptionsPropertyValidator", "<init>(int)", new Object[]{new Integer(domain)});
            }
            this.domainNames.put(new Integer(1), "ASYNCEXCEPTION");
            this.domainNames.put(new Integer(2), "AEX");
            this.domainNames.put(new Integer(4), "XMSC_ASYNC_EXCEPTIONS");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("ALL", new Integer(-1));
            adminNames.put("CONNECTIONBROKEN", new Integer(1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQAsyncExceptionsPropertyValidator", "<init>(int)");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer || value instanceof Long)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer) && !(value instanceof Long)) return false;
            int asyncflags = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
            if (asyncflags == -1 || asyncflags == 1) return true;
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(asyncflags));
            info.put("XMSC_INSERT_NAME", "AsyncExceptions");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQUserIDPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = -6338751396776206443L;

        public WMQUserIDPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_USERID");
        }
    }

    static class WMQPasswordPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = 7715077688644289226L;

        public WMQPasswordPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_PASSWORD");
        }
    }

    static class WMQConnectionTypePropertyValidator
    extends WMQStandardValidators.WMQIntPropertyValidator {
        private static final long serialVersionUID = 6735356794678569616L;

        public WMQConnectionTypePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_CONNECTION_TYPE");
        }
    }

    static class WMQConnectionTypeNamePropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = -6292739949362401746L;

        public WMQConnectionTypeNamePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_CONNECTION_TYPE_NAME");
        }
    }

    static class WMQWildcardFormatPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 6686620470291229589L;

        public WMQWildcardFormatPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "WILDCARDFORMAT");
            this.domainNames.put(new Integer(2), "WCFMT");
            this.domainNames.put(new Integer(4), "wildcardFormat");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("CHAR_ONLY", new Integer(1));
            adminNames.put("TOPIC_ONLY", new Integer(0));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int intval = (Integer)value;
            if (intval >= 0 && intval <= 2) return true;
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(intval));
            info.put("XMSC_INSERT_NAME", "wildcardFormat");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQConnectionPoolingPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 277824117667162657L;

        public WMQConnectionPoolingPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "USECONNPOOLING");
            this.domainNames.put(new Integer(2), "UCP");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_USE_CONNECTION_POOLING");
            HashMap<String, Boolean> adminNames = new HashMap<String, Boolean>();
            adminNames.put("YES", Boolean.TRUE);
            adminNames.put("NO", Boolean.FALSE);
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Boolean)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (value != null && (((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("yes"))) {
                    value = new Boolean(true);
                } else if (value != null && (((String)value).equalsIgnoreCase("false") || ((String)value).equalsIgnoreCase("no"))) {
                    value = new Boolean(false);
                }
            }
            return value instanceof Boolean;
        }
    }

    static class WMQConnectionModePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 6461105230365657215L;

        public WMQConnectionModePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "TRANSPORT");
            this.domainNames.put(new Integer(2), "TRAN");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CONNECTION_MODE");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("CLIENT", new Integer(1));
            adminNames.put("BIND", new Integer(0));
            adminNames.put("DIRECT", new Integer(2));
            adminNames.put("DIRECTHTTP", new Integer(4));
            adminNames.put("BINDINGS_THEN_CLIENT", new Integer(8));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            void var4_4;
            int type;
            JmsPropertyContext parentPC = (JmsPropertyContext)parent;
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (!(value instanceof Integer) && !(value instanceof String)) return false;
            if (value instanceof Integer) {
                type = (Integer)value;
            } else if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                if (!adminNames.containsKey(value)) return false;
                type = (Integer)adminNames.get(value);
            } else {
                try {
                    type = Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            switch (var4_4) {
                case 8: {
                    return true;
                }
                case 0: 
                case 1: {
                    int options;
                    if (var4_4 != true || ((options = parentPC.getIntProperty("XMSC_WMQ_CONNECT_OPTIONS")) & 8) == 0 && (options & 0x10) == 0) return true;
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(options));
                    info.put("XMSC_INSERT_NAME", "Invalid connection options when in client mode");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                case 2: 
                case 4: {
                    Class<?> parentClass = parent.getClass();
                    if (!parentClass.equals(class$com$ibm$mq$jms$MQQueueConnectionFactory == null ? (class$com$ibm$mq$jms$MQQueueConnectionFactory = WMQConnectionFactory.class$("com.ibm.mq.jms.MQQueueConnectionFactory")) : class$com$ibm$mq$jms$MQQueueConnectionFactory) && !parentClass.equals(class$com$ibm$mq$jms$MQXAConnectionFactory == null ? (class$com$ibm$mq$jms$MQXAConnectionFactory = WMQConnectionFactory.class$("com.ibm.mq.jms.MQXAConnectionFactory")) : class$com$ibm$mq$jms$MQXAConnectionFactory) && !parentClass.equals(class$com$ibm$mq$jms$MQXAQueueConnectionFactory == null ? (class$com$ibm$mq$jms$MQXAQueueConnectionFactory = WMQConnectionFactory.class$("com.ibm.mq.jms.MQXAQueueConnectionFactory")) : class$com$ibm$mq$jms$MQXAQueueConnectionFactory) && !parentClass.equals(class$com$ibm$mq$jms$MQXATopicConnectionFactory == null ? (class$com$ibm$mq$jms$MQXATopicConnectionFactory = WMQConnectionFactory.class$("com.ibm.mq.jms.MQXATopicConnectionFactory")) : class$com$ibm$mq$jms$MQXATopicConnectionFactory)) return true;
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf((int)var4_4));
                    info.put("XMSC_INSERT_NAME", "transportType");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf((int)var4_4));
            info.put("XMSC_INSERT_NAME", "transportType");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQTempQPrefixPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 2717973061599556214L;

        public WMQTempQPrefixPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "TEMPQPREFIX");
            this.domainNames.put(new Integer(2), "TQP");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_TEMP_Q_PREFIX");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQTopicConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setTempQPrefix()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (value == null) {
                value = "";
            }
            String newTempQPrefix = this.convertToString(value);
            if (newTempQPrefix == null || newTempQPrefix.equals("")) {
                return true;
            }
            int length = 0;
            length = newTempQPrefix.length();
            if (length < 2 || length > 33 || !newTempQPrefix.substring(newTempQPrefix.length() - 1, newTempQPrefix.length()).equals("*")) {
                String vstr = newTempQPrefix;
                if (vstr == null) {
                    vstr = "<null>";
                }
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("XMSC_INSERT_VALUE", vstr);
                info.put("XMSC_INSERT_NAME", "tempQPrefix");
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                throw je;
            }
            return true;
        }
    }

    static class WMQTempTopicPrefixPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 5325130931042923132L;
        private static final Pattern badPattern = Pattern.compile(".*((#+)|(\\++)|(/+)|(\\*+)|(\\?+)).*");

        public WMQTempTopicPrefixPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "TEMPTOPICPREFIX");
            this.domainNames.put(new Integer(2), "TTP");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_TEMP_TOPIC_PREFIX");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setTempTopicPrefix()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (value == null) {
                return true;
            }
            if (badPattern.matcher((String)(value = this.convertToString(value))).matches()) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("XMSC_INSERT_VALUE", String.valueOf(value));
                info.put("XMSC_INSERT_NAME", "tempTopicPrefix");
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                throw je;
            }
            return true;
        }
    }

    static class WMQTemporaryModelPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = 5032845991021006372L;

        public WMQTemporaryModelPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "TEMPMODEL");
            this.domainNames.put(new Integer(2), "TM");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_TEMPORARY_MODEL");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQTopicConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setTemporaryModel()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            boolean traceRet1 = super.validate(value, parent);
            return traceRet1;
        }
    }

    static class WMQTargetClientMatchingPropertyValidator
    extends WMQStandardValidators.WMQBooleanPropertyValidator {
        private static final long serialVersionUID = 5614110823978901569L;

        public WMQTargetClientMatchingPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "TARGCLIENTMATCHING");
            this.domainNames.put(new Integer(2), "TCM");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_TARGET_CLIENT_MATCHING");
            HashMap<String, Boolean> adminNames = new HashMap<String, Boolean>();
            adminNames.put("YES", Boolean.TRUE);
            adminNames.put("NO", Boolean.FALSE);
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }
    }

    static class WMQSyncpointAllGetsPropertyValidator
    extends WMQStandardValidators.WMQBooleanPropertyValidator {
        private static final long serialVersionUID = 6573805368499716518L;

        public WMQSyncpointAllGetsPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SYNCPOINTALLGETS");
            this.domainNames.put(new Integer(2), "SPAG");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SYNCPOINT_ALL_GETS");
            HashMap<String, Boolean> adminNames = new HashMap<String, Boolean>();
            adminNames.put("YES", Boolean.TRUE);
            adminNames.put("NO", Boolean.FALSE);
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }
    }

    static class WMQSubscriptionStorePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -3149709136733446051L;

        public WMQSubscriptionStorePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SUBSTORE");
            this.domainNames.put(new Integer(2), "SS");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SUBSCRIPTION_STORE");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("MIGRATE", new Integer(2));
            adminNames.put("QUEUE", new Integer(0));
            adminNames.put("BROKER", new Integer(1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setSubscriptionStore()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int flag = (Integer)value;
            switch (flag) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(flag));
            info.put("XMSC_INSERT_NAME", "subscriptionStore");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQStatusRefreshIntervalPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -7976792455381322958L;

        public WMQStatusRefreshIntervalPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "STATREFRESHINT");
            this.domainNames.put(new Integer(2), "SRI");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_STATUS_REFRESH_INTERVAL");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setStatusRefreshInterval()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                int interval = (Integer)value;
                if (interval != -1 && interval < 0) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(interval));
                    info.put("XMSC_INSERT_NAME", "StatusRefreshInterval");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }
    }

    static class WMQSSLSocketFactoryPropertyValidator
    extends WMQStandardValidators.WMQTrivialPropertyValidator {
        private static final long serialVersionUID = 1770397102389658575L;

        public WMQSSLSocketFactoryPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SSL_SOCKET_FACTORY");
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQSSLSocketFactoryPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_SOCKET_FACTORY") != null && ((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_CIPHER_SUITE") == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLSocketFactoryPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLSocketFactoryPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQSSLResetCountPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -6355667917902267498L;

        public WMQSSLResetCountPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SSLRESETCOUNT");
            this.domainNames.put(new Integer(2), "SRC");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SSL_KEY_RESETCOUNT");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                int bytes = (Integer)value;
                if (bytes < 0 || bytes > 999999999) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(bytes));
                    info.put("XMSC_INSERT_NAME", "sslResetCount");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return value == null;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQSSLResetCountPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_SSL_KEY_RESETCOUNT") != 0 && ((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_CIPHER_SUITE") == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLResetCountPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLResetCountPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQSSLPeerNamePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 4934320916933908241L;

        public WMQSSLPeerNamePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SSLPEERNAME");
            this.domainNames.put(new Integer(2), "SPEER");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SSL_PEER_NAME");
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_PEER_NAME") != null && ((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_CIPHER_SUITE") == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }

        public boolean validate(Object value, Object propContext) throws JMSException {
            if (value == null) {
                return true;
            }
            value = this.convertToString(value);
            boolean traceRet1 = this.checkPeerName((String)value);
            return traceRet1;
        }

        private boolean checkPeerName(String DN) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "checkPeerName(String)", new Object[]{DN});
            }
            boolean DNCLEAR = true;
            int DNSYMBOL = 2;
            int DNVALUE = 3;
            int DNQVALUE = 4;
            int DNFINISHED = 5;
            int state = 1;
            String symbol = "";
            String value = "";
            if (DN != null && DN.equals("")) {
                state = 5;
            }
            try {
                for (int i = 0; i < DN.length(); ++i) {
                    char ch = DN.charAt(i);
                    if (state == 1) {
                        if (ch == '\"' || ch == ',' || ch == ';' || ch == '=') {
                            MQException traceRet1 = new MQException(2, 2399, (Object)this);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "checkPeerName(String)", traceRet1, 1);
                            }
                            throw traceRet1;
                        }
                        if (ch == ' ' || ch == '\t') continue;
                        symbol = symbol + ch;
                        state = 2;
                        continue;
                    }
                    if (state == 2) {
                        if (ch == ' ' || ch == '\"') {
                            MQException traceRet2 = new MQException(2, 2399, (Object)this);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "checkPeerName(String)", traceRet2, 2);
                            }
                            throw traceRet2;
                        }
                        if (ch == '=') {
                            value = "";
                            if (i + 1 >= DN.length()) {
                                state = 3;
                                continue;
                            }
                            if (DN.charAt(i + 1) == '\"') {
                                ++i;
                                state = 4;
                                continue;
                            }
                            state = 3;
                            continue;
                        }
                        symbol = symbol + ch;
                        continue;
                    }
                    if (state == 3) {
                        if (!(ch != ',' && ch != ';' || i != 0 && DN.charAt(i - 1) == '\\')) {
                            state = 1;
                            symbol = "";
                            continue;
                        }
                        value = value + ch;
                        continue;
                    }
                    if (state == 4) {
                        if (ch == '\"' && (i == 0 || DN.charAt(i - 1) != '\\')) {
                            state = 5;
                            symbol = "";
                            continue;
                        }
                        value = value + ch;
                        continue;
                    }
                    if (state != 5) continue;
                    if (ch == ',' || ch == ';') {
                        state = 1;
                        continue;
                    }
                    if (ch == ' ' || ch == '\t') continue;
                    MQException traceRet3 = new MQException(2, 2399, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "checkPeerName(String)", traceRet3, 3);
                    }
                    throw traceRet3;
                }
                if (state == 2 || state == 1) {
                    MQException traceRet4 = new MQException(2, 2399, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "checkPeerName(String)", traceRet4, 4);
                    }
                    throw traceRet4;
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "checkPeerName(String)", e);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "checkPeerName(String)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLPeerNamePropertyValidator", "checkPeerName(String)", true, 2);
            }
            return true;
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(String keyIn, Object valueIn) {
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = this.toCanonicalNoTrim(keyIn, valueIn);
            return returnVal;
        }
    }

    static class WMQSSLFipsRequiredPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -3024451464357897333L;

        public WMQSSLFipsRequiredPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SSLFIPSREQUIRED");
            this.domainNames.put(new Integer(2), "SFIPS");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SSL_FIPS_REQUIRED");
            HashMap<String, Boolean> adminNames = new HashMap<String, Boolean>();
            adminNames.put("YES", Boolean.TRUE);
            adminNames.put("NO", Boolean.FALSE);
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Boolean)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (value != null && (((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("YES"))) {
                    value = new Boolean(true);
                } else if (value != null && (((String)value).equalsIgnoreCase("false") || ((String)value).equalsIgnoreCase("NO"))) {
                    value = new Boolean(false);
                }
            }
            if (value instanceof Boolean) {
                return true;
            }
            return value == null;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQSSLFipsRequiredPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getBooleanProperty("XMSC_WMQ_SSL_FIPS_REQUIRED") && ((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_CIPHER_SUITE") == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLFipsRequiredPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLFipsRequiredPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQSSLCipherSuitePropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = 8258565901457400654L;

        public WMQSSLCipherSuitePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SSLCIPHERSUITE");
            this.domainNames.put(new Integer(2), "SCPHS");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SSL_CIPHER_SUITE");
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQSSLCipherSuitePropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_CIPHER_SUITE") != null && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") != 1) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLCipherSuitePropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLCipherSuitePropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQSSLCertStoresStrPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -1183933341131104792L;

        public WMQSSLCertStoresStrPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SSLCRL");
            this.domainNames.put(new Integer(2), "SCRL");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SSL_CERT_STORES_STR");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            String stores = this.convertToString(value);
            if (stores != null) {
                StringTokenizer st = new StringTokenizer(stores);
                while (st.hasMoreTokens()) {
                    String currentHost = "";
                    String URI2 = st.nextToken();
                    if (!URI2.toUpperCase().startsWith("LDAP://")) {
                        HashMap<String, String> info = new HashMap<String, String>();
                        info.put("XMSC_INSERT_VALUE", URI2);
                        info.put("XMSC_INSERT_NAME", "CertStore URI protocol");
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                        throw je;
                    }
                    int portpos = URI2.indexOf(58, 7);
                    if (portpos != -1) {
                        try {
                            Integer.parseInt(URI2.substring(portpos + 1));
                            currentHost = URI2.substring(7, portpos);
                        }
                        catch (NumberFormatException nfe) {
                            HashMap<String, String> info = new HashMap<String, String>();
                            info.put("XMSC_INSERT_VALUE", URI2);
                            info.put("XMSC_INSERT_NAME", "CertStore URI port");
                            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                            throw je;
                        }
                    } else {
                        currentHost = URI2.substring(7);
                    }
                    if (currentHost.length() > 0) continue;
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", URI2);
                    info.put("XMSC_INSERT_NAME", "CertStore URI port");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
            }
            return true;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQSSLCertStoresStrPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_CERT_STORES_STR") != null && ((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_CIPHER_SUITE") == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLCertStoresStrPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLCertStoresStrPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQSSLCertStoresColPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -8934571746754688885L;

        public WMQSSLCertStoresColPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SSL_CERT_STORES_COL");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (value instanceof Collection) {
                return true;
            }
            return value == null;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQSSLCertStoresColPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_CERT_STORES_COL") != null && ((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_SSL_CIPHER_SUITE") == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLCertStoresColPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQSSLCertStoresColPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQSparseSubscriptionsPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 2863993679302251180L;

        public WMQSparseSubscriptionsPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SPARSESUBS");
            this.domainNames.put(new Integer(2), "SSUBS");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SPARSE_SUBSCRIPTIONS");
            HashMap<String, Boolean> adminNames = new HashMap<String, Boolean>();
            adminNames.put("YES", Boolean.TRUE);
            adminNames.put("NO", Boolean.FALSE);
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setSparseSubscriptions()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Boolean)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (value != null && (((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("YES"))) {
                    value = new Boolean(true);
                } else if (value != null && (((String)value).equalsIgnoreCase("false") || ((String)value).equalsIgnoreCase("NO"))) {
                    value = new Boolean(false);
                }
            }
            return value instanceof Boolean;
        }
    }

    static class WMQShareConvAllowedPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -2057880582374102891L;

        public WMQShareConvAllowedPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SHARECONVALLOWED");
            this.domainNames.put(new Integer(2), "SCALD");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SHARE_CONV_ALLOWED");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("YES", new Integer(1));
            adminNames.put("NO", new Integer(0));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int intval = (Integer)value;
            if (intval >= 0 && intval <= 1) return true;
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(intval));
            info.put("XMSC_INSERT_NAME", "shareConvAllowed");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQShareConvAllowedPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_SHARE_CONV_ALLOWED") != 1 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") != 1) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQShareConvAllowedPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQShareConvAllowedPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQSendExitInitPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = 5905014472636439912L;

        public WMQSendExitInitPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SENDEXITINIT");
            this.domainNames.put(new Integer(2), "SDXI");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SEND_EXIT_INIT");
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(String keyIn, Object valueIn) {
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = this.toCanonicalNoTrim(keyIn, valueIn);
            return returnVal;
        }
    }

    static class WMQSendExitPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = 1886796269033400462L;

        public WMQSendExitPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SENDEXIT");
            this.domainNames.put(new Integer(2), "SDX");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SEND_EXIT");
        }
    }

    static class WMQSendCheckCountPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 1458473553538049949L;

        public WMQSendCheckCountPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SENDCHECKCOUNT");
            this.domainNames.put(new Integer(2), "SCC");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SEND_CHECK_COUNT");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                int intval = (Integer)value;
                if (intval < 0) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(intval));
                    info.put("XMSC_INSERT_NAME", "sendCheckCount");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }
    }

    static class WMQSecurityExitInitPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = 5282141183069892571L;

        public WMQSecurityExitInitPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SECEXITINIT");
            this.domainNames.put(new Integer(2), "SCXI");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SECURITY_EXIT_INIT");
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(String keyIn, Object valueIn) {
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = this.toCanonicalNoTrim(keyIn, valueIn);
            return returnVal;
        }
    }

    static class WMQSecurityExitPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = 2590959585421048601L;

        public WMQSecurityExitPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "SECEXIT");
            this.domainNames.put(new Integer(2), "SCX");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_SECURITY_EXIT");
        }
    }

    static class WMQRescanIntervalPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = 6182528870830046926L;

        public WMQRescanIntervalPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "RESCANINT");
            this.domainNames.put(new Integer(2), "RINT");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_RESCAN_INTERVAL");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                int interval = (Integer)value;
                if (interval < 0) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(interval));
                    info.put("XMSC_INSERT_NAME", "rescanInterval");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }
    }

    static class WMQRcvIsolPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -5326028447026745256L;

        public WMQRcvIsolPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "RECEIVEISOLATION");
            this.domainNames.put(new Integer(2), "RCVISOL");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_RECEIVE_ISOLATION");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("COMMITTED", new Integer(0));
            adminNames.put("UNCOMMITTED", new Integer(1));
            adminNames.put("DEFAULT", new Integer(0));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int newVal = (Integer)value;
            switch (newVal) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            if (Trace.isOn) {
                Trace.traceData(this, "invalid parameter specified. Not setting", null);
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(newVal));
            info.put("XMSC_INSERT_NAME", "receiveIsolation");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQReceiveExitInitPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = 523959514006874514L;

        public WMQReceiveExitInitPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "RECEXITINIT");
            this.domainNames.put(new Integer(2), "RCXI");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_RECEIVE_EXIT_INIT");
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(String keyIn, Object valueIn) {
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = this.toCanonicalNoTrim(keyIn, valueIn);
            return returnVal;
        }
    }

    static class WMQReceiveExitPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = -4603255629202181269L;

        public WMQReceiveExitPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "RECEXIT");
            this.domainNames.put(new Integer(2), "RCX");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_RECEIVE_EXIT");
        }
    }

    static class WMQQueueManagerPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = 6046121161697048153L;

        public WMQQueueManagerPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "QMANAGER");
            this.domainNames.put(new Integer(2), "QMGR");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_QUEUE_MANAGER");
        }
    }

    static class WMQPubAckIntervalPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -7759281454969029483L;

        public WMQPubAckIntervalPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "PUBACKINT");
            this.domainNames.put(new Integer(2), "PAI");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_PUB_ACK_INTERVAL");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setPubAckInterval()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                int interval = (Integer)value;
                if (interval != -1 && interval < 0) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(interval));
                    info.put("XMSC_INSERT_NAME", "PubAckInterval");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }
    }

    static class WMQProviderVersionPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 3796689812129943870L;
        private static final Pattern providerVersionPattern = Pattern.compile("\\d+(\\.\\d+){0,3}|unspecified", 2);

        public WMQProviderVersionPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "PROVIDERVERSION");
            this.domainNames.put(new Integer(2), "PVER");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_PROVIDER_VERSION");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (value == null) {
                return false;
            }
            if (!providerVersionPattern.matcher((String)(value = this.convertToString(value))).matches()) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("XMSC_INSERT_VALUE", value);
                info.put("XMSC_INSERT_NAME", "ProviderVersion");
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                throw je;
            }
            if (!((String)value).equalsIgnoreCase("unspecified")) {
                String[] providerVerElements = ((String)value).split("\\.");
                if (providerVerElements.length == 0) {
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("XMSC_INSERT_VALUE", value);
                    info.put("XMSC_INSERT_NAME", "ProviderVersion");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                for (int i = 0; i < providerVerElements.length; ++i) {
                    try {
                        Integer.parseInt(providerVerElements[i]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        HashMap<String, Object> info = new HashMap<String, Object>();
                        info.put("XMSC_INSERT_VALUE", value);
                        info.put("XMSC_INSERT_NAME", "ProviderVersion");
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                        throw je;
                    }
                }
            }
            return true;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQProviderVersionPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (!((JmsPropertyContext)parent).getStringProperty("XMSC_WMQ_PROVIDER_VERSION").equals("unspecified") && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQProviderVersionPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQProviderVersionPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQProxyPortPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -3105241323784579916L;

        public WMQProxyPortPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "PROXYPORT");
            this.domainNames.put(new Integer(2), "PPORT");
            this.domainNames.put(new Integer(4), "XMSC_RTT_PROXY_PORT");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setProxyPort()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                int proxyPort = (Integer)value;
                if (proxyPort < 0) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(proxyPort));
                    info.put("XMSC_INSERT_NAME", "proxyPort");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQProxyPortPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("XMSC_RTT_PROXY_PORT") != 443 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQProxyPortPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQProxyPortPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQProxyHostnamePropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = -363121133060093907L;

        public WMQProxyHostnamePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "PROXYHOSTNAME");
            this.domainNames.put(new Integer(2), "PHOST");
            this.domainNames.put(new Integer(4), "XMSC_RTT_PROXY_HOSTNAME");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setProxyHostname()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            boolean traceRet1 = super.validate(value, parent);
            return traceRet1;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQProxyHostnamePropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getObjectProperty("XMSC_RTT_PROXY_HOSTNAME") != null && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQProxyHostnamePropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQProxyHostnamePropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQProcessDurationPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -4268937941756073078L;

        public WMQProcessDurationPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "PROCESSDURATION");
            this.domainNames.put(new Integer(2), "PROCDUR");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_PROCESS_DURATION");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("UNKNOWN", new Integer(0));
            adminNames.put("SHORT", new Integer(1));
            adminNames.put("DEFAULT", new Integer(0));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int newVal = (Integer)value;
            switch (newVal) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            if (Trace.isOn) {
                Trace.traceData(this, "invalid parameter specified. Not setting", null);
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(newVal));
            info.put("XMSC_INSERT_NAME", "processDuration");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQPortPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 2960491545923009779L;

        public WMQValidationInterface.WMQPropertyValidatorDatatype fromCanonical(JmsPropertyContext context, String keyIn, Object valueIn) {
            String connectionNameList = "";
            try {
                connectionNameList = context.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST");
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            int startPort = connectionNameList.indexOf(40);
            int endPort = connectionNameList.indexOf(41);
            String port = connectionNameList.substring(startPort + 1, endPort);
            return super.fromCanonical(context, keyIn, port);
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(JmsPropertyContext context, String keyIn, Object valueIn) {
            ArrayList connectionNameList = null;
            try {
                connectionNameList = (ArrayList)context.getObjectProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT");
                if (connectionNameList == null) {
                    connectionNameList = new WMQConnectionNameList();
                    connectionNameList.add(new WMQConnectionName("localhost", 1414));
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            WMQConnectionName wcn = (WMQConnectionName)connectionNameList.get(0);
            if (valueIn instanceof String) {
                wcn.setPort(Integer.parseInt((String)valueIn));
            } else if (valueIn instanceof Integer) {
                wcn.setPort((Integer)valueIn);
            }
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = new WMQValidationInterface.WMQPropertyValidatorDatatype("XMSC_WMQ_CONNECTION_NAME_LIST_INT", connectionNameList);
            return returnVal;
        }

        public WMQPortPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "PORT");
            this.domainNames.put(new Integer(2), "PORT");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_PORT");
        }

        /*
         * WARNING - void declaration
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof Integer || value instanceof String) {
                void var3_3;
                int port;
                if (value instanceof Integer) {
                    port = (Integer)value;
                } else {
                    try {
                        port = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                if (var3_3 < 0) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf((int)var3_3));
                    info.put("XMSC_INSERT_NAME", "port");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                this.updatePortFlag(parent);
                return true;
            }
            return false;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQPortPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_PORT") != 1414 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_PORT") != 1506 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQPortPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQPortPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }

        private void updatePortFlag(Object parent) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQPortPropertyValidator", "updatePortFlag(final Object)", new Object[]{parent});
            }
            if (parent instanceof MQConnectionFactory) {
                AccessController.doPrivileged(new PrivilegedAction(this, parent){
                    private final /* synthetic */ Object val$parent;
                    private final /* synthetic */ WMQPortPropertyValidator this$0;
                    {
                        this.this$0 = this$0;
                        this.val$parent = val$parent;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public Object run() {
                        block15: {
                            if (Trace.isOn) {
                                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQPortPropertyValidator", "run()");
                            }
                            try {
                                try {
                                    Field portSetField = (class$com$ibm$mq$jms$MQConnectionFactory == null ? (class$com$ibm$mq$jms$MQConnectionFactory = WMQConnectionFactory.class$("com.ibm.mq.jms.MQConnectionFactory")) : class$com$ibm$mq$jms$MQConnectionFactory).getDeclaredField("portSet");
                                    portSetField.setAccessible(true);
                                    portSetField.setBoolean(this.val$parent, true);
                                }
                                catch (NoSuchFieldException nsfe) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()", nsfe, 1);
                                    }
                                    Object var3_5 = null;
                                    if (Trace.isOn) {
                                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                                    }
                                    if (Trace.isOn) {
                                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                                    }
                                    return null;
                                }
                                catch (IllegalAccessException iae) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()", iae, 2);
                                    }
                                    Object var3_6 = null;
                                    if (Trace.isOn) {
                                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                                    }
                                    if (Trace.isOn) {
                                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                                    }
                                    return null;
                                }
                                Object var3_4 = null;
                                if (!Trace.isOn) break block15;
                            }
                            catch (Throwable throwable) {
                                Object var3_7 = null;
                                if (Trace.isOn) {
                                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                                }
                                if (Trace.isOn) {
                                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                                }
                                return null;
                            }
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                        }
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                        }
                        return null;
                    }
                });
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQPortPropertyValidator", "updatePortFlag(final Object)");
            }
        }
    }

    static class WMQOutNotifyPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 6973164587041708965L;

        public WMQOutNotifyPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "OUTCOMENOTIFICATION");
            this.domainNames.put(new Integer(2), "NOTIFY");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_OUTCOME_NOTIFICATION");
            HashMap<String, Boolean> adminNames = new HashMap<String, Boolean>();
            adminNames.put("YES", Boolean.TRUE);
            adminNames.put("NO", Boolean.FALSE);
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Boolean)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (value != null && (((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("yes"))) {
                    value = new Boolean(true);
                } else if (value != null && (((String)value).equalsIgnoreCase("false") || ((String)value).equalsIgnoreCase("no"))) {
                    value = new Boolean(false);
                }
            }
            return value instanceof Boolean;
        }
    }

    static class WMQOptPubPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 7690158133313647691L;

        public WMQOptPubPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "OPTIMISTICPUBLICATION");
            this.domainNames.put(new Integer(2), "OPTPUB");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_OPT_PUB");
            HashMap<String, Boolean> adminNames = new HashMap<String, Boolean>();
            adminNames.put("YES", Boolean.TRUE);
            adminNames.put("NO", Boolean.FALSE);
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Boolean)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (value != null && (((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("yes"))) {
                    value = new Boolean(true);
                } else if (value != null && (((String)value).equalsIgnoreCase("false") || ((String)value).equalsIgnoreCase("no"))) {
                    value = new Boolean(false);
                }
            }
            return value instanceof Boolean;
        }
    }

    static class WMQMulticastPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 4172926495250839774L;

        public WMQMulticastPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "MULTICAST");
            this.domainNames.put(new Integer(2), "MCAST");
            this.domainNames.put(new Integer(4), "multicast");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("DISABLED", new Integer(0));
            adminNames.put("ASCF", new Integer(-1));
            adminNames.put("ENABLED", new Integer(7));
            adminNames.put("RELIABLE", new Integer(5));
            adminNames.put("NOTR", new Integer(3));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setMulticast()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int multicast = (Integer)value;
            if (multicast == 0 || multicast == 3 || multicast == 5 || multicast == 7) return true;
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(multicast));
            info.put("XMSC_INSERT_NAME", "multicast");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQMulticastPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("multicast") != 0 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") != 2) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQMulticastPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQMulticastPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQPollingIntervalPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -1218143777857680293L;

        public WMQPollingIntervalPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "POLLINGINT");
            this.domainNames.put(new Integer(2), "PINT");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_POLLING_INTERVAL");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                int interval = (Integer)value;
                if (interval < 0) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(interval));
                    info.put("XMSC_INSERT_NAME", "pollingInterval");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }
    }

    static class WMQMsgCompPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 2828456160225827315L;

        public WMQMsgCompPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "COMPMSG");
            this.domainNames.put(new Integer(2), "MC");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_MSG_COMP");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (value instanceof String && value != null) {
                StringTokenizer st = new StringTokenizer((String)((Object)value));
                Vector<Integer> c = new Vector<Integer>();
                while (st.hasMoreTokens()) {
                    String tk = st.nextToken();
                    if (tk.equals("NONE")) {
                        c.add(new Integer(0));
                        continue;
                    }
                    if (tk.equals("RLE")) {
                        c.add(new Integer(1));
                        continue;
                    }
                    if (tk.equals("ZLIBFAST")) {
                        c.add(new Integer(2));
                        continue;
                    }
                    if (tk.equals("ZLIBHIGH")) {
                        c.add(new Integer(4));
                        continue;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Compressor value is not supported", null);
                    }
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(tk));
                    info.put("XMSC_INSERT_NAME", "Compressor");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                value = c;
            }
            if (value instanceof Collection) {
                Collection compList = value;
                if (compList == null || compList.size() == 0) {
                    return true;
                }
                Integer compressor = new Integer(0);
                Iterator it = compList.iterator();
                while (it.hasNext()) {
                    try {
                        compressor = (Integer)it.next();
                    }
                    catch (ClassCastException cce) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Compressor of unacceptable type", null);
                        }
                        HashMap<String, String> info = new HashMap<String, String>();
                        info.put("XMSC_INSERT_VALUE", cce.getMessage());
                        info.put("XMSC_INSERT_NAME", "Compressor value");
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                        je.setLinkedException((Exception)cce);
                        throw je;
                    }
                    if (compressor == null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "null compressor", null);
                        }
                        HashMap<String, String> info = new HashMap<String, String>();
                        info.put("XMSC_INSERT_VALUE", "null");
                        info.put("XMSC_INSERT_NAME", "Compressor");
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                        throw je;
                    }
                    int comp = compressor;
                    if (comp == 0 || comp == 1 || comp == 2 || comp == 4) continue;
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", compressor.toString());
                    info.put("XMSC_INSERT_NAME", "Compressor");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }
    }

    static class WMQMsgBatchSizePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 3698963451138408718L;

        public WMQMsgBatchSizePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "MSGBATCHSZ");
            this.domainNames.put(new Integer(2), "MBS");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_MSG_BATCH_SIZE");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                int size = (Integer)value;
                if (size < 0) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(size));
                    info.put("XMSC_INSERT_NAME", "MsgBatchSize");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }
    }

    static class WMQConnectionOptionsPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 397751746931416967L;

        public WMQConnectionOptionsPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "CONNOPT");
            this.domainNames.put(new Integer(2), "CNOPT");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CONNECT_OPTIONS");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("STANDARD", new Integer(0));
            adminNames.put("SHARED", new Integer(256));
            adminNames.put("ISOLATED", new Integer(512));
            adminNames.put("FASTPATH", new Integer(1));
            adminNames.put("SERIALQM", new Integer(2));
            adminNames.put("SERIALQSG", new Integer(4));
            adminNames.put("RESTRICTQM", new Integer(8));
            adminNames.put("RESTRICTQSG", new Integer(16));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            void var3_3;
            int cTagOpt;
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (!(value instanceof Integer) && !(value instanceof String)) return false;
            if (value instanceof Integer) {
                cTagOpt = (Integer)value;
            } else if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                if (!adminNames.containsKey(value)) return false;
                cTagOpt = (Integer)adminNames.get(value);
            } else {
                try {
                    cTagOpt = Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            int count = 0;
            if ((var3_3 & 8) != 0) {
                ++count;
            }
            if ((var3_3 & 0x10) != 0) {
                ++count;
            }
            if ((var3_3 & 2) != 0) {
                ++count;
            }
            if ((var3_3 & 4) != 0) {
                ++count;
            }
            if (count > 1) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("XMSC_INSERT_VALUE", String.valueOf((int)var3_3));
                info.put("XMSC_INSERT_NAME", "ProviderConnection options");
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                throw je;
            }
            count = 0;
            if ((var3_3 & 1) != 0) {
                ++count;
            }
            if ((var3_3 & 0x200) != 0) {
                ++count;
            }
            if ((var3_3 & 0x100) != 0) {
                ++count;
            }
            if (count > 1) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("XMSC_INSERT_VALUE", String.valueOf((int)var3_3));
                info.put("XMSC_INSERT_NAME", "ProviderConnection options");
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                throw je;
            }
            if (((MQConnectionFactory)parent).getTransportType() == 1 && ((var3_3 & 8) != 0 || (var3_3 & 0x10) != 0)) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("XMSC_INSERT_VALUE", String.valueOf((int)var3_3));
                info.put("XMSC_INSERT_NAME", "Invalid connection options when in client mode");
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                throw je;
            }
            count = var3_3;
            if ((count &= 0xFFFFFCE0) <= 0) return true;
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf((int)var3_3));
            info.put("XMSC_INSERT_NAME", "ProviderConnection options");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQMessageSelectionPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -3081005187089113998L;

        public WMQMessageSelectionPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "MSGSELECTION");
            this.domainNames.put(new Integer(2), "MSEL");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_MESSAGE_SELECTION");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("CLIENT", new Integer(0));
            adminNames.put("BROKER", new Integer(1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setMessageSelection()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int selection = (Integer)value;
            switch (selection) {
                case 0: 
                case 1: {
                    this.updateMessageSelectionFlag(parent);
                    return true;
                }
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(selection));
            info.put("XMSC_INSERT_NAME", "messageSelection");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }

        private void updateMessageSelectionFlag(Object parent) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQMessageSelectionPropertyValidator", "updateMessageSelectionFlag(final Object)", new Object[]{parent});
            }
            if (parent instanceof MQConnectionFactory) {
                AccessController.doPrivileged(new PrivilegedAction(this, parent){
                    private final /* synthetic */ Object val$parent;
                    private final /* synthetic */ WMQMessageSelectionPropertyValidator this$0;
                    {
                        this.this$0 = this$0;
                        this.val$parent = val$parent;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public Object run() {
                        block15: {
                            if (Trace.isOn) {
                                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQMessageSelectionPropertyValidator", "run()");
                            }
                            try {
                                try {
                                    Field mselSetField = (class$com$ibm$mq$jms$MQConnectionFactory == null ? (class$com$ibm$mq$jms$MQConnectionFactory = WMQConnectionFactory.class$("com.ibm.mq.jms.MQConnectionFactory")) : class$com$ibm$mq$jms$MQConnectionFactory).getDeclaredField("mselSet");
                                    mselSetField.setAccessible(true);
                                    mselSetField.setBoolean(this.val$parent, true);
                                }
                                catch (NoSuchFieldException nsfe) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()", nsfe, 1);
                                    }
                                    Object var3_5 = null;
                                    if (Trace.isOn) {
                                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                                    }
                                    if (Trace.isOn) {
                                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                                    }
                                    return null;
                                }
                                catch (IllegalAccessException iae) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()", iae, 2);
                                    }
                                    Object var3_6 = null;
                                    if (Trace.isOn) {
                                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                                    }
                                    if (Trace.isOn) {
                                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                                    }
                                    return null;
                                }
                                Object var3_4 = null;
                                if (!Trace.isOn) break block15;
                            }
                            catch (Throwable throwable) {
                                Object var3_7 = null;
                                if (Trace.isOn) {
                                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                                }
                                if (Trace.isOn) {
                                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                                }
                                return null;
                            }
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                        }
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                        }
                        return null;
                    }
                });
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQMessageSelectionPropertyValidator", "updateMessageSelectionFlag(final Object)");
            }
        }
    }

    static class WMQMessageRetentionPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 6760842274009487000L;

        public WMQMessageRetentionPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "MSGRETENTION");
            this.domainNames.put(new Integer(2), "MRET");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_MESSAGE_RETENTION");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("YES", new Integer(1));
            adminNames.put("NO", new Integer(0));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQTopicConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setMessageRetention()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int mRet = (Integer)value;
            if (mRet == 1 || mRet == 0) {
                return true;
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(mRet));
            info.put("XMSC_INSERT_NAME", "messageRetention");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQMaxBufferSizePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -491142338544404051L;

        public WMQMaxBufferSizePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "MAXBUFFSIZE");
            this.domainNames.put(new Integer(2), "MBSZ");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_MAX_BUFFER_SIZE");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setMaxBufferSize()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                int size = (Integer)value;
                if (size < 0) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(size));
                    info.put("XMSC_INSERT_NAME", "maxBufferSize");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }
    }

    static class WMQMapmsgNameStylePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 8800568865487888303L;

        public WMQMapmsgNameStylePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_WMQ_MAP_NAME_STYLE");
            this.domainNames.put(new Integer(1), "MAPNAMESTYLE");
            this.domainNames.put(new Integer(2), "MNST");
            HashMap<String, Boolean> adminNames = new HashMap<String, Boolean>();
            adminNames.put("STANDARD", Boolean.TRUE);
            adminNames.put("COMPATIBLE", Boolean.FALSE);
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Boolean)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (value != null && (((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("standard"))) {
                    value = new Boolean(true);
                } else if (value != null && (((String)value).equalsIgnoreCase("false") || ((String)value).equalsIgnoreCase("compatible"))) {
                    value = new Boolean(false);
                }
            }
            return value instanceof Boolean;
        }
    }

    static class WMQLocalAddressPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 4607207777088043690L;

        public WMQLocalAddressPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "LOCALADDRESS");
            this.domainNames.put(new Integer(2), "LA");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_LOCAL_ADDRESS");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (value == null) {
                value = "";
            }
            String address = this.convertToString(value);
            if ((address = address.trim()).length() > 48) {
                return false;
            }
            if (address.equals("")) {
                return true;
            }
            String ipAddr = null;
            String lowPort = null;
            String highPort = null;
            int openBracketIndex = address.indexOf("(");
            int closeBracketIndex = address.indexOf(")");
            int commaIndex = address.indexOf(",");
            if (openBracketIndex != -1 && closeBracketIndex == -1) {
                return false;
            }
            if (openBracketIndex == -1 && closeBracketIndex != -1) {
                return false;
            }
            if (commaIndex != -1 && openBracketIndex == -1) {
                return false;
            }
            if (openBracketIndex == -1) {
                ipAddr = address;
                return true;
            }
            if (commaIndex == -1) {
                lowPort = address.substring(openBracketIndex + 1, closeBracketIndex);
            } else {
                lowPort = address.substring(openBracketIndex + 1, commaIndex);
                highPort = address.substring(commaIndex + 1, closeBracketIndex);
            }
            int lowPortInt = 0;
            int highPortInt = 0;
            if (lowPort != null) {
                try {
                    lowPortInt = Integer.parseInt(lowPort);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (highPort != null) {
                try {
                    highPortInt = Integer.parseInt(highPort);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (lowPortInt < 0 || highPortInt < 0) {
                return false;
            }
            if (lowPortInt > 65535 || highPortInt > 65535) {
                return false;
            }
            return highPort == null || lowPortInt <= highPortInt;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQLocalAddressPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (!((JmsPropertyContext)parent).getStringProperty("XMSC_WMQ_LOCAL_ADDRESS").equals("") && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQLocalAddressPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQLocalAddressPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQHostnamePropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = -4078396467130249926L;

        public WMQValidationInterface.WMQPropertyValidatorDatatype fromCanonical(String keyIn, Object valueIn) {
            return super.fromCanonical(keyIn, valueIn);
        }

        public WMQHostnamePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "HOSTNAME");
            this.domainNames.put(new Integer(2), "HOST");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_HOST_NAME");
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype fromCanonical(JmsPropertyContext context, String keyIn, Object valueIn) {
            String connectionNameList = "";
            try {
                connectionNameList = context.getStringProperty("XMSC_WMQ_CONNECTION_NAME_LIST");
            }
            catch (JMSException e) {
                // empty catch block
            }
            int endHost = connectionNameList.indexOf(40);
            String hostName = connectionNameList.substring(0, endHost);
            return super.fromCanonical(context, keyIn, hostName);
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(JmsPropertyContext context, String keyIn, Object valueIn) {
            if (valueIn instanceof String) {
                valueIn = ((String)valueIn).trim();
            }
            ArrayList connectionNameList = null;
            try {
                connectionNameList = (ArrayList)context.getObjectProperty("XMSC_WMQ_CONNECTION_NAME_LIST_INT");
                if (connectionNameList == null) {
                    connectionNameList = new WMQConnectionNameList();
                    connectionNameList.add(new WMQConnectionName("localhost", 1414));
                }
            }
            catch (JMSException e) {
                // empty catch block
            }
            WMQConnectionName wcn = (WMQConnectionName)connectionNameList.get(0);
            wcn.setHostname((String)valueIn);
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = new WMQValidationInterface.WMQPropertyValidatorDatatype("XMSC_WMQ_CONNECTION_NAME_LIST_INT", connectionNameList);
            return returnVal;
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(String keyIn, Object valueIn) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQHostnamePropertyValidator", "toCanonical(String,Object)", new Object[]{keyIn, valueIn});
            }
            if (valueIn instanceof String) {
                valueIn = ((String)valueIn).trim();
            }
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = super.toCanonical(keyIn, valueIn);
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.factories.WMQHostnamePropertyValidator", "toCanonical(String keyIn, Object valueIn)");
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQHostnamePropertyValidator", "toCanonical(String,Object)", returnVal);
            }
            return returnVal;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQHostnamePropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (!((JmsPropertyContext)parent).getStringProperty("XMSC_WMQ_HOST_NAME").equals("localhost") && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQHostnamePropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQHostnamePropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQHeaderCompPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -7472872025334039252L;

        public WMQHeaderCompPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "COMPHDR");
            this.domainNames.put(new Integer(2), "HC");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_HEADER_COMP");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (value instanceof String && value != null) {
                StringTokenizer st = new StringTokenizer((String)((Object)value));
                Vector<Object> c = new Vector<Object>();
                while (st.hasMoreTokens()) {
                    String tk = st.nextToken();
                    if (tk.equals("NONE")) {
                        c.add(new Integer(0));
                        continue;
                    }
                    if (tk.equals("SYSTEM")) {
                        c.add(new Integer(8));
                        continue;
                    }
                    c.add(tk);
                }
                value = c;
            }
            if (value instanceof Collection) {
                if (value == null || ((Collection)value).size() == 0) {
                    return true;
                }
                Integer compressor = new Integer(0);
                Iterator it = ((Collection)value).iterator();
                while (it.hasNext()) {
                    try {
                        compressor = (Integer)it.next();
                    }
                    catch (ClassCastException cce) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Compression technique of unacceptable type", null);
                        }
                        HashMap<String, String> info = new HashMap<String, String>();
                        info.put("XMSC_INSERT_VALUE", cce.getMessage());
                        info.put("XMSC_INSERT_NAME", "Compression technique of unacceptable type");
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                        je.setLinkedException((Exception)cce);
                        throw je;
                    }
                    if (compressor == null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "null compressor", null);
                        }
                        HashMap<String, String> info = new HashMap<String, String>();
                        info.put("XMSC_INSERT_VALUE", "null");
                        info.put("XMSC_INSERT_NAME", "Compression technique");
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                        throw je;
                    }
                    int comp = compressor;
                    if (comp == 0 || comp == 8) continue;
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", compressor.toString());
                    info.put("XMSC_INSERT_NAME", "Compression technique");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQHeaderCompPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getObjectProperty("XMSC_WMQ_HEADER_COMP") != null && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") != 1) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQHeaderCompPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQHeaderCompPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQFailIfQuiescePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 3434462552598026495L;

        public WMQFailIfQuiescePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "FAILIFQUIESCE");
            this.domainNames.put(new Integer(2), "FIQ");
            this.domainNames.put(new Integer(4), "failIfQuiesce");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("YES", new Integer(1));
            adminNames.put("NO", new Integer(0));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int fiq = (Integer)value;
            switch (fiq) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(fiq));
            info.put("XMSC_INSERT_NAME", "failIfQuiesce");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQDirectAuthPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 5316616203824367137L;

        public WMQDirectAuthPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "DIRECTAUTH");
            this.domainNames.put(new Integer(2), "DAUTH");
            this.domainNames.put(new Integer(4), "XMSC_RTT_DIRECT_AUTH");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("BASIC", new Integer(0));
            adminNames.put("CERTIFICATE", new Integer(1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setDirectAuth()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int authority = (Integer)value;
            if (authority == 0 || authority == 1) return true;
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(authority));
            info.put("XMSC_INSERT_NAME", "directAuth");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQDirectAuthPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("XMSC_RTT_DIRECT_AUTH") != 0 && (((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") != 4 || ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") != 2)) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQDirectAuthPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQDirectAuthPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQCFDescriptionPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = 6986879728345123980L;

        public WMQCFDescriptionPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "DESCRIPTION");
            this.domainNames.put(new Integer(2), "DESC");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CF_DESCRIPTION");
        }
    }

    static class WMQConnTagPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -593486815816249250L;

        public WMQConnTagPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "CONNTAG");
            this.domainNames.put(new Integer(2), "CNTAG");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CONNECTION_TAG");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            return value instanceof byte[];
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(String keyIn, Object valueIn) {
            byte[] valueOut;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQConnTagPropertyValidator", "toCanonical(String,Object)", new Object[]{keyIn, valueIn});
            }
            String keyOut = (String)this.domainNames.get(new Integer(4));
            byte[] val = (byte[])valueIn;
            int valLen = val.length;
            if (valLen == 128) {
                valueOut = (byte[])valueIn;
            } else if (valLen < 128) {
                valueOut = new byte[128];
                System.arraycopy(val, 0, valueOut, 0, valLen);
                System.arraycopy(CMQC.MQCT_NONE, 0, valueOut, valLen, 128 - valLen);
            } else {
                valueOut = new byte[128];
                System.arraycopy(val, 0, valueOut, 0, 128);
            }
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = new WMQValidationInterface.WMQPropertyValidatorDatatype(keyOut, valueOut);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.WMQConnTagPropertyValidator", "toCanonical(String,Object)", returnVal);
            }
            return returnVal;
        }
    }

    static class WMQCloneSupportPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -5026438323249820121L;

        public WMQCloneSupportPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "CLONESUPP");
            this.domainNames.put(new Integer(2), "CLS");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CLONE_SUPPORT");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("DISABLED", new Integer(0));
            adminNames.put("ENABLED", new Integer(1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setCloneSupport()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int type = (Integer)value;
            switch (type) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(type));
            info.put("XMSC_INSERT_NAME", "cloneSupport");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQClientIDPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = -8932880273620654596L;

        public WMQClientIDPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "CLIENTID");
            this.domainNames.put(new Integer(2), "CID");
            this.domainNames.put(new Integer(4), "XMSC_CLIENT_ID");
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQClientIDPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getObjectProperty("XMSC_CLIENT_ID") != null && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") != 1) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQClientIDPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQClientIDPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQCleanupLevelPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 6482851624338428343L;

        public WMQCleanupLevelPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "CLEANUP");
            this.domainNames.put(new Integer(2), "CL");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CLEANUP_LEVEL");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("SAFE", new Integer(1));
            adminNames.put("ASPROP", new Integer(-1));
            adminNames.put("NONE", new Integer(0));
            adminNames.put("STRONG", new Integer(2));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setCleanupLevel()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = (Integer)adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int level = (Integer)value;
            switch (level) {
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(level));
            info.put("XMSC_INSERT_NAME", "cleanupLevel");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }
    }

    static class WMQCleanupIntervalPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 2300294526348491914L;

        public WMQCleanupIntervalPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "CLEANUPINT");
            this.domainNames.put(new Integer(2), "CLINT");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CLEANUP_INTERVAL");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setCleanupInterval()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer || value instanceof Long)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Long((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                try {
                    value = new Long(((Integer)value).longValue());
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Long) {
                long interval = (Long)value;
                if (interval < 0L) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(interval));
                    info.put("XMSC_INSERT_NAME", "cleanupInterval");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQCleanupIntervalPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CLEANUP_INTERVAL") != 3600000 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CLEANUP_LEVEL") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQCleanupIntervalPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQCleanupIntervalPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQChannelPropertyValidator
    extends WMQStandardValidators.WMQChannelNamePropertyValidator {
        private static final long serialVersionUID = -7961979588050326660L;

        public WMQChannelPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "CHANNEL");
            this.domainNames.put(new Integer(2), "CHAN");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CHANNEL");
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQChannelPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (!((JmsPropertyContext)parent).getStringProperty("XMSC_WMQ_CHANNEL").equals("SYSTEM.DEF.SVRCONN")) {
                if (((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") != 0 && ((JmsPropertyContext)parent).getStringProperty("XMSC_WMQ_CCDTURL") == null) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQChannelPropertyValidator", "crossPropertyValidate(Object)", true, 1);
                    }
                    return true;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQChannelPropertyValidator", "crossPropertyValidate(Object)", false, 2);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQChannelPropertyValidator", "crossPropertyValidate(Object)", true, 3);
            }
            return true;
        }
    }

    static class WMQCCDTURLPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -4370671351805889291L;

        public WMQCCDTURLPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "CCDTURL");
            this.domainNames.put(new Integer(2), "CCDT");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_CCDTURL");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (value == null) {
                return true;
            }
            value = this.convertToString(value);
            try {
                new URL((String)value);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQCCDTURLPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getStringProperty("XMSC_WMQ_CCDTURL") != null) {
                if (((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") != 0 && "SYSTEM.DEF.SVRCONN".equals(((JmsPropertyContext)parent).getStringProperty("XMSC_WMQ_CHANNEL"))) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQCCDTURLPropertyValidator", "crossPropertyValidate(Object)", true, 1);
                    }
                    return true;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQCCDTURLPropertyValidator", "crossPropertyValidate(Object)", false, 2);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQCCDTURLPropertyValidator", "crossPropertyValidate(Object)", true, 3);
            }
            return true;
        }
    }

    static class WMQQMgrCCSIDPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -4143839812665823110L;

        public WMQQMgrCCSIDPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "CCSID");
            this.domainNames.put(new Integer(2), "CCS");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_QMGR_CCSID");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if ((value = this.convertToString(value)) instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (value instanceof Integer) {
                int ccsid = (Integer)value;
                if (ccsid < 0) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(ccsid));
                    info.put("XMSC_INSERT_NAME", "CCSID");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                return true;
            }
            return false;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQQMgrCCSIDPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_QMGR_CCSID") != 819 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQQMgrCCSIDPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQQMgrCCSIDPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQBrokerVersionPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 2993529085855398328L;

        public WMQBrokerVersionPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERVER");
            this.domainNames.put(new Integer(2), "BVER");
            this.domainNames.put(new Integer(4), "brokerVersion");
            HashMap<String, Integer> adminNames = new HashMap<String, Integer>();
            adminNames.put("V1", new Integer(0));
            adminNames.put("V2", new Integer(1));
            adminNames.put("UNSPECIFIED", new Integer(-1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setBrokerVersion()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                    HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                    if (!adminNames.containsKey(value)) return false;
                    value = adminNames.get(value);
                } else {
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            if (!(value instanceof Integer)) return false;
            int version = (Integer)value;
            if (version == -1) {
                this.updateBrokerVersionFlag(parent);
                return true;
            }
            if (version == 0) {
                int t = ((MQConnectionFactory)parent).getTransportType();
                if (t == 4 || t == 2) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("XMSC_INSERT_VALUE", String.valueOf(version));
                    info.put("XMSC_INSERT_NAME", "brokerVersion");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
                    throw je;
                }
                this.updateBrokerVersionFlag(parent);
                return true;
            }
            if (version == 1) {
                this.updateBrokerVersionFlag(parent);
                return true;
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("XMSC_INSERT_VALUE", String.valueOf(version));
            info.put("XMSC_INSERT_NAME", "brokerVersion");
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSFMQ1006", info));
            throw je;
        }

        private void updateBrokerVersionFlag(Object parent) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQBrokerVersionPropertyValidator", "updateBrokerVersionFlag(final Object)", new Object[]{parent});
            }
            if (parent instanceof MQConnectionFactory) {
                AccessController.doPrivileged(new PrivilegedAction(this, parent){
                    private final /* synthetic */ Object val$parent;
                    private final /* synthetic */ WMQBrokerVersionPropertyValidator this$0;
                    {
                        this.this$0 = this$0;
                        this.val$parent = val$parent;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public Object run() {
                        block15: {
                            if (Trace.isOn) {
                                Trace.entry(this, "com.ibm.msg.client.wmq.factories.WMQBrokerVersionPropertyValidator", "run()");
                            }
                            try {
                                try {
                                    Field bverSetField = (class$com$ibm$mq$jms$MQConnectionFactory == null ? (class$com$ibm$mq$jms$MQConnectionFactory = WMQConnectionFactory.class$("com.ibm.mq.jms.MQConnectionFactory")) : class$com$ibm$mq$jms$MQConnectionFactory).getDeclaredField("bverSet");
                                    bverSetField.setAccessible(true);
                                    bverSetField.setBoolean(this.val$parent, true);
                                }
                                catch (NoSuchFieldException nsfe) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()", nsfe, 1);
                                    }
                                    Object var3_5 = null;
                                    if (Trace.isOn) {
                                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                                    }
                                    if (Trace.isOn) {
                                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                                    }
                                    return null;
                                }
                                catch (IllegalAccessException iae) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()", iae, 2);
                                    }
                                    Object var3_6 = null;
                                    if (Trace.isOn) {
                                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                                    }
                                    if (Trace.isOn) {
                                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                                    }
                                    return null;
                                }
                                Object var3_4 = null;
                                if (!Trace.isOn) break block15;
                            }
                            catch (Throwable throwable) {
                                Object var3_7 = null;
                                if (Trace.isOn) {
                                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                                }
                                if (Trace.isOn) {
                                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                                }
                                return null;
                            }
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.factories.null", "run()");
                        }
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.msg.client.wmq.factories.null", "run()", null);
                        }
                        return null;
                    }
                });
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.factories.WMQBrokerVersionPropertyValidator", "updateBrokerVersionFlag(final Object)");
            }
        }
    }

    static class WMQBrokerSubQPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = 5366967103691046747L;

        public WMQBrokerSubQPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERSUBQ");
            this.domainNames.put(new Integer(2), "BSUB");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_BROKER_SUBQ");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setBrokerSubQ()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            String queueName = this.convertToString(value);
            return queueName != null && queueName.length() <= 48 && (queueName.startsWith("SYSTEM.JMS.ND.") || queueName.equals(""));
        }
    }

    static class WMQBrokerQMgrPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = -412165032155030940L;

        public WMQBrokerQMgrPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERQMGR");
            this.domainNames.put(new Integer(2), "BQM");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_BROKER_QMGR");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setBrokerQMgr()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            boolean traceRet1 = super.validate(value, parent);
            return traceRet1;
        }
    }

    static class WMQBrokerPubQPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = 595921449503109875L;

        public WMQBrokerPubQPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERPUBQ");
            this.domainNames.put(new Integer(2), "BPUB");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_BROKER_PUBQ");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setBrokerPubQ()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            boolean traceRet1 = super.validate(value, parent);
            return traceRet1;
        }
    }

    static class WMQBrokerControlQPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = 7226072931501351962L;

        public WMQBrokerControlQPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERCONQ");
            this.domainNames.put(new Integer(2), "BCON");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_BROKER_CONTROLQ");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setBrokerControlQ()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            boolean traceRet1 = super.validate(value, parent);
            return traceRet1;
        }
    }

    static class WMQBrokerCCSubQPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = -6998439326748223037L;

        public WMQBrokerCCSubQPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERCCSUBQ");
            this.domainNames.put(new Integer(2), "CCSUB");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_BROKER_CC_SUBQ");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (parent instanceof MQQueueConnectionFactory) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "setBrokerCCSubQ()");
                inserts.put("XMSC_INSERT_TYPE", parent.getClass().getName());
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSMQ1112", inserts));
                throw je;
            }
            String queueName = this.convertToString(value);
            return queueName != null && queueName.length() <= 48 && (queueName.startsWith("SYSTEM.JMS.ND.") || queueName.equals(""));
        }
    }

    static class WMQAdminObjectPropertyValidator
    extends WMQStandardValidators.WMQTrivialPropertyValidator {
        private static final long serialVersionUID = 7919748242803675773L;

        public WMQAdminObjectPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_ADMIN_OBJECT_TYPE");
        }
    }
}

