/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.factories;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiFactory;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.JmqiPropertyHandler;
import com.ibm.mq.jmqi.JmqiThreadPoolFactory;
import com.ibm.mq.jmqi.JmqiTraceHandlerAdapter;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.system.JmqiMetaData;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.msg.client.commonservices.componentmanager.Component;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyHandler;
import com.ibm.msg.client.wmq.common.internal.WMQThreadPoolFactory;
import com.ibm.msg.client.wmq.common.internal.WMQTraceHandler;
import com.ibm.msg.client.wmq.factories.WMQFactoryFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class WMQComponent
extends Component {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/factories/WMQComponent.java, jmscc.wmq, k701, k701-112-140304 1.16.1.2 09/09/01 10:28:50";

    public WMQComponent() {
        this.name = "com.ibm.msg.client.wmq";
        this.title = "IBM WebSphere MQ";
        this.type = "MPI";
        URL resource = this.getClass().getResource("version.properties");
        if (resource == null) {
            resource = ClassLoader.getSystemResource("META-INF/version.properties");
        }
        if (resource != null) {
            Properties props = new Properties();
            try {
                String CMVCLevel;
                props.load(resource.openStream());
                String stringVersion = props.getProperty(this.name);
                if (stringVersion != null) {
                    this.version = new int[4];
                    StringTokenizer token = new StringTokenizer(stringVersion);
                    int i = 0;
                    while (token.hasMoreElements()) {
                        int value;
                        String t = token.nextToken(".");
                        this.version[i] = value = Integer.parseInt(t);
                        ++i;
                    }
                }
                if ((CMVCLevel = props.getProperty("CMVC")) != null) {
                    this.implementationInfo = new HashMap();
                    this.implementationInfo.put("CMVC", CMVCLevel);
                }
            }
            catch (Exception e) {
                System.err.println("WMQComponent failed to initialize " + e.getMessage());
            }
        }
    }

    public Class getFactoryClass() {
        return WMQFactoryFactory.class;
    }

    public Object getFactoryInstance() {
        return WMQFactoryFactory.getInstance();
    }

    public boolean isSuitable(HashMap filters) {
        return true;
    }

    public Map getImplementationInfo() {
        return this.getImplementationInfo(false);
    }

    public Map getImplementationInfo(boolean quiet) {
        block2: {
            WMQTraceHandler traceHandler = new WMQTraceHandler();
            WMQThreadPoolFactory threadPool = new WMQThreadPoolFactory();
            WMQPropertyHandler propertyHandler = new WMQPropertyHandler();
            String MQJBND_LVL = "mqjbnd level";
            try {
                JmqiEnvironment jmqiEnvironment = JmqiFactory.getInstance((JmqiTraceHandlerAdapter)traceHandler, (JmqiThreadPoolFactory)threadPool, (JmqiPropertyHandler)propertyHandler);
                JmqiSystemEnvironment sysenv = (JmqiSystemEnvironment)jmqiEnvironment;
                JmqiMetaData jmqiMetaData = sysenv.newJmqiMetaData();
                JmqiMQ jmqiMQ = jmqiEnvironment.getMQI(0);
                Pint cc = jmqiEnvironment.newPint();
                Pint rc = jmqiEnvironment.newPint();
                ((JmqiSP)jmqiMQ).getMetaData(jmqiMetaData, cc, rc);
                String bindingsLevel = jmqiMetaData.getCmvcLevel();
                this.implementationInfo.put(MQJBND_LVL, bindingsLevel);
            }
            catch (JmqiException e) {
                int rc;
                if (quiet || (rc = e.getReason()) != 2495) break block2;
                Throwable cause = e.getCause();
                String causeMsg = cause != null ? cause.getMessage() : "";
                String msg = e.getLocalizedMessage() + "::" + causeMsg;
                this.implementationInfo.put(MQJBND_LVL, msg);
            }
        }
        return super.getImplementationInfo();
    }
}

