/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderTextMessage;
import com.ibm.msg.client.wmq.common.WMQThreadLocalStorage;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import java.nio.ByteBuffer;
import javax.jms.JMSException;

public class WMQTextMessage
extends WMQMessage
implements ProviderTextMessage {
    private static final long serialVersionUID = -8937815037534630461L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQTextMessage.java, jmscc.wmq, k701, k701-112-140304 1.7.1.1 09/08/17 08:43:50";
    private String characterSet;
    private ByteBuffer body;
    private String text;

    public WMQTextMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "<init>()");
        }
        this.messageClass = "jms_text";
        this.initialize();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "<init>()");
        }
    }

    ByteBuffer _exportBodyUsingTls(int encoding, String cSet, WMQThreadLocalStorage tls) throws JMSException {
        ByteBuffer result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "_exportBodyUsingTls(int,String,WMQThreadLocalStorage)", new Object[]{new Integer(encoding), cSet, tls});
        }
        if (this.body == null) {
            if (this.text == null) {
                result = null;
            } else {
                result = WMQUtils.computeBytesFromTextUsingTls(this.text, cSet, tls);
                this.setNewBody(result, cSet, false);
            }
        } else if (this.characterSet.equals(cSet)) {
            result = this.body;
        } else {
            String tmp = WMQUtils.computeTextFromByteBuffer(this.body, this.characterSet);
            result = WMQUtils.computeBytesFromTextUsingTls(tmp, cSet, tls);
            this.setNewBody(result, cSet, false);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "_exportBodyUsingTls(int,String,WMQThreadLocalStorage)", result);
        }
        return result;
    }

    public byte[] _exportBody(int encoding, String cSet) throws JMSException {
        ByteBuffer result = this._exportBodyUsingTls(encoding, cSet, null);
        return result == null ? null : result.array();
    }

    public void _importBody(byte[] input, int startIndex, int endIndex, int encoding, String cSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "_importBody(byte [ ],int,int,int,String)", new Object[]{input, new Integer(startIndex), new Integer(endIndex), new Integer(encoding), cSet});
        }
        int length = endIndex == -1 ? input.length : endIndex - startIndex;
        byte[] bytes = new byte[length];
        System.arraycopy(input, startIndex, bytes, 0, length);
        ByteBuffer newBody = ByteBuffer.wrap(bytes);
        this.setNewBody(newBody, cSet, true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "_importBody(byte [ ],int,int,int,String)");
        }
    }

    public void clearBody() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "clearBody()");
        }
        this.initialize();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "clearBody()");
        }
    }

    public String getText() throws JMSException {
        if (this.text == null && this.body != null) {
            String result = WMQUtils.computeTextFromByteBuffer(this.body, this.characterSet);
            this.setMessageText(result, false);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "getText()", "getter", this.text);
        }
        return this.text;
    }

    private void initialize() {
        this.text = null;
        this.body = null;
        this.characterSet = null;
    }

    private void setNewBody(ByteBuffer newBody, String cSet, boolean inValidateCachedText) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "setNewBody(ByteBuffer,String,boolean)", new Object[]{newBody, cSet, inValidateCachedText});
        }
        if (inValidateCachedText) {
            this.text = null;
        }
        this.body = newBody;
        this.characterSet = cSet;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "setNewBody(ByteBuffer,String,boolean)");
        }
    }

    private void setMessageText(String newText, boolean inValidateCachedBytes) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "setMessageText(String,boolean)", new Object[]{newText, inValidateCachedBytes});
        }
        this.text = newText;
        if (inValidateCachedBytes) {
            this.body = null;
            this.characterSet = null;
        }
        if (this.isNullMessage) {
            if (Trace.isOn) {
                Trace.data(this, "setMessageText(String)", "isNullMessage is true. Ignoring new message text = ", (Object)newText);
            }
            this.text = null;
        } else if (!this.isNullMessage && this.text == null) {
            if (Trace.isOn) {
                Trace.data(this, "setMessageText(String)", "isNullMessage is false. New message text is null, but using empty string.", null);
            }
            this.text = "";
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "setMessageText(String,boolean)");
        }
    }

    public void setText(String newText) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "setText(String)", "setter", newText);
        }
        this.isNullMessage = newText == null;
        this.setMessageText(newText, true);
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQTextMessage.java, jmscc.wmq, k701, k701-112-140304  1.7.1.1 09/08/17 08:43:50");
        }
    }
}

