/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderStreamMessage;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.jms.JMSException;

public class WMQStreamMessage
extends WMQMessage
implements ProviderStreamMessage {
    private static final long serialVersionUID = -7838595029912202997L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQStreamMessage.java, jmscc.wmq, k701, k701-112-140304 1.6.1.2 12/06/06 19:48:06";
    private static final String STREAM_BODY_NAME = "stream";
    private static final String STREAM_ELT_NAME = "elt";
    private ArrayList stream = new ArrayList();
    private int streamPos;

    public WMQStreamMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "<init>()");
        }
        this.messageClass = "jms_stream";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "<init>()");
        }
    }

    public byte[] _exportBody(int encoding, String characterSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "_exportBody(int,String)", new Object[]{new Integer(encoding), characterSet});
        }
        StringBuffer output = new StringBuffer();
        byte[] bytes = null;
        output.append("<");
        output.append(STREAM_BODY_NAME);
        output.append(">");
        Iterator iterator = this.stream.iterator();
        Object current = null;
        while (iterator.hasNext()) {
            current = iterator.next();
            WMQMessageUtils.formatElement(STREAM_ELT_NAME, current, output);
        }
        output.append("</");
        output.append(STREAM_BODY_NAME);
        output.append(">");
        bytes = WMQUtils.computeBytesFromText(output.toString(), characterSet);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "_exportBody(int,String)", bytes);
        }
        return bytes;
    }

    public void _importBody(byte[] input, int startIndex, int endIndex, int encoding, String cSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "_importBody(byte [ ],int,int,int,String)", new Object[]{input, new Integer(startIndex), new Integer(endIndex), new Integer(encoding), cSet});
        }
        this.streamPos = 0;
        this.stream.clear();
        String body = WMQUtils.computeTextFromBytes(input, startIndex, endIndex, cSet);
        this.parseStreamBody(body);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "_importBody(byte [ ],int,int,int,String)");
        }
    }

    public synchronized void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "clearBody()");
        }
        this.streamPos = 0;
        this.stream.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "clearBody()");
        }
    }

    private void parseStreamBody(String streamBody) throws JMSException {
        StringTokenizer dataToBeRead;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "parseStreamBody(String)", new Object[]{streamBody});
        }
        if (!(dataToBeRead = new StringTokenizer(streamBody, "<>")).nextToken().equals(STREAM_BODY_NAME)) {
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1048", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "parseStreamBody(String)", je, 1);
            }
            throw je;
        }
        String name = dataToBeRead.nextToken();
        String value = null;
        String token = null;
        Object currentField = null;
        try {
            while (!name.equals("/stream")) {
                boolean shortForm = name.charAt(name.length() - 1) == '/';
                int nullIndex = name.indexOf(" xsi:nil");
                if (nullIndex != -1) {
                    int spaceIndex = name.indexOf(" ");
                    name = name.substring(0, spaceIndex);
                    if (!shortForm) {
                        token = dataToBeRead.nextToken();
                        if (token.charAt(0) != '/') {
                            token = dataToBeRead.nextToken();
                        }
                        if (token.charAt(0) != '/') {
                            JMSException je2 = (JMSException)((Object)NLSServices.createException("JMSCMQ1048", null));
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "parseStreamBody(String)", je2, 2);
                            }
                            throw je2;
                        }
                    }
                    this.stream.add(null);
                    name = dataToBeRead.nextToken();
                    continue;
                }
                int index = name.indexOf(" dt=");
                String type = "";
                if (index != -1) {
                    type = name.substring(index + 4);
                    name = name.substring(0, index);
                } else {
                    type = "'string'";
                }
                if (shortForm) {
                    currentField = WMQMessageUtils.deformatElement(type, "");
                    this.stream.add(currentField);
                    name = dataToBeRead.nextToken();
                    continue;
                }
                value = dataToBeRead.nextToken();
                if (value.charAt(0) == '/') {
                    currentField = WMQMessageUtils.deformatElement(type, "");
                    this.stream.add(currentField);
                } else {
                    token = dataToBeRead.nextToken();
                    if (token.charAt(0) != '/') {
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1048", null));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "parseStreamBody(String)", je, 3);
                        }
                        throw je;
                    }
                    currentField = WMQMessageUtils.deformatElement(type, value);
                    this.stream.add(currentField);
                }
                name = dataToBeRead.nextToken();
            }
        }
        catch (NoSuchElementException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "parseStreamBody(String)", ex);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0009", null));
            je.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "parseStreamBody(String)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "parseStreamBody(String)");
        }
    }

    public synchronized Object readObject() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "readObject()");
        }
        if (this.streamPos >= this.stream.size()) {
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0017", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "readObject()", je);
            }
            throw je;
        }
        Object object = this.stream.get(this.streamPos);
        ++this.streamPos;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "readObject()", object);
        }
        return object;
    }

    public synchronized void reset() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "reset()");
        }
        this.streamPos = 0;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "reset()");
        }
    }

    public synchronized void stepBack() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "stepBack()");
        }
        if (this.streamPos > 0) {
            --this.streamPos;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "stepBack()");
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeBoolean(boolean)", new Object[]{value});
        }
        this.stream.add(new Boolean(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeBoolean(boolean)");
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeByte(byte)", new Object[]{new Byte(value)});
        }
        this.stream.add(new Byte(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeByte(byte)");
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeBytes(byte [ ])", new Object[]{value});
        }
        this.stream.add(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeBytes(byte [ ])");
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeBytes(byte [ ],int,int)", new Object[]{value, new Integer(offset), new Integer(length)});
        }
        byte[] bytes = new byte[length];
        System.arraycopy(value, offset, bytes, 0, length);
        this.stream.add(bytes);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeBytes(byte [ ],int,int)");
        }
    }

    public void writeChar(char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeChar(char)", new Object[]{new Character(value)});
        }
        this.stream.add(new Character(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeChar(char)");
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeDouble(double)", new Object[]{new Double(value)});
        }
        this.stream.add(new Double(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeDouble(double)");
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeFloat(float)", new Object[]{new Float(value)});
        }
        this.stream.add(new Float(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeFloat(float)");
        }
    }

    public void writeInt(int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeInt(int)", new Object[]{new Integer(value)});
        }
        this.stream.add(new Integer(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeInt(int)");
        }
    }

    public void writeLong(long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeLong(long)", new Object[]{new Long(value)});
        }
        this.stream.add(new Long(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeLong(long)");
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeObject(Object)", new Object[]{value});
        }
        this.stream.add(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeObject(Object)");
        }
    }

    public void writeShort(short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeShort(short)", new Object[]{new Short(value)});
        }
        this.stream.add(new Short(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeShort(short)");
        }
    }

    public void writeString(String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeString(String)", new Object[]{value});
        }
        this.stream.add(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "writeString(String)");
        }
    }

    public ArrayList getStreamData() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "getStreamData()", "getter", this.stream);
        }
        return this.stream;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQStreamMessage.java, jmscc.wmq, k701, k701-112-140304  1.6.1.2 12/06/06 19:48:06");
        }
    }
}

