/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.mq.constants.CMQC;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.MQRFH;
import com.ibm.mq.jmqi.internal.JmqiTools;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.mq.jmqi.system.JmqiComponentTls;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.JmqiTls;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.WMQThreadLocalStorage;
import com.ibm.msg.client.wmq.common.internal.WMQCommonConnection;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;

public class WMQSendMarshal
extends WMQMarshal {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQSendMarshal.java, jmscc.wmq, k701, k701-112-140304 1.14.1.4 12/11/30 13:23:43";
    private static JmqiCodepage cachedJmqiCodepage;
    private ByteBuffer[] messageBuffers = null;
    private int messageBuffersIndex = 0;
    private boolean exported = false;

    WMQSendMarshal() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "<init>()");
        }
    }

    private void constructMessageBuffers() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "constructMessageBuffers()");
        }
        int bodyEncoding = WMQMarshalUtils.calculateMessageBodyEncoding(this.destination, this.providerMessage);
        int bodyCcsid = WMQMarshalUtils.calculateMessageBodyCcsid(this.env, this.destination, this.providerMessage);
        this.messageBuffers = new ByteBuffer[2];
        this.messageBuffersIndex = 0;
        this.writeMessageProperties(bodyEncoding, bodyCcsid);
        String bodyCharset = WMQUtils.getCharacterSetString(this.env, bodyCcsid, bodyEncoding);
        if (bodyCharset == null) {
            bodyCharset = "UTF-8";
        }
        if (this.providerMessage instanceof WMQTextMessage) {
            WMQTextMessage tm = (WMQTextMessage)this.providerMessage;
            WMQThreadLocalStorage tls = this.owner.getThreadLocalStorage();
            ByteBuffer bodyByteBuffer = tm._exportBodyUsingTls(bodyEncoding, bodyCharset, tls);
            if (bodyByteBuffer != null) {
                this.messageBuffers[this.messageBuffersIndex++] = bodyByteBuffer;
                if (Trace.isOn) {
                    Trace.data(this, "constructMessageBuffers()", "Body of the message", (Object)bodyByteBuffer);
                }
            }
        } else {
            byte[] body = this.providerMessage._exportBody(bodyEncoding, bodyCharset);
            if (body != null) {
                this.messageBuffers[this.messageBuffersIndex++] = ByteBuffer.wrap(body);
                if (Trace.isOn) {
                    Trace.data(this, "constructMessageBuffers()", "Body of the message", (Object)body);
                }
            }
        }
        if (this.messageBuffersIndex > 0) {
            ByteBuffer[] tmp = new ByteBuffer[this.messageBuffersIndex];
            for (int i = 0; i < this.messageBuffersIndex; ++i) {
                ByteBuffer current = this.messageBuffers[i];
                if (current == null) continue;
                tmp[i] = current;
            }
            this.messageBuffers = tmp;
        } else {
            this.messageBuffers = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "constructMessageBuffers()");
        }
    }

    private void constructMQMD() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "constructMQMD()");
        }
        this.mqmd = this.env.newMQMD();
        this.mqmd.setCodedCharSetId(1208);
        this.mqmd.setPriority(this.providerMessage.getJMSPriority().intValue());
        byte[] correlIdBytes = this.providerMessage.getJMSCorrelationIDAsBytes();
        if (correlIdBytes != null) {
            this.mqmd.setCorrelId(correlIdBytes);
        } else {
            String correlIdString = this.providerMessage.getJMSCorrelationID();
            if (correlIdString == null) {
                this.mqmd.setCorrelId(CMQC.MQCI_NONE);
            } else {
                byte[] cid = WMQUtils.computeBytesFromText(correlIdString, "UTF8");
                this.mqmd.setCorrelId(cid);
            }
        }
        int deliveryMode = this.providerMessage.getJMSDeliveryMode();
        switch (deliveryMode) {
            case 1: {
                this.mqmd.setPersistence(0);
                break;
            }
            case 2: {
                this.mqmd.setPersistence(1);
                break;
            }
            default: {
                HashMap<String, Object> ffstInfo = new HashMap<String, Object>();
                ffstInfo.put("message", "Invalid DeliveryMode");
                ffstInfo.put("DeliveryMode", new Integer(deliveryMode));
                Trace.ffst(this, "constructMQMD()", "XN007004", ffstInfo, JMSException.class);
            }
        }
        if (this.providerMessage instanceof WMQTextMessage || this.providerMessage instanceof WMQStreamMessage || this.providerMessage instanceof WMQMapMessage) {
            this.mqmd.setFormat("MQSTR   ");
        } else {
            this.mqmd.setFormat("        ");
        }
        long expiration = this.providerMessage.getJMSExpiration();
        if (expiration == 0L) {
            this.mqmd.setExpiry(-1);
        } else {
            long timestamp = this.providerMessage.getJMSTimestamp();
            long expiry = expiration - (timestamp > 0L ? timestamp : System.currentTimeMillis());
            if ((expiry /= 100L) < 1L) {
                this.mqmd.setExpiry(1);
            } else if (expiry < Integer.MAX_VALUE) {
                this.mqmd.setExpiry((int)expiry);
            } else {
                this.mqmd.setExpiry(-1);
            }
        }
        String replyToDestination = this.providerMessage.getJMSReplyToAsString();
        if (replyToDestination != null) {
            WMQDestinationURIParser uriParser = new WMQDestinationURIParser(replyToDestination);
            if (uriParser.getDomain() == 1) {
                String qMgrName;
                String qName = uriParser.getDestinationName();
                if (qName != null) {
                    this.mqmd.setReplyToQ(qName);
                }
                if ((qMgrName = uriParser.getQmName()) != null) {
                    this.mqmd.setReplyToQMgr(qMgrName);
                }
                this.mqmd.setMsgType(1);
            }
        } else {
            this.mqmd.setMsgType(8);
        }
        Enumeration props = this.providerMessage.getPropertyNames();
        WMQDestinationURIParser uriParser = new WMQDestinationURIParser(this.providerMessage.getJMSDestinationAsString());
        boolean isQueue = uriParser.getDomain() == 1;
        String name = null;
        while (props.hasMoreElements()) {
            name = (String)props.nextElement();
            if (!name.startsWith("JMS")) continue;
            if (Trace.isOn) {
                Trace.traceData(this, "constructMQMD()", "processing propery", (Object)name);
            }
            if (isQueue && name.equals("JMSXGroupID")) {
                String jmsxGroupId = this.providerMessage.getStringProperty("JMSXGroupID");
                if (jmsxGroupId != null) {
                    if (jmsxGroupId.startsWith("ID:")) {
                        this.mqmd.setGroupId(WMQUtils.stringToId(jmsxGroupId));
                    } else {
                        byte[] gid = WMQUtils.computeBytesFromText(jmsxGroupId, "UTF8");
                        this.mqmd.setGroupId(gid);
                    }
                    this.mqmd.setMsgFlags(this.mqmd.getMsgFlags() | 8);
                    this.mqmd.setVersion(2);
                    continue;
                }
                if (!Trace.isOn) continue;
                Trace.traceData(this, "constructMQMD()", "Ignoring null jmsxGroupId", (Object)jmsxGroupId);
                continue;
            }
            if (isQueue && name.equals("JMSXGroupSeq")) {
                try {
                    int seqNumber = this.providerMessage.getIntProperty("JMSXGroupSeq");
                    if (seqNumber > 0) {
                        this.mqmd.setMsgSeqNumber(seqNumber);
                        this.mqmd.setMsgFlags(this.mqmd.getMsgFlags() | 8);
                        this.mqmd.setVersion(2);
                        continue;
                    }
                    if (!Trace.isOn) continue;
                    Trace.traceData(this, "constructMQMD()", "Ignoring invalid seqNumber", (Object)new Integer(seqNumber));
                }
                catch (NumberFormatException nfe) {
                    if (!Trace.isOn) continue;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "constructMQMD()", nfe);
                    String groupSeqNo = this.providerMessage.getStringProperty("JMSXGroupSeq");
                    Trace.traceData(this, "constructMQMD()", "Ignoring invalid value for JMSXGroupSeq property.", (Object)groupSeqNo);
                }
                continue;
            }
            if (!name.startsWith("JMS_IBM_")) continue;
            if (name.equals("JMS_IBM_Format")) {
                String format = this.providerMessage.getStringProperty("JMS_IBM_Format");
                this.mqmd.setFormat(format);
                continue;
            }
            if (name.equals("JMS_IBM_MsgType")) {
                int msgType = this.providerMessage.getIntProperty("JMS_IBM_MsgType");
                this.mqmd.setMsgType(msgType);
                continue;
            }
            if (name.equals("JMS_IBM_Feedback")) {
                this.mqmd.setFeedback(this.providerMessage.getIntProperty("JMS_IBM_Feedback"));
                continue;
            }
            if (isQueue && name.equals("JMS_IBM_Last_Msg_In_Group")) {
                if (!this.providerMessage.getBooleanProperty("JMS_IBM_Last_Msg_In_Group")) continue;
                this.mqmd.setMsgFlags(this.mqmd.getMsgFlags() | 0x10);
                continue;
            }
            if (!name.startsWith("JMS_IBM_Report")) continue;
            this.updateMQMDReport(name, "JMS_IBM_Report_Exception", 0x7000000);
            this.updateMQMDReport(name, "JMS_IBM_Report_Expiration", 0xE00000);
            this.updateMQMDReport(name, "JMS_IBM_Report_COA", 1792);
            this.updateMQMDReport(name, "JMS_IBM_Report_COD", 14336);
            this.updateMQMDReport(name, "JMS_IBM_Report_PAN", 1);
            this.updateMQMDReport(name, "JMS_IBM_Report_NAN", 2);
            this.updateMQMDReport(name, "JMS_IBM_Report_Pass_Msg_ID", 128);
            this.updateMQMDReport(name, "JMS_IBM_Report_Pass_Correl_ID", 64);
            this.updateMQMDReport(name, "JMS_IBM_Report_Discard_Msg", 0x8000000);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "constructMQMD()");
        }
    }

    private void exportMQMDAndMessageBuffers() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "exportMQMDAndMessageBuffers()");
        }
        if (!this.exported) {
            if (Trace.isOn) {
                Trace.data(this, "exportMQMDAndMessageBuffers()", "Preparing MQMD and Message Buffers for export", null);
            }
            if (!this.imported) {
                Trace.ffst(this, "exportMQMDAndMessageBuffers()", "XM006001", null, null);
            }
            this.providerMessage.setJMSRedelivered(false);
            this.providerMessage.setIntProperty("JMSXDeliveryCount", 0);
            this.constructMQMD();
            this.updateMQMD();
            this.constructMessageBuffers();
            WMQMarshalUtils.overrideHeaderFromMQMDProps(this.destination, this.providerMessage, this.mqmd);
            this.exported = true;
        } else if (Trace.isOn) {
            Trace.data(this, "exportMQMDAndMessageBuffers()", "Using earlier exported MQMD and Message Buffers", null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "exportMQMDAndMessageBuffers()");
        }
    }

    public ByteBuffer[] exportMessageBuffers() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "exportMessageBuffers()");
        }
        this.exportMQMDAndMessageBuffers();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "exportMessageBuffers()", this.messageBuffers);
        }
        return this.messageBuffers;
    }

    public MQMD exportMQMD() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "exportMQMD()");
        }
        this.exportMQMDAndMessageBuffers();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "exportMQMD()", this.mqmd);
        }
        return this.mqmd;
    }

    public void importProviderMessage(WMQConsumerOwner anOwner, WMQMessage message, WMQDestination aDestination) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "importProviderMessage(WMQConsumerOwner,WMQMessage,WMQDestination)", new Object[]{anOwner, message, aDestination});
        }
        if (anOwner == null || message == null || aDestination == null) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("anOwner", anOwner);
            info.put("message", message);
            info.put("aDestination", aDestination);
            Trace.ffst(this, "importProviderMessage(WMQConsumerOwner,WMQMessage,WMQDestination)", "XN007001", info, null);
        }
        this.resetSendState();
        this.imported = true;
        this.owner = anOwner;
        this.providerMessage = message;
        this.destination = aDestination;
        this.env = this.owner.getJmqiEnvironment();
        if (this.env == null) {
            Trace.ffst(this, "importProviderMessage(WMQConsumerOwner,WMQMessage,WMQDestination)", "XN00L001", null, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "importProviderMessage(WMQConsumerOwner,WMQMessage,WMQDestination)");
        }
    }

    public void resetSendState() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "resetSendState()");
        }
        this.resetState();
        this.messageBuffers = null;
        this.messageBuffersIndex = 0;
        this.exported = false;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "resetSendState()");
        }
    }

    private void updateMQMD() throws JMSException {
        int destinationPriority;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "updateMQMD()");
        }
        if ((destinationPriority = this.destination.getIntProperty("priority")) == -1) {
            this.providerMessage.setJMSPriority(4);
            this.mqmd.setPriority(-1);
        }
        int destinationPersistence = this.destination.getIntProperty("deliveryMode");
        switch (destinationPersistence) {
            case -2: 
            case 1: 
            case 2: {
                break;
            }
            case -1: {
                this.providerMessage.setJMSDeliveryMode(-2);
                this.mqmd.setPersistence(2);
                break;
            }
            case 3: {
                if (!this.destination.isNPHighCheckDone()) {
                    boolean targetClientMQ;
                    WMQCommonConnection connection = this.owner.getConnection();
                    if (connection == null) {
                        HashMap<String, Object> info = new HashMap<String, Object>();
                        info.put("methodName", "updateMD()");
                        info.put("message", "Connection is null");
                        info.put("destination", this.destination);
                        info.put("MQMD", this.mqmd);
                        info.put("WMQMessage", this.providerMessage);
                        Trace.ffst(this, "updateMD()", "XN00L002", info, JMSException.class);
                    }
                    boolean persistenceFromMD = connection.getPersistenceFromMD();
                    boolean bl = targetClientMQ = this.destination.getIntProperty("targetClient") == 1;
                    if (!persistenceFromMD && !targetClientMQ && WMQUtils.isNPMClassHigh(this.owner, this.destination)) {
                        this.destination.setNPHighSupported(true);
                    } else {
                        this.destination.setNPHighSupported(false);
                    }
                }
                if (!this.destination.getNPHighSupported()) break;
                this.mqmd.setPersistence(0);
                break;
            }
            default: {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("methodName", "updateMD()");
                info.put("message", "Invalid value for WMQ_PERSISTENCE");
                info.put("destination", this.destination);
                info.put("persistence", new Integer(destinationPersistence));
                info.put("MQMD", this.mqmd);
                info.put("WMQMessage", this.providerMessage);
                Trace.ffst(this, "updateMD()", "XN00L003", info, JMSException.class);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "updateMQMD()");
        }
    }

    private void updateMQMDReport(String namedProperty, String reportProperty, int mask) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "updateMQMDReport(String,String,int)", new Object[]{namedProperty, reportProperty, new Integer(mask)});
        }
        if (namedProperty.equals(reportProperty)) {
            int oldReport = this.mqmd.getReport();
            int enableValue = this.providerMessage.getIntProperty(reportProperty);
            int newReport = oldReport | enableValue & mask;
            this.mqmd.setReport(newReport);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "updateMQMDReport(String,String,int)");
        }
    }

    private void updateProviderMessageFromMQMD(MQMD newMQMD) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "updateProviderMessageFromMQMD(MQMD)", new Object[]{newMQMD});
        }
        if (newMQMD == null) {
            Trace.ffst(this, "updateProviderMessageFromMQMD(MQMD)", "XN007002", null, JMSException.class);
        }
        this.mqmd = newMQMD;
        super.updateProviderMessageFromMQMD();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "updateProviderMessageFromMQMD(MQMD)");
        }
    }

    protected boolean areMessagePropertiesRequired() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "areMessagePropertiesRequired()");
        }
        boolean propsRequired = true;
        int messageBodyStyle = this.destination.getIntProperty("messageBody");
        switch (messageBodyStyle) {
            case 2: {
                int targetClient = this.destination.getIntProperty("targetClient");
                if (targetClient == 0) {
                    propsRequired = true;
                    break;
                }
                if (targetClient == 1) {
                    propsRequired = false;
                    break;
                }
                HashMap<String, Integer> info = new HashMap<String, Integer>();
                info.put("targetClient", new Integer(targetClient));
                Trace.ffst(this, "areMessagePropertiesRequired()", "XN00L004", info, JMSException.class);
                break;
            }
            case 0: {
                propsRequired = true;
                break;
            }
            case 1: {
                propsRequired = false;
                break;
            }
            default: {
                HashMap<String, Integer> info = new HashMap<String, Integer>();
                info.put("messageBody", new Integer(messageBodyStyle));
                Trace.ffst(this, "areMessagePropertiesRequired()", "XN00L005", info, JMSException.class);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "areMessagePropertiesRequired()", propsRequired);
        }
        return propsRequired;
    }

    private void writeMQRFH2(int messageBodyEncoding, int messageBodyCcsid) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "writeMQRFH2(int,int)", new Object[]{new Integer(messageBodyEncoding), new Integer(messageBodyCcsid)});
        }
        boolean persistenceFromMD = WMQMarshalUtils.getPersistenceFromMD(this.owner);
        String messageBodyFormat = this.mqmd.getFormat();
        JmqiSystemEnvironment sysenv = (JmqiSystemEnvironment)this.env;
        WMQThreadLocalStorage tls = this.owner.getThreadLocalStorage();
        JmqiTls jTls = sysenv.getJmqiTls((JmqiComponentTls)tls);
        MQRFH rfh = null;
        if (tls.mqrfh == null) {
            rfh = this.env.newMQRFH(5);
            rfh.setVersion(2);
            tls.mqrfh = rfh;
        } else {
            rfh = tls.mqrfh;
        }
        rfh.setEncoding(messageBodyEncoding);
        rfh.setCodedCharSetId(messageBodyCcsid);
        rfh.setFormat(messageBodyFormat);
        this.setRfhFolder(rfh, 0, null, this.providerMessage._getMcdFolder());
        this.setRfhFolder(rfh, 1, null, this.providerMessage._getJmsFolder(persistenceFromMD));
        this.setRfhFolder(rfh, 2, null, this.providerMessage._getMQExtFolder());
        this.setRfhFolder(rfh, 3, "<usr></usr>", this.providerMessage._getUsrFolder());
        boolean swap = false;
        if ((this.mqmd.getEncoding() & 0xF) == 2) {
            swap = true;
        }
        int ptrSize = 0;
        JmqiMQ mq = this.owner.getJmqiMQ();
        if (cachedJmqiCodepage == null && (cachedJmqiCodepage = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)this.mqmd.getCodedCharSetId())) == null) {
            WMQMarshalUtils.throwBadCcsidException(this.mqmd.getCodedCharSetId());
        }
        int size = 0;
        try {
            size = rfh.getRequiredBufferSize(mq, ptrSize, cachedJmqiCodepage, swap);
            if (size > tls.rfhBuffer.length) {
                tls.rfhBuffer = new byte[size];
            }
            rfh.writeToBuffer(tls.rfhBuffer, 0, ptrSize, swap, cachedJmqiCodepage, jTls);
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "writeMQRFH2(int,int)", e);
            }
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("messageBodyEncoding", new Integer(messageBodyEncoding));
            info.put("messageBodyCcsid", new Integer(messageBodyCcsid));
            info.put("messageBodyFormat", messageBodyFormat);
            info.put("swap", new Boolean(swap));
            info.put("size", new Integer(size));
            info.put("MQMD", this.mqmd != null ? this.mqmd.toString() : "mqmd is null");
            info.put("MQRFH", rfh != null ? rfh.toString() : "rfh is null");
            info.put("JmqiCodepage", cachedJmqiCodepage != null ? cachedJmqiCodepage.toString() : "jmqiCodePage is null");
            info.put("rfhBuffer length", tls.rfhBuffer != null ? "" + tls.rfhBuffer.length : "rfhBuffer is null");
            info.put("WMQMessage", this.providerMessage != null ? this.providerMessage.toString() : "providerMessage is null");
            info.put("WMQDestination", this.destination != null ? this.destination.toURI() : "destination is null");
            WMQMarshalUtils.addInfo(e, info);
            Trace.ffst(this, JmqiTools.getExSumm((Throwable)e), "XN00L006", info, JMSException.class);
        }
        this.messageBuffers[this.messageBuffersIndex++] = ByteBuffer.wrap(tls.rfhBuffer, 0, size);
        if (Trace.isOn) {
            byte[] traceData = new byte[size];
            System.arraycopy(tls.rfhBuffer, 0, traceData, 0, size);
            Trace.data(this, "constructMessageBuffers()", "MQRFH2 header for the message", (Object)traceData);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "writeMQRFH2(int,int)");
        }
    }

    private void setRfhFolder(MQRFH rfh, int index, String empty, String folderString) {
        String folderData = null;
        if (folderString != null) {
            folderData = folderString;
            if (folderString.equals(empty)) {
                folderData = null;
            }
        }
        rfh.setNameValueData(index, folderData);
    }

    protected void writeMessageProperties(int bodyEncoding, int bodyCcsid) throws JMSException {
        boolean messagePropertiesRequired;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "writeMessageProperties(int,int)", new Object[]{new Integer(bodyEncoding), new Integer(bodyCcsid)});
        }
        if (messagePropertiesRequired = this.areMessagePropertiesRequired()) {
            this.writeMQRFH2(bodyEncoding, bodyCcsid);
            this.mqmd.setFormat("MQHRF2  ");
        } else {
            this.mqmd.setEncoding(bodyEncoding);
            this.mqmd.setCodedCharSetId(bodyCcsid);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "writeMessageProperties(int,int)");
        }
    }

    public void informSendMarshal(MQMD md) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "informSendMarshal(MQMD)", new Object[]{md});
        }
        this.updateProviderMessageFromMQMD(md);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "informSendMarshal(MQMD)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQSendMarshal.java, jmscc.wmq, k701, k701-112-140304  1.14.1.4 12/11/30 13:23:43");
        }
    }
}

