/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.MQHeader;
import com.ibm.mq.jmqi.internal.JmqiDC;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.mq.jmqi.system.JmqiComponentTls;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.JmqiTls;
import com.ibm.mq.jmqi.system.zrfp.ReceiveZRFP;
import com.ibm.mq.jmqi.system.zrfp.Triplet;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.WMQThreadLocalStorage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQNullMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage;
import javax.jms.JMSException;

public class WMQReceiveMarshalMH
extends WMQReceiveMarshal {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQReceiveMarshalMH.java, jmscc.wmq, k701, k701-112-140304 1.8.1.2 11/01/20 15:24:12";

    WMQReceiveMarshalMH() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshalMH", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshalMH", "<init>()");
        }
    }

    protected int constructProviderMessageFromProperties(int messageBodyStyle) throws JMSException {
        return this.constructProviderMessageFromZRFP(messageBodyStyle);
    }

    private int constructProviderMessageFromZRFP(int messageBodyStyle) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshalMH", "constructProviderMessageFromZRFP(int)", new Object[]{new Integer(messageBodyStyle)});
        }
        int pos = 0;
        try {
            JmqiSystemEnvironment sysenv = (JmqiSystemEnvironment)this.env;
            WMQThreadLocalStorage tls = this.owner.getThreadLocalStorage();
            JmqiTls jTls = sysenv.getJmqiTls((JmqiComponentTls)tls);
            JmqiDC dc = sysenv.getDC();
            int strucID = dc.readI32(this.buffer, pos, false);
            ReceiveZRFP receiveZRFP = null;
            if (strucID == 1515341392) {
                if (tls.receiveZRFP == null) {
                    tls.receiveZRFP = receiveZRFP = new ReceiveZRFP(this.env, jTls);
                } else {
                    receiveZRFP = tls.receiveZRFP;
                }
                pos = receiveZRFP.readFromBuffer(this.buffer, pos);
                this.hasMessageProperties = true;
            }
            int encoding = this.mqmd.getEncoding();
            int ccsid = this.mqmd.getCodedCharSetId();
            String format = this.mqmd.getFormat();
            if (format.startsWith("MQH")) {
                int previousCcsid = this.owner.getHconn().getCcsid();
                int ptrSize = 4;
                while (format.startsWith("MQH")) {
                    MQHeader header = this.env.newMQHeader();
                    if (ccsid == -2) {
                        ccsid = previousCcsid;
                    }
                    header.setFormat(format);
                    boolean swap = (encoding & 0xF) == 2;
                    JmqiCodepage cp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)ccsid);
                    header.readFromBuffer(this.buffer, pos, ptrSize, swap, cp, jTls, false);
                    pos += header.getStrucLength();
                    encoding = header.getEncoding();
                    previousCcsid = ccsid;
                    ccsid = header.getCodedCharSetId();
                    format = header.getFormat();
                }
            }
            this.encodingFromLastHeaderBeforeBody = encoding;
            this.ccsidFromLastHeaderBeforeBody = ccsid;
            this.formatFromLastHeaderBeforeBody = format;
            if (Trace.isOn) {
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshalMH", "constructProviderMessageFromZRFP(int)", (Object)"All of the headers have been processed");
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshalMH", "constructProviderMessageFromZRFP(int)", (Object)("Format of last header in message: " + this.formatFromLastHeaderBeforeBody));
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshalMH", "constructProviderMessageFromZRFP(int)", (Object)("CCSID of message body: " + this.ccsidFromLastHeaderBeforeBody));
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshalMH", "constructProviderMessageFromZRFP(int)", (Object)("Encoding of message body: " + this.formatFromLastHeaderBeforeBody));
            }
            String fbClass = format.equals("MQSTR   ") ? "jms_text" : "jms_bytes";
            String forcedMessageClass = messageBodyStyle == 1 ? "jms_bytes" : null;
            Triplet mcdTriplet = null;
            Triplet jmsTriplet = null;
            Triplet usrTriplet = null;
            Triplet mqextTriplet = null;
            Triplet mqpsTriplet = null;
            if (receiveZRFP != null) {
                Triplet[] triplets = receiveZRFP.getTriplets();
                block8: for (int i = 0; i < triplets.length; ++i) {
                    Triplet triplet = triplets[i];
                    if (triplet == null) continue;
                    String label = triplet.getLabel();
                    char index = label.charAt(0);
                    switch (index) {
                        case 'm': {
                            if ("mcd".equals(label)) {
                                mcdTriplet = triplet;
                                continue block8;
                            }
                            if ("mqps".equals(label)) {
                                mqpsTriplet = triplet;
                                continue block8;
                            }
                            if (!"mqext".equals(label)) continue block8;
                            mqextTriplet = triplet;
                            continue block8;
                        }
                        case 'j': {
                            if (!"jms".equals(label)) continue block8;
                            jmsTriplet = triplet;
                            continue block8;
                        }
                        case 'u': {
                            if (!"usr".equals(label)) continue block8;
                            usrTriplet = triplet;
                        }
                    }
                }
            }
            if (mcdTriplet != null) {
                this.providerMessage = WMQMessage.setTripletMcd(mcdTriplet, fbClass, forcedMessageClass);
            } else if (forcedMessageClass == null) {
                if (pos >= this.getSafeBufferEnd()) {
                    this.providerMessage = new WMQNullMessage();
                    this.providerMessage.isNullMessage = true;
                } else if (format.equals("MQSTR   ")) {
                    this.providerMessage = new WMQTextMessage();
                    this.providerMessage.isNullMessage = false;
                } else {
                    this.providerMessage = new WMQBytesMessage();
                }
            } else if (forcedMessageClass.equals("jms_bytes")) {
                this.providerMessage = new WMQBytesMessage();
            }
            if (jmsTriplet != null) {
                boolean persistenceFromMD = WMQMarshalUtils.getPersistenceFromMD(this.owner);
                this.providerMessage.setTripletJms(jmsTriplet, persistenceFromMD);
            } else {
                this.providerMessage.setJMSDeliveryMode(-3);
            }
            if (mqpsTriplet != null) {
                this.providerMessage.setTripletMqps(mqpsTriplet);
            }
            if (mqextTriplet != null) {
                this.providerMessage.setTripletMqext(mqextTriplet);
            }
            if (usrTriplet != null) {
                this.providerMessage.setTripletUsr(usrTriplet);
            }
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshalMH", "constructProviderMessageFromZRFP(int)", e);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1000", null));
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshalMH", "constructProviderMessageFromZRFP(int)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshalMH", "constructProviderMessageFromZRFP(int)", new Integer(pos));
        }
        return pos;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshalMH", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQReceiveMarshalMH.java, jmscc.wmq, k701, k701-112-140304  1.8.1.2 11/01/20 15:24:12");
        }
    }
}

