/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.MQHeader;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.MQRFH;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.mq.jmqi.system.JmqiComponentTls;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.JmqiTls;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.WMQThreadLocalStorage;
import com.ibm.msg.client.wmq.common.internal.WMQCommonConnection;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQNullMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage;
import java.nio.ByteBuffer;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import javax.jms.JMSException;

public class WMQReceiveMarshal
extends WMQMarshal {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQReceiveMarshal.java, jmscc.wmq, k701, k701-112-140304 1.14.1.7 12/06/06 19:52:15";
    private static JmqiCodepage cachedJmqiCodepage1;
    private static JmqiCodepage cachedJmqiCodepage2;
    private static int cachedCcsid1;
    private static int cachedCcsid2;
    protected byte[] buffer = null;
    private int bufferEnd = -1;
    private int bufferStart = 0;
    protected int ccsidFromLastHeaderBeforeBody = 0;
    protected int encodingFromLastHeaderBeforeBody = 0;
    protected String formatFromLastHeaderBeforeBody = null;
    protected boolean hasMessageProperties = false;
    private int defaultReplyToStyle = 1;
    private GregorianCalendar putMsCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));

    WMQReceiveMarshal() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "<init>()");
        }
        this.defaultReplyToStyle = WMQMarshalUtils.getDefaultReplyToStyle();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "<init>()");
        }
    }

    protected int constructProviderMessageFromProperties(int messageBodyStyle) throws JMSException {
        return this.constructProviderMessageFromRFH2(messageBodyStyle);
    }

    private int constructProviderMessageFromRFH2(int messageBodyStyle) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "constructProviderMessageFromRFH2(int)", new Object[]{new Integer(messageBodyStyle)});
        }
        int pos = 0;
        try {
            JmqiCodepage cp;
            String mcdFolder = null;
            String usrFolder = null;
            String jmsFolder = null;
            String mqextFolder = null;
            String mqpsFolder = null;
            boolean jmsFolderParsed = false;
            int ptrSize = 4;
            this.hasMessageProperties = false;
            JmqiSystemEnvironment sysenv = (JmqiSystemEnvironment)this.env;
            WMQThreadLocalStorage tls = this.owner.getThreadLocalStorage();
            JmqiTls jTls = sysenv.getJmqiTls((JmqiComponentTls)tls);
            MQRFH rfh = this.env.newMQRFH(10);
            MQHeader header = rfh.getMqHeader();
            header.setFormat(this.mqmd.getFormat());
            int encoding = this.mqmd.getEncoding();
            int previousCcsid = this.owner.getHconn().getCcsid();
            int ccsid = this.mqmd.getCodedCharSetId();
            if (cachedCcsid1 == ccsid && cachedJmqiCodepage1 != null) {
                cp = cachedJmqiCodepage1;
            } else {
                cp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)ccsid);
                if (cp == null) {
                    WMQMarshalUtils.throwBadCcsidException(ccsid);
                }
                cachedCcsid1 = ccsid;
                cachedJmqiCodepage1 = cp;
            }
            JmqiCodepage hconnCP = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)this.owner.getHconn().getCcsid());
            if (hconnCP == null) {
                WMQMarshalUtils.throwBadCcsidException(this.owner.getHconn().getCcsid());
            }
            long formatLong = MQHeader.convertFormatToLong((JmqiEnvironment)this.env, (JmqiCodepage)hconnCP, (String)this.mqmd.getFormat());
            long mqheader = formatLong & 0xFFFFFF0000000000L;
            if (Trace.isOn) {
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshal", (Object)("Format:    " + this.mqmd.getFormat()));
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshal", (Object)("formatLong:" + Long.toHexString(formatLong)));
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshal", (Object)("mqheader:  " + Long.toHexString(mqheader)));
            }
            while (mqheader == 5571313378871214080L || mqheader == -3109515640373772288L) {
                if (ccsid == -2) {
                    ccsid = previousCcsid;
                }
                if (cachedCcsid2 == ccsid && cachedJmqiCodepage2 != null) {
                    cp = cachedJmqiCodepage2;
                } else {
                    cp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)ccsid);
                    if (cp == null) {
                        WMQMarshalUtils.throwBadCcsidException(ccsid);
                    }
                    cachedCcsid2 = ccsid;
                    cachedJmqiCodepage2 = cp;
                }
                boolean swap = (encoding & 0xF) == 2;
                int bodyPos = header.readFromBuffer(this.buffer, pos, ptrSize, swap, cp, jTls, false);
                if (formatLong == 5571313732236222496L || formatLong == -3109514705028104128L) {
                    this.hasMessageProperties = true;
                    rfh.readBodyFromBuffer(this.buffer, bodyPos, ptrSize, swap, cp, jTls);
                    int numberOfFolders = rfh.getNameValueDataLength();
                    for (int i = 0; i < numberOfFolders; ++i) {
                        String folder = rfh.getNameValueData(i);
                        if (mcdFolder == null && folder.startsWith("<mcd>")) {
                            mcdFolder = folder;
                            continue;
                        }
                        if (usrFolder == null && folder.startsWith("<usr>")) {
                            usrFolder = folder;
                            continue;
                        }
                        if (jmsFolder == null && folder.startsWith("<jms>")) {
                            jmsFolder = folder;
                            continue;
                        }
                        if (mqextFolder == null && folder.startsWith("<mqext>")) {
                            mqextFolder = folder;
                            continue;
                        }
                        if (mqpsFolder != null || !folder.startsWith("<mqps>")) continue;
                        mqpsFolder = folder;
                    }
                }
                pos += header.getStrucLength();
                encoding = header.getEncoding();
                previousCcsid = ccsid;
                ccsid = header.getCodedCharSetId();
                formatLong = header.getFormatLong(cp);
                mqheader = formatLong & 0xFFFFFF0000000000L;
            }
            this.encodingFromLastHeaderBeforeBody = encoding;
            this.ccsidFromLastHeaderBeforeBody = ccsid;
            this.formatFromLastHeaderBeforeBody = header.getFormat();
            if (Trace.isOn) {
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshal", "constructProviderMessageFromRFH2(int)", (Object)"All of the headers have been processed");
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshal", "constructProviderMessageFromRFH2(int)", (Object)("Format of last header in message: " + this.formatFromLastHeaderBeforeBody));
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshal", "constructProviderMessageFromRFH2(int)", (Object)("CCSID of message body: " + this.ccsidFromLastHeaderBeforeBody));
                Trace.data(this, "c.i.m.c.w.internal.messages.WMQReceiveMarshal", "constructProviderMessageFromRFH2(int)", (Object)("Encoding of message body: " + this.formatFromLastHeaderBeforeBody));
            }
            String fallbackMessageClass = null;
            fallbackMessageClass = formatLong == 5571325835654209568L || formatLong == -3109486074469007296L ? "jms_text" : "jms_bytes";
            String forcedMessageClass = null;
            if (messageBodyStyle == 1) {
                forcedMessageClass = "jms_bytes";
            }
            if (mcdFolder != null) {
                this.providerMessage = WMQMessage._parseMcdFolder(mcdFolder, fallbackMessageClass, forcedMessageClass);
            } else if (forcedMessageClass == null) {
                if (pos >= this.getSafeBufferEnd()) {
                    this.providerMessage = new WMQNullMessage();
                    this.providerMessage.isNullMessage = true;
                } else if (formatLong == 5571325835654209568L || formatLong == -3109486074469007296L) {
                    this.providerMessage = new WMQTextMessage();
                    this.providerMessage.isNullMessage = false;
                } else {
                    this.providerMessage = new WMQBytesMessage();
                }
            } else if (forcedMessageClass.equals("jms_bytes")) {
                this.providerMessage = new WMQBytesMessage();
            }
            if (jmsFolder != null) {
                boolean persistenceFromMD = WMQMarshalUtils.getPersistenceFromMD(this.owner);
                this.providerMessage._parseJmsFolder(jmsFolder, persistenceFromMD);
                jmsFolderParsed = true;
            }
            if (usrFolder != null) {
                this.providerMessage._parseUsrFolder(usrFolder);
            }
            if (mqextFolder != null) {
                this.providerMessage._parseMQExtFolder(mqextFolder);
            }
            if (mqpsFolder != null) {
                this.providerMessage._parseMQPsFolder(mqpsFolder);
            }
            if (!jmsFolderParsed) {
                this.providerMessage.setJMSDeliveryMode(-3);
            }
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "constructProviderMessageFromRFH2(int)", e);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1000", null));
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "constructProviderMessageFromRFH2(int)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "constructProviderMessageFromRFH2(int)", new Integer(pos));
        }
        return pos;
    }

    private WMQMessage createProviderMessage(boolean createHeadersOnly) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "createProviderMessage(boolean)", new Object[]{new Boolean(createHeadersOnly)});
        }
        int messageBodyStyle = this.destination.getIntProperty("messageBody");
        int currentOffset = this.constructProviderMessageFromProperties(messageBodyStyle);
        this.updateProviderMessageFromMQMD();
        if (!createHeadersOnly) {
            this.addBodyToProviderMessage(currentOffset, messageBodyStyle);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "createProviderMessage(boolean)", this.providerMessage);
        }
        return this.providerMessage;
    }

    private void addBodyToProviderMessage(int currentOffset, int messageBodyStyle) throws JMSException {
        HashMap<String, Integer> info;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "addBodyToProviderMessage(int,int)", new Object[]{new Integer(currentOffset), new Integer(messageBodyStyle)});
        }
        int offsetForBody = -1;
        int ccsidForBody = 0;
        int encodingForBody = 0;
        String formatForBody = null;
        String charSetForBody = null;
        switch (messageBodyStyle) {
            case 0: 
            case 2: {
                ccsidForBody = this.ccsidFromLastHeaderBeforeBody;
                encodingForBody = this.encodingFromLastHeaderBeforeBody;
                formatForBody = this.formatFromLastHeaderBeforeBody;
                charSetForBody = WMQUtils.getCharacterSetString(this.env, ccsidForBody, encodingForBody);
                offsetForBody = currentOffset;
                break;
            }
            case 1: {
                ccsidForBody = this.mqmd.getCodedCharSetId();
                encodingForBody = this.mqmd.getEncoding();
                formatForBody = this.mqmd.getFormat();
                charSetForBody = WMQUtils.getCharacterSetString(this.env, ccsidForBody, encodingForBody);
                offsetForBody = this.bufferStart;
                break;
            }
            default: {
                info = new HashMap<String, Integer>();
                info.put("messageBody", new Integer(messageBodyStyle));
                Trace.ffst(this, "addBodyToProviderMessage(int,int)", "XN00K001", info, JMSException.class);
            }
        }
        if (offsetForBody < 0 || offsetForBody > this.getSafeBufferEnd()) {
            info = new HashMap();
            info.put("offsetForBody", new Integer(offsetForBody));
            Trace.ffst(this, "addBodyToProviderMessage(int,int)", "XN00K002", info, JMSException.class);
        }
        this.providerMessage._importBody(this.buffer, offsetForBody, this.bufferEnd, encodingForBody, charSetForBody);
        if (ccsidForBody > 0) {
            this.providerMessage.setStringProperty("JMS_IBM_Character_Set", charSetForBody);
        } else if (Trace.isOn) {
            Trace.data(this, "addBodyToProviderMessage(int,int)", "Unexpected value for ccsidForBody", (Object)new Integer(ccsidForBody));
        }
        this.providerMessage.setIntProperty("JMS_IBM_Encoding", encodingForBody);
        if (encodingForBody <= 0 && Trace.isOn) {
            Trace.data(this, "addBodyToProviderMessage(int,int)", "Unexpected value for encodingForBody", (Object)new Integer(encodingForBody));
        }
        if (formatForBody != null) {
            this.providerMessage.setStringProperty("JMS_IBM_Format", formatForBody);
        } else if (Trace.isOn) {
            Trace.data(this, "addBodyToProviderMessage(int,int)", "formatForBody is null", (Object)formatForBody);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "addBodyToProviderMessage(int,int)");
        }
    }

    public WMQMessage exportProviderMessage(boolean exportHeadersOnly) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "exportProviderMessage(boolean)", new Object[]{new Boolean(exportHeadersOnly)});
        }
        if (!this.imported) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "exportProviderMessage()", null, 1);
            }
            return null;
        }
        this.createProviderMessage(exportHeadersOnly);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "exportProviderMessage(boolean)", this.providerMessage, 2);
        }
        return this.providerMessage;
    }

    protected int getSafeBufferEnd() {
        int end = this.bufferEnd == -1 ? this.buffer.length : this.bufferEnd;
        return end;
    }

    public void importMQMDMesageBuffer(WMQConsumerOwner anOwner, WMQDestination destination, MQMD mqmd, ByteBuffer buffer, int dataStart, int dataEnd) {
        HashMap<String, Object> info;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "importMQMDMesageBuffer(WMQConsumerOwner,WMQDestination,MQMD,ByteBuffer,int,int)", new Object[]{anOwner, destination, mqmd, buffer, new Integer(dataStart), new Integer(dataEnd)});
        }
        if (anOwner == null || mqmd == null || buffer == null || destination == null) {
            info = new HashMap<String, Object>();
            info.put("anOwner", anOwner);
            info.put("mqmd", mqmd);
            info.put("buffer", buffer);
            info.put("destination", destination);
            Trace.ffst(this, "importMQMDMesageBuffer(WMQConsumerOwner,WMQDestination,MQMD,ByteBuffer,int,int)", "XN006001", info, null);
        }
        if (dataEnd != -1 && dataEnd < dataStart) {
            info = new HashMap();
            info.put("start", new Integer(dataStart));
            info.put("end", new Integer(dataEnd));
            Trace.ffst(this, "importMQMDMesageBuffer(WMQConsumerOwner,WMQDestination,MQMD,ByteBuffer,int,int)", "XN006002", info, null);
        }
        this.resetReceiveState();
        this.imported = true;
        this.owner = anOwner;
        this.destination = destination;
        this.mqmd = mqmd;
        this.buffer = buffer.array();
        this.bufferStart = dataStart;
        this.bufferEnd = dataEnd;
        this.env = this.owner.getJmqiEnvironment();
        if (this.env == null) {
            Trace.ffst(this, "importMQMDMesageBuffer(WMQConsumerOwner,WMQDestination,MQMD,ByteBuffer,int,int)", "XN00K003", null, null);
        }
        if (Trace.isOn) {
            Trace.data(this, "importMQMDMesageBuffer(WMQConsumerOwner,WMQDestination,MQMD,ByteBuffer,int,int)", "Imported/received buffer", (Object)buffer);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "importMQMDMesageBuffer(WMQConsumerOwner,WMQDestination,MQMD,ByteBuffer,int,int)");
        }
    }

    private void resetReceiveState() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "resetReceiveState()");
        }
        this.resetState();
        this.buffer = null;
        this.bufferStart = 0;
        this.bufferEnd = -1;
        this.hasMessageProperties = false;
        this.encodingFromLastHeaderBeforeBody = 0;
        this.ccsidFromLastHeaderBeforeBody = 0;
        this.formatFromLastHeaderBeforeBody = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "resetReceiveState()");
        }
    }

    private void updateFromMQMDReport(String reportProperty, int fullReport, int mask) throws JMSException {
        int reportSubset;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "updateFromMQMDReport(String,int,int)", new Object[]{reportProperty, new Integer(fullReport), new Integer(mask)});
        }
        if ((reportSubset = fullReport & mask) != 0) {
            this.providerMessage.setIntProperty(reportProperty, reportSubset);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "updateFromMQMDReport(String,int,int)");
        }
    }

    protected void updateProviderMessageFromMQMD() throws JMSException {
        int msgFlags;
        String mqmdReplyToQ;
        String replyToURI;
        boolean noReplyTo;
        int backoutCount;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "updateProviderMessageFromMQMD()");
        }
        super.updateProviderMessageFromMQMD();
        if (this.providerMessage.getJMSCorrelationID() == null) {
            byte[] cid = this.mqmd.getCorrelId();
            if (cid != null) {
                this.providerMessage.setJMSCorrelationIDAsBytes(cid);
            } else if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "byte[] value for MQMD.CorrelId is null", (Object)cid);
            }
        }
        if (this.providerMessage.getJMSTimestamp() == 0L) {
            String putTimeString = this.mqmd.getPutTime();
            String putDateString = this.mqmd.getPutDate();
            if (putTimeString != null && !putTimeString.trim().equals("") && putDateString != null && !putDateString.trim().equals("")) {
                long putTime = this.getMQPutDateTimeMs(putTimeString, putDateString);
                this.providerMessage.setJMSTimestamp(putTime);
            } else if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "String value for MQMD.PutTime is null or empty", (Object)putTimeString);
            }
        }
        if (this.providerMessage.getJMSExpiration() == 0L) {
            int expiry = this.mqmd.getExpiry();
            if (expiry > 0) {
                this.providerMessage.setJMSExpiration(System.currentTimeMillis() + (long)expiry * 100L);
            } else if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "Unexpected value for MQMD.Expiry", (Object)new Integer(expiry));
            }
        }
        if ((backoutCount = this.mqmd.getBackoutCount()) > 0) {
            this.providerMessage.setJMSRedelivered(true);
        }
        this.providerMessage.setIntProperty("JMSXDeliveryCount", backoutCount + 1);
        int replyToStyle = this.destination.getIntProperty("XMSC_WMQ_REPLYTO_STYLE");
        boolean goWithMD = false;
        if (replyToStyle == 0 && this.defaultReplyToStyle == 1 || replyToStyle == 1) {
            goWithMD = true;
        }
        boolean bl = noReplyTo = (replyToURI = this.providerMessage.getJMSReplyToAsString()) == null;
        if (Trace.isOn) {
            Trace.data(this, "updateProviderMessageFromMQMD()", "ReplyTo not set from RFH2", (Object)new Boolean(noReplyTo));
        }
        String string = mqmdReplyToQ = (mqmdReplyToQ = this.mqmd.getReplyToQ()) != null ? mqmdReplyToQ.trim() : null;
        if (Trace.isOn) {
            Trace.data(this, "updateProviderMessageFromMQMD()", "String value for MQMD.ReplyTo", (Object)mqmdReplyToQ);
        }
        if (goWithMD && mqmdReplyToQ != null && !mqmdReplyToQ.equals("")) {
            String mqmdReplyToQMgr = this.mqmd.getReplyToQMgr();
            String string2 = mqmdReplyToQMgr = mqmdReplyToQMgr == null ? "" : mqmdReplyToQMgr.trim();
            if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "String value for MQMD.ReplyToQMgr", (Object)mqmdReplyToQMgr);
            }
            StringBuffer newReplyToURI = new StringBuffer("queue://");
            newReplyToURI.append(mqmdReplyToQMgr).append("/").append(mqmdReplyToQ);
            String replyToParamters = null;
            if (replyToURI != null) {
                int positionOfQuestionMark = replyToURI.indexOf(63);
                if (positionOfQuestionMark > 0) {
                    replyToParamters = replyToURI.substring(positionOfQuestionMark);
                }
            } else {
                boolean targetClientMatching = true;
                WMQCommonConnection connection = this.owner.getConnection();
                if (connection != null) {
                    targetClientMatching = connection.getBooleanProperty("XMSC_WMQ_TARGET_CLIENT_MATCHING");
                }
                if (!this.hasMessageProperties && targetClientMatching) {
                    if (Trace.isOn) {
                        Trace.data(this, "updateProviderMessageFromMQMD()", "Messages sent to ReplyTo will not contain RFH2 header", null);
                    }
                    replyToParamters = "?targetClient=1";
                }
            }
            if (replyToParamters != null) {
                newReplyToURI.append(replyToParamters);
            }
            this.providerMessage.setJMSReplyToAsString(newReplyToURI.toString());
        }
        int msgType = this.mqmd.getMsgType();
        this.providerMessage.setIntProperty("JMS_IBM_MsgType", msgType);
        int feedback = this.mqmd.getFeedback();
        if (feedback != 0) {
            this.providerMessage.setIntProperty("JMS_IBM_Feedback", feedback);
        } else if (Trace.isOn) {
            Trace.data(this, "updateProviderMessageFromMQMD()", "Numeric value for MQMD.Feedback is MQFB_NONE", (Object)new Integer(feedback));
        }
        int report = this.mqmd.getReport();
        if (report != 0) {
            this.updateFromMQMDReport("JMS_IBM_Report_Exception", report, 0x7000000);
            this.updateFromMQMDReport("JMS_IBM_Report_Expiration", report, 0xE00000);
            this.updateFromMQMDReport("JMS_IBM_Report_COA", report, 1792);
            this.updateFromMQMDReport("JMS_IBM_Report_COD", report, 14336);
            this.updateFromMQMDReport("JMS_IBM_Report_PAN", report, 1);
            this.updateFromMQMDReport("JMS_IBM_Report_NAN", report, 2);
            this.updateFromMQMDReport("JMS_IBM_Report_Pass_Msg_ID", report, 128);
            this.updateFromMQMDReport("JMS_IBM_Report_Pass_Correl_ID", report, 64);
            this.updateFromMQMDReport("JMS_IBM_Report_Discard_Msg", report, 0x8000000);
        }
        if ((msgFlags = this.mqmd.getMsgFlags()) != 0) {
            if ((msgFlags & 0x10) != 0) {
                this.providerMessage.setBooleanProperty("JMS_IBM_Last_Msg_In_Group", true);
            }
        } else if (Trace.isOn) {
            Trace.data(this, "updateProviderMessageFromMQMD()", "Numeric value for MQMD.MsgFlags is MQMF_NONE", (Object)new Integer(msgFlags));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "updateProviderMessageFromMQMD()");
        }
    }

    private long getMQPutDateTimeMs(String putTime, String putDate) {
        long msValue;
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "getMQPutDateTimeMs(String,String)", new Object[]{putTime, putDate});
            }
            msValue = 0L;
            this.putMsCalendar.clear();
            try {
                this.putMsCalendar.set(Integer.parseInt(putDate.substring(0, 4)), Integer.parseInt(putDate.substring(4, 6)) - 1, Integer.parseInt(putDate.substring(6, 8)), Integer.parseInt(putTime.substring(0, 2)), Integer.parseInt(putTime.substring(2, 4)), Integer.parseInt(putTime.substring(4, 6)));
                msValue = this.putMsCalendar.getTimeInMillis() + (long)(Integer.parseInt(putTime.substring(6, 8)) * 10);
            }
            catch (NumberFormatException e) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "getMQPutDateTimeMs(String,String)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "getMQPutDateTimeMs(String,String)", new Long(msValue));
        }
        return msValue;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQReceiveMarshal.java, jmscc.wmq, k701, k701-112-140304  1.14.1.7 12/06/06 19:52:15");
        }
        cachedJmqiCodepage1 = null;
        cachedJmqiCodepage2 = null;
        cachedCcsid1 = -1;
        cachedCcsid2 = -1;
    }
}

