/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.HashMap;
import javax.jms.JMSException;

class WMQRFH2FolderParser {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26         (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQRFH2FolderParser.java, jmscc.wmq, k701, k701-112-140304 1.2.1.1 09/08/17 08:43:27";
    private String folder;
    private String folderName;
    private boolean isEndTag;
    private int startTag;
    private int endTag;
    private int startFolderNameStartPosition;
    private int startFolderNameEndPosition;
    private int startAttrNameStartPosition;
    private int startAttrNameEndPosition;
    private int endFolderNameStartPosition;
    private int endFolderNameEndPosition;
    private int endAttrNameStartPosition;
    private int endAttrNameEndPosition;

    public void setFolder(String in, String expectedFolderName) throws JMSException {
        if (in == null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("expectedFolderName", expectedFolderName);
            Trace.ffst(this, "setFolder(String, String)", "XN00R001", info, JMSException.class);
        }
        this.folder = in;
        this.isEndTag = this.nextTag(0);
        if (this.isEndTag) {
            this.throwBadRFH2Exception();
        } else {
            this.startFolderNameStartPosition = this.startTag;
            this.startFolderNameEndPosition = this.endTag;
        }
        this.folderName = this.getTagName(this.startFolderNameStartPosition, this.startFolderNameEndPosition);
        if (!expectedFolderName.equals(this.folderName)) {
            if (Trace.isOn) {
                Trace.data(this, "throwBadRFH2Exception()", "Unexpected folder name " + this.folderName + ", expected = ", (Object)expectedFolderName);
            }
            this.throwBadRFH2Exception();
        }
        this.isEndTag = this.nextTag(this.startFolderNameEndPosition);
    }

    public boolean hasNext() throws JMSException {
        if (!this.isEndTag) {
            return true;
        }
        this.endFolderNameStartPosition = this.startTag;
        this.endFolderNameEndPosition = this.endTag;
        String endFolderName = this.getEndTagName(this.endFolderNameStartPosition, this.endFolderNameEndPosition);
        if (!this.folderName.equals(endFolderName)) {
            if (Trace.isOn) {
                Trace.data(this, "throwBadRFH2Exception()", "Unexpected end folder name " + endFolderName + ", expected = ", (Object)this.folderName);
            }
            this.throwBadRFH2Exception();
        }
        return false;
    }

    public String getNextElement() throws JMSException {
        this.startAttrNameStartPosition = this.startTag;
        this.startAttrNameEndPosition = this.endTag;
        this.isEndTag = this.nextTag(this.startAttrNameEndPosition);
        if (this.isEndTag) {
            this.endAttrNameStartPosition = this.startTag;
            this.endAttrNameEndPosition = this.endTag;
        } else {
            this.throwBadRFH2Exception();
        }
        String tagName = this.getTagName(this.startAttrNameStartPosition, this.startAttrNameEndPosition);
        String endTagName = this.getEndTagName(this.endAttrNameStartPosition, this.endAttrNameEndPosition);
        if (!tagName.equals(endTagName)) {
            this.throwBadRFH2Exception();
        }
        this.isEndTag = this.nextTag(this.endAttrNameEndPosition);
        if (Trace.isOn) {
            Trace.data(this, "getNextElement()", "Element = ", (Object)tagName);
        }
        return tagName;
    }

    public String getElementValue() throws JMSException {
        String valueName = this.getValueName(this.startAttrNameEndPosition, this.endAttrNameStartPosition);
        this.isEndTag = this.nextTag(this.endAttrNameEndPosition);
        if (Trace.isOn) {
            Trace.data(this, "getElementValue()", "Value = ", (Object)valueName);
        }
        return valueName;
    }

    private boolean nextTag(int position) throws JMSException {
        this.startTag = this.folder.indexOf(60, position);
        if (this.startTag < 0) {
            this.throwBadRFH2Exception();
        }
        this.endTag = this.folder.indexOf(62, this.startTag);
        if (this.endTag < 0) {
            this.throwBadRFH2Exception();
        }
        return this.folder.charAt(this.startTag + 1) == '/';
    }

    private String getTagName(int startpos, int endpos) {
        int spacePosition = this.folder.indexOf(32, startpos);
        int endPosition = spacePosition < 0 ? endpos : Math.min(endpos, spacePosition);
        int length = endPosition - startpos;
        return this.folder.substring(startpos + 1, startpos + length);
    }

    private String getEndTagName(int startpos, int endpos) {
        int spacePosition = this.folder.indexOf(32, startpos);
        int endPosition = spacePosition < 0 ? endpos : Math.min(endpos, spacePosition);
        int length = endPosition - startpos;
        return this.folder.substring(startpos + 2, startpos + length);
    }

    private String getValueName(int startPosition, int endPosition) {
        return this.folder.substring(startPosition + 1, endPosition);
    }

    private void throwBadRFH2Exception() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "throwBadRFH2Exception()", "Folder = ", (Object)this.folder);
        }
        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1050", null));
        throw je;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQRFH2FolderParser", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQRFH2FolderParser.java, jmscc.wmq, k701, k701-112-140304  1.2.1.1 09/08/17 08:43:27");
        }
    }
}

