/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderObjectMessage;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import javax.jms.JMSException;

public class WMQObjectMessage
extends WMQMessage
implements ProviderObjectMessage {
    private static final long serialVersionUID = 8504626642994004178L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQObjectMessage.java, jmscc.wmq, k701, k701-112-140304 1.2.1.2 12/06/06 19:59:32";
    private int dataEnd = -1;
    private int dataStart = 0;
    private byte[] objBytes = null;

    public WMQObjectMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "<init>()");
        }
        this.messageClass = "jms_object";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "<init>()");
        }
    }

    public byte[] _exportBody(int encoding, String characterSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "_exportBody(int,String)", new Object[]{new Integer(encoding), characterSet});
        }
        if (this.dataStart != 0 || this.dataEnd != -1) {
            this.objBytes = WMQUtils.computeNewBytesFromBytes(this.objBytes, this.dataStart, this.dataEnd);
            this.dataStart = 0;
            this.dataEnd = -1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "_exportBody(int,String)", this.objBytes);
        }
        return this.objBytes;
    }

    public void _importBody(byte[] input, int startIndex, int endIndex, int encoding, String cSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "_importBody(byte [ ],int,int,int,String)", new Object[]{input, new Integer(startIndex), new Integer(endIndex), new Integer(encoding), cSet});
        }
        this.objBytes = WMQUtils.computeNewBytesFromBytes(input, startIndex, endIndex);
        this.dataStart = 0;
        this.dataEnd = -1;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "_importBody(byte [ ],int,int,int,String)");
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "clearBody()");
        }
        this.objBytes = null;
        this.dataStart = 0;
        this.dataEnd = -1;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "clearBody()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSerializedObject() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "getSerializedObject()");
        }
        try {
            if (this.dataStart == 0 && this.dataEnd == -1) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "getSerializedObject()", this.objBytes, 1);
                }
                byte[] byArray = this.objBytes;
                return byArray;
            }
            byte[] result = this._exportBody(0, "");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "getSerializedObject()", result, 2);
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "getSerializedObject()");
            }
        }
    }

    public void setSerializedObject(byte[] objectBytes) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "setSerializedObject(byte [ ])", "setter", objectBytes);
        }
        this.objBytes = objectBytes;
        this.dataStart = 0;
        this.dataEnd = -1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQObjectMessage.java, jmscc.wmq, k701, k701-112-140304  1.2.1.2 12/06/06 19:59:32");
        }
    }
}

