/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.mq.jmqi.system.zrfp.Constants;
import com.ibm.mq.jmqi.system.zrfp.Triplet;
import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.Utils;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.HashMap;
import javax.jms.JMSException;

abstract class WMQMessageUtils {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMessageUtils.java, jmscc.wmq, k701, k701-112-140304 1.4.1.2 13/08/28 15:37:39";
    static final HashMap datatypeElements;
    static final HashMap datatypeForTriplets;
    static final HashMap datatypeNameToNumber;
    static final String BOOLEAN_ID = "boolean";
    static final String BYTEARRAY_ID = "bin.hex";
    static final String CHAR_ID = "char";
    static final String BYTE_ID = "i1";
    static final String SHORT_ID = "i2";
    static final String INT_ID = "i4";
    static final String INT_GENERIC_ID = "int";
    static final String LONG_ID = "i8";
    static final String FLOAT_ID = "r4";
    static final String DOUBLE_ID = "r8";
    static final String STRING_ID = "";
    static final int RFH2_DT_BOOLEAN = 1;
    static final int RFH2_DT_BYTEARRAY = 2;
    static final int RFH2_DT_CHAR = 3;
    static final int RFH2_DT_I1 = 4;
    static final int RFH2_DT_I2 = 5;
    static final int RFH2_DT_I4 = 6;
    static final int RFH2_DT_I8 = 7;
    static final int RFH2_DT_INT = 7;
    static final int RFH2_DT_R4 = 8;
    static final int RFH2_DT_R8 = 9;
    static final int RFH2_DT_STRING = 10;
    static final String MCD_CLASS_BYTES = "<mcd><Msd>jms_bytes</Msd></mcd>";
    static final String MCD_CLASS_MAP = "<mcd><Msd>jms_map</Msd></mcd>";
    static final String MCD_CLASS_NONE = "<mcd><Msd>jms_none</Msd></mcd>";
    static final String MCD_CLASS_OBJECT = "<mcd><Msd>jms_object</Msd></mcd>";
    static final String MCD_CLASS_STREAM = "<mcd><Msd>jms_stream</Msd></mcd>";
    static final String MCD_CLASS_TEXT = "<mcd><Msd>jms_text</Msd></mcd>";
    static final String MCD_CLASS_TEXT_NULL_MSG = "<mcd><Msd>jms_text</Msd><msgbody xsi:nil=\"true\"></msgbody></mcd>";
    static final String MCD_CLASS_TEXT_NULL_MSG_SINGLE_QUOTES = "<mcd><Msd>jms_text</Msd><msgbody xsi:nil='true'></msgbody></mcd>";
    static final String NULL_MSG_BODY = "<msgbody xsi:nil=\"true\"></msgbody>";
    static final Triplet TRIPLET_MCD_CLASS_BYTES;
    static final Triplet TRIPLET_MCD_CLASS_MAP;
    static final Triplet TRIPLET_MCD_CLASS_NONE;
    static final Triplet TRIPLET_MCD_CLASS_OBJECT;
    static final Triplet TRIPLET_MCD_CLASS_STREAM;
    static final Triplet TRIPLET_MCD_CLASS_TEXT;
    static final Triplet TRIPLET_MCD_CLASS_TEXT_NULL_MSG;

    WMQMessageUtils() {
    }

    static void backReference(StringBuffer sb, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils", "backReference(StringBuffer,String)", new Object[]{sb, string});
        }
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if ('<' == ch) {
                sb.append("&lt;");
                continue;
            }
            if ('>' == ch) {
                sb.append("&gt;");
                continue;
            }
            if ('&' == ch) {
                sb.append("&amp;");
                continue;
            }
            if ('\"' == ch) {
                sb.append("&quot;");
                continue;
            }
            if ('\'' == ch) {
                sb.append("&apos;");
                continue;
            }
            if ('\ud800' <= ch && ch < '\udc00') {
                int next;
                if (i + 1 >= string.length()) {
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_INSERT_CHARACTER", Integer.toHexString(ch) + " ?");
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1053", inserts));
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils", "backReference(StringBuffer,String)", je, 1);
                    }
                    throw je;
                }
                if (56320 > (next = string.charAt(++i)) || next >= 57344) {
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_INSERT_CHARACTER", Integer.toHexString(ch) + " " + Integer.toHexString(next));
                    JMSException je2 = (JMSException)((Object)NLSServices.createException("JMSCMQ1053", inserts));
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils", "backReference(StringBuffer,String)", je2, 2);
                    }
                    throw je2;
                }
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                sb.append("&#x");
                sb.append(Integer.toHexString(next));
                sb.append(";");
                continue;
            }
            sb.append(ch);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils", "backReference(StringBuffer,String)");
        }
    }

    static Object deformatTypedElement(int datatype, String value) throws JMSException {
        Object result = null;
        switch (datatype) {
            case 10: {
                if (value == null) {
                    result = null;
                    break;
                }
                result = WMQMessageUtils.expandRefs(value);
                break;
            }
            case 6: {
                try {
                    result = new Integer(value);
                    break;
                }
                catch (NumberFormatException e) {
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0008", null));
                    throw je;
                }
            }
            case 1: {
                if (value.equals("1")) {
                    result = new Boolean(true);
                    break;
                }
                if (value.equals("0")) {
                    result = new Boolean(false);
                    break;
                }
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0008", null));
                throw je;
            }
            case 2: {
                if (value.length() == 0) {
                    result = new byte[0];
                    break;
                }
                try {
                    result = Utils.hexToBytes(value);
                    break;
                }
                catch (CSIException e) {
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_INSERT_HEX_STRING", value);
                    JMSException je2 = (JMSException)((Object)NLSServices.createException("JMSCMQ1044", inserts));
                    throw je2;
                }
            }
            case 5: {
                try {
                    result = new Short(value);
                    break;
                }
                catch (NumberFormatException e) {
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0008", null));
                    throw je;
                }
            }
            case 7: {
                try {
                    result = new Long(value);
                    break;
                }
                catch (NumberFormatException e) {
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0008", null));
                    throw je;
                }
            }
            case 8: {
                try {
                    result = new Float(value);
                    break;
                }
                catch (NumberFormatException e) {
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0008", null));
                    throw je;
                }
            }
            case 9: {
                try {
                    result = new Double(value);
                    break;
                }
                catch (NumberFormatException e) {
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0008", null));
                    throw je;
                }
            }
            case 3: {
                result = new Character(WMQMessageUtils.expandRefs(value).charAt(0));
                break;
            }
            case 4: {
                try {
                    result = new Byte(value);
                    break;
                }
                catch (NumberFormatException e) {
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0008", null));
                    throw je;
                }
            }
            default: {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("info", "Unexpected RFH2 datatype numeric code.");
                info.put("datatype", new Integer(datatype));
                Trace.ffst("WMQMessageUtils", "deformatTypedElement(int,String)", "XN00Q001", info, JMSException.class);
            }
        }
        if (Trace.isOn) {
            Trace.data("WMQMessageUtils", "deformatTypedElement(int,String)", "De-formatted object", result);
        }
        return result;
    }

    static Object deformatElement(String datatype, String value) throws JMSException {
        char openingQuote = datatype.charAt(0);
        if (openingQuote != '\'' && openingQuote != '\"') {
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0008", null));
            throw je;
        }
        String type = datatype.substring(1, datatype.indexOf(openingQuote, 1));
        Object lookup = datatypeNameToNumber.get(type);
        if (lookup == null) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_TYPE", type);
            JMSException je2 = (JMSException)((Object)NLSServices.createException("JMSCMQ1056", inserts));
            throw je2;
        }
        int numType = (Integer)lookup;
        return WMQMessageUtils.deformatTypedElement(numType, value);
    }

    private static String expandRefs(String input) throws JMSException {
        if (input.length() == 0) {
            String result = STRING_ID;
            return result;
        }
        if (input.indexOf(38) == -1) {
            return input;
        }
        StringBuffer sb = new StringBuffer(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if ('&' == ch) {
                String entity = input.substring(i + 1, i + 4);
                if (entity.equals("lt;")) {
                    sb.append('<');
                    i += 3;
                    continue;
                }
                if (entity.equals("gt;")) {
                    sb.append('>');
                    i += 3;
                    continue;
                }
                if (input.substring(i + 1, i + 5).equals("amp;")) {
                    sb.append("&");
                    i += 4;
                    continue;
                }
                if (input.substring(i + 1, i + 6).equals("apos;")) {
                    sb.append("'");
                    i += 5;
                    continue;
                }
                if (input.substring(i + 1, i + 6).equals("quot;")) {
                    sb.append('\"');
                    i += 5;
                    continue;
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_STRING", "&" + entity);
                JMSException je2 = (JMSException)((Object)NLSServices.createException("JMSCMQ1054", inserts));
                throw je2;
            }
            sb.append(ch);
        }
        String result = sb.toString();
        return result;
    }

    static void formatElement(String name, Object value, StringBuffer buffer) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils", "formatElement(String,Object,StringBuffer)", new Object[]{name, value, buffer});
        }
        buffer.append("<");
        buffer.append(name);
        if (value == null) {
            buffer.append(" xsi:nil='true'>");
            buffer.append("</");
            buffer.append(name);
            buffer.append(">");
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils", "formatElement(String,Object,StringBuffer)");
            }
            return;
        }
        String type = (String)datatypeElements.get(value.getClass());
        if (type != STRING_ID) {
            buffer.append(" dt='" + type + "'");
        }
        buffer.append(">");
        if (value instanceof byte[]) {
            buffer.append(Utils.bytesToHex((byte[])value).toString());
        } else if (value instanceof Boolean) {
            if (((Boolean)value).equals(Boolean.TRUE)) {
                buffer.append("1");
            } else {
                buffer.append("0");
            }
        } else if (value instanceof String) {
            WMQMessageUtils.backReference(buffer, (String)value);
        } else if (value instanceof Character) {
            WMQMessageUtils.backReference(buffer, ((Character)value).toString());
        } else {
            buffer.append(value);
        }
        buffer.append("</");
        buffer.append(name);
        buffer.append(">");
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils", "formatElement(String,Object,StringBuffer)");
        }
    }

    static void formatElement(String name, String type, String value, StringBuffer buffer) throws JMSException {
        buffer.append("<");
        buffer.append(name);
        if (type != STRING_ID) {
            buffer.append(" dt=" + type);
        }
        buffer.append(">");
        buffer.append(value);
        buffer.append("</");
        buffer.append(name);
        buffer.append(">");
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMessageUtils.java, jmscc.wmq, k701, k701-112-140304  1.4.1.2 13/08/28 15:37:39");
        }
        datatypeElements = new HashMap(10);
        datatypeForTriplets = new HashMap(10);
        datatypeNameToNumber = new HashMap(10);
        TRIPLET_MCD_CLASS_BYTES = new Triplet("mcd", 1);
        TRIPLET_MCD_CLASS_MAP = new Triplet("mcd", 1);
        TRIPLET_MCD_CLASS_NONE = new Triplet("mcd", 1);
        TRIPLET_MCD_CLASS_OBJECT = new Triplet("mcd", 1);
        TRIPLET_MCD_CLASS_STREAM = new Triplet("mcd", 1);
        TRIPLET_MCD_CLASS_TEXT = new Triplet("mcd", 1);
        TRIPLET_MCD_CLASS_TEXT_NULL_MSG = new Triplet("mcd", 2);
        datatypeElements.put(Boolean.class, BOOLEAN_ID);
        datatypeElements.put(Byte.class, BYTE_ID);
        datatypeElements.put([B.class, BYTEARRAY_ID);
        datatypeElements.put(Character.class, CHAR_ID);
        datatypeElements.put(Short.class, SHORT_ID);
        datatypeElements.put(Integer.class, INT_ID);
        datatypeElements.put(Long.class, LONG_ID);
        datatypeElements.put(Float.class, FLOAT_ID);
        datatypeElements.put(Double.class, DOUBLE_ID);
        datatypeElements.put(String.class, STRING_ID);
        datatypeNameToNumber.put(BOOLEAN_ID, new Integer(1));
        datatypeNameToNumber.put(BYTE_ID, new Integer(4));
        datatypeNameToNumber.put(BYTEARRAY_ID, new Integer(2));
        datatypeNameToNumber.put(CHAR_ID, new Integer(3));
        datatypeNameToNumber.put(SHORT_ID, new Integer(5));
        datatypeNameToNumber.put(INT_ID, new Integer(6));
        datatypeNameToNumber.put(INT_GENERIC_ID, new Integer(7));
        datatypeNameToNumber.put(LONG_ID, new Integer(7));
        datatypeNameToNumber.put(FLOAT_ID, new Integer(8));
        datatypeNameToNumber.put(DOUBLE_ID, new Integer(9));
        datatypeNameToNumber.put("string", new Integer(10));
        datatypeForTriplets.put(Boolean.class, Constants.TYPE_BOOLEAN);
        datatypeForTriplets.put(Byte.class, Constants.TYPE_INT8);
        datatypeForTriplets.put([B.class, Constants.TYPE_BYTE_STRING);
        datatypeForTriplets.put(Character.class, Constants.TYPE_INT16);
        datatypeForTriplets.put(Short.class, Constants.TYPE_INT16);
        datatypeForTriplets.put(Integer.class, Constants.TYPE_INT32);
        datatypeForTriplets.put(Long.class, Constants.TYPE_INT64);
        datatypeForTriplets.put(Float.class, Constants.TYPE_FLOAT32);
        datatypeForTriplets.put(Double.class, Constants.TYPE_FLOAT64);
        datatypeForTriplets.put(String.class, Constants.TYPE_STRING);
        TRIPLET_MCD_CLASS_BYTES.add("Msd", "jms_bytes");
        TRIPLET_MCD_CLASS_MAP.add("Msd", "jms_map");
        TRIPLET_MCD_CLASS_NONE.add("Msd", "jms_none");
        TRIPLET_MCD_CLASS_OBJECT.add("Msd", "jms_object");
        TRIPLET_MCD_CLASS_STREAM.add("Msd", "jms_stream");
        TRIPLET_MCD_CLASS_TEXT.add("Msd", "jms_text");
        TRIPLET_MCD_CLASS_TEXT_NULL_MSG.add("Msd", "jms_text");
        TRIPLET_MCD_CLASS_TEXT_NULL_MSG.add("msgbody", null, Constants.TYPE_NULL);
    }
}

