/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessageProps;
import java.util.Arrays;
import java.util.HashMap;
import javax.jms.JMSException;

abstract class WMQMessageHeader
extends WMQMessageProps {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26         (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMessageHeader.java, jmscc.wmq, k701, k701-112-140304 1.4.1.1 09/08/17 08:42:38";
    private static final int DEFAULT_DELIVERY_MODE = 2;
    private static final long DEFAULT_EXPIRATION = 0L;
    private static final int DEFAULT_PRIORITY = 4;
    private static final boolean DEFAULT_REDELIVERED = false;
    private static final long DEFAULT_TIMESTAMP = 0L;
    private static final byte[] DEFAULT_CORRELID_BYTES;
    private int jmsDeliveryMode = 2;
    private int jmsPriority = 4;
    private long jmsExpiration = 0L;
    private long jmsTimestamp = 0L;
    private boolean jmsRedelivered = false;
    private String jmsMessageID = null;
    private String jmsDestinationAsString = null;
    private String jmsReplyToAsString = null;
    private String jmsType = null;
    private String jmsCorrelationID = null;
    private byte[] jmsCorrelationIDAsBytes = null;
    protected String messageClass = "jms_none";
    protected String jmsType_Domain = null;
    protected String jmsType_Format = null;
    protected String jmsType_Set = null;
    protected String jmsType_Type = null;
    protected boolean hideDeliveryMode = false;

    WMQMessageHeader() {
    }

    public String getJMSCorrelationID() throws JMSException {
        if (this.jmsCorrelationID == null && this.jmsCorrelationIDAsBytes != null && !Arrays.equals(this.jmsCorrelationIDAsBytes, DEFAULT_CORRELID_BYTES)) {
            this.jmsCorrelationID = WMQUtils.idToString(this.jmsCorrelationIDAsBytes);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSCorrelationID()", "getter", this.jmsCorrelationID);
        }
        return this.jmsCorrelationID;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (this.jmsCorrelationIDAsBytes == null && this.jmsCorrelationID != null) {
            this.jmsCorrelationIDAsBytes = WMQUtils.computeBytesFromText(this.jmsCorrelationID, "UTF-8");
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSCorrelationIDAsBytes()", "getter", this.jmsCorrelationIDAsBytes);
        }
        return this.jmsCorrelationIDAsBytes;
    }

    public Integer getJMSDeliveryMode() throws JMSException {
        Integer dm = new Integer(this.jmsDeliveryMode);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSDeliveryMode()", "getter", dm);
        }
        return dm;
    }

    public String getJMSDestinationAsString() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSDestinationAsString()", "getter", this.jmsDestinationAsString);
        }
        return this.jmsDestinationAsString;
    }

    public Long getJMSExpiration() throws JMSException {
        Long exp = new Long(this.jmsExpiration);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSExpiration()", "getter", exp);
        }
        return exp;
    }

    public String getJMSMessageID() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSMessageID()", "getter", this.jmsMessageID);
        }
        return this.jmsMessageID;
    }

    public Integer getJMSPriority() throws JMSException {
        Integer pri = new Integer(this.jmsPriority);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSPriority()", "getter", pri);
        }
        return pri;
    }

    public Boolean getJMSRedelivered() throws JMSException {
        Boolean redelivered = new Boolean(this.jmsRedelivered);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSRedelivered()", "getter", redelivered);
        }
        return redelivered;
    }

    public String getJMSReplyToAsString() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSReplyToAsString()", "getter", this.jmsReplyToAsString);
        }
        return this.jmsReplyToAsString;
    }

    public Long getJMSTimestamp() throws JMSException {
        Long ts = new Long(this.jmsTimestamp);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSTimestamp()", "getter", ts);
        }
        return ts;
    }

    public String getJMSType() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "getJMSType()", "getter", this.jmsType);
        }
        return this.jmsType;
    }

    public void setJMSCorrelationID(String correlID) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSCorrelationID(String)", new Object[]{correlID});
        }
        if (correlID == null) {
            this.jmsCorrelationID = null;
            this.jmsCorrelationIDAsBytes = null;
        } else {
            this.jmsCorrelationIDAsBytes = (byte[])(correlID.startsWith("ID:") ? WMQUtils.stringToId(correlID) : null);
        }
        this.jmsCorrelationID = correlID;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSCorrelationID(String)");
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlIDBytes) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSCorrelationIDAsBytes(byte [ ])", new Object[]{correlIDBytes});
        }
        if (correlIDBytes == null) {
            this.jmsCorrelationIDAsBytes = null;
            this.jmsCorrelationID = null;
        } else {
            this.jmsCorrelationIDAsBytes = new byte[correlIDBytes.length];
            System.arraycopy(correlIDBytes, 0, this.jmsCorrelationIDAsBytes, 0, correlIDBytes.length);
            this.jmsCorrelationID = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSCorrelationIDAsBytes(byte [ ])");
        }
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSDeliveryMode(int)", "setter", new Integer(deliveryMode));
        }
        if (deliveryMode == -2) {
            this.jmsDeliveryMode = 2;
            this.hideDeliveryMode = true;
        } else if (deliveryMode == -3) {
            this.jmsDeliveryMode = -2;
            this.hideDeliveryMode = true;
        } else {
            this.jmsDeliveryMode = deliveryMode;
            this.hideDeliveryMode = false;
        }
    }

    public void setJMSDestinationAsString(String newDestinationAsString) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSDestinationAsString(String)", "setter", newDestinationAsString);
        }
        this.jmsDestinationAsString = newDestinationAsString;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSExpiration(long)", "setter", new Long(expiration));
        }
        this.jmsExpiration = expiration;
    }

    public void setJMSMessageID(String messageID) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSMessageID(String)", "setter", messageID);
        }
        this.jmsMessageID = messageID;
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSPriority(int)", "setter", new Integer(priority));
        }
        this.jmsPriority = priority;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSRedelivered(boolean)", "setter", redelivered);
        }
        this.jmsRedelivered = redelivered;
    }

    public void setJMSReplyToAsString(String newReplyToAsString) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSReplyToAsString(String)", "setter", newReplyToAsString);
        }
        this.jmsReplyToAsString = newReplyToAsString;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSTimestamp(long)", "setter", new Long(timestamp));
        }
        this.jmsTimestamp = timestamp;
    }

    public void setJMSType(String type) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSType(String)", new Object[]{type});
        }
        this.jmsType = type;
        if (type == null || !type.startsWith("mcd://")) {
            this.jmsType_Domain = null;
            this.jmsType_Set = null;
            this.jmsType_Type = null;
            this.jmsType_Format = null;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSType(String)", 1);
            }
            return;
        }
        if (!"jms_text".equals(this.messageClass) && !"jms_bytes".equals(this.messageClass)) {
            this.throwBadJMSTypeException(type);
        }
        String msDomain = null;
        String msSet = null;
        String msType = null;
        String msFormat = null;
        int index = 6;
        int query = type.indexOf(63, index);
        String path = query == -1 ? type : type.substring(0, query);
        int separator = path.indexOf(47, index);
        if (separator == -1) {
            if (path.length() <= 6) {
                this.throwBadJMSTypeException(type);
            }
            msDomain = path.substring(index);
        } else {
            if (separator == index) {
                this.throwBadJMSTypeException(type);
            }
            msDomain = path.substring(index, separator);
            index = separator + 1;
            if ((separator = path.indexOf(47, index)) == -1) {
                msSet = path.substring(index);
            } else {
                msSet = path.substring(index, separator);
                index = separator + 1;
                msType = path.substring(index);
            }
        }
        if (query > 0) {
            if (type.regionMatches(true, query, "?format=", 0, 8)) {
                msFormat = type.substring(query + 8);
                if (msFormat.indexOf(38) != -1) {
                    this.throwBadJMSTypeException(type);
                }
            } else {
                this.throwBadJMSTypeException(type);
            }
        }
        this.jmsType_Domain = msDomain;
        this.jmsType_Set = msSet;
        this.jmsType_Type = msType;
        this.jmsType_Format = msFormat;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "setJMSType(String)", 2);
        }
    }

    private void throwBadJMSTypeException(String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "throwBadJMSTypeException(String)", new Object[]{value});
        }
        HashMap<String, String> inserts = new HashMap<String, String>();
        inserts.put("XMSC_INSERT_PROPERTY", "JMSType");
        inserts.put("XMSC_INSERT_VALUE", value);
        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1006", inserts));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "throwBadJMSTypeException(String)", je);
        }
        throw je;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMessageHeader.java, jmscc.wmq, k701, k701-112-140304  1.4.1.1 09/08/17 08:42:38");
        }
        DEFAULT_CORRELID_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }
}

