/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.mq.jmqi.system.zrfp.Constants;
import com.ibm.mq.jmqi.system.zrfp.Triplet;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessageHeader;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQNullMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQObjectMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQRFH2FolderParser;
import com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQTextMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.JMSException;

abstract class WMQMessageBase
extends WMQMessageHeader {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26         (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMessageBase.java, jmscc.wmq, k701, k701-112-140304 1.17.1.8 13/08/28 15:21:48";
    boolean isNullMessage = true;
    private WMQRFH2FolderParser rfh2FolderParser = null;

    WMQMessageBase() {
    }

    static WMQMessage _parseMcdFolder(String s, String fbClass, String forcedMessageClass) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseMcdFolder(String,String,String)", new Object[]{s, fbClass, forcedMessageClass});
        }
        WMQMessage newMessage = null;
        if (forcedMessageClass == null) {
            boolean fastpath = false;
            String folder = s.trim();
            if (folder.equals("<mcd><Msd>jms_text</Msd></mcd>")) {
                newMessage = new WMQTextMessage();
                newMessage.isNullMessage = false;
                fastpath = true;
            } else if (folder.equals("<mcd><Msd>jms_bytes</Msd></mcd>")) {
                newMessage = new WMQBytesMessage();
                fastpath = true;
            } else if (folder.equals("<mcd><Msd>jms_none</Msd></mcd>")) {
                newMessage = new WMQNullMessage();
                fastpath = true;
            } else if (folder.equals("<mcd><Msd>jms_map</Msd></mcd>")) {
                newMessage = new WMQMapMessage();
                fastpath = true;
            } else if (folder.equals("<mcd><Msd>jms_stream</Msd></mcd>")) {
                newMessage = new WMQStreamMessage();
                fastpath = true;
            } else if (folder.equals("<mcd><Msd>jms_object</Msd></mcd>")) {
                newMessage = new WMQObjectMessage();
                fastpath = true;
            } else if (folder.equals("<mcd><Msd>jms_text</Msd><msgbody xsi:nil=\"true\"></msgbody></mcd>")) {
                newMessage = new WMQTextMessage();
                newMessage.isNullMessage = true;
                fastpath = true;
            } else if (folder.equals("<mcd><Msd>jms_text</Msd><msgbody xsi:nil='true'></msgbody></mcd>")) {
                newMessage = new WMQTextMessage();
                newMessage.isNullMessage = true;
                fastpath = true;
            }
            if (fastpath) {
                if (Trace.isOn) {
                    Trace.data("com.ibm.msg.client.wmq.internal.messages.WMQMessageBase", "_parseMcdFolder(String,String,String)", "Computed message type on the fastpath", (Object)newMessage);
                }
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseMcdFolder(String,String,String)", newMessage, 1);
                }
                return newMessage;
            }
        }
        String jmsType = null;
        String msDomain = null;
        String msSet = null;
        String msFormat = null;
        boolean isNullMsgFlag = false;
        StringTokenizer strtok = new StringTokenizer(s, "<>");
        if (!strtok.nextToken().startsWith("mcd")) {
            WMQMessageBase.throwBadRFH2Exception();
        }
        String name = strtok.nextToken();
        while (!name.equals("/mcd")) {
            String token;
            boolean assumingTypeEmpty = false;
            boolean msgbodyField = false;
            String value = strtok.nextToken();
            if (name.startsWith("msgbody")) {
                msgbodyField = true;
                if (name.indexOf("xsi:nil=\"true\"") != -1) {
                    isNullMsgFlag = true;
                }
                if (name.indexOf("xsi:nil='true'") != -1) {
                    isNullMsgFlag = true;
                }
            } else if (name.startsWith("Msd")) {
                if (forcedMessageClass == null) {
                    if (value.equals("jms_none")) {
                        newMessage = new WMQNullMessage();
                    } else if (value.equals("jms_text")) {
                        newMessage = new WMQTextMessage();
                        newMessage.isNullMessage = false;
                    } else if (value.equals("jms_bytes")) {
                        newMessage = new WMQBytesMessage();
                    } else if (value.equals("jms_map")) {
                        newMessage = new WMQMapMessage();
                    } else if (value.equals("jms_stream")) {
                        newMessage = new WMQStreamMessage();
                    } else if (value.equals("jms_object")) {
                        newMessage = new WMQObjectMessage();
                    } else {
                        if (value.equals("/Msd")) {
                            assumingTypeEmpty = true;
                        } else {
                            msDomain = value;
                        }
                        if (fbClass.equals("jms_text")) {
                            newMessage = new WMQTextMessage();
                            newMessage.isNullMessage = false;
                            if (assumingTypeEmpty) {
                                msDomain = "jms_text";
                            }
                        } else if (fbClass.equals("jms_bytes")) {
                            newMessage = new WMQBytesMessage();
                            if (assumingTypeEmpty) {
                                msDomain = "jms_bytes";
                            }
                        } else {
                            WMQMessageBase.throwBadRFH2Exception();
                        }
                    }
                } else {
                    if (value.equals("/Msd")) {
                        assumingTypeEmpty = true;
                    }
                    if (forcedMessageClass.equals("jms_bytes")) {
                        newMessage = new WMQBytesMessage();
                        if (assumingTypeEmpty) {
                            msDomain = "jms_bytes";
                        }
                    }
                }
            } else if (name.startsWith("Type")) {
                if (value.equals("/Type")) {
                    jmsType = "";
                    assumingTypeEmpty = true;
                } else {
                    jmsType = value;
                }
            } else if (name.startsWith("Set")) {
                if (value.equals("/Set")) {
                    msSet = "";
                    assumingTypeEmpty = true;
                } else {
                    msSet = value;
                }
            } else if (name.startsWith("Fmt")) {
                if (value.equals("/Fmt")) {
                    msFormat = "";
                    assumingTypeEmpty = true;
                } else {
                    msFormat = value;
                }
            }
            if (msgbodyField) {
                if (name.charAt(name.length() - 1) == '/') {
                    assumingTypeEmpty = true;
                    token = value;
                } else if (value.equals("/msgbody")) {
                    assumingTypeEmpty = true;
                    token = strtok.nextToken();
                } else {
                    token = strtok.nextToken();
                }
            } else {
                token = strtok.nextToken();
            }
            if (assumingTypeEmpty) {
                if (token.equals("/Type") || token.equals("/Set") || token.equals("/Fmt")) {
                    if (token.equals("/Type")) {
                        jmsType = value;
                    } else if (token.equals("/Set")) {
                        msSet = value;
                    } else if (token.equals("/Fmt")) {
                        msFormat = value;
                    }
                    name = strtok.nextToken();
                    continue;
                }
                name = token;
                continue;
            }
            if (token.charAt(0) != '/') {
                WMQMessageBase.throwBadRFH2Exception();
            }
            name = strtok.nextToken();
        }
        if (newMessage == null) {
            if (forcedMessageClass != null && forcedMessageClass.equals("jms_bytes")) {
                newMessage = new WMQBytesMessage();
            } else if (fbClass != null) {
                if (fbClass.equals("jms_text")) {
                    newMessage = new WMQTextMessage();
                    newMessage.isNullMessage = false;
                } else if (fbClass.equals("jms_bytes")) {
                    newMessage = new WMQBytesMessage();
                } else {
                    if (Trace.isOn) {
                        Trace.traceData("com.ibm.msg.client.wmq.internal.messages.WMQMessageBase", "_parseMcdFolder(String,String,String)", "No Msd, and fbClass not defined as text or bytes type. fbClass is ", (Object)fbClass);
                    }
                    WMQMessageBase.throwBadRFH2Exception();
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData("com.ibm.msg.client.wmq.internal.messages.WMQMessageBase", "_parseMcdFolder(String,String,String)", "Unknown message type: no Msd, forcedMessageClass or fbClass declared", null);
                }
                WMQMessageBase.throwBadRFH2Exception();
            }
        }
        if (msDomain != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("mcd://");
            sb.append(msDomain);
            if (msSet != null) {
                sb.append('/');
                sb.append(msSet);
            }
            if (jmsType != null) {
                if (msSet == null) {
                    sb.append('/');
                }
                sb.append('/');
                sb.append(jmsType);
            }
            if (msFormat != null) {
                sb.append("?format=");
                sb.append(msFormat);
            }
            newMessage.setJMSType(sb.toString());
        } else if (jmsType != null) {
            newMessage.setJMSType((String)WMQMessageUtils.deformatTypedElement(10, jmsType));
        }
        newMessage.isNullMessage = isNullMsgFlag;
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseMcdFolder(String,String,String)", newMessage, 2);
        }
        return newMessage;
    }

    static WMQMessage setTripletMcd(Triplet mcdTriplet, String fbClass, String forcedMessageClass) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletMcd(Triplet,String,String)", new Object[]{mcdTriplet, fbClass, forcedMessageClass});
        }
        int size = mcdTriplet.size();
        if (!"mcd".equals(mcdTriplet.getLabel()) || size == 0) {
            WMQMessageBase.throwMsgCreateErrorException();
        }
        WMQMessage newMessage = null;
        if (forcedMessageClass == null && mcdTriplet.getKey(0).equals("Msd")) {
            boolean fastpath = false;
            String msdValue = (String)mcdTriplet.getValue(0);
            if (size == 1) {
                if (msdValue.equals("jms_text")) {
                    newMessage = new WMQTextMessage();
                    newMessage.isNullMessage = false;
                    fastpath = true;
                } else if (msdValue.equals("jms_bytes")) {
                    newMessage = new WMQBytesMessage();
                    fastpath = true;
                } else if (msdValue.equals("jms_none")) {
                    newMessage = new WMQNullMessage();
                    fastpath = true;
                } else if (msdValue.equals("jms_map")) {
                    newMessage = new WMQMapMessage();
                    fastpath = true;
                } else if (msdValue.equals("jms_stream")) {
                    newMessage = new WMQStreamMessage();
                    fastpath = true;
                } else if (msdValue.equals("jms_object")) {
                    newMessage = new WMQObjectMessage();
                    fastpath = true;
                }
            } else if (size == 2) {
                String secondKey = mcdTriplet.getKey(1);
                int secondType = mcdTriplet.getType(1);
                if (msdValue.equals("jms_text") && secondKey.equals("msgbody") && secondType == 9) {
                    newMessage = new WMQTextMessage();
                    newMessage.isNullMessage = true;
                    fastpath = true;
                }
            }
            if (fastpath) {
                if (Trace.isOn) {
                    Trace.data("com.ibm.msg.client.wmq.internal.messages.WMQMessageBase", "setTripletMcd(Triplet,String,String)", "Computed message type on the fastpath", (Object)newMessage);
                }
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletMcd(Triplet,String,String)", newMessage, 1);
                }
                return newMessage;
            }
        }
        String msdValue = null;
        String setValue = null;
        String typeValue = null;
        String fmtValue = null;
        boolean nullMsgBody = false;
        for (int i = 0; i < size; ++i) {
            String key = mcdTriplet.getKey(i);
            int type = mcdTriplet.getType(i);
            if (type == 0) {
                String value = (String)mcdTriplet.getValue(i);
                if (key == null) {
                    WMQMessageBase.throwInvalidTripletException(mcdTriplet);
                }
                char index = key.charAt(0);
                switch (index) {
                    case 'M': {
                        if (!key.equals("Msd")) break;
                        msdValue = value;
                        break;
                    }
                    case 'S': {
                        if (!key.equals("Set")) break;
                        setValue = value;
                        break;
                    }
                    case 'T': {
                        if (!key.equals("Type")) break;
                        typeValue = value;
                        break;
                    }
                    case 'F': {
                        if (!key.equals("Fmt")) break;
                        fmtValue = value;
                    }
                }
                continue;
            }
            if (type != 9) continue;
            if (key == null) {
                WMQMessageBase.throwInvalidTripletException(mcdTriplet);
            }
            if (!key.equals("msgbody")) continue;
            nullMsgBody = true;
        }
        String domainValue = null;
        if (msdValue != null) {
            if (forcedMessageClass == null) {
                if (msdValue.equals("jms_text")) {
                    newMessage = new WMQTextMessage();
                } else if (msdValue.equals("jms_bytes")) {
                    newMessage = new WMQBytesMessage();
                } else if (msdValue.equals("jms_none")) {
                    newMessage = new WMQNullMessage();
                } else if (msdValue.equals("jms_map")) {
                    newMessage = new WMQMapMessage();
                } else if (msdValue.equals("jms_stream")) {
                    newMessage = new WMQStreamMessage();
                } else if (msdValue.equals("jms_object")) {
                    newMessage = new WMQObjectMessage();
                } else {
                    domainValue = msdValue;
                    if (fbClass.equals("jms_text")) {
                        newMessage = new WMQTextMessage();
                    } else if (fbClass.equals("jms_bytes")) {
                        newMessage = new WMQBytesMessage();
                    } else {
                        WMQMessageBase.throwInvalidTripletException(mcdTriplet);
                    }
                }
            } else if (forcedMessageClass.equals("jms_bytes")) {
                newMessage = new WMQBytesMessage();
            }
        } else if (forcedMessageClass != null && forcedMessageClass.equals("jms_bytes")) {
            newMessage = new WMQBytesMessage();
        } else if (fbClass != null) {
            if (fbClass.equals("jms_text")) {
                newMessage = new WMQTextMessage();
                newMessage.isNullMessage = false;
            } else if (fbClass.equals("jms_bytes")) {
                newMessage = new WMQBytesMessage();
            } else {
                if (Trace.isOn) {
                    Trace.traceData("com.ibm.msg.client.wmq.internal.messages.WMQMessageBase", "setTripletMcd(Triplet,String,String)", "No Msd, and fbClass not defined as text or bytes type. fbClass is ", (Object)fbClass);
                }
                WMQMessageBase.throwInvalidTripletException(mcdTriplet);
            }
        } else {
            if (Trace.isOn) {
                Trace.traceData("com.ibm.msg.client.wmq.internal.messages.WMQMessageBase", "setTripletMcd(Triplet,String,String)", "Unknown message type: no Msd, forcedMessageClass or fbClass declared", null);
            }
            WMQMessageBase.throwInvalidTripletException(mcdTriplet);
        }
        if (domainValue != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("mcd://");
            sb.append(domainValue);
            if (setValue != null) {
                sb.append('/');
                sb.append(setValue);
            }
            if (typeValue != null) {
                if (setValue == null) {
                    sb.append('/');
                }
                sb.append('/');
                sb.append(typeValue);
            }
            if (fmtValue != null) {
                sb.append("?format=");
                sb.append(fmtValue);
            }
            newMessage.setJMSType(sb.toString());
        } else if (typeValue != null) {
            newMessage.setJMSType(typeValue);
        }
        newMessage.isNullMessage = nullMsgBody;
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletMcd(Triplet,String,String)", newMessage, 2);
        }
        return newMessage;
    }

    String _getJmsFolder(boolean persistenceFromMD) throws JMSException {
        StringBuffer rfhstr;
        block16: {
            Object jmsxGroupId;
            int priority;
            String correlationId;
            long expiration;
            long timestamp;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_getJmsFolder(boolean)", new Object[]{persistenceFromMD});
            }
            rfhstr = new StringBuffer(100);
            rfhstr.append("<jms>");
            String destinationAsString = this.getJMSDestinationAsString();
            if (destinationAsString == null) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("info", "jmsDestinationAsString is null");
                info.put("persistenceFromMD", persistenceFromMD);
                Trace.ffst(this, "_getJmsFolder(boolean)", "XN003001", info, JMSException.class);
            }
            WMQMessageUtils.formatElement("Dst", destinationAsString, rfhstr);
            String rToString = this.getJMSReplyToAsString();
            if (rToString != null) {
                WMQMessageUtils.formatElement("Rto", rToString, rfhstr);
            }
            if ((timestamp = this.getJMSTimestamp().longValue()) != 0L) {
                rfhstr.append("<Tms>");
                rfhstr.append(String.valueOf(timestamp));
                rfhstr.append("</Tms>");
            }
            if ((expiration = this.getJMSExpiration().longValue()) != 0L) {
                rfhstr.append("<Exp>");
                rfhstr.append(String.valueOf(expiration));
                rfhstr.append("</Exp>");
            }
            if ((correlationId = this.getJMSCorrelationID()) != null && !correlationId.startsWith("ID:")) {
                WMQMessageUtils.formatElement("Cid", correlationId, rfhstr);
            }
            if ((priority = this.getJMSPriority().intValue()) != 4) {
                rfhstr.append("<Pri>");
                rfhstr.append(priority);
                rfhstr.append("</Pri>");
            }
            int deliveryMode = this.getJMSDeliveryMode();
            if (!persistenceFromMD && !this.hideDeliveryMode || persistenceFromMD && deliveryMode != 2) {
                rfhstr.append("<Dlv>");
                rfhstr.append(deliveryMode);
                rfhstr.append("</Dlv>");
            }
            if (this.propertyExists("JMS_IBM_ConnectionID")) {
                String connectionID = this.getStringProperty("JMS_IBM_ConnectionID");
                if (connectionID != null) {
                    rfhstr.append("<Uci dt='");
                    rfhstr.append("bin.hex");
                    rfhstr.append("'>");
                    rfhstr.append(connectionID);
                    rfhstr.append("</Uci>");
                } else {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("connectionID", connectionID);
                    Trace.ffst(this, "_getJmsFolder", "XM009001", info, JMSException.class);
                }
            }
            if ((jmsxGroupId = this.getObjectProperty("JMSXGroupID")) instanceof String) {
                WMQMessageUtils.formatElement("Gid", jmsxGroupId, rfhstr);
            }
            if (this.propertyExists("JMSXGroupSeq")) {
                try {
                    int jmsxGroupSeq = this.getIntProperty("JMSXGroupSeq");
                    WMQMessageUtils.formatElement("Seq", "", Integer.toString(jmsxGroupSeq), rfhstr);
                }
                catch (NumberFormatException nfe) {
                    if (!Trace.isOn) break block16;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_getJmsFolder(boolean)", nfe);
                    String groupSeqNo = this.getStringProperty("JMSXGroupSeq");
                    Trace.traceData(this, "_getJmsFolder(boolean)", "Ignoring invalid value for JMSXGroupSeq property.", (Object)groupSeqNo);
                }
            }
        }
        rfhstr.append("</jms>");
        String jmsFolder = rfhstr.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_getJmsFolder(boolean)", jmsFolder);
        }
        return jmsFolder;
    }

    Triplet getTripletJms(boolean persistenceFromMD) throws JMSException {
        Triplet jmsTriplet;
        block16: {
            Object jmsxGroupId;
            int priority;
            String correlationId;
            long expiration;
            long timestamp;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "getTripletJms(boolean)", new Object[]{persistenceFromMD});
            }
            jmsTriplet = new Triplet("jms", 10);
            String destinationAsString = this.getJMSDestinationAsString();
            if (destinationAsString == null) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("info", "jmsDestinationAsString is null");
                info.put("persistenceFromMD", persistenceFromMD);
                Trace.ffst(this, "getTripletJms(boolean)", "XM009002", info, JMSException.class);
            }
            jmsTriplet.add("Dst", destinationAsString);
            String rToString = this.getJMSReplyToAsString();
            if (rToString != null) {
                jmsTriplet.add("Rto", rToString);
            }
            if ((timestamp = this.getJMSTimestamp().longValue()) != 0L) {
                jmsTriplet.add("Tms", String.valueOf(timestamp));
            }
            if ((expiration = this.getJMSExpiration().longValue()) != 0L) {
                jmsTriplet.add("Exp", String.valueOf(expiration));
            }
            if ((correlationId = this.getJMSCorrelationID()) != null && !correlationId.startsWith("ID:")) {
                jmsTriplet.add("Cid", correlationId);
            }
            if ((priority = this.getJMSPriority().intValue()) != 4) {
                jmsTriplet.add("Pri", String.valueOf(priority));
            }
            int deliveryMode = this.getJMSDeliveryMode();
            if (!persistenceFromMD && !this.hideDeliveryMode || persistenceFromMD && deliveryMode != 2) {
                jmsTriplet.add("Dlv", String.valueOf(deliveryMode));
            }
            if (this.propertyExists("JMS_IBM_ConnectionID")) {
                String connectionID = this.getStringProperty("JMS_IBM_ConnectionID");
                if (connectionID != null) {
                    byte[] connectionIDAsBytes = WMQUtils.hexToBin(connectionID, 0);
                    jmsTriplet.add("Uci", (Object)connectionIDAsBytes, Constants.TYPE_BYTE_STRING);
                } else {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("connectionID", connectionID);
                    Trace.ffst(this, "getTripletJms", "XM009003", info, JMSException.class);
                }
            }
            if ((jmsxGroupId = this.getObjectProperty("JMSXGroupID")) instanceof String) {
                jmsTriplet.add("Gid", (String)jmsxGroupId);
            }
            if (this.propertyExists("JMSXGroupSeq")) {
                try {
                    int jmsxGroupSeq = this.getIntProperty("JMSXGroupSeq");
                    jmsTriplet.add("Seq", String.valueOf(jmsxGroupSeq));
                }
                catch (NumberFormatException nfe) {
                    if (!Trace.isOn) break block16;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "getTripletJms(boolean)", nfe);
                    String groupSeqNo = this.getStringProperty("JMSXGroupSeq");
                    Trace.traceData(this, "getTripletJms(boolean)", "Ignoring invalid value for JMSXGroupSeq property.", (Object)groupSeqNo);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "getTripletJms(boolean)", jmsTriplet);
        }
        return jmsTriplet;
    }

    String _getMcdFolder() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_getMcdFolder()");
        }
        String jmsType = this.getJMSType();
        String quickMcdFolder = null;
        if (this.jmsType_Domain == null && jmsType == null) {
            if (this.messageClass.equals("jms_text") && !this.isNullMessage) {
                quickMcdFolder = "<mcd><Msd>jms_text</Msd></mcd>";
            } else if (this.messageClass.equals("jms_text") && this.isNullMessage) {
                quickMcdFolder = "<mcd><Msd>jms_text</Msd><msgbody xsi:nil=\"true\"></msgbody></mcd>";
            } else if (this.messageClass.equals("jms_bytes")) {
                quickMcdFolder = "<mcd><Msd>jms_bytes</Msd></mcd>";
            } else if (this.messageClass.equals("jms_none")) {
                quickMcdFolder = "<mcd><Msd>jms_none</Msd></mcd>";
            } else if (this.messageClass.equals("jms_object")) {
                quickMcdFolder = "<mcd><Msd>jms_object</Msd></mcd>";
            } else if (this.messageClass.equals("jms_map")) {
                quickMcdFolder = "<mcd><Msd>jms_map</Msd></mcd>";
            } else if (this.messageClass.equals("jms_stream")) {
                quickMcdFolder = "<mcd><Msd>jms_stream</Msd></mcd>";
            } else {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("message class", this.messageClass);
                info.put("is null message", this.isNullMessage);
                Trace.ffst(this, "_getMcdFolder", "XN003002", info, JMSException.class);
            }
        }
        if (quickMcdFolder != null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_getMcdFolder()", quickMcdFolder, 1);
            }
            return quickMcdFolder;
        }
        StringBuffer rfhstr = new StringBuffer(40);
        rfhstr.append("<mcd><Msd>");
        if (this.jmsType_Domain != null) {
            rfhstr.append(this.jmsType_Domain);
            rfhstr.append("</Msd>");
            if (this.jmsType_Set != null && this.jmsType_Set.length() > 0) {
                WMQMessageUtils.formatElement("Set", this.jmsType_Set, rfhstr);
            }
            if (this.jmsType_Type != null && this.jmsType_Type.length() > 0) {
                WMQMessageUtils.formatElement("Type", this.jmsType_Type, rfhstr);
            }
            if (this.jmsType_Format != null && this.jmsType_Format.length() > 0) {
                WMQMessageUtils.formatElement("Fmt", this.jmsType_Format, rfhstr);
            }
        } else {
            rfhstr.append(this.messageClass);
            rfhstr.append("</Msd>");
            if (jmsType != null) {
                WMQMessageUtils.formatElement("Type", jmsType, rfhstr);
            }
        }
        if (this.messageClass.equals("jms_text") && this.isNullMessage) {
            rfhstr.append("<msgbody xsi:nil=\"true\"></msgbody>");
        }
        rfhstr.append("</mcd>");
        String mcdFolder = rfhstr.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_getMcdFolder()", mcdFolder, 2);
        }
        return mcdFolder;
    }

    Triplet getTripletMcd() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "getTripletMcd()");
        }
        String jmsType = this.getJMSType();
        Triplet quickMcdTriplet = null;
        if (this.jmsType_Domain == null && jmsType == null) {
            if (this.messageClass.equals("jms_text") && !this.isNullMessage) {
                quickMcdTriplet = WMQMessageUtils.TRIPLET_MCD_CLASS_TEXT;
            } else if (this.messageClass.equals("jms_text") && this.isNullMessage) {
                quickMcdTriplet = WMQMessageUtils.TRIPLET_MCD_CLASS_TEXT_NULL_MSG;
            } else if (this.messageClass.equals("jms_bytes")) {
                quickMcdTriplet = WMQMessageUtils.TRIPLET_MCD_CLASS_BYTES;
            } else if (this.messageClass.equals("jms_none")) {
                quickMcdTriplet = WMQMessageUtils.TRIPLET_MCD_CLASS_NONE;
            } else if (this.messageClass.equals("jms_object")) {
                quickMcdTriplet = WMQMessageUtils.TRIPLET_MCD_CLASS_OBJECT;
            } else if (this.messageClass.equals("jms_map")) {
                quickMcdTriplet = WMQMessageUtils.TRIPLET_MCD_CLASS_MAP;
            } else if (this.messageClass.equals("jms_stream")) {
                quickMcdTriplet = WMQMessageUtils.TRIPLET_MCD_CLASS_STREAM;
            } else {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("message class", this.messageClass);
                info.put("is null message", this.isNullMessage);
                Trace.ffst(this, "getTripletMcd", "XM009004", info, JMSException.class);
            }
        }
        if (quickMcdTriplet != null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "getTripletMcd()", quickMcdTriplet, 1);
            }
            return quickMcdTriplet;
        }
        Triplet mcdTriplet = new Triplet("mcd", 5);
        if (this.jmsType_Domain != null) {
            mcdTriplet.add("Msd", this.jmsType_Domain);
            if (this.jmsType_Set != null && this.jmsType_Set.length() > 0) {
                mcdTriplet.add("Set", this.jmsType_Set);
            }
            if (this.jmsType_Type != null && this.jmsType_Type.length() > 0) {
                mcdTriplet.add("Type", this.jmsType_Type);
            }
            if (this.jmsType_Format != null && this.jmsType_Format.length() > 0) {
                mcdTriplet.add("Fmt", this.jmsType_Format);
            }
        } else {
            mcdTriplet.add("Msd", this.messageClass);
            if (jmsType != null) {
                mcdTriplet.add("Type", jmsType);
            }
        }
        if (this.messageClass.equals("jms_text") && this.isNullMessage) {
            mcdTriplet.add("msgbody", null, Constants.TYPE_NULL);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "getTripletMcd()", mcdTriplet, 2);
        }
        return mcdTriplet;
    }

    String _getMQExtFolder() throws JMSException {
        String mqextFolder;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_getMQExtFolder()");
        }
        StringBuffer rfhstr = null;
        String armCorrelator = this.getStringProperty("JMS_IBM_ArmCorrelator");
        String wrmCorrelator = this.getStringProperty("JMS_IBM_RMCorrelator");
        if (armCorrelator != null || wrmCorrelator != null) {
            rfhstr = new StringBuffer(40);
            rfhstr.append("<mqext>");
            if (armCorrelator != null) {
                WMQMessageUtils.formatElement("Arm", armCorrelator, rfhstr);
            }
            if (wrmCorrelator != null) {
                WMQMessageUtils.formatElement("Wrm", wrmCorrelator, rfhstr);
            }
            rfhstr.append("</mqext>");
        }
        String string = mqextFolder = rfhstr != null ? rfhstr.toString() : null;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_getMQExtFolder()", mqextFolder);
        }
        return mqextFolder;
    }

    Triplet getTripletMqext() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "getTripletMqext()");
        }
        String armCorrelator = this.getStringProperty("JMS_IBM_ArmCorrelator");
        String wrmCorrelator = this.getStringProperty("JMS_IBM_RMCorrelator");
        Triplet mqextTriplet = null;
        if (armCorrelator != null || wrmCorrelator != null) {
            mqextTriplet = new Triplet("mqext", 2);
            if (armCorrelator != null) {
                mqextTriplet.add("Arm", armCorrelator);
            }
            if (wrmCorrelator != null) {
                mqextTriplet.add("Wrm", wrmCorrelator);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "getTripletMqext()", mqextTriplet);
        }
        return mqextTriplet;
    }

    String _getUsrFolder() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_getUsrFolder()");
        }
        StringBuffer rfhstr = new StringBuffer(40);
        Iterator propNames = this.properties.keySet().iterator();
        rfhstr.append("<usr>");
        while (propNames.hasNext()) {
            String name = (String)propNames.next();
            if (name.startsWith("JMS")) continue;
            Object value = this.getObjectProperty(name);
            WMQMessageUtils.formatElement(name, value, rfhstr);
        }
        rfhstr.append("</usr>");
        String usrFolder = rfhstr.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_getUsrFolder()", usrFolder);
        }
        return usrFolder;
    }

    Triplet getTripletUsr() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "getTripletUsr()");
        }
        Set propSet = this.properties.keySet();
        int size = propSet.size();
        Triplet usrTriplet = null;
        if (size > 0) {
            Iterator propNames = propSet.iterator();
            usrTriplet = new Triplet("usr", size);
            while (propNames.hasNext()) {
                String name = (String)propNames.next();
                if (name.startsWith("JMS")) continue;
                Object value = this.getObjectProperty(name);
                if (value != null) {
                    Integer type = (Integer)WMQMessageUtils.datatypeForTriplets.get(value.getClass());
                    usrTriplet.add(name, value, type);
                    continue;
                }
                usrTriplet.add(name, null, Constants.TYPE_NULL);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "getTripletUsr()", usrTriplet);
        }
        return usrTriplet;
    }

    void _parseJmsFolder(String s, boolean persistenceFromMD) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseJmsFolder(String,boolean)", new Object[]{s, persistenceFromMD});
        }
        if (this.rfh2FolderParser == null) {
            this.rfh2FolderParser = new WMQRFH2FolderParser();
        }
        this.rfh2FolderParser.setFolder(s, "jms");
        this.setJMSDeliveryMode(-3);
        while (this.rfh2FolderParser.hasNext()) {
            String tmp;
            String element = this.rfh2FolderParser.getNextElement();
            String value = this.rfh2FolderParser.getElementValue();
            if (element.equals("Dst")) {
                tmp = (String)WMQMessageUtils.deformatTypedElement(10, value);
                this.setJMSDestinationAsString(tmp);
                continue;
            }
            if (value != null && element.equals("Tms")) {
                try {
                    long timestamp = Long.parseLong(value);
                    this.setJMSTimestamp(timestamp);
                }
                catch (NumberFormatException e) {
                    if (Trace.isOn) {
                        Trace.data(this, "_parseJmsFolder(String,boolean)", "Unexpected value for Tms element in the jms folder of the RFH2", (Object)value);
                    }
                    WMQMessageBase.throwBadRFH2Exception();
                }
                continue;
            }
            if (value != null && element.equals("Dlv") && !persistenceFromMD) {
                if (value.equals("1")) {
                    this.setJMSDeliveryMode(1);
                    continue;
                }
                if (value.equals("2")) {
                    this.setJMSDeliveryMode(2);
                    continue;
                }
                try {
                    int deliveryMode = Integer.parseInt(value);
                    this.setJMSDeliveryMode(deliveryMode);
                }
                catch (NumberFormatException e) {
                    if (Trace.isOn) {
                        Trace.data(this, "_parseJmsFolder(String,boolean)", "Unexpected value for Dlv element in the jms folder of the RFH2", (Object)value);
                    }
                    WMQMessageBase.throwBadRFH2Exception();
                }
                continue;
            }
            if (element.equals("Rto")) {
                tmp = (String)WMQMessageUtils.deformatTypedElement(10, value);
                this.setJMSReplyToAsString(tmp);
                continue;
            }
            if (value != null && element.equals("Exp")) {
                try {
                    long expiration = Long.parseLong(value);
                    this.setJMSExpiration(expiration);
                }
                catch (NumberFormatException e) {
                    if (Trace.isOn) {
                        Trace.data(this, "_parseJmsFolder(String,boolean)", "Unexpected value for Exp element in the jms folder of the RFH2", (Object)value);
                    }
                    WMQMessageBase.throwBadRFH2Exception();
                }
                continue;
            }
            if (element.equals("Cid")) {
                this.setJMSCorrelationID((String)WMQMessageUtils.deformatTypedElement(10, value));
                continue;
            }
            if (element.equals("Uci")) {
                if (value != null && value.length() == 48) {
                    this.setStringProperty("JMS_IBM_ConnectionID", value);
                    continue;
                }
                if (Trace.isOn) {
                    Trace.data(this, "_parseJmsFolder(String,boolean)", "Unexpected value for Uci element in the jms folder of the RFH2", (Object)value);
                }
                WMQMessageBase.throwBadRFH2Exception();
                continue;
            }
            if (element.equals("Gid")) {
                this.setObjectProperty("JMSXGroupID", WMQMessageUtils.deformatTypedElement(10, value));
                continue;
            }
            if (!element.equals("Seq")) continue;
            try {
                this.setObjectProperty("JMSXGroupSeq", WMQMessageUtils.deformatTypedElement(6, value));
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.data(this, "_parseJmsFolder(String,boolean)", "Unexpected value for Seq element in the jms folder of the RFH2", (Object)value);
                }
                WMQMessageBase.throwBadRFH2Exception();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseJmsFolder(String,boolean)");
        }
    }

    void setTripletJms(Triplet jmsTriplet, boolean persistenceFromMD) throws JMSException {
        int size;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletJms(Triplet,boolean)", new Object[]{jmsTriplet, persistenceFromMD});
        }
        if (!"jms".equals(jmsTriplet.getLabel())) {
            WMQMessageBase.throwMsgCreateErrorException();
        }
        if ((size = jmsTriplet.size()) == 0) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletJms(Triplet,boolean)");
            }
            return;
        }
        Object dstValue = null;
        Object rtoValue = null;
        Object tmsValue = null;
        Object expValue = null;
        Object cidValue = null;
        Object dlvValue = null;
        Object gidValue = null;
        Object seqValue = null;
        Object uciValue = null;
        for (int i = 0; i < size; ++i) {
            Object value;
            String key = jmsTriplet.getKey(i);
            int type = jmsTriplet.getType(i);
            if (type == 0) {
                value = (String)jmsTriplet.getValue(i);
                if (key == null || value == null) {
                    WMQMessageBase.throwInvalidTripletException(jmsTriplet);
                }
                char index = key.charAt(0);
                switch (index) {
                    case 'D': {
                        if (key.equals("Dst")) {
                            dstValue = value;
                            break;
                        }
                        if (!key.equals("Dlv")) break;
                        dlvValue = value;
                        break;
                    }
                    case 'R': {
                        if (!key.equals("Rto")) break;
                        rtoValue = value;
                        break;
                    }
                    case 'T': {
                        if (!key.equals("Tms")) break;
                        tmsValue = value;
                        break;
                    }
                    case 'E': {
                        if (!key.equals("Exp")) break;
                        expValue = value;
                        break;
                    }
                    case 'C': {
                        if (!key.equals("Cid")) break;
                        cidValue = value;
                        break;
                    }
                    case 'G': {
                        if (!key.equals("Gid")) break;
                        gidValue = value;
                        break;
                    }
                    case 'S': {
                        if (!key.equals("Seq")) break;
                        seqValue = value;
                    }
                }
                continue;
            }
            if (type != 2) continue;
            value = (byte[])jmsTriplet.getValue(i);
            if (key == null || value == null) {
                WMQMessageBase.throwInvalidTripletException(jmsTriplet);
            }
            if (!key.equals("Uci")) continue;
            uciValue = value;
        }
        if (dstValue != null) {
            this.setJMSDestinationAsString((String)dstValue);
        }
        if (rtoValue != null) {
            this.setJMSReplyToAsString((String)rtoValue);
        }
        if (tmsValue != null) {
            long timestamp = Long.parseLong(tmsValue);
            this.setJMSTimestamp(timestamp);
        }
        if (expValue != null) {
            long expiration = Long.parseLong(expValue);
            this.setJMSExpiration(expiration);
        }
        if (cidValue != null) {
            this.setJMSCorrelationID((String)cidValue);
        }
        if (dlvValue != null && !persistenceFromMD) {
            if (((String)dlvValue).equals("1")) {
                this.setJMSDeliveryMode(1);
            } else if (((String)dlvValue).equals("2")) {
                this.setJMSDeliveryMode(2);
            } else {
                int deliveryMode = Integer.parseInt((String)dlvValue);
                this.setJMSDeliveryMode(deliveryMode);
            }
        }
        if (gidValue != null) {
            this.setStringProperty("JMSXGroupID", (String)gidValue);
        }
        if (seqValue != null) {
            int seq = Integer.parseInt(seqValue);
            this.setIntProperty("JMSXGroupSeq", seq);
        }
        if (uciValue != null) {
            StringBuffer sb = new StringBuffer(48);
            WMQUtils.binToHexUpperCase((byte[])uciValue, 0, (uciValue).length, sb);
            this.setStringProperty("JMS_IBM_ConnectionID", sb.toString());
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletJms(Triplet,boolean)");
        }
    }

    void _parseMQExtFolder(String s) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseMQExtFolder(String)", new Object[]{s});
        }
        if (this.rfh2FolderParser == null) {
            this.rfh2FolderParser = new WMQRFH2FolderParser();
        }
        this.rfh2FolderParser.setFolder(s, "mqext");
        while (this.rfh2FolderParser.hasNext()) {
            String element = this.rfh2FolderParser.getNextElement();
            String value = this.rfh2FolderParser.getElementValue();
            if (element.equals("Arm")) {
                String arm = (String)WMQMessageUtils.deformatTypedElement(10, value);
                this.setStringProperty("JMS_IBM_ArmCorrelator", arm);
                continue;
            }
            if (!element.equals("Wrm")) continue;
            String wrm = (String)WMQMessageUtils.deformatTypedElement(10, value);
            this.setStringProperty("JMS_IBM_RMCorrelator", wrm);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseMQExtFolder(String)");
        }
    }

    void setTripletMqext(Triplet mqextTriplet) throws JMSException {
        int size;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletMqext(Triplet)", new Object[]{mqextTriplet});
        }
        if (!"mqext".equals(mqextTriplet.getLabel())) {
            WMQMessageBase.throwMsgCreateErrorException();
        }
        if ((size = mqextTriplet.size()) == 0) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletMqext(Triplet)");
            }
            return;
        }
        String armValue = null;
        String wrmValue = null;
        block4: for (int i = 0; i < size; ++i) {
            String key = mqextTriplet.getKey(i);
            int type = mqextTriplet.getType(i);
            if (type != 0) continue;
            String value = (String)mqextTriplet.getValue(i);
            if (key == null || value == null) {
                WMQMessageBase.throwInvalidTripletException(mqextTriplet);
            }
            char index = key.charAt(0);
            switch (index) {
                case 'A': {
                    if (!key.equals("Arm")) continue block4;
                    armValue = value;
                    continue block4;
                }
                case 'W': {
                    if (!key.equals("Wrm")) continue block4;
                    wrmValue = value;
                }
            }
        }
        if (armValue != null) {
            this.setStringProperty("JMS_IBM_ArmCorrelator", armValue);
        }
        if (wrmValue != null) {
            this.setStringProperty("JMS_IBM_RMCorrelator", wrmValue);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletMqext(Triplet)");
        }
    }

    void _parseMQPsFolder(String s) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseMQPsFolder(String)", new Object[]{s});
        }
        if (this.rfh2FolderParser == null) {
            this.rfh2FolderParser = new WMQRFH2FolderParser();
        }
        this.rfh2FolderParser.setFolder(s, "mqps");
        while (this.rfh2FolderParser.hasNext()) {
            String element = this.rfh2FolderParser.getNextElement();
            String value = this.rfh2FolderParser.getElementValue();
            if (element.equals("Ret")) {
                if (!value.equals("1")) continue;
                this.setIntProperty("JMS_IBM_Retain", 1);
                continue;
            }
            if (!element.equals("Top") || this.getJMSDestinationAsString() != null) continue;
            StringBuffer jmsTopic = new StringBuffer("topic://");
            jmsTopic.append(value);
            this.setJMSDestinationAsString(jmsTopic.toString());
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseMQPsFolder(String)");
        }
    }

    void setTripletMqps(Triplet mqpsTriplet) throws JMSException {
        int size;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletMqps(Triplet)", new Object[]{mqpsTriplet});
        }
        if (!"mqps".equals(mqpsTriplet.getLabel())) {
            WMQMessageBase.throwMsgCreateErrorException();
        }
        if ((size = mqpsTriplet.size()) == 0) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletMqps(Triplet)");
            }
            return;
        }
        Boolean retValue = null;
        for (int i = 0; i < size; ++i) {
            String key = mqpsTriplet.getKey(i);
            int type = mqpsTriplet.getType(i);
            if (type != 1) continue;
            Boolean value = (Boolean)mqpsTriplet.getValue(i);
            if (key == null || value == null) {
                WMQMessageBase.throwInvalidTripletException(mqpsTriplet);
            }
            if (!key.equals("Ret")) continue;
            retValue = value;
        }
        if (retValue != null && retValue.booleanValue()) {
            this.setIntProperty("JMS_IBM_Retain", 1);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletMqps(Triplet)");
        }
    }

    void _parseUsrFolder(String s) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseUsrFolder(String)", new Object[]{s});
        }
        try {
            StringTokenizer strtok = new StringTokenizer(s, "<>");
            if (!strtok.nextToken().equals("usr")) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("strtok", strtok);
                info.put("s", s);
            }
            String name = strtok.nextToken();
            while (!name.equals("/usr")) {
                String value;
                boolean newNull = false;
                int nullIndex = 0;
                try {
                    nullIndex = name.indexOf(" xsi:nil");
                    if (nullIndex != -1) {
                        int dtindex = name.indexOf(" dt=");
                        if (dtindex != -1 && dtindex < nullIndex) {
                            nullIndex = dtindex;
                        }
                        newNull = true;
                    } else {
                        newNull = false;
                    }
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseUsrFolder(String)", e, 1);
                    }
                    newNull = false;
                }
                if (newNull) {
                    this.setObjectProperty(name.substring(0, nullIndex), null);
                    if (name.charAt(name.length() - 1) != '/') {
                        value = strtok.nextToken();
                        if (value.charAt(0) != '/') {
                            value = strtok.nextToken();
                        }
                        if (value.charAt(0) != '/') {
                            WMQMessageBase.throwBadRFH2Exception();
                        }
                    }
                } else if (!newNull) {
                    String type;
                    boolean endsWithSlash = name.charAt(name.length() - 1) == '/';
                    int index = name.indexOf(" dt=");
                    if (index != -1) {
                        type = name.substring(index + 4, name.length() - (endsWithSlash ? 1 : 0));
                        int firstSpace = name.indexOf(32);
                        name = name.substring(0, firstSpace);
                    } else {
                        if (endsWithSlash) {
                            name = name.substring(0, name.length() - 1);
                        }
                        type = "'string'";
                    }
                    if (endsWithSlash) {
                        this.setObjectProperty(name, WMQMessageUtils.deformatElement(type, ""));
                    } else {
                        String token;
                        value = strtok.nextToken();
                        if (value.startsWith('/' + name) && !value.equals('/' + name)) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "startsWith /: " + name + " Type : " + type + " value : " + value, null);
                            }
                            this.setObjectProperty(name, WMQMessageUtils.deformatElement(type, value));
                            token = strtok.nextToken();
                            if (token.charAt(0) != '/') {
                                WMQMessageBase.throwBadRFH2Exception();
                            }
                        } else if (value.startsWith('/' + name)) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "startsWith / 2 ", null);
                            }
                            this.setObjectProperty(name, WMQMessageUtils.deformatElement(type, ""));
                        } else {
                            if (Trace.isOn) {
                                Trace.traceData(this, "!!startsWith ", null);
                            }
                            this.setObjectProperty(name, WMQMessageUtils.deformatElement(type, value));
                            token = strtok.nextToken();
                            if (token.charAt(0) != '/') {
                                WMQMessageBase.throwBadRFH2Exception();
                            }
                        }
                    }
                }
                name = strtok.nextToken();
            }
        }
        catch (Exception ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseUsrFolder(String)", ex, 2);
            }
            JMSException jmsEx = (JMSException)((Object)NLSServices.createException("JMSCMQ1050", null));
            jmsEx.setLinkedException(ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseUsrFolder(String)", jmsEx);
            }
            throw jmsEx;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "_parseUsrFolder(String)");
        }
    }

    void setTripletUsr(Triplet usrTriplet) throws JMSException {
        int size;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletUsr(Triplet)", new Object[]{usrTriplet});
        }
        if (!"usr".equals(usrTriplet.getLabel())) {
            WMQMessageBase.throwMsgCreateErrorException();
        }
        if ((size = usrTriplet.size()) == 0) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletUsr(Triplet)");
            }
            return;
        }
        for (int i = 0; i < size; ++i) {
            String key = usrTriplet.getKey(i);
            Object value = usrTriplet.getValue(i);
            int type = usrTriplet.getType(i);
            if (key == null || type != 9 && value == null) {
                WMQMessageBase.throwInvalidTripletException(usrTriplet);
            }
            this.setObjectProperty(key, value);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "setTripletUsr(Triplet)");
        }
    }

    private static void throwBadRFH2Exception() throws JMSException {
        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1050", null));
        throw je;
    }

    private static void throwMsgCreateErrorException() throws JMSException {
        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1000", null));
        throw je;
    }

    private static void throwInvalidTripletException(Triplet triplet) throws JMSException {
        HashMap<String, String> inserts = new HashMap<String, String>();
        inserts.put("XMSC_INSERT_PROPERTY", triplet.getLabel());
        inserts.put("XMSC_INSERT_VALUE", triplet.toString());
        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1006", inserts));
        throw je;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQMessageBase", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMessageBase.java, jmscc.wmq, k701, k701-112-140304  1.17.1.8 13/08/28 15:21:48");
        }
    }
}

