/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.internal.JmqiTools;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.wmq.common.internal.WMQCommonConnection;
import com.ibm.msg.client.wmq.common.internal.WMQCommonSession;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import java.util.HashMap;
import javax.jms.JMSException;

abstract class WMQMarshalUtils {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMarshalUtils.java, jmscc.wmq, k701, k701-112-140304 1.7.1.3 12/05/22 09:43:54";
    static final int CCSID_UTF8 = 1208;
    static final String CHAR_SET_UTF8 = "UTF8";
    static final long MQHEADER_ASCII = 5571313378871214080L;
    static final long MQHEADER_EBCDIC = -3109515640373772288L;
    static final long MQHEADER_MASK = -1099511627776L;
    static final long MQRFH2_ASCII = 5571313732236222496L;
    static final long MQRFH2_EBCDIC = -3109514705028104128L;
    static final long MQSTR_ASCII = 5571325835654209568L;
    static final long MQSTR_EBCDIC = -3109486074469007296L;
    private static final String useInternalFormatPropertyName = "zrfp";
    private static Boolean useInternalFormatPropertyValue;

    WMQMarshalUtils() {
    }

    static boolean useInternalFormat(WMQConsumerOwner owner) {
        boolean result;
        int connectionMode;
        if (!useInternalFormatPropertyValue.booleanValue()) {
            return false;
        }
        try {
            connectionMode = owner.getIntProperty("XMSC_WMQ_CONNECTION_MODE");
        }
        catch (JMSException e) {
            return false;
        }
        switch (connectionMode) {
            case 1: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    static void overrideHeaderFromMQMDProps(ProviderDestination destination, ProviderMessage message, MQMD mqmd) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "overrideHeaderFromMQMDProps(ProviderDestination,ProviderMessage,MQMD)", new Object[]{destination, message, mqmd});
        }
        if (destination.getBooleanProperty("mdWriteEnabled")) {
            byte[] safeValue;
            int value;
            boolean mqmdV2required = false;
            if (message.propertyExists("JMS_IBM_MQMD_Report")) {
                value = message.getIntProperty("JMS_IBM_MQMD_Report");
                mqmd.setReport(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_MsgType")) {
                value = message.getIntProperty("JMS_IBM_MQMD_MsgType");
                mqmd.setMsgType(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Expiry")) {
                value = message.getIntProperty("JMS_IBM_MQMD_Expiry");
                mqmd.setExpiry(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Feedback")) {
                value = message.getIntProperty("JMS_IBM_MQMD_Feedback");
                mqmd.setFeedback(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Encoding")) {
                value = message.getIntProperty("JMS_IBM_MQMD_Encoding");
                mqmd.setEncoding(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_CodedCharSetId")) {
                value = message.getIntProperty("JMS_IBM_MQMD_CodedCharSetId");
                mqmd.setCodedCharSetId(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Format")) {
                String value2 = message.getStringProperty("JMS_IBM_MQMD_Format");
                mqmd.setFormat(value2);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Priority")) {
                int value3 = message.getIntProperty("JMS_IBM_MQMD_Priority");
                mqmd.setPriority(value3);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Persistence")) {
                int value4 = message.getIntProperty("JMS_IBM_MQMD_Persistence");
                mqmd.setPersistence(value4);
            }
            if (message.propertyExists("JMS_IBM_MQMD_MsgId")) {
                Object value5 = message.getObjectProperty("JMS_IBM_MQMD_MsgId");
                safeValue = WMQMarshalUtils.objectAsByteArray("JMS_IBM_MQMD_MsgId", value5);
                mqmd.setMsgId(safeValue);
            }
            if (message.propertyExists("JMS_IBM_MQMD_CorrelId")) {
                Object value6 = message.getObjectProperty("JMS_IBM_MQMD_CorrelId");
                safeValue = WMQMarshalUtils.objectAsByteArray("JMS_IBM_MQMD_CorrelId", value6);
                mqmd.setCorrelId(safeValue);
            }
            if (message.propertyExists("JMS_IBM_MQMD_ReplyToQ")) {
                String value7 = message.getStringProperty("JMS_IBM_MQMD_ReplyToQ");
                mqmd.setReplyToQ(value7);
            }
            if (message.propertyExists("JMS_IBM_MQMD_ReplyToQMgr")) {
                String value8 = message.getStringProperty("JMS_IBM_MQMD_ReplyToQMgr");
                mqmd.setReplyToQMgr(value8);
            }
            if (message.propertyExists("JMS_IBM_MQMD_UserIdentifier")) {
                String value9 = message.getStringProperty("JMS_IBM_MQMD_UserIdentifier");
                mqmd.setUserIdentifier(value9);
            }
            if (message.propertyExists("JMS_IBM_MQMD_AccountingToken")) {
                Object value10 = message.getObjectProperty("JMS_IBM_MQMD_AccountingToken");
                safeValue = WMQMarshalUtils.objectAsByteArray("JMS_IBM_MQMD_AccountingToken", value10);
                mqmd.setAccountingToken(safeValue);
            }
            if (message.propertyExists("JMS_IBM_MQMD_ApplIdentityData")) {
                String value11 = message.getStringProperty("JMS_IBM_MQMD_ApplIdentityData");
                mqmd.setApplIdentityData(value11);
            }
            if (message.propertyExists("JMS_IBM_MQMD_PutApplType")) {
                int value12 = message.getIntProperty("JMS_IBM_MQMD_PutApplType");
                mqmd.setPutApplType(value12);
            }
            if (message.propertyExists("JMS_IBM_MQMD_PutApplName")) {
                String value13 = message.getStringProperty("JMS_IBM_MQMD_PutApplName");
                mqmd.setPutApplName(value13);
            }
            if (message.propertyExists("JMS_IBM_MQMD_PutDate")) {
                String value14 = message.getStringProperty("JMS_IBM_MQMD_PutDate");
                mqmd.setPutDate(value14);
            }
            if (message.propertyExists("JMS_IBM_MQMD_PutTime")) {
                String value15 = message.getStringProperty("JMS_IBM_MQMD_PutTime");
                mqmd.setPutTime(value15);
            }
            if (message.propertyExists("JMS_IBM_MQMD_ApplOriginData")) {
                String value16 = message.getStringProperty("JMS_IBM_MQMD_ApplOriginData");
                mqmd.setApplOriginData(value16);
            }
            if (message.propertyExists("JMS_IBM_MQMD_GroupId")) {
                Object value17 = message.getObjectProperty("JMS_IBM_MQMD_GroupId");
                safeValue = WMQMarshalUtils.objectAsByteArray("JMS_IBM_MQMD_GroupId", value17);
                mqmd.setGroupId(safeValue);
                mqmdV2required = true;
            }
            if (message.propertyExists("JMS_IBM_MQMD_MsgSeqNumber")) {
                int value18 = message.getIntProperty("JMS_IBM_MQMD_MsgSeqNumber");
                mqmd.setMsgSeqNumber(value18);
                mqmdV2required = true;
            }
            if (message.propertyExists("JMS_IBM_MQMD_Offset")) {
                int value19 = message.getIntProperty("JMS_IBM_MQMD_Offset");
                mqmd.setOffset(value19);
                mqmdV2required = true;
            }
            if (message.propertyExists("JMS_IBM_MQMD_MsgFlags")) {
                int value20 = message.getIntProperty("JMS_IBM_MQMD_MsgFlags");
                mqmd.setMsgFlags(value20);
                mqmdV2required = true;
            }
            if (message.propertyExists("JMS_IBM_MQMD_OriginalLength")) {
                int value21 = message.getIntProperty("JMS_IBM_MQMD_OriginalLength");
                mqmd.setOriginalLength(value21);
                mqmdV2required = true;
            }
            if (mqmd.getVersion() == 1 && mqmdV2required) {
                mqmd.setVersion(2);
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "overrideHeaderFromMQMDProps(ProviderDestination,ProviderMessage,MQMD)");
        }
    }

    static void setMQMDPropsFromHeader(ProviderDestination destination, ProviderMessage message, MQMD mqmd) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "setMQMDPropsFromHeader(ProviderDestination,ProviderMessage,MQMD)", new Object[]{destination, message, mqmd});
        }
        if (destination.getBooleanProperty("mdReadEnabled")) {
            int report = mqmd.getReport();
            message.setIntProperty("JMS_IBM_MQMD_Report", report);
            int msgType = mqmd.getMsgType();
            message.setIntProperty("JMS_IBM_MQMD_MsgType", msgType);
            int expiry = mqmd.getExpiry();
            message.setIntProperty("JMS_IBM_MQMD_Expiry", expiry);
            int feedback = mqmd.getFeedback();
            message.setIntProperty("JMS_IBM_MQMD_Feedback", feedback);
            int encoding = mqmd.getEncoding();
            message.setIntProperty("JMS_IBM_MQMD_Encoding", encoding);
            int codedCharSetId = mqmd.getCodedCharSetId();
            message.setIntProperty("JMS_IBM_MQMD_CodedCharSetId", codedCharSetId);
            String format = mqmd.getFormat();
            message.setStringProperty("JMS_IBM_MQMD_Format", format);
            int priority = mqmd.getPriority();
            message.setIntProperty("JMS_IBM_MQMD_Priority", priority);
            int persistence = mqmd.getPersistence();
            message.setIntProperty("JMS_IBM_MQMD_Persistence", persistence);
            byte[] msgId = mqmd.getMsgId();
            message.setObjectProperty("JMS_IBM_MQMD_MsgId", msgId);
            byte[] correlId = mqmd.getCorrelId();
            message.setObjectProperty("JMS_IBM_MQMD_CorrelId", correlId);
            int backoutCount = mqmd.getBackoutCount();
            message.setIntProperty("JMS_IBM_MQMD_BackoutCount", backoutCount);
            String replyToQ = mqmd.getReplyToQ();
            message.setStringProperty("JMS_IBM_MQMD_ReplyToQ", replyToQ);
            String replyToQMgr = mqmd.getReplyToQMgr();
            message.setStringProperty("JMS_IBM_MQMD_ReplyToQMgr", replyToQMgr);
            String userIdentifier = mqmd.getUserIdentifier();
            message.setStringProperty("JMS_IBM_MQMD_UserIdentifier", userIdentifier);
            byte[] accountingToken = mqmd.getAccountingToken();
            message.setObjectProperty("JMS_IBM_MQMD_AccountingToken", accountingToken);
            String applIdentityData = mqmd.getApplIdentityData();
            message.setStringProperty("JMS_IBM_MQMD_ApplIdentityData", applIdentityData);
            int putApplType = mqmd.getPutApplType();
            message.setIntProperty("JMS_IBM_MQMD_PutApplType", putApplType);
            String putApplName = mqmd.getPutApplName();
            message.setStringProperty("JMS_IBM_MQMD_PutApplName", putApplName);
            String putDate = mqmd.getPutDate();
            message.setStringProperty("JMS_IBM_MQMD_PutDate", putDate);
            String putTime = mqmd.getPutTime();
            message.setStringProperty("JMS_IBM_MQMD_PutTime", putTime);
            String applOriginData = mqmd.getApplOriginData();
            message.setStringProperty("JMS_IBM_MQMD_ApplOriginData", applOriginData);
            byte[] groupId = mqmd.getGroupId();
            message.setObjectProperty("JMS_IBM_MQMD_GroupId", groupId);
            int msgSeqNumber = mqmd.getMsgSeqNumber();
            message.setIntProperty("JMS_IBM_MQMD_MsgSeqNumber", msgSeqNumber);
            int offset = mqmd.getOffset();
            message.setIntProperty("JMS_IBM_MQMD_Offset", offset);
            int msgFlags = mqmd.getMsgFlags();
            message.setIntProperty("JMS_IBM_MQMD_MsgFlags", msgFlags);
            int originalLength = mqmd.getOriginalLength();
            message.setIntProperty("JMS_IBM_MQMD_OriginalLength", originalLength);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "setMQMDPropsFromHeader(ProviderDestination,ProviderMessage,MQMD)");
        }
    }

    private static byte[] objectAsByteArray(String propName, Object object) throws JMSException {
        byte[] result = null;
        if (!(object instanceof byte[])) {
            HashMap<String, Object> inserts = new HashMap<String, Object>();
            inserts.put("XMSC_INSERT_PROPERTY", propName);
            inserts.put("XMSC_INSERT_VALUE", object);
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1006", inserts));
            throw je;
        }
        result = (byte[])object;
        return result;
    }

    static void addInfo(JmqiException e, HashMap info) {
        info.put("COMPCODE", new Integer(e.getCompCode()));
        info.put("REASON", new Integer(e.getReason()));
        String value = e.getWmqMsgExplanation();
        if (value != null) {
            info.put("MSGEXPLANATION", value);
        }
        if ((value = e.getWmqMsgSummary()) != null) {
            info.put("MSGSUMMARY", value);
        }
        if ((value = e.getWmqMsgUserResponse()) != null) {
            info.put("MSGUSERRESPONSE", value);
        }
        info.put("MSGSEVERITY", new Integer(e.getWmqMsgSeverity()));
    }

    static int getQueueManagerCcsid(WMQCommonSession session) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "getQueueManagerCcsid(WMQCommonSession)", new Object[]{session});
        }
        int ccsid = 0;
        Hconn hconn = null;
        try {
            hconn = session.getHconn();
            ccsid = hconn.getCcsid();
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "getQueueManagerCcsid(WMQCommonSession)", e);
            }
            HashMap<String, Hconn> info = new HashMap<String, Hconn>();
            info.put("HConn", hconn);
            WMQMarshalUtils.addInfo(e, info);
            Trace.ffst("WMQMarshalUtils", JmqiTools.getExSumm((Throwable)e), "XM008001", info, null);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "getQueueManagerCcsid(WMQCommonSession)", new Integer(ccsid));
        }
        return ccsid;
    }

    static void throwBadCcsidException(int ccsid) throws JMSException {
        HashMap<String, String> inserts = new HashMap<String, String>();
        inserts.put("CCSID", "ccsid:" + Integer.toString(ccsid));
        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1046", inserts));
        throw je;
    }

    static boolean getPersistenceFromMD(WMQConsumerOwner owner) {
        WMQCommonConnection connection;
        if (owner == null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("session", "<null>");
            Trace.ffst("WMQMarshalUtils", "getPersistenceFromMD()", "XN00E001", info, null);
        }
        if ((connection = owner.getConnection()) == null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("connection", "<null>");
            Trace.ffst("WMQMarshalUtils", "getPersistenceFromMD()", "XN00E002", info, null);
        }
        boolean result = connection.getPersistenceFromMD();
        return result;
    }

    static int getDefaultReplyToStyle() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "getDefaultReplyToStyle()");
        }
        int result = 1;
        String overrideReplyToStyle = PropertyStore.getStringProperty("com.ibm.mq.jms.replyToStyle");
        if (overrideReplyToStyle != null) {
            result = overrideReplyToStyle.equalsIgnoreCase("MQMD") ? 1 : (overrideReplyToStyle.equalsIgnoreCase("RFH2") ? 2 : 1);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "getDefaultReplyToStyle()", new Integer(result));
        }
        return result;
    }

    static int calculateMessageBodyCcsid(JmqiEnvironment env, WMQDestination destination, WMQMessage providerMessage) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "calculateMessageBodyCcsid(JmqiEnvironment,WMQDestination,WMQMessage)", new Object[]{env, destination, providerMessage});
        }
        int ccsid = 0;
        if (providerMessage.getStringProperty("JMS_IBM_Character_Set") != null) {
            String msgCharSet;
            block12: {
                msgCharSet = providerMessage.getStringProperty("JMS_IBM_Character_Set");
                JmqiCodepage msgCp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)env, (String)msgCharSet);
                if (msgCp != null) {
                    ccsid = msgCp.ccsid;
                } else {
                    try {
                        int num = Integer.parseInt(msgCharSet);
                        if (num > 0) {
                            ccsid = num;
                        }
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "calculateMessageBodyCcsid(JmqiEnvironment,WMQDestination,WMQMessage)", e);
                        }
                        if (!Trace.isOn) break block12;
                        Trace.data("WMQMarshalUtils", "calculateMessageBodyCcsid()", "Character set name unrecognised - got a number format exception when attemtping to interpret as a ccsid, returning default", null);
                    }
                }
            }
            if (ccsid == 0) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "JMS_IBM_Character_Set");
                inserts.put("XMSC_INSERT_VALUE", msgCharSet);
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1006", inserts));
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "calculateMessageBodyCcsid(JmqiEnvironment,WMQDestination,WMQMessage)", je);
                }
                throw je;
            }
        } else {
            ccsid = destination.getIntProperty("CCSID");
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "calculateMessageBodyCcsid(JmqiEnvironment,WMQDestination,WMQMessage)", new Integer(ccsid));
        }
        return ccsid;
    }

    static int calculateMessageBodyEncoding(WMQDestination destination, WMQMessage providerMessage) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "calculateMessageBodyEncoding(WMQDestination,WMQMessage)", new Object[]{destination, providerMessage});
        }
        int encoding = 0;
        if (providerMessage.propertyExists("JMS_IBM_Encoding")) {
            encoding = providerMessage.getIntProperty("JMS_IBM_Encoding");
        } else {
            encoding = destination.getIntProperty("encoding");
            if (encoding == 0) {
                encoding = 273;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "calculateMessageBodyEncoding(WMQDestination,WMQMessage)", new Integer(encoding));
        }
        return encoding;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMarshalUtils.java, jmscc.wmq, k701, k701-112-140304  1.7.1.3 12/05/22 09:43:54");
        }
        useInternalFormatPropertyValue = null;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "static()");
        }
        PropertyStore.register(useInternalFormatPropertyName, false);
        useInternalFormatPropertyValue = PropertyStore.getBooleanPropertyObject(useInternalFormatPropertyName);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils", "static()");
        }
    }
}

