/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.internal.JmqiDC;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.WMQCommonSession;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMarshalUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQReceiveMarshalMH;
import com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshal;
import com.ibm.msg.client.wmq.common.internal.messages.WMQSendMarshalMH;
import java.nio.ByteBuffer;
import javax.jms.JMSException;

public abstract class WMQMarshal {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMarshal.java, jmscc.wmq, k701, k701-112-140304 1.10.1.4 12/11/28 19:15:13";
    public static final String trimJMSXUserID = "com.ibm.mq.jms.trimJMSXUserID";
    protected boolean imported = false;
    protected MQMD mqmd = null;
    protected WMQMessage providerMessage = null;
    protected WMQDestination destination = null;
    protected WMQConsumerOwner owner = null;
    protected JmqiEnvironment env = null;

    public static WMQSendMarshal newSendMarshal() {
        WMQSendMarshal sendMarshal = new WMQSendMarshal();
        return sendMarshal;
    }

    public static WMQSendMarshal newSendMarshal(WMQConsumerOwner owner, boolean forceRFH2) {
        boolean useInternalFormat = forceRFH2 ? false : WMQMarshalUtils.useInternalFormat(owner);
        WMQSendMarshal sendMarshal = useInternalFormat ? new WMQSendMarshalMH() : new WMQSendMarshal();
        return sendMarshal;
    }

    public static WMQReceiveMarshal newReceiveMarshal() {
        WMQReceiveMarshal receiveMarshal = new WMQReceiveMarshal();
        return receiveMarshal;
    }

    public static WMQReceiveMarshal newReceiveMarshal(WMQConsumerOwner owner, boolean forceRFH2) {
        boolean useInternalFormat = forceRFH2 ? false : WMQMarshalUtils.useInternalFormat(owner);
        WMQReceiveMarshal receiveMarshal = useInternalFormat ? new WMQReceiveMarshalMH() : new WMQReceiveMarshal();
        return receiveMarshal;
    }

    public static WMQReceiveMarshal newReceiveMarshal(WMQCommonSession session, ByteBuffer buffer, int offset) {
        JmqiSystemEnvironment sysenv;
        JmqiDC dc;
        int strucID;
        if (session == null || buffer == null || buffer.array() == null || offset < 0) {
            Trace.ffst("WMQMarshal", "newReceiveMarshal(WMQSession,ByteBuffer,int)", "XM00A001", null, null);
        }
        WMQReceiveMarshal receiveMarshal = (strucID = (dc = (sysenv = (JmqiSystemEnvironment)session.getJmqiEnvironment()).getDC()).readI32(buffer.array(), offset, false)) == 1515341392 ? new WMQReceiveMarshalMH() : new WMQReceiveMarshal();
        return receiveMarshal;
    }

    protected void resetState() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal", "resetState()");
        }
        this.imported = false;
        this.mqmd = null;
        this.owner = null;
        this.env = null;
        this.providerMessage = null;
        this.destination = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal", "resetState()");
        }
    }

    protected void updateProviderMessageFromMQMD() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal", "updateProviderMessageFromMQMD()");
        }
        try {
            String putDate;
            byte[] messageId;
            WMQMarshalUtils.setMQMDPropsFromHeader(this.destination, this.providerMessage, this.mqmd);
            int priority = this.mqmd.getPriority();
            if (priority >= 0) {
                this.providerMessage.setJMSPriority(priority);
            } else {
                if (Trace.isOn) {
                    Trace.data(this, "updateProviderMessageFromMQMD()", "Unexpected or AS_Q_DEF value for MQMD.Priority", (Object)new Integer(priority));
                }
                this.providerMessage.setJMSPriority(priority);
            }
            boolean persistenceFromMD = WMQMarshalUtils.getPersistenceFromMD(this.owner);
            if (this.providerMessage.getJMSDeliveryMode() == -2 || persistenceFromMD) {
                int persistence = this.mqmd.getPersistence();
                if (persistence == 0) {
                    this.providerMessage.setJMSDeliveryMode(1);
                } else if (persistence == 1) {
                    this.providerMessage.setJMSDeliveryMode(2);
                } else {
                    if (Trace.isOn) {
                        Trace.data(this, "updateProviderMessageFromMQMD()", "Unexpected or AS_Q_DEF value for MQMD.Persistence", (Object)new Integer(persistence));
                    }
                    this.providerMessage.setJMSDeliveryMode(-1);
                }
            }
            if ((messageId = this.mqmd.getMsgId()) != null) {
                String messageIdString = WMQUtils.idToString(messageId);
                if (messageIdString != null) {
                    this.providerMessage.setJMSMessageID(messageIdString);
                } else if (Trace.isOn) {
                    Trace.data(this, "updateProviderMessageFromMQMD()", "String value for MQMD.MsgId is null", (Object)messageIdString);
                }
            } else if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "byte[] value for MQMD.MsgId is null", (Object)messageId);
            }
            String userId = this.mqmd.getUserIdentifier();
            PropertyStore.register(trimJMSXUserID, false);
            boolean isTrim = PropertyStore.getBooleanProperty(trimJMSXUserID);
            if (isTrim && userId != null) {
                userId = userId.trim();
                if (Trace.isOn) {
                    Trace.data(this, "updateProviderMessageFromMQMD()", "JMXUserID without pad", (Object)userId);
                }
            }
            if (userId != null) {
                this.providerMessage.setStringProperty("JMSXUserID", userId);
            } else if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "String value for MQMD.UserIdentifier is null", (Object)userId);
            }
            String appIdString = this.mqmd.getPutApplName();
            if (appIdString != null) {
                this.providerMessage.setStringProperty("JMSXAppID", appIdString);
            } else if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "String value for MQMD.PutApplName is null", (Object)appIdString);
            }
            int messageFlags = this.mqmd.getMsgFlags();
            if (messageFlags != 0) {
                if ((messageFlags & 8) != 0 || (messageFlags & 0x10) != 0) {
                    String groupIDString;
                    int seqNumber = this.mqmd.getMsgSeqNumber();
                    this.providerMessage.setIntProperty("JMSXGroupSeq", seqNumber);
                    byte[] groupId = this.mqmd.getGroupId();
                    if (groupId != null && this.providerMessage.getStringProperty("JMSXGroupID") == null && (groupIDString = WMQUtils.idToString(groupId)) != null) {
                        this.providerMessage.setStringProperty("JMSXGroupID", groupIDString);
                    }
                }
            } else if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "Numeric value for MQMD.MsgFlags is MQMF_NONE", (Object)new Integer(messageFlags));
            }
            if ((putDate = this.mqmd.getPutDate()) != null) {
                this.providerMessage.setStringProperty("JMS_IBM_PutDate", putDate);
            } else if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "String value for MQMD.PutDate is null", (Object)putDate);
            }
            String putTime = this.mqmd.getPutTime();
            if (putTime != null) {
                this.providerMessage.setStringProperty("JMS_IBM_PutTime", putTime);
            } else if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "String value for MQMD.PutTime is null", (Object)putTime);
            }
            int applType = this.mqmd.getPutApplType();
            if (applType != 0) {
                this.providerMessage.setIntProperty("JMS_IBM_PutApplType", applType);
            } else if (Trace.isOn) {
                Trace.data(this, "updateProviderMessageFromMQMD()", "Numeric value for MQMD.PutApplType is MQAT_NO_CONTEXT", (Object)new Integer(applType));
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal", "updateProviderMessageFromMQMD()", e);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1000", null));
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal", "updateProviderMessageFromMQMD()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal", "updateProviderMessageFromMQMD()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQMarshal", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMarshal.java, jmscc.wmq, k701, k701-112-140304  1.10.1.4 12/11/28 19:15:13");
        }
    }
}

