/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.msg.client.commonservices.collections.CSHashtable;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderMapMessage;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessageUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.JMSException;

public class WMQMapMessage
extends WMQMessage
implements ProviderMapMessage {
    private static final long serialVersionUID = 4255553665929966757L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMapMessage.java, jmscc.wmq, k701, k701-112-140304 1.6.1.2 12/06/06 19:23:38";
    private CSHashtable mapBody = new CSHashtable();
    private boolean mapNameStyle = true;

    public WMQMapMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "<init>()");
        }
        this.messageClass = "jms_map";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "<init>()");
        }
    }

    public byte[] _exportBody(int encoding, String characterSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "_exportBody(int,String)", new Object[]{new Integer(encoding), characterSet});
        }
        StringBuffer body = new StringBuffer(100);
        Enumeration elementNames = this.getMapNames();
        body.append("<map>");
        while (elementNames.hasMoreElements()) {
            String name = (String)elementNames.nextElement();
            Object value = this.getObject(name);
            this.eltFormatElement(name, value, body);
        }
        body.append("</map>");
        byte[] bodyBytes = WMQUtils.computeBytesFromText(body.toString(), characterSet);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "_exportBody(int,String)", bodyBytes);
        }
        return bodyBytes;
    }

    private String _handleIllegalCharacters(String propertyName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "_handleIllegalCharacters(String)", new Object[]{propertyName});
        }
        try {
            if (propertyName.length() > 3 && propertyName.substring(0, 3).equals("elt")) {
                int endbit;
                String name = propertyName;
                String realName = "";
                String nameIntro = "";
                boolean newNull = false;
                int nullIndex = 0;
                nullIndex = name.indexOf(" xsi:nil");
                newNull = nullIndex != -1;
                String nullbit = "";
                if (newNull) {
                    nullbit = name.substring(nullIndex, nullIndex + 15);
                }
                if ((endbit = name.indexOf(" dt=")) != -1) {
                    nameIntro = name.substring(0, name.indexOf("name=") + 5);
                    int realNameStart = nameIntro.length() + 1;
                    int realNameEnd = name.indexOf("dt=") - 2;
                    realName = name.substring(realNameStart, realNameEnd);
                    realName = realName + name.substring(endbit, name.length());
                    name = realName + nullbit;
                    if (Trace.isOn) {
                        Trace.traceData(this, "Altered Name = " + name, null);
                    }
                } else {
                    nameIntro = name.substring(0, name.indexOf("name=") + 5);
                    int realNameStart = nameIntro.length() + 1;
                    realName = newNull ? name.substring(realNameStart, name.indexOf("xsi:nil") - 2) : name.substring(realNameStart, name.length() - 1);
                    name = realName + nullbit;
                    if (Trace.isOn) {
                        Trace.traceData(this, "(String) Altered Name = " + name, null);
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "_handleIllegalCharacters(String)", name, 1);
                }
                return name;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "_handleIllegalCharacters(String)", propertyName, 2);
            }
            return propertyName;
        }
        catch (Exception ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "_handleIllegalCharacters(String)", ex);
            }
            JMSException jmsEx = (JMSException)((Object)NLSServices.createException("JMSCMQ1050", null));
            jmsEx.setLinkedException(ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "_handleIllegalCharacters(String)", jmsEx);
            }
            throw jmsEx;
        }
    }

    public void _importBody(byte[] input, int startIndex, int endIndex, int encoding, String cSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "_importBody(byte [ ],int,int,int,String)", new Object[]{input, new Integer(startIndex), new Integer(endIndex), new Integer(encoding), cSet});
        }
        this.mapBody.clear();
        String body = WMQUtils.computeTextFromBytes(input, startIndex, endIndex, cSet);
        this.parseMapBody(body);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "_importBody(byte [ ],int,int,int,String)");
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "clearBody()");
        }
        this.mapBody.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "clearBody()");
        }
    }

    private void eltFormatElement(String name, Object value, StringBuffer buffer) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "eltFormatElement(String,Object,StringBuffer)", new Object[]{name, value, buffer});
        }
        boolean written = false;
        buffer.append("<");
        if (this.mapNameStyle) {
            buffer.append("elt name=\"" + name + "\"");
        } else {
            buffer.append(name);
        }
        if (value instanceof String) {
            buffer.append(">");
            WMQMessageUtils.backReference(buffer, (String)value);
            written = true;
        } else if (value instanceof Integer) {
            buffer.append(" dt='i4'>");
        } else if (value instanceof Short) {
            buffer.append(" dt='i2'>");
        } else if (value instanceof Byte) {
            buffer.append(" dt='i1'>");
        } else if (value instanceof Long) {
            buffer.append(" dt='i8'>");
        } else if (value instanceof Float) {
            buffer.append(" dt='r4'>");
        } else if (value instanceof Double) {
            buffer.append(" dt='r8'>");
        } else if (value instanceof byte[]) {
            buffer.append(" dt='bin.hex'>");
            WMQUtils.binToHex((byte[])value, 0, ((byte[])value).length, buffer);
            written = true;
        } else if (value instanceof Boolean) {
            buffer.append(" dt='boolean'>");
            value = ((Boolean)value).booleanValue() ? "1" : "0";
        } else if (value instanceof Character) {
            buffer.append(" dt='char'>");
            WMQMessageUtils.backReference(buffer, ((Character)value).toString());
            written = true;
        } else if (value == null) {
            buffer.append(" xsi:nil='true'>");
            buffer.append("</");
            if (this.mapNameStyle) {
                buffer.append("elt");
            } else {
                buffer.append(name);
            }
            buffer.append(">");
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "eltFormatElement(String,Object,StringBuffer)", 1);
            }
            return;
        }
        if (!written) {
            buffer.append(value.toString());
        }
        buffer.append("</");
        if (this.mapNameStyle) {
            buffer.append("elt");
        } else {
            buffer.append(name);
        }
        buffer.append(">");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "eltFormatElement(String,Object,StringBuffer)", 2);
        }
    }

    public Enumeration getMapNames() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "getMapNames()");
        }
        final Iterator iterator = this.mapBody.keySet().iterator();
        Enumeration e = new Enumeration(){

            public boolean hasMoreElements() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "hasMoreElements()");
                }
                boolean b = iterator.hasNext();
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.null", "hasMoreElements()", b);
                }
                return b;
            }

            public Object nextElement() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "nextElement()");
                }
                Object o = iterator.next();
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.null", "nextElement()", o);
                }
                return o;
            }
        };
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "getMapNames()", e);
        }
        return e;
    }

    public Object getObject(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "getObject(String)", new Object[]{name});
        }
        Object object = this.mapBody.get(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "getObject(String)", object);
        }
        return object;
    }

    public boolean itemExists(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "itemExists(String)", new Object[]{name});
        }
        boolean itemExists = this.mapBody.containsKey(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "itemExists(String)", itemExists);
        }
        return itemExists;
    }

    private void parseMapBody(String mapBody) throws JMSException {
        Tokenizer strtok;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "parseMapBody(String)", new Object[]{mapBody});
        }
        if (!(strtok = new Tokenizer(mapBody)).nextToken().equals("map")) {
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1047", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "parseMapBody(String)", je, 1);
            }
            throw je;
        }
        String name = strtok.nextToken();
        while (!name.equals("/map")) {
            String token;
            String type;
            if (name.length() > 3 && name.substring(0, 3).equals("elt")) {
                name = this._handleIllegalCharacters(name);
            }
            int nullIndex = 0;
            boolean newNull = false;
            try {
                nullIndex = name.indexOf(" xsi:nil");
                newNull = nullIndex != -1;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "parseMapBody(String)", e);
                }
                newNull = false;
            }
            boolean shortForm = false;
            boolean byteIndex = false;
            if (name.charAt(name.length() - 1) == '/') {
                shortForm = true;
            }
            if (newNull) {
                int spaceIndex = 0;
                spaceIndex = name.indexOf(" ");
                type = "'string'";
                name = name.substring(0, spaceIndex);
                if (!shortForm) {
                    token = strtok.nextToken();
                    if (token.charAt(0) != '/') {
                        token = strtok.nextToken();
                    }
                    if (token.charAt(0) != '/') {
                        JMSException je2 = (JMSException)((Object)NLSServices.createException("JMSCMQ1050", null));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "parseMapBody(String)", je2, 2);
                        }
                        throw je2;
                    }
                }
                this.setObject(name, WMQMessageUtils.deformatElement(type, null));
            } else {
                int index = name.indexOf(" dt=");
                if (index != -1) {
                    type = name.substring(index + 4);
                    name = name.substring(0, index);
                    if (shortForm) {
                        type = type.substring(0, type.length() - 1);
                    }
                } else {
                    type = "'string'";
                    if (shortForm) {
                        name = name.substring(0, name.length() - 1);
                    }
                }
                if (shortForm) {
                    this.setObject(name, WMQMessageUtils.deformatElement(type, ""));
                } else {
                    String value = strtok.nextToken();
                    if (value.charAt(0) == '/' && (value.equals("/elt") || name.equals(value.substring(1, value.length())))) {
                        this.setObject(name, WMQMessageUtils.deformatElement(type, ""));
                    } else {
                        this.setObject(name, WMQMessageUtils.deformatElement(type, value));
                        token = strtok.nextToken();
                        if (token.charAt(0) != '/') {
                            JMSException je3 = (JMSException)((Object)NLSServices.createException("JMSCMQ1047", null));
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "parseMapBody(String)", je3, 3);
                            }
                            throw je3;
                        }
                    }
                }
            }
            name = strtok.nextToken();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "parseMapBody(String)");
        }
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setBoolean(String,boolean)", new Object[]{name, value});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, new Boolean(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setBoolean(String,boolean)");
        }
    }

    public void setByte(String name, byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setByte(String,byte)", new Object[]{name, new Byte(value)});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, new Byte(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setByte(String,byte)");
        }
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setBytes(String,byte [ ])", new Object[]{name, value});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setBytes(String,byte [ ])");
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setBytes(String,byte [ ],int,int)", new Object[]{name, value, new Integer(offset), new Integer(length)});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        byte[] bytes = new byte[length];
        System.arraycopy(value, offset, bytes, 0, length);
        this.mapBody.put(name, bytes);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setBytes(String,byte [ ],int,int)");
        }
    }

    public void setChar(String name, char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setChar(String,char)", new Object[]{name, new Character(value)});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, new Character(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setChar(String,char)");
        }
    }

    public void setDouble(String name, double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setDouble(String,double)", new Object[]{name, new Double(value)});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, new Double(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setDouble(String,double)");
        }
    }

    public void setFloat(String name, float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setFloat(String,float)", new Object[]{name, new Float(value)});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, new Float(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setFloat(String,float)");
        }
    }

    public void setInt(String name, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setInt(String,int)", new Object[]{name, new Integer(value)});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, new Integer(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setInt(String,int)");
        }
    }

    public void setLong(String name, long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setLong(String,long)", new Object[]{name, new Long(value)});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, new Long(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setLong(String,long)");
        }
    }

    public void setObject(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setObject(String,Object)", new Object[]{name, value});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setObject(String,Object)");
        }
    }

    public void setShort(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setShort(String,short)", new Object[]{name, new Short(value)});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, new Short(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setShort(String,short)");
        }
    }

    public void setString(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setString(String,String)", new Object[]{name, value});
        }
        if (!this.mapNameStyle) {
            this.checkMapNameStyle(name);
        }
        this.mapBody.put(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setString(String,String)");
        }
    }

    boolean isMapNameStyle() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "isMapNameStyle()", "getter", this.mapNameStyle);
        }
        return this.mapNameStyle;
    }

    public void setMapNameStyle(boolean mapNameStyle) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "setMapNameStyle(boolean)", "setter", mapNameStyle);
        }
        this.mapNameStyle = mapNameStyle;
    }

    private void checkMapNameStyle(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "checkMapNameStyle(String)", new Object[]{name});
        }
        boolean valid = true;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(ch)) continue;
                valid = false;
                break;
            }
            if (Character.isJavaIdentifierPart(ch)) continue;
            valid = false;
            break;
        }
        if (!valid) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_PROPERTY", name);
            JMSException jmsEx = (JMSException)((Object)NLSServices.createException("JMSCMQ1066", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "checkMapNameStyle(String)", jmsEx);
            }
            throw jmsEx;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "checkMapNameStyle(String)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQMapMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQMapMessage.java, jmscc.wmq, k701, k701-112-140304  1.6.1.2 12/06/06 19:23:38");
        }
    }

    private class Tokenizer {
        private Vector tokens = new Vector();

        private Tokenizer(String string) {
            String token;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.Tokenizer", "<init>(String)", new Object[]{string});
            }
            int length = string.length();
            boolean hide = false;
            int tokenStart = 0;
            boolean decorated = false;
            for (int index = 0; index < length; ++index) {
                char ch = string.charAt(index);
                if (ch == '\"') {
                    hide = !hide;
                    continue;
                }
                if (hide) continue;
                if (decorated) {
                    if (ch != '>') continue;
                    if (index > tokenStart && (token = string.substring(tokenStart + 1, index)).length() > 0) {
                        this.tokens.add(token);
                    }
                    decorated = false;
                    tokenStart = index;
                    continue;
                }
                if (ch != '<') continue;
                if (index > tokenStart && (token = string.substring(tokenStart + 1, index)).length() > 0) {
                    this.tokens.add(token);
                }
                decorated = true;
                tokenStart = index;
            }
            if (length - tokenStart > 2) {
                token = string.substring(tokenStart + 1, length - 1);
                this.tokens.add(token);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.Tokenizer", "<init>(String)");
            }
        }

        private String nextElement() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.Tokenizer", "nextElement()");
            }
            if (this.tokens.size() <= 0) {
                NoSuchElementException traceRet1 = new NoSuchElementException();
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.Tokenizer", "nextElement()", traceRet1);
                }
                throw traceRet1;
            }
            String token = (String)this.tokens.firstElement();
            this.tokens.remove(0);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.Tokenizer", "nextElement()", token);
            }
            return token;
        }

        private String nextToken() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.Tokenizer", "nextToken()");
            }
            if (this.tokens.size() <= 0) {
                NoSuchElementException traceRet1 = new NoSuchElementException();
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.messages.Tokenizer", "nextToken()", traceRet1);
                }
                throw traceRet1;
            }
            String token = (String)this.tokens.firstElement();
            this.tokens.remove(0);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.Tokenizer", "nextToken()", token);
            }
            return token;
        }
    }
}

