/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal.messages;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderBytesMessage;
import com.ibm.msg.client.wmq.common.internal.WMQUtils;
import com.ibm.msg.client.wmq.common.internal.messages.WMQMessage;
import javax.jms.JMSException;

public class WMQBytesMessage
extends WMQMessage
implements ProviderBytesMessage {
    private static final long serialVersionUID = 4939588168641754626L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQBytesMessage.java, jmscc.wmq, k701, k701-112-140304 1.2.1.1 09/08/17 08:41:40";
    private byte[] bytes;
    private int dataEnd = -1;
    private int dataStart = 0;

    public WMQBytesMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "<init>()");
        }
        this.messageClass = "jms_bytes";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "<init>()");
        }
    }

    public byte[] _exportBody(int encoding, String characterSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "_exportBody(int,String)", new Object[]{new Integer(encoding), characterSet});
        }
        byte[] bodyByteArray = this.getBodyByteArray();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "_exportBody(int,String)", bodyByteArray);
        }
        return bodyByteArray;
    }

    public void _importBody(byte[] input, int startIndex, int endIndex, int encoding, String cSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "_importBody(byte [ ],int,int,int,String)", new Object[]{input, new Integer(startIndex), new Integer(endIndex), new Integer(encoding), cSet});
        }
        this.bytes = WMQUtils.computeNewBytesFromBytes(input, startIndex, endIndex);
        this.dataStart = 0;
        this.dataEnd = -1;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "_importBody(byte [ ],int,int,int,String)");
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "clearBody()");
        }
        this.bytes = new byte[0];
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "clearBody()");
        }
    }

    private byte[] getBodyByteArray() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "getBodyByteArray()");
        }
        if (this.dataStart != 0 || this.dataEnd != -1) {
            this.bytes = WMQUtils.computeNewBytesFromBytes(this.bytes, this.dataStart, this.dataEnd);
            this.dataStart = 0;
            this.dataEnd = -1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "getBodyByteArray()", this.bytes);
        }
        return this.bytes;
    }

    public byte[] getBytes() {
        byte[] bodyByteArray = this.getBodyByteArray();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "getBytes()", "getter", bodyByteArray);
        }
        return bodyByteArray;
    }

    public void setBytes(byte[] newBytes) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "setBytes(byte [ ])", "setter", newBytes);
        }
        this.bytes = newBytes;
        this.dataStart = 0;
        this.dataEnd = -1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.messages.WMQBytesMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/messages/WMQBytesMessage.java, jmscc.wmq, k701, k701-112-140304  1.2.1.1 09/08/17 08:41:40");
        }
    }
}

