/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Hobj;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.internal.Configuration;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.WMQThreadLocalStorage;
import com.ibm.msg.client.wmq.common.internal.WMQConsumerOwner;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.jms.JMSException;

public class WMQUtils {
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQUtils.java, jmscc.wmq, k701, k701-112-140304 1.11.1.8 13/07/24 15:41:20";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final ThreadLocal cachedCcsid;
    private static final ThreadLocal cachedCharset;
    private static final ThreadLocal cachedEncoding;
    private static final int maxTlsBufferSize = 131072;
    static final String CLASSNAME = "c.i.m.c.wmq.internal.WMQUtils";
    private static final char[] BIN2HEX;
    private static final char[] BIN2HEX_UPPERCASE;

    public static byte[] computeNewBytesFromBytes(byte[] input, int startIndex, int endIndex) {
        if (input == null) {
            return null;
        }
        int length = (endIndex == -1 ? input.length : endIndex) - startIndex;
        if (length == 0) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(input, startIndex, result, 0, length);
        return result;
    }

    public static byte[] computeBytesFromText(String input, String cSet) throws JMSException {
        ByteBuffer buffer;
        if (input == null) {
            return null;
        }
        if (cSet.equals("UTF-8") && (buffer = WMQUtils.convUtf16Utf8Optimistic(input, null)) != null) {
            if (Trace.isOn) {
                Trace.data("com.ibm.msg.client.wmq.internal.WMQUtils", "computeBytesFromText(String,String)", "Fast-path successful. Resultant ByteBuffer: ", (Object)buffer);
            }
            return buffer.array();
        }
        byte[] result = WMQUtils.computeBytesFromTextSlowPath(input, cSet);
        return result;
    }

    public static ByteBuffer computeBytesFromTextUsingTls(String input, String cSet, WMQThreadLocalStorage tls) throws JMSException {
        if (input == null) {
            return null;
        }
        if (tls == null) {
            return ByteBuffer.wrap(WMQUtils.computeBytesFromText(input, cSet));
        }
        ByteBuffer result = null;
        if (cSet.equals("UTF-8") && (result = WMQUtils.convUtf16Utf8Optimistic(input, tls)) != null) {
            if (Trace.isOn) {
                Trace.data("com.ibm.msg.client.wmq.internal.WMQUtils", "computeBytesFromTextUsingTls(String,String,WMQThreadLocalStorage)", "Fast-path successful. Resultant ByteBuffer: ", (Object)result);
            }
            return result;
        }
        byte[] bytes = WMQUtils.computeBytesFromTextSlowPath(input, cSet);
        result = ByteBuffer.wrap(bytes);
        return result;
    }

    private static byte[] computeBytesFromTextSlowPath(String input, String cSet) throws JMSException {
        byte[] result;
        try {
            result = input.getBytes(cSet);
        }
        catch (UnsupportedEncodingException ex) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("CCSID", cSet);
            inserts.put("input", input);
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1046", inserts));
            je.setLinkedException((Exception)ex);
            throw je;
        }
        return result;
    }

    public static ByteBuffer convUtf16Utf8Optimistic(String src, WMQThreadLocalStorage tls) {
        int srcPos = 0;
        int targPos = 0;
        int srcLen = src.length();
        byte[] targ = null;
        targ = new byte[srcLen];
        int lastByte = srcLen;
        while (srcPos < srcLen) {
            char srcChar = src.charAt(srcPos++);
            int srcByte0 = srcChar >> 8 & 0xFF;
            int srcByte1 = srcChar & 0xFF;
            if ((srcByte1 & 0x80) == 0 && srcByte0 == 0) {
                if (targPos >= lastByte) {
                    return null;
                }
                targ[targPos++] = (byte)srcByte1;
                continue;
            }
            return null;
        }
        ByteBuffer result = ByteBuffer.wrap(targ);
        result.limit(srcLen);
        return result;
    }

    public static String computeTextFromBytes(byte[] input, int startIndex, int endIndex, String cSet) throws JMSException {
        try {
            int dataLength = (endIndex == -1 ? input.length : endIndex) - startIndex;
            String result = new String(input, startIndex, dataLength, cSet);
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            HashMap<String, Object> inserts = new HashMap<String, Object>();
            inserts.put("CCSID", cSet);
            inserts.put("input", input);
            inserts.put("startIndex", new Integer(startIndex));
            inserts.put("endIndex", new Integer(endIndex));
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1046", inserts));
            je.setLinkedException((Exception)ex);
            throw je;
        }
    }

    public static String computeTextFromByteBuffer(ByteBuffer input, String cSet) throws JMSException {
        return WMQUtils.computeTextFromBytes(input.array(), input.position(), input.limit(), cSet);
    }

    public static int binToHex(byte[] bin, int start, int length, StringBuffer hex) {
        int sum = 0;
        for (int i = start; i < start + length; ++i) {
            int binByte = bin[i];
            if (binByte < 0) {
                binByte += 256;
            }
            sum += binByte;
            hex.append(BIN2HEX[binByte / 16]);
            hex.append(BIN2HEX[binByte % 16]);
        }
        return sum;
    }

    public static int binToHexUpperCase(byte[] bin, int start, int length, StringBuffer hex) {
        int sum = 0;
        for (int i = start; i < start + length; ++i) {
            int binByte = bin[i];
            if (binByte < 0) {
                binByte += 256;
            }
            sum += binByte;
            hex.append(BIN2HEX_UPPERCASE[binByte / 16]);
            hex.append(BIN2HEX_UPPERCASE[binByte % 16]);
        }
        return sum;
    }

    public static byte[] hexToBin(String hex, int start) throws JMSException {
        int length = hex.length() - start;
        if (length == 0) {
            byte[] result = new byte[]{};
            return result;
        }
        if (length < 0 || length % 2 != 0) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_HEX_STRING", hex.substring(start));
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1044", inserts));
            throw je;
        }
        byte[] retval = new byte[length /= 2];
        for (int i = 0; i < length; ++i) {
            int digit1 = Character.digit(hex.charAt(2 * i + start), 16) << 4;
            int digit2 = Character.digit(hex.charAt(2 * i + start + 1), 16);
            if (digit1 < 0 || digit2 < 0) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_HEX_STRING", hex.substring(start));
                JMSException je2 = (JMSException)((Object)NLSServices.createException("JMSCMQ1044", inserts));
                throw je2;
            }
            retval[i] = (byte)(digit1 + digit2);
        }
        return retval;
    }

    public static String idToString(byte[] id) {
        if (id == null) {
            return null;
        }
        int len = id.length;
        char[] idchars = new char[3 + 2 * len];
        idchars[0] = 73;
        idchars[1] = 68;
        idchars[2] = 58;
        for (int i = 0; i < len; ++i) {
            int binByte = id[i];
            if (binByte < 0) {
                binByte += 256;
            }
            idchars[2 * i + 3] = BIN2HEX[binByte / 16];
            idchars[2 * i + 4] = BIN2HEX[binByte % 16];
        }
        return new String(idchars);
    }

    public static byte[] stringToId(String idString) throws JMSException {
        byte[] result = WMQUtils.hexToBin(idString, 3);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static String getCharacterSetString(JmqiEnvironment env, int ccsid, int encoding) throws JMSException {
        void var3_3;
        String result;
        if (cachedCharset.get() != null) {
            if (Trace.isOn) {
                Trace.data(CLASSNAME, "getCharacterSetString(env,int,int)", "Using cached value of character set", null);
            }
            Integer cachedCcsidAsInteger = (Integer)cachedCcsid.get();
            Integer cachedEncodingAsInteger = (Integer)cachedEncoding.get();
            if (cachedCcsidAsInteger == ccsid && cachedEncodingAsInteger == encoding) {
                if (Trace.isOn) {
                    Trace.data(CLASSNAME, "getCharacterSetString(env,int,int)", "Mapped " + ccsid + " to " + cachedCharset.get() + ", (cached) ", null);
                }
                return (String)cachedCharset.get();
            }
        }
        if (Trace.isOn) {
            Trace.data(CLASSNAME, "getCharacterSetString(env,int,int)", "character set not cached. Trying to work out the character set using CCSID " + ccsid + " and encoding " + encoding, null);
        }
        if (ccsid == 0) {
            ccsid = 819;
        }
        Configuration conf = env.getConfiguration();
        boolean useCcsidStandards = conf.getBoolValue(Configuration.CCSID_MAPUTF16BYTEORDERBYCCSID);
        if (ccsid % 4096 == 1200 && !useCcsidStandards) {
            result = (encoding & 0xF) == 2 ? "UTF-16LE" : (conf.getBoolValue(Configuration.CCSID_MAPCCSID1200TOUNICODEBIGUNMARKED) ? "UnicodeBigUnmarked" : "UTF-16");
            if (Trace.isOn) {
                Trace.data(CLASSNAME, "getCharacterSetString(env,int,int)", "Mapped " + ccsid + " to " + result + ", (Unicode check) ", null);
            }
        } else {
            JmqiCodepage cp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)env, (int)ccsid);
            if (cp != null) {
                result = cp.charsetId;
                if (Trace.isOn) {
                    Trace.data(CLASSNAME, "getCharacterSetString(env,int,int)", "Mapped " + ccsid + " to " + result + ", (using JmqiCodepage) ", null);
                }
            } else {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("CCSID", "ccsid:" + Integer.toString(ccsid));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1046", inserts));
                throw je;
            }
        }
        cachedCcsid.set(new Integer(ccsid));
        cachedEncoding.set(new Integer(encoding));
        cachedCharset.set(var3_3);
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNPMClassHigh(WMQConsumerOwner owner, WMQDestination destination) {
        boolean bl;
        Hobj hobj;
        Phobj phobj;
        Pint rc;
        Pint cc;
        JmqiMQ mq;
        Hconn hconn;
        block30: {
            block28: {
                boolean bl2;
                block29: {
                    int[] intAttrs;
                    block26: {
                        boolean bl3;
                        block27: {
                            if (Trace.isOn) {
                                Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)", new Object[]{owner, destination});
                            }
                            if (owner == null || destination == null) {
                                HashMap<String, Object> info = new HashMap<String, Object>();
                                info.put("methodName", "isNPMClassHigh(WMQSession,WMQDestination)");
                                info.put("owner", owner);
                                info.put("destination", destination);
                                Trace.ffst(CLASSNAME, "isNPMClassHigh(WMQSession,WMQDestination)", "XN00A003", info, null);
                            }
                            if (destination.isTopic()) {
                                if (Trace.isOn) {
                                    Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)", false, 1);
                                }
                                return false;
                            }
                            JmqiEnvironment env = owner.getJmqiEnvironment();
                            hconn = owner.getHconn();
                            mq = owner.getJmqiMQ();
                            if (env == null || hconn == null || mq == null) {
                                HashMap<String, String> info = new HashMap<String, String>();
                                info.put("methodName", "isNPMClassHigh(WMQSession,WMQDestination)");
                                info.put("JmqiEnvironment", (String)env);
                                info.put("Hconn", (String)hconn);
                                info.put("JmqiMQ", (String)mq);
                                Trace.ffst(CLASSNAME, "isNPMClassHigh(WMQSession,WMQDestination)", "XN00A004", info, null);
                            }
                            cc = env.newPint();
                            rc = env.newPint();
                            MQOD mqod = env.newMQOD();
                            try {
                                String qmName;
                                if (destination.propertyExists("XMSC_WMQ_QUEUE_MANAGER") && (qmName = destination.getStringProperty("XMSC_WMQ_QUEUE_MANAGER")) != null && qmName.length() > 0) {
                                    mqod.setObjectQMgrName(qmName);
                                }
                            }
                            catch (JMSException je) {
                                if (Trace.isOn) {
                                    Trace.catchBlock("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)", je);
                                }
                                if (Trace.isOn) {
                                    Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)", false, 2);
                                }
                                return false;
                            }
                            mqod.setObjectType(1);
                            mqod.setObjectName(destination.getName());
                            int openOptions = 32;
                            phobj = env.newPhobj();
                            mq.MQOPEN(hconn, mqod, openOptions, phobj, cc, rc);
                            if (rc.x != 0 || cc.x != 0) {
                                if (Trace.isOn) {
                                    Trace.data(CLASSNAME, "isNPMClassHigh(WMQSession,WMQDestination)", "MQOPEN did not succeed. cc=" + cc + " and rc=" + rc + ", returning false", null);
                                }
                                if (Trace.isOn) {
                                    Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)", false, 3);
                                }
                                return false;
                            }
                            hobj = phobj.getHobj();
                            try {
                                int[] selectors = new int[]{78};
                                intAttrs = new int[1];
                                mq.MQINQ(hconn, hobj, selectors.length, selectors, intAttrs.length, intAttrs, 0, null, cc, rc);
                                if (rc.x == 0 && cc.x == 0) break block26;
                                if (Trace.isOn) {
                                    Trace.data(CLASSNAME, "isNPMClassHigh(WMQSession,WMQDestination)", "MQINQ did not succeed. cc=" + cc + " and rc=" + rc + ", returning false", null);
                                }
                                if (Trace.isOn) {
                                    Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)", false, 4);
                                }
                                bl3 = false;
                                Object var16_17 = null;
                                if (!Trace.isOn) break block27;
                            }
                            catch (Throwable throwable) {
                                block31: {
                                    Object var16_20 = null;
                                    if (Trace.isOn) {
                                        Trace.finallyBlock("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)");
                                    }
                                    int closeOptions = 0;
                                    phobj.setHobj(hobj);
                                    mq.MQCLOSE(hconn, phobj, closeOptions, cc, rc);
                                    if (rc.x == 0 && cc.x == 0 || !Trace.isOn) break block31;
                                    Trace.data(CLASSNAME, "isNPMClassHigh(WMQSession,WMQDestination)", "MQCLOSE did not succeed. cc=" + cc + " and rc=" + rc, null);
                                }
                                throw throwable;
                            }
                            Trace.finallyBlock("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)");
                        }
                        int closeOptions = 0;
                        phobj.setHobj(hobj);
                        mq.MQCLOSE(hconn, phobj, closeOptions, cc, rc);
                        if ((rc.x != 0 || cc.x != 0) && Trace.isOn) {
                            Trace.data(CLASSNAME, "isNPMClassHigh(WMQSession,WMQDestination)", "MQCLOSE did not succeed. cc=" + cc + " and rc=" + rc, null);
                        }
                        return bl3;
                    }
                    int npmClass = intAttrs[0];
                    if (Trace.isOn) {
                        Trace.data(CLASSNAME, "isNPMClassHigh(WMQSession,WMQDestination)", "MQIA_NPM_CLASS value = " + npmClass, null);
                    }
                    if (npmClass != 10) break block28;
                    if (Trace.isOn) {
                        Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)", true, 5);
                    }
                    bl2 = true;
                    Object var16_18 = null;
                    if (!Trace.isOn) break block29;
                    Trace.finallyBlock("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)");
                }
                int closeOptions = 0;
                phobj.setHobj(hobj);
                mq.MQCLOSE(hconn, phobj, closeOptions, cc, rc);
                if ((rc.x != 0 || cc.x != 0) && Trace.isOn) {
                    Trace.data(CLASSNAME, "isNPMClassHigh(WMQSession,WMQDestination)", "MQCLOSE did not succeed. cc=" + cc + " and rc=" + rc, null);
                }
                return bl2;
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)", false, 6);
            }
            bl = false;
            Object var16_19 = null;
            if (!Trace.isOn) break block30;
            Trace.finallyBlock("com.ibm.msg.client.wmq.common.internal.WMQUtils", "isNPMClassHigh(final WMQConsumerOwner,final WMQDestination)");
        }
        int closeOptions = 0;
        phobj.setHobj(hobj);
        mq.MQCLOSE(hconn, phobj, closeOptions, cc, rc);
        if ((rc.x != 0 || cc.x != 0) && Trace.isOn) {
            Trace.data(CLASSNAME, "isNPMClassHigh(WMQSession,WMQDestination)", "MQCLOSE did not succeed. cc=" + cc + " and rc=" + rc, null);
        }
        return bl;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.WMQUtils", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQUtils.java, jmscc.wmq, k701, k701-112-140304  1.11.1.8 13/07/24 15:41:20");
        }
        cachedCcsid = new ThreadLocal();
        cachedCharset = new ThreadLocal();
        cachedEncoding = new ThreadLocal();
        BIN2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        BIN2HEX_UPPERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

