/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.wmq.common.internal.WMQValidationInterface;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.JMSException;

public class WMQStandardValidators {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQStandardValidators.java, jmscc.wmq, k701, k701-112-140304 1.26.1.4 09/12/01 14:40:40";

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.WMQStandardValidators", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQStandardValidators.java, jmscc.wmq, k701, k701-112-140304  1.26.1.4 09/12/01 14:40:40");
        }
    }

    public static abstract class WMQTrivialPropertyValidator
    extends WMQPropertyValidator {
        public WMQTrivialPropertyValidator(int domain) {
            super(domain);
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            return true;
        }
    }

    public static abstract class WMQStringPropertyValidator
    extends WMQPropertyValidator {
        public WMQStringPropertyValidator(int domain) {
            super(domain);
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            return true;
        }
    }

    public static abstract class WMQQueueNamePropertyValidator
    extends WMQStringPropertyValidator {
        public WMQQueueNamePropertyValidator(int domain) {
            super(domain);
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            String queueName = this.convertToString(value);
            return queueName != null && queueName.length() <= 48;
        }
    }

    public static abstract class WMQPropertyValidator
    implements WMQValidationInterface {
        protected Hashtable domainNames = new Hashtable();
        protected HashMap valueToCanMappings = new HashMap();
        protected HashMap valueFromCanMappings = new HashMap();
        protected int mapperDomain;

        public WMQValidationInterface.WMQPropertyValidatorDatatype fromCanonical(JmsPropertyContext context, String keyIn, Object valueIn) {
            return this.fromCanonical(keyIn, valueIn);
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(JmsPropertyContext context, String keyIn, Object valueIn) {
            return this.toCanonical(keyIn, valueIn);
        }

        public WMQPropertyValidator(int domain) {
            this.mapperDomain = domain;
        }

        protected void reverseValueMappings() {
            Iterator it = this.valueToCanMappings.keySet().iterator();
            while (it.hasNext()) {
                Integer domain = (Integer)it.next();
                HashMap domainValueMappings = (HashMap)this.valueToCanMappings.get(domain);
                Iterator valueIterator = domainValueMappings.keySet().iterator();
                HashMap reverseValueMappings = new HashMap();
                while (valueIterator.hasNext()) {
                    Object canValue = valueIterator.next();
                    Object domainValue = domainValueMappings.get(canValue);
                    reverseValueMappings.put(domainValue, canValue);
                }
                this.valueFromCanMappings.put(domain, reverseValueMappings);
            }
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype fromCanonical(String keyIn, Object valueIn) {
            HashMap mappings;
            String keyOut = (String)this.domainNames.get(new Integer(this.mapperDomain));
            Object valueOut = this.mapperDomain == 4 ? valueIn : ((mappings = (HashMap)this.valueFromCanMappings.get(new Integer(this.mapperDomain))) == null ? valueIn : mappings.get(valueIn));
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = new WMQValidationInterface.WMQPropertyValidatorDatatype(keyOut, valueOut);
            return returnVal;
        }

        public String getDomainName(int domain) {
            try {
                String name = (String)this.domainNames.get(new Integer(domain));
                return name;
            }
            catch (NullPointerException npe) {
                return null;
            }
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonical(String keyIn, Object valueIn) {
            HashMap mappings;
            valueIn = valueIn instanceof String ? ((String)valueIn).trim() : valueIn;
            String keyOut = (String)this.domainNames.get(new Integer(4));
            Object valueOut = this.mapperDomain == 4 ? valueIn : ((mappings = (HashMap)this.valueToCanMappings.get(new Integer(this.mapperDomain))) == null ? valueIn : mappings.get(valueIn));
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = new WMQValidationInterface.WMQPropertyValidatorDatatype(keyOut, valueOut);
            return returnVal;
        }

        public WMQValidationInterface.WMQPropertyValidatorDatatype toCanonicalNoTrim(String keyIn, Object valueIn) {
            HashMap mappings;
            String keyOut = (String)this.domainNames.get(new Integer(4));
            Object valueOut = this.mapperDomain == 4 ? valueIn : ((mappings = (HashMap)this.valueToCanMappings.get(new Integer(this.mapperDomain))) == null ? valueIn : mappings.get(valueIn));
            WMQValidationInterface.WMQPropertyValidatorDatatype returnVal = new WMQValidationInterface.WMQPropertyValidatorDatatype(keyOut, valueOut);
            return returnVal;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            return true;
        }

        public String convertToString(Object value) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", new Object[]{value});
            }
            if (value == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", null, 1);
                }
                return null;
            }
            if (value instanceof String) {
                String traceRet1 = (String)value;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", traceRet1, 2);
                }
                return traceRet1;
            }
            if (value instanceof Boolean) {
                String traceRet2 = ((Boolean)value).toString();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", traceRet2, 3);
                }
                return traceRet2;
            }
            if (value instanceof Byte) {
                String traceRet3 = ((Byte)value).toString();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", traceRet3, 4);
                }
                return traceRet3;
            }
            if (value instanceof Short) {
                String traceRet4 = ((Short)value).toString();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", traceRet4, 5);
                }
                return traceRet4;
            }
            if (value instanceof Character) {
                String traceRet5 = ((Character)value).toString();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", traceRet5, 6);
                }
                return traceRet5;
            }
            if (value instanceof Integer) {
                String traceRet6 = ((Integer)value).toString();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", traceRet6, 7);
                }
                return traceRet6;
            }
            if (value instanceof Long) {
                String traceRet7 = ((Long)value).toString();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", traceRet7, 8);
                }
                return traceRet7;
            }
            if (value instanceof Float) {
                String traceRet8 = ((Float)value).toString();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", traceRet8, 9);
                }
                return traceRet8;
            }
            if (value instanceof Double) {
                String traceRet9 = ((Double)value).toString();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", traceRet9, 10);
                }
                return traceRet9;
            }
            String traceRet10 = value.toString();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyValidator", "convertToString(Object)", traceRet10, 11);
            }
            return traceRet10;
        }
    }

    public static abstract class WMQIntPropertyValidator
    extends WMQPropertyValidator {
        public WMQIntPropertyValidator(int domain) {
            super(domain);
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return value instanceof Integer;
        }
    }

    public static abstract class WMQChannelNamePropertyValidator
    extends WMQStringPropertyValidator {
        public WMQChannelNamePropertyValidator(int domain) {
            super(domain);
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            String queueName = this.convertToString(value);
            return queueName != null && queueName.length() <= 20;
        }
    }

    public static abstract class WMQBooleanPropertyValidator
    extends WMQPropertyValidator {
        public WMQBooleanPropertyValidator(int domain) {
            super(domain);
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (!(value instanceof Boolean)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                if (value != null && (((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("yes"))) {
                    value = new Boolean(true);
                } else if (value != null && (((String)value).equalsIgnoreCase("false") || ((String)value).equalsIgnoreCase("no"))) {
                    value = new Boolean(false);
                }
            }
            return value instanceof Boolean;
        }
    }

    public static class CaseInsentiveHashmap
    extends HashMap {
        public boolean containsKey(Object key) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.CaseInsentiveHashmap", "containsKey(Object)", new Object[]{key});
            }
            if (key instanceof String) {
                key = ((String)key).toUpperCase();
            }
            boolean traceRet1 = super.containsKey(key);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.CaseInsentiveHashmap", "containsKey(Object)", traceRet1);
            }
            return traceRet1;
        }

        public Object get(Object key) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.CaseInsentiveHashmap", "get(Object)", new Object[]{key});
            }
            if (key instanceof String) {
                key = ((String)key).toUpperCase();
            }
            Object traceRet1 = super.get(key);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.CaseInsentiveHashmap", "get(Object)", traceRet1);
            }
            return traceRet1;
        }

        public Object put(Object key, Object arg1) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.CaseInsentiveHashmap", "put(Object,Object)", new Object[]{key, arg1});
            }
            if (key instanceof String) {
                key = ((String)key).toUpperCase();
            }
            Object traceRet1 = super.put(key, arg1);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.CaseInsentiveHashmap", "put(Object,Object)", traceRet1);
            }
            return traceRet1;
        }

        public Object remove(Object key) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.CaseInsentiveHashmap", "remove(Object)", new Object[]{key});
            }
            if (key instanceof String) {
                key = ((String)key).toUpperCase();
            }
            Object traceRet1 = super.remove(key);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.CaseInsentiveHashmap", "remove(Object)", traceRet1);
            }
            return traceRet1;
        }
    }
}

