/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal;

import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyCacheInterface;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.jms.JmsValidationInterface;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.provider.ProviderPropertyContextCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.jms.JMSException;

public class WMQPropertyContext
implements JmsPropertyContext,
JmsValidationInterface,
JmsPropertyCacheInterface {
    private static final long serialVersionUID = -2339897896507411816L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQPropertyContext.java, jmscc.wmq, k701, k701-112-140304 1.40.1.5 11/02/15 09:00:29";
    protected JmsPropertyContext jmsPropertyContext;
    static final /* synthetic */ boolean $assertionsDisabled;

    private WMQPropertyContext() {
    }

    protected WMQPropertyContext(JmsPropertyContext jmsProps) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyContext", "<init>(JmsPropertyContext)", null);
        }
        if (jmsProps == null) {
            this.jmsPropertyContext = new JmsPropertyContextImpl();
        } else {
            this.jmsPropertyContext = jmsProps;
            if (jmsProps instanceof ProviderPropertyContextCallback) {
                ((ProviderPropertyContextCallback)((Object)jmsProps)).setProviderPropertyContext(this);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyContext", "<init>(JmsPropertyContext)");
        }
    }

    public void clearCachedValue(String key) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || !(o instanceof WMQPropertyContext)) {
            return false;
        }
        WMQPropertyContext other = (WMQPropertyContext)o;
        JmsPropertyContext thisParentContext = this.jmsPropertyContext;
        JmsPropertyContext thatParentContext = other.jmsPropertyContext;
        return thisParentContext.equals(thatParentContext);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getBooleanProperty");
        }
        boolean result = this.jmsPropertyContext.getBooleanProperty(name);
        if (Trace.isOn) {
            Trace.data(this, "getBooleanProperty(String)", "via WMQPropertyContext", (Object)result);
        }
        return result;
    }

    public byte getByteProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getByteProperty");
        }
        byte result = this.jmsPropertyContext.getByteProperty(name);
        if (Trace.isOn) {
            Trace.data(this, "getByteProperty(String)", "via WMQPropertyContext", (Object)new Byte(result));
        }
        return result;
    }

    public byte[] getBytesProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getBytesProperty");
        }
        byte[] result = this.jmsPropertyContext.getBytesProperty(name);
        if (Trace.isOn) {
            Trace.data(this, "getBytesProperty(String)", "via WMQPropertyContext", (Object)result);
        }
        return result;
    }

    public Object getCachedValue(String key) {
        return null;
    }

    public void getCachedValueAll(Map props) {
    }

    public String getCanonicalKey(String keyIn) {
        return null;
    }

    public char getCharProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getCharProperty");
        }
        char result = this.jmsPropertyContext.getCharProperty(name);
        if (Trace.isOn) {
            Trace.data(this, "getCharProperty(String)", "via WMQPropertyContext", (Object)new Character(result));
        }
        return result;
    }

    public double getDoubleProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getDoubleProperty");
        }
        double result = this.jmsPropertyContext.getDoubleProperty(name);
        if (Trace.isOn) {
            Trace.data(this, "getDoubleProperty(String)", "via WMQPropertyContext", (Object)new Double(result));
        }
        return result;
    }

    public float getFloatProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getFloatProperty");
        }
        float result = this.jmsPropertyContext.getFloatProperty(name);
        if (Trace.isOn) {
            Trace.data(this, "getFloatProperty(String)", "via WMQPropertyContext", (Object)new Float(result));
        }
        return result;
    }

    public int getIntProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getIntProperty");
        }
        int result = this.jmsPropertyContext.getIntProperty(name);
        if (Trace.isOn) {
            Trace.data(this, "getIntProperty(String)", "via WMQPropertyContext", (Object)new Integer(result));
        }
        return result;
    }

    public long getLongProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getLongProperty");
        }
        long result = this.jmsPropertyContext.getLongProperty(name);
        if (Trace.isOn) {
            Trace.data(this, "getLongProperty(String)", "via WMQPropertyContext", (Object)new Long(result));
        }
        return result;
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getObjectProperty");
        }
        Object result = this.jmsPropertyContext.getObjectProperty(name);
        if (Trace.isOn) {
            if ("XMSC_PASSWORD".equals(name)) {
                Trace.data(this, "getObjectProperty(String)", "via WMQPropertyContext", (Object)"********");
            } else {
                Trace.data(this, "getObjectProperty(String)", "via WMQPropertyContext", result);
            }
        }
        return result;
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getPropertyNames");
        }
        Enumeration result = this.jmsPropertyContext.getPropertyNames();
        if (Trace.isOn) {
            Trace.data(this, "getPropertyNames()", "via WMQPropertyContext", (Object)result);
        }
        return result;
    }

    public short getShortProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getShortProperty");
        }
        short result = this.jmsPropertyContext.getShortProperty(name);
        if (Trace.isOn) {
            Trace.data(this, "getShortProperty(String)", "via WMQPropertyContext", (Object)new Short(result));
        }
        return result;
    }

    public String getStringProperty(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in getStringProperty");
        }
        String result = this.jmsPropertyContext.getStringProperty(name);
        if (!$assertionsDisabled && (name.equalsIgnoreCase("XMSC_WMQ_HOST_NAME") || name.equalsIgnoreCase("XMSC_WMQ_PORT"))) {
            throw new AssertionError();
        }
        if (Trace.isOn) {
            if ("XMSC_PASSWORD".equals(name)) {
                Trace.data(this, "getStringProperty(String)", "via WMQPropertyContext", (Object)"********");
            } else {
                Trace.data(this, "getStringProperty(String)", "via WMQPropertyContext", (Object)result);
            }
        }
        return result;
    }

    public Object mapFromCanonical(String keyIn, Object valueIn) {
        return null;
    }

    public Vector mapToCanonical(String keyIn, Object valueIn) {
        return null;
    }

    public boolean propertyExists(String name) throws JMSException {
        if (!$assertionsDisabled && this.jmsPropertyContext == null) {
            throw new AssertionError((Object)"jmsPropertyContext null in propertyExists");
        }
        boolean result = this.jmsPropertyContext.propertyExists(name);
        if (Trace.isOn) {
            Trace.data(this, "propertyExists(String)", "via WMQPropertyContext", (Object)result);
        }
        return result;
    }

    public void setBatchProperties(Map properties) throws JMSException {
        this.jmsPropertyContext.setBatchProperties(properties);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setBooleanProperty(String,boolean)", "via WMQPropertyContext", (Object)new Object[]{name, value});
        }
        this.setObjectProperty(name, new Boolean(value));
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setByteProperty(String,byte)", "via WMQPropertyContext", (Object)new Object[]{name, new Byte(value)});
        }
        this.setObjectProperty(name, new Byte(value));
    }

    public void setBytesProperty(String name, byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setBytesProperty(String,byte [ ])", "via WMQPropertyContext", (Object)new Object[]{name, value});
        }
        this.setObjectProperty(name, value);
    }

    public boolean setCachedValue(String key, Object value) {
        return false;
    }

    public void setCharProperty(String name, char value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setCharProperty(String,char)", "via WMQPropertyContext", (Object)new Object[]{name, new Character(value)});
        }
        this.setObjectProperty(name, new Character(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setDoubleProperty(String,double)", "via WMQPropertyContext", (Object)new Object[]{name, new Double(value)});
        }
        this.setObjectProperty(name, new Double(value));
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setFloatProperty(String,float)", "via WMQPropertyContext", (Object)new Object[]{name, new Float(value)});
        }
        this.setObjectProperty(name, new Float(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setIntProperty(String,int)", "via WMQPropertyContext", (Object)new Object[]{name, new Integer(value)});
        }
        this.setObjectProperty(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setLongProperty(String,long)", "via WMQPropertyContext", (Object)new Object[]{name, new Long(value)});
        }
        this.setObjectProperty(name, new Long(value));
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setObjectProperty(String,Object)", "via WMQPropertyContext", (Object)new Object[]{name, value});
        }
        this.jmsPropertyContext.setObjectProperty(name, value);
    }

    public void setPropertyContext(JmsPropertyContext jmsPropertyContext) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyContext", "setPropertyContext(JmsPropertyContext)", "setter", jmsPropertyContext);
        }
        this.jmsPropertyContext = jmsPropertyContext;
        if (jmsPropertyContext instanceof ProviderPropertyContextCallback) {
            ((ProviderPropertyContextCallback)((Object)jmsPropertyContext)).setProviderPropertyContext(this);
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setShortProperty(String,short)", "via WMQPropertyContext", (Object)new Object[]{name, new Short(value)});
        }
        this.setObjectProperty(name, new Short(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (Trace.isOn) {
            if ("XMSC_PASSWORD".equals(name)) {
                Trace.data(this, "setStringProperty(String,String)", "via WMQPropertyContext", (Object)new Object[]{name, "********"});
            } else {
                Trace.data(this, "setStringProperty(String,String)", "via WMQPropertyContext", (Object)new Object[]{name, value});
            }
        }
        this.setObjectProperty(name, value);
    }

    protected void throwValidationException(String name, Object value, Exception linkedException) throws JMSException {
        if (Trace.isOn) {
            if ("XMSC_PASSWORD".equals(name)) {
                Trace.data(this, "throwValidationException(String,Object,Exception)", "via WMQPropertyContext", (Object)new Object[]{name, "********", linkedException});
            } else {
                Trace.data(this, "throwValidationException(String,Object,Exception)", "via WMQPropertyContext", (Object)new Object[]{name, value, linkedException});
            }
        }
        Throwable validateException = linkedException;
        if (!(linkedException instanceof JMSException)) {
            HashMap<String, Object> inserts = new HashMap<String, Object>();
            inserts.put("XMSC_INSERT_PROPERTY", name);
            inserts.put("XMSC_INSERT_VALUE", value);
            JMSException e = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
            e.setLinkedException(linkedException);
            validateException = e;
        }
        JMSException jmsex = (JMSException)validateException;
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyContext", "throwValidationException(String,Object,Exception)", jmsex);
        }
        throw jmsex;
    }

    public boolean validate(Object name, Object value) throws JMSException {
        return true;
    }

    public String crossPropertyValidate() {
        return null;
    }

    public void clearCachedValueAll() {
    }

    public boolean containsCachedValue(String key) {
        return false;
    }

    public void clear() {
        this.jmsPropertyContext.clear();
    }

    public boolean containsKey(Object key) {
        boolean result = this.jmsPropertyContext.containsKey(key);
        return result;
    }

    public boolean containsValue(Object value) {
        boolean result = this.jmsPropertyContext.containsValue(value);
        return result;
    }

    public Set entrySet() {
        Set result = this.jmsPropertyContext.entrySet();
        return result;
    }

    public Object get(Object key) {
        Object result = this.jmsPropertyContext.get(key);
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.jmsPropertyContext.isEmpty();
        return result;
    }

    public Set keySet() {
        Set result = this.jmsPropertyContext.keySet();
        return result;
    }

    public Object put(Object arg0, Object arg1) {
        Object result = this.jmsPropertyContext.put(arg0, arg1);
        return result;
    }

    public void putAll(Map arg0) {
        this.jmsPropertyContext.putAll(arg0);
    }

    public Object remove(Object key) {
        Object result = this.jmsPropertyContext.remove(key);
        return result;
    }

    public int size() {
        int size = this.jmsPropertyContext.size();
        return size;
    }

    public Collection values() {
        Collection result = this.jmsPropertyContext.values();
        return result;
    }

    public Object mapFromCanonical(JmsPropertyContext context, String keyIn, Object valueIn) {
        return this.mapFromCanonical(keyIn, valueIn);
    }

    public Vector mapToCanonical(JmsPropertyContext context, String keyIn, Object valueIn) {
        return this.mapToCanonical(keyIn, valueIn);
    }

    public Object clone() throws CloneNotSupportedException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyContext", "clone()", null);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            oos.flush();
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object o = ois.readObject();
            if (!$assertionsDisabled && !(o instanceof WMQPropertyContext)) {
                throw new AssertionError();
            }
            WMQPropertyContext newContext = (WMQPropertyContext)o;
            if (Trace.isOn) {
                Trace.data(this, "Created clone", (Object)newContext);
            }
            WMQPropertyContext wMQPropertyContext = newContext;
            return wMQPropertyContext;
        }
        catch (IOException e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException();
            cnse.initCause(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyContext", "clone()", cnse);
            }
            throw cnse;
        }
        catch (ClassNotFoundException e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException();
            cnse.initCause(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyContext", "clone()", cnse);
            }
            throw cnse;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPropertyContext", "clone()");
            }
        }
    }

    static {
        boolean bl = $assertionsDisabled = !WMQPropertyContext.class.desiredAssertionStatus();
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.WMQPropertyContext", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQPropertyContext.java, jmscc.wmq, k701, k701-112-140304  1.40.1.5 11/02/15 09:00:29");
        }
    }
}

