/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.componentmanager.Component;
import com.ibm.msg.client.commonservices.componentmanager.ComponentManager;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderMetaData;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.JMSException;

public class WMQMetaData
implements ProviderMetaData {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Vector jmsXPropertyNames;
    private static final int REF_MAJOR_VERSION = 1;
    private static final int REF_MINOR_VERSION = 0;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQMetaData.java, jmscc.wmq, k701, k701-112-140304 1.22.1.1 09/08/17 07:45:31";
    private int providerMajorVersion;
    private int providerMinorVersion;
    private String providerVersion;
    private static String providerTitle;

    public WMQMetaData(String providerVersion) {
        block7: {
            this.providerMajorVersion = 0;
            this.providerMinorVersion = 0;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQMetaData", "<init>(String)", new Object[]{providerVersion});
            }
            this.providerVersion = providerVersion;
            String[] versions = providerVersion.split("\\.");
            try {
                if (versions.length > 1) {
                    this.providerMajorVersion = Integer.parseInt(versions[0]);
                    if (versions.length > 2) {
                        this.providerMinorVersion = Integer.parseInt(versions[1]);
                    }
                } else {
                    this.providerMajorVersion = Integer.parseInt(providerVersion);
                }
            }
            catch (NumberFormatException e) {
                if (!Trace.isOn) break block7;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQMetaData", "<init>(String)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMetaData", "<init>(String)");
        }
    }

    public String getConnectionTypeName() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQMetaData", "getConnectionTypeName()", "getter", "XMSC_PROVIDER_NAME");
        }
        return "XMSC_PROVIDER_NAME";
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        Enumeration traceRet1 = jmsXPropertyNames.elements();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQMetaData", "getJMSXPropertyNames()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public int getProviderMajorVersion() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQMetaData", "getProviderMajorVersion()", "getter", new Integer(this.providerMajorVersion));
        }
        return this.providerMajorVersion;
    }

    public int getProviderMinorVersion() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQMetaData", "getProviderMinorVersion()", "getter", new Integer(this.providerMinorVersion));
        }
        return this.providerMinorVersion;
    }

    public String getProviderName() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQMetaData", "getProviderName()", "getter", providerTitle);
        }
        return providerTitle;
    }

    public String getProviderVersion() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQMetaData", "getProviderVersion()", "getter", this.providerVersion);
        }
        return this.providerVersion;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.WMQMetaData", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQMetaData.java, jmscc.wmq, k701, k701-112-140304  1.22.1.1 09/08/17 07:45:31");
        }
        jmsXPropertyNames = new Vector();
        providerTitle = null;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQMetaData", "static()");
        }
        jmsXPropertyNames.add("JMSXUserID");
        jmsXPropertyNames.add("JMSXAppID");
        jmsXPropertyNames.add("JMSXDeliveryCount");
        jmsXPropertyNames.add("JMSXGroupID");
        jmsXPropertyNames.add("JMSXGroupSeq");
        ComponentManager compMgr = ComponentManager.getInstance();
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("XMSC_PROVIDER_NAME", "com.ibm.msg.client.wmq");
        try {
            Component[] wmqComp = compMgr.getComponents("MPI", filter);
            if (wmqComp.length > 0) {
                providerTitle = wmqComp[0].getTitle();
            }
        }
        catch (CSIException e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.common.internal.WMQMetaData", "static()", e);
            }
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            data.put("exception", e);
            data.put("filter", filter);
            Trace.ffst("WMQMetaData", "<clinit>", "XM005001", filter, null);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQMetaData", "static()");
        }
    }
}

