/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal;

import com.ibm.msg.client.commonservices.trace.TableBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.trace.TraceFFSTInfo;
import com.ibm.msg.client.provider.ProviderConnection;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.provider.ProviderSession;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class WMQFFSTInfo
implements TraceFFSTInfo {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQFFSTInfo.java, jmscc.wmq, k701, k701-112-140304 1.11.1.3 13/07/26 15:47:47";
    private static Map connections;
    private static Map sessions;
    private static Map consumers;
    private static Map producers;

    public static synchronized String produceInformation(Object sourceObject) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "produceInformation(Object)", new Object[]{sourceObject});
        }
        StringBuffer output = new StringBuffer();
        output.append("Overview of JMS System").append(Trace.lineSeparator);
        output.append("Num. Connections : ").append(connections.size()).append(Trace.lineSeparator);
        output.append("Num. Sessions    : ").append(sessions.size()).append(Trace.lineSeparator);
        output.append("Num. Consumers   : ").append(consumers.size()).append(Trace.lineSeparator);
        output.append("Num. Producers   : ").append(producers.size()).append(Trace.lineSeparator);
        output.append(Trace.lineSeparator).append("Detailed JMS System Information").append(Trace.lineSeparator);
        output.append("Connections      : ").append(Trace.lineSeparator);
        Iterator connIt = connections.keySet().iterator();
        while (connIt.hasNext()) {
            ProviderConnection conn = (ProviderConnection)connIt.next();
            output.append(conn.toString()).append(Trace.lineSeparator);
            output.append(WMQFFSTInfo.formatProps(conn)).append(Trace.lineSeparator).append(Trace.lineSeparator);
        }
        output.append("Sessions         : ").append(Trace.lineSeparator);
        Iterator sessIt = sessions.keySet().iterator();
        while (sessIt.hasNext()) {
            ProviderSession sess = (ProviderSession)sessIt.next();
            output.append(sess.toString()).append(Trace.lineSeparator);
            output.append(WMQFFSTInfo.formatProps(sess)).append(Trace.lineSeparator).append(Trace.lineSeparator);
        }
        output.append("Consumers        : ").append(Trace.lineSeparator);
        Iterator consumersIt = consumers.keySet().iterator();
        while (consumersIt.hasNext()) {
            ProviderMessageConsumer con = (ProviderMessageConsumer)consumersIt.next();
            output.append(con.toString()).append(Trace.lineSeparator);
            output.append(WMQFFSTInfo.formatProps(con)).append(Trace.lineSeparator).append(Trace.lineSeparator);
        }
        output.append("Producers        : ").append(Trace.lineSeparator);
        Iterator producersIt = producers.keySet().iterator();
        while (producersIt.hasNext()) {
            ProviderMessageProducer prod = (ProviderMessageProducer)producersIt.next();
            output.append(prod.toString()).append(Trace.lineSeparator);
            output.append(WMQFFSTInfo.formatProps(prod)).append(Trace.lineSeparator).append(Trace.lineSeparator);
        }
        String traceRet1 = output.toString();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "produceInformation(Object)", (Object)traceRet1);
        }
        return traceRet1;
    }

    private static String formatProps(Map props) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "formatProps(Map)", new Object[]{props});
        }
        Iterator entryIt = props.entrySet().iterator();
        TableBuilder builder = new TableBuilder();
        while (entryIt.hasNext()) {
            Map.Entry entry = entryIt.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equals("XMSC_PASSWORD") && value != null) {
                builder.append(key, "********");
                continue;
            }
            builder.append(key, value == null ? "<null>" : entry.getValue().toString());
        }
        String traceRet1 = builder.toStringBuffer().toString();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "formatProps(Map)", (Object)traceRet1);
        }
        return traceRet1;
    }

    public static synchronized void addConnection(ProviderConnection connection) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "addConnection(ProviderConnection)", new Object[]{connection});
        }
        connections.put(connection, null);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "addConnection(ProviderConnection)");
        }
    }

    public static synchronized void removeConnection(ProviderConnection connection) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "removeConnection(ProviderConnection)", new Object[]{connection});
        }
        connections.remove(connection);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "removeConnection(ProviderConnection)");
        }
    }

    public static synchronized void addSession(ProviderSession session) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "addSession(ProviderSession)", new Object[]{session});
        }
        sessions.put(session, null);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "addSession(ProviderSession)");
        }
    }

    public static synchronized void removeSession(ProviderSession session) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "removeSession(ProviderSession)", new Object[]{session});
        }
        sessions.remove(session);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "removeSession(ProviderSession)");
        }
    }

    public static synchronized void addConsumer(ProviderMessageConsumer consumer) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "addConsumer(ProviderMessageConsumer)", new Object[]{consumer});
        }
        consumers.put(consumer, null);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "addConsumer(ProviderMessageConsumer)");
        }
    }

    public static synchronized void removeConsumer(ProviderMessageConsumer consumer) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "removeConsumer(ProviderMessageConsumer)", new Object[]{consumer});
        }
        consumers.remove(consumer);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "removeConsumer(ProviderMessageConsumer)");
        }
    }

    public static synchronized void addProducer(ProviderMessageProducer producer) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "addProducer(ProviderMessageProducer)", new Object[]{producer});
        }
        producers.put(producer, null);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "addProducer(ProviderMessageProducer)");
        }
    }

    public static synchronized void removeProducer(ProviderMessageProducer producer) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "removeProducer(ProviderMessageProducer)", new Object[]{producer});
        }
        producers.remove(producer);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "removeProducer(ProviderMessageProducer)");
        }
    }

    public String providerInformation(Object sourceObject) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "providerInformation(Object)", new Object[]{sourceObject});
        }
        String traceRet1 = WMQFFSTInfo.produceInformation(sourceObject);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "providerInformation(Object)", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.WMQFFSTInfo", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQFFSTInfo.java, jmscc.wmq, k701, k701-112-140304  1.11.1.3 13/07/26 15:47:47");
        }
        connections = new WeakHashMap();
        sessions = new WeakHashMap();
        consumers = new WeakHashMap();
        producers = new WeakHashMap();
    }
}

