/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal;

import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.JMSException;

public class WMQDestinationURIParser {
    private static Set uriExcludeProperties = new HashSet();
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQDestinationURIParser.java, jmscc.wmq, k701, k701-112-140304 1.32.1.4 11/03/24 11:38:21";
    private static final char SUBTOPIC_MATCHMANY_CHAR = '#';
    private static final char SUBTOPIC_MATCHONE_CHAR = '+';
    private static final char SUBTOPIC_SEPARATOR_CHAR = '/';
    private boolean uriOutputTxtBaseCacheValid = false;
    private boolean uriOutputTxtPropsCacheValid = false;
    private String uriOutputTxtBaseCache = "";
    private String uriOutputTxtPropsCache = "";
    private int uriDomain = -1;
    private String uriName = "";
    private String uriQMName = "";
    private HashMap uriProps = new HashMap();

    public WMQDestinationURIParser() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "<init>()");
        }
        this.initialise();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "<init>()");
        }
    }

    public WMQDestinationURIParser(String uri) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "<init>(String)", new Object[]{uri});
        }
        this.initialise();
        this.setUri(uri);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "<init>(String)");
        }
    }

    public int getDomain() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "getDomain()", "getter", new Integer(this.uriDomain));
        }
        return this.uriDomain;
    }

    public void setDomain(int domain) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setDomain(int)", new Object[]{new Integer(domain)});
        }
        switch (domain) {
            case 1: 
            case 2: {
                this.uriDomain = domain;
                break;
            }
            default: {
                this.uriDomain = -1;
            }
        }
        this.uriOutputTxtBaseCacheValid = false;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setDomain(int)");
        }
    }

    public String getDestinationName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "getDestinationName()", "getter", this.uriName);
        }
        return this.uriName;
    }

    public void setDestinationName(String destName) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setDestinationName(String)", "setter", destName);
        }
        this.uriName = destName == null ? "" : destName;
        this.uriOutputTxtBaseCacheValid = false;
    }

    public String getQmName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "getQmName()", "getter", this.uriQMName);
        }
        return this.uriQMName;
    }

    public void setQmName(String qmName) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setQmName(String)", "setter", qmName);
        }
        this.uriQMName = qmName == null ? "" : qmName;
        this.uriOutputTxtBaseCacheValid = false;
    }

    public HashMap getProps() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "getProps()", "getter", this.uriProps);
        }
        return this.uriProps;
    }

    public void getPropsIntoPropertyContext(JmsPropertyContext jmsProps) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "getPropsIntoPropertyContext(JmsPropertyContext)", new Object[]{jmsProps});
        }
        Iterator propertyNames = this.uriProps.keySet().iterator();
        while (propertyNames.hasNext()) {
            String name;
            Object val = this.uriProps.get(name = (String)propertyNames.next());
            jmsProps.setStringProperty(name, val == null ? null : val.toString());
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "getPropsIntoPropertyContext(JmsPropertyContext)");
        }
    }

    public void setProps(HashMap props) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setProps(HashMap)", "setter", props);
        }
        if (props != null) {
            this.uriProps = props;
            this.uriOutputTxtPropsCacheValid = false;
        }
    }

    public String getURI() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "getURI()");
        }
        StringBuffer destURI = new StringBuffer();
        if (this.uriOutputTxtBaseCacheValid) {
            destURI.append(this.uriOutputTxtBaseCache);
        } else {
            if (this.uriDomain == 1) {
                destURI.append("queue://");
                destURI.append(this.uriQMName);
                destURI.append("/");
            } else if (this.uriDomain == 2) {
                destURI.append("topic://");
            } else {
                destURI.append("://");
            }
            destURI.append(this.uriName);
            this.uriOutputTxtBaseCache = destURI.toString();
            this.uriOutputTxtBaseCacheValid = true;
        }
        if (this.uriOutputTxtPropsCacheValid) {
            destURI.append(this.uriOutputTxtPropsCache);
        } else {
            boolean first = true;
            StringBuffer destProps = new StringBuffer();
            Iterator propertyNames = this.uriProps.keySet().iterator();
            while (propertyNames.hasNext()) {
                String value;
                String unEscapedName = (String)propertyNames.next();
                if (uriExcludeProperties.contains(unEscapedName)) continue;
                String name = this.addEscapes(unEscapedName);
                Object v = this.uriProps.get(unEscapedName);
                String string = value = v == null ? "" : v.toString();
                if (!name.equals("ibmxml")) {
                    value = this.addEscapes(value);
                }
                if (first) {
                    destProps.append("?");
                } else {
                    destProps.append("&");
                }
                destProps.append(name).append("=").append(value);
                first = false;
            }
            String s = destProps.toString();
            destURI.append(s);
            this.uriOutputTxtPropsCache = s;
            this.uriOutputTxtPropsCacheValid = true;
        }
        String result = destURI.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "getURI()", result);
        }
        return result;
    }

    public void setUri(String uri) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setUri(String)", new Object[]{uri});
        }
        String uriBaseTxt = "";
        String uriPropsTxt = "";
        boolean isValidUri = false;
        if (uri == null || uri.trim().length() == 0) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_DESTINATION_NAME", uri);
            JMSException je1 = (JMSException)((Object)NLSServices.createException("JMSCMQ0005", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setUri(String)", je1, 1);
            }
            throw je1;
        }
        String name = uri = uri.trim();
        if (name.startsWith("queue://") && this.uriDomain != 2) {
            this.uriDomain = 1;
            int qmIndex = (name = name.substring("queue://".length())).indexOf("/");
            if (qmIndex == 0) {
                name = name.substring(1);
            } else if (qmIndex > 0) {
                this.uriQMName = name.substring(0, qmIndex);
                name = name.substring(qmIndex + 1);
            } else {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_DESTINATION_NAME", uri);
                JMSException je2 = (JMSException)((Object)NLSServices.createException("JMSCMQ0005", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setUri(String)", je2, 2);
                }
                throw je2;
            }
            isValidUri = true;
        } else if (name.startsWith("topic://") && this.uriDomain != 1) {
            this.uriDomain = 2;
            name = name.substring("topic://".length());
            isValidUri = true;
        }
        if ((uri.startsWith("topic://") || uri.startsWith("queue://")) && isValidUri) {
            int propIndex = name.indexOf(63);
            if (propIndex > 0) {
                String props = name.substring(propIndex + 1);
                uriPropsTxt = name.substring(propIndex);
                uriBaseTxt = uri.substring(0, uri.length() - uriPropsTxt.length());
                name = name.substring(0, propIndex);
                StringTokenizer propToks = new StringTokenizer(props, "&");
                while (propToks.hasMoreTokens()) {
                    String tok = propToks.nextToken();
                    int delim = tok.indexOf(61);
                    if (delim <= 0) continue;
                    String propName = tok.substring(0, delim);
                    String propValue = tok.substring(delim + 1);
                    try {
                        propName = URLDecoder.decode(propName, "UTF8");
                        propValue = URLDecoder.decode(propValue, "UTF8");
                    }
                    catch (NoSuchMethodError e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setUri(String)", e, 1);
                        }
                        if (Trace.isOn) {
                            Trace.data(this, "setUri(String)", (Object)"URLDecoder was used with 1.3.1 jvm this is not supported");
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setUri(String)", e, 2);
                        }
                        HashMap<String, String> inserts = new HashMap<String, String>();
                        inserts.put("XMSC_DESTINATION_NAME", uri);
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0005", inserts));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setUri(String)", je, 3);
                        }
                        throw je;
                    }
                    this.uriProps.put(propName, propValue);
                }
            } else {
                uriBaseTxt = uri;
                uriPropsTxt = "";
            }
        }
        if (name == null || name.equals("") || name.indexOf("://") != -1) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_DESTINATION_NAME", uri);
            JMSException je3 = (JMSException)((Object)NLSServices.createException("JMSCMQ0005", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setUri(String)", je3, 4);
            }
            throw je3;
        }
        this.uriName = name;
        if (isValidUri) {
            this.uriOutputTxtBaseCache = uriBaseTxt;
            this.uriOutputTxtPropsCache = uriPropsTxt;
            this.uriOutputTxtBaseCacheValid = true;
            this.uriOutputTxtPropsCacheValid = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "setUri(String)");
        }
    }

    public boolean containsAnyWildcard(int brokerVersion) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "containsAnyWildcard(int)", new Object[]{new Integer(brokerVersion)});
        }
        String topicString = null;
        topicString = this.getDestinationName();
        if (topicString != null) {
            if (brokerVersion == 0) {
                if (topicString.indexOf(42) >= 0 || topicString.indexOf(63) >= 0) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "containsAnyWildcard(int)", true, 1);
                    }
                    return true;
                }
            } else if (topicString.indexOf(43) >= 0 || topicString.indexOf(35) >= 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "containsAnyWildcard(int)", true, 2);
                }
                return true;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "containsAnyWildcard(int)", false, 3);
        }
        return false;
    }

    public boolean containsWildcard() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "containsWildcard()");
        }
        boolean result = false;
        String topicString = null;
        topicString = this.getDestinationName();
        boolean bl = result = this.findFirstMatchManyWildcard(topicString) >= 0 || this.findFirstMatchOneWildcard(topicString) >= 0;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "containsWildcard()", result);
        }
        return result;
    }

    private final int findFirstMatchManyWildcard(String topic) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchManyWildcard(String)", new Object[]{topic});
        }
        int firstOccurrence = -1;
        int topiclength = topic.length();
        if (topic == null || topiclength == 0) {
            int traceRet1 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchManyWildcard(String)", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        if (topiclength == 1) {
            if (topic.charAt(0) == '#') {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchManyWildcard(String)", new Integer(0), 2);
                }
                return 0;
            }
            int traceRet2 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchManyWildcard(String)", new Integer(traceRet2), 3);
            }
            return traceRet2;
        }
        if (topic.charAt(0) == '#' && topic.charAt(1) == '/') {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchManyWildcard(String)", new Integer(0), 4);
            }
            return 0;
        }
        firstOccurrence = topic.indexOf("/#/");
        if (firstOccurrence != -1) {
            int traceRet3 = firstOccurrence + 1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchManyWildcard(String)", new Integer(traceRet3), 5);
            }
            return traceRet3;
        }
        if (topic.charAt(topiclength - 2) == '/' && topic.charAt(topiclength - 1) == '#') {
            int traceRet4 = topiclength - 1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchManyWildcard(String)", new Integer(traceRet4), 6);
            }
            return traceRet4;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchManyWildcard(String)", new Integer(firstOccurrence), 7);
        }
        return firstOccurrence;
    }

    private final int findFirstMatchOneWildcard(String topic) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchOneWildcard(String)", new Object[]{topic});
        }
        int firstOccurrence = -1;
        int topiclength = topic.length();
        if (topic == null || topiclength == 0) {
            int traceRet1 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchOneWildcard(String)", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        if (topiclength == 1) {
            if (topic.charAt(0) == '+') {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchOneWildcard(String)", new Integer(0), 2);
                }
                return 0;
            }
            int traceRet2 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchOneWildcard(String)", new Integer(traceRet2), 3);
            }
            return traceRet2;
        }
        if (topic.charAt(0) == '+' && topic.charAt(1) == '/') {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchOneWildcard(String)", new Integer(0), 4);
            }
            return 0;
        }
        firstOccurrence = topic.indexOf("/+/");
        if (firstOccurrence != -1) {
            int traceRet3 = firstOccurrence + 1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchOneWildcard(String)", new Integer(traceRet3), 5);
            }
            return traceRet3;
        }
        if (topic.charAt(topiclength - 2) == '/' && topic.charAt(topiclength - 1) == '+') {
            int traceRet4 = topiclength - 1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchOneWildcard(String)", new Integer(traceRet4), 6);
            }
            return traceRet4;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "findFirstMatchOneWildcard(String)", new Integer(firstOccurrence), 7);
        }
        return firstOccurrence;
    }

    private void initialise() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "initialise()");
        }
        this.uriOutputTxtBaseCacheValid = false;
        this.uriOutputTxtPropsCacheValid = false;
        this.uriOutputTxtBaseCache = "";
        this.uriOutputTxtPropsCache = "";
        this.uriDomain = -1;
        this.uriName = "";
        this.uriQMName = "";
        this.uriProps.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "initialise()");
        }
    }

    private String addEscapes(String txt) {
        String retTxt;
        block8: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "addEscapes(String)", new Object[]{txt});
            }
            retTxt = txt;
            try {
                retTxt = URLEncoder.encode(retTxt, "UTF8");
            }
            catch (NoSuchMethodError e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "addEscapes(String)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.data(this, "addEscapes(String)", (Object)"URLEncoder was used with 1.3.1 jvm this is not supported");
                }
            }
            catch (UnsupportedEncodingException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "addEscapes(String)", e, 2);
                }
                if (!Trace.isOn) break block8;
                Trace.data(this, "addEscapes(String)", (Object)"UTF-8 encoder not supported - URI escape sequences not processed");
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "addEscapes(String)", retTxt);
        }
        return retTxt;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser", "static", "SCCS id", (Object)sccsid);
        }
        uriExcludeProperties.add("XMSC_OBJECT_IDENTITY");
        uriExcludeProperties.add("OBJECT_IDENTITY");
    }
}

