/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal;

import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.jms.JmsTopic;
import com.ibm.msg.client.provider.ProviderConnection;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.wmq.common.internal.WMQCommonConnection;
import com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.common.internal.WMQStandardValidators;
import com.ibm.msg.client.wmq.common.internal.WMQValidationInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.jms.JMSException;

public class WMQDestination
extends WMQPropertyContext
implements ProviderDestination {
    private static final long serialVersionUID = -3208663426915897132L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/WMQDestination.java, jmscc.wmq, k701, k701-112-140304 1.81.1.9 11/03/24 18:41:24";
    private static final Pattern validNamePattern;
    private boolean hasBeenDeleted;
    private boolean isTemporary;
    protected WMQCommonConnection connection;
    private String name;
    private int destType;
    private JmsPropertyContext properties;
    private boolean validationEnabled = true;
    private int useageCount = 0;
    private static final Map propertyValidators;
    private WMQDestinationURIParser uriParser = new WMQDestinationURIParser();
    private boolean destBaseChanged;
    private boolean destPropsChanged;
    private HashMap destProps;
    private boolean cacheInitialised;
    private CacheProperty cachedDestinationName;
    private CacheProperty cachedDeliveryMode;
    private CacheProperty cachedEncoding;
    private CacheProperty cachedCCSID;
    private CacheProperty cachedTargetClient;
    private CacheProperty cachedPriority;
    private CacheProperty cachedDestDescription;
    private CacheProperty cachedFailIfQuiesce;
    private CacheProperty cachedPutAsyncAllowed;
    private CacheProperty cachedReadAheadAllowed;
    private CacheProperty cachedReadAheadClosePolicy;
    private CacheProperty cachedWildcardFormat;
    private CacheProperty cachedTimeToLive;
    private CacheProperty cachedMessageContext;
    private CacheProperty cachedMdWriteEnabled;
    private CacheProperty cachedMdReadEnabled;
    private CacheProperty cachedMessageBodyStyle;
    private CacheProperty cachedRemoteQueueManager;
    private CacheProperty cachedBrokerCCDurSubQ;
    private CacheProperty cachedBrokerDurSubQ;
    private CacheProperty cachedBrokerPubQ;
    private CacheProperty cachedBrokerPubQQMgr;
    private CacheProperty cachedBrokerVersion;
    private CacheProperty cachedMulticast;
    private CacheProperty cachedVersion;
    private CacheProperty cachedReplyToStyle;
    private CacheProperty cachedReceiveCCSID;
    private CacheProperty cachedReceiveConversion;
    private Boolean supportsNPHigh = null;

    public WMQDestination(int destType, String name, JmsPropertyContext props) throws JMSException {
        this(false, destType, name, null, props);
    }

    WMQDestination(boolean isTemporary, int destType, String name, ProviderConnection connection, JmsPropertyContext props) throws JMSException {
        super(props);
        int domain;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "<init>(boolean,int,String,ProviderConnection,JmsPropertyContext)", new Object[]{isTemporary, new Integer(destType), name, connection, props});
        }
        this.destType = destType;
        this.isTemporary = isTemporary;
        this.connection = (WMQCommonConnection)connection;
        this.properties = props;
        this.hasBeenDeleted = false;
        this.uriParser.setDomain(destType);
        if (name != null) {
            this.uriParser.setUri(name);
            this.setStringProperty("XMSC_DESTINATION_NAME", this.uriParser.getDestinationName());
            this.setStringProperty("XMSC_WMQ_QUEUE_MANAGER", this.uriParser.getQmName());
            this.uriParser.getPropsIntoPropertyContext(this);
            this.destBaseChanged = false;
            this.destPropsChanged = false;
        }
        if ((domain = this.uriParser.getDomain()) != this.destType) {
            this.destType = domain;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "<init>(boolean,int,String,ProviderConnection,JmsPropertyContext)");
        }
    }

    private void initialiseDefaultCacheProperties() {
        this.cachedDestinationName = new CacheProperty("XMSC_DESTINATION_NAME", null, true);
        this.cachedPriority = new CacheProperty("priority", new Integer(-2), false);
        this.cachedDeliveryMode = new CacheProperty("deliveryMode", "persistence", new Integer(-2), false);
        this.cachedTimeToLive = new CacheProperty("timeToLive", "expiry", new Integer(-2), false);
        this.cachedCCSID = new CacheProperty("CCSID", new Integer(1208), false);
        this.cachedReceiveCCSID = new CacheProperty("receiveCCSID", new Integer(1208), false);
        this.cachedReceiveConversion = new CacheProperty("receiveConversion", new Integer(1), false);
        this.cachedDestDescription = new CacheProperty("destDescription", null, false);
        this.cachedEncoding = new CacheProperty("encoding", new Integer(273), false);
        this.cachedFailIfQuiesce = new CacheProperty("failIfQuiesce", new Integer(1), false);
        this.cachedMessageContext = new CacheProperty("mdMessageContext", new Integer(0), false);
        this.cachedMdWriteEnabled = new CacheProperty("mdWriteEnabled", new Boolean(false), false);
        this.cachedMdReadEnabled = new CacheProperty("mdReadEnabled", new Boolean(false), false);
        this.cachedMessageBodyStyle = new CacheProperty("messageBody", new Integer(2), false);
        this.cachedPutAsyncAllowed = new CacheProperty("putAsyncAllowed", new Integer(-1), false);
        this.cachedReadAheadAllowed = new CacheProperty("readAheadAllowed", new Integer(-1), false);
        this.cachedReadAheadClosePolicy = new CacheProperty("readAheadClosePolicy", new Integer(2), false);
        this.cachedTargetClient = new CacheProperty("targetClient", new Integer(0), false);
        this.cachedWildcardFormat = new CacheProperty("wildcardFormat", new Integer(0), false);
        this.cachedVersion = new CacheProperty("version", new Integer(7), false);
        this.cachedRemoteQueueManager = new CacheProperty("XMSC_WMQ_QUEUE_MANAGER", "", true);
        this.cachedBrokerCCDurSubQ = new CacheProperty("brokerCCDurSubQueue", "SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE", false);
        this.cachedBrokerDurSubQ = new CacheProperty("brokerDurSubQueue", "SYSTEM.JMS.D.SUBSCRIBER.QUEUE", false);
        this.cachedBrokerPubQ = new CacheProperty("XMSC_WMQ_BROKER_PUBQ", "", false);
        this.cachedBrokerPubQQMgr = new CacheProperty("XMSC_WMQ_BROKER_PUBQ_QMGR", "", false);
        this.cachedBrokerVersion = new CacheProperty("brokerVersion", new Integer(0), false);
        this.cachedMulticast = new CacheProperty("multicast", new Integer(-1), false);
        this.cachedReplyToStyle = new CacheProperty("XMSC_WMQ_REPLYTO_STYLE", new Integer(0), true);
    }

    public void delete() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "delete()");
        }
        if (!this.isTemporary) {
            Trace.ffst(this, "delete()", "XM002001", null, null);
            JMSException jmsex = (JMSException)((Object)NLSServices.createException("JMSCMQ0003", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "delete()", jmsex);
            }
            throw jmsex;
        }
        if (this.connection != null) {
            this.connection.deleteTemporaryDestination(this);
        }
        this.hasBeenDeleted = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "delete()");
        }
    }

    public String getName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getName()");
        }
        if (this.name != null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getName()", this.name, 1);
            }
            return this.name;
        }
        try {
            String traceRet1 = this.getStringProperty("XMSC_DESTINATION_NAME");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getName()", traceRet1, 2);
            }
            return traceRet1;
        }
        catch (JMSException j) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getName()", j);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getName()", null, 3);
            }
            return null;
        }
    }

    public boolean isQueue() {
        boolean result;
        boolean bl = result = this.destType == 1;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "isQueue()", "getter", result);
        }
        return result;
    }

    public boolean isTemporary() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "isTemporary()", "getter", this.isTemporary);
        }
        return this.isTemporary;
    }

    public boolean isTopic() {
        boolean result;
        boolean bl = result = this.destType == 2;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "isTopic()", "getter", result);
        }
        return result;
    }

    public void setFailIfQuiesce(int fiq) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "setFailIfQuiesce(int)", "setter", new Integer(fiq));
        }
        this.setIntProperty("failIfQuiesce", fiq);
    }

    public int getFailIfQuiesce() {
        int fiq;
        block5: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getFailIfQuiesce()");
            }
            fiq = 0;
            try {
                fiq = this.getIntProperty("failIfQuiesce");
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getFailIfQuiesce()", je);
                }
                if (!Trace.isOn) break block5;
                Trace.data(this, "public int getFailIfQuiesce()", "Exception thrown querying property. Assuming default", (Object)je);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getFailIfQuiesce()", new Integer(fiq));
        }
        return fiq;
    }

    public boolean isNPHighCheckDone() {
        boolean traceRet1;
        boolean bl = traceRet1 = this.supportsNPHigh != null;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "isNPHighCheckDone()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public boolean getNPHighSupported() {
        boolean traceRet1;
        boolean bl = traceRet1 = this.supportsNPHigh != null && this.supportsNPHigh != false;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getNPHighSupported()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setNPHighSupported(boolean value) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "setNPHighSupported(boolean)", "setter", value);
        }
        this.supportsNPHigh = new Boolean(value);
    }

    public String toURI() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "toURI()");
        }
        if (this.destBaseChanged) {
            if (this.isQueue()) {
                String qmName = this.cachedRemoteQueueManager.value == null ? "" : this.cachedRemoteQueueManager.value.toString();
                this.uriParser.setQmName(qmName);
            }
            String name = this.cachedDestinationName.value == null ? "" : this.cachedDestinationName.value.toString();
            this.uriParser.setDestinationName(name);
            this.destBaseChanged = false;
        }
        if (this.destPropsChanged) {
            this.uriParser.setProps(this.destProps);
            this.destPropsChanged = false;
        }
        String uri = this.uriParser.getURI();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "toURI()", uri);
        }
        return uri;
    }

    public boolean containsAnyWildcard() {
        int brokerVersion;
        boolean result;
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "containsAnyWildcard()");
            }
            result = false;
            brokerVersion = 0;
            try {
                brokerVersion = this.getIntProperty("brokerVersion");
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "containsAnyWildcard()", je);
            }
        }
        result = this.uriParser.containsAnyWildcard(brokerVersion);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "containsAnyWildcard()", result);
        }
        return result;
    }

    public boolean containsWildcard() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "containsWildcard()");
        }
        boolean result = false;
        result = this.uriParser.containsWildcard();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "containsWildcard()", result);
        }
        return result;
    }

    public Object getCachedValue(String key) {
        CacheProperty prop;
        if (!this.cacheInitialised) {
            this.initialiseDefaultCacheProperties();
            this.cacheInitialised = true;
        }
        if ((prop = this.findCacheProperty(key)) != null && prop.exists) {
            return prop.value;
        }
        return null;
    }

    public boolean setCachedValue(String key, Object value) {
        CacheProperty prop;
        if (!this.cacheInitialised) {
            this.initialiseDefaultCacheProperties();
            this.cacheInitialised = true;
        }
        if ((prop = this.findCacheProperty(key)) != null) {
            prop.setValue(value);
            if (prop.baseProperty) {
                this.destBaseChanged = true;
            } else {
                Object defaultVal = prop.defaultValue;
                this.checkForURIChange(prop.uriName, value, defaultVal == null ? null : defaultVal.toString());
                this.destPropsChanged = true;
            }
            return true;
        }
        if (key.equals("XMSC_CONNECTION_TYPE_NAME") || key.equals("XMSC_CONNECTION_TYPE") || key.equals("XMSC_ADMIN_OBJECT_TYPE")) {
            return false;
        }
        if (this.destProps == null) {
            this.destProps = new HashMap();
        }
        this.destProps.put(key, value == null ? null : value.toString());
        this.destPropsChanged = true;
        return false;
    }

    public void clearCachedValue(String key) {
        CacheProperty prop;
        if (!this.cacheInitialised) {
            this.initialiseDefaultCacheProperties();
            this.cacheInitialised = true;
        }
        if ((prop = this.findCacheProperty(key)) != null) {
            prop.clear();
            if (prop.baseProperty) {
                this.destBaseChanged = true;
            }
        }
        this.destPropsChanged = true;
    }

    public void getCachedValueAll(Map props) {
        if (!this.cacheInitialised) {
            this.initialiseDefaultCacheProperties();
            this.cacheInitialised = true;
        }
        if (this.cachedDestinationName.exists) {
            props.put(this.cachedDestinationName.name, this.cachedDestinationName.value);
        }
        if (this.cachedPriority.exists) {
            props.put(this.cachedPriority.name, this.cachedPriority.value);
        }
        if (this.cachedDeliveryMode.exists) {
            props.put(this.cachedDeliveryMode.name, this.cachedDeliveryMode.value);
        }
        if (this.cachedTimeToLive.exists) {
            props.put(this.cachedTimeToLive.name, this.cachedTimeToLive.value);
        }
        if (this.cachedCCSID.exists) {
            props.put(this.cachedCCSID.name, this.cachedCCSID.value);
        }
        if (this.cachedReceiveCCSID.exists) {
            props.put(this.cachedReceiveCCSID.name, this.cachedReceiveCCSID.value);
        }
        if (this.cachedReceiveConversion.exists) {
            props.put(this.cachedReceiveConversion.name, this.cachedReceiveConversion.value);
        }
        if (this.cachedDestDescription.exists) {
            props.put(this.cachedDestDescription.name, this.cachedDestDescription.value);
        }
        if (this.cachedEncoding.exists) {
            props.put(this.cachedEncoding.name, this.cachedEncoding.value);
        }
        if (this.cachedFailIfQuiesce.exists) {
            props.put(this.cachedFailIfQuiesce.name, this.cachedFailIfQuiesce.value);
        }
        if (this.cachedMessageContext.exists) {
            props.put(this.cachedMessageContext.name, this.cachedMessageContext.value);
        }
        if (this.cachedMdWriteEnabled.exists) {
            props.put(this.cachedMdWriteEnabled.name, this.cachedMdWriteEnabled.value);
        }
        if (this.cachedMdReadEnabled.exists) {
            props.put(this.cachedMdReadEnabled.name, this.cachedMdReadEnabled.value);
        }
        if (this.cachedMessageBodyStyle.exists) {
            props.put(this.cachedMessageBodyStyle.name, this.cachedMessageBodyStyle.value);
        }
        if (this.cachedPutAsyncAllowed.exists) {
            props.put(this.cachedPutAsyncAllowed.name, this.cachedPutAsyncAllowed.value);
        }
        if (this.cachedReadAheadAllowed.exists) {
            props.put(this.cachedReadAheadAllowed.name, this.cachedReadAheadAllowed.value);
        }
        if (this.cachedReadAheadClosePolicy.exists) {
            props.put(this.cachedReadAheadClosePolicy.name, this.cachedReadAheadClosePolicy.value);
        }
        if (this.cachedTargetClient.exists) {
            props.put(this.cachedTargetClient.name, this.cachedTargetClient.value);
        }
        if (this.cachedWildcardFormat.exists) {
            props.put(this.cachedWildcardFormat.name, this.cachedWildcardFormat.value);
        }
        if (this.cachedVersion.exists) {
            props.put(this.cachedVersion.name, this.cachedVersion.value);
        }
        if (this.cachedRemoteQueueManager.exists) {
            props.put(this.cachedRemoteQueueManager.name, this.cachedRemoteQueueManager.value);
        }
        if (this.cachedBrokerCCDurSubQ.exists) {
            props.put(this.cachedBrokerCCDurSubQ.name, this.cachedBrokerCCDurSubQ.value);
        }
        if (this.cachedBrokerDurSubQ.exists) {
            props.put(this.cachedBrokerDurSubQ.name, this.cachedBrokerDurSubQ.value);
        }
        if (this.cachedBrokerPubQ.exists) {
            props.put(this.cachedBrokerPubQ.name, this.cachedBrokerPubQ.value);
        }
        if (this.cachedBrokerPubQQMgr.exists) {
            props.put(this.cachedBrokerPubQQMgr.name, this.cachedBrokerPubQQMgr.value);
        }
        if (this.cachedBrokerVersion.exists) {
            props.put(this.cachedBrokerVersion.name, this.cachedBrokerVersion.value);
        }
        if (this.cachedMulticast.exists) {
            props.put(this.cachedMulticast.name, this.cachedMulticast.value);
        }
        if (this.cachedReplyToStyle.exists) {
            props.put(this.cachedReplyToStyle.name, this.cachedReplyToStyle.value);
        }
    }

    public void clearCachedValueAll() {
        if (!this.cacheInitialised) {
            this.initialiseDefaultCacheProperties();
            this.cacheInitialised = true;
        }
        this.cachedDestinationName.clear();
        this.cachedDeliveryMode.clear();
        this.cachedEncoding.clear();
        this.cachedCCSID.clear();
        this.cachedTargetClient.clear();
        this.cachedPriority.clear();
        this.cachedDestDescription.clear();
        this.cachedFailIfQuiesce.clear();
        this.cachedPutAsyncAllowed.clear();
        this.cachedReadAheadAllowed.clear();
        this.cachedReadAheadClosePolicy.clear();
        this.cachedWildcardFormat.clear();
        this.cachedTimeToLive.clear();
        this.cachedMessageContext.clear();
        this.cachedMdWriteEnabled.clear();
        this.cachedMdReadEnabled.clear();
        this.cachedMessageBodyStyle.clear();
        this.cachedRemoteQueueManager.clear();
        this.cachedBrokerCCDurSubQ.clear();
        this.cachedBrokerDurSubQ.clear();
        this.cachedBrokerPubQ.clear();
        this.cachedBrokerPubQQMgr.clear();
        this.cachedBrokerVersion.clear();
        this.cachedMulticast.clear();
        this.cachedVersion.clear();
        this.cachedReplyToStyle.clear();
    }

    public boolean containsCachedValue(String key) {
        if (!this.cacheInitialised) {
            this.initialiseDefaultCacheProperties();
            this.cacheInitialised = true;
        }
        boolean found = false;
        CacheProperty prop = this.findCacheProperty(key);
        if (prop != null && prop.exists) {
            found = true;
        }
        return found;
    }

    private CacheProperty findCacheProperty(String key) {
        CacheProperty prop = null;
        if (key.equals(this.cachedDestinationName.name)) {
            prop = this.cachedDestinationName;
        } else if (key.equals(this.cachedPriority.name)) {
            prop = this.cachedPriority;
        } else if (key.equals(this.cachedDeliveryMode.name)) {
            prop = this.cachedDeliveryMode;
        } else if (key.equals(this.cachedTimeToLive.name)) {
            prop = this.cachedTimeToLive;
        } else if (key.equals(this.cachedTargetClient.name)) {
            prop = this.cachedTargetClient;
        } else if (key.equals(this.cachedEncoding.name)) {
            prop = this.cachedEncoding;
        } else if (key.equals(this.cachedCCSID.name)) {
            prop = this.cachedCCSID;
        } else if (key.equals(this.cachedReceiveCCSID.name)) {
            prop = this.cachedReceiveCCSID;
        } else if (key.equals(this.cachedReceiveConversion.name)) {
            prop = this.cachedReceiveConversion;
        } else if (key.equals(this.cachedDestDescription.name)) {
            prop = this.cachedDestDescription;
        } else if (key.equals(this.cachedFailIfQuiesce.name)) {
            prop = this.cachedFailIfQuiesce;
        } else if (key.equals(this.cachedPutAsyncAllowed.name)) {
            prop = this.cachedPutAsyncAllowed;
        } else if (key.equals(this.cachedReadAheadAllowed.name)) {
            prop = this.cachedReadAheadAllowed;
        } else if (key.equals(this.cachedReadAheadClosePolicy.name)) {
            prop = this.cachedReadAheadClosePolicy;
        } else if (key.equals(this.cachedWildcardFormat.name)) {
            prop = this.cachedWildcardFormat;
        } else if (key.equals(this.cachedMessageContext.name)) {
            prop = this.cachedMessageContext;
        } else if (key.equals(this.cachedMdWriteEnabled.name)) {
            prop = this.cachedMdWriteEnabled;
        } else if (key.equals(this.cachedMdReadEnabled.name)) {
            prop = this.cachedMdReadEnabled;
        } else if (key.equals(this.cachedMessageBodyStyle.name)) {
            prop = this.cachedMessageBodyStyle;
        } else if (key.equals(this.cachedRemoteQueueManager.name)) {
            prop = this.cachedRemoteQueueManager;
        } else if (key.equals(this.cachedBrokerCCDurSubQ.name)) {
            prop = this.cachedBrokerCCDurSubQ;
        } else if (key.equals(this.cachedBrokerDurSubQ.name)) {
            prop = this.cachedBrokerDurSubQ;
        } else if (key.equals(this.cachedBrokerPubQ.name)) {
            prop = this.cachedBrokerPubQ;
        } else if (key.equals(this.cachedBrokerPubQQMgr.name)) {
            prop = this.cachedBrokerPubQQMgr;
        } else if (key.equals(this.cachedBrokerVersion.name)) {
            prop = this.cachedBrokerVersion;
        } else if (key.equals(this.cachedMulticast.name)) {
            prop = this.cachedMulticast;
        } else if (key.equals(this.cachedVersion.name)) {
            prop = this.cachedVersion;
        } else if (key.equals(this.cachedReplyToStyle.name)) {
            prop = this.cachedReplyToStyle;
        }
        return prop;
    }

    private void checkForURIChange(String propName, Object val, String defaultVal) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "checkForURIChange(String,Object,String)", new Object[]{propName, val, defaultVal});
        }
        if (this.destProps == null) {
            this.destProps = new HashMap();
        }
        if (!(val == defaultVal || val != null && val.toString().equals(defaultVal))) {
            this.destProps.put(propName, val);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "checkForURIChange(String,Object,String)", 1);
            }
            return;
        }
        this.destProps.remove(propName);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "checkForURIChange(String,Object,String)", 2);
        }
    }

    public Object mapFromCanonical(String keyIn, Object valueIn) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "mapFromCanonical(String,Object)", new Object[]{keyIn, valueIn});
        }
        if (propertyValidators.size() > 0) {
            WMQStandardValidators.WMQPropertyValidator mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn);
            if (mapper != null) {
                WMQValidationInterface.WMQPropertyValidatorDatatype mappedPair = mapper.fromCanonical(keyIn, valueIn);
                Object traceRet1 = mappedPair.getValue();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "mapFromCanonical(String,Object)", traceRet1, 1);
                }
                return traceRet1;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "mapFromCanonical(String,Object)", valueIn, 2);
            }
            return valueIn;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "mapFromCanonical(String,Object)", valueIn, 3);
        }
        return valueIn;
    }

    public String getCanonicalKey(String keyIn) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getCanonicalKey(String)", new Object[]{keyIn});
        }
        if (propertyValidators.size() > 0) {
            WMQStandardValidators.WMQPropertyValidator mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn);
            if (mapper == null) {
                mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn.toUpperCase());
            }
            if (mapper != null) {
                String traceRet1 = mapper.getDomainName(4);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getCanonicalKey(String)", traceRet1, 1);
                }
                return traceRet1;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getCanonicalKey(String)", keyIn, 2);
            }
            return keyIn;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "getCanonicalKey(String)", keyIn, 3);
        }
        return keyIn;
    }

    public Vector mapToCanonical(String keyIn, Object valueIn) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "mapToCanonical(String,Object)", new Object[]{keyIn, valueIn});
        }
        Vector<Object> result = new Vector<Object>();
        if (propertyValidators.size() > 0) {
            WMQStandardValidators.WMQPropertyValidator mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn);
            if (mapper == null) {
                mapper = (WMQStandardValidators.WMQPropertyValidator)propertyValidators.get(keyIn.toUpperCase());
            }
            if (mapper != null) {
                WMQValidationInterface.WMQPropertyValidatorDatatype mappedPair = mapper.toCanonical(keyIn, valueIn);
                result.add(mappedPair.getName());
                result.add(mappedPair.getValue());
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "mapToCanonical(String,Object)", result, 1);
                }
                return result;
            }
            result.add(keyIn);
            result.add(valueIn);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "mapToCanonical(String,Object)", result, 2);
            }
            return result;
        }
        result.add(keyIn);
        result.add(valueIn);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "mapToCanonical(String,Object)", result, 3);
        }
        return result;
    }

    public boolean validate(Object name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "validate(Object,Object)", new Object[]{name, value});
        }
        if (this.validationEnabled && propertyValidators.size() > 0) {
            Object mqValidator = propertyValidators.get(name);
            if (mqValidator == null && name instanceof String) {
                mqValidator = propertyValidators.get(((String)name).toUpperCase());
            }
            if (mqValidator != null) {
                boolean traceRet1 = ((WMQStandardValidators.WMQPropertyValidator)mqValidator).validate(value, this.jmsPropertyContext);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "validate(Object,Object)", traceRet1, 1);
                }
                return traceRet1;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Unable to find validator for property " + name + " - skipping validation", null);
            }
            HashMap<String, Object> inserts = new HashMap<String, Object>();
            inserts.put("XMSC_INSERT_KEY", name);
            inserts.put("XMSC_INSERT_VALUE", value);
            Log.log(this, "validate(Object name, Object value)", "JMSCMQ0007", inserts);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "validate(Object,Object)", true, 2);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "validate(Object,Object)", true, 3);
        }
        return true;
    }

    public String crossPropertyValidate() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "crossPropertyValidate()");
        }
        boolean overallValidation = true;
        String validationFailures = "";
        if (propertyValidators.size() > 0) {
            Iterator en = propertyValidators.keySet().iterator();
            while (en.hasNext()) {
                boolean validated;
                Object key;
                block9: {
                    key = en.next();
                    Object mqValidator = propertyValidators.get(key);
                    if (mqValidator == null) continue;
                    validated = true;
                    try {
                        validated = ((WMQStandardValidators.WMQPropertyValidator)mqValidator).crossPropertyValidate(this.jmsPropertyContext);
                    }
                    catch (JMSException j) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "crossPropertyValidate()", j);
                        }
                        if (!Trace.isOn) break block9;
                        Trace.traceWarning(this, "c.i.m.c.w.common.internal.WMQDestination", "crossPropertyValidate()", (Object)j);
                    }
                }
                if (validated) continue;
                overallValidation = false;
                validationFailures = validationFailures + key.toString() + ", ";
            }
        }
        if (overallValidation) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "crossPropertyValidate()", null, 1);
            }
            return null;
        }
        String traceRet1 = validationFailures.substring(0, validationFailures.length() - 2);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "crossPropertyValidate()", traceRet1, 2);
        }
        return traceRet1;
    }

    public boolean isDeleted() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "isDeleted()");
        }
        if (this.isTemporary) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "isDeleted()", this.hasBeenDeleted, 1);
            }
            return this.hasBeenDeleted;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "isDeleted()", false, 2);
        }
        return false;
    }

    public boolean isScopedBy(WMQCommonConnection conn) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "isScopedBy(WMQCommonConnection)", new Object[]{conn});
        }
        boolean traceRet1 = conn.equals(this.connection);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.common.internal.WMQDestination", "isScopedBy(WMQCommonConnection)", traceRet1);
        }
        return traceRet1;
    }

    public boolean equals(Object o) {
        boolean traceRet1 = this == o ? true : (null == o || !(o instanceof WMQDestination) ? false : super.equals(o));
        return traceRet1;
    }

    public void checkAccess(WMQCommonConnection connection) throws JMSException {
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.WMQDestination", "static", "SCCS id", (Object)sccsid);
        }
        validNamePattern = Pattern.compile("[A-Za-z0-9/._%*]*");
        propertyValidators = new HashMap();
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.WMQDestination", "static()");
        }
        propertyValidators.put("encoding", new WMQEncodingPropertyValidator(4));
        propertyValidators.put("ENCODING", new WMQEncodingPropertyValidator(1));
        propertyValidators.put("ENC", new WMQEncodingPropertyValidator(2));
        propertyValidators.put("CCSID", new WMQCCSIDPropertyValidator(4));
        propertyValidators.put("CCSID", new WMQCCSIDPropertyValidator(1));
        propertyValidators.put("CCS", new WMQCCSIDPropertyValidator(2));
        propertyValidators.put("targetClient", new WMQTargetClientPropertyValidator(4));
        propertyValidators.put("TARGCLIENT", new WMQTargetClientPropertyValidator(1));
        propertyValidators.put("TC", new WMQTargetClientPropertyValidator(2));
        propertyValidators.put("deliveryMode", new WMQDeliveryModePropertyValidator(4));
        propertyValidators.put("PERSISTENCE", new WMQDeliveryModePropertyValidator(1));
        propertyValidators.put("PER", new WMQDeliveryModePropertyValidator(2));
        propertyValidators.put("persistence", new WMQDeliveryModePropertyValidator(3));
        propertyValidators.put("priority", new WMQPriorityPropertyValidator(4));
        propertyValidators.put("PRIORITY", new WMQPriorityPropertyValidator(1));
        propertyValidators.put("PRI", new WMQPriorityPropertyValidator(2));
        propertyValidators.put("destDescription", new WMQDestDescriptionPropertyValidator(4));
        propertyValidators.put("DESCRIPTION", new WMQDestDescriptionPropertyValidator(1));
        propertyValidators.put("DESC", new WMQDestDescriptionPropertyValidator(2));
        propertyValidators.put("failIfQuiesce", new WMQFailIfQuiescePropertyValidator(4));
        propertyValidators.put("FAILIFQUIESCE", new WMQFailIfQuiescePropertyValidator(1));
        propertyValidators.put("FIQ", new WMQFailIfQuiescePropertyValidator(2));
        propertyValidators.put("mdMessageContext", new WMQMessageContextPropertyValidator(4));
        propertyValidators.put("MDMSGCTX", new WMQMessageContextPropertyValidator(1));
        propertyValidators.put("MDCTX", new WMQMessageContextPropertyValidator(2));
        propertyValidators.put("mdWriteEnabled", new WMQmdWriteEnabledPropertyValidator(4));
        propertyValidators.put("MDWRITE", new WMQmdWriteEnabledPropertyValidator(1));
        propertyValidators.put("MDW", new WMQmdWriteEnabledPropertyValidator(2));
        propertyValidators.put("mdReadEnabled", new WMQmdReadEnabledPropertyValidator(4));
        propertyValidators.put("MDREAD", new WMQmdReadEnabledPropertyValidator(1));
        propertyValidators.put("MDR", new WMQmdReadEnabledPropertyValidator(2));
        propertyValidators.put("messageBody", new WMQMessageBodyStylePropertyValidator(4));
        propertyValidators.put("MSGBODY", new WMQMessageBodyStylePropertyValidator(1));
        propertyValidators.put("MBODY", new WMQMessageBodyStylePropertyValidator(2));
        propertyValidators.put("putAsyncAllowed", new WMQPutAsyncAllowedPropertyValidator(4));
        propertyValidators.put("PUTASYNCALLOWED", new WMQPutAsyncAllowedPropertyValidator(1));
        propertyValidators.put("PAALD", new WMQPutAsyncAllowedPropertyValidator(2));
        propertyValidators.put("readAheadAllowed", new WMQReadAheadAllowedPropertyValidator(4));
        propertyValidators.put("READAHEADALLOWED", new WMQReadAheadAllowedPropertyValidator(1));
        propertyValidators.put("RAALD", new WMQReadAheadAllowedPropertyValidator(2));
        propertyValidators.put("readAheadClosePolicy", new WMQReadAheadClosePolicyPropertyValidator(4));
        propertyValidators.put("READAHEADCLOSEPOLICY", new WMQReadAheadClosePolicyPropertyValidator(1));
        propertyValidators.put("RACP", new WMQReadAheadClosePolicyPropertyValidator(2));
        propertyValidators.put("wildcardFormat", new WMQWildcardFormatPropertyValidator(4));
        propertyValidators.put("WILDCARDFORMAT", new WMQWildcardFormatPropertyValidator(1));
        propertyValidators.put("WCFMT", new WMQWildcardFormatPropertyValidator(2));
        propertyValidators.put("timeToLive", new WMQTimeToLivePropertyValidator(4));
        propertyValidators.put("EXPIRY", new WMQTimeToLivePropertyValidator(1));
        propertyValidators.put("EXP", new WMQTimeToLivePropertyValidator(2));
        propertyValidators.put("expiry", new WMQTimeToLivePropertyValidator(3));
        propertyValidators.put("XMSC_WMQ_BROKER_PUBQ_QMGR", new WMQBrokerPubQQMgrPropertyValidator(4));
        propertyValidators.put("BROKERPUBQMGR", new WMQBrokerPubQQMgrPropertyValidator(1));
        propertyValidators.put("BPQM", new WMQBrokerPubQQMgrPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_BROKER_PUBQ", new WMQBrokerPubQPropertyValidator(4));
        propertyValidators.put("BROKERPUBQ", new WMQBrokerPubQPropertyValidator(1));
        propertyValidators.put("BPUB", new WMQBrokerPubQPropertyValidator(2));
        propertyValidators.put("brokerDurSubQueue", new WMQBrokerDurSubQPropertyValidator(4));
        propertyValidators.put("BROKERDURSUBQ", new WMQBrokerDurSubQPropertyValidator(1));
        propertyValidators.put("BDSUB", new WMQBrokerDurSubQPropertyValidator(2));
        propertyValidators.put("brokerCCDurSubQueue", new WMQBrokerCCDurSubQPropertyValidator(4));
        propertyValidators.put("BROKERCCDURSUBQ", new WMQBrokerCCDurSubQPropertyValidator(1));
        propertyValidators.put("CCDSUB", new WMQBrokerCCDurSubQPropertyValidator(2));
        propertyValidators.put("brokerVersion", new WMQBrokerVersionPropertyValidator(4));
        propertyValidators.put("BROKERVER", new WMQBrokerVersionPropertyValidator(1));
        propertyValidators.put("BVER", new WMQBrokerVersionPropertyValidator(2));
        propertyValidators.put("multicast", new WMQMulticastPropertyValidator(4));
        propertyValidators.put("MULTICAST", new WMQMulticastPropertyValidator(1));
        propertyValidators.put("MCAST", new WMQMulticastPropertyValidator(2));
        propertyValidators.put("XMSC_DESTINATION_NAME", new WMQDestinationNamePropertyValidator(4));
        propertyValidators.put("DESTNAME", new WMQDestinationNamePropertyValidator(1));
        propertyValidators.put("NAME", new WMQDestinationNamePropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_QUEUE_MANAGER", new WMQQueueManagerNamePropertyValidator(4));
        propertyValidators.put("QMANAGER", new WMQQueueManagerNamePropertyValidator(1));
        propertyValidators.put("QMGR", new WMQQueueManagerNamePropertyValidator(2));
        propertyValidators.put("version", new WMQVersionPropertyValidator(4));
        propertyValidators.put("VERSION", new WMQVersionPropertyValidator(1));
        propertyValidators.put("VER", new WMQVersionPropertyValidator(2));
        propertyValidators.put("XMSC_WMQ_REPLYTO_STYLE", new WMQReplyToStylePropertyValidator(4));
        propertyValidators.put("REPLYTOSTYLE", new WMQReplyToStylePropertyValidator(1));
        propertyValidators.put("RTOST", new WMQReplyToStylePropertyValidator(2));
        propertyValidators.put("replyToStyle", new WMQReplyToStylePropertyValidator(3));
        propertyValidators.put("receiveCCSID", new WMQReceiveCCSIDPropertyValidator(4));
        propertyValidators.put("RECEIVECCSID", new WMQReceiveCCSIDPropertyValidator(1));
        propertyValidators.put("RCCS", new WMQReceiveCCSIDPropertyValidator(2));
        propertyValidators.put("receiveCCSID", new WMQReceiveCCSIDPropertyValidator(3));
        propertyValidators.put("receiveConversion", new WMQReceiveConversionPropertyValidator(4));
        propertyValidators.put("RECEIVECONVERSION", new WMQReceiveConversionPropertyValidator(1));
        propertyValidators.put("RCNV", new WMQReceiveConversionPropertyValidator(2));
        propertyValidators.put("receiveConversion", new WMQReceiveConversionPropertyValidator(3));
        propertyValidators.put("XMSC_CONNECTION_TYPE_NAME", new WMQConnectionTypeNamePropertyValidator(4));
        propertyValidators.put("XMSC_CONNECTION_TYPE", new WMQConnectionTypePropertyValidator(4));
        propertyValidators.put("XMSC_ADMIN_OBJECT_TYPE", new WMQAdminObjectPropertyValidator(4));
        propertyValidators.put("XMSC_OBJECT_IDENTITY", new WMQObjectIdentityPropertyValidator(4));
        propertyValidators.put("OBJECT_IDENTITY", new WMQObjectIdentityPropertyValidator(5));
        propertyValidators.put("userProperties", new WMQUserPropsPropertyValidator(4));
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.WMQDestination", "static()");
        }
    }

    static class WMQReceiveConversionPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -84234231548414268L;

        public WMQReceiveConversionPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "RECEIVECONVERSION");
            this.domainNames.put(new Integer(2), "RCNV");
            this.domainNames.put(new Integer(4), "receiveConversion");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("QMGR", new Integer(2));
            ((HashMap)adminNames).put("CLIENT_MSG", new Integer(1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block20: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveConversionPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Long || value instanceof Integer)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = adminNames.get(value);
                            break block20;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQFailIfQuiescePropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = Integer.valueOf((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveConversionPropertyValidator", "validate(Object,Object)", e, 1);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveConversionPropertyValidator", "validate(Object,Object)", false, 1);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int rcnv = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                try {
                    if (rcnv != 1 && rcnv != 2) {
                        HashMap<String, String> inserts = new HashMap<String, String>();
                        inserts.put("XMSC_INSERT_PROPERTY", "RECEIVECONVERSION");
                        inserts.put("XMSC_INSERT_VALUE", String.valueOf(rcnv));
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveConversionPropertyValidator", "validate(Object,Object)", je, 1);
                        }
                        throw je;
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveConversionPropertyValidator", "validate(Object,Object)", true, 2);
                    }
                    return true;
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveConversionPropertyValidator", "validate(Object,Object)", je, 2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveConversionPropertyValidator", "validate(Object,Object)", je, 2);
                    }
                    throw je;
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveConversionPropertyValidator", "validate(Object,Object)", false, 3);
            }
            return false;
        }
    }

    static class WMQReceiveCCSIDPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -889913888348414268L;

        public WMQReceiveCCSIDPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "RECEIVECCSID");
            this.domainNames.put(new Integer(2), "RCCS");
            this.domainNames.put(new Integer(4), "receiveCCSID");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveCCSIDPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (!(value instanceof Long || value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = Integer.valueOf((String)value);
                }
                catch (NumberFormatException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveCCSIDPropertyValidator", "validate(Object,Object)", e, 1);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveCCSIDPropertyValidator", "validate(Object,Object)", false, 1);
                    }
                    return false;
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int ccsid = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                try {
                    if (ccsid < 0) {
                        HashMap<String, String> inserts = new HashMap<String, String>();
                        inserts.put("XMSC_INSERT_PROPERTY", "RECEIVECCSID");
                        inserts.put("XMSC_INSERT_VALUE", String.valueOf(ccsid));
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveCCSIDPropertyValidator", "validate(Object,Object)", je, 1);
                        }
                        throw je;
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveCCSIDPropertyValidator", "validate(Object,Object)", true, 2);
                    }
                    return true;
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveCCSIDPropertyValidator", "validate(Object,Object)", je, 2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveCCSIDPropertyValidator", "validate(Object,Object)", je, 2);
                    }
                    throw je;
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReceiveCCSIDPropertyValidator", "validate(Object,Object)", false, 3);
            }
            return false;
        }
    }

    static class WMQReplyToStylePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -6200145672501515211L;

        public WMQReplyToStylePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "REPLYTOSTYLE");
            this.domainNames.put(new Integer(2), "RTOST");
            this.domainNames.put(new Integer(3), "replyToStyle");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_REPLYTO_STYLE");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("DEFAULT", new Integer(0));
            ((HashMap)adminNames).put("MQMD", new Integer(1));
            ((HashMap)adminNames).put("RFH2", new Integer(2));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block18: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQReplyToStylePropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = (Integer)adminNames.get(value);
                            break block18;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReplyToStylePropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQReplyToStylePropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReplyToStylePropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int replyToStyle = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                switch (replyToStyle) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReplyToStylePropertyValidator", "validate(Object,Object)", true, 3);
                        }
                        return true;
                    }
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "replyToStyle");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(replyToStyle));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQReplyToStylePropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReplyToStylePropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQVersionPropertyValidator
    extends WMQStandardValidators.WMQTrivialPropertyValidator {
        private static final long serialVersionUID = -6200113082501515212L;

        public WMQVersionPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "VERSION");
            this.domainNames.put(new Integer(2), "VER");
            this.domainNames.put(new Integer(4), "version");
        }
    }

    static class WMQMulticastPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 5675026711601977145L;

        public WMQMulticastPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "MULTICAST");
            this.domainNames.put(new Integer(2), "MCAST");
            this.domainNames.put(new Integer(4), "multicast");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQMulticastPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                value = new Integer((String)value);
            }
            if (value instanceof Integer) {
                int multicast = (Integer)value;
                if (multicast != 0 && multicast != -1 && multicast != 3 && multicast != 5 && multicast != 7) {
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_INSERT_PROPERTY", "multicast");
                    inserts.put("XMSC_INSERT_VALUE", String.valueOf(multicast));
                    JMSException traceRet1 = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQMulticastPropertyValidator", "validate(Object,Object)", traceRet1);
                    }
                    throw traceRet1;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMulticastPropertyValidator", "validate(Object,Object)", true, 1);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMulticastPropertyValidator", "validate(Object,Object)", false, 2);
            }
            return false;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQMulticastPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("multicast") != 0 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") != 2) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMulticastPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMulticastPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQBrokerVersionPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 7965859765992626834L;

        public WMQBrokerVersionPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERVER");
            this.domainNames.put(new Integer(2), "BVER");
            this.domainNames.put(new Integer(4), "brokerVersion");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerVersionPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (!(value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                value = new Integer((String)value);
            }
            if (value instanceof Integer) {
                int version = (Integer)value;
                switch (version) {
                    case 0: 
                    case 1: {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerVersionPropertyValidator", "validate(Object,Object)", true, 1);
                        }
                        return true;
                    }
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "brokerVersion");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(version));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerVersionPropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerVersionPropertyValidator", "validate(Object,Object)", false, 2);
            }
            return false;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            JmsPropertyContext parentPC;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerVersionPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if ((parentPC = (JmsPropertyContext)parent).getIntProperty("brokerVersion") == 0) {
                if (parentPC.getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 1 || parentPC.getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerVersionPropertyValidator", "crossPropertyValidate(Object)", true, 1);
                    }
                    return true;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerVersionPropertyValidator", "crossPropertyValidate(Object)", false, 2);
                }
                return false;
            }
            if (parentPC.getIntProperty("brokerVersion") == 1) {
                if (parentPC.getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 4 || parentPC.getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 2) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerVersionPropertyValidator", "crossPropertyValidate(Object)", true, 3);
                    }
                    return true;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerVersionPropertyValidator", "crossPropertyValidate(Object)", false, 4);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerVersionPropertyValidator", "crossPropertyValidate(Object)", true, 5);
            }
            return true;
        }
    }

    static class WMQBrokerPubQQMgrPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = -6450884337394891771L;

        public WMQBrokerPubQQMgrPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERPUBQMGR");
            this.domainNames.put(new Integer(2), "BPQM");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_BROKER_PUBQ_QMGR");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerPubQQMgrPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (value == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerPubQQMgrPropertyValidator", "validate(Object,Object)", false, 1);
                }
                return false;
            }
            value = this.convertToString(value);
            if (!validNamePattern.matcher((String)value).matches()) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerPubQQMgrPropertyValidator", "validate(Object,Object)", false, 2);
                }
                return false;
            }
            String queueName = (String)value;
            if (queueName == null || queueName.length() > 48) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerPubQQMgrPropertyValidator", "validate(Object,Object)", false, 3);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerPubQQMgrPropertyValidator", "validate(Object,Object)", true, 4);
            }
            return true;
        }
    }

    static class WMQBrokerPubQPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = 4467837469835453836L;

        public WMQBrokerPubQPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERPUBQ");
            this.domainNames.put(new Integer(2), "BPUB");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_BROKER_PUBQ");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerPubQPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (value == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerPubQPropertyValidator", "validate(Object,Object)", false, 1);
                }
                return false;
            }
            value = this.convertToString(value);
            if (!validNamePattern.matcher((String)value).matches()) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerPubQPropertyValidator", "validate(Object,Object)", false, 2);
                }
                return false;
            }
            String queueName = (String)value;
            if (queueName == null || queueName.length() > 48) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerPubQPropertyValidator", "validate(Object,Object)", false, 3);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerPubQPropertyValidator", "validate(Object,Object)", true, 4);
            }
            return true;
        }
    }

    static class WMQBrokerDurSubQPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = 4010546703751946760L;

        public WMQBrokerDurSubQPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERDURSUBQ");
            this.domainNames.put(new Integer(2), "BDSUB");
            this.domainNames.put(new Integer(4), "brokerDurSubQueue");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerDurSubQPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (value == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerDurSubQPropertyValidator", "validate(Object,Object)", false, 1);
                }
                return false;
            }
            value = this.convertToString(value);
            if (!validNamePattern.matcher((String)value).matches()) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerDurSubQPropertyValidator", "validate(Object,Object)", false, 2);
                }
                return false;
            }
            String queueName = (String)value;
            if (queueName.length() <= 48 && (queueName.startsWith("SYSTEM.JMS.") || queueName.startsWith("SYSTEM.BROKER"))) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerDurSubQPropertyValidator", "validate(Object,Object)", true, 3);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerDurSubQPropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQBrokerCCDurSubQPropertyValidator
    extends WMQStandardValidators.WMQQueueNamePropertyValidator {
        private static final long serialVersionUID = -1968710937199422796L;

        public WMQBrokerCCDurSubQPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "BROKERCCDURSUBQ");
            this.domainNames.put(new Integer(2), "CCDSUB");
            this.domainNames.put(new Integer(4), "brokerCCDurSubQueue");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerCCDurSubQPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            value = this.convertToString(value);
            if (!validNamePattern.matcher((String)value).matches()) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerCCDurSubQPropertyValidator", "validate(Object,Object)", false, 1);
                }
                return false;
            }
            String queueName = (String)value;
            if (queueName.length() <= 48 && queueName.startsWith("SYSTEM.JMS.")) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerCCDurSubQPropertyValidator", "validate(Object,Object)", true, 2);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQBrokerCCDurSubQPropertyValidator", "validate(Object,Object)", false, 3);
            }
            return false;
        }
    }

    static class WMQWildcardFormatPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 3919470995696146576L;

        public WMQWildcardFormatPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "WILDCARDFORMAT");
            this.domainNames.put(new Integer(2), "WCFMT");
            this.domainNames.put(new Integer(4), "wildcardFormat");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("CHAR_ONLY", new Integer(1));
            ((HashMap)adminNames).put("TOPIC_ONLY", new Integer(0));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block16: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQWildcardFormatPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = (Integer)adminNames.get(value);
                            break block16;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQWildcardFormatPropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQWildcardFormatPropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQWildcardFormatPropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int intval = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                if (intval < 0 || intval > 1) {
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_INSERT_PROPERTY", "wildcardFormat");
                    inserts.put("XMSC_INSERT_VALUE", String.valueOf(intval));
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQWildcardFormatPropertyValidator", "validate(Object,Object)", je);
                    }
                    throw je;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQWildcardFormatPropertyValidator", "validate(Object,Object)", true, 3);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQWildcardFormatPropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQUserPropsPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -4548728485512352415L;

        public WMQUserPropsPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "userProperties");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQUserPropsPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (value instanceof Properties) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQUserPropsPropertyValidator", "validate(Object,Object)", true, 1);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQUserPropsPropertyValidator", "validate(Object,Object)", false, 2);
            }
            return false;
        }
    }

    static class WMQObjectIdentityPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        static final long serialVersionUID = -8471859292465301393L;

        public WMQObjectIdentityPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_OBJECT_IDENTITY");
            this.domainNames.put(new Integer(5), "OBJECT_IDENTITY");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQObjectIdentityPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (value instanceof Integer || value instanceof Long) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQObjectIdentityPropertyValidator", "validate(Object,Object)", true, 1);
                }
                return true;
            }
            if (value instanceof String) {
                try {
                    Long.parseLong((String)value);
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQObjectIdentityPropertyValidator", "validate(Object,Object)", true, 3);
                    }
                    return true;
                }
                catch (NumberFormatException nfe) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQObjectIdentityPropertyValidator", "validate(Object,Object)", false, 4);
                    }
                    return false;
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQObjectIdentityPropertyValidator", "validate(Object,Object)", false, 2);
            }
            return false;
        }
    }

    static class WMQTimeToLivePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -447532760337374562L;

        public WMQTimeToLivePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "EXPIRY");
            this.domainNames.put(new Integer(2), "EXP");
            this.domainNames.put(new Integer(3), "expiry");
            this.domainNames.put(new Integer(4), "timeToLive");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("APP", new Integer(-2));
            ((HashMap)adminNames).put("UNLIM", new Integer(0));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block16: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQTimeToLivePropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = (Integer)adminNames.get(value);
                            break block16;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQTimeToLivePropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Long((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQTimeToLivePropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQTimeToLivePropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                long intval = value instanceof Long ? (Long)value : (long)((Integer)value).intValue();
                if (intval < 0L && intval != -2L) {
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_INSERT_PROPERTY", "timeToLive");
                    inserts.put("XMSC_INSERT_VALUE", String.valueOf(intval));
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQTimeToLivePropertyValidator", "validate(Object,Object)", je);
                    }
                    throw je;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQTimeToLivePropertyValidator", "validate(Object,Object)", true, 3);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQTimeToLivePropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQTargetClientPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -8327884191290941918L;

        public WMQTargetClientPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "TARGCLIENT");
            this.domainNames.put(new Integer(2), "TC");
            this.domainNames.put(new Integer(4), "targetClient");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("JMS", new Integer(0));
            ((HashMap)adminNames).put("MQ", new Integer(1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block18: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQTargetClientPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = (Integer)adminNames.get(value);
                            break block18;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQTargetClientPropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQTargetClientPropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQTargetClientPropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int targetClient = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                switch (targetClient) {
                    case 0: 
                    case 1: {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQTargetClientPropertyValidator", "validate(Object,Object)", true, 3);
                        }
                        return true;
                    }
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "targetClient");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(targetClient));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQTargetClientPropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQTargetClientPropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQReadAheadClosePolicyPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 8703407824128956301L;

        public WMQReadAheadClosePolicyPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "READAHEADCLOSEPOLICY");
            this.domainNames.put(new Integer(2), "RACP");
            this.domainNames.put(new Integer(4), "readAheadClosePolicy");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("DELIVER_ALL", new Integer(2));
            ((HashMap)adminNames).put("DELIVER_CURRENT", new Integer(1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block18: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadClosePolicyPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = (Integer)adminNames.get(value);
                            break block18;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadClosePolicyPropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadClosePolicyPropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadClosePolicyPropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int closePolicyValue = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                switch (closePolicyValue) {
                    case 1: 
                    case 2: {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadClosePolicyPropertyValidator", "validate(Object,Object)", true, 3);
                        }
                        return true;
                    }
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "readAheadClosePolicy");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(closePolicyValue));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadClosePolicyPropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadClosePolicyPropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadClosePolicyPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("readAheadClosePolicy") != 2 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadClosePolicyPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadClosePolicyPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQReadAheadAllowedPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 2594030826556403515L;

        public WMQReadAheadAllowedPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "READAHEADALLOWED");
            this.domainNames.put(new Integer(2), "RAALD");
            this.domainNames.put(new Integer(4), "readAheadAllowed");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("YES", new Integer(1));
            ((HashMap)adminNames).put("NO", new Integer(0));
            ((HashMap)adminNames).put("AS_DEST", new Integer(-1));
            ((HashMap)adminNames).put("AS_Q_DEF", new Integer(-1));
            ((HashMap)adminNames).put("AS_TOPIC_DEF", new Integer(-1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block18: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadAllowedPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = (Integer)adminNames.get(value);
                            break block18;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadAllowedPropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadAllowedPropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadAllowedPropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int readAheadValue = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                switch (readAheadValue) {
                    case -1: 
                    case 0: 
                    case 1: {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadAllowedPropertyValidator", "validate(Object,Object)", true, 3);
                        }
                        return true;
                    }
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "readAheadAllowed");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(readAheadValue));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadAllowedPropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadAllowedPropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadAllowedPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("readAheadAllowed") != -1 && ((JmsPropertyContext)parent).getIntProperty("readAheadAllowed") != 0 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadAllowedPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQReadAheadAllowedPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQPutAsyncAllowedPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -4617294089836628163L;

        public WMQPutAsyncAllowedPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "PUTASYNCALLOWED");
            this.domainNames.put(new Integer(2), "PAALD");
            this.domainNames.put(new Integer(4), "putAsyncAllowed");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("YES", new Integer(1));
            ((HashMap)adminNames).put("NO", new Integer(0));
            ((HashMap)adminNames).put("AS_DEST", new Integer(-1));
            ((HashMap)adminNames).put("AS_Q_DEF", new Integer(-1));
            ((HashMap)adminNames).put("AS_TOPIC_DEF", new Integer(-1));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block18: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQPutAsyncAllowedPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = (Integer)adminNames.get(value);
                            break block18;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPutAsyncAllowedPropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQPutAsyncAllowedPropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPutAsyncAllowedPropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int putAsyncValue = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                switch (putAsyncValue) {
                    case -1: 
                    case 0: 
                    case 1: {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPutAsyncAllowedPropertyValidator", "validate(Object,Object)", true, 3);
                        }
                        return true;
                    }
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "putAsyncAllowed");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(putAsyncValue));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQPutAsyncAllowedPropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPutAsyncAllowedPropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQPriorityPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 3172310166239305786L;

        public WMQPriorityPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "PRIORITY");
            this.domainNames.put(new Integer(2), "PRI");
            this.domainNames.put(new Integer(4), "priority");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("APP", new Integer(-2));
            ((HashMap)adminNames).put("QDEF", new Integer(-1));
            ((HashMap)adminNames).put("0", new Integer(0));
            ((HashMap)adminNames).put("1", new Integer(1));
            ((HashMap)adminNames).put("2", new Integer(2));
            ((HashMap)adminNames).put("3", new Integer(3));
            ((HashMap)adminNames).put("4", new Integer(4));
            ((HashMap)adminNames).put("5", new Integer(5));
            ((HashMap)adminNames).put("6", new Integer(6));
            ((HashMap)adminNames).put("7", new Integer(7));
            ((HashMap)adminNames).put("8", new Integer(9));
            ((HashMap)adminNames).put("9", new Integer(9));
            ((HashMap)adminNames).put(new Integer(0), new Integer(0));
            ((HashMap)adminNames).put(new Integer(1), new Integer(1));
            ((HashMap)adminNames).put(new Integer(2), new Integer(2));
            ((HashMap)adminNames).put(new Integer(3), new Integer(3));
            ((HashMap)adminNames).put(new Integer(4), new Integer(4));
            ((HashMap)adminNames).put(new Integer(5), new Integer(5));
            ((HashMap)adminNames).put(new Integer(6), new Integer(6));
            ((HashMap)adminNames).put(new Integer(7), new Integer(7));
            ((HashMap)adminNames).put(new Integer(8), new Integer(9));
            ((HashMap)adminNames).put(new Integer(9), new Integer(9));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block16: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQPriorityPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = (Integer)adminNames.get(value);
                            break block16;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPriorityPropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQPriorityPropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPriorityPropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int priority = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                if (priority == -2 || priority == -1 || priority >= 0 && priority <= 9) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPriorityPropertyValidator", "validate(Object,Object)", true, 3);
                    }
                    return true;
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "priority");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(priority));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQPriorityPropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQPriorityPropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQDeliveryModePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 916546588885471908L;

        public WMQDeliveryModePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "PERSISTENCE");
            this.domainNames.put(new Integer(2), "PER");
            this.domainNames.put(new Integer(3), "persistence");
            this.domainNames.put(new Integer(4), "deliveryMode");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("APP", new Integer(-2));
            ((HashMap)adminNames).put("QDEF", new Integer(-1));
            ((HashMap)adminNames).put("PERS", new Integer(2));
            ((HashMap)adminNames).put("NON", new Integer(1));
            ((HashMap)adminNames).put("HIGH", new Integer(3));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block18: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDeliveryModePropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = (Integer)adminNames.get(value);
                            break block18;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDeliveryModePropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQDeliveryModePropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDeliveryModePropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int deliveryMode = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                switch (deliveryMode) {
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDeliveryModePropertyValidator", "validate(Object,Object)", true, 3);
                        }
                        return true;
                    }
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "persistence");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(deliveryMode));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQDeliveryModePropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDeliveryModePropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQMessageBodyStylePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 1053052193028384899L;

        public WMQMessageBodyStylePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "MSGBODY");
            this.domainNames.put(new Integer(2), "MBODY");
            this.domainNames.put(new Integer(4), "messageBody");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("JMS", new Integer(0));
            ((HashMap)adminNames).put("MQ", new Integer(1));
            ((HashMap)adminNames).put("UNSPECIFIED", new Integer(2));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block18: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageBodyStylePropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = (Integer)adminNames.get(value);
                            break block18;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageBodyStylePropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageBodyStylePropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageBodyStylePropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int messageBodyStyle = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                switch (messageBodyStyle) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageBodyStylePropertyValidator", "validate(Object,Object)", true, 3);
                        }
                        return true;
                    }
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "messageBody");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(messageBodyStyle));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageBodyStylePropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageBodyStylePropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQmdReadEnabledPropertyValidator
    extends WMQStandardValidators.WMQBooleanPropertyValidator {
        private static final long serialVersionUID = 858442200305589834L;

        public WMQmdReadEnabledPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "MDREAD");
            this.domainNames.put(new Integer(2), "MDR");
            this.domainNames.put(new Integer(4), "mdReadEnabled");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("YES", Boolean.TRUE);
            ((HashMap)adminNames).put("NO", Boolean.FALSE);
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }
    }

    static class WMQmdWriteEnabledPropertyValidator
    extends WMQStandardValidators.WMQBooleanPropertyValidator {
        private static final long serialVersionUID = 5423523221173433204L;

        public WMQmdWriteEnabledPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "MDWRITE");
            this.domainNames.put(new Integer(2), "MDW");
            this.domainNames.put(new Integer(4), "mdWriteEnabled");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("YES", Boolean.TRUE);
            ((HashMap)adminNames).put("NO", Boolean.FALSE);
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }
    }

    static class WMQMessageContextPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 8485830106901109460L;

        public WMQMessageContextPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "MDMSGCTX");
            this.domainNames.put(new Integer(2), "MDCTX");
            this.domainNames.put(new Integer(4), "mdMessageContext");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageContextPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (!(value instanceof Integer || value instanceof Long)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageContextPropertyValidator", "validate(Object,Object)", e);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageContextPropertyValidator", "validate(Object,Object)", false, 1);
                    }
                    return false;
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int messageContext = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                switch (messageContext) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageContextPropertyValidator", "validate(Object,Object)", true, 2);
                        }
                        return true;
                    }
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "mdMessageContext");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(messageContext));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageContextPropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQMessageContextPropertyValidator", "validate(Object,Object)", false, 3);
            }
            return false;
        }
    }

    static class WMQFailIfQuiescePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 671057721715729251L;

        public WMQFailIfQuiescePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "FAILIFQUIESCE");
            this.domainNames.put(new Integer(2), "FIQ");
            this.domainNames.put(new Integer(4), "failIfQuiesce");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("YES", new Integer(1));
            ((HashMap)adminNames).put("NO", new Integer(0));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block18: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQFailIfQuiescePropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = adminNames.get(value);
                            break block18;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQFailIfQuiescePropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQFailIfQuiescePropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQFailIfQuiescePropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int fiq = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                switch (fiq) {
                    case 0: 
                    case 1: {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQFailIfQuiescePropertyValidator", "validate(Object,Object)", true, 3);
                        }
                        return true;
                    }
                }
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", "failIfQuiesce");
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(fiq));
                JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQFailIfQuiescePropertyValidator", "validate(Object,Object)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQFailIfQuiescePropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQEncodingPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 2941571030984413932L;

        public WMQEncodingPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "ENCODING");
            this.domainNames.put(new Integer(2), "ENC");
            this.domainNames.put(new Integer(4), "encoding");
            WMQStandardValidators.CaseInsentiveHashmap adminNames = new WMQStandardValidators.CaseInsentiveHashmap();
            ((HashMap)adminNames).put("NATIVE", new Integer(273));
            ((HashMap)adminNames).put("N", new Integer(1));
            ((HashMap)adminNames).put("R", new Integer(2));
            ((HashMap)adminNames).put("3", new Integer(768));
            this.valueToCanMappings.put(new Integer(1), adminNames);
            this.valueToCanMappings.put(new Integer(2), adminNames);
            this.reverseValueMappings();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean validate(Object value, Object parent) throws JMSException {
            block16: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQEncodingPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
                }
                if (!(value instanceof Integer || value instanceof Long)) {
                    value = this.convertToString(value);
                }
                if (value instanceof String) {
                    if (this.mapperDomain == 1 || this.mapperDomain == 2) {
                        HashMap adminNames = (HashMap)this.valueToCanMappings.get(new Integer(1));
                        if (adminNames.containsKey(value)) {
                            value = adminNames.get(value);
                            break block16;
                        } else {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQEncodingPropertyValidator", "validate(Object,Object)", false, 1);
                            }
                            return false;
                        }
                    }
                    try {
                        value = new Integer((String)value);
                    }
                    catch (NumberFormatException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQEncodingPropertyValidator", "validate(Object,Object)", e);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQEncodingPropertyValidator", "validate(Object,Object)", false, 2);
                        }
                        return false;
                    }
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int mask;
                int encoding = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                if ((encoding & ~(mask = 819)) != 0) {
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_INSERT_PROPERTY", "encoding");
                    inserts.put("XMSC_INSERT_VALUE", Integer.toHexString(encoding));
                    JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQEncodingPropertyValidator", "validate(Object,Object)", je);
                    }
                    throw je;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQEncodingPropertyValidator", "validate(Object,Object)", true, 3);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQEncodingPropertyValidator", "validate(Object,Object)", false, 4);
            }
            return false;
        }
    }

    static class WMQDestinationNamePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = 6012851027361876199L;
        static final Pattern queueNamePattern = Pattern.compile("queue://.+|topic://.+", 2);

        public WMQDestinationNamePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "DESTNAME");
            this.domainNames.put(new Integer(2), "NAME");
            this.domainNames.put(new Integer(4), "XMSC_DESTINATION_NAME");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationNamePropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (value == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationNamePropertyValidator", "validate(Object,Object)", false, 1);
                }
                return false;
            }
            value = this.convertToString(value);
            if (parent instanceof JmsTopic) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationNamePropertyValidator", "validate(Object,Object)", true, 2);
                }
                return true;
            }
            String queueName = (String)value;
            if (queueNamePattern.matcher((String)value).matches()) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationNamePropertyValidator", "validate(Object,Object)", true, 3);
                }
                return true;
            }
            if (!validNamePattern.matcher((String)value).matches()) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationNamePropertyValidator", "validate(Object,Object)", false, 4);
                }
                return false;
            }
            if (queueName == null || queueName.length() > 48) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationNamePropertyValidator", "validate(Object,Object)", false, 5);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQDestinationNamePropertyValidator", "validate(Object,Object)", true, 6);
            }
            return true;
        }
    }

    static class WMQQueueManagerNamePropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -6200113082501515211L;

        public WMQQueueManagerNamePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "QMANAGER");
            this.domainNames.put(new Integer(2), "QMGR");
            this.domainNames.put(new Integer(4), "XMSC_WMQ_QUEUE_MANAGER");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            String qmName;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQQueueManagerNamePropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if ((qmName = this.convertToString(value)) == null || qmName.length() > 48) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQQueueManagerNamePropertyValidator", "validate(Object,Object)", false, 1);
                }
                return false;
            }
            if (!validNamePattern.matcher((String)value).matches()) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQQueueManagerNamePropertyValidator", "validate(Object,Object)", false, 2);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQQueueManagerNamePropertyValidator", "validate(Object,Object)", true, 3);
            }
            return true;
        }
    }

    static class WMQDestDescriptionPropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = -9060363910500947331L;

        public WMQDestDescriptionPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "DESCRIPTION");
            this.domainNames.put(new Integer(2), "DESC");
            this.domainNames.put(new Integer(4), "destDescription");
        }
    }

    static class WMQConnectionTypePropertyValidator
    extends WMQStandardValidators.WMQIntPropertyValidator {
        private static final long serialVersionUID = -4767085469361870248L;

        public WMQConnectionTypePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_CONNECTION_TYPE");
        }
    }

    static class WMQConnectionTypeNamePropertyValidator
    extends WMQStandardValidators.WMQStringPropertyValidator {
        private static final long serialVersionUID = 4057776201748947687L;

        public WMQConnectionTypeNamePropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_CONNECTION_TYPE_NAME");
        }
    }

    static class WMQCCSIDPropertyValidator
    extends WMQStandardValidators.WMQPropertyValidator {
        private static final long serialVersionUID = -8899138887128414268L;

        public WMQCCSIDPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(1), "CCSID");
            this.domainNames.put(new Integer(2), "CCS");
            this.domainNames.put(new Integer(4), "CCSID");
        }

        public boolean validate(Object value, Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "validate(Object,Object)", new Object[]{value, parent});
            }
            if (!(value instanceof Long || value instanceof Integer)) {
                value = this.convertToString(value);
            }
            if (value instanceof String) {
                try {
                    value = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "validate(Object,Object)", e, 1);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "validate(Object,Object)", false, 1);
                    }
                    return false;
                }
            }
            if (value instanceof Integer || value instanceof Long) {
                int ccsid = value instanceof Long ? ((Long)value).intValue() : ((Integer)value).intValue();
                try {
                    if (ccsid < 0) {
                        HashMap<String, String> inserts = new HashMap<String, String>();
                        inserts.put("XMSC_INSERT_PROPERTY", "CCSID");
                        inserts.put("XMSC_INSERT_VALUE", String.valueOf(ccsid));
                        JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ0004", inserts));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "validate(Object,Object)", je, 1);
                        }
                        throw je;
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "validate(Object,Object)", true, 2);
                    }
                    return true;
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "validate(Object,Object)", je, 2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "validate(Object,Object)", je, 2);
                    }
                    throw je;
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "validate(Object,Object)", false, 3);
            }
            return false;
        }

        public boolean crossPropertyValidate(Object parent) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "crossPropertyValidate(Object)", new Object[]{parent});
            }
            if (((JmsPropertyContext)parent).getIntProperty("CCSID") != 1208 && ((JmsPropertyContext)parent).getIntProperty("XMSC_WMQ_CONNECTION_MODE") == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "crossPropertyValidate(Object)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.WMQCCSIDPropertyValidator", "crossPropertyValidate(Object)", true, 2);
            }
            return true;
        }
    }

    static class WMQAdminObjectPropertyValidator
    extends WMQStandardValidators.WMQTrivialPropertyValidator {
        private static final long serialVersionUID = 64038312559603860L;

        public WMQAdminObjectPropertyValidator(int domain) {
            super(domain);
            this.domainNames.put(new Integer(4), "XMSC_ADMIN_OBJECT_TYPE");
        }
    }

    static final class CacheProperty {
        String name;
        String uriName;
        Object value;
        Object defaultValue;
        boolean baseProperty;
        boolean exists;

        CacheProperty(String name, Object defaultValue, boolean baseProperty) {
            this(name, name, defaultValue, baseProperty);
        }

        CacheProperty(String name, String uriName, Object defaultValue, boolean baseProperty) {
            this.name = name;
            this.uriName = uriName == null ? name : uriName;
            this.value = defaultValue;
            this.defaultValue = defaultValue;
            this.baseProperty = baseProperty;
            this.exists = true;
        }

        void clear() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.CacheProperty", "clear()");
            }
            this.value = null;
            this.exists = false;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.CacheProperty", "clear()");
            }
        }

        void setValue(Object value) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.common.internal.CacheProperty", "setValue(Object)", "setter", value);
            }
            this.value = value;
            this.exists = true;
        }
    }
}

