/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.common.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.constants.CMQC;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.DetailedIllegalStateException;
import com.ibm.msg.client.jms.DetailedInvalidDestinationException;
import com.ibm.msg.client.jms.DetailedInvalidSelectorException;
import com.ibm.msg.client.jms.DetailedJMSException;
import com.ibm.msg.client.jms.DetailedJMSSecurityException;
import com.ibm.msg.client.jms.DetailedMessageEOFException;
import com.ibm.msg.client.jms.DetailedMessageFormatException;
import com.ibm.msg.client.jms.DetailedResourceAllocationException;
import com.ibm.msg.client.jms.DetailedTransactionInProgressException;
import com.ibm.msg.client.jms.DetailedTransactionRolledBackException;
import com.ibm.msg.client.jms.JmsExceptionDetail;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.jms.JMSException;

public class Reason {
    private static HashMap compcodeMap;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int[] impossibleReasons;
    private static int[] connectionBrokenReasons;
    private static HashMap reasonMap;
    static final String sccsid = "@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/Reason.java, jmscc.wmq, k701, k701-112-140304 1.45.1.1 09/08/17 08:01:15";

    public static JMSException createException(String messageid, HashMap inserts, int reason, int compcode, JmqiEnvironment environment) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.Reason", "createException(String,HashMap,int,int,JmqiEnvironment)", new Object[]{messageid, inserts, new Integer(reason), new Integer(compcode), environment});
        }
        if (0 == reason) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "createException(String,HashMap,int,int,JmqiEnvironment)", (Object)null, 1);
            }
            return null;
        }
        JmqiException jmqiException = null;
        if (null != environment) {
            jmqiException = environment.getLastException();
        }
        StringBuffer wmqMsgbuff = new StringBuffer("JMSCMQ0001");
        wmqMsgbuff.append(": ");
        wmqMsgbuff.append(NLSServices.getMessage("JMSCMQ0001", Integer.toString(compcode), Reason.getCompCodeSymbol(compcode), Integer.toString(reason), Reason.getReasonSymbol(reason)));
        String wmqMsg = wmqMsgbuff.toString();
        MQException wmqex = new MQException(wmqMsg, "JMSCMQ0001", reason, compcode);
        if (null != jmqiException) {
            wmqex.initCause((Throwable)jmqiException);
        }
        StringBuffer msgbuff = new StringBuffer(messageid);
        msgbuff.append(": ");
        msgbuff.append(NLSServices.getMessage(messageid, inserts));
        String message = msgbuff.toString();
        String explanation = NLSServices.getExplanation(messageid, inserts);
        String useraction = NLSServices.getUserAction(messageid, inserts);
        JMSException je = Reason.reasonToException(reason, message, messageid, explanation, useraction, inserts);
        je.setLinkedException((Exception)wmqex);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "createException(String,HashMap,int,int,JmqiEnvironment)", (Object)je, 2);
        }
        return je;
    }

    public static JMSException createException(String method, int reason, int compcode, JmqiEnvironment environment) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.Reason", "createException(String,int,int,JmqiEnvironment)", new Object[]{method, new Integer(reason), new Integer(compcode), environment});
        }
        if (0 == reason) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "createException(String,int,int,JmqiEnvironment)", (Object)null, 1);
            }
            return null;
        }
        HashMap<String, String> inserts = new HashMap<String, String>();
        inserts.put("XMSC_INSERT_METHOD", method);
        JMSException traceRet1 = Reason.createException("JMSCMQ0002", inserts, reason, compcode, environment);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "createException(String,int,int,JmqiEnvironment)", (Object)traceRet1, 2);
        }
        return traceRet1;
    }

    private static String getCompCodeSymbol(int compcode) {
        String symbol;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.Reason", "getCompCodeSymbol(int)", new Object[]{new Integer(compcode)});
        }
        if (null == (symbol = (String)compcodeMap.get(new Integer(compcode)))) {
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("compcode", new Integer(compcode));
            Trace.ffst("Reason", "getCompCodeSymbol(int)", "XM001003", info, null);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "getCompCodeSymbol(int)", (Object)symbol);
        }
        return symbol;
    }

    private static String getReasonSymbol(int reason) {
        String symbol;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.Reason", "getReasonSymbol(int)", new Object[]{new Integer(reason)});
        }
        if (null == (symbol = (String)reasonMap.get(new Integer(reason)))) {
            symbol = new String();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "getReasonSymbol(int)", (Object)symbol);
        }
        return symbol;
    }

    public static boolean isConnectionBroken(int reason) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.Reason", "isConnectionBroken(int)", new Object[]{new Integer(reason)});
        }
        for (int i = 0; i < connectionBrokenReasons.length; ++i) {
            if (connectionBrokenReasons[i] != reason) continue;
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "isConnectionBroken(int)", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "isConnectionBroken(int)", false, 2);
        }
        return false;
    }

    public static boolean isImpossibleReason(int reason, int compcode) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.Reason", "isImpossibleReason(int,int)", new Object[]{new Integer(reason), new Integer(compcode)});
        }
        for (int i = 0; i < impossibleReasons.length; ++i) {
            if (impossibleReasons[i] != reason) continue;
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "isImpossibleReason(int,int)", true, 1);
            }
            return true;
        }
        if (0 != compcode && 1 != compcode && 2 != compcode) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "isImpossibleReason(int,int)", true, 2);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "isImpossibleReason(int,int)", false, 3);
        }
        return false;
    }

    private static JMSException reasonToException(int reason, String message, String messageid, String explanation, String useraction, HashMap inserts) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.Reason", "reasonToException(int,String,String,String,String,HashMap)", new Object[]{new Integer(reason), message, messageid, explanation, useraction, inserts});
        }
        JmsExceptionDetail je = null;
        switch (reason) {
            case 2013: 
            case 2014: 
            case 2016: 
            case 2027: 
            case 2029: 
            case 2033: 
            case 2034: 
            case 2040: 
            case 2041: 
            case 2042: 
            case 2047: 
            case 2048: 
            case 2049: 
            case 2050: 
            case 2051: 
            case 2055: 
            case 2059: 
            case 2061: 
            case 2062: 
            case 2069: 
            case 2095: 
            case 2096: 
            case 2097: 
            case 2098: 
            case 2104: 
            case 2106: 
            case 2142: 
            case 2157: 
            case 2160: 
            case 2161: 
            case 2162: 
            case 2185: 
            case 2187: 
            case 2202: 
            case 2203: 
            case 2209: 
            case 2232: 
            case 2249: 
            case 2250: 
            case 2251: 
            case 2252: 
            case 2255: 
            case 2258: 
            case 2259: 
            case 2271: 
            case 2285: 
            case 2298: 
            case 2306: 
            case 2308: 
            case 2317: 
            case 2322: 
            case 2330: 
            case 2344: 
            case 2354: 
            case 2391: 
            case 2429: 
            case 6104: 
            case 6105: 
            case 6124: {
                je = new DetailedIllegalStateException(message, messageid, explanation, useraction, inserts);
                break;
            }
            case 2011: 
            case 2052: 
            case 2053: 
            case 2082: 
            case 2085: 
            case 2100: 
            case 2137: 
            case 2152: 
            case 2153: 
            case 2184: 
            case 2189: 
            case 2196: 
            case 2197: 
            case 2198: 
            case 2201: 
            case 2270: 
            case 2288: 
            case 2290: 
            case 2343: 
            case 2425: 
            case 2428: {
                je = new DetailedInvalidDestinationException(message, messageid, explanation, useraction, inserts);
                break;
            }
            case 2459: 
            case 2504: 
            case 2519: 
            case 2551: {
                je = new DetailedInvalidSelectorException(message, messageid, explanation, useraction, inserts);
                break;
            }
            case 2035: 
            case 2063: 
            case 2217: 
            case 2348: 
            case 2381: 
            case 2382: 
            case 2388: 
            case 2401: {
                je = new DetailedJMSSecurityException(message, messageid, explanation, useraction, inserts);
                break;
            }
            case 2079: 
            case 2080: 
            case 2143: 
            case 2144: 
            case 2190: {
                je = new DetailedMessageEOFException(message, messageid, explanation, useraction, inserts);
                break;
            }
            case 2110: 
            case 2111: 
            case 2112: 
            case 2113: 
            case 2114: 
            case 2115: 
            case 2116: 
            case 2117: 
            case 2118: 
            case 2119: 
            case 2145: 
            case 2146: 
            case 2150: 
            case 2228: 
            case 2243: 
            case 2244: 
            case 2272: 
            case 2364: 
            case 2421: {
                je = new DetailedMessageFormatException(message, messageid, explanation, useraction, inserts);
                break;
            }
            case 2017: 
            case 2024: 
            case 2025: 
            case 2056: 
            case 2071: 
            case 2102: 
            case 2127: 
            case 2183: 
            case 2192: 
            case 2204: 
            case 2208: 
            case 2267: 
            case 2269: {
                je = new DetailedResourceAllocationException(message, messageid, explanation, useraction, inserts);
                break;
            }
            case 2128: 
            case 2351: 
            case 2352: 
            case 2353: 
            case 2355: {
                je = new DetailedTransactionInProgressException(message, messageid, explanation, useraction, inserts);
                break;
            }
            case 2003: 
            case 2297: {
                je = new DetailedTransactionRolledBackException(message, messageid, explanation, useraction, inserts);
                break;
            }
            default: {
                je = new DetailedJMSException(message, messageid, explanation, useraction, inserts);
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "reasonToException(int,String,String,String,String,HashMap)", je);
        }
        return je;
    }

    private Reason() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.common.internal.Reason", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.common.internal.Reason", "<init>()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.common.internal.Reason", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.common/src/com/ibm/msg/client/wmq/common/internal/Reason.java, jmscc.wmq, k701, k701-112-140304  1.45.1.1 09/08/17 08:01:15");
        }
        compcodeMap = new HashMap();
        impossibleReasons = new int[]{2004, 2018, 2019, 2020, 2021, 2022, 2023, 2026, 6125, 2036, 2037, 2038, 2039, 2093, 2094, 2043, 2044, 2062, 2065, 2067, 2075, 2076, 2078, 2090, 2097, 2099, 2134, 2135, 2139, 2141, 2148, 2149, 2154, 2155, 2156, 2158, 2159, 2173, 2186, 2191, 2194, 2219, 2220, 2235, 2236, 2237, 2238, 2239, 2247, 2248, 2253, 2260, 2265, 2277, 2299, 2300, 2301, 2307, 2310, 2312, 2314, 2319, 2320, 2321, 2323, 2327, 2331, 2333, 2334, 2335, 2336, 2337, 2338, 2339, 2356, 2358, 2380, 2383, 2384, 2385, 2386, 2389, 2390, 2392, 2395, 2396, 2414, 2415, 2416, 2420, 2422, 2424, 2426, 2002, 2066, 2257};
        connectionBrokenReasons = new int[]{2009, 2195, 2059, 2273, 2161, 2162, 2279, 2203, 2202, 2223, 2373};
        reasonMap = new HashMap();
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.common.internal.Reason", "static()");
        }
        NLSServices.addCatalogue("com.ibm.msg.client.wmq.common.internal.resources.JMSCMQ_MessageResourceBundle", "JMSCMQ", Reason.class);
        String name = null;
        int idx = 0;
        Field field = null;
        try {
            Field[] fields = CMQC.class.getFields();
            for (idx = 0; idx < fields.length; ++idx) {
                field = fields[idx];
                name = field.getName();
                if (name.startsWith("MQRC_")) {
                    reasonMap.put(new Integer(field.getInt(null)), name);
                    continue;
                }
                if (!name.startsWith("MQCC_")) continue;
                compcodeMap.put(new Integer(field.getInt(null)), name);
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.common.internal.Reason", "static()", e);
            }
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("exception", e);
            info.put("index", new Integer(idx));
            info.put("field", field);
            Trace.ffst("Reason", "getSymbol(int)", "XM001001", info, null);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.common.internal.Reason", "static()");
        }
    }
}

