/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import javax.jms.JMSException;

public class State {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NOT_INITIALIZED = 0;
    public static final int STARTED = 1;
    public static final int STOPPED = 2;
    public static final int CLOSED = 3;
    public static final int DISCONNECTED = 4;
    public int minState = 0;
    public int maxState = 4;
    private int state = 0;

    public State() {
    }

    public State(int initialState) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.State", "<init>(int)", new Object[]{new Integer(initialState)});
        }
        this.state = initialState;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.State", "<init>(int)");
        }
    }

    public int getState() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.State", "getState()", "getter", new Integer(this.state));
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int newState) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.State", "setState(int)", "setter", new Integer(newState));
        }
        int oldState = -1;
        if (newState >= this.minState && newState <= this.maxState) {
            State state = this;
            synchronized (state) {
                oldState = this.state;
                this.state = newState;
            }
        }
    }

    public synchronized boolean close() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.State", "close()");
        }
        if (this.state == 3) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.State", "close()", true, 1);
            }
            return true;
        }
        this.state = 3;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.State", "close()", false, 2);
        }
        return false;
    }

    protected void checkNotClosed(String message) throws JMSException {
        if (this.state == 3) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException(message, null));
            throw je;
        }
    }

    protected boolean isClosed() {
        boolean traceRet1;
        boolean bl = traceRet1 = this.state == 3;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.State", "isClosed()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public synchronized boolean equals(int otherState) {
        boolean traceRet1 = this.state == otherState;
        return traceRet1;
    }

    public synchronized boolean equals(State otherState) {
        boolean traceRet1 = this.state == otherState.state;
        return traceRet1;
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(" ");
        if (0 == this.state) {
            text.append("NOT INITIALIZED");
        } else if (1 == this.state) {
            text.append("STARTED");
        } else if (2 == this.state) {
            text.append("STOPPED");
        } else if (3 == this.state) {
            text.append("CLOSED");
        } else if (4 == this.state) {
            text.append("DISCONNECTED");
        } else {
            text.append("??UNKNOWN??");
        }
        return text.toString();
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.State", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/State.java, jmscc.jms.internal, k701, k701-112-140304  1.24.1.1 09/08/17 07:38:36");
        }
    }
}

