/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsMessageReference;
import com.ibm.msg.client.jms.JmsSession;
import com.ibm.msg.client.jms.JmsXASession;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.jms.internal.JmsXAConnectionImpl;
import com.ibm.msg.client.provider.ProviderXASession;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.transaction.xa.XAResource;

public class JmsXASessionImpl
extends JmsSessionImpl
implements JmsXASession {
    private static final long serialVersionUID = 1373634542979416953L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsXASessionImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.32.1.6 12/12/10 17:51:47";

    protected JmsXASessionImpl(JmsXAConnectionImpl connection) throws JMSException {
        super(true, 0, connection);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "<init>(JmsXAConnectionImpl)", new Object[]{connection});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "<init>(JmsXAConnectionImpl)");
        }
    }

    public Session getSession() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "getSession()");
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "getSession()", (Object)"creating new JmsSession() for use with this XA session");
        }
        JmsSession session = new JmsSession(){

            public Message consume(byte[] flatMR) throws JMSException {
                return JmsXASessionImpl.this.consume(flatMR);
            }

            public void deliver(List mrf) throws JMSException {
                JmsXASessionImpl.this.deliver(mrf);
            }

            public JmsMessageReference recreateMessageReference(byte[] flatMR) throws JMSException {
                return JmsXASessionImpl.this.recreateMessageReference(flatMR);
            }

            public void setBatchProperties(Map properties) throws JMSException {
                JmsXASessionImpl.this.setBatchProperties(properties);
            }

            public void setBooleanProperty(String name, boolean value) throws JMSException {
                JmsXASessionImpl.this.setBooleanProperty(name, value);
            }

            public void setByteProperty(String name, byte value) throws JMSException {
                JmsXASessionImpl.this.setByteProperty(name, value);
            }

            public void setBytesProperty(String name, byte[] value) throws JMSException {
                JmsXASessionImpl.this.setBytesProperty(name, value);
            }

            public void setCharProperty(String name, char value) throws JMSException {
                JmsXASessionImpl.this.setCharProperty(name, value);
            }

            public void setDoubleProperty(String name, double value) throws JMSException {
                JmsXASessionImpl.this.setDoubleProperty(name, value);
            }

            public void setFloatProperty(String name, float value) throws JMSException {
                JmsXASessionImpl.this.setFloatProperty(name, value);
            }

            public void setIntProperty(String name, int value) throws JMSException {
                JmsXASessionImpl.this.setIntProperty(name, value);
            }

            public void setLongProperty(String name, long value) throws JMSException {
                JmsXASessionImpl.this.setLongProperty(name, value);
            }

            public void setObjectProperty(String name, Object value) throws JMSException {
                JmsXASessionImpl.this.setObjectProperty(name, value);
            }

            public void setShortProperty(String name, short value) throws JMSException {
                JmsXASessionImpl.this.setShortProperty(name, value);
            }

            public void setStringProperty(String name, String value) throws JMSException {
                JmsXASessionImpl.this.setStringProperty(name, value);
            }

            public boolean getBooleanProperty(String name) throws JMSException {
                return JmsXASessionImpl.this.getBooleanProperty(name);
            }

            public byte getByteProperty(String name) throws JMSException {
                return JmsXASessionImpl.this.getByteProperty(name);
            }

            public byte[] getBytesProperty(String name) throws JMSException {
                return JmsXASessionImpl.this.getBytesProperty(name);
            }

            public char getCharProperty(String name) throws JMSException {
                return JmsXASessionImpl.this.getCharProperty(name);
            }

            public double getDoubleProperty(String name) throws JMSException {
                return JmsXASessionImpl.this.getDoubleProperty(name);
            }

            public float getFloatProperty(String arg0) throws JMSException {
                return JmsXASessionImpl.this.getFloatProperty(arg0);
            }

            public int getIntProperty(String name) throws JMSException {
                return JmsXASessionImpl.this.getIntProperty(name);
            }

            public long getLongProperty(String name) throws JMSException {
                return JmsXASessionImpl.this.getLongProperty(name);
            }

            public Object getObjectProperty(String name) throws JMSException {
                return JmsXASessionImpl.this.getObjectProperty(name);
            }

            public Enumeration getPropertyNames() throws JMSException {
                return JmsXASessionImpl.this.getPropertyNames();
            }

            public short getShortProperty(String name) throws JMSException {
                return JmsXASessionImpl.this.getShortProperty(name);
            }

            public String getStringProperty(String name) throws JMSException {
                return JmsXASessionImpl.this.getStringProperty(name);
            }

            public boolean propertyExists(String name) throws JMSException {
                return JmsXASessionImpl.this.propertyExists(name);
            }

            public void clear() {
                JmsXASessionImpl.this.clear();
            }

            public boolean containsKey(Object key) {
                return JmsXASessionImpl.this.containsKey(key);
            }

            public boolean containsValue(Object value) {
                return JmsXASessionImpl.this.containsValue(value);
            }

            public Set entrySet() {
                return JmsXASessionImpl.this.entrySet();
            }

            public Object get(Object key) {
                return JmsXASessionImpl.this.get(key);
            }

            public boolean isEmpty() {
                return JmsXASessionImpl.this.isEmpty();
            }

            public Set keySet() {
                return JmsXASessionImpl.this.keySet();
            }

            public Object put(Object key, Object value) {
                return JmsXASessionImpl.this.put(key, value);
            }

            public void putAll(Map t) {
                JmsXASessionImpl.this.putAll(t);
            }

            public Object remove(Object key) {
                return JmsXASessionImpl.this.remove(key);
            }

            public int size() {
                return JmsXASessionImpl.this.size();
            }

            public Collection values() {
                return JmsXASessionImpl.this.values();
            }

            public void close() throws JMSException {
                JmsXASessionImpl.this.close();
            }

            public void commit() throws JMSException {
                JmsXASessionImpl.this.commit();
            }

            public QueueBrowser createBrowser(Queue queue) throws JMSException {
                return JmsXASessionImpl.this.createBrowser(queue);
            }

            public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
                return JmsXASessionImpl.this.createBrowser(queue, selector);
            }

            public BytesMessage createBytesMessage() throws JMSException {
                return JmsXASessionImpl.this.createBytesMessage();
            }

            public MessageConsumer createConsumer(Destination dest) throws JMSException {
                return JmsXASessionImpl.this.createConsumer(dest);
            }

            public MessageConsumer createConsumer(Destination dest, String selector) throws JMSException {
                return JmsXASessionImpl.this.createConsumer(dest, selector);
            }

            public MessageConsumer createConsumer(Destination dest, String selector, boolean noLocal) throws JMSException {
                return JmsXASessionImpl.this.createConsumer(dest, selector, noLocal);
            }

            public TopicSubscriber createDurableSubscriber(Topic topic, String subscriptionName) throws JMSException {
                return JmsXASessionImpl.this.createDurableSubscriber(topic, subscriptionName);
            }

            public TopicSubscriber createDurableSubscriber(Topic topic, String subscriptionName, String selector, boolean noLocal) throws JMSException {
                return JmsXASessionImpl.this.createDurableSubscriber(topic, subscriptionName, selector, noLocal);
            }

            public MapMessage createMapMessage() throws JMSException {
                return JmsXASessionImpl.this.createMapMessage();
            }

            public Message createMessage() throws JMSException {
                return JmsXASessionImpl.this.createMessage();
            }

            public ObjectMessage createObjectMessage() throws JMSException {
                return JmsXASessionImpl.this.createObjectMessage();
            }

            public ObjectMessage createObjectMessage(Serializable arg0) throws JMSException {
                return JmsXASessionImpl.this.createObjectMessage(arg0);
            }

            public MessageProducer createProducer(Destination dest) throws JMSException {
                return JmsXASessionImpl.this.createProducer(dest);
            }

            public Queue createQueue(String name) throws JMSException {
                return JmsXASessionImpl.this.createQueue(name);
            }

            public StreamMessage createStreamMessage() throws JMSException {
                return JmsXASessionImpl.this.createStreamMessage();
            }

            public TemporaryQueue createTemporaryQueue() throws JMSException {
                return JmsXASessionImpl.this.createTemporaryQueue();
            }

            public TemporaryTopic createTemporaryTopic() throws JMSException {
                return JmsXASessionImpl.this.createTemporaryTopic();
            }

            public TextMessage createTextMessage() throws JMSException {
                return JmsXASessionImpl.this.createTextMessage();
            }

            public TextMessage createTextMessage(String text) throws JMSException {
                return JmsXASessionImpl.this.createTextMessage(text);
            }

            public Topic createTopic(String name) throws JMSException {
                return JmsXASessionImpl.this.createTopic(name);
            }

            public int getAcknowledgeMode() throws JMSException {
                return JmsXASessionImpl.this.getAcknowledgeMode();
            }

            public MessageListener getMessageListener() throws JMSException {
                return JmsXASessionImpl.this.getMessageListener();
            }

            public boolean getTransacted() throws JMSException {
                return JmsXASessionImpl.this.getTransacted();
            }

            public void recover() throws JMSException {
                JmsXASessionImpl.this.recover();
            }

            public void rollback() throws JMSException {
                JmsXASessionImpl.this.rollback();
            }

            public void run() {
                JmsXASessionImpl.this.run();
            }

            public void setMessageListener(MessageListener listener) throws JMSException {
                JmsXASessionImpl.this.setMessageListener(listener);
            }

            public void unsubscribe(String subscriptionName) throws JMSException {
                JmsXASessionImpl.this.unsubscribe(subscriptionName);
            }
        };
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "getSession()", session);
        }
        return session;
    }

    public XAResource getXAResource() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "getXAResource()");
        }
        try {
            this.checkNotClosed();
            XAResource xar = this.getProviderXASession().getXAResource();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "getXAResource()", xar);
            }
            return xar;
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "getXAResource()", e);
            }
            HashMap<String, JMSException> inserts = new HashMap<String, JMSException>();
            inserts.put("XMSC_INSERT_EXCEPTION", e);
            RuntimeException re = (RuntimeException)JmsErrorUtils.createException("JMSCC0106", inserts);
            re.initCause(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "getXAResource()", re);
            }
            throw re;
        }
    }

    protected ProviderXASession getProviderXASession() {
        ProviderXASession pxs = (ProviderXASession)this.getProviderSession();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "getProviderXASession()", "getter", pxs);
        }
        return pxs;
    }

    public void commit() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "commit()");
        }
        JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1069", null));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "commit()", je);
        }
        throw je;
    }

    public void rollback() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "rollback()");
        }
        JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1069", null));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "rollback()", je);
        }
        throw je;
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "close()");
        }
        super.close();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "close()");
        }
    }

    public void close(boolean closingFromConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "close(boolean)", new Object[]{closingFromConnection});
        }
        super.close(closingFromConnection);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsXASessionImpl", "close(boolean)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsXASessionImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsXASessionImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.32.1.6 12/12/10 17:51:47");
        }
    }
}

