/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsXAConnection;
import com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl;
import com.ibm.msg.client.jms.internal.JmsConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsXASessionImpl;
import com.ibm.msg.client.jms.internal.State;
import com.ibm.msg.client.provider.ProviderXAConnection;
import com.ibm.msg.client.provider.ProviderXASession;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.XASession;

public class JmsXAConnectionImpl
extends JmsConnectionImpl
implements JmsXAConnection {
    private static final String enableMaxMessagesForXAListenerPortsProperty = "com.ibm.mq.jms.tuning.enableMaxMessagesForXAListenerPorts";
    private static final long serialVersionUID = 7671947122063053105L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public JmsXAConnectionImpl(JmsConnectionFactoryImpl connectionFactory) throws JMSException {
        super(connectionFactory);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "<init>(JmsConnectionFactoryImpl)", new Object[]{connectionFactory});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "<init>(JmsConnectionFactoryImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XASession createXASession() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "createXASession()");
        }
        this.state.checkNotClosed("JMSCC0008");
        this.fixClientID();
        JmsXASessionImpl xaSession = this.instantiateXASession();
        ProviderXASession providerSession = this.getProviderXAConnection().createXASession(xaSession);
        xaSession.setProviderSession(providerSession);
        State state = this.state;
        synchronized (state) {
            if (this.state.equals(1)) {
                xaSession.start();
            }
            this.sessions.add(xaSession);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "createXASession()", xaSession);
        }
        return xaSession;
    }

    protected JmsXASessionImpl instantiateXASession() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "instantiateXASession()");
        }
        JmsXASessionImpl xaSession = new JmsXASessionImpl(this);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "instantiateXASession()", xaSession);
        }
        return xaSession;
    }

    public ProviderXAConnection getProviderXAConnection() {
        ProviderXAConnection pxc = (ProviderXAConnection)this.getProviderConnection();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "getProviderXAConnection()", "getter", pxc);
        }
        return pxc;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", new Object[]{destination, messageSelector, sessionPool, new Integer(maxMessages)});
        }
        ConnectionConsumer cc = null;
        boolean enableMaxMessagesForXAListenerPorts = PropertyStore.getBooleanPropertyObject(enableMaxMessagesForXAListenerPortsProperty);
        if (enableMaxMessagesForXAListenerPorts) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", (Object)("Property com.ibm.mq.jms.tuning.enableMaxMessagesForXAListenerPorts has been set to true, setting Maximum Messages to " + maxMessages));
            }
            cc = super.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
        } else {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", (Object)"Property com.ibm.mq.jms.tuning.enableMaxMessagesForXAListenerPorts has either been set to false or is unset, so setting Maximum Messages to 1");
            }
            cc = super.createConnectionConsumer(destination, messageSelector, sessionPool, 1);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", cc);
        }
        return cc;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic destination, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", new Object[]{destination, subscriptionName, messageSelector, sessionPool, new Integer(maxMessages)});
        }
        ConnectionConsumer cc = super.createDurableConnectionConsumer(destination, subscriptionName, messageSelector, sessionPool, 1);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", cc);
        }
        return cc;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsXAConnectionImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsXAConnectionImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.29.1.3 12/10/24 16:45:40");
        }
        PropertyStore.register(enableMaxMessagesForXAListenerPortsProperty, false);
    }
}

