/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsTopicSubscriber;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Topic;

public class JmsTopicSubscriberImpl
extends JmsMessageConsumerImpl
implements JmsTopicSubscriber {
    private static final long serialVersionUID = 1389150200802673064L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsTopicSubscriberImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.22.1.1 09/08/17 07:37:17";
    private String subscriptionName;
    private Topic topic;

    JmsTopicSubscriberImpl(JmsSessionImpl session, Topic topic, String selector, boolean noLocal) throws JMSException {
        this(session, topic, selector, noLocal, null);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTopicSubscriberImpl", "<init>(JmsSessionImpl,Topic,String,boolean)", new Object[]{session, topic, selector, noLocal});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTopicSubscriberImpl", "<init>(JmsSessionImpl,Topic,String,boolean)");
        }
    }

    JmsTopicSubscriberImpl(JmsSessionImpl session, Topic topic, String selector, boolean noLocal, String subscriptionName) throws JMSException {
        super(session, (Destination)topic, selector, noLocal);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTopicSubscriberImpl", "<init>(JmsSessionImpl,Topic,String,boolean,String)", new Object[]{session, topic, selector, noLocal, subscriptionName});
        }
        this.subscriptionName = subscriptionName;
        this.topic = topic;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTopicSubscriberImpl", "<init>(JmsSessionImpl,Topic,String,boolean,String)");
        }
    }

    public boolean getNoLocal() throws JMSException {
        this.state.checkNotClosed("JMSCC0032");
        boolean traceRet1 = this.getBooleanProperty("XMSC_NOLOCAL");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsTopicSubscriberImpl", "getNoLocal()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Topic getTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTopicSubscriberImpl", "getTopic()");
        }
        this.state.checkNotClosed("JMSCC0032");
        if (this.closed) {
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0026", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsTopicSubscriberImpl", "getTopic()", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsTopicSubscriberImpl", "getTopic()", this.topic);
        }
        return this.topic;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsTopicSubscriberImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsTopicSubscriberImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.22.1.1 09/08/17 07:37:17");
        }
    }
}

