/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsTopicPublisher;
import com.ibm.msg.client.jms.internal.JmsMessageProducerImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;

public class JmsTopicPublisherImpl
extends JmsMessageProducerImpl
implements JmsTopicPublisher {
    private static final long serialVersionUID = 3558935369273881843L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsTopicPublisherImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.20.1.1 09/08/17 07:36:58";
    Topic topic;

    JmsTopicPublisherImpl(Topic topic, JmsSessionImpl session) throws JMSException {
        super((Destination)topic, session);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "<init>(Topic,JmsSessionImpl)", new Object[]{topic, session});
        }
        this.topic = topic;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "<init>(Topic,JmsSessionImpl)");
        }
    }

    public Topic getTopic() throws JMSException {
        this.state.checkNotClosed("JMSCC0026");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "getTopic()", "getter", this.topic);
        }
        return this.topic;
    }

    public void publish(Message message, int deliveryMode, int priority, long expiry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "publish(Message,int,int,long)", new Object[]{message, new Integer(deliveryMode), new Integer(priority), new Long(expiry)});
        }
        this.send(message, deliveryMode, priority, expiry);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "publish(Message,int,int,long)");
        }
    }

    public void publish(Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "publish(Message)", new Object[]{message});
        }
        this.send(message);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "publish(Message)");
        }
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long expiry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "publish(Topic,Message,int,int,long)", new Object[]{topic, message, new Integer(deliveryMode), new Integer(priority), new Long(expiry)});
        }
        this.send((Destination)topic, message, deliveryMode, priority, expiry);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "publish(Topic,Message,int,int,long)");
        }
    }

    public void publish(Topic topic, Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "publish(Topic,Message)", new Object[]{topic, message});
        }
        this.send((Destination)topic, message);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "publish(Topic,Message)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsTopicPublisherImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.20.1.1 09/08/17 07:36:58");
        }
    }
}

