/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderTextMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class JmsTextMessageImpl
extends JmsMessageImpl
implements TextMessage {
    private static final long serialVersionUID = 4900836031892307240L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsTextMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.27.1.1 09/08/17 07:36:33";
    private ProviderTextMessage providerTextMessage;

    public JmsTextMessageImpl(JmsSessionImpl session) throws JMSException {
        super(session);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "<init>(JmsSessionImpl)", new Object[]{session});
        }
        this.messageType = "jms_text";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "<init>(JmsSessionImpl)");
        }
    }

    public JmsTextMessageImpl(String connectionType) throws JMSException {
        super(connectionType);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "<init>(String)", new Object[]{connectionType});
        }
        this.messageType = "jms_text";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "<init>(String)");
        }
    }

    JmsTextMessageImpl(ProviderTextMessage newMsg, JmsSessionImpl newSess, String connectionTypeName) throws JMSException {
        super(newMsg, newSess, connectionTypeName);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "<init>(ProviderTextMessage,JmsSessionImpl,String)", new Object[]{newMsg, newSess, connectionTypeName});
        }
        this.providerTextMessage = newMsg;
        this.messageType = "jms_text";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "<init>(ProviderTextMessage,JmsSessionImpl,String)");
        }
    }

    JmsTextMessageImpl(JmsSessionImpl session, TextMessage textMessage) throws JMSException {
        super(session, (Message)textMessage);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "<init>(JmsSessionImpl,TextMessage)", new Object[]{session, textMessage});
        }
        this.setText(textMessage.getText());
        this.messageType = "jms_text";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "<init>(JmsSessionImpl,TextMessage)");
        }
    }

    public void setText(String txt) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "setText(String)", "setter", txt);
        }
        this.checkBodyWriteable("setText");
        this.providerTextMessage.setText(txt);
    }

    public String getText() throws JMSException {
        String txt = this.providerTextMessage.getText();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "getText()", "getter", txt);
        }
        return txt;
    }

    public String toString() {
        String val = super.toString();
        try {
            String thisText = this.getText();
            if (thisText == null) {
                thisText = "<null>";
            } else if (thisText.length() > 100) {
                thisText = thisText.substring(0, 100) + " ...";
            }
            val = val + "\n" + thisText;
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return val;
    }

    protected ProviderMessage createProviderMessage(JmsSessionImpl session) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "createProviderMessage(JmsSessionImpl)", new Object[]{session});
        }
        this.providerTextMessage = session != null ? this.providerMessageFactory.createTextMessage(session.getProviderSession()) : this.providerMessageFactory.createTextMessage(null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "createProviderMessage(JmsSessionImpl)", this.providerTextMessage);
        }
        return this.providerTextMessage;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsTextMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsTextMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.27.1.1 09/08/17 07:36:33");
        }
    }
}

