/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConnection;
import com.ibm.msg.client.jms.JmsTemporaryQueue;
import com.ibm.msg.client.jms.admin.JmsDestinationImpl;
import com.ibm.msg.client.jms.internal.JmsConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderSession;
import java.util.HashMap;
import javax.jms.JMSException;

public class JmsTemporaryQueueImpl
extends JmsDestinationImpl
implements JmsTemporaryQueue {
    private static final long serialVersionUID = -7727347894280057274L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsTemporaryQueueImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.32.1.2 09/10/16 10:09:10";
    private JmsConnection connection;
    private boolean deleted = false;

    protected JmsTemporaryQueueImpl(JmsConnection connection, ProviderSession providerSession) throws JMSException {
        super(providerSession.getStringProperty("XMSC_CONNECTION_TYPE_NAME"), null);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "<init>(JmsConnection,ProviderSession)", new Object[]{connection, providerSession});
        }
        try {
            this.setLongProperty("OBJECT_IDENTITY", System.identityHashCode(this));
        }
        catch (JMSException e) {
            // empty catch block
        }
        this.connection = connection;
        ProviderDestination providerDest = providerSession.createTemporaryDestination(1, this);
        this.setProviderDestination(providerDest);
        this.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)0);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "<init>(JmsConnection,ProviderSession)");
        }
    }

    public void delete() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "delete()");
        }
        if (!this.deleted) {
            if (this.getUseCount() > 0) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_DESTINATION_NAME", this.getName());
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3002", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "delete()", je);
                }
                throw je;
            }
            ((JmsConnectionImpl)this.connection).removeTemporaryDestination(this);
            ProviderDestination providerDest = this.getProviderDestination();
            if (providerDest != null) {
                providerDest.delete();
            }
            this.deleted = true;
        } else {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_DESTINATION_NAME", this.toString());
            JMSException jMSException = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3019", inserts));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "delete()");
        }
    }

    public String getQueueName() throws JMSException {
        String traceRet1 = this.getName();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "getQueueName()", "getter", traceRet1);
        }
        return traceRet1;
    }

    protected JmsConnection getConnection() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "getConnection()", "getter", this.connection);
        }
        return this.connection;
    }

    public boolean isDeleted() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "isDeleted()", "getter", this.deleted);
        }
        return this.deleted;
    }

    protected void initialise(String connectionTypeName1, String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "initialise(String,String)", new Object[]{connectionTypeName1, name});
        }
        this.setDefaultProperties();
        if (connectionTypeName1 != null) {
            this.setConnectionTypeName(connectionTypeName1);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "initialise(String,String)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsTemporaryQueueImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.32.1.2 09/10/16 10:09:10");
        }
    }
}

