/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderStreamMessage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.StreamMessage;

public class JmsStreamMessageImpl
extends JmsMessageImpl
implements StreamMessage {
    private static final long serialVersionUID = 4101671711366200546L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsStreamMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.32.1.1 09/08/17 07:36:05";
    private ProviderStreamMessage providerStreamMessage;
    private boolean partReadBytesElement;
    private byte[] bytesElement;
    private int bytesElementOffset;
    private static final int MAX_ELEMENTS_IN_TO_STRING = 32;

    public JmsStreamMessageImpl(JmsSessionImpl session) throws JMSException {
        super(session);
        this.partReadBytesElement = false;
        this.bytesElement = null;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "<init>(JmsSessionImpl)", new Object[]{session});
        }
        this.messageType = "jms_stream";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "<init>(JmsSessionImpl)");
        }
    }

    public JmsStreamMessageImpl(String connectionType) throws JMSException {
        super(connectionType);
        this.partReadBytesElement = false;
        this.bytesElement = null;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "<init>(String)", new Object[]{connectionType});
        }
        this.messageType = "jms_stream";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "<init>(String)");
        }
    }

    JmsStreamMessageImpl(ProviderStreamMessage newMsg, JmsSessionImpl newSess, String connectionTypeName) throws JMSException {
        block4: {
            super(newMsg, newSess, connectionTypeName);
            this.partReadBytesElement = false;
            this.bytesElement = null;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "<init>(ProviderStreamMessage,JmsSessionImpl,String)", new Object[]{newMsg, newSess, connectionTypeName});
            }
            this.providerStreamMessage = newMsg;
            this.messageType = "jms_stream";
            try {
                this.providerStreamMessage.reset();
            }
            catch (JMSException e) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "<init>(ProviderStreamMessage,JmsSessionImpl,String)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "<init>(ProviderStreamMessage,JmsSessionImpl,String)");
        }
    }

    JmsStreamMessageImpl(JmsSessionImpl session, StreamMessage streamMessage) throws JMSException {
        super(session, (Message)streamMessage);
        this.partReadBytesElement = false;
        this.bytesElement = null;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "<init>(JmsSessionImpl,StreamMessage)", new Object[]{session, streamMessage});
        }
        this.messageType = "jms_stream";
        streamMessage.reset();
        try {
            while (true) {
                this.writeObject(streamMessage.readObject());
            }
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "<init>(JmsSessionImpl,StreamMessage)", e);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "<init>(JmsSessionImpl,StreamMessage)");
            }
            return;
        }
    }

    public boolean readBoolean() throws JMSException {
        boolean result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBoolean()");
        }
        Object nextObj = this.getNextField("readBoolean");
        try {
            result = JmsPropertyContextImpl.parseBoolean(nextObj, "", MessageFormatException.class);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBoolean()", e, 1);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBoolean()", e, 1);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBoolean()", e, 2);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBoolean()", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBoolean()", result);
        }
        return result;
    }

    public byte readByte() throws JMSException {
        byte result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readByte()");
        }
        Object nextObj = this.getNextField("readByte");
        try {
            result = JmsPropertyContextImpl.parseByte(nextObj, "", MessageFormatException.class);
        }
        catch (RuntimeException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readByte()", e, 1);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readByte()", e, 1);
            }
            throw e;
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readByte()", e, 2);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readByte()", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readByte()", new Byte(result));
        }
        return result;
    }

    public short readShort() throws JMSException {
        short result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readShort()");
        }
        Object nextObj = this.getNextField("readShort");
        try {
            result = JmsPropertyContextImpl.parseShort(nextObj, "", MessageFormatException.class);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readShort()", e, 1);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readShort()", e, 1);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readShort()", e, 2);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readShort()", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readShort()", new Short(result));
        }
        return result;
    }

    public char readChar() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readChar()");
        }
        char result = '\u0000';
        Object nextObj = this.getNextField("readChar");
        if (nextObj == null) {
            NullPointerException npe = (NullPointerException)JmsErrorUtils.createException("JMSCC0062", null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readChar()", npe);
            }
            throw npe;
        }
        if (nextObj instanceof Character) {
            result = ((Character)nextObj).charValue();
        } else {
            this.providerStreamMessage.stepBack();
            JmsStreamMessageImpl.throwBadConvertException(nextObj, "", "Character", MessageFormatException.class);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readChar()", new Character(result));
        }
        return result;
    }

    public int readInt() throws JMSException {
        int result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readInt()");
        }
        Object nextObj = this.getNextField("readInt");
        try {
            result = JmsPropertyContextImpl.parseInt(nextObj, "", MessageFormatException.class);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readInt()", e, 1);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readInt()", e, 1);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readInt()", e, 2);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readInt()", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readInt()", new Integer(result));
        }
        return result;
    }

    public long readLong() throws JMSException {
        long result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readLong()");
        }
        Object nextObj = this.getNextField("readLong");
        try {
            result = JmsPropertyContextImpl.parseLong(nextObj, "", MessageFormatException.class);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readLong()", e, 1);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readLong()", e, 1);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readLong()", e, 2);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readLong()", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readLong()", new Long(result));
        }
        return result;
    }

    public float readFloat() throws JMSException {
        float result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readFloat()");
        }
        Object nextObj = this.getNextField("readFloat");
        try {
            result = JmsPropertyContextImpl.parseFloat(nextObj, "", MessageFormatException.class);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readFloat()", e, 1);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readFloat()", e, 1);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readFloat()", e, 2);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readFloat()", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readFloat()", new Float(result));
        }
        return result;
    }

    public double readDouble() throws JMSException {
        double result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readDouble()");
        }
        Object nextObj = this.getNextField("readDouble");
        try {
            result = JmsPropertyContextImpl.parseDouble(nextObj, "", MessageFormatException.class);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readDouble()", e, 1);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readDouble()", e, 1);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readDouble()", e, 2);
            }
            this.providerStreamMessage.stepBack();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readDouble()", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readDouble()", new Double(result));
        }
        return result;
    }

    public String readString() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readString()");
        }
        Object obj = this.getNextField("readString");
        String value = null;
        if (obj instanceof String || obj == null) {
            value = (String)obj;
        } else if (obj instanceof byte[]) {
            this.providerStreamMessage.stepBack();
            JmsStreamMessageImpl.throwBadConvertException(obj, "", "String", MessageFormatException.class);
        } else {
            value = obj.toString();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readString()", value);
        }
        return value;
    }

    public int readBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBytes(byte [ ])", new Object[]{value});
        }
        this.checkBodyReadable("readBytes");
        if (!this.partReadBytesElement) {
            Object obj = this.getNextField("readBytes");
            if (obj == null) {
                int traceRet1 = -1;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBytes(byte [ ])", new Integer(traceRet1), 1);
                }
                return traceRet1;
            }
            if (obj instanceof byte[]) {
                this.bytesElement = (byte[])obj;
                this.bytesElementOffset = 0;
                if (this.bytesElement.length == 0) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBytes(byte [ ])", new Integer(0), 2);
                    }
                    return 0;
                }
            } else {
                this.providerStreamMessage.stepBack();
                JmsStreamMessageImpl.throwBadConvertException(obj, "", "byte[]", MessageFormatException.class);
            }
        }
        if (value == null) {
            NullPointerException npe = (NullPointerException)JmsErrorUtils.createException("JMSCC0059", null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBytes(byte [ ])", npe);
            }
            throw npe;
        }
        int nBytesLeft = this.bytesElement.length - this.bytesElementOffset;
        int nBytes = nBytesLeft > value.length ? value.length : nBytesLeft;
        this.partReadBytesElement = nBytes == value.length;
        if (nBytes == 0) {
            int traceRet3 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBytes(byte [ ])", new Integer(traceRet3), 3);
            }
            return traceRet3;
        }
        System.arraycopy(this.bytesElement, this.bytesElementOffset, value, 0, nBytes);
        this.bytesElementOffset += nBytes;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readBytes(byte [ ])", new Integer(nBytes), 4);
        }
        return nBytes;
    }

    public Object readObject() throws JMSException {
        Object result;
        Object obj;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readObject()");
        }
        if ((obj = this.getNextField("readObject")) instanceof byte[]) {
            int len = ((byte[])obj).length;
            result = new byte[len];
            System.arraycopy(obj, 0, result, 0, len);
        } else {
            result = obj;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "readObject()", result);
        }
        return result;
    }

    public void writeBoolean(boolean x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeBoolean(boolean)", new Object[]{x});
        }
        this.checkBodyWriteable("writeBoolean");
        this.providerStreamMessage.writeBoolean(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeBoolean(boolean)");
        }
    }

    public void writeByte(byte x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeByte(byte)", new Object[]{new Byte(x)});
        }
        this.checkBodyWriteable("writeByte");
        this.providerStreamMessage.writeByte(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeByte(byte)");
        }
    }

    public void writeShort(short x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeShort(short)", new Object[]{new Short(x)});
        }
        this.checkBodyWriteable("writeShort");
        this.providerStreamMessage.writeShort(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeShort(short)");
        }
    }

    public void writeChar(char x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeChar(char)", new Object[]{new Character(x)});
        }
        this.checkBodyWriteable("writeChar");
        this.providerStreamMessage.writeChar(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeChar(char)");
        }
    }

    public void writeInt(int x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeInt(int)", new Object[]{new Integer(x)});
        }
        this.checkBodyWriteable("writeInt");
        this.providerStreamMessage.writeInt(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeInt(int)");
        }
    }

    public void writeLong(long x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeLong(long)", new Object[]{new Long(x)});
        }
        this.checkBodyWriteable("writeLong");
        this.providerStreamMessage.writeLong(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeLong(long)");
        }
    }

    public void writeFloat(float x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeFloat(float)", new Object[]{new Float(x)});
        }
        this.checkBodyWriteable("writeFloat");
        this.providerStreamMessage.writeFloat(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeFloat(float)");
        }
    }

    public void writeDouble(double x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeDouble(double)", new Object[]{new Double(x)});
        }
        this.checkBodyWriteable("writeDouble");
        this.providerStreamMessage.writeDouble(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeDouble(double)");
        }
    }

    public void writeString(String x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeString(String)", new Object[]{x});
        }
        this.checkBodyWriteable("writeString");
        this.providerStreamMessage.writeString(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeString(String)");
        }
    }

    public void writeBytes(byte[] x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeBytes(byte [ ])", new Object[]{x});
        }
        this.checkBodyWriteable("writeBytes");
        if (x != null) {
            byte[] c = new byte[x.length];
            System.arraycopy(x, 0, c, 0, x.length);
            x = c;
        }
        this.providerStreamMessage.writeBytes(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeBytes(byte [ ])");
        }
    }

    public void writeBytes(byte[] x, int offset, int len) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeBytes(byte [ ],int,int)", new Object[]{x, new Integer(offset), new Integer(len)});
        }
        this.checkBodyWriteable("writeBytes");
        byte[] subA = new byte[len];
        System.arraycopy(x, offset, subA, 0, len);
        this.providerStreamMessage.writeBytes(subA);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeBytes(byte [ ],int,int)");
        }
    }

    public void writeObject(Object x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeObject(Object)", new Object[]{x});
        }
        this.checkBodyWriteable("writeObject");
        if (!(x == null || x instanceof String || x instanceof Number || x instanceof Boolean || x instanceof Character || x instanceof byte[])) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_OBJECT", x.getClass().getName());
            JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0083", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeObject(Object)", je2);
            }
            throw je2;
        }
        if (x instanceof byte[]) {
            byte[] v = (byte[])x;
            byte[] tmp = new byte[v.length];
            System.arraycopy(v, 0, tmp, 0, v.length);
            x = tmp;
        }
        this.providerStreamMessage.writeObject(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "writeObject(Object)");
        }
    }

    public void reset() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "reset()");
        }
        this.setBodyReadOnly();
        this.providerStreamMessage.reset();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "reset()");
        }
    }

    protected ProviderMessage createProviderMessage(JmsSessionImpl session) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "createProviderMessage(JmsSessionImpl)", new Object[]{session});
        }
        this.providerStreamMessage = session != null ? this.providerMessageFactory.createStreamMessage(session.getProviderSession()) : this.providerMessageFactory.createStreamMessage(null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "createProviderMessage(JmsSessionImpl)", this.providerStreamMessage);
        }
        return this.providerStreamMessage;
    }

    public int hashCode() {
        if (this.providerStreamMessage == null) {
            return 0;
        }
        int traceRet1 = this.providerStreamMessage.hashCode();
        return traceRet1;
    }

    public Object getNextField(String callingMethodName) throws MessageEOFException, MessageNotReadableException, MessageFormatException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "getNextField(String)", new Object[]{callingMethodName});
        }
        this.checkBodyReadable(callingMethodName);
        if (this.partReadBytesElement) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0061", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "getNextField(String)", je, 1);
            }
            throw je;
        }
        Object nextObj = null;
        nextObj = this.providerStreamMessage.readObject();
        if (!(nextObj != null || "readBytes".equals(callingMethodName) || "readString".equals(callingMethodName) || "readChar".equals(callingMethodName) || "readObject".equals(callingMethodName))) {
            JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0060", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "getNextField(String)", je2, 2);
            }
            throw je2;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "getNextField(String)", nextObj);
        }
        return nextObj;
    }

    public String toString() {
        String val = super.toString();
        StringBuffer sb = new StringBuffer("\n");
        try {
            ArrayList streamData = this.providerStreamMessage.getStreamData();
            if (streamData != null) {
                int size = streamData.size();
                int unfoldSize = size <= 32 ? size : 32;
                for (int i = 0; i < unfoldSize; ++i) {
                    Object value = streamData.get(i);
                    if (value == null) {
                        value = "<null>";
                    }
                    sb.append(value);
                    sb.append("\n");
                }
                if (size > 32) {
                    sb.append("...\n");
                }
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        val = val + sb.toString();
        return val;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsStreamMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsStreamMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.32.1.1 09/08/17 07:36:05");
        }
    }
}

